/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.utils.DBObject;

public class PlSqlReferencesViewer
extends TTTableViewer {
    private MyTableModel _model;
    protected static Logger _logger = Logger.getLogger(PlSqlReferencesViewer.class.getPackage().getName());

    @Override
    protected String GetPurposeTxt() {
        return "Listing of PL/SQL objects that refers to this object";
    }

    @Override
    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new MyTableModel(this._dbObject);
            this._table.setModel(this._model);
        } else {
            this._model.init();
        }
        this._model.fireTableDataChanged();
    }

    private class MyTableModel
    extends AbstractTableModel {
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        private String[] theColumnNames = new String[]{"OBJECT ID", "OWNER", "OBJECT TYPE", "OBJECT NAME", "STATUS"};
        List<Integer> theReferenceObjects = new ArrayList<Integer>(32);

        private MyTableModel(DBObject dBObject) throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "PL/SQL References, getting dependents failed " + sQLException.toString());
                throw sQLException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getReferences(String string) throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                Connection connection = PlSqlReferencesViewer.this._dbObject.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT distinct object_id, referenced_object_id FROM public_dependency where referenced_object_id = " + string);
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    if (this.theReferenceObjects.contains(n)) continue;
                    this.theReferenceObjects.add(n);
                    this.getReferences(Integer.toString(n));
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Getting dependents failed", sQLException);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }

        private void init() throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string = PlSqlReferencesViewer.this._dbObject.getObjectId();
                this.theRows.clear();
                this.theReferenceObjects.clear();
                this.getReferences(string);
                Collections.sort(this.theReferenceObjects);
                Connection connection = PlSqlReferencesViewer.this._dbObject.getConnection();
                statement = connection.createStatement();
                for (int n : this.theReferenceObjects) {
                    resultSet = statement.executeQuery("SELECT OBJECT_ID, owner, object_type, object_name, status from sys.all_objects  where OBJECT_ID = " + n + " and owner NOT IN ('SYS', 'SYSTEM', 'PUBLIC') and object_name <> 'DUAL'");
                    int n2 = 0;
                    while (resultSet.next()) {
                        Object[] objectArray = new Object[this.theColumnNames.length];
                        for (int i = 1; i <= this.theColumnNames.length; ++i) {
                            objectArray[i - 1] = resultSet.getString(i);
                        }
                        this.theRows.add(objectArray);
                        ++n2;
                    }
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "PL/SQL References, getting dependents failed " + sQLException.toString(), sQLException);
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }

        @Override
        public final int getColumnCount() {
            return this.theColumnNames.length;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > this.theColumnNames.length) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public final String getColumnName(int n) {
            return this.theColumnNames[n];
        }
    }
}

