/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TT2ColGridBagConstraints;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.AnalysisParam;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Analyzer;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.ClosableEscMenuItem;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.ComponentEnabler;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Constraint;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.IndexInfo;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadOptions;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadSchema;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTablesTable;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoaderPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.OracleTableLoader;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.SchemaProvider;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.SchemaTreeNode;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.TableRefresher;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageModule;

public class LoadSelectedTraversablePanel
extends DefaultTraversablePanel
implements ActionListener,
LoaderPanel,
TableRefresher,
ComponentEnabler {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(LoadSelectedTraversablePanel.class.getPackage().getName());
    private DBObject _dbObject;
    private JPanel _leftPanel;
    private JPanel _buttonPanel;
    private JScrollPane _scrollTree;
    private SchemaTreePanel _tree;
    private LoadPanel _loadPanel;
    private JSplitPane _splitPane;
    private JButton _plusButton;
    private JButton _lessButton;
    private List<Object> _allSchemas;
    private List<Object> _openedSchemas;
    private SchemaTreeNode _treeRoot;
    private SchemaTreeNode _currentSchemaNode;
    private SchemasTreeModel _treeModel;
    private LoadTablesTable _loadTable;
    private TimesTenPassthrough _passthrough;
    private SchemaProvider provider;
    private boolean initialized;
    private boolean advancedMapping;
    private Analyzer analyzer;
    private LoadOptions loadOptions;
    private TraversableContext dataContext;

    public TraversableContext getDataContext() {
        return this.dataContext;
    }

    private void init(DBObject dBObject) {
        this.setLayout(new BorderLayout());
        this._dbObject = dBObject;
        this._passthrough = new TimesTenPassthrough(this._dbObject);
        this.provider = new LoadSchema(this._dbObject);
        this._treeRoot = new SchemaTreeNode(Messages.getString("LoadTablesFromOracle.schemas"), 1, null);
        this._currentSchemaNode = new SchemaTreeNode(this._dbObject.getSchemaName(), 2, null);
        this._treeRoot.add(this._currentSchemaNode);
        this._allSchemas = new LinkedList<Object>();
        this._openedSchemas = new LinkedList<Object>();
        this._plusButton = new JButton("+");
        this._lessButton = new JButton("-");
        this._buttonPanel = new JPanel(new FlowLayout(1));
        this._buttonPanel.add(this._plusButton);
        this._buttonPanel.add(this._lessButton);
        this._leftPanel = new JPanel(new BorderLayout());
        this._loadTable = new LoadTablesTable(this, this._dbObject);
        this._loadPanel = new LoadPanel(this._loadTable, false);
        this._splitPane = new JSplitPane(1);
        this._leftPanel.add((Component)this._buttonPanel, "North");
        this._treeModel = new SchemasTreeModel(this._treeRoot);
        this._tree = new SchemaTreePanel(this._treeModel);
        this._tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._scrollTree = new JScrollPane(this._tree);
        this._leftPanel.add((Component)this._scrollTree, "Center");
        this._splitPane.setLeftComponent(this._leftPanel);
        this._splitPane.setRightComponent(this._loadPanel);
        this._splitPane.setDividerLocation(160);
        this._splitPane.setContinuousLayout(true);
        this.add(this._splitPane, "Center");
        this._plusButton.addActionListener(this);
        this._lessButton.addActionListener(this);
        if (this.provider != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            this.provider.getSchemas(arrayList, (JPanel)((Object)this));
            for (Object e : arrayList) {
                if (!this._allSchemas.contains(e)) {
                    this._allSchemas.add(e);
                }
                if (!this._allSchemas.isEmpty()) continue;
                this._plusButton.setEnabled(false);
            }
        }
        this.loadSchemaNodeTable(this._currentSchemaNode);
        if (System.getProperty("oracle.dbtools.raptor.timesten.maxparallelloads") == null) {
            System.setProperty("oracle.dbtools.raptor.timesten.maxparallelloads", String.valueOf(16));
        }
        this.initialized = true;
    }

    public void loadSchema(List<Object> list) {
        for (Object object : list) {
            if (this._allSchemas.contains(object)) continue;
            this._allSchemas.add(object);
        }
    }

    private void loadSchemaNodeTable(final SchemaTreeNode schemaTreeNode) {
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)((Object)this), Messages.getString("TimesTen.common.pleaseWait"));
        schemaTreeNode.removeAllChildren();
        this._treeModel.reload(schemaTreeNode);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                try {
                    String string = null;
                    if (schemaTreeNode.getFilter() == null) {
                        string = "SELECT table_name FROM all_tables WHERE owner = '#user#'".replace("#user#", schemaTreeNode.getLabel());
                    } else {
                        string = "SELECT table_name FROM all_tables WHERE owner = '#user#' AND table_name #filter#".replace("#user#", schemaTreeNode.getLabel());
                        string = string.replace("#filter#", schemaTreeNode.getFilter());
                    }
                    List<Object[]> list = LoadSelectedTraversablePanel.this._passthrough.executeQueryOnOracle(string);
                    for (Object[] objectArray : list) {
                        final String string2 = objectArray[0].toString();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (string2.matches("[A-Za-z].*")) {
                                    schemaTreeNode.add(new SchemaTreeNode(string2, 3, schemaTreeNode.getLabel()));
                                } else {
                                    schemaTreeNode.add(new SchemaTreeNode("\"" + string2 + "\"", 3, schemaTreeNode.getLabel()));
                                }
                                LoadSelectedTraversablePanel.this._treeModel.reload(schemaTreeNode);
                            }
                        });
                    }
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Error while loading tables into schema", sQLException);
                    if (sQLException.getErrorCode() == 15022) {
                        MessageDialog.error(null, (Object)Messages.getString("LoadTablesFromOracle.errorWithOraclePassword"), (String)Messages.getString("TimesTen.common.error"), null);
                    }
                    MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(LoadSelectedTraversablePanel.this._passthrough.getConnection(), LoadSelectedTraversablePanel.this._passthrough.getLastError(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                }
                return null;
            }

            @Override
            protected void done() {
                LoadSelectedTraversablePanel.this._treeModel.reload(schemaTreeNode);
                indeterminateProgressMonitor.close();
            }
        };
        swingWorker.execute();
    }

    private void loadTable(final SchemaTreeNode schemaTreeNode) {
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)((Object)this), Messages.getString("TimesTen.common.pleaseWait"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                LoadSelectedTraversablePanel.this.helpLoadTable(schemaTreeNode);
                return null;
            }

            @Override
            protected void done() {
                indeterminateProgressMonitor.close();
            }
        };
        swingWorker.execute();
    }

    private void loadAllTables(final SchemaTreeNode schemaTreeNode, final String string) {
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)((Object)this), Messages.getString("TimesTen.common.pleaseWait"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                if (schemaTreeNode.isSchema()) {
                    Enumeration<TreeNode> enumeration = schemaTreeNode.depthFirstEnumeration();
                    try {
                        while (enumeration.hasMoreElements()) {
                            SchemaTreeNode schemaTreeNode2 = (SchemaTreeNode)enumeration.nextElement();
                            schemaTreeNode2.setLoadAllSchema(string);
                            LoadSelectedTraversablePanel.this.helpLoadTable(schemaTreeNode2);
                            schemaTreeNode2.setLoadAllSchema(null);
                        }
                    }
                    catch (SQLException sQLException) {
                        return null;
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                indeterminateProgressMonitor.close();
            }
        };
        swingWorker.execute();
    }

    public void setPassthrough(TimesTenPassthrough timesTenPassthrough) {
        this._passthrough = timesTenPassthrough;
    }

    public void obtainTableConstraints(LoadTableRow loadTableRow) throws SQLException {
        try {
            String string = "SELECT AC.CONSTRAINT_NAME, AC.CONSTRAINT_TYPE, AC.R_CONSTRAINT_NAME, ACC.COLUMN_NAME, ACC.POSITION FROM ALL_CONSTRAINTS AC, ALL_CONS_COLUMNS ACC WHERE AC.OWNER = '#owner#' AND AC.STATUS = 'ENABLED' AND AC.VALIDATED = 'VALIDATED' AND AC.TABLE_NAME = '#table#' AND AC.CONSTRAINT_NAME = ACC.CONSTRAINT_NAME  AND AC.CONSTRAINT_TYPE IN ('P', 'R', 'U') ORDER BY AC.CONSTRAINT_TYPE, AC.CONSTRAINT_NAME, ACC.POSITION".replace("#owner#", loadTableRow.getOracleUser()).replace("#table#", loadTableRow.getOracleTable());
            List<Object[]> list = this._passthrough.executeQueryOnOracle(string);
            for (Object[] objectArray : list) {
                String string2 = (String)objectArray[1];
                IndexInfo.ConstraintType constraintType = IndexInfo.ConstraintType.NONE;
                if (string2 != null) {
                    if (string2.equalsIgnoreCase("P")) {
                        constraintType = IndexInfo.ConstraintType.PRIMARY;
                    } else if (string2.equalsIgnoreCase("R")) {
                        constraintType = IndexInfo.ConstraintType.FOREIGN;
                    } else if (string2.equalsIgnoreCase("U")) {
                        constraintType = IndexInfo.ConstraintType.UNIQUE;
                    }
                }
                Constraint constraint = new Constraint((String)objectArray[0], constraintType, (String)objectArray[2]);
                String string3 = (String)objectArray[3];
                int n = ((BigDecimal)objectArray[4]).intValue();
                if (loadTableRow.getConstraints() == null || !loadTableRow.getConstraints().contains(constraint)) {
                    loadTableRow.addConstraint(constraint);
                } else {
                    constraint = loadTableRow.getConstraint(constraint);
                }
                if (constraint.containsColumn(string3, n)) continue;
                constraint.addColumn(string3, n);
            }
            if (loadTableRow.getConstraints() != null) {
                Collections.sort(loadTableRow.getConstraints());
            }
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Couldn't get table constraints", sQLException);
            throw sQLException;
        }
    }

    private void generateTableSchemaFromOracleQuery(String string, String string2, String string3) throws SQLException {
        this.generateTableSchemaFromOracleQuery(string, string2, string3, this._dbObject.getConnection().getMetaData().getUserName());
    }

    private void generateTableSchemaFromOracleQuery(String string, String string2, String string3, String string4) throws SQLException {
        if (this.advancedMapping) {
            this.executeAdvancedMapping(string, string2, string3, string4);
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this._dbObject.getConnection();
            Connections.getInstance().lock(connection);
            statement = connection.createStatement();
            String string5 = "call ttTableSchemaFromOraQueryGet('#owner#','#table#','#query#');".replace("#query#", Common.doubleSingleQuotedString(string3, false)).replace("#table#", Common.doubleSingleQuotedString(string2, true)).replace("#owner#", Common.doubleSingleQuotedString(string, true));
            ResultSet resultSet = statement.executeQuery(string5);
            LoadTableRow loadTableRow = null;
            while (resultSet.next()) {
                loadTableRow = new LoadTableRow(string, string2, string3, resultSet.getString(1));
                this._loadTable.addRow(loadTableRow);
                loadTableRow.setParallelLoads(this.loadOptions.getParallelLoads());
            }
            if (loadTableRow != null && Common.isGrid().booleanValue()) {
                loadTableRow.setOracleTable(Common.getOracleTableFromQuery(loadTableRow.getSelectQuery()));
                loadTableRow.setOracleUser(string4);
                this.obtainTableConstraints(loadTableRow);
                this.checkReferencedTables(false);
            }
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Couldn't get select query while loading", sQLException);
            StringBuffer stringBuffer = new StringBuffer();
            for (SQLException sQLException2 : sQLException) {
                if (2207 == sQLException2.getErrorCode()) continue;
                stringBuffer.append(TTSQLExceptionScrubber.getInstance().getMessage(connection, statement.toString(), sQLException2) + "\n");
            }
            MessageDialog.error((Component)((Object)this), (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            throw sQLException;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Error on closing statement", sQLException);
            }
            if (connection != null) {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private void executeAdvancedMapping(String string, String string2, String string3, String string4) throws SQLException {
        if (this.analyzer == null) {
            this.analyzer = new Analyzer(this._dbObject);
        }
        this.analyzer.setAnalysisParameters((AnalysisParam)this.dataContext.get("ANALYSISPARAM"));
        LoadTableRow loadTableRow = this.analyzer.getTable(string, string2, string3, string4);
        if (loadTableRow != null) {
            if (loadTableRow.getAnalysisData() != null && loadTableRow.getAnalysisData().getStatus() != null) {
                MessageDialog.error((Component)((Object)this), (Object)loadTableRow.getAnalysisData().getStatus(), (String)Messages.getString("TimesTen.common.error"), null);
                return;
            }
            loadTableRow.setParallelLoads(this.loadOptions.getParallelLoads());
            this._loadTable.addRow(loadTableRow);
            if (Common.isGrid().booleanValue()) {
                loadTableRow.setOracleTable(Common.getOracleTableFromQuery(loadTableRow.getSelectQuery()));
                loadTableRow.setOracleUser(string4);
                this.obtainTableConstraints(loadTableRow);
                this.checkReferencedTables(false);
            }
        }
    }

    private void helpLoadTable(SchemaTreeNode schemaTreeNode) throws SQLException {
        if (schemaTreeNode.isTable()) {
            String string = schemaTreeNode.getLoadAllSchema();
            String string2 = schemaTreeNode.getSchema();
            String string3 = schemaTreeNode.getLabel();
            if (string == null) {
                string = string2;
            }
            String string4 = "SELECT * from #schema#.#tableName#".replace("#tableName#", string3).replace("#schema#", string2);
            this.generateTableSchemaFromOracleQuery(string, string3, string4, string2);
        }
    }

    private void loadCustomQueryRow(final String string, final String string2, final String string3) {
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)((Object)this), Messages.getString("TimesTen.common.pleaseWait"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                LoadSelectedTraversablePanel.this.generateTableSchemaFromOracleQuery(string, string2, string3);
                return null;
            }

            @Override
            protected void done() {
                indeterminateProgressMonitor.close();
            }
        };
        swingWorker.execute();
    }

    private List<Object> getNotOpenedSchemas() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object : this._allSchemas) {
            if (this._openedSchemas.contains(object)) continue;
            linkedList.add(object);
        }
        return linkedList;
    }

    private void removeOpenedSchema(String string) {
        for (int i = 0; i < this._openedSchemas.size(); ++i) {
            if (!this._openedSchemas.get(i).toString().equals(string)) continue;
            this._openedSchemas.remove(i);
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._plusButton) {
            Object object;
            SelectSchemaPanel selectSchemaPanel = new SelectSchemaPanel();
            JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)selectSchemaPanel, (String)Messages.getString("LoadTablesFromOracle.chooseSchema"), null);
            jEWTDialog.setButtonMask(3);
            if (jEWTDialog.runDialog() && (object = selectSchemaPanel.getSchema()) != null) {
                this._openedSchemas.add(object);
                if (this.getNotOpenedSchemas().isEmpty()) {
                    this._plusButton.setEnabled(false);
                }
                SchemaTreeNode schemaTreeNode = new SchemaTreeNode(object.toString(), 2, null);
                this._treeRoot.add(schemaTreeNode);
                this._treeModel.reload(this._treeRoot);
                this.loadSchemaNodeTable(schemaTreeNode);
            }
            return;
        }
        if (actionEvent.getSource() == this._lessButton) {
            SchemaTreeNode schemaTreeNode;
            if (this._tree.getSelectionPath().getPath().length > 0 && (schemaTreeNode = (SchemaTreeNode)this._tree.getSelectionPath().getLastPathComponent()).isSchema() && !schemaTreeNode.toString().equalsIgnoreCase(this._dbObject.getSchemaName())) {
                this._treeModel.removeNodeFromParent(schemaTreeNode);
                this.removeOpenedSchema(schemaTreeNode.toString());
                this._plusButton.setEnabled(true);
            }
            return;
        }
    }

    @Override
    public void setEnabledComponents(boolean bl) {
        this._plusButton.setEnabled(bl);
        this._lessButton.setEnabled(bl);
        this._tree.setEnabledComponents(bl);
    }

    public void freeResources() {
        try {
            if (!this._passthrough.getConnection().isClosed()) {
                this._passthrough.getConnection().close();
            }
            this.provider.closeConnection();
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Can't close connection", sQLException);
        }
    }

    public void onEntry(final TraversableContext traversableContext) {
        this.dataContext = traversableContext;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        this.loadOptions = (LoadOptions)traversableContext.get("LOAD_OPTIONS");
        this.advancedMapping = traversableContext.contains("ANALYSISPARAM");
        if (!this.initialized) {
            this.init((DBObject)traversableContext.get("DBOBJECT"));
        }
        if (traversableContext.contains("TABLES")) {
            final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)((Object)this), Messages.getString("TimesTen.common.pleaseWait"));
            SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    indeterminateProgressMonitor.display();
                    ArrayList arrayList = new ArrayList((List)traversableContext.get("TABLES"));
                    LoadSelectedTraversablePanel.this._loadTable.deleteAllRows();
                    for (LoadTableRow loadTableRow : arrayList) {
                        LoadSelectedTraversablePanel.this.generateTableSchemaFromOracleQuery(loadTableRow.getTimesTenUser(), loadTableRow.getTimesTenTable(), loadTableRow.getSelectQuery(), loadTableRow.getOracleUser());
                    }
                    return null;
                }

                @Override
                protected void done() {
                    indeterminateProgressMonitor.close();
                }
            };
            swingWorker.execute();
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.get("READY") == null) {
            if (traversableContext.getDirection() == 1) {
                List<LoadTableRow> list = this._loadTable.getData();
                if (list.size() == 0) {
                    throw new TraversalException(Messages.getString("LoadTablesFromOracle.noTableSelected"));
                }
                ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i).getTimesTenUser() + "." + list.get(i).getTimesTenTable();
                    if (arrayList.contains(string)) {
                        throw new TraversalException(MessageFormat.format(Messages.getString("LoadTablesFromOracle.repeatedTableName"), i + 1, arrayList.indexOf(string) + 1));
                    }
                    arrayList.add((CallSite)((Object)string));
                }
                if (Common.isGrid().booleanValue()) {
                    if (!this.checkReferencedTables(true)) {
                        throw new TraversalException(null);
                    }
                    if (this.notLoadedParentTable()) {
                        throw new TraversalException(null);
                    }
                }
                traversableContext.put("TABLES", list);
                OracleTableLoader oracleTableLoader = new OracleTableLoader(this._dbObject);
                oracleTableLoader.loadData(this._loadTable, this);
                if (this.analyzer != null) {
                    this.analyzer.freeResources();
                }
                throw new TraversalException(null);
            }
            if (traversableContext.getDirection() == 2) {
                traversableContext.remove("ANALYSISPARAM");
                traversableContext.put("TABLES", this._loadTable.getData());
            }
        }
        traversableContext.put("TIMESTENPASSTHROUGH", (Object)this._passthrough);
    }

    public void loadReferences(LoadTablesTable loadTablesTable) {
        this._loadTable = loadTablesTable;
        this.checkReferencedTables(false);
        this.notLoadedParentTable();
    }

    private boolean notLoadedParentTable() {
        for (LoadTableRow loadTableRow : this._loadTable.getData()) {
            if (loadTableRow.getConstraints() == null) continue;
            for (Constraint constraint : loadTableRow.getConstraints()) {
                if (constraint.getConstraintType() == IndexInfo.ConstraintType.FOREIGN && constraint.addConstraint()) {
                    loadTableRow.setChildTable(true);
                    continue;
                }
                if (constraint.getConstraintType() != IndexInfo.ConstraintType.PRIMARY && constraint.getConstraintType() != IndexInfo.ConstraintType.UNIQUE || !constraint.addConstraint()) continue;
                loadTableRow.setParentTable(true);
            }
        }
        for (LoadTableRow loadTableRow : this._loadTable.getData()) {
            if (!loadTableRow.isChildTable()) continue;
            for (Constraint constraint : loadTableRow.getConstraints()) {
                String string;
                int n;
                LoadTableRow loadTableRow2;
                String string2;
                if (constraint.getConstraintType() != IndexInfo.ConstraintType.FOREIGN || !constraint.addConstraint() || (string2 = constraint.getRTableName()) == null || (loadTableRow2 = this.findParentTable(string2)) == null || !loadTableRow2.getCreateTableOnly() || loadTableRow.getCreateTableOnly() || (n = MessageDialog.confirmOrCancel((Component)((Object)this), (Object)(string = MessageFormat.format(Messages.getString("LoadTablesFromOracle.parenTableNotLoaded"), loadTableRow2.getTimesTenTable(), loadTableRow.getTimesTenTable())), (String)Messages.getString("TimesTen.common.warning"))) == 1) continue;
                return true;
            }
        }
        return false;
    }

    private LoadTableRow findParentTable(String string) {
        for (LoadTableRow loadTableRow : this._loadTable.getData()) {
            if (!loadTableRow.isParentTable() || loadTableRow.getOracleTable() == null || !loadTableRow.getOracleTable().equalsIgnoreCase(string)) continue;
            return loadTableRow;
        }
        return null;
    }

    private boolean checkReferencedTables(boolean bl) {
        int n;
        Object object;
        Hashtable<Constraint, String> hashtable = new Hashtable<Constraint, String>();
        Hashtable<String, Constraint> hashtable2 = new Hashtable<String, Constraint>();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        for (LoadTableRow comparable2 : this._loadTable.getData()) {
            if (comparable2.getConstraints() == null) continue;
            for (Constraint n2 : comparable2.getConstraints()) {
                if (n2.getConstraintType() == IndexInfo.ConstraintType.FOREIGN) {
                    hashtable.put(n2, comparable2.getOracleTable());
                }
                hashtable2.put(n2.getName(), n2);
                hashtable3.put(n2.getName(), comparable2.getTimesTenTable());
            }
        }
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (Constraint constraint : hashtable.keySet()) {
            if (!hashtable2.containsKey(constraint.getRName())) {
                ++n2;
                if (stringBuilder.length() == 0) {
                    stringBuilder.append((String)hashtable.get(constraint));
                    continue;
                }
                stringBuilder.append(", " + (String)hashtable.get(constraint));
                continue;
            }
            constraint.setAddConstraint(true);
            object = (Constraint)hashtable2.get(constraint.getRName());
            ((Constraint)object).setAddConstraint(true);
            constraint.setRConstraint((Constraint)object);
        }
        Object object2 = this._loadTable.getData().iterator();
        while (object2.hasNext()) {
            LoadTableRow loadTableRow = (LoadTableRow)object2.next();
            object = loadTableRow.getTableDistribution();
            if (loadTableRow.isDefaultDistribution()) {
                if (loadTableRow.getConstraints() != null) {
                    for (Constraint constraint : loadTableRow.getConstraints()) {
                        if (constraint.getConstraintType() != IndexInfo.ConstraintType.FOREIGN || !constraint.addConstraint()) continue;
                        object = new Constraint.TableDistribution(Constraint.DistributionType.REFERENCE);
                        ((Constraint.TableDistribution)object).setForeignKey(constraint);
                        constraint.setRTableName((String)hashtable3.get(constraint.getRName()));
                    }
                }
            } else if (loadTableRow.getConstraints() != null) {
                for (Constraint constraint : loadTableRow.getConstraints()) {
                    if (constraint.getConstraintType() != IndexInfo.ConstraintType.FOREIGN || !constraint.addConstraint()) continue;
                    constraint.setRTableName((String)hashtable3.get(constraint.getRName()));
                }
            }
            loadTableRow.setTableDistribution((Constraint.TableDistribution)object);
        }
        return n2 <= 0 || !bl || (n = MessageDialog.confirmOrCancel((Component)((Object)this), (Object)(object2 = n2 == 1 ? MessageFormat.format(Messages.getString("LoadTablesFromOracle.notSelectedTableWithRFK"), stringBuilder.toString()) : MessageFormat.format(Messages.getString("LoadTablesFromOracle.notSelectedTablesWithRFK"), stringBuilder.toString())), (String)Messages.getString("TimesTen.common.warning"))) == 1;
    }

    public Object getExitTransition() {
        return "LoadSummary";
    }

    @Override
    public LoadOptions getLoadOptions() {
        return this.loadOptions;
    }

    @Override
    public void refreshRow(int n) {
        this._loadTable.refreshRow(n);
    }

    @Override
    public TimesTenPassthrough getPassthrough() {
        return this._passthrough;
    }

    @Override
    public Component getLoadComponent() {
        return this;
    }

    @Override
    public void refreshTheCompleteTable() {
        this._loadTable.refreshTheCompleteTable();
    }

    @Override
    public void updateOnFinish() {
        this.dataContext.put("READY", (Object)1);
        SwingUtilities.invokeLater(() -> this.dataContext.getWizardCallbacks().nextPage());
    }

    private class SchemasTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 1L;

        public SchemasTreeModel(TreeNode treeNode) {
            super(treeNode);
        }
    }

    private class SchemaTreePanel
    extends JTree
    implements ActionListener,
    TreeWillExpandListener {
        private static final long serialVersionUID = 1L;
        private JPopupMenu _menu;
        private JMenuItem _load;
        private JMenuItem _loadAll;
        private JMenuItem _filter;
        private JMenuItem _removeFilter;
        private JMenuItem _custom;
        private SchemaTreeNode _selectedNode;
        private boolean enabledComponents;
        private MouseAdapter mouseAdapter;

        public SchemaTreePanel(SchemasTreeModel schemasTreeModel) {
            super(schemasTreeModel);
            this.mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isPopupTrigger()) {
                        SchemaTreePanel.this.displayPopUp(mouseEvent);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isPopupTrigger()) {
                        SchemaTreePanel.this.displayPopUp(mouseEvent);
                    }
                }
            };
            this.addMouseListener(this.mouseAdapter);
            this._menu = new JPopupMenu();
            this.setCellRenderer(new TreeIconRenderer());
            this.setupMenuItems();
            this.addTreeWillExpandListener(this);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(121, 1, true);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(525, 0);
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(27, 0);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SchemaTreePanel.this.displayPopup();
                }
            };
            this.registerKeyboardAction(actionListener, keyStroke, 0);
            this.registerKeyboardAction(actionListener, keyStroke2, 0);
            this._menu.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SchemaTreePanel.this._menu.setVisible(false);
                }
            }, keyStroke3, 0);
            this.enabledComponents = true;
        }

        private void setupMenuItems() {
            this._custom = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.custom"), this._menu);
            this._load = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.load"), this._menu);
            this._loadAll = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.loadAll"), this._menu);
            this._filter = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.applyFilter"), this._menu);
            this._removeFilter = new ClosableEscMenuItem(Messages.getString("LoadTablesFromOracle.removeFilter"), this._menu);
            this._custom.addActionListener(this);
            this._load.addActionListener(this);
            this._loadAll.addActionListener(this);
            this._filter.addActionListener(this);
            this._removeFilter.addActionListener(this);
        }

        private void displayPopUp(MouseEvent mouseEvent) {
            if (!this.enabledComponents) {
                return;
            }
            int n = this.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            this.setSelectionRow(n);
            TreePath[] treePathArray = this.getSelectionModel().getSelectionPaths();
            if (treePathArray.length == 1) {
                this._selectedNode = (SchemaTreeNode)treePathArray[0].getLastPathComponent();
                this._menu.removeAll();
                if (this._selectedNode.isSchema()) {
                    this._menu.add(this._loadAll);
                    if (this._selectedNode.getFilter() == null) {
                        this._menu.add(this._filter);
                    } else {
                        this._menu.add(this._removeFilter);
                    }
                }
                if (this._selectedNode.isTable()) {
                    this._menu.add(this._load);
                }
                if (!this._selectedNode.isRoot()) {
                    this._menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this._menu.add(this._custom);
                    this._menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        private void displayPopup() {
            if (!this.enabledComponents) {
                return;
            }
            TreePath[] treePathArray = this.getSelectionModel().getSelectionPaths();
            if (treePathArray.length == 1) {
                this._selectedNode = (SchemaTreeNode)treePathArray[0].getLastPathComponent();
                this._menu.removeAll();
                Rectangle rectangle = this.getPathBounds(treePathArray[0]);
                if (this._selectedNode.isSchema()) {
                    this._menu.add(this._loadAll);
                    if (this._selectedNode.getFilter() == null) {
                        this._menu.add(this._filter);
                    } else {
                        this._menu.add(this._removeFilter);
                    }
                }
                if (this._selectedNode.isTable()) {
                    this._menu.add(this._load);
                }
                if (!this._selectedNode.isRoot()) {
                    this._menu.show(this, rectangle.x, rectangle.y);
                } else {
                    this._menu.add(this._custom);
                    this._menu.show(this, rectangle.x, rectangle.y);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._load) {
                LoadSelectedTraversablePanel.this.loadTable(this._selectedNode);
                return;
            }
            if (actionEvent.getSource() == this._custom) {
                final CustomPanel customPanel = new CustomPanel();
                final JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)customPanel, (String)Messages.getString("LoadTablesFromOracle.customQuery"), null);
                jEWTDialog.setButtonMask(2);
                JButton jButton = new JButton();
                jEWTDialog.setCancelButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.cancelButton")));
                jEWTDialog.setCancelButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.cancelButton")));
                jButton.setText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
                jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.OKButton")));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        LoadSelectedTraversablePanel.this.loadCustomQueryRow(customPanel.getUserName(), customPanel.getTableName(), customPanel.getQuery());
                        jEWTDialog.dispose();
                    }
                });
                jEWTDialog.addCustomButton((Component)jButton);
                jEWTDialog.setVisible(true);
                return;
            }
            if (actionEvent.getSource() == this._loadAll) {
                UsernamePanel usernamePanel = new UsernamePanel();
                JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)usernamePanel, (String)Messages.getString("LoadTablesFromOracle.timestenUsername"), null);
                jEWTDialog.setButtonMask(3);
                jEWTDialog.setCancelButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.cancelButton")));
                jEWTDialog.setCancelButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.cancelButton")));
                jEWTDialog.setOKButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
                jEWTDialog.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.OKButton")));
                if (jEWTDialog.runDialog()) {
                    String string = usernamePanel.getUserName();
                    if (string.length() == 0) {
                        MessageDialog.error(null, (Object)"USERNAME CANT BE EMPTY ", (String)Messages.getString("TimesTen.common.error"), null);
                    } else {
                        LoadSelectedTraversablePanel.this.loadAllTables(this._selectedNode, string);
                    }
                }
                return;
            }
            if (actionEvent.getSource() == this._filter) {
                FilterPanel filterPanel = new FilterPanel();
                JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)filterPanel, (String)Messages.getString("LoadTablesFromOracle.filter"), null);
                jEWTDialog.setButtonMask(3);
                jEWTDialog.setCancelButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.cancelButton")));
                jEWTDialog.setCancelButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.cancelButton")));
                jEWTDialog.setOKButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
                jEWTDialog.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.OKButton")));
                if (jEWTDialog.runDialog()) {
                    this._selectedNode.setFilter(filterPanel.getFilter());
                    LoadSelectedTraversablePanel.this.loadSchemaNodeTable(this._selectedNode);
                }
                return;
            }
            if (actionEvent.getSource() == this._removeFilter) {
                this._selectedNode.removeFilter();
                LoadSelectedTraversablePanel.this.loadSchemaNodeTable(this._selectedNode);
            }
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            SchemaTreeNode schemaTreeNode = (SchemaTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
            if (schemaTreeNode == LoadSelectedTraversablePanel.this._treeRoot) {
                throw new ExpandVetoException(treeExpansionEvent);
            }
        }

        public void setEnabledComponents(boolean bl) {
            this.enabledComponents = bl;
        }
    }

    private class SelectSchemaPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JPanel _contentPanel;
        private TT2ColGridBagConstraints constraint;
        private GridBagLayout _gridBag = new GridBagLayout();
        private JComboBox<Object> _combo;

        public SelectSchemaPanel() {
            this._contentPanel = new JPanel(this._gridBag);
            this.add(this._contentPanel);
            this.constraint = new TT2ColGridBagConstraints();
            this.constraint.new_row();
            JLabel jLabel = new JLabel(Messages.getString("LoadTablesFromORacle.schemaName"));
            this._gridBag.setConstraints(jLabel, this.constraint);
            this._contentPanel.add(jLabel);
            this.constraint.col2();
            this._combo = new JComboBox<Object>(LoadSelectedTraversablePanel.this.getNotOpenedSchemas().toArray());
            this._gridBag.setConstraints(this._combo, this.constraint);
            this._contentPanel.add(this._combo);
        }

        public Object getSchema() {
            return this._combo.getSelectedItem();
        }
    }

    private class FilterPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel _tableText = new JLabel(Messages.getString("LoadTablesFromOracle.tableName"));
        private JComboBox<String> _options = new JComboBox<String>(Common.likeOptions);
        private JTextField _value;

        public FilterPanel() {
            this._options.setSelectedIndex(2);
            this._value = new JTextField(10);
            this.add(this._tableText);
            this.add(this._options);
            this.add(this._value);
        }

        private String getValue() {
            if (this._options.getSelectedItem().toString().contains("LIKE")) {
                if (this._value.getText().contains("%")) {
                    return "'" + this._value.getText() + "'";
                }
                return "'%" + this._value.getText() + "%'";
            }
            return "'" + this._value.getText() + "'";
        }

        public String getFilter() {
            return this._options.getSelectedItem().toString() + " " + this.getValue();
        }
    }

    private class UsernamePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel _text = new JLabel(Messages.getString("LoadTablesFromOracle.timestenUsername"));
        private JTextField _user = new JTextField(20);

        public UsernamePanel() {
            this.add(this._text);
            this.add(this._user);
        }

        public String getUserName() {
            return this._user.getText().trim();
        }
    }

    private class CustomPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private BasicEditorPane _queryEditor;
        private JLabel _queryEditorLable;
        private JLabel _ttUsernameLabel;
        private JLabel _tableNameLabel;
        private JLabel _oraUsernameLabel;
        private JTextField _ttUsernameJTF;
        private JTextField _tableNameJTF;
        private JTextField _oraUsernameJTF;

        public String getUserName() {
            return this._ttUsernameJTF.getText();
        }

        public String getTableName() {
            return this._tableNameJTF.getText();
        }

        public String getQuery() {
            return this._queryEditor.getText();
        }

        public CustomPanel() {
            this.setLayout(new GridBagLayout());
            this._ttUsernameLabel = new JLabel(Messages.getString("LoadTablesFromOracle.timestenUsername"));
            this._ttUsernameJTF = new JTextField(15);
            this._tableNameLabel = new JLabel(Messages.getString("LoadTablesFromOracle.timesTenTableName"));
            this._tableNameJTF = new JTextField(15);
            this._oraUsernameLabel = new JLabel(Messages.getString("LoadTablesFromORacle.schemaName"));
            this._oraUsernameJTF = new JTextField(15);
            this._oraUsernameJTF.setEditable(false);
            this._queryEditorLable = new JLabel(Messages.getString("LoadTablesFromOracle.selectQuery"));
            this._queryEditor = EditorFactory.createIdeEditorPane();
            BasicDocument basicDocument = (BasicDocument)this._queryEditor.getDocument();
            basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
            this._queryEditor.setPreferredSize(new Dimension(200, 200));
            this._queryEditorLable.setVerticalAlignment(1);
            this._queryEditorLable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            ResourceUtils.resLabel((JLabel)this._ttUsernameLabel, (Component)this._ttUsernameJTF, (String)Messages.getString("LoadTablesFromOracle.timestenUsername"));
            ResourceUtils.resLabel((JLabel)this._oraUsernameLabel, (Component)this._oraUsernameJTF, (String)Messages.getString("LoadTablesFromORacle.schemaName"));
            ResourceUtils.resLabel((JLabel)this._tableNameLabel, (Component)this._tableNameJTF, (String)Messages.getString("LoadTablesFromOracle.timesTenTableName"));
            ResourceUtils.resLabel((JLabel)this._queryEditorLable, (Component)this._queryEditor, (String)Messages.getString("LoadTablesFromOracle.selectQuery"));
            Insets insets = new Insets(2, 2, 2, 2);
            this.add((Component)this._oraUsernameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._oraUsernameJTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
            this.add((Component)this._ttUsernameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._ttUsernameJTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
            this.add((Component)this._tableNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._tableNameJTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
            this.add((Component)this._queryEditorLable, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._queryEditor, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
            this._tableNameJTF.setText(LoadSelectedTraversablePanel.this._dbObject.getObjectName());
            this._ttUsernameJTF.setText(LoadSelectedTraversablePanel.this._dbObject.getSchemaName());
            try {
                this._oraUsernameJTF.setText(LoadSelectedTraversablePanel.this._dbObject.getConnection().getMetaData().getUserName());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private class TreeIconRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private TreeIconRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof SchemaTreeNode) {
                SchemaTreeNode schemaTreeNode = (SchemaTreeNode)object;
                if (schemaTreeNode.isRoot()) {
                    this.setIcon(Common.SCHEMA_FOLDER_ICON);
                } else if (schemaTreeNode.isSchema()) {
                    this.setIcon(Common.SCHEMA_ICON);
                } else if (schemaTreeNode.isTable()) {
                    this.setIcon(Common.TABLE_ICON);
                }
            }
            return this;
        }
    }
}

