/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.dbtools.raptor.timesten.AgingInfo;
import oracle.dbtools.raptor.timesten.CacheInfo;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.TTDialog;
import oracle.dbtools.raptor.utils.DBObject;

public final class AddAgingUBPanel
extends DialogBase {
    private JTextField gui_aging_state;

    @Override
    public boolean applicable(DBObject dBObject) {
        if (this._model != null) {
            if (this._model.get("TYPE") != null) {
                TTDialog.showError(MessageFormat.format(Messages.getString("AddAgingUBPanel.thisCommandOnlyAppliesTo"), this.THING));
                return false;
            }
            if (this.is_table) {
                if (CacheInfo.tableIsPartOfARCG(dBObject)) {
                    TTDialog.showError(Messages.getString("AddAgingUBPanel.thisCommandCannotBeAppliedTothisTale"));
                    return false;
                }
                if (CacheInfo.tableIsNonRootCG(dBObject)) {
                    TTDialog.showError(Messages.getString("AddAgingUBPanel.thisCommandCannotBeAppliedTothisTaleNonRoot"));
                    return false;
                }
            }
        }
        return true;
    }

    public AddAgingUBPanel(DBObject dBObject, String string) {
        super(dBObject, string, "AddAgingUBPanel", "aging");
    }

    public AddAgingUBPanel(DBObject dBObject, String string, String string2) {
        super(dBObject, string, "AddAgingUBPanel", string2);
    }

    @Override
    protected void initGUI() {
        this.setLayout(this.gridbag);
        if (!this._mode.equals("none")) {
            this.addOwnerAndName(this._dict);
        }
        this.gui_aging_state = new JTextField("on");
        this._textValues.add(this.gui_aging_state);
        Container container = TTDialog.createRadioButtonGroup(new String[]{Messages.getString("TimesTen.common.on"), Messages.getString("TimesTen.common.off")}, 0, new ActionListener[]{new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddAgingUBPanel.this.gui_aging_state.setText("on");
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddAgingUBPanel.this.gui_aging_state.setText("off");
            }
        }});
        StringBuffer stringBuffer = new StringBuffer(128);
        String[] stringArray = AgingInfo.getLRUThreshold(this._dbObject);
        stringBuffer.append("<html><body>");
        stringBuffer.append(MessageFormat.format(Messages.getString("AddAgingUBPanel.currentlyLeastRecently"), stringArray[0], stringArray[1]));
        stringBuffer.append("%.</body></html>");
        if (this._mode.startsWith("none")) {
            this.addRow(container);
            this.addRow("<html><body><b><br>" + Messages.getString("AddAgingUBPanel.currentUsageThreshold") + "<br>&nbsp;</b></body></html>");
            this.addRow(stringBuffer.toString());
        } else {
            this.addRow(Messages.getString("AddAgingUBPanel.usageBasedAging"), (Component)container);
            this.addRow("", stringBuffer.toString());
        }
        this.setSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    @Override
    public String getSql() {
        try {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            String string = stackTraceElementArray[1].toString();
            if (this._mode.startsWith("none")) {
                return "\n  AGING LRU " + this.gui_aging_state.getText().toUpperCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "alter table " + this._rootTableFullname + "\n    add aging lru " + this.gui_aging_state.getText();
    }
}

