/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.jobs;

import java.sql.Connection;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.extension.jobs.JobsMessages;
import oracle.dbtools.extension.jobs.JobsProcessor;
import oracle.dbtools.extension.jobs.completers.JobIdCompleter;
import oracle.dbtools.extension.jobs.completers.JobNameCompleter;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.OptionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class JobsCommand
extends ParsedCommandListener
implements SQLCLService {
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        Id command = parsedCommand.getType().getId();
        if (command == Symbol.JOBS) {
            JobsProcessor.list(ctx, (Integer)parsedCommand.getOptionValue((Id)Symbol.ID), (String)parsedCommand.getOptionValue((Id)Symbol.TASKNAME));
        } else if (command == Symbol.CANCEL) {
            JobsProcessor.cancel(ctx, (Integer)parsedCommand.getOptionValue((Id)Symbol.ID), (String)parsedCommand.getOptionValue((Id)Symbol.TASKNAME));
        } else if (command == Symbol.DELETE) {
            JobsProcessor.delete(ctx, (Integer)parsedCommand.getOptionValue((Id)Symbol.ID), (String)parsedCommand.getOptionValue((Id)Symbol.TASKNAME), parsedCommand.isFlagSet((Id)Symbol.ALL), parsedCommand.isFlagSet((Id)Symbol.FINISHED));
        } else if (command == Symbol.LOGS) {
            JobsProcessor.showLogs(ctx, (Integer)parsedCommand.getOptionValue((Id)Symbol.ID), (String)parsedCommand.getOptionValue((Id)Symbol.TASKNAME));
        } else if (command == Symbol.DELETE_LOGS) {
            JobsProcessor.deleteLogs(ctx);
        }
        return true;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        JobsProcessor.init(ctx);
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return "Jobs command";
    }

    public String getExtensionName() {
        return "Jobs command";
    }

    public String getExtensionVersion() {
        return JobsMessages.getString("SQLclVersion.VERSION");
    }

    protected Type createType() {
        Option id = ((OptionBuilder)((OptionBuilder)Factory.option((Id)Symbol.ID).abbrevs(new String[]{"I"}).dataType(Integer.class)).completer(new SemanticCompleter[]{new JobIdCompleter()})).build();
        Option taskname = ((OptionBuilder)Factory.option((Id)Symbol.TASKNAME).completer(new SemanticCompleter[]{new JobNameCompleter()})).abbrevs(new String[]{"TN"}).build();
        Type cancel = Factory.type((Id)Symbol.CANCEL).abbrevs(new String[]{"C"}).add(id).add(taskname).build();
        Type logs = Factory.type((Id)Symbol.LOGS).abbrevs(new String[]{"L"}).add(id).add(taskname).add(Factory.type((Id)Symbol.DELETE_LOGS).name("DELETE").abbrevs(new String[]{"D"}).build()).build();
        Type delete = Factory.type((Id)Symbol.DELETE).abbrevs(new String[]{"D"}).add(id).add(taskname).add(Factory.option((Id)Symbol.ALL).abbrevs(new String[]{"A"}).flag().build()).add(Factory.option((Id)Symbol.FINISHED).abbrevs(new String[]{"F"}).flag().build()).build();
        return Factory.type((Id)Symbol.JOBS).abbrevs(new String[]{"JB"}).add(id).add(taskname).add(cancel).add(logs).add(delete).build();
    }

    public static enum Symbol implements Id
    {
        JOBS,
        ID,
        TASKNAME,
        START,
        WAIT4,
        CANCEL,
        LOGS,
        DELETE,
        DELETE_LOGS,
        ALL,
        FINISHED;

    }
}

