/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.image;

import ilog.views.util.image.ImageEncodeParam;
import ilog.views.util.image.PNGSuggestedPaletteEntry;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Date;
import java.util.Vector;

public abstract class PNGEncodeParam
implements ImageEncodeParam {
    public static final int INTENT_PERCEPTUAL = 0;
    public static final int INTENT_RELATIVE = 1;
    public static final int INTENT_SATURATION = 2;
    public static final int INTENT_ABSOLUTE = 3;
    public static final int PNG_FILTER_NONE = 0;
    public static final int PNG_FILTER_SUB = 1;
    public static final int PNG_FILTER_UP = 2;
    public static final int PNG_FILTER_AVERAGE = 3;
    public static final int PNG_FILTER_PAETH = 4;
    protected int bitDepth;
    protected boolean bitDepthSet = false;
    private boolean a = false;
    private float[] b = null;
    private boolean c = false;
    private float d;
    private boolean e = false;
    private int[] f = null;
    private boolean g = false;
    private byte[] h = null;
    private boolean i = false;
    private int[] j = null;
    private boolean k = false;
    private PNGSuggestedPaletteEntry[] l = null;
    private boolean m = false;
    private int[] n = null;
    private boolean o = false;
    private int p;
    private boolean q = false;
    private String[] r = null;
    private boolean s = false;
    private Date t;
    private boolean u = false;
    boolean v = false;
    private String[] w = null;
    private boolean x = false;
    Vector y = new Vector();
    Vector z = new Vector();

    public static PNGEncodeParam getDefaultEncodeParam(RenderedImage renderedImage) {
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return new Palette();
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getNumBands();
        if (n == 1 || n == 2) {
            return new Gray();
        }
        return new RGB();
    }

    public abstract void setBitDepth(int var1);

    public int getBitDepth() {
        if (!this.bitDepthSet) {
            throw new IllegalStateException("Grayscale bit depth has not been set.");
        }
        return this.bitDepth;
    }

    public void unsetBitDepth() {
        this.bitDepthSet = false;
    }

    public void setInterlacing(boolean bl) {
        this.a = bl;
    }

    public boolean getInterlacing() {
        return this.a;
    }

    public void unsetBackground() {
        throw new RuntimeException("'unsetBackground' not implemented by the superclass 'PNGEncodeParam'.");
    }

    public boolean isBackgroundSet() {
        throw new RuntimeException("'isBackgroundSet' not implemented by the superclass 'PNGEncodeParam'.");
    }

    public void setChromaticity(float[] fArray) {
        if (fArray.length != 8) {
            throw new IllegalArgumentException();
        }
        this.b = (float[])fArray.clone();
        this.c = true;
    }

    public void setChromaticity(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float[] fArray = new float[]{f, f2, f3, f4, f5, f6, f7, f8};
        this.setChromaticity(fArray);
    }

    public float[] getChromaticity() {
        if (!this.c) {
            throw new IllegalStateException("Chromaticity has not been set.");
        }
        return (float[])this.b.clone();
    }

    public void unsetChromaticity() {
        this.b = null;
        this.c = false;
    }

    public boolean isChromaticitySet() {
        return this.c;
    }

    public void setGamma(float f) {
        this.d = f;
        this.e = true;
    }

    public float getGamma() {
        if (!this.e) {
            throw new IllegalStateException("Gamma has not been set.");
        }
        return this.d;
    }

    public void unsetGamma() {
        this.e = false;
    }

    public boolean isGammaSet() {
        return this.e;
    }

    public void setPaletteHistogram(int[] nArray) {
        this.f = (int[])nArray.clone();
        this.g = true;
    }

    public int[] getPaletteHistogram() {
        if (!this.g) {
            throw new IllegalStateException("Palette histogram has not been set.");
        }
        return this.f;
    }

    public void unsetPaletteHistogram() {
        this.f = null;
        this.g = false;
    }

    public boolean isPaletteHistogramSet() {
        return this.g;
    }

    public void setICCProfileData(byte[] byArray) {
        this.h = (byte[])byArray.clone();
        this.i = true;
    }

    public byte[] getICCProfileData() {
        if (!this.i) {
            throw new IllegalStateException("ICC profile has not been set");
        }
        return (byte[])this.h.clone();
    }

    public void unsetICCProfileData() {
        this.h = null;
        this.i = false;
    }

    public boolean isICCProfileDataSet() {
        return this.i;
    }

    public void setPhysicalDimension(int[] nArray) {
        this.j = (int[])nArray.clone();
        this.k = true;
    }

    public void setPhysicalDimension(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2, n3};
        this.setPhysicalDimension(nArray);
    }

    public int[] getPhysicalDimension() {
        if (!this.k) {
            throw new IllegalStateException("Physical dimension information has not been set");
        }
        return (int[])this.j.clone();
    }

    public void unsetPhysicalDimension() {
        this.j = null;
        this.k = false;
    }

    public boolean isPhysicalDimensionSet() {
        return this.k;
    }

    public void setSuggestedPalette(PNGSuggestedPaletteEntry[] pNGSuggestedPaletteEntryArray) {
        this.l = (PNGSuggestedPaletteEntry[])pNGSuggestedPaletteEntryArray.clone();
        this.m = true;
    }

    public PNGSuggestedPaletteEntry[] getSuggestedPalette() {
        if (!this.m) {
            throw new IllegalStateException("Suggested palette information has not been set");
        }
        return (PNGSuggestedPaletteEntry[])this.l.clone();
    }

    public void unsetSuggestedPalette() {
        this.l = null;
        this.m = false;
    }

    public boolean isSuggestedPaletteSet() {
        return this.m;
    }

    public void setSignificantBits(int[] nArray) {
        this.n = (int[])nArray.clone();
        this.o = true;
    }

    public int[] getSignificantBits() {
        if (!this.o) {
            throw new IllegalStateException("Significant bits values have not been set");
        }
        return (int[])this.n.clone();
    }

    public void unsetSignificantBits() {
        this.n = null;
        this.o = false;
    }

    public boolean isSignificantBitsSet() {
        return this.o;
    }

    public void setSRGBIntent(int n) {
        this.p = n;
        this.q = true;
    }

    public int getSRGBIntent() {
        if (!this.q) {
            throw new IllegalStateException("sRGB rendereding intent has not been set");
        }
        return this.p;
    }

    public void unsetSRGBIntent() {
        this.q = false;
    }

    public boolean isSRGBIntentSet() {
        return this.q;
    }

    public void setText(String[] stringArray) {
        this.r = stringArray;
        this.s = true;
    }

    public String[] getText() {
        if (!this.s) {
            throw new IllegalStateException("Uncompressed text strings have not been set");
        }
        return this.r;
    }

    public void unsetText() {
        this.r = null;
        this.s = false;
    }

    public boolean isTextSet() {
        return this.s;
    }

    public void setModificationTime(Date date) {
        this.t = date;
        this.u = true;
    }

    public Date getModificationTime() {
        if (!this.u) {
            throw new IllegalStateException("Modification time has not been set");
        }
        return this.t;
    }

    public void unsetModificationTime() {
        this.t = null;
        this.u = false;
    }

    public boolean isModificationTimeSet() {
        return this.u;
    }

    public void unsetTransparency() {
        this.v = false;
    }

    public boolean isTransparencySet() {
        return this.v;
    }

    public void setCompressedText(String[] stringArray) {
        this.w = stringArray;
        this.x = true;
    }

    public String[] getCompressedText() {
        if (!this.x) {
            throw new IllegalStateException("Compressed text strings have not been set");
        }
        return this.w;
    }

    public void unsetCompressedText() {
        this.w = null;
        this.x = false;
    }

    public boolean isCompressedTextSet() {
        return this.x;
    }

    public synchronized void addPrivateChunk(String string, byte[] byArray) {
        this.y.add(string);
        this.z.add((byte[])byArray.clone());
    }

    public synchronized int getNumPrivateChunks() {
        return this.y.size();
    }

    public synchronized String getPrivateChunkType(int n) {
        return (String)this.y.elementAt(n);
    }

    public synchronized byte[] getPrivateChunkData(int n) {
        return (byte[])this.z.elementAt(n);
    }

    public synchronized void removeUnsafeToCopyPrivateChunks() {
        Vector<String> vector = new Vector<String>();
        Vector<byte[]> vector2 = new Vector<byte[]>();
        int n = this.getNumPrivateChunks();
        for (int i = 0; i < n; ++i) {
            String string = this.getPrivateChunkType(i);
            char c = string.charAt(3);
            if (c < 'a' || c > 'z') continue;
            vector.add(string);
            vector2.add(this.getPrivateChunkData(i));
        }
        this.y = vector;
        this.z = vector2;
    }

    public synchronized void removeAllPrivateChunks() {
        this.y = new Vector();
        this.z = new Vector();
    }

    private static final int a(int n) {
        return n < 0 ? -n : n;
    }

    public static final int paethPredictor(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = PNGEncodeParam.a(n4 - n);
        int n6 = PNGEncodeParam.a(n4 - n2);
        int n7 = PNGEncodeParam.a(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }

    public int filterRow(byte[] byArray, byte[] byArray2, byte[][] byArray3, int n, int n2) {
        int n3;
        int[] nArray = new int[]{0, 0, 0, 0, 0};
        for (n3 = n2; n3 < n + n2; ++n3) {
            int n4;
            int n5 = byArray[n3] & 0xFF;
            int n6 = byArray[n3 - n2] & 0xFF;
            int n7 = byArray2[n3] & 0xFF;
            int n8 = byArray2[n3 - n2] & 0xFF;
            nArray[0] = nArray[0] + n5;
            int n9 = n5 - n6;
            byArray3[1][n3] = (byte)n9;
            nArray[1] = nArray[1] + (n9 > 0 ? n9 : -n9);
            n9 = n5 - n7;
            byArray3[2][n3] = (byte)n9;
            nArray[2] = nArray[2] + (n9 >= 0 ? n9 : -n9);
            n9 = n5 - (n6 + n7 >> 1);
            byArray3[3][n3] = (byte)n9;
            nArray[3] = nArray[3] + (n9 >= 0 ? n9 : -n9);
            int n10 = n7 - n8;
            int n11 = n6 - n8;
            if (n10 < 0) {
                if (n11 < 0) {
                    n9 = n10 >= n11 ? n5 - n6 : n5 - n7;
                } else {
                    n4 = n10 + n11;
                    n9 = (n10 = -n10) <= n11 ? (n10 <= n4 ? n5 - n6 : n5 - n8) : (n11 <= -n4 ? n5 - n7 : n5 - n8);
                }
            } else {
                n9 = n11 < 0 ? (n10 <= (n11 = -n11) ? (n10 <= (n4 = n11 - n10) ? n5 - n6 : (n11 == n4 ? n5 - n7 : n5 - n8)) : (n11 <= (n4 = n10 - n11) ? n5 - n7 : n5 - n8)) : (n10 <= n11 ? n5 - n6 : n5 - n7);
            }
            byArray3[4][n3] = (byte)n9;
            nArray[4] = nArray[4] + (n9 >= 0 ? n9 : -n9);
        }
        n3 = 0;
        int n12 = nArray[0];
        for (int i = 1; i < 5; ++i) {
            if (nArray[i] >= n12) continue;
            n12 = nArray[i];
            n3 = i;
        }
        if (n3 == 0) {
            System.arraycopy(byArray, n2, byArray3[0], n2, n);
        }
        return n3;
    }

    public static class RGB
    extends PNGEncodeParam {
        private boolean a = false;
        private int[] b;
        private int[] c;

        @Override
        public void unsetBackground() {
            this.a = false;
        }

        @Override
        public boolean isBackgroundSet() {
            return this.a;
        }

        @Override
        public void setBitDepth(int n) {
            if (n != 8 && n != 16) {
                throw new RuntimeException();
            }
            this.bitDepth = n;
            this.bitDepthSet = true;
        }

        public void setBackgroundRGB(int[] nArray) {
            if (nArray.length != 3) {
                throw new RuntimeException();
            }
            this.b = nArray;
            this.a = true;
        }

        public int[] getBackgroundRGB() {
            if (!this.a) {
                throw new IllegalStateException("RGB background color has not been set");
            }
            return this.b;
        }

        public void setTransparentRGB(int[] nArray) {
            this.c = (int[])nArray.clone();
            this.v = true;
        }

        public int[] getTransparentRGB() {
            if (!this.v) {
                throw new IllegalStateException("Transparent RGB value has not been set.");
            }
            return (int[])this.c.clone();
        }
    }

    public static class Gray
    extends PNGEncodeParam {
        private boolean a = false;
        private int b;
        private int[] c;
        private int d;
        private boolean e = false;

        @Override
        public void unsetBackground() {
            this.a = false;
        }

        @Override
        public boolean isBackgroundSet() {
            return this.a;
        }

        @Override
        public void setBitDepth(int n) {
            if (n != 1 && n != 2 && n != 4 && n != 8 && n != 16) {
                throw new IllegalArgumentException();
            }
            this.bitDepth = n;
            this.bitDepthSet = true;
        }

        public void setBackgroundGray(int n) {
            this.b = n;
            this.a = true;
        }

        public int getBackgroundGray() {
            if (!this.a) {
                throw new IllegalStateException("Background gray level has not been set");
            }
            return this.b;
        }

        public void setTransparentGray(int n) {
            this.c = new int[1];
            this.c[0] = n;
            this.v = true;
        }

        public int getTransparentGray() {
            if (!this.v) {
                throw new IllegalStateException("Transparent gray value has not been set");
            }
            int n = this.c[0];
            return n;
        }

        public void setBitShift(int n) {
            if (n < 0) {
                throw new RuntimeException();
            }
            this.d = n;
            this.e = true;
        }

        public int getBitShift() {
            if (!this.e) {
                throw new IllegalStateException("Bit shift has not been set");
            }
            return this.d;
        }

        public void unsetBitShift() {
            this.e = false;
        }

        public boolean isBitShiftSet() {
            return this.e;
        }

        public boolean isBitDepthSet() {
            return this.bitDepthSet;
        }
    }

    public static class Palette
    extends PNGEncodeParam {
        private boolean a = false;
        private int[] b = null;
        private boolean c = false;
        private int d;
        private int[] e;

        @Override
        public void unsetBackground() {
            this.a = false;
        }

        @Override
        public boolean isBackgroundSet() {
            return this.a;
        }

        @Override
        public void setBitDepth(int n) {
            if (n != 1 && n != 2 && n != 4 && n != 8) {
                throw new IllegalArgumentException("Bit depth not equal to 1, 2, 4, or 8");
            }
            this.bitDepth = n;
            this.bitDepthSet = true;
        }

        public void setPalette(int[] nArray) {
            if (nArray.length < 3 || nArray.length > 768) {
                throw new IllegalArgumentException("Bad palette length");
            }
            if (nArray.length % 3 != 0) {
                throw new IllegalArgumentException("Not divisible by 3");
            }
            this.b = (int[])nArray.clone();
            this.c = true;
        }

        public int[] getPalette() {
            if (!this.c) {
                throw new IllegalStateException("RGB palette has not been set");
            }
            return (int[])this.b.clone();
        }

        public void unsetPalette() {
            this.b = null;
            this.c = false;
        }

        public boolean isPaletteSet() {
            return this.c;
        }

        public void setBackgroundPaletteIndex(int n) {
            this.d = n;
            this.a = true;
        }

        public int getBackgroundPaletteIndex() {
            if (!this.a) {
                throw new IllegalStateException("background palette index has not been set");
            }
            return this.d;
        }

        public void setPaletteTransparency(byte[] byArray) {
            this.e = new int[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                this.e[i] = byArray[i] & 0xFF;
            }
            this.v = true;
        }

        public byte[] getPaletteTransparency() {
            if (!this.v) {
                throw new IllegalStateException("Palette transparency has not been set");
            }
            byte[] byArray = new byte[this.e.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)this.e[i];
            }
            return byArray;
        }
    }
}

