/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.gui;

import ilog.views.appframe.swing.util.IlvButton;
import ilog.views.builder.gui.IlvHelpComponent;
import ilog.views.util.IlvImageUtil;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public abstract class IlvAbstractHelpComponent {
    private String a = "<html><font face=\"Arial\" SIZE=3>";
    private String b = "</font></html>";
    private Container c;
    private JComponent d;
    private AbstractButton e;
    private JEditorPane f;
    private URL g;
    protected String _helpText;

    public static Window getWindow(Component component) {
        if (component instanceof Window || component == null) {
            return (Window)component;
        }
        return IlvAbstractHelpComponent.getWindow(component.getParent());
    }

    protected static ImageIcon createIcon(Class clazz, String string) {
        try {
            return new ImageIcon(IlvImageUtil.loadImageFromFile(clazz, string));
        }
        catch (Exception exception) {
            System.err.println("Exception during load of icon: " + string + " for class: " + clazz);
            exception.printStackTrace();
            return null;
        }
    }

    protected IlvAbstractHelpComponent(Container container) {
        this.init(container);
    }

    protected IlvAbstractHelpComponent(Container container, URL uRL) {
        this.init(container);
        this.g = uRL;
    }

    protected Container getOwner() {
        return this.c;
    }

    public JComponent getHelpButton() {
        return this.e;
    }

    public JComponent getHelpComponent() {
        if (this.d == null) {
            this.d = this.createHelpContents();
            if (this.d == null) {
                this.e.setEnabled(false);
            } else {
                this.e.setEnabled(true);
            }
        }
        return this.d;
    }

    public void setHtmlLeadIn(String string) {
        this.a = string;
    }

    public String getHtmlLeadIn() {
        return this.a;
    }

    public void setHtmlLeadOut(String string) {
        this.b = string;
    }

    public String getHtmlLeadOut() {
        return this.b;
    }

    public void setHelpURL(URL uRL) throws IOException {
        this.g = uRL;
        if (this.f != null) {
            this.f.setPage(this.g);
        }
    }

    public void setHelpText(String string) {
        this._helpText = string;
        if (this.f != null) {
            boolean bl = string.toLowerCase().startsWith("<html>");
            if (bl) {
                int n = string.length();
                if (string.endsWith("</html>")) {
                    n = string.length() - 7;
                }
                string = this.a + string.substring(6, n) + this.b;
            }
            this.f.setContentType(bl ? "text/html" : "text/plain");
            this.f.setText(string);
        }
    }

    protected JEditorPane createEditorPane(URL uRL) throws IOException {
        JEditorPane jEditorPane = new JEditorPane(uRL);
        jEditorPane.setEditable(false);
        return jEditorPane;
    }

    private JEditorPane a(String string) {
        JEditorPane jEditorPane = null;
        if (string != null) {
            boolean bl = string.toLowerCase().startsWith("<html>");
            if (bl) {
                int n = string.length();
                if (string.endsWith("</html>")) {
                    n = string.length() - 7;
                }
                string = this.a + string.substring(6, n) + this.b;
            }
            jEditorPane = new JEditorPane(bl ? "text/html" : "text/plain", string);
        } else {
            jEditorPane = new JEditorPane();
        }
        jEditorPane.setEditable(false);
        return jEditorPane;
    }

    protected JComponent createHelpContents() {
        try {
            this.f = this.g != null ? this.createEditorPane(this.g) : this.a(this._helpText);
            JScrollPane jScrollPane = new JScrollPane(this.f, 20, 30);
            return jScrollPane;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void init(Container container) {
        ResourceBundle resourceBundle = IlvResourceUtil.getBundle("ilog.views.builder.gui.messages", IlvLocaleUtil.getCurrentLocale(), this.getClass().getClassLoader());
        ImageIcon imageIcon = IlvAbstractHelpComponent.createIcon(IlvHelpComponent.class, resourceBundle.getString("IlvHelpComponent.button.icon"));
        this.c = container;
        this._helpText = null;
        this.g = null;
        this.d = null;
        this.a = resourceBundle.getString("IlvHelpComponent.html.LeadIn");
        this.b = resourceBundle.getString("IlvHelpComponent.html.LeadOut");
        this.e = new IlvButton(imageIcon);
        this.e.setMargin(new Insets(0, 0, 0, 0));
        this.e.setToolTipText(resourceBundle.getString("IlvHelpComponent.button.tooltip"));
        this.registerHelpButtonListener(this.e);
    }

    protected void registerHelpButtonListener(AbstractButton abstractButton) {
        abstractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvAbstractHelpComponent.this.setHelpPanelVisible(true);
            }
        });
    }

    public abstract void setHelpPanelVisible(boolean var1);
}

