/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.diagram.measure;

import ilog.views.IlvGrapher;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayout;
import ilog.views.interactor.IlvSelectInteractor;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.renderer.IlvSDMRenderer;
import ilog.views.swing.IlvPopupMenuManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.diagram.core.manager.CoreGrapher;
import oracle.diagram.sdm.node.SDMEngineNode;
import oracle.ide.Context;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.CalcReferences;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.diagram.AbstractOLAPDiagram;
import oracle.olap.diagram.AbstractOLAPDiagramNode;
import oracle.olap.diagram.ManagerViewReadyCallback;
import oracle.olap.diagram.measure.MeasureDependenciesDiagramContextMenu;
import oracle.olap.diagram.measure.MeasureDependenciesDiagramModel;
import oracle.olap.diagram.measure.MeasureDependenciesDiagramRenderer;
import oracle.olap.diagram.measure.MeasureLink;
import oracle.olap.diagram.measure.MeasureNode;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;

public class MeasureDependenciesDiagram
extends AbstractOLAPDiagram {
    private IlvGraphLayout layout;
    private IlvSDMEngine engine;
    private Context context;
    private CalculatedMeasureNode calcNode;
    private Schema schema;
    private OLAPISyntaxParser parser;
    private AnalyticWorkspace aw;
    private MeasureDependenciesDiagramModel model = new MeasureDependenciesDiagramModel();
    private ManagerViewReadyCallback callback;
    private static final float INIT_POS = 100.0f;
    private static final String ADDED_BY_DEPENDENCY = "addedByDependency";
    private static final String POPUPMENU = "diagrammenu";
    private boolean fullDiagram;

    public MeasureDependenciesDiagram() {
        try {
            this.initDiagram();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setManagerViewCallback(ManagerViewReadyCallback managerViewReadyCallback) {
        this.callback = managerViewReadyCallback;
    }

    private void initDiagram() throws Exception {
        SDMEngineNode sDMEngineNode = new SDMEngineNode();
        this.engine = sDMEngineNode.getEngine();
        this.engine.setGrapher((IlvGrapher)new CoreGrapher());
        this.engine.setRenderer((IlvSDMRenderer)new MeasureDependenciesDiagramRenderer());
        IlvHierarchicalLayout ilvHierarchicalLayout = new IlvHierarchicalLayout();
        ilvHierarchicalLayout.setBacktrackCrossingReductionEnabled(true);
        ilvHierarchicalLayout.setGlobalLinkStyle(2);
        this.setDiagramLayout((IlvGraphLayout)ilvHierarchicalLayout);
        IlvPopupMenuManager.registerMenu((String)POPUPMENU, (JPopupMenu)MeasureDependenciesDiagramContextMenu.getInstance().getMenu());
    }

    @Override
    protected Object findOrCreateGraphSystemFromContext(Context context) throws Exception {
        this.context = context;
        this.initSchemaData();
        return this.engine;
    }

    private void initSchemaData() throws Exception {
        this.calcNode = (CalculatedMeasureNode)this.context.getNode();
        this.schema = OLAPMetadataCache.getUpdatedSchema(this.calcNode.getConnectionName(), this.calcNode.getSchemaName());
        this.parser = new OLAPISyntaxParser(this.schema, new Properties());
        this.aw = new AnalyticWorkspace();
        this.aw.setCubes(this.schema.getCubes());
    }

    private void populateContextMeasureDependenciesModel() {
        AbstractOLAPDiagramNode abstractOLAPDiagramNode;
        Object object;
        Measure measure = this.schema.findCube(this.calcNode.getCubeName()).findMeasure(this.calcNode.getMeasureName());
        List<Measure> list = CalcReferences.getReferences(measure, this.parser, this.aw);
        MeasureNode measureNode = this.createNode(measure, false);
        this.model.addObjectImpl((Object)measureNode, null, null);
        for (Measure object22 : list) {
            boolean measure2 = !object22.getCube().getName().equals(this.calcNode.getCubeName());
            object = measure2 ? String.format("%s.%s", object22.getCube().getName(), object22.getName()) : object22.getName();
            if (this.model.getObject((String)object) != null) continue;
            abstractOLAPDiagramNode = this.createNode(object22, measure2);
            this.model.addObjectImpl((Object)abstractOLAPDiagramNode, null, null);
            MeasureLink measureLink = new MeasureLink(abstractOLAPDiagramNode, measureNode);
            this.model.addObjectImpl((Object)measureLink, null, null);
        }
        List<Measure> list2 = CalcReferences.getDependencies(this.aw, this.calcNode.getCubeName(), measure.getName(), this.parser);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Measure measure2 = (Measure)iterator.next();
            object = this.createNode(measure2, false);
            this.model.addObjectImpl(object, null, null);
            abstractOLAPDiagramNode = new MeasureLink(measureNode, (AbstractOLAPDiagramNode)((Object)object));
            this.model.addObjectImpl((Object)abstractOLAPDiagramNode, null, null);
        }
    }

    private MeasureNode createNode(Measure measure, boolean bl) {
        MeasureNode measureNode = new MeasureNode(this, measure);
        measureNode.setIncludeCubeName(bl);
        if (bl) {
            measureNode.setID(String.format("%s.%s", measure.getCube().getName(), measure.getName()));
            measureNode.setName(String.format("%s.%s", measure.getCube().getName(), measure.getName()));
        } else {
            measureNode.setID(measure.getName());
            measureNode.setName(measure.getName());
        }
        measureNode.setProperty("tooltip", String.format("<html><center>%s</center></html>", measureNode.getFullDisplayLabel().replace("\n", "<br>")));
        measureNode.setProperty("x", Float.valueOf(100.0f));
        measureNode.setProperty("y", Float.valueOf(100.0f));
        try {
            measureNode.setProperty("connection", Connections.getInstance().getConnection(this.calcNode.getConnectionName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return measureNode;
    }

    public void open() {
        super.open();
        this.populateContextMeasureDependenciesModel();
        this.engine.setModel((IlvSDMModel)this.model);
        this.engine.loadData();
        this.layoutDiagram();
    }

    public void setDiagramLayout(IlvGraphLayout ilvGraphLayout) {
        this.layout = ilvGraphLayout;
        ilvGraphLayout.attach(this.engine.getGrapher());
    }

    public void layoutDiagram() {
        try {
            this.layout.performLayout();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void populateFullCubeMeasureDependenciesModel() {
        MeasureNode measureNode;
        Cube cube = this.schema.findCube(this.calcNode.getCubeName());
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        for (Measure measure : cube.getMeasures()) {
            if (measure.isDerived()) continue;
            arrayList.add(measure);
        }
        for (Measure measure : arrayList) {
            measureNode = this.createNode(measure, false);
            this.model.addObjectImpl((Object)measureNode, null, null);
        }
        for (Measure measure : arrayList) {
            measureNode = (MeasureNode)((Object)this.model.getObject(measure.getName()));
            List<Measure> list = CalcReferences.getDependencies(this.aw, cube.getName(), measureNode.getName(), this.parser);
            for (Measure measure2 : list) {
                MeasureNode measureNode2 = null;
                if (this.model.getObject(measure2.getName()) != null) {
                    var10_10 = (MeasureNode)((Object)this.model.getObject(measure2.getName()));
                    if (var10_10.getProperty(ADDED_BY_DEPENDENCY) == null) {
                        MeasureLink measureLink = new MeasureLink(measureNode, var10_10);
                        this.model.addObjectImpl((Object)measureLink, null, null);
                    }
                } else {
                    measureNode2 = this.createNode(measure2, false);
                    this.model.addObjectImpl((Object)measureNode2, null, null);
                    var10_10 = new MeasureLink(measureNode, measureNode2);
                    this.model.addObjectImpl((Object)var10_10, null, null);
                }
                if (measureNode2 == null) continue;
                this.addCurrentNodeDependencies(measure2, this.aw, this.calcNode.getCubeName(), this.parser);
            }
        }
    }

    private void addCurrentNodeDependencies(Measure measure, AnalyticWorkspace analyticWorkspace, String string, OLAPISyntaxParser oLAPISyntaxParser) {
        Stack<Measure> stack = new Stack<Measure>();
        stack.push(measure);
        while (!stack.isEmpty()) {
            Measure measure2 = (Measure)stack.pop();
            MeasureNode measureNode = (MeasureNode)((Object)this.model.getObject(measure2.getName()));
            List<Measure> list = CalcReferences.getDependencies(analyticWorkspace, string, measure2.getName(), oLAPISyntaxParser);
            for (Measure measure3 : list) {
                if (this.model.getObject(measure3.getName()) != null) {
                    var11_11 = (MeasureNode)((Object)this.model.getObject(measure3.getName()));
                    var12_12 = new MeasureLink(measureNode, var11_11);
                    this.model.addObjectImpl((Object)var12_12, null, null);
                } else {
                    var11_11 = this.createNode(measure3, false);
                    var11_11.setProperty(ADDED_BY_DEPENDENCY, true);
                    this.model.addObjectImpl((Object)var11_11, null, null);
                    var12_12 = new MeasureLink(measureNode, var11_11);
                    this.model.addObjectImpl((Object)var12_12, null, null);
                }
                stack.push(measure3);
            }
        }
    }

    protected IlvManagerView createManagerView(IlvManager ilvManager) {
        IlvManagerView ilvManagerView = super.createManagerView(ilvManager);
        IlvSelectInteractor ilvSelectInteractor = new IlvSelectInteractor();
        ilvSelectInteractor.setDragAllowed(true);
        ilvSelectInteractor.setMoveAllowed(true);
        ilvSelectInteractor.setMultipleSelectionMode(true);
        ilvManagerView.setInteractor((IlvManagerViewInteractor)ilvSelectInteractor);
        ilvManagerView.setZoomFactorRange(0.5, 1.5);
        this.callback.setManagerView(ilvManagerView);
        this.callback.registerViewToPopupManager(ilvManagerView);
        return ilvManagerView;
    }

    public void switchDiagram(final boolean bl) {
        this.fullDiagram = bl;
        this.engine.getModel().clear();
        String string = OLAPArb.getString("CALCULATED_MEASURES_LOADING_DIAGRAM");
        RaptorTask raptorTask = new RaptorTask(string, true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl2 = Boolean.TRUE;
                if (bl) {
                    MeasureDependenciesDiagram.this.populateFullCubeMeasureDependenciesModel();
                } else {
                    MeasureDependenciesDiagram.this.populateContextMeasureDependenciesModel();
                }
                return bl2;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        Logger.getLogger(this.getClass().getName()).severe(throwable.toString());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MeasureDependenciesDiagram.this.engine.loadData();
                        MeasureDependenciesDiagram.this.layoutDiagram();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
    }

    public void refreshDiagram() {
        try {
            this.initSchemaData();
            this.switchDiagram(this.fullDiagram);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isFullDiagram() {
        return this.fullDiagram;
    }
}

