/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubeviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.editors.RaptorEditorPlugin;
import oracle.dbtools.raptor.editors.WorksheetEditorPluginRegistry;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.folding.WorksheetFoldingPlugin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.config.Preferences;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.DragDropPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.table.Query;
import oracle.olap.app.table.QueryTableModel;
import oracle.olap.app.table.TablePacker;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.app.util.CursorUtil;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.context.ContextUtil;
import oracle.olap.cubeviewer.CubeDataSource;
import oracle.olap.cubeviewer.CubeDimensionConditionPanel;
import oracle.olap.cubeviewer.CubeGraphDataViewerPanel;
import oracle.olap.cubeviewer.CubeMeasureSelectionPanel;
import oracle.olap.cubeviewer.CubeTable;
import oracle.olap.data.CubeMetadataContext;
import oracle.olap.db.LanguageDBSettings;
import oracle.olap.preferences.OLAPPreferenceSettings;
import oracle.olap.util.LanguageSelector;
import oracle.olap.util.LanguageSelectorPanel;
import oracle.olap.util.LineNumberTableRowHeader;

public class CubeDataViewerPanel
extends JPanel
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(CubeDataViewerPanel.class.getName());
    private JDialog window;
    private final HelpProvider helpProvider;
    private CubeMetadataContext cubeMetadataContext;
    private QueryTableModel cubeTableModel;
    private CubeTable cubeDataTable;
    private ResultSetTable cubeDataRaptorTable;
    private boolean useRaptorTable;
    private JLabel resultsLabel;
    private BasicEditorPane queryEditor;
    private JButton editQueryButton;
    private JButton runButton;
    private List<RaptorEditorPlugin> installedPlugins;
    private CompletionInsight insightPlugin;
    private WorksheetFoldingPlugin foldingPlugin;
    private CubeMeasureSelectionPanel measureSelectionPanel;
    private CubeDimensionConditionPanel dimCondPanel;
    private CubeGraphDataViewerPanel graphPanel;
    private JScrollPane cubeDataTableScrollPane;
    private boolean queryChanged;
    private List<String> languages;
    private String defaultLanguage;
    private LanguageSelectorPanel languagePanel;

    public CubeDataViewerPanel(JDialog jDialog, HelpProvider helpProvider, CubeMetadataContext cubeMetadataContext) throws SQLException, IOException {
        this(jDialog, helpProvider, cubeMetadataContext, Collections.EMPTY_LIST, null);
    }

    public CubeDataViewerPanel(JDialog jDialog, HelpProvider helpProvider, CubeMetadataContext cubeMetadataContext, List<DimensionHierarchy> list, List<String> list2) throws SQLException, IOException {
        this.window = jDialog;
        this.helpProvider = helpProvider;
        this.cubeMetadataContext = cubeMetadataContext;
        this.languages = list2;
        this.useRaptorTable = true;
        Preferences preferences = Preferences.getPreferences();
        OLAPPreferenceSettings oLAPPreferenceSettings = OLAPPreferenceSettings.getInstance((PropertyStorage)preferences);
        int n = oLAPPreferenceSettings.getCubeDataViewerMaxRows();
        OLAPResources oLAPResources = new OLAPResources("/oracle/olap/cubeviewer/dimcondition.xml");
        FetchIcon fetchIcon = null;
        this.dimCondPanel = new CubeDimensionConditionPanel(cubeMetadataContext, oLAPResources, fetchIcon);
        this.measureSelectionPanel = new CubeMeasureSelectionPanel(cubeMetadataContext);
        this.graphPanel = new CubeGraphDataViewerPanel();
        this.graphPanel.setName("graphPanel");
        try {
            this.defaultLanguage = LanguageDBSettings.getDefaultLanguage();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        this.languagePanel = new LanguageSelectorPanel(new LanguageSelector(){

            @Override
            public void languageSelectionChanged(String string) {
                try {
                    LanguageDBSettings.setLanguage(string);
                    CubeDataViewerPanel.this.runQuery();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.languagePanel.setVisible(false);
        try {
            if (list2 != null && !list2.isEmpty()) {
                this.languagePanel.addLanguage(LanguageDBSettings.getDefaultLanguage());
                for (String string : list2) {
                    this.languagePanel.addLanguage(string);
                }
                this.languagePanel.setVisible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.layoutComponents();
        this.dimCondPanel.addPropertyChangeListener(this);
        this.measureSelectionPanel.addPropertyChangeListener(this);
        String string = this.dimCondPanel.getQuery();
        this.queryEditor.setText(string);
        this.queryEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CubeDataViewerPanel.this.queryChanged = true;
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CubeDataViewerPanel.this.queryChanged = true;
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CubeDataViewerPanel.this.queryChanged = true;
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CubeDataViewerPanel.this.runQuery();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            String string = this.dimCondPanel.getQuery();
            this.queryEditor.setText(string);
            this.queryChanged = true;
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
    }

    private void editQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuery() {
        try {
            CursorUtil.setBusyCursor(this);
            String string = this.queryEditor.getText();
            Query query = new Query();
            query.setText(string);
            CubeDataSource cubeDataSource = null;
            if (this.useRaptorTable) {
                String string2 = this.cubeMetadataContext.getDatabase().getQualifiedName();
                this.cubeDataRaptorTable.setQuery(string2, string, null, null);
                this.cubeDataRaptorTable.refresh();
                this.cubeDataRaptorTable.allRowsFetched();
                cubeDataSource = new CubeDataSource(this.cubeMetadataContext.getCube(), this.cubeDataRaptorTable.getModel());
            } else {
                this.cubeTableModel = new QueryTableModelReadOnly(this.cubeMetadataContext.getDatabase().getConnection(), query, null);
                this.resultsLabel.setText("");
                this.cubeTableModel.populateQueryTableDataModel();
                String string3 = this.cubeTableModel.getQueryResultStatistics().getElapsedTime();
                int n = this.cubeTableModel.getQueryResultStatistics().getRowCount();
                this.resultsLabel.setText(OLAPArb.format("CUBE_DATA_VIEWER_RESULTS", string3, n));
                this.cubeDataTable.setModel(this.cubeTableModel);
                cubeDataSource = new CubeDataSource(this.cubeMetadataContext.getCube(), this.cubeTableModel);
            }
            this.graphPanel.setDataSource(cubeDataSource);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        finally {
            CursorUtil.setDefaultCursor(this);
        }
    }

    public void closeTableModel() {
        if (this.cubeDataRaptorTable != null) {
            this.cubeDataRaptorTable.closeModel();
        }
    }

    public void cleanUp() throws Exception {
        this.closeTableModel();
        LanguageDBSettings.setLanguage(this.defaultLanguage);
    }

    public void packTable() {
        TablePacker tablePacker = new TablePacker();
        tablePacker.pack((JTable)((Object)this.cubeDataTable));
    }

    private void layoutComponents() {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        JScrollPane jScrollPane;
        this.cubeDataRaptorTable = new ResultSetTable();
        KeyStrokeContext[] keyStrokeContextArray = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/worksheet/editor/accelerators.xml")};
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        EditorStatusBar editorStatusBar = new EditorStatusBar();
        JPanel jPanel = null;
        boolean bl = true;
        if (bl) {
            this.queryEditor = EditorFactory.createIdeEditorPane((KeyStrokeContext[])keyStrokeContextArray);
            this.queryEditor.setEditable(bl);
            this.foldingPlugin = new WorksheetFoldingPlugin();
            if (this.queryEditor.isEditable()) {
                jScrollPane = null;
                object4 = jScrollPane != null ? new BasicDocument("foo.plsql", (TextBuffer)jScrollPane) : new BasicDocument("foo.plsql");
                this.queryEditor.setDocument((Document)object4);
                if (this.insightPlugin != null) {
                    this.queryEditor.deinstallPlugin((EditorPlugin)this.insightPlugin);
                }
                if (Ide.getLastActiveNavigator() != null) {
                    object3 = Ide.getLastActiveNavigator().getContext();
                    object22 = ContextUtil.getConnectionName(object3);
                    if (object22 == null) {
                        object22 = this.cubeMetadataContext.getDatabase().getConnectionName();
                    }
                    this.insightPlugin = new CompletionInsight((String)object22, this.foldingPlugin.parser);
                    this.queryEditor.installPlugin((EditorPlugin)this.insightPlugin);
                }
            }
            this.queryEditor.installPlugin((EditorPlugin)new LineHighlightPlugin());
            this.queryEditor.installPlugin((EditorPlugin)lineGutterPlugin);
            if (this.queryEditor.isEditable()) {
                this.queryEditor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
                this.queryEditor.installPlugin((EditorPlugin)editorStatusBar);
            }
            jScrollPane = new HighlightEditorPlugin(this.queryEditor, null, null);
            if (Ide.getLastActiveNavigator() != null) {
                object4 = Ide.getLastActiveNavigator().getContext();
                if (this.queryEditor.isEditable()) {
                    for (Object object22 : WorksheetEditorPluginRegistry.getPlugins((Context)object4)) {
                        this.queryEditor.installPlugin((EditorPlugin)object22);
                        if (!(object22 instanceof RaptorEditorPlugin)) continue;
                        object = (RaptorEditorPlugin)object22;
                        object.setLineGutter(lineGutterPlugin);
                        this.installedPlugins.add((RaptorEditorPlugin)object);
                    }
                    object3 = new DragDropPlugin(){

                        protected void removeSelectedText() {
                        }
                    };
                    this.queryEditor.installPlugin((EditorPlugin)object3);
                }
            }
            if (this.queryEditor.isEditable()) {
                jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)lineGutterPlugin, "Center");
            }
        } else {
            this.queryEditor = new BasicEditorPane();
            this.queryEditor.setEditable(false);
        }
        jScrollPane = new JScrollPane((Component)this.queryEditor);
        if (jPanel != null) {
            jScrollPane.setRowHeaderView(jPanel);
        }
        this.cubeDataTable = new CubeTable();
        this.cubeDataTable.setName("cubeDataTable");
        this.cubeDataTable.setFont(new Font("Monospaced", 0, 12));
        this.cubeDataTable.setAutoResizeMode(0);
        this.cubeDataTableScrollPane = new JScrollPane((Component)((Object)this.cubeDataTable));
        this.cubeDataTableScrollPane.setName("cubeDataTableScrollPane");
        object4 = new LineNumberTableRowHeader(this.cubeDataTableScrollPane, (JTable)((Object)this.cubeDataTable));
        ((JComponent)object4).setBackground(Color.WHITE);
        this.cubeDataTableScrollPane.setRowHeaderView((Component)object4);
        if (this.useRaptorTable) {
            this.cubeDataTableScrollPane = new JScrollPane((Component)this.cubeDataRaptorTable);
            object4 = new LineNumberTableRowHeader(this.cubeDataTableScrollPane, (JTable)this.cubeDataRaptorTable);
            ((JComponent)object4).setBackground(Color.WHITE);
            this.cubeDataTableScrollPane.setRowHeaderView((Component)object4);
        }
        this.runButton = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_RUN_BUTTON_TEXT")));
        this.runButton.setName("runButton");
        this.runButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_RUN_BUTTON_TEXT")));
        this.editQueryButton = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_EDIT_BUTTON_TEXT")));
        this.editQueryButton.setName("editQueryButton");
        this.editQueryButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_EDIT_BUTTON_TEXT")));
        this.resultsLabel = new JLabel();
        this.resultsLabel.setName("resultsLabel");
        object3 = new ButtonBar(1);
        object3.setName("bb");
        object3.add((Component)this.runButton);
        object22 = new JTabbedPane();
        ((Component)object22).setName("queryTab");
        ((JComponent)object22).setBorder(null);
        object = new JPanel();
        ((Component)object).setName("topPane");
        ((Container)object).setLayout(new GridBagLayout());
        int n = 0;
        ((Container)object).add((Component)this.languagePanel, new GridBagConstraints(0, n, 1, 1, 0.5, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        ((Container)object).add((Component)object22, new GridBagConstraints(0, n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 5, 0));
        ((Container)object).add((Component)this.resultsLabel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 5, 0));
        boolean bl2 = false;
        if (bl2) {
            ((Container)object).add((Component)object3, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 0, 0, 0), 5, 5));
        }
        n = 0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("bottomPane");
        jPanel2.setLayout(new GridBagLayout());
        boolean bl3 = false;
        final JTabbedPane jTabbedPane = new JTabbedPane();
        if (bl3) {
            jTabbedPane.setName("dataTabPane");
            jTabbedPane.add(OLAPArb.format("CUBE_DATA_VIEWER_GRAPH_TAB", new Object[0]), this.graphPanel);
            jTabbedPane.add(OLAPArb.format("CUBE_DATA_VIEWER_DATA_TAB", new Object[0]), this.cubeDataTableScrollPane);
            jPanel2.add((Component)jTabbedPane, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 5, 0));
            JSplitPane jSplitPane = new JSplitPane(0, (Component)object, jPanel2);
            jSplitPane.setName("querySplitPane");
            this.setLayout(new GridBagLayout());
            n = 0;
            JLabel jLabel = new JLabel(OLAPArb.get("CUBE_DATA_VIEWER_HEADER"));
            jLabel.setName("headerLabel");
            this.add((Component)jSplitPane, new GridBagConstraints(0, n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
            jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (jTabbedPane.getSelectedComponent() == CubeDataViewerPanel.this.cubeDataTableScrollPane) {
                        CubeDataViewerPanel.this.packTable();
                    }
                }
            });
        } else {
            ((JTabbedPane)object22).add(OLAPArb.format("CUBE_DATA_VIEWER_GRAPH_TAB", new Object[0]), this.graphPanel);
            ((JTabbedPane)object22).add(OLAPArb.format("CUBE_DATA_VIEWER_DATA_TAB", new Object[0]), this.cubeDataTableScrollPane);
            this.setLayout(new GridBagLayout());
            n = 0;
            JLabel jLabel = new JLabel(OLAPArb.get("CUBE_DATA_VIEWER_HEADER"));
            jLabel.setName("headerLabel");
            this.add((Component)object, new GridBagConstraints(0, n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        }
        ((JTabbedPane)object22).add(OLAPArb.get("CUBE_MEASURES"), this.measureSelectionPanel);
        this.measureSelectionPanel.setPreferredSize(new Dimension(200, 200));
        ((JTabbedPane)object22).add(OLAPArb.get("CUBE_QUERY_DIMENSION_TAB"), this.dimCondPanel);
        this.dimCondPanel.setPreferredSize(new Dimension(200, 200));
        ((JTabbedPane)object22).add(OLAPArb.get("CUBE_QUERY_QUERY_TAB"), jScrollPane);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        ((JTabbedPane)object22).addChangeListener(new ChangeListener(){
            final /* synthetic */ JTabbedPane val$queryTab;
            {
                this.val$queryTab = jTabbedPane;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (CubeDataViewerPanel.this.queryChanged && (this.val$queryTab.getSelectedComponent() == CubeDataViewerPanel.this.cubeDataTableScrollPane || this.val$queryTab.getSelectedComponent() == CubeDataViewerPanel.this.graphPanel)) {
                    if (CubeDataViewerPanel.this.measureSelectionPanel.getSelectedMeasuresCount() > 0) {
                        CubeDataViewerPanel.this.runQuery();
                        CubeDataViewerPanel.this.queryChanged = false;
                    } else {
                        JOptionPane.showMessageDialog(CubeDataViewerPanel.this, OLAPArb.getString("CUBE_DATA_VIEWER_NO_MEASURES_SELECTED_ERROR_MSG"), OLAPArb.getString("CUBE_DATA_VIEWER_NO_MEASURES_SELECTED_ERROR_TITLE"), 0);
                        this.val$queryTab.setSelectedComponent(CubeDataViewerPanel.this.measureSelectionPanel);
                    }
                }
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                List<Measure> list = CubeDataViewerPanel.this.cubeMetadataContext.getMeasures();
                for (Measure object : list) {
                    if (!object.isSelected()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    CubeDataViewerPanel.this.runQuery();
                    if (jTabbedPane.getSelectedComponent() == CubeDataViewerPanel.this.cubeDataTableScrollPane) {
                        CubeDataViewerPanel.this.packTable();
                    }
                } else {
                    String string = OLAPArb.get("CUBE_DATA_VIEWER_NO_MEASURES_SELECTED_ERROR_MSG");
                    String string2 = OLAPArb.get("CUBE_DATA_VIEWER_ERROR_TITLE");
                    String string3 = null;
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string2, string3);
                }
            }
        });
        this.editQueryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeDataViewerPanel.this.editQuery();
            }
        });
    }

    static class QueryTableModelReadOnly
    extends QueryTableModel {
        public QueryTableModelReadOnly(Connection connection, Query query, Map<String, Object> map) {
            super(connection, query, map);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

