/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.panels.aggregation.AggregationBuilder;
import oracle.olap.cube.panels.aggregation.AggregationBuilderPanel;
import oracle.olap.cube.panels.aggregation.AggregationHierarchyPanel;
import oracle.olap.cube.panels.aggregation.AggregationOperatorPanel;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.db.view.DimensionTree;
import oracle.olap.ddl.CubeDDLSupport;
import oracle.olap.syntax.AggregationOperatorMap;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.syntax.SolveSyntax;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;

public class CubeAggregationPanel
extends BaseEditorPanel<Cube> {
    private static final Logger LOG = Logger.getLogger(CubeAggregationPanel.class.getName());
    protected static final int USE_BUILDER = 2;
    protected static final int USE_TABLE = 0;
    protected static final int USE_ORDERED_LIST = 1;
    protected AggregationOperatorPanel aggregationOperatorPanel;
    protected AggregationHierarchyPanel aggregationHierarchyPanel;
    protected List<CubeAggregationDimension> cubeAggregationDimensions;
    protected AggregationBuilderPanel aggregationBuilder;
    protected SyntaxBuilderPanel syntaxBuilder;
    private AggregationBuilder aggBuilder;

    public CubeAggregationPanel() {
        this.setLayout(new GridBagLayout());
        int n = this.getBuilderSetting();
        if (n == 1) {
            this.aggregationBuilder = new AggregationBuilderPanel();
        } else if (n == 2) {
            this.aggBuilder = new AggregationBuilder();
            try {
                this.syntaxBuilder = this.aggBuilder.createBuilder();
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Error instantiating AggregationBuilder", exception);
            }
        } else if (n == 0) {
            this.cubeAggregationDimensions = new ArrayList<CubeAggregationDimension>();
            this.aggregationOperatorPanel = new AggregationOperatorPanel();
            this.aggregationOperatorPanel.setName("aggregationOperatorPanel");
            this.aggregationHierarchyPanel = new AggregationHierarchyPanel();
            this.aggregationHierarchyPanel.setName("aggregationHierarchyPanel");
            this.aggregationOperatorPanel.addPropertyChangeListener(this.aggregationOperatorPanel);
            this.aggregationOperatorPanel.addPropertyChangeListener(this.aggregationHierarchyPanel);
            this.aggregationHierarchyPanel.addPropertyChangeListener(this.aggregationOperatorPanel);
        }
        this.layoutComponents(0);
    }

    protected int getBuilderSetting() {
        return 2;
    }

    protected void initialisePanel() {
        Cube cube = (Cube)this.getUpdatedObject();
        DBObjectProvider dBObjectProvider = this.getProvider();
        String string = cube.getConsistentSolveSpec();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        int n = this.getBuilderSetting();
        if (n == 0) {
            Object object;
            AggregationOperatorMap aggregationOperatorMap = this.aggregationOperatorPanel.getAggregationOperatorMap();
            int n2 = 0;
            this.cubeAggregationDimensions = new ArrayList<CubeAggregationDimension>();
            if (string != null) {
                object = this.getDataContext().get("dimensions");
                this.cubeAggregationDimensions = SolveSyntax.getInstance().fromSyntax(cube, cube.getDimensionMap(object), dBObjectProvider, string);
            } else {
                object = this.getDataContext().get("dimensions");
                for (CubeDimension cubeDimension : cube.getDimensions(object)) {
                    String string2 = cubeDimension.getName();
                    CubeAggregationDimension cubeAggregationDimension = new CubeAggregationDimension(cube, string2);
                    cubeAggregationDimension.setAggregationOrder(++n2);
                    this.cubeAggregationDimensions.add(cubeAggregationDimension);
                }
            }
            object = this.getDataContext().get("dimensions");
            this.aggregationOperatorPanel.initialisePanel(oracleDatabaseImpl, (Cube)this.getUpdatedObject(), object, this.cubeAggregationDimensions);
            Object object2 = this.getDataContext().get("dimensions");
            this.aggregationHierarchyPanel.initialisePanel((Cube)this.getUpdatedObject(), object2, this.cubeAggregationDimensions);
        } else if (n == 1) {
            try {
                String string3 = Connections.getInstance().getConnectionName((Database)oracleDatabaseImpl);
                Schema schema = OLAPMetadataCache.getUpdatedSchema(string3, ((Cube)this.getUpdatedObject()).getSchema().getName());
                this.aggregationBuilder.initializePanel(schema, cube.getName(), oracleDatabaseImpl.getConnection());
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Error initializing AggregationBuilder", exception);
            }
        } else if (n == 2) {
            Object object = this.getDataContext().get("dimensions");
            this.aggBuilder.initialize(oracleDatabaseImpl.getConnection(), cube, object);
        }
    }

    protected void commitPanel() throws TraversalException {
        Cube cube = (Cube)this.getUpdatedObject();
        Cube cube2 = (Cube)this.getOriginalObject();
        String string = null;
        String string2 = null;
        if (cube2 != null) {
            string2 = cube2.getConsistentSolveSpec();
        }
        string = this.getConsistentSolveSpec(string2);
        cube.setConsistentSolveSpec(string);
    }

    protected String getConsistentSolveSpec(String string) throws TraversalException {
        Object object;
        DimensionTree dimensionTree;
        Object object2;
        int n = this.getBuilderSetting();
        String string2 = null;
        DBObjectProvider dBObjectProvider = this.getProvider();
        String string3 = CubeDDLSupport.getDatabaseCompatibleLevel(dBObjectProvider);
        Cube cube = (Cube)this.getUpdatedObject();
        if (n == 1) {
            string2 = this.aggregationBuilder.getExpression();
        } else if (n == 2) {
            object2 = String.format("SOLVE(%s)", this.syntaxBuilder.getSyntax());
            string2 = object2;
        } else if (n == 0) {
            object2 = this.getProvider();
            dimensionTree = this.aggregationHierarchyPanel.getDimensionHierarchyTree();
            this.cubeAggregationDimensions = this.aggregationOperatorPanel.getAggregationDimensions();
            object = this.getDataContext().get("dimensions");
            string2 = SolveSyntax.getInstance().toSyntax(cube, cube.getDimensionMap(object), (DBObjectProvider)object2, this.cubeAggregationDimensions);
        }
        object2 = new ArrayList();
        try {
            object2 = SolveSyntax.getInstance().fromSyntax(cube, string2);
        }
        catch (SyntaxException syntaxException) {
            object = OLAPArb.format("CUBE_VALIDATE_AGGRULES_SYNTAX_ERROR", string2);
            object = (String)object + "  " + syntaxException.getLocalizedMessage();
            throw new TraversalException((String)object);
        }
        catch (Exception exception) {
            object = OLAPArb.format("CUBE_VALIDATE_AGGRULES_SYNTAX_ERROR", string2);
            object = (String)object + "  " + exception.getLocalizedMessage();
            throw new TraversalException((String)object);
        }
        if (string != null) {
            dimensionTree = SyntaxObject.fromSyntax((String)string, null);
            object = SyntaxObject.fromSyntax((String)string2, null);
            if (dimensionTree.toSyntax().equals(object.toSyntax())) {
                if (string3.startsWith("12.2")) {
                    if (string.equals(string2)) {
                        string2 = string;
                    }
                } else {
                    string2 = string;
                }
            }
        }
        return string2;
    }

    protected void layoutComponents(int n) {
        int n2 = this.getBuilderSetting();
        JLabel jLabel = new JLabel(OLAPArb.get("AGGREGATION.RULES.DESC"));
        jLabel.setName("aggOperatorLabel");
        this.add(jLabel, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        if (n2 == 1) {
            this.add(this.aggregationBuilder, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
        } else if (n2 == 2) {
            this.add(this.syntaxBuilder, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
        } else if (n2 == 0) {
            this.add(this.aggregationOperatorPanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
            JLabel jLabel2 = new JLabel(OLAPArb.get("AGGREGATION.RULES.HIER.DESC"));
            jLabel2.setName("aggHierarchyLabel");
            this.add(jLabel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add(this.aggregationHierarchyPanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
        }
    }
}

