/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Internal;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeBuildCommand;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.syntax.BuildSyntax;

public class CubeBuildSpecification
extends AbstractChildObjectWithDesc {
    public static final String TYPE = "BUILDSPECIFICATION";
    public static final String SYSTEM_DEFAULT_NAME = "SYS_DEFAULT";
    public static final String LOAD_AND_AGGREGATION = OLAPArb.get("CUBE.BUILD.SPEC.LOAD.AND.AGGREGATE");

    public CubeBuildSpecification() {
        this.setIsDefault(false);
    }

    public CubeBuildSpecification(String string) {
        super(string);
        this.setIsDefault(false);
    }

    public CubeBuildSpecification(Cube cube, String string, String string2) {
        super(string);
        this.setCube(cube);
        this.initBuildSpecification(string2);
        this.setIsDefault(false);
    }

    public String getType() {
        return TYPE;
    }

    @Internal
    public Cube getCube() {
        return (Cube)this.getParent();
    }

    public void setCube(Cube cube) {
        this.setParent((DBObject)cube);
    }

    public boolean isDefault() {
        return (Boolean)this.getProperty("buildSpecificationIsDefault");
    }

    public void setIsDefault(boolean bl) {
        this.setProperty("buildSpecificationIsDefault", bl);
    }

    public CubeBuildCommand[] getBuildCommands() {
        CubeBuildCommand[] cubeBuildCommandArray = (CubeBuildCommand[])this.getChildSupport("buildSpecificationCommands").getChildArray(CubeBuildCommand.class);
        return cubeBuildCommandArray;
    }

    public String getSyntax() {
        String string = (String)this.getProperty("buildSpecificationSyntax");
        if (string != null) {
            string = string.replaceAll("''", "'");
        }
        return string;
    }

    public void setSyntax(String string) {
        if (string != null) {
            string = string.replaceAll("'", "''");
        }
        this.setProperty("buildSpecificationSyntax", string);
    }

    public void initBuildSpecification(String string) {
        Object object;
        this.setSyntax(string);
        Map<Object, Object> map = new HashMap();
        String string2 = null;
        Cube cube = this.getCube();
        if (cube != null) {
            object = cube.getSchema();
            string2 = object.getName();
        }
        try {
            map = BuildSyntax.getInstance().fromSyntax(string2, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BuildSyntax.getInstance();
        object = (String)map.get("CUBE_BUILD_SPECIFICATION_NAME_KEY");
        this.setName((String)object);
        CubeBuildCommand[] cubeBuildCommandArray = new CubeBuildCommand[]{};
        BuildSyntax.getInstance();
        List list = (List)map.get("CUBE_BUILD_COMMANDS_KEY");
        if (list != null) {
            cubeBuildCommandArray = list.toArray(cubeBuildCommandArray);
        }
        this.setBuildCommands(cubeBuildCommandArray);
    }

    public void setBuildCommands(CubeBuildCommand[] cubeBuildCommandArray) {
        this.getChildSupport("buildSpecificationCommands").setChildArray((Object[])cubeBuildCommandArray);
    }

    private String _generateBuildSyntax() {
        CubeBuildCommand[] cubeBuildCommandArray = this.getBuildCommands();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<CubeBuildCommand> arrayList = new ArrayList<CubeBuildCommand>();
        for (int i = 0; i < cubeBuildCommandArray.length; ++i) {
            arrayList.add(cubeBuildCommandArray[i]);
        }
        BuildSyntax.getInstance();
        hashMap.put("CUBE_BUILD_SPECIFICATION_NAME_KEY", this.getName());
        BuildSyntax.getInstance();
        hashMap.put("CUBE_BUILD_COMMANDS_KEY", arrayList);
        String string = BuildSyntax.getInstance().toSyntax(hashMap);
        return string;
    }

    public static String getDefaultCubeMeasureSelection(Cube cube) {
        CubeMeasure[] cubeMeasureArray = cube.getMeasures();
        String string = cube.getName();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < cubeMeasureArray.length; ++i) {
            String string2 = string + "." + cubeMeasureArray[i].getName();
            arrayList.add(string2);
        }
        Object object = "";
        for (String string3 : arrayList) {
            if (((String)object).length() == 0) {
                object = (String)object + string3;
                continue;
            }
            object = (String)object + "," + string3;
        }
        return object;
    }

    public static String getDefaultCubeDimensionCondition(Cube cube) {
        Object object = "";
        CubeDimensionality[] cubeDimensionalityArray = cube.getDimensions();
        for (int i = 0; i < cubeDimensionalityArray.length; ++i) {
            String string = cubeDimensionalityArray[i].getName();
            String string2 = String.format("%1$s WHERE %1$s.DIM_KEY IS NOT NULL", string);
            object = ((String)object).length() == 0 ? (String)object + string2 : (String)object + "," + string2;
        }
        return object;
    }
}

