/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.model.CubeMeasureFolderContents;
import oracle.olap.cube.model.CubePartition;
import oracle.olap.cubedimension.CubeDimensionBuilder;
import oracle.olap.cubexml.CubeXML;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.db.model.AbstractOLAPDBObjectBuilder;
import oracle.olap.db.model.LanguageDescription;
import oracle.olap.ddl.CubeDDLSupport;
import oracle.olapi.syntax.ConsistentSolveSpecification;
import oracle.olapi.syntax.SyntaxObject;

public class CubeBuilder
extends AbstractOLAPDBObjectBuilder<Cube> {
    public CubeBuilder(OracleDatabaseImpl oracleDatabaseImpl) {
        super((AbstractDBObjectProvider)oracleDatabaseImpl, "CUBE");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public Cube createObject(String string, oracle.javatools.db.Schema schema, DBObjectID dBObjectID) {
        Cube cube = new Cube();
        cube.setName(string);
        cube.setSchema(schema);
        cube.setID(dBObjectID);
        return cube;
    }

    public void buildFromCache(Cube cube) throws DBException, SQLException, IOException {
        Object object;
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        String string = cube.getSchema().getName();
        String string2 = Connections.getInstance().getConnectionName(oracleDatabaseImpl.getConnection());
        Schema schema = OLAPMetadataCache.getUpdatedSchema(string2, string);
        oracle.olap.app.olapmetadata.Cube cube2 = schema.findCube(cube.getName());
        if (cube2 == null) {
            return;
        }
        cube.setDescription(cube2.getDescription());
        cube.setConsistentSolveSpec(cube2.getConsistentSolveSpec());
        int n = 1;
        for (Dimension namedObjectWithDesc : cube2.getDimensions()) {
            object = new CubeDimensionality();
            object.setName(namedObjectWithDesc.getName());
            object.setPhysicalOrder(n++);
            cube.addDimensionality((CubeDimensionality)((Object)object));
        }
        for (Measure measure : cube2.getMeasures()) {
            Object object2;
            object = measure.getName();
            if (measure.isDerived()) {
                object2 = new CubeCalculatedMeasure((String)object);
                cube.addCalculatedMeasure((CubeCalculatedMeasure)object2);
                ((CubeCalculatedMeasure)object2).setMeasureExpression(measure.getExpression());
                continue;
            }
            object2 = CubeDimensionBuilder.getRootDataType(measure.getSQLDataType());
            CubeMeasure cubeMeasure = new CubeMeasure((String)object);
            cube.addMeasure(cubeMeasure);
            cubeMeasure.setDataType((String)object2);
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"description", "analyticWorkspace", "consistentSolveSpec", "partitionDimension", "partitionHierarchy", "partitionLevel"})
    public void buildProperties(final Cube cube) throws DBException {
        String string = "select /*+ NO_QUERY_TRANSFORMATION */ aw_name, description, consistent_solve_spec, partition_dimension_name, partition_hierarchy_name, partition_level_name, precompute_percent    from all_cubes where cube_name = ? and owner = ?";
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), string, new Object[]{cube.getName(), cube.getSchema()});
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        final String string2 = CubeDDLSupport.getDatabaseCompatibleLevel((DBObjectProvider)abstractDBObjectProvider);
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string;
                        String string22 = resultSet.getString("aw_name");
                        String string3 = resultSet.getString("description");
                        String string4 = resultSet.getString("consistent_solve_spec");
                        cube.setDescription(string3);
                        cube.setAnalyticWorkspace(string22);
                        if (string4 != null) {
                            if (!string2.startsWith("12.2")) {
                                string = (ConsistentSolveSpecification)SyntaxObject.fromSyntax((String)string4, null);
                                string4 = string.toSyntax(cube.getSchema().getName());
                            }
                            cube.setConsistentSolveSpec(string4);
                        }
                        string = resultSet.getString("partition_dimension_name");
                        String string5 = resultSet.getString("partition_hierarchy_name");
                        String string6 = resultSet.getString("partition_level_name");
                        BigDecimal bigDecimal = resultSet.getBigDecimal("precompute_percent");
                        if (string != null && string.trim().length() > 0) {
                            CubePartition cubePartition = new CubePartition();
                            String string7 = String.format("%s_%s", string5, string6);
                            cubePartition.setName(string7);
                            cubePartition.setPartitionDimension(string);
                            cubePartition.setPartitionHierarchy(string5);
                            cubePartition.setPartitionLevel(string6);
                            if (bigDecimal != null) {
                                cubePartition.setPrecomputePercent(bigDecimal.intValue());
                            } else {
                                cubePartition.setPrecomputePercent(0);
                            }
                            cube.addPartition(cubePartition);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"shortDescription", "longDescription", "defaultBuildSpecifications", "buildSpecifications", "measures", "calculatedMeasures", "dimensions", "dimensionNames"})
    public void buildDetails(Cube cube) throws DBException, SQLException, IOException, JAXBException {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        this.build(cube);
        String string = cube.getSchema().getName();
        String string2 = String.format("%s.%s", string, cube.getName());
        Object object = this.getObject(oracleDatabaseImpl.getConnection(), string2);
        MetadataContext metadataContext = new MetadataContext(this.getProvider());
        CubeXML cubeXML = new CubeXML(metadataContext, object, cube);
        cubeXML.loadModel();
        cube.setFullyLoaded(true);
    }

    public void build(final Cube cube) throws DBException {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        cube.removeAllDimensions();
        cube.removeAllMeasures();
        cube.removeAllCalculatedMeasures();
        cube.removeAllLanguageDescriptions();
        String string = String.format("SELECT /*+ NO_QUERY_TRANSFORMATION */ object_name , object_type, language, description_type, description_value from all_cube_descriptions where owner = ? and (object_name='%1$s' or object_name like '%1$s.%%') and object_type in('CUBE','MEASURE') and language <> ? order by object_name,language", cube.getName());
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), string, new Object[]{cube.getSchema(), this.getDefaultLanguage()});
        final QueryWrapper queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "SELECT /*+ NO_QUERY_TRANSFORMATION */ dty.dimension_name, dimension_type\nFROM all_cube_dimensionality dty, all_cube_dimensions dims\nWHERE cube_name = ?\nAND dty.owner       = ?\nand dty.owner = dims.owner and dty.dimension_name = dims.dimension_name\nORDER BY order_num", new Object[]{cube.getName(), cube.getSchema()});
        final QueryWrapper queryWrapper3 = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ measure_name, data_type  || DECODE(data_type, 'CHAR', '('  || data_length  ||')', 'VARCHAR', '('  || data_length  ||')', 'VARCHAR2', '('  || data_length  ||')', 'NCHAR', '('  || data_length  ||')', 'NVARCHAR', '('  || data_length  ||')', 'NVARCHAR2', '('  || data_length  ||')', 'NUMBER', '('  || NVL(data_precision,data_length)  || DECODE(data_scale,NULL,NULL, ','  ||data_scale)  ||')', NULL) data_type from all_cube_measures  where cube_name = ? and owner = ? and measure_type = 'BASE' order by measure_name", new Object[]{cube.getName(), cube.getSchema()});
        final QueryWrapper queryWrapper4 = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ measure_name, to_char(expression) from all_cube_measures where cube_name = ? and owner = ? and measure_type = 'DERIVED' and nvl(length(expression), 0) < 2000 order by measure_name", new Object[]{cube.getName(), cube.getSchema()});
        final QueryWrapper queryWrapper5 = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ measure_name, expression from all_cube_measures where cube_name = ? and owner = ? and measure_type = 'DERIVED' and nvl(length(expression), 0) >= 2000 order by measure_name", new Object[]{cube.getName(), cube.getSchema()});
        final QueryWrapper queryWrapper6 = new QueryWrapper((Database)this.getProvider(), "select /*+ NO_QUERY_TRANSFORMATION */ distinct mviews.owner, cube_name, rewrite_enabled, refresh_method, fast_refreshable, last_refresh_type  from all_cubes ch, all_mviews mviews  where ch.owner = ? and cube_name = ? and  (ch.rewrite_mview_name=mviews.mview_name or ch.refresh_mview_name = mviews.mview_name)", new Object[]{cube.getSchema(), cube.getName()});
        queryWrapper3.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = CubeDimensionBuilder.getRootDataType(string2);
                        CubeMeasure cubeMeasure = new CubeMeasure(string);
                        cube.addMeasure(cubeMeasure);
                        cubeMeasure.setDataType(string3);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper3.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
        queryWrapper4.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        CubeCalculatedMeasure cubeCalculatedMeasure = new CubeCalculatedMeasure(string);
                        cube.addCalculatedMeasure(cubeCalculatedMeasure);
                        cubeCalculatedMeasure.setMeasureExpression(string2);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper4.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
        queryWrapper5.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        CubeCalculatedMeasure cubeCalculatedMeasure = new CubeCalculatedMeasure(string);
                        cube.addCalculatedMeasure(cubeCalculatedMeasure);
                        cubeCalculatedMeasure.setMeasureExpression(string2);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper5.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
        queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    int n = 1;
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        CubeDimensionality cubeDimensionality = new CubeDimensionality();
                        cubeDimensionality.setName(string);
                        cubeDimensionality.setPhysicalOrder(n++);
                        cube.addDimensionality(cubeDimensionality);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper2.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
        queryWrapper6.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        cube.setCubeMVEnabled(true);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper6.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    CubeBuilder.this.processLanguageDescriptionsResultSet(resultSet, cube);
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
    }

    private void processLanguageDescriptionsResultSet(ResultSet resultSet, Cube cube) throws DBException, SQLException {
        String string = "";
        boolean bl = true;
        LanguageDescription languageDescription = null;
        int n = 0;
        while (resultSet.next()) {
            if (bl) {
                string = resultSet.getString("language");
                languageDescription = new LanguageDescription(string);
                languageDescription.setLanguage(string);
                bl = false;
            }
            if (string.equals(resultSet.getString("language"))) {
                if (resultSet.getString("description_type").equalsIgnoreCase("Description")) {
                    languageDescription.setDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("ShortDescription")) {
                    languageDescription.setShortDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("LongDescription")) {
                    languageDescription.setLongDescription(resultSet.getString("description_value"));
                    ++n;
                }
                if (n == 3) {
                    this.checkForNullLanguageDescriptionValues(languageDescription);
                    if (resultSet.getString("object_type").equalsIgnoreCase("CUBE")) {
                        cube.addLanguageDescription(languageDescription);
                    } else {
                        String string2 = resultSet.getString("object_name").substring(resultSet.getString("object_name").indexOf(".") + 1);
                        CubeMeasure cubeMeasure = cube.findMeasure(string2);
                        if (cubeMeasure != null) {
                            cubeMeasure.addLanguageDescription(languageDescription);
                        } else {
                            CubeCalculatedMeasure cubeCalculatedMeasure = cube.findCalculatedMeasure(string2);
                            if (cubeCalculatedMeasure != null) {
                                cubeCalculatedMeasure.addLanguageDescription(languageDescription);
                            }
                        }
                    }
                    n = 0;
                    languageDescription = new LanguageDescription(resultSet.getString("language"));
                    languageDescription.setLanguage(resultSet.getString("language"));
                }
            } else {
                languageDescription = new LanguageDescription(resultSet.getString("language"));
                languageDescription.setLanguage(resultSet.getString("language"));
                if (resultSet.getString("description_type").equalsIgnoreCase("Description")) {
                    languageDescription.setDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("ShortDescription")) {
                    languageDescription.setShortDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("LongDescription")) {
                    languageDescription.setLongDescription(resultSet.getString("description_value"));
                    ++n;
                }
            }
            string = resultSet.getString("language");
        }
    }

    public List<CubeMeasureFolderContents> buildCubeMeasureFolderContents(final Cube cube, String string, String string2) throws DBException {
        final ArrayList<CubeMeasureFolderContents> arrayList = new ArrayList<CubeMeasureFolderContents>();
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select owner, measure_folder_name, cube_owner, cube_name, measure_name from all_measure_folder_contents where cube_owner = ? and cube_name = ?", new Object[]{string2, string});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        arrayList.add(new CubeMeasureFolderContents(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5)));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cube, sQLException);
                }
            }
        });
        return arrayList;
    }
}

