/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import javax.swing.JTable;
import oracle.dbtools.raptor.controls.listtable.ListTableModel;
import oracle.olap.OLAPArb;
import oracle.olap.build.BuildObject;

public class BuildObjectListTableModel
extends ListTableModel<BuildObject> {
    public static final int NAME = 0;
    public static final int TYPE = 1;
    public static final int LOADOPTION = 2;
    public static final int SORT = 3;
    public static final int METHOD = 4;
    public static final int SCRIPT = 5;
    private static final String[] COL_NAMES = new String[]{OLAPArb.get("BUILD_WIZARD_REF_METHODS_OBJ_NAME_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_OBJ_TYPE_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADOPTIONS_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_SORT_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_METHOD_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBE_SCRIPT_LABEL")};
    private static final String[] COL_TIPS = new String[]{OLAPArb.get("BUILD_WIZARD_REF_METHODS_OBJ_NAME_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_OBJ_TYPE_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADOPTIONS_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_SORT_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_METHOD_LABEL"), OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBE_SCRIPT_LABEL")};

    public BuildObjectListTableModel() {
        super(COL_NAMES, COL_TIPS);
    }

    public void setTable(JTable jTable) {
        super.setTable(jTable);
        jTable.setSurrendersFocusOnKeystroke(true);
    }

    protected Object getValueAt(BuildObject buildObject, int n) {
        switch (n) {
            case 0: {
                Object object = buildObject.getName();
                String string = buildObject.getInlineBuildSpecification();
                if (!string.isEmpty()) {
                    object = (String)object + " USING(" + string + ")";
                }
                return object;
            }
            case 1: {
                String string = buildObject.getType();
                boolean bl = buildObject.isMVOn();
                if (bl) {
                    if (string.equalsIgnoreCase("CUBE")) {
                        string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBEMV_LABEL");
                    } else if (string.equalsIgnoreCase("CUBE DIMENSION")) {
                        string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIMMV_LABEL");
                    }
                } else if (string.equalsIgnoreCase("CUBE")) {
                    string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBE_LABEL");
                } else if (string.equalsIgnoreCase("CUBE DIMENSION")) {
                    string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIM_LABEL");
                }
                return string;
            }
            case 2: {
                String string = buildObject.getLoadOption();
                if (string.equalsIgnoreCase("SYNCH")) {
                    string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL");
                } else if (string.equalsIgnoreCase("NOSYNCH")) {
                    string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL");
                } else if (string.equalsIgnoreCase("RETAIN")) {
                    string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_LABEL");
                }
                return string;
            }
            case 3: {
                boolean bl = buildObject.isSortOn();
                return bl;
            }
            case 4: {
                String string = buildObject.getRefreshMethod();
                if (string.equalsIgnoreCase("C")) {
                    string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL");
                } else if (string.equalsIgnoreCase("F")) {
                    string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_FAST_LABEL");
                } else if (string.equalsIgnoreCase("?")) {
                    string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_FORCE_LABEL");
                } else if (string.equalsIgnoreCase("P")) {
                    string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_PCT_LABEL");
                } else if (string.equalsIgnoreCase("S")) {
                    string = OLAPArb.get("BUILD_WIZARD_REF_METHODS_SOLVE_LABEL");
                }
                return string;
            }
            case 5: {
                String string = buildObject.getCubeScriptName();
                if (string == null) {
                    string = "";
                }
                return string;
            }
        }
        return null;
    }

    protected boolean isCellEditable(BuildObject buildObject, int n) {
        String string = buildObject.getType();
        String string2 = buildObject.getInlineBuildSpecification();
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return string.equalsIgnoreCase("CUBE DIMENSION") && string2.isEmpty();
            }
            case 3: {
                return string.equalsIgnoreCase("CUBE DIMENSION") && string2.isEmpty();
            }
            case 4: {
                return true;
            }
            case 5: {
                return string.equalsIgnoreCase("CUBE") && string2.isEmpty();
            }
        }
        return false;
    }

    protected void setValueAt(Object object, BuildObject buildObject, int n) {
        switch (n) {
            case 0: {
                buildObject.setName((String)object);
                break;
            }
            case 1: {
                buildObject.setType((String)object);
                break;
            }
            case 2: {
                String string = ((String)object).trim();
                if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL"))) {
                    string = "SYNCH";
                } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL"))) {
                    string = "NOSYNCH";
                } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_LABEL"))) {
                    string = "RETAIN";
                }
                buildObject.setLoadOption(string);
                break;
            }
            case 3: {
                buildObject.setSort((Boolean)object);
                break;
            }
            case 4: {
                String string = ((String)object).trim();
                string = string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL")) ? "C" : (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FAST_LABEL")) ? "F" : (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FORCE_LABEL")) ? "?" : (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SOLVE_LABEL")) ? "S" : (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_PCT_LABEL")) ? "P" : "C"))));
                buildObject.setRefreshMethod(string);
                break;
            }
            case 5: {
                buildObject.setCubeScriptName((String)object);
                break;
            }
        }
    }
}

