/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.aw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.actions.NewAWRunnable;
import oracle.olap.aw.NewAWDialog;

public class NewAW {
    private static NewAW INSTANCE;
    private static final Logger LOGGER;
    public static final int AW_NAME_LENGTH = 26;

    private NewAW() {
    }

    public static NewAW getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NewAW();
        }
        return INSTANCE;
    }

    public void launchDialog(DBObject dBObject) {
        Database database = dBObject.getDatabase();
        String string = dBObject.getSchemaName();
        NewAWDialog newAWDialog = new NewAWDialog((Frame)Ide.getMainWindow(), (DBObjectProvider)database, string);
        newAWDialog.setMinimumSize(new Dimension(400, 120));
        newAWDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        newAWDialog.setVisible(true);
        if (newAWDialog.isOKSelected()) {
            String string2 = newAWDialog.getAWName();
            String string3 = newAWDialog.getTableSpaceName();
            if (string2 != null && string2.length() > 0) {
                string2 = string2.toUpperCase();
                this.createAW(database, string, string3, string2);
            }
        }
    }

    private void createAW(Database database, String string, String string2, String string3) {
        try {
            NewAWRunnable newAWRunnable = new NewAWRunnable(database, string, string2, string3);
            String string4 = OLAPArb.get("NEWAW_PROGRESSBAR_TITLE");
            string4 = MessageFormat.format(string4, "");
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string4, (Runnable)newAWRunnable, true);
            progressBar.setCancelable(false);
            newAWRunnable.setProgressBar(progressBar);
            progressBar.start(OLAPArb.get("NEWAWL_PROGRESSBAR_WAIT_MSG"), null);
            if (newAWRunnable.getException() != null) {
                throw newAWRunnable.getException();
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            String string5 = null;
            String string6 = exception.getLocalizedMessage();
            if (string6 == null || string6.length() == 0) {
                string6 = exception.getClass().toString();
            }
            String string7 = OLAPArb.get("NEWAW_ERROR_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string6, (String)string7, string5);
        }
    }

    static {
        LOGGER = Logger.getLogger(NewAW.class.getName());
    }
}

