/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.hyper.HyperLabel;
import oracle.olap.app.hyper.HyperLabelActionListener;
import oracle.olap.app.hyper.HyperLinkCombo;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.ItemElement;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateListHyperView;
import oracle.olap.app.templates.templateview.TemplateMetadata;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.app.templates.view.TemplateHyperContextImpl;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamAdvancedOptionsDMLExpression
extends TemplateHyperParam
implements PropertyChangeListener {
    private final JPanel gui = new JPanel(new FlowLayout(0, 0, 0));
    private final JPanel advOptionsPanel = new JPanel(new BorderLayout());
    private final HyperLabel advOptionsLink;
    private boolean isOk;
    private TemplateListHyperView templateListHyperView;
    private ParseNode pattern;
    private boolean isLoading;
    private final String RESERVED_WORD_LOOP = "LOOP";
    private final String RESERVED_WORD_DIMENSION = "DIMENSION";
    private final String RESERVED_WORD_DENSE = "DENSE";
    private final String RESERVED_WORD_SPARSE = "SPARSE";
    private final String MULTI_SELECT_HYPER_LABEL_NAME = "MULTI_SELECT_HYPER_LABEL_NAME";
    private String dmlExpression;
    private boolean hasChanged;
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamAdvancedOptionsDMLExpression.class.getName());

    public TemplateHyperParamAdvancedOptionsDMLExpression() {
        this.advOptionsPanel.setPreferredSize(new Dimension(450, 300));
        this.advOptionsLink = this.getAdvancedOptionsLink();
        if (this.advOptionsLink != null) {
            this.gui.add(this.advOptionsLink);
        }
    }

    @Override
    public Component getComponent() {
        return this.gui;
    }

    @Override
    public void init() {
        try {
            this.setUpTemplate(this.getTemplateContext());
        }
        catch (IOException iOException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void setUpTemplate(TemplateContext templateContext) throws SQLException, IOException {
        if (templateContext != null) {
            OLAPResources oLAPResources = new OLAPResources("/oracle/olap/measureexpression/advancedOptionsDMLExpression.xml");
            FetchIcon fetchIcon = null;
            TemplateHyperContextImpl templateHyperContextImpl = new TemplateHyperContextImpl(templateContext.getDatabase().getConnection(), oLAPResources, fetchIcon, TemplateHyperContext.ResizeMode.LEGACY);
            templateContext.getCube().getSchema().setLoaded(true);
            TemplateContext templateContext2 = new TemplateContext(templateContext.getDatabase(), new TemplateMetadata(templateContext.getCube()));
            this.templateListHyperView = new TemplateListHyperView(templateContext2, templateHyperContextImpl, TemplateHyperParamAdvancedOptionsDMLExpression.class, "/oracle/olap/measureexpression/advancedOptionsDMLExpression.xml");
            this.templateListHyperView.addPropertyChangeListener(this);
            this.dmlExpression = this.templateListHyperView.getExpression();
            this.advOptionsPanel.add(this.templateListHyperView.getPanel());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("VALUE_CHANGED")) {
            try {
                this.dmlExpression = this.templateListHyperView.getExpression();
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, exception.getMessage(), exception);
            }
            this.hasChanged = true;
        }
    }

    private HyperLabel getAdvancedOptionsLink() {
        HyperLabel hyperLabel = new HyperLabel(OLAPArb.getString("ADVANCED_DML_EXPRESSION_OPTIONS_LINK_LABEL"));
        hyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", null, "");
                TemplateHyperParamAdvancedOptionsDMLExpression.this.isOk = UIUtils.showPanelAsDialog((JPanel)TemplateHyperParamAdvancedOptionsDMLExpression.this.advOptionsPanel, (String)OLAPArb.getString("ADVANCED_DML_EXPRESSION_OPTIONS_TITLE"), null, (int)7);
                if (TemplateHyperParamAdvancedOptionsDMLExpression.this.isOk && TemplateHyperParamAdvancedOptionsDMLExpression.this.hasChanged) {
                    TemplateHyperParamAdvancedOptionsDMLExpression.this.firePropertyChangeEvent(propertyChangeEvent);
                    TemplateHyperParamAdvancedOptionsDMLExpression.this.hasChanged = false;
                }
            }
        });
        return hyperLabel;
    }

    @Override
    public Object getValue() {
        return this.getExpression();
    }

    @Override
    public boolean setValue(Object object) {
        List<Object> list = new ArrayList();
        ParseNode parseNode = null;
        ParseNode parseNode2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        Stack<String> stack = new Stack<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (object != null && object instanceof ParseNode) {
            this.isOk = true;
            parseNode = (ParseNode)object;
            parseNode2 = (ParseNode)parseNode.getParent();
            list = parseNode2.getChildren();
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                int n;
                if (((ParseNode)list.get(i)).getUserObject().equals("DIMENSION")) {
                    for (n = i + 2; n < list.size() && !((ParseNode)list.get(n)).getUserObject().equals("LOOP"); ++n) {
                        String string;
                        String string2 = ((ParseNode)list.get(n)).getUserObject().toString();
                        String string3 = null;
                        if (n + 1 < list.size()) {
                            string3 = ((ParseNode)list.get(n + 1)).getUserObject().toString();
                        } else {
                            string3 = "";
                            bl = true;
                        }
                        if (string2.equalsIgnoreCase("DENSE")) continue;
                        stack.push(string2);
                        if (!string3.equalsIgnoreCase("DENSE")) {
                            string = (String)stack.pop();
                            hashMap.put(string, "SPARSE");
                            continue;
                        }
                        string = (String)stack.pop();
                        hashMap.put(string, "DENSE");
                    }
                    i = bl ? n - 1 : n;
                }
                if (!((ParseNode)list.get(i)).getUserObject().equals("LOOP")) continue;
                n = i + 2;
                stringBuilder.append(((ParseNode)list.get(n)).getUserObject());
                ++n;
                while (n < list.size()) {
                    stringBuilder.append(",");
                    stringBuilder.append(((ParseNode)list.get(n)).getUserObject());
                    ++n;
                }
                i = n;
            }
        } else {
            this.isOk = false;
            stringBuilder.append(OLAPArb.getString("DEFAULT_MEASURES_SELECTION_LINK"));
            for (oracle.olap.app.olapmetadata.Dimension dimension : this.getTemplateContext().getCubeDimensions()) {
                hashMap.put(dimension.getName(), "SPARSE");
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(OLAPArb.getString("DEFAULT_MEASURES_SELECTION_LINK"));
        }
        this.findPanelComponents(this.templateListHyperView.getPanel(), stringBuilder, hashMap);
        return true;
    }

    private void findPanelComponents(JPanel jPanel, StringBuilder stringBuilder, HashMap<String, String> hashMap) {
        Stack<JComponent> stack = new Stack<JComponent>();
        Stack<String> stack2 = new Stack<String>();
        stack.push(jPanel);
        while (!stack.empty()) {
            JComponent jComponent = (JComponent)stack.pop();
            if (!(jComponent instanceof JPanel) && !(jComponent instanceof JScrollPane) && !(jComponent instanceof JViewport)) continue;
            JComponent jComponent2 = jComponent;
            block1: for (Component component : jComponent2.getComponents()) {
                Object object;
                JComponent jComponent3;
                if (component instanceof HyperLabel) {
                    jComponent3 = (HyperLabel)component;
                    object = jComponent3.getName();
                    if (!((String)object).equals("MULTI_SELECT_HYPER_LABEL_NAME")) continue;
                    ((JLabel)jComponent3).setText(stringBuilder.toString());
                    continue;
                }
                if (component instanceof HyperLinkCombo) {
                    Object object2;
                    jComponent3 = (HyperLinkCombo)component;
                    object = ((JComboBox)jComponent3).getModel();
                    Object object3 = ((JComboBox)jComponent3).getSelectedItem();
                    if (object3 instanceof oracle.olap.app.olapmetadata.Dimension) {
                        object2 = (oracle.olap.app.olapmetadata.Dimension)object3;
                        stack2.push(((NamedObject)object2).getName());
                    }
                    if (!(object3 instanceof ItemElement) || stack2.isEmpty()) continue;
                    object2 = (String)stack2.pop();
                    String string = hashMap.get(object2);
                    for (int i = 0; i < object.getSize(); ++i) {
                        String string2 = object.getElementAt(i).toString();
                        if (!string2.equals(string)) continue;
                        ((HyperLinkCombo)jComponent3).setSelectedItem(object.getElementAt(i));
                        continue block1;
                    }
                    continue;
                }
                if (!(component instanceof JPanel) && !(component instanceof JScrollPane) && !(component instanceof JViewport)) continue;
                stack.push((JComponent)component);
            }
        }
    }

    @Override
    public String getExpression() {
        if (this.isOk || this.isLoading) {
            return this.dmlExpression;
        }
        this.setValue(null);
        return "";
    }

    @Override
    public ParseNode getPattern() {
        if (this.pattern == null) {
            this.pattern = new ParseNode("dml_advanced_options", Type.STRING.toString(), false);
            this.isLoading = true;
        }
        return this.pattern;
    }

    @Override
    public int getPixelSize(int n) {
        return 0;
    }
}

