/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.hyper;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import oracle.olap.app.hyper.HyperLabelActionListener;

public class HyperLabel
extends JLabel {
    private HyperFocusListener hfl;
    private MouseListener ml;
    private HyperLabelActionListener hla;
    private Object context;
    private boolean m_blnIsEnabled = true;
    private Color m_focusForeColor = UIManager.getColor("ComboBox.selectionForeground");
    private Color m_focusBackColor = UIManager.getColor("ComboBox.selectionBackground");
    private Color m_hyperForeColor = Color.blue;
    private Color m_lblBackColor1 = UIManager.getColor("Panel.background");
    private Color m_lblBackColor2 = UIManager.getColor("ComboBox.background");

    public HyperLabel(String string) {
        this(null, string);
    }

    public HyperLabel(final Object object, String string) {
        super(string);
        this.context = object;
        this.setOpaque(true);
        this.setBorder(null);
        this.setDoubleBuffered(true);
        this.setEnabled(true);
        this.setRequestFocusEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.hfl = new HyperFocusListener();
        this.addFocusListener(this.hfl);
        this.ml = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (HyperLabel.this.hla != null) {
                    HyperLabel.this.hla.actionPerformed(object, HyperLabel.this.getText());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        };
        this.addMouseListener(this.ml);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HyperLabel.this.hla != null) {
                    HyperLabel.this.hla.actionPerformed(object, HyperLabel.this.getText());
                }
            }
        };
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 1);
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(40, 8), 1);
    }

    public void addActionListener(HyperLabelActionListener hyperLabelActionListener) {
        this.hla = hyperLabelActionListener;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        Color color = this.m_hyperForeColor;
        Color color2 = this.m_lblBackColor1 != null ? this.m_lblBackColor1 : this.m_lblBackColor2;
        Color color3 = graphics.getColor();
        Font font = graphics.getFont();
        graphics.setFont(this.getFont());
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.getText();
        if (this.m_blnIsEnabled) {
            if (this.hasFocus()) {
                color = this.m_focusForeColor;
                color2 = this.m_focusBackColor;
            }
            graphics.setColor(color2);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
            int n3 = n / 2 - fontMetrics.stringWidth(string) / 2;
            int n4 = fontMetrics.getAscent();
            graphics.drawString(string, n3, n4);
            graphics.drawLine(n3, n4 + 1, n - n3, n4 + 1);
            graphics.setColor(color3);
            graphics.setFont(font);
        } else {
            super.paint(graphics);
        }
    }

    public void paintOld(Graphics graphics) {
        super.paint(graphics);
        Color color = this.getForeground();
        Rectangle2D rectangle2D = this.getFontMetrics(this.getFont()).getStringBounds(this.getText(), graphics);
        int n = this.getHeight() / 2 + (int)(rectangle2D.getHeight() / 2.0);
        int n2 = (int)rectangle2D.getWidth();
        int n3 = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
        graphics.setColor(color);
        graphics.drawLine(0, n, n3 + n2, n);
    }

    public void cleanup() {
        this.removeFocusListener(this.hfl);
        this.removeMouseListener(this.ml);
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 8));
        this.ml = null;
        this.hfl = null;
        this.hla = null;
        this.context = null;
    }

    private class HyperFocusListener
    implements FocusListener {
        private HyperFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            HyperLabel.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            HyperLabel.this.repaint();
        }
    }

    private class HyperMouseInputListener
    extends MouseInputAdapter {
        private HyperMouseInputListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (HyperLabel.this.m_blnIsEnabled) {
                HyperLabel.this.requestFocusInWindow();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (HyperLabel.this.m_blnIsEnabled) {
                HyperLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                HyperLabel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            HyperLabel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

