/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import oracle.ide.history.Historian;
import oracle.ide.model.Node;
import oracle.ideimpl.history.HistorianRegistration;
import oracle.ideimpl.history.HistorianRegistrations;

public class HistorianHandler
extends ElementVisitor {
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "historian-hook");
    private static final ElementName HISTORIAN_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "historian-class");
    private static final ElementName NODE_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "node-class");
    private static final ElementName RESTORE_HELPER_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "restore-helper-class");
    private final ElementVisitor _historianClassHandler = new HistorianClassHandler();
    private final ElementVisitor _nodeClassHandler = new NodeClassHandler();
    private final ElementVisitor _restoreHelperHandler = new RestoreHelperHandler();
    private static final String KEY_SCOPE_REGISTRATION = "oide_historian_registration";

    public final void start(ElementStartContext context) {
        context.registerChildVisitor(HISTORIAN_CLASS, this._historianClassHandler);
        context.registerChildVisitor(NODE_CLASS, this._nodeClassHandler);
        context.registerChildVisitor(RESTORE_HELPER_CLASS, this._restoreHelperHandler);
        context.getScopeData().put(KEY_SCOPE_REGISTRATION, new HistorianRegistration());
    }

    public final void end(ElementEndContext context) {
        HistorianRegistration registration = (HistorianRegistration)context.getScopeData().get(KEY_SCOPE_REGISTRATION);
        HistorianRegistrations.register(registration);
    }

    private final class HistorianClassHandler
    extends MetaClassVisitor {
        private HistorianClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            HistorianRegistration registration = (HistorianRegistration)context.getScopeData().get(HistorianHandler.KEY_SCOPE_REGISTRATION);
            registration.setHistorianClass((MetaClass<? extends Historian>)mc);
        }
    }

    private final class NodeClassHandler
    extends MetaClassVisitor {
        private NodeClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            HistorianRegistration registration = (HistorianRegistration)context.getScopeData().get(HistorianHandler.KEY_SCOPE_REGISTRATION);
            registration.setNodeClass((MetaClass<? extends Node>)mc);
        }
    }

    private final class RestoreHelperHandler
    extends MetaClassVisitor {
        private RestoreHelperHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            HistorianRegistration registration = (HistorianRegistration)context.getScopeData().get(HistorianHandler.KEY_SCOPE_REGISTRATION);
            registration.setRestoreHelperClass((MetaClass<? extends Node>)mc);
        }
    }
}

