/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.util.HashMap;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.XMIException;
import oracle.mof.xmi.XMIMetaModel;
import oracle.mof.xmi.XMIType;

public class DefaultXMIMetaModel
implements XMIMetaModel {
    private String m_name;
    private String m_version;
    private String m_nsPrefix;
    private String m_nsURI;
    private String[] m_namespaces;
    private HashMap<Object, XMIType> m_types = new HashMap();

    public DefaultXMIMetaModel(String name, String version, String nsPrefix, String nsURI, String[] namespaces) {
        ContractUtils.checkNull(name, "Name must not be null");
        ContractUtils.checkNull(version, "Version must not be null");
        ContractUtils.checkNull(nsPrefix, "Namespace prefix must not be null");
        ContractUtils.checkNull(nsURI, "Namespace URI must not be null");
        this.m_name = name;
        this.m_version = version;
        this.m_nsPrefix = nsPrefix;
        this.m_nsURI = nsURI;
        this.m_namespaces = namespaces;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getVersion() {
        return this.m_version;
    }

    @Override
    public String getNSPrefix() {
        return this.m_nsPrefix;
    }

    @Override
    public String getNSURI() {
        return this.m_nsURI;
    }

    @Override
    public String[] getAdditionalNamespaces() {
        return this.m_namespaces;
    }

    @Override
    public XMIType getTypeByName(String name) throws XMIException {
        XMIType type = this.m_types.get(name);
        if (type == null && (type = this.createTypeByName(name)) != null) {
            this.m_types.put(name, type);
        }
        return type;
    }

    @Override
    public XMIType getTypeForInstance(Object instance) throws XMIException {
        Object key = this.getTypeKey(instance);
        if (key != null) {
            XMIType type = this.m_types.get(key);
            if (type == null && (type = this.createTypeForKey(key)) != null) {
                this.m_types.put(key, type);
            }
            return type;
        }
        return null;
    }

    protected XMIType createTypeByName(String name) throws XMIException {
        throw new UnsupportedOperationException("createTypeByName not implemented");
    }

    protected Object getTypeKey(Object instance) {
        throw new UnsupportedOperationException("getTypeKey not implemented");
    }

    protected XMIType createTypeForKey(Object key) throws XMIException {
        throw new UnsupportedOperationException("createTypeForKey not implemented");
    }
}

