/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;

public class JarStorage
implements Storage {
    private final URL _jarURL;
    private final JarIndex _jarIndex;
    private final String _jarEntry;
    private final File _jarFile;
    private String _canonicalPath;
    private HashMap<String, Object> properties;
    private Map<String, Storage> _cachedDirEntries;
    private Translator.Log _log;

    public JarStorage(URL jarURL) {
        this(null, jarURL);
    }

    JarStorage(Translator.Log log, URL jarURL) {
        String message;
        boolean isEmpty;
        long timestamp;
        String exceptionMessage;
        block13: {
            this.properties = null;
            this._log = log;
            this._jarURL = jarURL;
            URL jarPath = JarUtil.getJarFileURL((URL)jarURL);
            this._jarFile = new File(jarPath.getPath());
            JarIndex jarIndex = null;
            exceptionMessage = null;
            try {
                jarIndex = JarUtil.getJarIndex((URL)this._jarURL);
            }
            catch (IOException e) {
                jarIndex = null;
                exceptionMessage = this.collectExceptionMessages(e);
            }
            this._jarIndex = jarIndex;
            timestamp = -1L;
            isEmpty = true;
            if (this._jarIndex != null) {
                timestamp = this._jarIndex.getTimestamp();
                try {
                    isEmpty = this._jarIndex.isEmptyEx();
                }
                catch (IOException e) {
                    if (this._log == null) break block13;
                    message = CompArb.format(133, this._jarFile.getPath(), this.collectExceptionMessages(e));
                    this._log.warning(this, 0, 0, 0, message);
                }
            }
        }
        if (exceptionMessage != null || isEmpty && timestamp > 0L) {
            String path = this._jarFile.getPath();
            if (log != null) {
                if (exceptionMessage != null) {
                    message = CompArb.format(133, path, exceptionMessage);
                    log.error(this, 0, 0, 0, message);
                } else {
                    message = isEmpty && timestamp > 0L ? CompArb.format(132, path) : CompArb.format(63, path);
                    log.warning(this, 0, 0, 0, message);
                }
            } else {
                LogManager logMgr = LogManager.getLogManager();
                if (logMgr != null) {
                    final String message2 = exceptionMessage != null ? CompArb.format(140, path, exceptionMessage) : (isEmpty && timestamp > 0L ? CompArb.format(141, path) : CompArb.format(142, path));
                    final LogPage page = logMgr.getMsgPage();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            page.log((Object)message2);
                            page.log((Object)"\n");
                        }
                    };
                    if (page instanceof MessagePage) {
                        runnable.run();
                    } else {
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            }
        }
        this._jarEntry = JarUtil.getJarEntry((URL)this._jarURL);
    }

    private JarStorage(JarStorage orig, String jarEntry) {
        this.properties = null;
        this._jarURL = orig._jarURL;
        this._jarIndex = orig._jarIndex;
        this._jarEntry = jarEntry;
        this._jarFile = orig._jarFile;
        if (!ModelUtil.hasLength((String)orig._jarEntry)) {
            this._canonicalPath = orig.getCanonicalPath() + File.separator + jarEntry.replace('/', File.separatorChar);
        } else {
            this._canonicalPath = orig.getCanonicalPath();
            if (!this._canonicalPath.endsWith(File.separator)) {
                this._canonicalPath = this._canonicalPath + File.separator;
            }
            this._canonicalPath = this._canonicalPath + this.getName().replace('/', File.separatorChar);
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        JarStorage jarStorage = (JarStorage)o;
        return ModelUtil.areEqual((Object)this._jarEntry, (Object)jarStorage._jarEntry) && ModelUtil.areEqual((Object)this._jarFile, (Object)jarStorage._jarFile);
    }

    public int hashCode() {
        return this._jarURL != null ? this._jarURL.hashCode() : 0;
    }

    public String toString() {
        return this.getCanonicalPath();
    }

    public long modDate() {
        if (this._jarIndex != null) {
            try {
                return this._jarIndex.getTimestampEx(this._jarEntry);
            }
            catch (IOException e) {
                if (this._log != null) {
                    String message = CompArb.format(133, this._jarFile.getPath(), this.collectExceptionMessages(e));
                    this._log.warning(this, 0, 0, 0, message);
                }
                return this._jarIndex.getTimestamp();
            }
        }
        return this._jarFile.lastModified();
    }

    public URL getURL() {
        return URLFactory.newJarURL((URL)this._jarURL, (String)this._jarEntry);
    }

    public String getName() {
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            int lastSlash = this._jarEntry.lastIndexOf("/");
            if (this._jarEntry.endsWith("/") && lastSlash > 0) {
                lastSlash = this._jarEntry.lastIndexOf("/", lastSlash - 1);
            }
            return this._jarEntry.substring(lastSlash + 1);
        }
        return this._jarFile.getName();
    }

    public String getPath() {
        String jarFilePath = this._jarFile.getPath();
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            return jarFilePath + "!/" + this._jarEntry;
        }
        return jarFilePath;
    }

    public String getCanonicalPath() {
        if (this._canonicalPath == null) {
            try {
                this._canonicalPath = this._jarFile.getCanonicalPath() + "!";
            }
            catch (IOException e) {
                this._canonicalPath = this._jarFile.getAbsolutePath() + "!";
            }
            if (ModelUtil.hasLength((String)this._jarEntry)) {
                this._canonicalPath = this._canonicalPath + File.separator + this._jarEntry.replace('/', File.separatorChar);
            }
        }
        return this._canonicalPath;
    }

    public String getParent() {
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            return this._jarFile.getPath();
        }
        return this._jarFile.getParent();
    }

    public Object getProperty(String property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(property, value);
    }

    public boolean isDirectory() {
        return !ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/");
    }

    public boolean isInJar() {
        return true;
    }

    public void close() {
        if (this._cachedDirEntries != null) {
            this._cachedDirEntries.clear();
        }
        this._log = null;
    }

    public int size() throws IOException {
        assert (false);
        return 0;
    }

    public ArrayList listStorage() {
        String[] files = this.list();
        if (files != null) {
            ArrayList<Storage> res = new ArrayList<Storage>(files.length);
            for (int i = 0; i < files.length; ++i) {
                res.add(this.open(files[i]));
            }
            return res;
        }
        return new ArrayList(0);
    }

    public String[] list() {
        if (this._jarIndex != null && this.isDirectory()) {
            String[] result;
            try {
                boolean isEmpty;
                result = this._jarIndex.listEx(this._jarEntry == null ? "" : this._jarEntry);
                if (result.length == 0 && !(isEmpty = this._jarIndex.isEmptyEx()) && this._log != null) {
                    String message = CompArb.format(143, this._jarFile.getPath());
                    this._log.warning(this, 0, 0, 0, message);
                }
            }
            catch (IOException e) {
                if (this._log != null) {
                    String message = CompArb.format(133, this._jarFile.getPath(), this.collectExceptionMessages(e));
                    this._log.warning(this, 0, 0, 0, message);
                }
                result = new String[]{};
            }
            return result;
        }
        return new String[0];
    }

    public void open() throws IOException {
    }

    public Storage open(String name) {
        block5: {
            if (this._jarIndex == null) {
                return null;
            }
            if ((name = name.replace(File.separatorChar, '/')).endsWith("/")) {
                return this.openDir(name);
            }
            name = this._jarEntry == null ? name : this._jarEntry + name;
            try {
                if (this._jarIndex.existsEx(name)) {
                    return new JarStorage(this, name);
                }
            }
            catch (IOException e) {
                if (this._log == null) break block5;
                String message = CompArb.format(133, this._jarFile.getPath(), this.collectExceptionMessages(e));
                this._log.warning(this, 0, 0, 0, message);
            }
        }
        return null;
    }

    public Storage openDir(String name) {
        block8: {
            if (this._jarIndex == null) {
                return null;
            }
            if (!((String)(name = ((String)name).replace(File.separatorChar, '/'))).endsWith("/")) {
                name = (String)name + "/";
            }
            name = this._jarEntry == null ? name : this._jarEntry + (String)name;
            Storage entry = null;
            if (this._cachedDirEntries == null) {
                this._cachedDirEntries = new HashMap<String, Storage>();
            } else {
                entry = this._cachedDirEntries.get(name);
            }
            if (entry != null) {
                return entry;
            }
            try {
                if (this._jarIndex.isDirectoryEx((String)name)) {
                    entry = new JarStorage(this, (String)name);
                    this._cachedDirEntries.put((String)name, entry);
                    return entry;
                }
            }
            catch (IOException e) {
                if (this._log == null) break block8;
                String message = CompArb.format(133, this._jarFile.getPath(), this.collectExceptionMessages(e));
                this._log.warning(this, 0, 0, 0, message);
            }
        }
        return null;
    }

    public byte[] read() throws IOException {
        if (!ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/")) {
            throw new UnsupportedOperationException();
        }
        return this._jarIndex.getBytes(this._jarEntry);
    }

    public int read(byte[] buf) throws IOException {
        if (!ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/")) {
            throw new UnsupportedOperationException();
        }
        byte[] bytes = this._jarIndex.getBytes(this._jarEntry);
        int n = bytes.length;
        if (n > buf.length) {
            return n;
        }
        System.arraycopy(bytes, 0, buf, 0, n);
        return n;
    }

    public Storage setContext(Storage newContext) {
        throw new UnsupportedOperationException();
    }

    public void setPackage(String packageName) {
    }

    public void write(byte[] xs, int start, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Storage create(String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Storage createDir(String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    private String collectExceptionMessages(Exception ex) {
        StringBuilder buf = new StringBuilder();
        Throwable t = ex;
        while (t != null) {
            buf.append(t.getMessage());
            if ((t = t.getCause()) == null) continue;
            buf.append(" Cause: ");
        }
        return buf.toString();
    }
}

