/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.compiler.BuildLog;
import oracle.ide.compiler.Diagnostic;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.JarStorage;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

public class Helpers {
    public static Storage createFileStorage(String pathName) {
        return new FileStorage(new File(pathName));
    }

    public static Storage createFileStorage(File file) {
        return new FileStorage(file);
    }

    public static boolean isFileStorage(Storage stor) {
        return stor instanceof FileStorage;
    }

    private static List<URL> listOfUniqueClassPathElement(List<Storage> storageList) {
        ArrayList<URL> uniqueElements = null;
        HashMap<URL, URL> map = null;
        if (storageList != null) {
            for (Storage st : storageList) {
                ArrayList l = (ArrayList)st.getProperty("dependantClassPathURLList");
                if (l == null) continue;
                if (map == null) {
                    map = new HashMap<URL, URL>();
                }
                for (int j = 0; j < l.size(); ++j) {
                    URL cp = (URL)l.get(j);
                    if (map.get(cp) != null) continue;
                    map.put(cp, cp);
                    if (uniqueElements == null) {
                        uniqueElements = new ArrayList<URL>();
                    }
                    uniqueElements.add(cp);
                }
            }
        }
        return uniqueElements;
    }

    private static void addStoragePath(boolean verbose, Translator.Log log, HashSet<URL> seenURLs, List<Storage> storagePath, URL url, String indent, Storage enclosingJar) {
        block23: {
            String urlPath;
            if (seenURLs.contains(url)) {
                return;
            }
            seenURLs.add(url);
            boolean isFromManifestFile = ((String)indent).length() > 0;
            indent = (String)indent + "  ";
            if (verbose) {
                String message = CompArb.format(135, url.getPath());
                JCompiler.getInstance().getOutputLog().log((Object)((String)indent + message + "\n"));
            }
            URL jarFileUrl = null;
            if (JarUtil.isJarURL((URL)url)) {
                jarFileUrl = JarUtil.getJarFileURL((URL)url);
            } else if ("file".equals(url.getProtocol()) && (urlPath = url.getPath()) != null && (urlPath.endsWith(".jar") || urlPath.endsWith(".zip"))) {
                jarFileUrl = url;
            }
            if (jarFileUrl != null) {
                if (URLFileSystem.exists((URL)jarFileUrl) || new File(jarFileUrl.getPath()).exists()) {
                    boolean checkUnusedJars = verbose || System.getProperty("CHECK_UNUSED_JARS") != null;
                    JarStorage jarStorage = new JarStorage(log, url);
                    if (checkUnusedJars) {
                        jarStorage.setProperty("javacompiler.enclosing.jar", enclosingJar != null ? enclosingJar : jarStorage);
                        if (enclosingJar == null) {
                            Boolean used = jarStorage.getPath().replace('\\', '/').indexOf("/jre/") > 0;
                            jarStorage.setProperty("javacompiler.enclosing.jar.used", used);
                        }
                    }
                    if (isFromManifestFile) {
                        jarStorage.setProperty("isFromManifestFile", Boolean.TRUE);
                    }
                    storagePath.add(jarStorage);
                    try {
                        String classPathAttr = JarUtil.getClassPath((URL)jarFileUrl);
                        if (classPathAttr == null) break block23;
                        if (verbose) {
                            String message = CompArb.getString(136);
                            JCompiler.getInstance().getOutputLog().log((Object)((String)indent + message + "\n"));
                        }
                        URL dirUrl = URLFileSystem.getParent((URL)jarFileUrl);
                        StringTokenizer st = new StringTokenizer(classPathAttr);
                        while (st.hasMoreTokens()) {
                            String classPathItemStr = st.nextToken();
                            boolean isJar = false;
                            URL classPathItemURL = URLFactory.newURL((URL)dirUrl, (String)classPathItemStr);
                            if (JarUtil.isArchive((String)classPathItemStr)) {
                                isJar = true;
                                classPathItemURL = URLFactory.newJarURL((URL)classPathItemURL, null);
                            }
                            Helpers.addStoragePath(verbose, log, seenURLs, storagePath, classPathItemURL, (String)indent + "  ", (Storage)(enclosingJar != null ? enclosingJar : jarStorage));
                        }
                        if (verbose) {
                            String message = CompArb.getString(137);
                            JCompiler.getInstance().getOutputLog().log((Object)((String)indent + message + "\n"));
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    String message = CompArb.format(134, url.getPath());
                    if (!isFromManifestFile) {
                        log.warning(null, 0, 0, 0, message);
                    }
                    if (verbose) {
                        JCompiler.getInstance().getOutputLog().log((Object)((String)indent + message + "\n"));
                    }
                }
            } else {
                File file = new File(url.getPath());
                if (file.isDirectory()) {
                    storagePath.add((Storage)new DirectoryStorage(file));
                } else if (file.exists()) {
                    storagePath.add((Storage)new FileStorage(file));
                }
            }
        }
    }

    static Storage[] urlPathAndDependantPathToStorageArray(boolean verbose, Translator.Log log, URLPath urlPath, List<Storage> storageList) {
        int i;
        int n;
        Storage[] result = null;
        List<URL> cpElements = Helpers.listOfUniqueClassPathElement(storageList);
        int cpElementCnt = cpElements == null ? 0 : cpElements.size();
        URL[] urls = urlPath == null ? null : urlPath.getEntries();
        int n2 = n = urls == null ? 0 : urls.length;
        if (n + cpElementCnt == 0) {
            return result;
        }
        if (verbose) {
            JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(138) + "\n"));
        }
        HashSet<URL> seenURLs = new HashSet<URL>();
        ArrayList<Storage> storagePathList = new ArrayList<Storage>(n + cpElementCnt);
        for (i = 0; i < n; ++i) {
            Helpers.addStoragePath(verbose, log, seenURLs, storagePathList, urls[i], "", null);
        }
        for (i = 0; i < cpElementCnt; ++i) {
            Helpers.addStoragePath(verbose, log, seenURLs, storagePathList, cpElements.get(i), "", null);
        }
        if (verbose) {
            JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(139) + "\n"));
        }
        return storagePathList.toArray(new Storage[storagePathList.size()]);
    }

    private static void addStringPath(boolean verbose, StringBuffer path, URL url, String separator, boolean allowNonExistingPaths) {
        if (JarUtil.isJarURL((URL)url)) {
            url = JarUtil.getJarFileURL((URL)url);
        }
        File urlFile = new File(url.getPath());
        if (allowNonExistingPaths || urlFile.exists()) {
            path.append(urlFile.getPath());
            path.append(separator);
        } else if (verbose) {
            JCompiler.getInstance().getOutputLog().log((Object)("Jar " + url.getPath() + " does not exist and will not be included on the class or module path\n"));
        }
    }

    static String urlPathAndDependantPathToString(boolean verbose, Translator.Log log, URLPath urlPath, List<Storage> storageList, String separator, boolean allowNonExistingPaths) {
        int i;
        List<URL> cpElements = Helpers.listOfUniqueClassPathElement(storageList);
        URL[] urls = urlPath == null ? null : urlPath.getEntries();
        StringBuffer path = new StringBuffer(30);
        if (urls != null) {
            for (i = 0; i < urls.length; ++i) {
                Helpers.addStringPath(verbose, path, urls[i], separator, allowNonExistingPaths);
            }
        }
        if (cpElements != null) {
            for (i = 0; i < cpElements.size(); ++i) {
                Helpers.addStringPath(verbose, path, cpElements.get(i), separator, allowNonExistingPaths);
            }
        }
        if (path.length() > 0) {
            path.deleteCharAt(path.length() - 1);
        }
        return path.toString();
    }

    static String urlPathToString(boolean verbose, Translator.Log log, URLPath urlPath, String separator) {
        return Helpers.urlPathAndDependantPathToString(verbose, log, urlPath, null, separator, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL[] getUrlsThroughIndexer(Workspace ws, Project prj, QueryCriteria queryCriteria, BuildLog buildLog) {
        IndexManager manager = IndexManager.getIndexManager();
        Index index = ws == null ? manager.getIndex(prj) : manager.getIndex(ws, prj);
        BackgroundTask query = index.query(queryCriteria);
        try {
            URL[] uRLArray = (URL[])query.get();
            return uRLArray;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(CompArb.getString(76));
        }
        catch (Exception e) {
            Diagnostic diagnostic = new Diagnostic(Diagnostic.Kind.ERROR);
            diagnostic.setMessage("Unable to retrieve project content: " + e.getMessage());
            buildLog.diagnostic(diagnostic);
        }
        finally {
            index.release();
        }
        return new URL[0];
    }
}

