/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SPKIData
extends XMLElement
implements KeyInfoData {
    public SPKIData(Element element) throws DOMException {
        super(element);
    }

    public SPKIData(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    SPKIData(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", "SPKIData");
    }

    SPKIData(Document owner, byte[] sExp) throws DOMException {
        this(owner);
        this.setSExpression(sExp);
    }

    public void setSExpression(byte[] sExp) throws DOMException {
        NodeList seList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SPKISexp");
        for (int i = seList.getLength(); i > 0; --i) {
            this.removeChild(seList.item(i - 1));
        }
        Element se = this.getOwnerDocument().createElementNS("http://www.w3.org/2000/09/xmldsig#", "SPKISexp");
        XMLUtils.copyNSPrefix((Element)this.node, se);
        se.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64WithLFSeparator(sExp)));
        NodeList nList = this.getChildNodes();
        if (nList.getLength() != 0) {
            this.insertBefore(se, nList.item(0));
        } else {
            this.appendChild(se);
        }
    }

    public byte[] getSExpression() {
        String seString;
        byte[] sExp = null;
        NodeList seList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SPKISexp");
        if (seList.getLength() != 0 && (seString = XMLUtils.collectText(seList.item(0))).length() != 0) {
            sExp = Base64.fromBase64(seString);
        }
        return sExp;
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2000/09/xmldsig#SPKIData";
    }
}

