/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.keys.KeyDerivationParams;
import oracle.security.xmlsec.util.URIManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConcatKDFParams
extends KeyDerivationParams {
    public ConcatKDFParams(Document owner, String systemId) throws DOMException {
        super(owner, "http://www.w3.org/2009/xmlenc11#", "ConcatKDFParams", systemId);
    }

    public ConcatKDFParams(Document owner) throws DOMException {
        this(owner, null);
    }

    public ConcatKDFParams(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public ConcatKDFParams(Element element) throws DOMException {
        super(element);
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2009/xmlenc11#ConcatKDF";
    }

    public void setDigestMethod(String digestMethod) throws DOMException {
        this.setDigestMethod(new XSAlgorithmIdentifier(this.getOwnerDocument(), "DigestMethod", digestMethod));
    }

    public void setDigestMethod(XSAlgorithmIdentifier digestMethod) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        NodeList dv = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestValue");
        if (dv.getLength() != 0) {
            this.insertBefore(digestMethod, dv.item(0));
        } else {
            this.appendChild(digestMethod);
        }
    }

    public XSAlgorithmIdentifier getDigestMethod() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        if (nList.getLength() != 0) {
            return new XSAlgorithmIdentifier((Element)nList.item(0), this.systemId);
        }
        return null;
    }

    private byte[] unpad(byte[] val) {
        if (val == null || val.length == 0) {
            return null;
        }
        if (val[0] != 0) {
            throw new IllegalArgumentException("padding is expected to be 0 bits, but is " + val[0]);
        }
        byte[] newVal = new byte[val.length - 1];
        System.arraycopy(val, 1, newVal, 0, val.length - 1);
        return newVal;
    }

    private byte[] pad(byte[] val) {
        if (val == null || val.length == 0) {
            return null;
        }
        byte[] newVal = new byte[val.length + 1];
        newVal[0] = 0;
        System.arraycopy(val, 0, newVal, 1, val.length);
        return newVal;
    }

    public byte[] getAlgorithmID() {
        String val = this.getAttribute("AlgorithmID");
        if (val == null || val.length() == 0) {
            return null;
        }
        return this.unpad(Utils.fromHexString((String)val));
    }

    public void setAlgorithmID(byte[] val) {
        if (val == null) {
            this.setAttribute("AlgorithmID", null);
        }
        this.setAttribute("AlgorithmID", Utils.toHexString((byte[])this.pad(val)));
    }

    public byte[] getPartyUInfo() {
        String val = this.getAttribute("PartyUInfo");
        if (val == null || val.length() == 0) {
            return null;
        }
        return this.unpad(Utils.fromHexString((String)val));
    }

    public void setPartyUInfo(byte[] val) {
        if (val == null) {
            this.setAttribute("PartyUInfo", null);
        }
        this.setAttribute("PartyUInfo", Utils.toHexString((byte[])this.pad(val)));
    }

    public byte[] getPartyVInfo() {
        String val = this.getAttribute("PartyVInfo");
        if (val == null || val.length() == 0) {
            return null;
        }
        return this.unpad(Utils.fromHexString((String)val));
    }

    public void setPartyVInfo(byte[] val) {
        if (val == null) {
            this.setAttribute("PartyVInfo", null);
        }
        this.setAttribute("PartyVInfo", Utils.toHexString((byte[])this.pad(val)));
    }

    public byte[] getSuppPubInfo() {
        String val = this.getAttribute("SuppPubInfo");
        if (val == null || val.length() == 0) {
            return null;
        }
        return this.unpad(Utils.fromHexString((String)val));
    }

    public void setSuppPubInfo(byte[] val) {
        if (val == null) {
            this.setAttribute("SuppPubInfo", null);
        }
        this.setAttribute("SuppPubInfo", Utils.toHexString((byte[])this.pad(val)));
    }

    public byte[] getSuppPrivInfo() {
        String val = this.getAttribute("SuppPrivInfo");
        if (val == null || val.length() == 0) {
            return null;
        }
        return this.unpad(Utils.fromHexString((String)val));
    }

    public void setSuppPrivInfo(byte[] val) {
        if (val == null) {
            this.setAttribute("SuppPrivInfo", null);
        }
        this.setAttribute("SuppPrivInfo", Utils.toHexString((byte[])this.pad(val)));
    }

    @Override
    public byte[] deriveKey(byte[] secret, int keyDataLen) throws XECipherException {
        MessageDigest digestor;
        byte[] otherInfo;
        String digestAlg = this.getDigestMethod().getAlgorithm();
        try {
            UnsyncByteArrayOutputStream otherInfoBos = new UnsyncByteArrayOutputStream();
            byte[] val = this.getAlgorithmID();
            if (val != null) {
                otherInfoBos.write(val);
            }
            if ((val = this.getPartyUInfo()) != null) {
                otherInfoBos.write(val);
            }
            if ((val = this.getPartyVInfo()) != null) {
                otherInfoBos.write(val);
            }
            if ((val = this.getSuppPubInfo()) != null) {
                otherInfoBos.write(val);
            }
            if ((val = this.getSuppPrivInfo()) != null) {
                otherInfoBos.write(val);
            }
            otherInfo = otherInfoBos.toByteArray();
        }
        catch (IOException ex) {
            throw new XECipherException(ex);
        }
        try {
            String jceDigestAlg = URIManager.getURIManager().getJCEAlgorithm(digestAlg);
            digestor = MessageDigest.getInstance(jceDigestAlg);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XECipherException("Unknown digest algorithm " + digestAlg, ex);
        }
        int dLen = digestor.getDigestLength();
        int reps = (keyDataLen + dLen - 1) / dLen;
        int counter = 0;
        byte[] generatedKey = new byte[keyDataLen];
        byte[] toBeHashed = new byte[4 + secret.length + otherInfo.length];
        System.arraycopy(secret, 0, toBeHashed, 4, secret.length);
        System.arraycopy(otherInfo, 0, toBeHashed, 4 + secret.length, otherInfo.length);
        for (int i = 0; i < reps; ++i) {
            System.arraycopy(Utils.wordToBytes((int)counter), 0, toBeHashed, 0, 4);
            byte[] digest = digestor.digest(toBeHashed);
            if (i < reps - 1) {
                System.arraycopy(digest, 0, generatedKey, i * dLen, dLen);
                continue;
            }
            System.arraycopy(digest, 0, generatedKey, i * dLen, keyDataLen % dLen);
        }
        return generatedKey;
    }

    @Override
    public void setToDefaultParameters() {
        SecureRandom sr = new SecureRandom();
        byte[] nonce = new byte[16];
        sr.nextBytes(nonce);
        this.setAlgorithmID(new byte[0]);
        this.setPartyUInfo(nonce);
        this.setPartyVInfo(new byte[0]);
        this.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
    }
}

