/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.c14n;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.util.DSIGInitializer;
import oracle.security.xmlsec.util.URIManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class Canonicalizer {
    protected XSAlgorithmIdentifier c14nMethod;
    protected String algorithmURI;

    protected Canonicalizer() {
    }

    protected Canonicalizer(XSAlgorithmIdentifier c14nMethod) {
        if (!"CanonicalizationMethod".equals(c14nMethod.getLocalName()) && !"CanonicalizationMethod".equals(c14nMethod.getTagName())) {
            throw new IllegalArgumentException("CanonicalizationMethod element required");
        }
        this.c14nMethod = c14nMethod;
    }

    public XSAlgorithmIdentifier getC14NMethod() {
        return this.c14nMethod;
    }

    public String getAlgorithURI() {
        return this.algorithmURI;
    }

    public static Canonicalizer getInstance(XSAlgorithmIdentifier c14nMethod) throws AlgorithmIdentifierException {
        if (!"CanonicalizationMethod".equals(c14nMethod.getLocalName()) && !"CanonicalizationMethod".equals(c14nMethod.getTagName())) {
            throw new IllegalArgumentException("CanonicalizationMethod element required");
        }
        try {
            Class c = URIManager.getURIManager().getClassForURI(c14nMethod.getAlgorithm(), "canonicalizer");
            if (c == null) {
                throw new AlgorithmIdentifierException("Unknown CanonicalizationMethod algorithm URI " + c14nMethod.getAlgorithm());
            }
            try {
                Constructor x = c.getConstructor(XSAlgorithmIdentifier.class);
                Canonicalizer cn = (Canonicalizer)x.newInstance(c14nMethod);
                cn.algorithmURI = c14nMethod.getAlgorithm();
                return cn;
            }
            catch (NoSuchMethodException x) {
                Canonicalizer cn = (Canonicalizer)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                cn.algorithmURI = c14nMethod.getAlgorithm();
                return cn;
            }
        }
        catch (ClassNotFoundException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (SecurityException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (InstantiationException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (IllegalAccessException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (InvocationTargetException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (NoSuchMethodException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
    }

    public static Canonicalizer getInstance(String uri) throws AlgorithmIdentifierException {
        try {
            Class c = URIManager.getURIManager().getClassForURI(uri, "canonicalizer");
            if (c == null) {
                throw new AlgorithmIdentifierException("Unknown algorithm URI " + uri);
            }
            Canonicalizer cn = (Canonicalizer)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            cn.algorithmURI = uri;
            return cn;
        }
        catch (ClassNotFoundException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (SecurityException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (InstantiationException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (IllegalAccessException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (NoSuchMethodException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
        catch (InvocationTargetException ex) {
            throw new AlgorithmIdentifierException(ex.toString());
        }
    }

    public static Canonicalizer getInstance(boolean inclusive, boolean withComments) {
        return Canonicalizer.getInstance(inclusive, withComments, false);
    }

    public static Canonicalizer getInstance(boolean inclusive, boolean withComments, boolean c14n11) {
        try {
            if (c14n11 && inclusive) {
                return Canonicalizer.getInstance(withComments ? "http://www.w3.org/2006/12/xml-c14n11#WithComments" : "http://www.w3.org/2006/12/xml-c14n11");
            }
            if (inclusive) {
                return Canonicalizer.getInstance(withComments ? "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments" : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            }
            return Canonicalizer.getInstance(withComments ? "http://www.w3.org/2001/10/xml-exc-c14n#WithComments" : "http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        catch (AlgorithmIdentifierException ex) {
            return null;
        }
    }

    public void setInclusiveNSPrefixList(String nsPrefixList) {
    }

    public String getInclusiveNSPrefixList() {
        return null;
    }

    public abstract byte[] canonicalize(Node var1) throws CanonicalizationException;

    public InputStream canonicalizeToStream(Node source) throws CanonicalizationException {
        return new UnsyncByteArrayInputStream(this.canonicalize(source));
    }

    public abstract byte[] canonicalize(NodeList var1) throws CanonicalizationException;

    public InputStream canonicalizeToStream(NodeList source) throws CanonicalizationException {
        return new UnsyncByteArrayInputStream(this.canonicalize(source));
    }

    public abstract byte[] canonicalize(Collection var1) throws CanonicalizationException;

    public InputStream canonicalizeToStream(Collection source) throws CanonicalizationException {
        return new UnsyncByteArrayInputStream(this.canonicalize(source));
    }

    public abstract byte[] canonicalize(InputStream var1) throws CanonicalizationException;

    public InputStream canonicalizeToStream(InputStream source) throws CanonicalizationException {
        return new UnsyncByteArrayInputStream(this.canonicalize(source));
    }

    public abstract byte[] canonicalize(InputStream var1, String var2) throws CanonicalizationException;

    public InputStream canonicalizeToStream(InputStream source, String systemId) throws CanonicalizationException {
        return new UnsyncByteArrayInputStream(this.canonicalize(source, systemId));
    }

    public abstract byte[] canonicalize(InputSource var1) throws CanonicalizationException;

    public InputStream canonicalizeToStream(InputSource source) throws CanonicalizationException {
        return new UnsyncByteArrayInputStream(this.canonicalize(source));
    }

    static {
        DSIGInitializer.initialize();
    }
}

