/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.javatools.db.DBObjectProvider;

public class RenameTableModel
extends DefaultTableModel {
    private List<AVBaseMeasure> measuresToRename;
    private final int NAME_COLUMN = 0;
    private final int CAPTION_COLUMN = 1;
    private final int DESCRIPTION_COLUMN = 2;
    private DBObjectProvider prov;

    public RenameTableModel() {
        this.addColumn(HCSArb.getString("RENAME_TABLE_MODEL_NAME"));
        this.addColumn(HCSArb.getString("RENAME_TABLE_MODEL_CAPTION"));
        this.addColumn(HCSArb.getString("RENAME_TABLE_MODEL_DESCRIPTION"));
    }

    public RenameTableModel(List<AVBaseMeasure> list, DBObjectProvider dBObjectProvider) {
        this();
        this.setMeasures(list);
        this.setProvider(dBObjectProvider);
    }

    private void setMeasures(List<AVBaseMeasure> list) {
        this.measuresToRename = list;
    }

    private void setProvider(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    public void clear() {
        this.setRowCount(0);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = null;
        AVBaseMeasure aVBaseMeasure = this.measuresToRename.get(n);
        switch (n2) {
            case 0: {
                string = this.prov.getExternalName(aVBaseMeasure.getName());
                break;
            }
            case 1: {
                string = aVBaseMeasure.getCaption();
                break;
            }
            case 2: {
                string = aVBaseMeasure.getDescription();
            }
        }
        return string;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        AVBaseMeasure aVBaseMeasure = this.measuresToRename.get(n);
        switch (n2) {
            case 0: {
                aVBaseMeasure.setName((String)object);
                break;
            }
            case 1: {
                aVBaseMeasure.setCaption((String)object);
                break;
            }
            case 2: {
                aVBaseMeasure.setDescription((String)object);
            }
        }
        this.fireTableChanged(new TableModelEvent(this, n, n, n2, 0));
    }

    @Override
    public void addRow(Object[] objectArray) {
        boolean bl = false;
        for (int i = 0; i < super.getRowCount(); ++i) {
            String string = String.valueOf(this.getValueAt(i, 0));
            if (!string.equalsIgnoreCase(String.valueOf(objectArray[0]))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            super.addRow(objectArray);
        }
    }
}

