/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.ArrayList;
import java.util.List;
import oracle.hcs.actions.AbstractDropHCSObjectAction;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.ConfirmDropMeasurePanel;
import oracle.hcs.actions.DropMeasuresHelper;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.metadata.HCSSchema;
import oracle.ide.editor.Editor;

public abstract class AbstractDropMeasureAction
extends AbstractDropHCSObjectAction {
    private AVBaseMeasure measure;
    private String analyticViewName;
    protected static final String CALC_MEASURE = "DERIVED";
    protected static final String BASE_MEASURE = "BASE";
    private static final String ANALYTIC_VIEW_TYPE = "ANALYTIC VIEW";
    private static final String HELP_ID = "av_drop_measures";
    private HCSSchema schema;

    @Override
    protected AlterHCSObjectHelper getHelper() throws Exception {
        DropMeasuresHelper dropMeasuresHelper = null;
        this.schema = this.getSchema();
        this.analyticViewName = this.getAVName();
        this.measure = this.getMeasure();
        AnalyticView analyticView = this.schema.findAV(this.analyticViewName);
        dropMeasuresHelper = new DropMeasuresHelper(analyticView, this.schema, this.measure.getName(), this.analyticViewName, this.getDBObject());
        dropMeasuresHelper.setDropMeasureActionReference(this);
        return dropMeasuresHelper;
    }

    protected abstract String getAVName();

    protected abstract AVBaseMeasure getMeasure();

    @Override
    protected String getParentObjectName() {
        return this.getAVName();
    }

    @Override
    protected String getParentObjectType() {
        return ANALYTIC_VIEW_TYPE;
    }

    @Override
    protected String getObjectName() {
        return this.measure.getName();
    }

    @Override
    protected abstract String getTitle(String var1);

    @Override
    protected abstract String getProgressMessage();

    @Override
    protected ActionConfirmPanel getConfirmationPanel() {
        ActionConfirmPanel actionConfirmPanel = null;
        if (this.measure != null && this.actionHelper != null) {
            actionConfirmPanel = this.getDropMeasurePanel(this.measure, (List)this.actionHelper.getDependencies());
        }
        return actionConfirmPanel;
    }

    @Override
    protected String getHelpID() {
        return HELP_ID;
    }

    public abstract String getDropMeasureLabel(String var1);

    public abstract String getDropMeasureConfirmation(String var1);

    private ActionConfirmPanel getDropMeasurePanel(AVBaseMeasure aVBaseMeasure, List<AVBaseMeasure> list) {
        ArrayList<AVBaseMeasure> arrayList = new ArrayList<AVBaseMeasure>();
        String string = aVBaseMeasure.getAV().getSchema().getName();
        arrayList.add(aVBaseMeasure);
        return new ConfirmDropMeasurePanel(arrayList, list, string);
    }

    @Override
    protected void actionPostProcess() {
        String string = String.format("%s.%s", this.analyticViewName, this.measure.getName());
        this.closeEditorForDroppedObjects(string);
        this.refreshNavigator(this.getDBObject(), this.analyticViewName);
    }

    @Override
    protected List<Editor> findEditorsToClose(String string, List<Editor> list) {
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        IdentifierElement identifierElement = new IdentifierElement(string);
        String string2 = "";
        String string3 = "";
        if (identifierElement.getCount() == 2) {
            string2 = identifierElement.getFirst();
            string3 = identifierElement.getSecond();
        }
        List list2 = (List)this.actionHelper.getDependencies();
        for (Editor editor : list) {
            String string4 = editor.getTabLabel();
            if (string4.equalsIgnoreCase(string3) || string4.equalsIgnoreCase(String.format("%s.%s", string2, string3))) {
                arrayList.add(editor);
            }
            for (AVBaseMeasure aVBaseMeasure : list2) {
                if (!string4.equalsIgnoreCase(String.format("%s.%s", string2, aVBaseMeasure.getName()))) continue;
                arrayList.add(editor);
            }
        }
        return arrayList;
    }

    @Override
    protected boolean isVisibleForceCreateCheckBox() {
        return true;
    }
}

