/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ViewDataAction;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.avviewer.AVViewerDialog;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;
import oracle.ide.Ide;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AVViewDataAction
extends ViewDataAction {
    private static final Logger LOG = Logger.getLogger(AVViewDataAction.class.getName());
    private AVViewerDialog dvdlg;
    private static Queries queries;
    private static final String XMLFILE = "/oracle/hcs/actions/actionsQueries.xml";
    private static final String QUERIES_PACKAGE = "oracle.hcs.table";
    private static final String ANALYTIC_VIEW_STATE_QUERY = "analyticViewState";
    private static final String COMPILE_OBJECT_SQL = "compileObject";
    private static final String OWNER = "OWNER";
    private static final String ANALYTIC_VIEW_NAME = "ANALYTIC_VIEW_NAME";
    private static final String INVALID = "INVALID";

    @Override
    public void showData(DBObject dBObject) throws Exception {
        this.showViewerDialog(dBObject);
    }

    private void showViewerDialog(DBObject dBObject) throws Exception {
        final String string = dBObject.getConnectionName();
        final String string2 = dBObject.getSchemaName();
        final String string3 = dBObject.getObjectName();
        String string4 = dBObject.getObjectType();
        final OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        DBUtil dBUtil = DBUtil.getInstance((Connection)oracleDatabaseImpl.getConnection());
        if (oracleDatabaseImpl != null) {
            String string5 = String.format(this.getQuery(COMPILE_OBJECT_SQL), string4, string2, string3);
            dBUtil.execute(string5);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(OWNER, string2);
            hashMap.put(ANALYTIC_VIEW_NAME, string3);
            String string6 = dBUtil.executeReturnOneCol(this.getQuery(ANALYTIC_VIEW_STATE_QUERY), hashMap);
            if (string6 == null || string6.equalsIgnoreCase(INVALID)) {
                throw new Exception(HCSArb.format("AV_DATA_VIEWER_INVALID_ANALYTIC_VIEW", string3));
            }
            String string7 = HCSArb.getString("DATA_VIEWER_INITIALIZING_BUZY_BAR_TITLE");
            RaptorTask raptorTask = new RaptorTask(string7, true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    try {
                        this.setMessage(HCSArb.getString("AV_DATA_VIEWER_READ_METADATA_MSG"));
                        HCSSchema hCSSchema = HCSMetadataCache.getUpdatedSchema(string, string2);
                        AnalyticView analyticView = hCSSchema.findAV(string3);
                        if (analyticView == null) {
                            HCSMetadataCache.removeSchema(string, string2);
                            hCSSchema = HCSMetadataCache.getUpdatedSchema(string, string2);
                            analyticView = hCSSchema.findAV(string3);
                        }
                        String string4 = AVViewDataAction.this.getObjectNamesForQuery(analyticView);
                        List<String> list = AVViewDataAction.this.getAvailableLanguageDescriptions(string4);
                        AVViewDataAction.this.unselectAllMeasures(analyticView);
                        AVViewDataAction.this.dvdlg = new AVViewerDialog((JFrame)Ide.getMainWindow(), oracleDatabaseImpl, analyticView, list);
                    }
                    catch (Exception exception) {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    return bl;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            AVViewDataAction.this.warn(throwable);
                            AVViewDataAction.this.showErrorDialog(throwable);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (AVViewDataAction.this.dvdlg != null) {
                                AVViewDataAction.this.dvdlg.setModal(true);
                                AVViewDataAction.this.dvdlg.setDefaultCloseOperation(2);
                                AVViewDataAction.this.dvdlg.setMinimumSize(new Dimension(400, 400));
                                AVViewDataAction.this.dvdlg.setLocationRelativeTo((Component)Ide.getMainWindow());
                                AVViewDataAction.this.dvdlg.setVisible(true);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        }
    }

    private String getObjectNamesForQuery(AnalyticView analyticView) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
            arrayList.add(String.format("'%s'", aVDimensionality.getName()));
            for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                arrayList.add(String.format("'%s'", aVHierarchy.getName()));
            }
        }
        arrayList.add(String.format("'%s'", analyticView.getName()));
        String string = String.join((CharSequence)",", arrayList);
        return string;
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = QUERIES_PACKAGE;
                String string3 = JavaXMLBind.LoadDocument(((Object)((Object)this)).getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, (Object)this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        AVViewDataAction.queries = queries;
    }

    private void unselectAllMeasures(AnalyticView analyticView) {
        for (AVMeasure aVBaseMeasure : analyticView.getMeasures()) {
            aVBaseMeasure.setSelected(false);
        }
        for (AVBaseMeasure aVBaseMeasure : analyticView.getCalculatedMeasures()) {
            aVBaseMeasure.setSelected(false);
        }
    }

    @Override
    protected String getErrorTitle() {
        return HCSArb.get("AV_DATA_VIEWER_ERROR_TITLE");
    }
}

