-- Creates a ODMR_SALES_DATA table that contains pre 12.2 data from the SH.SALES table (a 1500 rows subset)
-- Paramters:
-- 1. User account - account to load the table into
-- Example:
-- @instSalesData.sql DMUSER
--------------------------------------------------------

EXECUTE dbms_output.put_line('');
EXECUTE dbms_output.put_line('Load Data Miner demo table ODMR_SALES_DATA.');
EXECUTE dbms_output.put_line('');


-- Drop table if it already exists
-- NOTE: ERRORS ARE OK FOR THE DROP TABLE AS IT CONFIRMS THE TABLE DOES NOT EXIST
DECLARE
v_sql varchar2(100); 
user_account_value varchar2(120);
BEGIN

user_account_value := q'[&&1]';

-- Change to the new user schema
BEGIN
v_sql := 'ALTER session set current_schema = "' || user_account_value || '" ' ; -- Enter the user schema
EXECUTE IMMEDIATE v_sql;
DBMS_OUTPUT.PUT_LINE (v_sql ||': succeeded');
EXCEPTION
WHEN OTHERS THEN
DBMS_OUTPUT.PUT_LINE (v_sql ||': ***  Failed ***');
raise;
END;

v_sql := 'DROP TABLE ODMR_SALES_DATA';
EXECUTE IMMEDIATE v_sql;
DBMS_OUTPUT.PUT_LINE (v_sql ||': succeeded');
EXCEPTION
WHEN OTHERS THEN
DBMS_OUTPUT.PUT_LINE (v_sql ||': drop unneccessary - no table/view exists');
END;
/

--------------------------------------------------------
--  DDL for Table ODMR_SALES_DATA
--------------------------------------------------------

create table ODMR_SALES_DATA (PROD_ID NUMBER, CUST_ID NUMBER, TIME_ID DATE, 
                              CHANNEL_ID NUMBER, PROMO_ID NUMBER, 
                              QUANTITY_SOLD NUMBER(10,2), AMOUNT_SOLD NUMBER(10,2)) NOLOGGING;
   

REM INSERTING a subset of SH.SALES into ODMR_SALES_DATA

SET DEFINE OFF

INSERT ALL
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,987,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1660,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1762,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1843,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1948,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2273,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2380,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2683,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2865,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4663,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5203,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5321,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5590,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6277,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6859,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,8540,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,9076,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,12099,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,35834,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,524,to_date('20-JAN-98','DD-MON-RR'),2,999,1,1205.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,188,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,361,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,531,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,659,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,848,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,949,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1242,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1291,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1422,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1485,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1580,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1943,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1959,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2021,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2142,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3014,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3053,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3261,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3783,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3947,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4523,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5813,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6543,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,7076,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,7421,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,8747,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,8787,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,8836,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,9052,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,9680,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,9802,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,10502,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,10844,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,14053,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,14457,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,17011,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,17566,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,17633,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,254,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,429,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1298,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1383,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1758,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1786,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1849,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1949,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2004,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2079,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2310,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2383,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2914,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2994,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3215,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3429,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3960,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4203,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4759,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4942,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5681,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6279,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6417,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6430,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6913,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,7086,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,7468,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,7873,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,7902,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,8236,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,8686,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,8935,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,9039,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,9317,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,10268,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,11131,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,11453,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,12783,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,15826,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,26631,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1232.16)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,343,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,966,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1946,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2113,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2125,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2530,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2839,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3454,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3548,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4700,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5164,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5475,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5731,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6955,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,7078,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,7995,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,10978,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,12824,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,15217,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,17081,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,26626,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,186,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,238,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,288,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,299,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,314,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,411,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,533,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,788,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,953,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1155,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1255,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1462,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1838,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1998,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2600,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2760,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2855,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3087,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3317,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3643,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3720,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4230,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4622,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4881,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4974,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5696,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5724,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6612,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6905,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,8345,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,9366,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,11407,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,11702,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,12539,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,12809,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,25244,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,28526,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,33722,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,40417,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1237.31)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,122,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,220,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,276,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,307,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,383,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,411,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,657,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,953,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1154,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1255,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1455,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1567,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1837,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2084,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2211,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2600,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2760,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2855,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3316,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3539,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,3720,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4120,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4621,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4881,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,4973,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5696,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5723,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6612,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,8324,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,9366,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,11403,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,11457,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,12119,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,12539,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,25244,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,28522,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,33717,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,33722,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,33748,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,945,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,987,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,1844,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2128,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2380,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2423,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2683,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,2869,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,5203,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,6277,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,9035,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,12099,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (13,35834,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1232.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,205,to_date('03-JAN-98','DD-MON-RR'),3,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,228,to_date('03-JAN-98','DD-MON-RR'),3,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5378,to_date('03-JAN-98','DD-MON-RR'),3,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7983,to_date('03-JAN-98','DD-MON-RR'),3,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9728,to_date('03-JAN-98','DD-MON-RR'),3,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,26448,to_date('03-JAN-98','DD-MON-RR'),3,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,205,to_date('03-JAN-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,228,to_date('03-JAN-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5378,to_date('03-JAN-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,429,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2903,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3001,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4759,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9038,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12783,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,429,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1297,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1441,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1846,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2903,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2994,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4759,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6279,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6430,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12783,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2994,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1265.03)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6279,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1265.03)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9038,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1265.03)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,915,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,932,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1689,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1847,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1948,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2077,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2883,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3550,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3557,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4518,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6221,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6859,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6957,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7083,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7872,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8685,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,26630,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,29313,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10007,to_date('14-JAN-98','DD-MON-RR'),2,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10007,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10007,to_date('14-JAN-98','DD-MON-RR'),4,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,965,to_date('16-JAN-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10667,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3047,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1112.87)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8318,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1112.87)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9882,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1112.87)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10667,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1112.87)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,19683,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1112.87)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,22478,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1112.87)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3047,to_date('17-JAN-98','DD-MON-RR'),4,999,1,1112.87)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8318,to_date('17-JAN-98','DD-MON-RR'),4,999,1,1112.87)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,22478,to_date('17-JAN-98','DD-MON-RR'),4,999,1,1112.87)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5028,to_date('18-JAN-98','DD-MON-RR'),3,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5028,to_date('18-JAN-98','DD-MON-RR'),4,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1385,to_date('19-JAN-98','DD-MON-RR'),2,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2622,to_date('19-JAN-98','DD-MON-RR'),3,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,27197,to_date('20-JAN-98','DD-MON-RR'),2,999,1,1163.47)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,387,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2073,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3947,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5847,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6543,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10844,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12605,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,27197,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3618,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,14,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,181,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,188,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,249,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,531,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,949,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1260,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1386,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1423,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1758,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1959,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2000,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2004,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2013,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2762,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3014,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3268,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3618,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3783,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4414,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5813,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6264,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6394,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6488,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7076,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7993,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9052,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9680,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,14053,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,16247,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,25938,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,39084,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3618,to_date('21-JAN-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,249,to_date('22-JAN-98','DD-MON-RR'),3,999,1,1239.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1758,to_date('22-JAN-98','DD-MON-RR'),3,999,1,1239.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2004,to_date('22-JAN-98','DD-MON-RR'),3,999,1,1239.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8825,to_date('22-JAN-98','DD-MON-RR'),3,999,1,1239.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8825,to_date('22-JAN-98','DD-MON-RR'),4,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10002,to_date('23-JAN-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1666,to_date('23-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10002,to_date('23-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3618,to_date('24-JAN-98','DD-MON-RR'),2,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3618,to_date('24-JAN-98','DD-MON-RR'),3,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3618,to_date('24-JAN-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,444,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1841,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1946,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4977,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5587,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6955,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,11408,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,11443,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,17081,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,26626,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7053,to_date('28-JAN-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1538,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1547,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1782,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3368,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7053,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1538,to_date('28-JAN-98','DD-MON-RR'),4,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1406,to_date('29-JAN-98','DD-MON-RR'),3,999,1,1239.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,513,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,678,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1369,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2798,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3215,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4203,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4465,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5035,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5351,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7902,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8268,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9317,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10756,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,11131,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,15826,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1812,to_date('02-FEB-98','DD-MON-RR'),2,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5378,to_date('02-FEB-98','DD-MON-RR'),2,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7983,to_date('02-FEB-98','DD-MON-RR'),2,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9728,to_date('02-FEB-98','DD-MON-RR'),2,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10261,to_date('02-FEB-98','DD-MON-RR'),2,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1713,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3361,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5378,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7983,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9728,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1812,to_date('02-FEB-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5378,to_date('02-FEB-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7983,to_date('02-FEB-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9728,to_date('02-FEB-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10261,to_date('02-FEB-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3732,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1164.05)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4053,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1164.05)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6316,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1164.05)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,945,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1293,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1844,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2380,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2869,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2993,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3375,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5732,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9038,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12782,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12783,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1298,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1439,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1844,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2044,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2380,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2869,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2993,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3375,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5204,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5732,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6278,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8543,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9037,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9038,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12782,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12783,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,30605,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1844,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2993,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3375,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6278,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9038,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12782,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12783,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12123,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2266,to_date('14-FEB-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2973,to_date('14-FEB-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2978,to_date('14-FEB-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,11597,to_date('14-FEB-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12655,to_date('14-FEB-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,305,to_date('14-FEB-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1658,to_date('14-FEB-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2598,to_date('14-FEB-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4248,to_date('14-FEB-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8117,to_date('14-FEB-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,11597,to_date('14-FEB-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,725,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,783,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1591,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2525,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3438,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3737,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4195,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5027,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5808,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8583,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8866,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,11073,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,20395,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,22478,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,458,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1591,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2018,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2525,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2866,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3438,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3545,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3737,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4195,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5027,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5808,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8583,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8866,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,11073,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12526,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,16062,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,20395,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,22478,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1156,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1577,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5855,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6033,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6115,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1577,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5855,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6115,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,462,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,691,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2103,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2522,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3087,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3096,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3121,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3618,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3968,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4040,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4334,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4471,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4655,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,13715,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,33732,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3618,to_date('20-FEB-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4655,to_date('20-FEB-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,33732,to_date('20-FEB-98','DD-MON-RR'),4,999,1,1108.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2013,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4414,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5163,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6394,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7003,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7993,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8488,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,25938,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,39084,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7053,to_date('26-FEB-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,205,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1547,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7053,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7715,to_date('28-FEB-98','DD-MON-RR'),2,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7801,to_date('28-FEB-98','DD-MON-RR'),2,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7715,to_date('28-FEB-98','DD-MON-RR'),4,999,1,1124.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1475,to_date('02-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2028,to_date('02-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4688,to_date('02-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7981,to_date('02-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9377,to_date('02-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,678,to_date('03-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,678,to_date('03-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9162,to_date('03-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1846,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2994,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4759,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5733,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9038,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,12783,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6586,to_date('10-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,13152,to_date('10-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,183,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,915,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,932,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1364,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1689,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1949,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2079,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2238,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3550,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3557,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6859,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6957,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7083,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7606,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7872,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8685,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,13152,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,26630,to_date('10-MAR-98','DD-MON-RR'),3,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,648,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6912,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9278,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,18145,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2957,to_date('14-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,305,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,488,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2268,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2973,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2978,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3505,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3648,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5236,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8117,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,305,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,488,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2266,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2973,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3505,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4248,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8117,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4157,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4803,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1518,to_date('20-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2073,to_date('20-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,387,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1487,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1518,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3458,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3736,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3811,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5325,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5493,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5517,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6540,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6543,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6976,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8789,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10502,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10844,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,44780,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1277.63)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2073,to_date('20-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,27197,to_date('20-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,14,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,181,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,188,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,531,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,949,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1260,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1386,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1423,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2004,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2013,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2080,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2653,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3025,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3268,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,3788,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4414,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5813,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6264,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6394,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,6488,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7606,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7993,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9052,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9680,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,14457,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,25938,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,33726,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,39084,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1264.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1478,to_date('23-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1666,to_date('23-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5562,to_date('23-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9492,to_date('23-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10113,to_date('23-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,5562,to_date('23-MAR-98','DD-MON-RR'),4,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9492,to_date('23-MAR-98','DD-MON-RR'),4,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10113,to_date('23-MAR-98','DD-MON-RR'),4,999,1,1159.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,185,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,288,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,314,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,533,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,788,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1155,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1743,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4974,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,8345,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,9016,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,10747,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,11407,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,11702,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1259.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,2746,to_date('28-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7157,to_date('28-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,7053,to_date('28-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1156,to_date('30-MAR-98','DD-MON-RR'),2,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1156,to_date('30-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,4471,to_date('30-MAR-98','DD-MON-RR'),3,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (14,1156,to_date('30-MAR-98','DD-MON-RR'),4,999,1,1176.23)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3718,to_date('02-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,33763,to_date('02-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1104,to_date('02-JAN-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,205,to_date('03-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5378,to_date('03-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7983,to_date('03-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9728,to_date('03-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2994,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1003.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4759,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1003.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5733,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1003.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6279,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1003.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9038,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1003.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,429,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1089,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1297,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2382,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2994,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4759,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5733,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6279,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6430,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9038,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9234,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,12783,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1468,to_date('10-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3043,to_date('10-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3538,to_date('10-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8638,to_date('10-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,11603,to_date('10-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1468,to_date('10-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2098,to_date('10-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2304,to_date('10-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3043,to_date('10-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8638,to_date('10-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,11603,to_date('10-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1466,to_date('10-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8638,to_date('10-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,11603,to_date('10-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3006,to_date('14-JAN-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3538,to_date('14-JAN-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3006,to_date('14-JAN-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,27323,to_date('14-JAN-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3484,to_date('16-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3584,to_date('16-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8586,to_date('16-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3484,to_date('16-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3584,to_date('16-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8583,to_date('16-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3484,to_date('16-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3584,to_date('16-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8586,to_date('16-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1448,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2745,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5785,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8866,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9883,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,22478,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1626,to_date('17-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3203,to_date('17-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,22478,to_date('17-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1385,to_date('19-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3538,to_date('19-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5126,to_date('19-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,443,to_date('19-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,765,to_date('19-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1385,to_date('19-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1398,to_date('19-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3803,to_date('19-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5126,to_date('19-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1385,to_date('19-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5126,to_date('19-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8445,to_date('19-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3946,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7443,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3084,to_date('20-JAN-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7426,to_date('20-JAN-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3618,to_date('21-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,405,to_date('21-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1458,to_date('21-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1928,to_date('21-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2004,to_date('21-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3618,to_date('21-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8806,to_date('21-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10986,to_date('21-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2004,to_date('22-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3618,to_date('24-JAN-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,405,to_date('24-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1458,to_date('24-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1928,to_date('24-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3618,to_date('24-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8806,to_date('24-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10986,to_date('24-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1928,to_date('24-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3618,to_date('24-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8806,to_date('24-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10986,to_date('24-JAN-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,187,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,427,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,444,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,519,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,954,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1578,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1841,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1946,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2005,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2125,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2839,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3127,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3454,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3548,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4977,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5475,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5587,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5727,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6955,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7078,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7156,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7871,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7995,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8347,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10584,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,11408,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,11443,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,17081,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,26634,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,33725,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10584,to_date('25-JAN-98','DD-MON-RR'),4,999,1,1002.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6038,to_date('28-JAN-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1284,to_date('28-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1538,to_date('28-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,12586,to_date('28-JAN-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,228,to_date('02-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10261,to_date('02-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,228,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4597,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5378,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9728,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,228,to_date('02-FEB-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5378,to_date('02-FEB-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10261,to_date('02-FEB-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,26448,to_date('02-FEB-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,28,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3577,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2869,to_date('05-FEB-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2993,to_date('05-FEB-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3375,to_date('05-FEB-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5204,to_date('05-FEB-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5732,to_date('05-FEB-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9038,to_date('05-FEB-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,12782,to_date('05-FEB-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2993,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1003.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9037,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1003.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9038,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1003.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,12782,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1003.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,12783,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1003.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,141,to_date('10-FEB-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6106,to_date('10-FEB-98','DD-MON-RR'),2,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4197,to_date('10-FEB-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4501,to_date('10-FEB-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,141,to_date('10-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6106,to_date('10-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1546,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1681,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1761,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4317,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5717,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9966,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1681,to_date('14-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1761,to_date('14-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2006,to_date('14-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3341,to_date('14-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4317,to_date('14-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9681,to_date('14-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9966,to_date('14-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5808,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8866,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,22478,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1448,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1626,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2977,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5808,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8866,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,22478,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1577,to_date('17-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5028,to_date('17-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6508,to_date('17-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1561,to_date('17-FEB-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6118,to_date('17-FEB-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,14937,to_date('17-FEB-98','DD-MON-RR'),3,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1577,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2597,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5028,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5418,to_date('19-FEB-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,118,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3618,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10608,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,621,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1758,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2157,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3121,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3618,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10608,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10986,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3618,to_date('20-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7748,to_date('20-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10608,to_date('20-FEB-98','DD-MON-RR'),4,999,1,999.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,118,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1241,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1886,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,381,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1241,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1886,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3201,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,118,to_date('23-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10618,to_date('23-FEB-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1686,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2461,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10618,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,11568,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1260,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2013,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2762,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4414,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5163,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6264,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6394,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7003,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7993,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,25938,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,39084,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,14,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,181,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1260,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2000,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2013,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2105,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2529,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3268,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,3702,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4045,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4414,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4922,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,5163,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6264,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6394,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6488,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7003,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7993,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8488,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8886,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10989,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,14865,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,25938,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,39084,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1003.49)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1401,to_date('28-FEB-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,8406,to_date('28-FEB-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10421,to_date('28-FEB-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,7801,to_date('28-FEB-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,10421,to_date('28-FEB-98','DD-MON-RR'),4,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,429,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1297,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2994,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4759,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6279,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9038,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,12783,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,429,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1089,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1297,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,1846,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2947,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,2994,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,4759,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,6279,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9038,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,9234,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,12788,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (15,33723,to_date('05-MAR-98','DD-MON-RR'),3,999,1,1013.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,214,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,429,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1089,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1297,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1441,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1846,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2382,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2903,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2994,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4759,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5733,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6279,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6430,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9038,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9234,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,12783,to_date('05-JAN-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1297,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2382,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4759,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6417,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9038,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,12783,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,524,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,932,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1637,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1948,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2077,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2906,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3550,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3557,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4398,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6221,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6859,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6957,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7083,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7872,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,8685,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,26630,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,361,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,387,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3947,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5517,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5847,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6540,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6543,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,8787,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9802,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,10502,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,10844,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,11497,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,33735,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,249,to_date('22-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,524,to_date('22-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2004,to_date('22-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,444,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,519,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3127,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4977,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5475,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5587,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7078,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7156,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7871,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7995,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,8340,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,8347,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,11408,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,11443,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,17081,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,26626,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,187,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,288,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,314,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,444,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,533,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,575,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,629,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,788,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,953,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1155,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1406,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1946,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2005,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2125,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2839,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
select * from dual;


Insert all
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3103,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3454,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3548,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4973,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5475,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5724,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6465,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6955,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7078,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7871,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7995,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,8324,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,8384,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9366,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,11403,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,11457,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,17081,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,26626,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,28526,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,33725,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1406,to_date('29-JAN-98','DD-MON-RR'),3,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1369,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2798,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2819,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2952,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3019,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3216,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5351,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7468,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7902,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,8198,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9317,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,11131,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,11453,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,15826,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,945,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1293,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1297,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1439,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1661,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1663,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1844,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2869,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2993,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3375,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5204,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5732,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6278,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,8543,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9037,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9038,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,12782,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,12783,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,30605,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,33723,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1297,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1844,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3375,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5204,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5732,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6968,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9038,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,12783,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1495.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,8563,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1516.93)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,462,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,691,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1758,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2086,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2103,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2324,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3087,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3096,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3216,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3968,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4008,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4334,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4337,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,11662,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,12072,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,13715,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,181,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1260,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2000,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2013,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2762,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3268,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4414,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6264,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6394,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6488,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,7993,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,25938,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,39084,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,186,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,276,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,307,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,411,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,845,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1255,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1462,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1567,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1837,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1998,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2406,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2600,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2760,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2855,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3279,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3316,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3403,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,3720,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4045,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4230,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5310,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5696,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5698,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6264,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6534,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6612,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6905,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,12119,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,12539,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,25244,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,33722,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,33726,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,33748,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,42420,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1556.42)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,429,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1846,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2914,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2994,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4759,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5733,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9038,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9234,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,12783,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1297,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2903,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,2994,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4759,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5733,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6279,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9038,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9234,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,12783,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,361,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5325,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,5847,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6540,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6543,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9802,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,10014,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,10844,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,12101,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,33735,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1572.7)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,185,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,275,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,288,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,314,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,533,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,788,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1155,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,1743,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,4974,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,6465,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,8345,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,9016,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,10747,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,11220,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,11407,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (17,11702,to_date('25-MAR-98','DD-MON-RR'),3,999,1,1550.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3995,to_date('03-JAN-98','DD-MON-RR'),2,999,1,1681.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6374,to_date('03-JAN-98','DD-MON-RR'),2,999,1,1681.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2994,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9038,to_date('05-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,429,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1846,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2994,to_date('05-JAN-98','DD-MON-RR'),4,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5865,to_date('07-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,12326,to_date('07-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3166,to_date('08-JAN-98','DD-MON-RR'),3,999,1,1639.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1325,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1433,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1847,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2189,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2349,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2491,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3007,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3512,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3671,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4518,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8638,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,29313,to_date('10-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1433,to_date('10-JAN-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1466,to_date('10-JAN-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1847,to_date('10-JAN-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4518,to_date('10-JAN-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8638,to_date('10-JAN-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,447,to_date('14-JAN-98','DD-MON-RR'),2,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1461,to_date('14-JAN-98','DD-MON-RR'),2,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3006,to_date('14-JAN-98','DD-MON-RR'),2,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3667,to_date('14-JAN-98','DD-MON-RR'),2,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10007,to_date('14-JAN-98','DD-MON-RR'),2,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,23171,to_date('14-JAN-98','DD-MON-RR'),2,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33765,to_date('14-JAN-98','DD-MON-RR'),2,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,447,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1461,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3006,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3206,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3326,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3667,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4066,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7931,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10007,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,12207,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,14565,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,23171,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33765,to_date('14-JAN-98','DD-MON-RR'),3,999,1,1442.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3326,to_date('15-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2259,to_date('16-JAN-98','DD-MON-RR'),2,999,1,1681.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3499,to_date('16-JAN-98','DD-MON-RR'),2,999,1,1681.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5172,to_date('16-JAN-98','DD-MON-RR'),2,999,1,1681.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6509,to_date('16-JAN-98','DD-MON-RR'),2,999,1,1681.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1346,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2252,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2259,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2375,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3499,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4851,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5172,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6230,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6509,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7895,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10761,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,17605,to_date('16-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3587,to_date('16-JAN-98','DD-MON-RR'),4,999,1,1448.76)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,572,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,675,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,791,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,846,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,893,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2279,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2367,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3552,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4431,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6581,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10667,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,14532,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,21086,to_date('17-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3047,to_date('17-JAN-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9869,to_date('17-JAN-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10667,to_date('17-JAN-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,846,to_date('18-JAN-98','DD-MON-RR'),2,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,846,to_date('18-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1266,to_date('18-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6526,to_date('18-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2073,to_date('20-JAN-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2930,to_date('20-JAN-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5067,to_date('20-JAN-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8390,to_date('20-JAN-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,892,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1321,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1485,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3474,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3526,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7421,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11812,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,13187,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,17011,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,17633,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,20966,to_date('21-JAN-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,892,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1294,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1321,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1485,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1607,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2092,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2634,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3012,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3526,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4093,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6073,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7526,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8494,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8747,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8759,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10526,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10761,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11814,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,17011,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,17506,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,17633,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,20966,to_date('21-JAN-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,330,to_date('23-JAN-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3610,to_date('23-JAN-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,330,to_date('23-JAN-98','DD-MON-RR'),3,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2638,to_date('23-JAN-98','DD-MON-RR'),3,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3610,to_date('23-JAN-98','DD-MON-RR'),3,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7387,to_date('23-JAN-98','DD-MON-RR'),3,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5926,to_date('24-JAN-98','DD-MON-RR'),2,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5926,to_date('24-JAN-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,427,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,908,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1841,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1893,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1946,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3454,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5475,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5587,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6955,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7036,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7078,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7806,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7871,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7995,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8347,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8406,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10421,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11408,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,15554,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33746,to_date('25-JAN-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,187,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,414,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,427,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,444,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,629,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,954,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1578,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1841,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1893,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1946,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2125,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3127,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3454,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3548,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3706,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5034,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5475,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5587,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5727,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6955,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7078,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7156,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7554,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7806,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7871,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7995,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8348,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8384,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8406,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10421,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11309,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11408,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,15554,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,17081,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,26626,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,29220,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33725,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33738,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33746,to_date('25-JAN-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3087,to_date('26-JAN-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3089,to_date('26-JAN-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4040,to_date('26-JAN-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7806,to_date('26-JAN-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10887,to_date('26-JAN-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,12072,to_date('26-JAN-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,27184,to_date('26-JAN-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33746,to_date('26-JAN-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,524,to_date('27-JAN-98','DD-MON-RR'),3,999,1,1702.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,20966,to_date('28-JAN-98','DD-MON-RR'),2,999,1,1637.69)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,524,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1702.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,20966,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1702.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5428,to_date('30-JAN-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9521,to_date('30-JAN-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3647,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4053,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4389,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5766,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6316,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6431,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7935,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9255,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,541,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,994,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1275,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1706,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2011,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4053,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4346,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4389,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5766,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6316,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6431,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7935,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8492,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9255,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11392,to_date('03-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5766,to_date('03-FEB-98','DD-MON-RR'),4,999,1,1537.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7935,to_date('03-FEB-98','DD-MON-RR'),4,999,1,1537.52)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9316,to_date('04-FEB-98','DD-MON-RR'),2,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,13869,to_date('04-FEB-98','DD-MON-RR'),2,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2128,to_date('04-FEB-98','DD-MON-RR'),4,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8198,to_date('04-FEB-98','DD-MON-RR'),4,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1293,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1844,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2869,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2993,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5204,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6278,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7036,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9038,to_date('05-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,200,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,945,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1293,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1441,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1844,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2380,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2869,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2993,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3375,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5204,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5732,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6278,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9038,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,30605,to_date('05-FEB-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,945,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1293,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1844,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2869,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3375,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5204,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5732,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9038,to_date('05-FEB-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,434,to_date('07-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5891,to_date('07-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7941,to_date('07-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11953,to_date('07-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2815,to_date('10-FEB-98','DD-MON-RR'),2,999,1,1463.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3826,to_date('10-FEB-98','DD-MON-RR'),2,999,1,1463.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4032,to_date('10-FEB-98','DD-MON-RR'),2,999,1,1463.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10386,to_date('10-FEB-98','DD-MON-RR'),2,999,1,1463.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3826,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4032,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4806,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4941,to_date('10-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2815,to_date('10-FEB-98','DD-MON-RR'),4,999,1,1463.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2975,to_date('10-FEB-98','DD-MON-RR'),4,999,1,1463.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8621,to_date('10-FEB-98','DD-MON-RR'),4,999,1,1463.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,23861,to_date('10-FEB-98','DD-MON-RR'),4,999,1,1463.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,507,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,572,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,693,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,791,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,832,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1521,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1535,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2006,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2193,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2252,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2266,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2279,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2287,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2375,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2633,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2655,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2895,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3289,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3310,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3374,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3499,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3552,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3832,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3981,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4431,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4851,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5172,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6230,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6509,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6581,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6666,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6851,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7895,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9829,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9966,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10467,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,21086,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2006,to_date('14-FEB-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2266,to_date('14-FEB-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2973,to_date('14-FEB-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7895,to_date('14-FEB-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9966,to_date('14-FEB-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,550,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,846,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1269,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1934,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3501,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3541,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3626,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4195,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4432,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4433,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4712,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5027,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6235,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7496,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8806,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8866,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11073,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,22478,to_date('16-FEB-98','DD-MON-RR'),2,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,12,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,229,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,405,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,550,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,705,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,846,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1269,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1346,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1370,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1565,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1934,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2692,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3501,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3535,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3541,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3626,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4195,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4309,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4432,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4433,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4614,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4712,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5027,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6235,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7496,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7794,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8413,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8806,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8866,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11073,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,17001,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,20395,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,20904,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,22478,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33741,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,550,to_date('16-FEB-98','DD-MON-RR'),4,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1370,to_date('16-FEB-98','DD-MON-RR'),4,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4195,to_date('16-FEB-98','DD-MON-RR'),4,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4433,to_date('16-FEB-98','DD-MON-RR'),4,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6235,to_date('16-FEB-98','DD-MON-RR'),4,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7794,to_date('16-FEB-98','DD-MON-RR'),4,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8866,to_date('16-FEB-98','DD-MON-RR'),4,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11073,to_date('16-FEB-98','DD-MON-RR'),4,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,20395,to_date('16-FEB-98','DD-MON-RR'),4,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,20904,to_date('16-FEB-98','DD-MON-RR'),4,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,22478,to_date('16-FEB-98','DD-MON-RR'),4,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,615,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1156,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1675,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2390,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2554,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2555,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3254,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3274,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3775,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4635,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4649,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4947,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5855,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6001,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6033,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7566,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7969,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10155,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1638.5)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5855,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1463.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6115,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1463.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10155,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1463.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,401,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2175,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2475,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3085,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3618,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5309,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9092,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9452,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11815,to_date('20-FEB-98','DD-MON-RR'),2,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,401,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,566,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2175,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2186,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2475,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3085,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3132,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3618,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4149,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5309,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6495,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7427,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7874,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8829,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9092,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9452,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10887,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,14345,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,20966,to_date('20-FEB-98','DD-MON-RR'),3,999,1,1632.79)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,649,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1741,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2101,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3072,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4246,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4266,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8386,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,12586,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,31473,to_date('21-FEB-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,221,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,649,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1286,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1741,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1911,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2101,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2301,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2991,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3072,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3907,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4246,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4266,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5655,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6526,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6681,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7092,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7112,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7335,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7453,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8386,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8566,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10621,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,12586,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,31473,to_date('21-FEB-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2572,to_date('23-FEB-98','DD-MON-RR'),2,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2606,to_date('23-FEB-98','DD-MON-RR'),2,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5541,to_date('23-FEB-98','DD-MON-RR'),2,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2572,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2595,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2606,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2755,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2912,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5541,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7786,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10692,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11606,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,13455,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1655.65)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,181,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,781,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1260,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2013,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2084,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3268,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3465,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4414,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5489,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6264,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6394,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6488,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7993,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8488,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9535,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,25938,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,29395,to_date('25-FEB-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,14,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,32,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,181,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,781,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1053,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1260,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1555,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1981,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2000,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2013,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2105,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2365,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2529,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3021,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3268,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3465,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3784,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4045,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4273,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4414,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4660,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5310,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5489,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5725,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6264,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6394,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6488,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7993,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8488,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8886,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9535,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10275,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10989,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,25938,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,29395,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33726,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,39084,to_date('25-FEB-98','DD-MON-RR'),3,999,1,1735.04)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2054,to_date('26-FEB-98','DD-MON-RR'),2,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3654,to_date('26-FEB-98','DD-MON-RR'),2,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5720,to_date('26-FEB-98','DD-MON-RR'),2,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1451,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1547,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1691,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1986,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2054,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2104,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2524,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3654,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4628,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5720,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7053,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7155,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8885,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,14856,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,30031,to_date('26-FEB-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,513,to_date('03-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5428,to_date('03-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2929,to_date('03-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3995,to_date('03-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4895,to_date('03-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6374,to_date('03-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7652,to_date('03-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,513,to_date('03-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5428,to_date('03-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3215,to_date('04-MAR-98','DD-MON-RR'),3,999,1,1735.91)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4213,to_date('04-MAR-98','DD-MON-RR'),3,999,1,1735.91)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5681,to_date('04-MAR-98','DD-MON-RR'),3,999,1,1735.91)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7468,to_date('04-MAR-98','DD-MON-RR'),3,999,1,1735.91)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8198,to_date('04-MAR-98','DD-MON-RR'),3,999,1,1735.91)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11131,to_date('04-MAR-98','DD-MON-RR'),3,999,1,1735.91)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,15826,to_date('04-MAR-98','DD-MON-RR'),3,999,1,1735.91)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1089,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1298,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2914,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5733,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9038,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9234,to_date('05-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,429,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1089,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2994,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5733,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9038,to_date('05-MAR-98','DD-MON-RR'),4,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,269,to_date('07-MAR-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5009,to_date('07-MAR-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5201,to_date('07-MAR-98','DD-MON-RR'),3,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1325,to_date('10-MAR-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2124,to_date('10-MAR-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2491,to_date('10-MAR-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3007,to_date('10-MAR-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3512,to_date('10-MAR-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3671,to_date('10-MAR-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4724,to_date('10-MAR-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,20910,to_date('10-MAR-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,24561,to_date('10-MAR-98','DD-MON-RR'),2,999,1,1697.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,735,to_date('10-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2124,to_date('10-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4724,to_date('10-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,20910,to_date('10-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,29313,to_date('10-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1113,to_date('11-MAR-98','DD-MON-RR'),4,999,1,1680.25)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1231,to_date('11-MAR-98','DD-MON-RR'),4,999,1,1680.25)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1461,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3294,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9690,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,23171,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1461,to_date('14-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1713,to_date('14-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2933,to_date('14-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3206,to_date('14-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3294,to_date('14-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4285,to_date('14-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7931,to_date('14-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9690,to_date('14-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,14333,to_date('14-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,23171,to_date('14-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2973,to_date('16-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5172,to_date('16-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5236,to_date('16-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6553,to_date('16-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,507,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2252,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2375,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2896,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2973,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3310,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3499,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3832,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3981,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5172,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5236,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6509,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6553,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6747,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7896,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,21787,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,44733,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2266,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2286,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2671,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2896,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2973,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7896,to_date('16-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,791,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,893,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1575,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2193,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3553,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4313,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4431,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6581,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9829,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10467,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,21086,to_date('17-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33,to_date('17-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1554,to_date('17-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4313,to_date('17-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4469,to_date('18-MAR-98','DD-MON-RR'),4,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,450,to_date('20-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1924,to_date('20-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2073,to_date('20-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2384,to_date('20-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1487,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1924,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1990,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2234,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2384,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2554,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3210,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3274,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3458,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3736,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6976,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7969,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10965,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,13446,to_date('20-MAR-98','DD-MON-RR'),3,999,1,1531.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,450,to_date('20-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2073,to_date('20-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2384,to_date('20-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3736,to_date('20-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,892,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1607,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2092,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2271,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2634,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3131,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3526,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4285,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4786,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6073,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7526,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8114,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,9186,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11814,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,17506,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,17633,to_date('21-MAR-98','DD-MON-RR'),3,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,330,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1666,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2638,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3610,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10113,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11053,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,36954,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,330,to_date('23-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2638,to_date('23-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3610,to_date('23-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10113,to_date('23-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11053,to_date('23-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,36954,to_date('23-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5926,to_date('24-MAR-98','DD-MON-RR'),4,999,1,1674.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1838,to_date('26-MAR-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2086,to_date('26-MAR-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3087,to_date('26-MAR-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4040,to_date('26-MAR-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4624,to_date('26-MAR-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,17364,to_date('26-MAR-98','DD-MON-RR'),3,999,1,1753.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,314,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,533,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1155,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1945,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2005,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4090,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5724,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6265,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6465,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7178,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7994,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10747,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11407,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,42167,to_date('27-MAR-98','DD-MON-RR'),2,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,288,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,314,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,788,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1155,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1945,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3453,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3546,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4090,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,4974,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,5724,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6265,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6395,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,6465,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7178,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7691,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,7994,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,8345,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,10747,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,11407,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,33744,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,42167,to_date('27-MAR-98','DD-MON-RR'),3,999,1,1728.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,1156,to_date('30-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,2390,to_date('30-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (18,3255,to_date('30-MAR-98','DD-MON-RR'),4,999,1,1552.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4842,to_date('14-JAN-98','DD-MON-RR'),2,999,1,62.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6219,to_date('14-JAN-98','DD-MON-RR'),2,999,1,62.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6752,to_date('14-JAN-98','DD-MON-RR'),2,999,1,62.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,461,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,797,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1682,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1948,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2077,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2370,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2464,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2865,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3549,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4144,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4394,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4842,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5590,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6859,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6912,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6955,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7082,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7872,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7996,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,9076,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,26630,to_date('14-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4842,to_date('14-JAN-98','DD-MON-RR'),4,999,1,62.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4982,to_date('14-JAN-98','DD-MON-RR'),4,999,1,62.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,42,to_date('16-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,44,to_date('16-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,484,to_date('16-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,914,to_date('16-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2672,to_date('16-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5864,to_date('16-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,21782,to_date('16-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,44,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,256,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,428,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,477,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,484,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,720,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,868,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,914,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,966,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1182,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1232,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1234,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1842,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2272,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2672,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3796,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3819,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5588,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5660,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5730,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5864,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7849,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8351,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12096,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12136,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,21782,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,30080,to_date('16-JAN-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,30974,to_date('19-JAN-98','DD-MON-RR'),2,999,1,62.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,155,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,289,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,350,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,355,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,357,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,407,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,908,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1157,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1573,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1682,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1743,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1945,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2005,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2146,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2411,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
select * from dual;


Insert all
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3254,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3453,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3546,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3705,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3962,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4090,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4497,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4974,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5724,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6265,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6395,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6467,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7178,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7691,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7994,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8345,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10747,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11407,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11702,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,25939,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,28527,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,42167,to_date('19-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,272,to_date('20-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,612,to_date('20-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1779,to_date('20-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2169,to_date('20-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,9604,to_date('20-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,272,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,361,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,387,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,782,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1779,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2169,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2834,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3020,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3261,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3947,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5325,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5847,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5855,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6540,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7113,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8787,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,9604,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,9802,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10502,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10844,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11497,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,33735,to_date('20-JAN-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1779,to_date('20-JAN-98','DD-MON-RR'),4,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,9604,to_date('20-JAN-98','DD-MON-RR'),4,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10262,to_date('20-JAN-98','DD-MON-RR'),4,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,519,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,908,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1578,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1841,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1946,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2005,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2125,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3127,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3454,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3706,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4977,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5475,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5587,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5727,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6955,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7078,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7156,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7871,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7995,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8347,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11408,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11443,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,17081,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,26626,to_date('25-JAN-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,299,to_date('26-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,462,to_date('26-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1838,to_date('26-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2324,to_date('26-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3087,to_date('26-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3643,to_date('26-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4624,to_date('26-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10112,to_date('26-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12072,to_date('26-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,17364,to_date('26-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,27184,to_date('26-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,299,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,462,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1838,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2324,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3087,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3089,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3318,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3643,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3966,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8883,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10833,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12072,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,14221,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,17364,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,27184,to_date('26-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2054,to_date('28-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3365,to_date('28-JAN-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,276,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,307,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,411,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,845,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1255,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1462,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1567,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1682,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1837,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2054,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2211,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2600,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2760,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2855,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3279,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3316,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3365,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3403,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3611,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3720,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4038,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4230,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4621,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4881,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5696,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5698,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6534,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6612,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6905,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8881,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8919,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10143,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12119,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12539,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,25244,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,33722,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,33748,to_date('28-JAN-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2054,to_date('28-JAN-98','DD-MON-RR'),4,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10262,to_date('28-JAN-98','DD-MON-RR'),4,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,484,to_date('14-FEB-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,914,to_date('14-FEB-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2672,to_date('14-FEB-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5864,to_date('14-FEB-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,21782,to_date('14-FEB-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,44,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,343,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,428,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,477,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,484,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,524,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,629,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,720,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,868,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,914,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,966,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1182,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1842,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1946,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2125,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2272,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2672,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3015,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3454,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3548,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3706,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3796,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3819,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3999,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4663,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5475,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5588,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5590,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5660,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5730,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5864,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6955,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7078,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7849,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7871,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7995,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8351,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8384,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12096,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12136,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,17081,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,21782,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,26626,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,30080,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,34834,to_date('14-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,914,to_date('14-FEB-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1182,to_date('14-FEB-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2672,to_date('14-FEB-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5864,to_date('14-FEB-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,21782,to_date('14-FEB-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,124,to_date('16-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1934,to_date('16-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3369,to_date('16-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4454,to_date('16-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4984,to_date('16-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,124,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,155,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,180,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,289,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,350,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,355,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,407,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,524,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,908,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1157,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1362,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1523,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1573,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1743,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1934,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1945,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2005,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2411,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3369,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3453,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3546,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3602,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3705,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4090,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4497,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4974,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4984,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5726,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6265,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6395,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6467,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7178,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7691,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7994,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8347,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10747,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11407,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11702,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,16062,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,25939,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,28527,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,34834,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,42167,to_date('16-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4874,to_date('19-FEB-98','DD-MON-RR'),2,999,1,62.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,15489,to_date('19-FEB-98','DD-MON-RR'),2,999,1,62.4)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,324,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,524,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,942,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1258,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1998,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2104,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2327,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2524,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2761,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2782,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2857,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3101,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3318,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3425,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3966,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3984,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4009,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4043,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4231,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4410,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4493,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4628,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4657,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5163,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5574,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5701,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5720,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7003,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7301,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8885,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10837,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,13232,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,13458,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,20973,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,25251,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,39879,to_date('19-FEB-98','DD-MON-RR'),3,999,1,62.37)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,462,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,691,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1758,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2086,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2103,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2324,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2522,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3087,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3096,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3968,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4008,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4040,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4334,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4627,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8883,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10112,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10834,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11662,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12072,to_date('20-FEB-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,162,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,181,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1114,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1260,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1981,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2000,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2013,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2529,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2762,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2892,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3268,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3784,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3794,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4047,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4414,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4629,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4922,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5163,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6264,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6394,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6488,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7003,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7993,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8488,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,14865,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,25938,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,33726,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,39084,to_date('25-FEB-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,162,to_date('25-FEB-98','DD-MON-RR'),4,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1114,to_date('25-FEB-98','DD-MON-RR'),4,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4152,to_date('25-FEB-98','DD-MON-RR'),4,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,122,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,172,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,220,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,235,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,383,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,599,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,657,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,942,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,953,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1154,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2054,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2104,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2327,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2524,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2782,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3099,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3415,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3779,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4628,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4973,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5720,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5723,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6464,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8324,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8885,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8919,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,9366,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11403,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11457,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,13458,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,28522,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,30031,to_date('26-FEB-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4724,to_date('10-MAR-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,13152,to_date('10-MAR-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,13152,to_date('10-MAR-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6912,to_date('14-MAR-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12962,to_date('14-MAR-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,461,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1948,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2070,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2077,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2464,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2865,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3362,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3422,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3549,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4144,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5590,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6859,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6912,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6957,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7082,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7872,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7996,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12962,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,26630,to_date('14-MAR-98','DD-MON-RR'),3,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6912,to_date('14-MAR-98','DD-MON-RR'),4,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7479,to_date('14-MAR-98','DD-MON-RR'),4,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1182,to_date('16-MAR-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2672,to_date('16-MAR-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5864,to_date('16-MAR-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,21782,to_date('16-MAR-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,350,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,355,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,357,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,407,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,908,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1573,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1849,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1945,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2005,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2070,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2411,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3127,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3453,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3546,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4090,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4497,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4974,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5292,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5587,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5726,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6265,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6395,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6467,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7178,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,7994,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8347,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10747,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,11408,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,25939,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,28527,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,42167,to_date('19-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,782,to_date('20-MAR-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1924,to_date('20-MAR-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2169,to_date('20-MAR-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2384,to_date('20-MAR-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2834,to_date('20-MAR-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10292,to_date('20-MAR-98','DD-MON-RR'),2,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,361,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,387,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,782,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1924,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2234,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2384,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3262,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3947,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5325,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5493,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5517,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5847,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6543,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,9802,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10014,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10292,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10844,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12101,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12902,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,33735,to_date('20-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,782,to_date('20-MAR-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2169,to_date('20-MAR-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2384,to_date('20-MAR-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10292,to_date('20-MAR-98','DD-MON-RR'),4,999,1,62.15)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,299,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,462,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1838,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2086,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2324,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3087,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3089,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3318,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3643,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3966,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4624,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8883,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10834,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12072,to_date('26-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,10112,to_date('26-MAR-98','DD-MON-RR'),4,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8919,to_date('28-MAR-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,16774,to_date('28-MAR-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,276,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,307,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,411,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,845,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1255,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1567,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1837,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1998,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2070,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2406,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2760,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,2857,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3279,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3316,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3720,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3984,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4038,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4881,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,4989,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5696,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,5698,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6534,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6612,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6905,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,8352,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,12539,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,16774,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,25244,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,33722,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,33734,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,33748,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,42420,to_date('28-MAR-98','DD-MON-RR'),3,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,3254,to_date('30-MAR-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6044,to_date('30-MAR-98','DD-MON-RR'),2,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,1982,to_date('30-MAR-98','DD-MON-RR'),4,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (19,6044,to_date('30-MAR-98','DD-MON-RR'),4,999,1,63.02)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2077,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2302,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2530,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3015,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3549,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3793,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4144,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5732,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6087,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6517,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6955,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7082,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7872,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7933,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8685,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,10978,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,12782,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,26626,to_date('07-JAN-98','DD-MON-RR'),3,999,1,602.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,461,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,689,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,807,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,904,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,922,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,987,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1481,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1660,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1843,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1948,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2423,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2865,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2869,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4394,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4663,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5203,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5590,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6277,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6859,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7036,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7757,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8540,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,9035,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,30604,to_date('10-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7606,to_date('13-JAN-98','DD-MON-RR'),2,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,360,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,444,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,689,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,742,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,868,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,912,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,966,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1481,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1843,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1946,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2005,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2125,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2273,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3548,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3706,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3785,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4512,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5475,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6276,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6955,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7036,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7757,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7850,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8351,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,15217,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,30147,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,33725,to_date('13-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1981,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2113,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2329,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2529,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3453,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3546,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3784,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4013,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5163,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5660,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5730,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6265,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6395,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7178,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7994,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,12096,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,25939,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,42167,to_date('23-JAN-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7606,to_date('30-JAN-98','DD-MON-RR'),2,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,214,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,254,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,429,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1297,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1369,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1441,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1786,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1849,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1949,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2084,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2383,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2798,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2819,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2914,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2952,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3001,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3019,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3215,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3429,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3686,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3960,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4465,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4759,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4942,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5085,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5681,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6279,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6417,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6430,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6913,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7086,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7468,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7873,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7902,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8236,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8686,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8888,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8935,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,9038,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,9234,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,10268,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,11131,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,12783,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,15826,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,26631,to_date('30-JAN-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7606,to_date('31-JAN-98','DD-MON-RR'),2,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,904,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1297,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1438,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1663,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1846,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2084,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2331,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3212,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3549,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3686,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3793,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4091,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4144,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4397,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5826,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6087,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6277,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6957,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7082,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7872,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7996,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8198,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8888,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,9038,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,10978,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,12783,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,26630,to_date('07-FEB-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1758,to_date('16-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,188,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,361,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,659,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,848,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,949,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1242,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1423,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1485,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1580,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1943,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2021,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2080,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2084,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2096,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2310,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2653,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3012,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3025,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3053,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3103,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3526,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3686,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3783,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3947,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4523,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5325,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5493,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5517,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5813,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5847,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6543,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7076,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7421,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8747,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8836,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8888,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,9052,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,9680,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,9802,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,10014,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,10502,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,11663,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,12101,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,14053,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,16280,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,17566,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,17633,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,33735,to_date('17-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1368,to_date('23-FEB-98','DD-MON-RR'),2,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2357,to_date('23-FEB-98','DD-MON-RR'),2,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4646,to_date('23-FEB-98','DD-MON-RR'),2,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6097,to_date('23-FEB-98','DD-MON-RR'),2,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8295,to_date('23-FEB-98','DD-MON-RR'),2,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,11817,to_date('23-FEB-98','DD-MON-RR'),2,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,25121,to_date('23-FEB-98','DD-MON-RR'),2,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,31957,to_date('23-FEB-98','DD-MON-RR'),2,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,122,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,172,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,220,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,235,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,276,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,307,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,383,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,411,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,657,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,845,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,953,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1154,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1255,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1371,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1567,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1837,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2211,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2600,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2760,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2855,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3316,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3392,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3415,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3539,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3720,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4038,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4621,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4881,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4973,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5696,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5698,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5723,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6464,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6612,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6905,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8324,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8888,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,9366,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,11403,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,11457,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,12539,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,25244,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,28522,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,33717,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,33722,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,42420,to_date('25-FEB-98','DD-MON-RR'),3,999,1,599.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,904,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,932,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1439,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1637,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1948,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2077,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2370,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2683,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2865,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2993,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3018,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3214,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3550,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4337,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4397,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4664,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6221,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6779,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6859,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7872,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8192,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8685,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,9316,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,15826,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,26630,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,48811,to_date('07-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,343,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,689,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,797,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,922,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,977,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,987,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1481,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1843,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1946,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2125,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2273,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2839,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3706,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4512,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5318,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5475,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5731,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6130,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6276,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7850,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7871,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8351,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,9076,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,12097,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,12824,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,30147,to_date('13-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,135,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,427,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,519,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,954,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1578,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,1841,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2782,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3819,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4628,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5588,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5720,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5727,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7156,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,8348,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,11443,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,12096,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,29911,to_date('17-MAR-98','DD-MON-RR'),3,999,1,608.39)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,432,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,444,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2113,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2330,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,2530,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3454,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3548,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,3790,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4337,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4661,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,4700,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,5164,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,6955,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7078,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,7995,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,9313,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,10978,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,15217,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,17081,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (20,26626,to_date('23-MAR-98','DD-MON-RR'),3,999,1,602.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5378,to_date('02-JAN-98','DD-MON-RR'),3,999,1,1057.2)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,205,to_date('02-JAN-98','DD-MON-RR'),4,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,228,to_date('04-JAN-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,228,to_date('04-JAN-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,968,to_date('07-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1847,to_date('07-JAN-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1847,to_date('08-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2883,to_date('08-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,402,to_date('08-JAN-98','DD-MON-RR'),4,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,9558,to_date('08-JAN-98','DD-MON-RR'),4,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3667,to_date('10-JAN-98','DD-MON-RR'),2,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10007,to_date('10-JAN-98','DD-MON-RR'),2,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5905,to_date('10-JAN-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,6106,to_date('10-JAN-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3047,to_date('13-JAN-98','DD-MON-RR'),2,999,1,1056.68)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3047,to_date('13-JAN-98','DD-MON-RR'),3,999,1,1056.68)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10667,to_date('13-JAN-98','DD-MON-RR'),3,999,1,1056.68)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,9966,to_date('13-JAN-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1928,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3618,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8806,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,9882,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,28323,to_date('17-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8806,to_date('17-JAN-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8825,to_date('18-JAN-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8825,to_date('18-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4165,to_date('20-JAN-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8447,to_date('20-JAN-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,11568,to_date('20-JAN-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1688,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1925,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3946,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5418,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,7426,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,7748,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8447,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10608,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,11568,to_date('20-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4165,to_date('20-JAN-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,7748,to_date('20-JAN-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10986,to_date('20-JAN-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,11568,to_date('20-JAN-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2403,to_date('23-JAN-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2646,to_date('23-JAN-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3006,to_date('23-JAN-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4156,to_date('23-JAN-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5905,to_date('23-JAN-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8898,to_date('23-JAN-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,30098,to_date('23-JAN-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,806,to_date('23-JAN-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2346,to_date('23-JAN-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2403,to_date('23-JAN-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4156,to_date('23-JAN-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8898,to_date('23-JAN-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10007,to_date('23-JAN-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,12123,to_date('23-JAN-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3006,to_date('24-JAN-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5905,to_date('24-JAN-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3006,to_date('24-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3667,to_date('24-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4547,to_date('24-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5905,to_date('24-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,6106,to_date('24-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,6818,to_date('24-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10007,to_date('24-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,12123,to_date('24-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2346,to_date('24-JAN-98','DD-MON-RR'),4,999,1,1056.68)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10007,to_date('24-JAN-98','DD-MON-RR'),4,999,1,1056.68)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,12123,to_date('24-JAN-98','DD-MON-RR'),4,999,1,1056.68)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,7386,to_date('26-JAN-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,7237,to_date('26-JAN-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5622,to_date('28-JAN-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,468,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1538,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2378,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4787,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5622,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10267,to_date('28-JAN-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5442,to_date('28-JAN-98','DD-MON-RR'),4,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,513,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,678,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1818,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2015,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2028,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2066,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3732,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4237,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4278,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4688,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5035,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5766,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,6316,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8583,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,9451,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,13316,to_date('30-JAN-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,6316,to_date('30-JAN-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1466,to_date('31-JAN-98','DD-MON-RR'),2,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1847,to_date('31-JAN-98','DD-MON-RR'),2,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3042,to_date('31-JAN-98','DD-MON-RR'),2,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1847,to_date('31-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2567,to_date('31-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3042,to_date('31-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4388,to_date('31-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10658,to_date('31-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,23226,to_date('31-JAN-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,766,to_date('02-FEB-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3871,to_date('02-FEB-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,29313,to_date('02-FEB-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1655,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2137,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3841,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3871,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,12266,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,13152,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,29313,to_date('02-FEB-98','DD-MON-RR'),3,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,11388,to_date('02-FEB-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,7983,to_date('03-FEB-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2166,to_date('03-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,9728,to_date('03-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3841,to_date('07-FEB-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,557,to_date('07-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,813,to_date('07-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,23237,to_date('07-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3841,to_date('07-FEB-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,23226,to_date('07-FEB-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,9278,to_date('10-FEB-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10392,to_date('12-FEB-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,22478,to_date('12-FEB-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2006,to_date('12-FEB-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,9966,to_date('12-FEB-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10392,to_date('12-FEB-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,11952,to_date('12-FEB-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,22478,to_date('12-FEB-98','DD-MON-RR'),3,999,1,1052.99)
select * from dual;


Insert all
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8866,to_date('12-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,22478,to_date('12-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,905,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,933,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1128,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2066,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2546,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3367,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4195,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5808,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,7626,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8583,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,9878,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10177,to_date('14-FEB-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1577,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2597,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3618,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,33732,to_date('16-FEB-98','DD-MON-RR'),3,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4177,to_date('17-FEB-98','DD-MON-RR'),2,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5855,to_date('17-FEB-98','DD-MON-RR'),2,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10002,to_date('17-FEB-98','DD-MON-RR'),2,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,21517,to_date('17-FEB-98','DD-MON-RR'),2,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,27197,to_date('17-FEB-98','DD-MON-RR'),2,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,36217,to_date('17-FEB-98','DD-MON-RR'),2,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1156,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1886,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4177,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5126,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5855,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10002,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,21517,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,27197,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,32172,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,36217,to_date('17-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5126,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5855,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10002,to_date('17-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,7748,to_date('19-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10572,to_date('19-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10986,to_date('19-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,266,to_date('23-FEB-98','DD-MON-RR'),2,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,266,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2532,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,6037,to_date('23-FEB-98','DD-MON-RR'),3,999,1,1052.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4195,to_date('26-FEB-98','DD-MON-RR'),2,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2066,to_date('26-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4195,to_date('26-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,7626,to_date('26-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,8583,to_date('26-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,14532,to_date('26-FEB-98','DD-MON-RR'),4,999,1,1067.73)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2073,to_date('28-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4157,to_date('28-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4291,to_date('28-FEB-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1475,to_date('03-MAR-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,513,to_date('03-MAR-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4237,to_date('03-MAR-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,6316,to_date('03-MAR-98','DD-MON-RR'),3,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2791,to_date('07-MAR-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3698,to_date('07-MAR-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,11388,to_date('07-MAR-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,458,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2896,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5678,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,6003,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,20395,to_date('14-MAR-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,318,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3458,to_date('16-MAR-98','DD-MON-RR'),3,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,783,to_date('17-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,3438,to_date('17-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,7496,to_date('17-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,9991,to_date('17-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1066,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2156,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2646,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,11665,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,16938,to_date('23-MAR-98','DD-MON-RR'),2,999,1,1064.8)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,7386,to_date('26-MAR-98','DD-MON-RR'),2,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,725,to_date('26-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2073,to_date('26-MAR-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4457,to_date('26-MAR-98','DD-MON-RR'),4,999,1,1075.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,1235,to_date('30-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2536,to_date('30-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,2956,to_date('30-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4177,to_date('30-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,4471,to_date('30-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,5408,to_date('30-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (21,10113,to_date('30-MAR-98','DD-MON-RR'),3,999,1,1061.09)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,9177,to_date('03-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,9177,to_date('03-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,27323,to_date('07-JAN-98','DD-MON-RR'),2,999,1,26.28)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,447,to_date('07-JAN-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4324,to_date('07-JAN-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4643,to_date('07-JAN-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7779,to_date('07-JAN-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10007,to_date('07-JAN-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,12207,to_date('07-JAN-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,557,to_date('08-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2933,to_date('08-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,6636,to_date('08-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1847,to_date('10-JAN-98','DD-MON-RR'),2,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2633,to_date('10-JAN-98','DD-MON-RR'),2,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,11603,to_date('10-JAN-98','DD-MON-RR'),2,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1847,to_date('10-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2067,to_date('10-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2286,to_date('10-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2633,to_date('10-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4389,to_date('10-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,8117,to_date('10-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,11603,to_date('10-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,13748,to_date('10-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1847,to_date('10-JAN-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4389,to_date('10-JAN-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,11603,to_date('10-JAN-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10883,to_date('11-JAN-98','DD-MON-RR'),2,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10883,to_date('11-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1433,to_date('12-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4024,to_date('12-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,9087,to_date('12-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,9231,to_date('13-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,9231,to_date('13-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10174,to_date('13-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,13236,to_date('13-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5406,to_date('14-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7626,to_date('14-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7626,to_date('14-JAN-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3584,to_date('16-JAN-98','DD-MON-RR'),2,999,1,26.29)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3484,to_date('16-JAN-98','DD-MON-RR'),4,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3584,to_date('16-JAN-98','DD-MON-RR'),4,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4291,to_date('17-JAN-98','DD-MON-RR'),2,999,1,26.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,893,to_date('17-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4291,to_date('17-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5329,to_date('17-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,6829,to_date('17-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,14003,to_date('17-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4291,to_date('17-JAN-98','DD-MON-RR'),4,999,1,26.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,6829,to_date('17-JAN-98','DD-MON-RR'),4,999,1,26.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,147,to_date('19-JAN-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3254,to_date('19-JAN-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,9669,to_date('19-JAN-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,27197,to_date('20-JAN-98','DD-MON-RR'),2,999,1,26.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1984,to_date('20-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3424,to_date('20-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3471,to_date('20-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,27197,to_date('20-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3424,to_date('20-JAN-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4629,to_date('21-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7313,to_date('21-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,8594,to_date('21-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,30098,to_date('21-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2646,to_date('21-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4629,to_date('21-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7313,to_date('21-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7748,to_date('21-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,8594,to_date('21-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10986,to_date('21-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,16309,to_date('21-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,30777,to_date('21-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7313,to_date('21-JAN-98','DD-MON-RR'),4,999,1,26.24)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,447,to_date('23-JAN-98','DD-MON-RR'),2,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1793,to_date('23-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3006,to_date('23-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10107,to_date('23-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,27323,to_date('23-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2346,to_date('23-JAN-98','DD-MON-RR'),4,999,1,26.28)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3006,to_date('23-JAN-98','DD-MON-RR'),4,999,1,26.28)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,12447,to_date('23-JAN-98','DD-MON-RR'),4,999,1,26.28)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,27323,to_date('23-JAN-98','DD-MON-RR'),4,999,1,26.28)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,8349,to_date('24-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,12276,to_date('25-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,28017,to_date('25-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1951,to_date('26-JAN-98','DD-MON-RR'),2,999,1,26.24)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3786,to_date('26-JAN-98','DD-MON-RR'),2,999,1,26.24)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3464,to_date('26-JAN-98','DD-MON-RR'),3,999,1,26.29)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3786,to_date('26-JAN-98','DD-MON-RR'),3,999,1,26.29)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7223,to_date('26-JAN-98','DD-MON-RR'),3,999,1,26.29)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3464,to_date('26-JAN-98','DD-MON-RR'),4,999,1,26.29)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1883,to_date('28-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5766,to_date('28-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10017,to_date('28-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,14856,to_date('28-JAN-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1538,to_date('28-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1883,to_date('28-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5106,to_date('28-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5766,to_date('28-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10017,to_date('28-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,14856,to_date('28-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,14864,to_date('29-JAN-98','DD-MON-RR'),2,999,1,26.27)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,14864,to_date('29-JAN-98','DD-MON-RR'),4,999,1,26.27)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,134,to_date('30-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,229,to_date('30-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1647,to_date('30-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1928,to_date('30-JAN-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1647,to_date('30-JAN-98','DD-MON-RR'),4,999,1,26.28)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1928,to_date('30-JAN-98','DD-MON-RR'),4,999,1,26.28)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2567,to_date('31-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7329,to_date('31-JAN-98','DD-MON-RR'),3,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3006,to_date('31-JAN-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,12447,to_date('31-JAN-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5378,to_date('02-FEB-98','DD-MON-RR'),4,999,1,26.29)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1191,to_date('03-FEB-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2791,to_date('03-FEB-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2997,to_date('03-FEB-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3039,to_date('03-FEB-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5374,to_date('03-FEB-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1191,to_date('03-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2791,to_date('03-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2997,to_date('03-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3039,to_date('03-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5374,to_date('03-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,11091,to_date('03-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2933,to_date('07-FEB-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2633,to_date('08-FEB-98','DD-MON-RR'),2,999,1,26.24)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4317,to_date('08-FEB-98','DD-MON-RR'),2,999,1,26.24)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,13748,to_date('08-FEB-98','DD-MON-RR'),2,999,1,26.24)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4317,to_date('08-FEB-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5479,to_date('08-FEB-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,297,to_date('10-FEB-98','DD-MON-RR'),2,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1433,to_date('10-FEB-98','DD-MON-RR'),2,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4521,to_date('10-FEB-98','DD-MON-RR'),2,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,22478,to_date('10-FEB-98','DD-MON-RR'),2,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,23237,to_date('10-FEB-98','DD-MON-RR'),2,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,297,to_date('10-FEB-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,22478,to_date('10-FEB-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,23226,to_date('10-FEB-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,141,to_date('12-FEB-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,141,to_date('12-FEB-98','DD-MON-RR'),4,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7626,to_date('13-FEB-98','DD-MON-RR'),4,999,1,26.56)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4433,to_date('16-FEB-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5027,to_date('16-FEB-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1519,to_date('16-FEB-98','DD-MON-RR'),3,999,1,26.24)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5027,to_date('16-FEB-98','DD-MON-RR'),3,999,1,26.24)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4433,to_date('16-FEB-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,893,to_date('17-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1574,to_date('17-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1577,to_date('17-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2597,to_date('17-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4157,to_date('17-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4291,to_date('17-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5419,to_date('17-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,14937,to_date('17-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,16266,to_date('17-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4313,to_date('17-FEB-98','DD-MON-RR'),4,999,1,26.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2436,to_date('19-FEB-98','DD-MON-RR'),3,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2646,to_date('19-FEB-98','DD-MON-RR'),3,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4629,to_date('19-FEB-98','DD-MON-RR'),3,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5858,to_date('19-FEB-98','DD-MON-RR'),3,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7313,to_date('19-FEB-98','DD-MON-RR'),3,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,30777,to_date('19-FEB-98','DD-MON-RR'),3,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4097,to_date('19-FEB-98','DD-MON-RR'),4,999,1,26.24)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2157,to_date('20-FEB-98','DD-MON-RR'),2,999,1,26.29)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2157,to_date('20-FEB-98','DD-MON-RR'),3,999,1,26.29)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7748,to_date('20-FEB-98','DD-MON-RR'),3,999,1,26.29)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1778,to_date('21-FEB-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1793,to_date('21-FEB-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5457,to_date('21-FEB-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10107,to_date('21-FEB-98','DD-MON-RR'),3,999,1,26.19)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2774,to_date('23-FEB-98','DD-MON-RR'),2,999,1,26.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10418,to_date('23-FEB-98','DD-MON-RR'),2,999,1,26.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,12276,to_date('23-FEB-98','DD-MON-RR'),2,999,1,26.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,28017,to_date('23-FEB-98','DD-MON-RR'),2,999,1,26.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,34,to_date('23-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2774,to_date('23-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,6841,to_date('23-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10418,to_date('23-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,12276,to_date('23-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,28017,to_date('23-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4097,to_date('23-FEB-98','DD-MON-RR'),4,999,1,26.24)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3794,to_date('25-FEB-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,14856,to_date('26-FEB-98','DD-MON-RR'),2,999,1,26.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2054,to_date('26-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,14856,to_date('26-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,14856,to_date('26-FEB-98','DD-MON-RR'),4,999,1,26.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3786,to_date('28-FEB-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4471,to_date('28-FEB-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3786,to_date('28-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3874,to_date('28-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4956,to_date('28-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7386,to_date('28-FEB-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4688,to_date('02-MAR-98','DD-MON-RR'),2,999,1,26.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1253,to_date('02-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4688,to_date('02-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2933,to_date('08-MAR-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2933,to_date('08-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,6636,to_date('08-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2933,to_date('08-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10881,to_date('10-MAR-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,8117,to_date('10-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10881,to_date('10-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,29217,to_date('12-MAR-98','DD-MON-RR'),2,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4521,to_date('12-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,29217,to_date('12-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4521,to_date('12-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,6934,to_date('13-MAR-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,6934,to_date('13-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,9231,to_date('13-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4313,to_date('17-MAR-98','DD-MON-RR'),2,999,1,26.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1574,to_date('17-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2809,to_date('17-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3874,to_date('17-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5419,to_date('17-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4313,to_date('17-MAR-98','DD-MON-RR'),4,999,1,26.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,3424,to_date('19-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4328,to_date('19-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,27889,to_date('20-MAR-98','DD-MON-RR'),2,999,1,26.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2436,to_date('21-MAR-98','DD-MON-RR'),2,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4629,to_date('21-MAR-98','DD-MON-RR'),2,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7347,to_date('21-MAR-98','DD-MON-RR'),2,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2436,to_date('21-MAR-98','DD-MON-RR'),3,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2646,to_date('21-MAR-98','DD-MON-RR'),3,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4629,to_date('21-MAR-98','DD-MON-RR'),3,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7347,to_date('21-MAR-98','DD-MON-RR'),3,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,30777,to_date('21-MAR-98','DD-MON-RR'),3,999,1,26.33)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4629,to_date('21-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,7347,to_date('21-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,30777,to_date('21-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,897,to_date('23-MAR-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,559,to_date('23-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,897,to_date('23-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1793,to_date('23-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5457,to_date('23-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,6274,to_date('23-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10107,to_date('23-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2774,to_date('25-MAR-98','DD-MON-RR'),2,999,1,26.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10418,to_date('25-MAR-98','DD-MON-RR'),2,999,1,26.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,12276,to_date('25-MAR-98','DD-MON-RR'),2,999,1,26.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,377,to_date('25-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,2774,to_date('25-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,11691,to_date('25-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,28017,to_date('25-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,10418,to_date('25-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,12276,to_date('25-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,28017,to_date('25-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,1478,to_date('26-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4478,to_date('26-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4478,to_date('26-MAR-98','DD-MON-RR'),4,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,5637,to_date('28-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,16774,to_date('28-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4471,to_date('30-MAR-98','DD-MON-RR'),2,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (22,4471,to_date('30-MAR-98','DD-MON-RR'),3,999,1,26.61)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1562,to_date('02-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5681,to_date('02-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7902,to_date('02-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8198,to_date('02-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10103,to_date('02-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11052,to_date('02-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11131,to_date('02-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11453,to_date('02-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4822,to_date('08-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5647,to_date('08-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6517,to_date('08-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6608,to_date('08-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6825,to_date('08-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10099,to_date('08-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,48811,to_date('08-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,932,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1689,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1948,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2077,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2906,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3550,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3557,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6221,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6859,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6957,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7083,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7872,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8685,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9579,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,26630,to_date('10-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,177,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1342,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1981,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2113,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2530,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3547,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4466,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5164,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5318,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5492,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6569,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9313,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9417,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10561,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,15555,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,18344,to_date('12-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,689,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,807,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,922,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,987,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1438,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1843,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1902,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2302,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2683,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2869,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5203,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5731,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6968,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8540,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9035,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12099,to_date('13-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,899,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1981,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2113,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2529,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3547,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4466,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5163,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5184,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5298,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5310,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7268,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9412,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10561,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,14865,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,15095,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,33727,to_date('14-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2328,to_date('17-JAN-98','DD-MON-RR'),3,999,1,23.85)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3808,to_date('17-JAN-98','DD-MON-RR'),3,999,1,23.85)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4045,to_date('17-JAN-98','DD-MON-RR'),3,999,1,23.85)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4628,to_date('17-JAN-98','DD-MON-RR'),3,999,1,23.85)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9410,to_date('17-JAN-98','DD-MON-RR'),3,999,1,23.85)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11663,to_date('17-JAN-98','DD-MON-RR'),3,999,1,23.85)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,13458,to_date('17-JAN-98','DD-MON-RR'),3,999,1,23.85)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,30031,to_date('17-JAN-98','DD-MON-RR'),3,999,1,23.85)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,155,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,350,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,355,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,407,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,533,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1157,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1573,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1743,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4974,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5724,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6467,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6968,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8345,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10747,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11407,to_date('19-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,361,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,387,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1261,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3891,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3947,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4466,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5233,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5532,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6342,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6543,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8084,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8787,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9802,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10502,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10844,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12831,to_date('20-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,188,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,249,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,531,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,949,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1386,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1422,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1959,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2021,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2080,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3014,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3783,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5813,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6968,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7076,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9680,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,14053,to_date('21-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,181,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1260,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1725,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2000,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2013,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2762,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3268,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4414,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6264,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6394,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6488,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6999,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7993,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,25938,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,39084,to_date('23-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1255,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1455,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2211,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2600,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2760,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2855,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3539,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3720,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4881,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5696,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6612,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6905,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12539,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,25244,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,33722,to_date('26-JAN-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,254,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,276,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,307,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,411,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1645,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1837,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1949,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2079,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2383,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3913,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3960,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4038,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4621,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4942,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6534,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6913,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7086,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7873,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8236,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8686,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8722,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8935,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9862,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10268,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10941,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11316,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12119,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,15205,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,26631,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,33748,to_date('28-JAN-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2819,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3019,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3215,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3581,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4465,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5351,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6683,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7468,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7469,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7902,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8198,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9317,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9574,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10103,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11052,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11131,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11453,to_date('30-JAN-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,466,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2128,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3570,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4802,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4822,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5525,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6417,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6608,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9237,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10099,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12788,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,48811,to_date('02-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3592,to_date('03-FEB-98','DD-MON-RR'),2,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,932,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1689,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1948,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2077,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3215,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3550,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3557,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4466,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5352,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6221,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6859,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6957,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7083,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7872,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8685,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9579,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,16517,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,26630,to_date('03-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,200,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,444,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,945,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1293,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1661,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1844,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1946,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2125,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2382,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2903,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2993,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3454,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3548,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4663,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5204,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5475,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5590,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5732,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6278,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6955,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7036,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7078,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7871,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7995,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8384,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8543,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9037,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12782,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,16517,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,17081,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,26626,to_date('08-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9038,to_date('10-FEB-98','DD-MON-RR'),2,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,807,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,922,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,987,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1297,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1523,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1660,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1844,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1846,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2302,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2380,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2869,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5203,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5731,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6277,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7036,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8540,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9035,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9038,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12099,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12783,to_date('10-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,164,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,689,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,742,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,912,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,922,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,966,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1258,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1843,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1998,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2273,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2327,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2524,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2761,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2857,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3028,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3984,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4009,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4043,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4231,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4410,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4493,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4512,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4657,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5163,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5192,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5298,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5574,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5701,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5720,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5730,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6276,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7003,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7036,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7301,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7850,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8351,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8885,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9410,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12097,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,13232,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,13458,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,15095,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,15217,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,16517,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,20973,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,25251,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,30031,to_date('13-FEB-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,350,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,355,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,407,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,908,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1157,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1573,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1743,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4974,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5726,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6467,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7036,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8347,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11407,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11702,to_date('16-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1255,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1998,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2600,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2760,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2855,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3720,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3966,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4230,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4881,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5696,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6612,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6905,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12539,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,16517,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,25244,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,33722,to_date('19-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1368,to_date('21-FEB-98','DD-MON-RR'),2,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,31957,to_date('21-FEB-98','DD-MON-RR'),2,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,411,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1278,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1368,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1838,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2322,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3026,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3087,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3280,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3317,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3643,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4039,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4607,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4646,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4955,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8295,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8723,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8882,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11381,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11550,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12809,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,13492,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,31957,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,40417,to_date('21-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1103,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1206,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1255,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2211,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2600,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2760,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2855,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3539,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3720,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4881,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4903,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5696,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6612,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6905,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12539,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,16517,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,25244,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,33722,to_date('23-FEB-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,307,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,411,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1567,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1645,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1837,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3279,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3316,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3913,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4038,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5698,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6534,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8722,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8881,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10941,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11549,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12119,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,33748,to_date('25-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,145,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,254,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1383,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2084,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2383,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2640,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3492,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3960,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6913,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7086,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7873,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8236,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8686,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8935,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10268,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,26631,to_date('28-FEB-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,819,to_date('02-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2798,to_date('02-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2952,to_date('02-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3581,to_date('02-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4203,to_date('02-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5681,to_date('02-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6683,to_date('02-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7469,to_date('02-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10103,to_date('02-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11052,to_date('02-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11131,to_date('02-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,461,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,904,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1948,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2370,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3214,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4191,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4464,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6859,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7872,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8192,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9316,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9573,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,14124,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,15826,to_date('07-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,771,to_date('08-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,800,to_date('08-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2261,to_date('08-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2796,to_date('08-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2819,to_date('08-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3570,to_date('08-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4802,to_date('08-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4822,to_date('08-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5525,to_date('08-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5647,to_date('08-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10101,to_date('08-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,915,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,932,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1689,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1949,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2079,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2906,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3492,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3550,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6221,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6859,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6957,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7083,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7872,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8685,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9579,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,26630,to_date('10-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,177,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1342,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1481,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2107,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2113,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2530,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3547,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3785,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4080,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5164,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5318,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5492,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6130,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9306,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9313,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9417,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10978,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,14120,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,20420,to_date('12-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,899,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1342,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1981,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2106,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2113,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2529,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3547,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3784,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4047,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5164,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5311,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5492,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6129,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7268,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8488,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8886,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9412,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10561,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,33727,to_date('14-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,164,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,324,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,428,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,477,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,720,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,868,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,966,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1258,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1714,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1842,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1998,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2272,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2761,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2857,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3492,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4231,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4410,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4512,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5574,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5588,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5660,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5701,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5730,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7301,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7849,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8351,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12097,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12136,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,13232,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,20973,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,25251,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,30080,to_date('16-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10,to_date('17-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2104,to_date('17-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2782,to_date('17-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3028,to_date('17-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4628,to_date('17-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5192,to_date('17-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5298,to_date('17-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5720,to_date('17-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9410,to_date('17-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,15095,to_date('17-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,30031,to_date('17-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,155,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,350,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,355,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,407,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,908,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1157,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1573,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3127,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4977,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5587,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5726,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6467,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8347,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10747,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11407,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,28527,to_date('19-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,361,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1261,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3947,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4224,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5233,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5325,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5493,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5517,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5532,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5847,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6342,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6540,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6543,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8085,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9802,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10502,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10844,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12101,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12831,to_date('20-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,180,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,357,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1945,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2005,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2146,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3453,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3492,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3546,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4090,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6265,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6395,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7178,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7691,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7994,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,25939,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,42167,to_date('23-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,185,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,275,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,288,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,314,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,533,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,788,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1155,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1743,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4974,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5724,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6465,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8345,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10747,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11220,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11407,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11702,to_date('25-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1255,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1455,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2412,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2760,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2855,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2920,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3539,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3720,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4881,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,5696,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6612,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6905,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,12539,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,25244,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
select * from dual;

Insert all
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,33717,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,33722,to_date('26-MAR-98','DD-MON-RR'),3,999,1,23.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,276,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,307,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,411,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,845,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1567,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1645,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,1837,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2406,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3913,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4038,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4621,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8722,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8881,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,9862,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,10941,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11316,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,11549,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,33748,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,42420,to_date('28-MAR-98','DD-MON-RR'),3,999,1,24.08)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,254,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2084,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2412,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2640,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,2748,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,3960,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,4942,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,6913,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7776,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,7873,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8236,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8686,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,8935,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (23,26631,to_date('30-MAR-98','DD-MON-RR'),3,999,1,23.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3228,to_date('02-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8343,to_date('02-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,25062,to_date('02-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7289,to_date('02-JAN-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9363,to_date('02-JAN-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,25062,to_date('02-JAN-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,513,to_date('03-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9332,to_date('03-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,14414,to_date('03-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9332,to_date('03-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,14414,to_date('03-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7779,to_date('07-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,12093,to_date('07-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1532,to_date('07-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7779,to_date('07-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2464,to_date('08-JAN-98','DD-MON-RR'),3,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3361,to_date('08-JAN-98','DD-MON-RR'),3,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9889,to_date('08-JAN-98','DD-MON-RR'),3,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,409,to_date('10-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2089,to_date('10-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2672,to_date('10-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2913,to_date('10-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3302,to_date('10-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6272,to_date('10-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,21782,to_date('10-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,22988,to_date('10-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,44,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,409,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,693,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1182,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2089,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2672,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2913,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3302,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4245,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4532,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6272,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6579,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,14979,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,21782,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,22988,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,44733,to_date('10-JAN-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,42,to_date('10-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3302,to_date('10-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9363,to_date('10-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,21782,to_date('10-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,22988,to_date('10-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6267,to_date('12-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,29313,to_date('12-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6267,to_date('12-JAN-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9363,to_date('12-JAN-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,20222,to_date('12-JAN-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6824,to_date('13-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6932,to_date('13-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9646,to_date('13-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1678,to_date('13-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3394,to_date('13-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6046,to_date('13-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6824,to_date('13-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6932,to_date('13-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9465,to_date('13-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10174,to_date('13-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6932,to_date('13-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1574,to_date('17-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4291,to_date('17-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9646,to_date('17-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,244,to_date('17-JAN-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1082,to_date('17-JAN-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1574,to_date('17-JAN-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4291,to_date('17-JAN-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9879,to_date('17-JAN-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11252,to_date('17-JAN-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,329,to_date('19-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3068,to_date('19-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3182,to_date('19-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6033,to_date('19-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9646,to_date('19-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,30974,to_date('19-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3068,to_date('19-JAN-98','DD-MON-RR'),3,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3254,to_date('19-JAN-98','DD-MON-RR'),3,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3962,to_date('19-JAN-98','DD-MON-RR'),3,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4369,to_date('19-JAN-98','DD-MON-RR'),3,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5247,to_date('19-JAN-98','DD-MON-RR'),3,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5292,to_date('19-JAN-98','DD-MON-RR'),3,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,329,to_date('19-JAN-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3182,to_date('19-JAN-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,272,to_date('20-JAN-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,209,to_date('20-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,272,to_date('20-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2343,to_date('20-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2834,to_date('20-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9604,to_date('20-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13865,to_date('20-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,838,to_date('21-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,885,to_date('21-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2403,to_date('21-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4629,to_date('21-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5969,to_date('21-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8594,to_date('21-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,838,to_date('21-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,948,to_date('21-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2165,to_date('21-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2403,to_date('21-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4154,to_date('21-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4262,to_date('21-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5969,to_date('21-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8594,to_date('21-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,885,to_date('21-JAN-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2403,to_date('21-JAN-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2758,to_date('23-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2769,to_date('23-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6273,to_date('23-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,49833,to_date('23-JAN-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2758,to_date('23-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2769,to_date('23-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4369,to_date('23-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6273,to_date('23-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10954,to_date('23-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,49833,to_date('23-JAN-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,34,to_date('25-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2314,to_date('25-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3574,to_date('25-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,34,to_date('25-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2774,to_date('25-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1545,to_date('26-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1951,to_date('26-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5019,to_date('26-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6602,to_date('26-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10002,to_date('26-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,32172,to_date('26-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,46754,to_date('26-JAN-98','DD-MON-RR'),2,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1249,to_date('26-JAN-98','DD-MON-RR'),3,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1545,to_date('26-JAN-98','DD-MON-RR'),3,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6602,to_date('26-JAN-98','DD-MON-RR'),3,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10002,to_date('26-JAN-98','DD-MON-RR'),3,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,12325,to_date('26-JAN-98','DD-MON-RR'),3,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,32172,to_date('26-JAN-98','DD-MON-RR'),3,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10002,to_date('26-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4053,to_date('28-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5084,to_date('28-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5084,to_date('28-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6789,to_date('28-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8674,to_date('28-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,513,to_date('30-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8612,to_date('30-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9386,to_date('30-JAN-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,134,to_date('30-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,513,to_date('30-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1833,to_date('30-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3931,to_date('30-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8612,to_date('30-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9386,to_date('30-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9451,to_date('30-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,17942,to_date('30-JAN-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9451,to_date('30-JAN-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,12093,to_date('02-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2791,to_date('03-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5374,to_date('03-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10901,to_date('03-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1299,to_date('03-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2463,to_date('03-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2791,to_date('03-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3039,to_date('03-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5374,to_date('03-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5374,to_date('03-FEB-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2464,to_date('07-FEB-98','DD-MON-RR'),2,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2464,to_date('07-FEB-98','DD-MON-RR'),3,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7479,to_date('07-FEB-98','DD-MON-RR'),3,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,44,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,338,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,693,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1182,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2672,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2913,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2973,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3302,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4532,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4683,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6272,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6579,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10901,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,21782,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,25058,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,44733,to_date('08-FEB-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2672,to_date('08-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2913,to_date('08-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2973,to_date('08-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4532,to_date('08-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6272,to_date('08-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,21782,to_date('08-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,33721,to_date('08-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,44733,to_date('08-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1621,to_date('10-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1652,to_date('10-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2643,to_date('10-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2975,to_date('10-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8621,to_date('10-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13152,to_date('10-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,23861,to_date('10-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,29313,to_date('10-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,183,to_date('10-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1621,to_date('10-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2643,to_date('10-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2975,to_date('10-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8052,to_date('10-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8621,to_date('10-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13152,to_date('10-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,23861,to_date('10-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,28683,to_date('10-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,29313,to_date('10-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1652,to_date('10-FEB-98','DD-MON-RR'),4,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13152,to_date('10-FEB-98','DD-MON-RR'),4,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6743,to_date('12-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6743,to_date('12-FEB-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1954,to_date('13-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3303,to_date('13-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4874,to_date('13-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6781,to_date('13-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6912,to_date('13-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9001,to_date('13-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,15489,to_date('13-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,271,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,421,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,933,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1629,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1954,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2733,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3303,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4364,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4874,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6912,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9001,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,15489,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,39879,to_date('13-FEB-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,871,to_date('13-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,933,to_date('13-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1954,to_date('13-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3303,to_date('13-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4364,to_date('13-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6912,to_date('13-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9001,to_date('13-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,15489,to_date('13-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,39879,to_date('13-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1163,to_date('14-FEB-98','DD-MON-RR'),2,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1308,to_date('14-FEB-98','DD-MON-RR'),2,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1477,to_date('14-FEB-98','DD-MON-RR'),2,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1826,to_date('14-FEB-98','DD-MON-RR'),2,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2955,to_date('14-FEB-98','DD-MON-RR'),2,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7237,to_date('14-FEB-98','DD-MON-RR'),2,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8772,to_date('14-FEB-98','DD-MON-RR'),2,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9277,to_date('14-FEB-98','DD-MON-RR'),2,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9986,to_date('14-FEB-98','DD-MON-RR'),2,999,1,48.83)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1477,to_date('14-FEB-98','DD-MON-RR'),4,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2955,to_date('14-FEB-98','DD-MON-RR'),4,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4841,to_date('14-FEB-98','DD-MON-RR'),4,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9277,to_date('14-FEB-98','DD-MON-RR'),4,999,1,48.66)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,277,to_date('16-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,783,to_date('16-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1437,to_date('16-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2061,to_date('16-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2917,to_date('16-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4957,to_date('16-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,277,to_date('16-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,783,to_date('16-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1362,to_date('16-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2061,to_date('16-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4957,to_date('16-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,16062,to_date('16-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,33755,to_date('16-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,783,to_date('16-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,244,to_date('17-FEB-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,358,to_date('17-FEB-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,677,to_date('17-FEB-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1574,to_date('17-FEB-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3254,to_date('17-FEB-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4291,to_date('17-FEB-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4323,to_date('17-FEB-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5292,to_date('17-FEB-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6033,to_date('17-FEB-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6489,to_date('17-FEB-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,244,to_date('17-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,358,to_date('17-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11252,to_date('17-FEB-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4629,to_date('19-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6455,to_date('19-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4262,to_date('19-FEB-98','DD-MON-RR'),3,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4629,to_date('19-FEB-98','DD-MON-RR'),3,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6455,to_date('19-FEB-98','DD-MON-RR'),3,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6455,to_date('19-FEB-98','DD-MON-RR'),4,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,838,to_date('20-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,958,to_date('20-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2403,to_date('20-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3937,to_date('20-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4261,to_date('20-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,30098,to_date('20-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,838,to_date('20-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,948,to_date('20-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3937,to_date('20-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4261,to_date('20-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,30098,to_date('20-FEB-98','DD-MON-RR'),3,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2769,to_date('21-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6273,to_date('21-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11253,to_date('21-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2769,to_date('21-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6273,to_date('21-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7184,to_date('21-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11253,to_date('21-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,49833,to_date('21-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,34,to_date('23-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2314,to_date('23-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2774,to_date('23-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3497,to_date('23-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8498,to_date('23-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,34,to_date('23-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2132,to_date('23-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2192,to_date('23-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2314,to_date('23-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2774,to_date('23-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6121,to_date('23-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6828,to_date('23-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8498,to_date('23-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9358,to_date('23-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10361,to_date('23-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,34,to_date('23-FEB-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,162,to_date('25-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,612,to_date('25-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1302,to_date('25-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1414,to_date('25-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1988,to_date('25-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2254,to_date('25-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3794,to_date('25-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5103,to_date('25-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7678,to_date('25-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,14791,to_date('25-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,162,to_date('25-FEB-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7678,to_date('25-FEB-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2054,to_date('26-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5377,to_date('26-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7053,to_date('26-FEB-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2054,to_date('26-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3503,to_date('26-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5101,to_date('26-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5377,to_date('26-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6012,to_date('26-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7053,to_date('26-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8919,to_date('26-FEB-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,146,to_date('28-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3874,to_date('28-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4471,to_date('28-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6602,to_date('28-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7397,to_date('28-FEB-98','DD-MON-RR'),2,999,1,49.34)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3874,to_date('28-FEB-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4471,to_date('28-FEB-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6602,to_date('28-FEB-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,647,to_date('02-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3123,to_date('02-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3997,to_date('02-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6344,to_date('02-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6609,to_date('02-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7655,to_date('02-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8343,to_date('02-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8877,to_date('02-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10661,to_date('02-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,27145,to_date('02-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,647,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3123,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3227,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3997,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4829,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6609,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7655,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8343,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8877,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10661,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10730,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,23684,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,33716,to_date('02-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8343,to_date('02-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,513,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1347,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2584,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3927,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3931,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5873,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7340,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8612,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9451,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10342,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13429,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,15865,to_date('03-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,134,to_date('03-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2584,to_date('03-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13335,to_date('03-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13429,to_date('03-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3241,to_date('07-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5954,to_date('07-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7942,to_date('07-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8481,to_date('07-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8871,to_date('07-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8895,to_date('07-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11739,to_date('07-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,12094,to_date('07-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1973,to_date('08-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2464,to_date('08-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3361,to_date('08-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3740,to_date('08-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5261,to_date('08-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10167,to_date('08-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10871,to_date('08-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11085,to_date('08-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13933,to_date('08-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,836,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1251,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1316,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1713,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1973,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2464,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3361,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3740,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4801,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7309,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8739,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9517,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10871,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11085,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11565,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13933,to_date('08-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3361,to_date('08-MAR-98','DD-MON-RR'),4,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,207,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,260,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,492,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2387,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2615,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2672,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2913,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2919,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2973,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3302,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4754,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4789,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6272,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6670,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6790,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7205,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7658,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8571,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,15822,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,21098,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,21782,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,27145,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,44733,to_date('10-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2672,to_date('10-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2794,to_date('10-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3302,to_date('10-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6272,to_date('10-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,15822,to_date('10-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,21782,to_date('10-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,33721,to_date('10-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,308,to_date('12-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1740,to_date('12-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3829,to_date('12-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4721,to_date('12-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4724,to_date('12-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4809,to_date('12-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6228,to_date('12-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11076,to_date('12-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13152,to_date('12-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,27145,to_date('12-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,183,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,308,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1740,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2807,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3117,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3829,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4721,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4724,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4809,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6915,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8858,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11076,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13152,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,28683,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,32331,to_date('12-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13152,to_date('12-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,29313,to_date('12-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3394,to_date('13-MAR-98','DD-MON-RR'),2,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6242,to_date('13-MAR-98','DD-MON-RR'),2,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6934,to_date('13-MAR-98','DD-MON-RR'),2,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7164,to_date('13-MAR-98','DD-MON-RR'),2,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9483,to_date('13-MAR-98','DD-MON-RR'),2,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10174,to_date('13-MAR-98','DD-MON-RR'),2,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11159,to_date('13-MAR-98','DD-MON-RR'),2,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,12766,to_date('13-MAR-98','DD-MON-RR'),2,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3394,to_date('13-MAR-98','DD-MON-RR'),4,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6824,to_date('13-MAR-98','DD-MON-RR'),4,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6934,to_date('13-MAR-98','DD-MON-RR'),4,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10174,to_date('13-MAR-98','DD-MON-RR'),4,999,1,48.95)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,244,to_date('17-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,389,to_date('17-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1025,to_date('17-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2081,to_date('17-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3572,to_date('17-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4034,to_date('17-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9867,to_date('17-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10538,to_date('17-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11821,to_date('17-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,27140,to_date('17-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,244,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,615,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1025,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2081,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2401,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3141,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3572,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3874,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3941,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4034,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4141,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4436,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4641,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9867,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10538,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11821,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,32331,to_date('17-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,329,to_date('19-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3084,to_date('19-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3179,to_date('19-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3182,to_date('19-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4991,to_date('19-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7443,to_date('19-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,12269,to_date('19-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,34083,to_date('19-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,455,to_date('19-MAR-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,467,to_date('19-MAR-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1193,to_date('19-MAR-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2377,to_date('19-MAR-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2557,to_date('19-MAR-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4991,to_date('19-MAR-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5292,to_date('19-MAR-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6650,to_date('19-MAR-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10798,to_date('19-MAR-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11945,to_date('19-MAR-98','DD-MON-RR'),3,999,1,48.92)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3182,to_date('19-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,12002,to_date('19-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,782,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1397,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1749,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2234,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2355,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9193,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9453,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10292,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,23737,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,26795,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,33764,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,40743,to_date('20-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,804,to_date('21-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1114,to_date('21-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2204,to_date('21-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2777,to_date('21-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3468,to_date('21-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4262,to_date('21-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4629,to_date('21-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5627,to_date('21-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,681,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,837,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1114,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1124,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2204,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2220,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2777,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3468,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4262,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4401,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4629,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4682,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5627,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6173,to_date('21-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1114,to_date('21-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4629,to_date('21-MAR-98','DD-MON-RR'),4,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1037,to_date('23-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2253,to_date('23-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2315,to_date('23-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2769,to_date('23-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3159,to_date('23-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4071,to_date('23-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6274,to_date('23-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6564,to_date('23-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7184,to_date('23-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,309,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1037,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2051,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2253,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2315,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2943,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3159,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4071,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6274,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7184,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10693,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11253,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,33733,to_date('23-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,6274,to_date('23-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11253,to_date('23-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,493,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1236,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2159,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2314,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2765,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2771,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2774,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4241,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4932,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5127,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9725,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10071,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,13113,to_date('25-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,34,to_date('25-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2774,to_date('25-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,818,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1788,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2555,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3485,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3874,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4471,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5015,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5562,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7393,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9492,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9929,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10113,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,31946,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,32172,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,40364,to_date('26-MAR-98','DD-MON-RR'),2,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,818,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3485,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4471,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5015,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5562,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5649,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5834,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8427,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9420,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9492,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9929,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10113,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,31946,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,40364,to_date('26-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3874,to_date('26-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5562,to_date('26-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9492,to_date('26-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10113,to_date('26-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,32172,to_date('26-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,515,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,525,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1525,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1989,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2257,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2900,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2963,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4073,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4989,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5316,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7661,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8352,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,9927,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,14172,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,16774,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,26795,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,33734,to_date('28-MAR-98','DD-MON-RR'),3,999,1,48.75)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,7053,to_date('28-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,8352,to_date('28-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10262,to_date('28-MAR-98','DD-MON-RR'),4,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1193,to_date('30-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1871,to_date('30-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2557,to_date('30-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3254,to_date('30-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3633,to_date('30-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4323,to_date('30-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,5292,to_date('30-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,10798,to_date('30-MAR-98','DD-MON-RR'),2,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,1871,to_date('30-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,2555,to_date('30-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,3725,to_date('30-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,4323,to_date('30-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (24,11651,to_date('30-MAR-98','DD-MON-RR'),3,999,1,49.43)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,25062,to_date('02-JAN-98','DD-MON-RR'),2,999,1,126.93)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1369,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1562,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3581,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5681,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6344,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6683,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,7902,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,8343,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,11131,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,11453,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,14979,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,25062,to_date('02-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,513,to_date('03-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,9332,to_date('03-JAN-98','DD-MON-RR'),4,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,7779,to_date('07-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,461,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,800,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1532,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1948,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2077,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2128,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2796,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2865,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3212,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3549,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4144,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4664,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4802,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6213,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6859,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6955,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,7082,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,7779,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,8687,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,9076,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,9573,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,10099,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,12093,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,14124,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,26626,to_date('07-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1713,to_date('08-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3570,to_date('08-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4191,to_date('08-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5525,to_date('08-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5647,to_date('08-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6517,to_date('08-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6608,to_date('08-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,48811,to_date('08-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,42,to_date('10-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,693,to_date('10-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2672,to_date('10-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2913,to_date('10-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3302,to_date('10-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4532,to_date('10-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,21782,to_date('10-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,34834,to_date('10-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,693,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,932,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1948,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2077,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2671,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2913,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3302,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3550,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3557,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4532,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6221,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6272,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6859,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6957,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,7083,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,7872,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,8687,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,9579,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,14979,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,21782,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,26630,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,44733,to_date('10-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3302,to_date('10-JAN-98','DD-MON-RR'),4,999,1,127.06)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,21782,to_date('10-JAN-98','DD-MON-RR'),4,999,1,127.06)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6824,to_date('13-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6932,to_date('13-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,689,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,807,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,874,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,922,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,987,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1843,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1902,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2273,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2302,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2423,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2683,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5203,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5731,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6277,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6824,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6932,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,8540,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,9035,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,12099,to_date('13-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,899,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1981,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2105,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2113,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2329,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2529,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3547,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3784,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4013,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4660,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5163,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5184,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5298,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5310,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,8488,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,8886,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,9412,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,10552,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,11523,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,15095,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,33727,to_date('14-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,164,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,428,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,477,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,720,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,868,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,966,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1258,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1842,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2272,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2761,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2857,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3796,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3819,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3984,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4231,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4410,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5574,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5588,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5660,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5701,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5730,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,7849,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,8351,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,8687,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,12096,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,12136,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,13232,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,20973,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,25251,to_date('16-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1574,to_date('17-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2328,to_date('17-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3028,to_date('17-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4291,to_date('17-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4608,to_date('17-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4628,to_date('17-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6602,to_date('17-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,9879,to_date('17-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,11252,to_date('17-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,11663,to_date('17-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,30031,to_date('17-JAN-98','DD-MON-RR'),3,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1574,to_date('17-JAN-98','DD-MON-RR'),4,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,11252,to_date('17-JAN-98','DD-MON-RR'),4,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,350,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,355,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,407,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,533,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,542,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1157,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1573,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1743,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2411,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4974,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5726,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6467,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,8345,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,10747,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,11407,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,11702,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,33744,to_date('19-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,9604,to_date('20-JAN-98','DD-MON-RR'),2,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,188,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,531,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,949,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1386,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1423,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1959,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2021,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2080,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2096,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3014,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3783,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5813,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,7076,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,9680,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,11649,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,14053,to_date('21-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6273,to_date('23-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,181,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1081,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1260,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2013,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2762,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2769,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3268,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4414,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6264,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6273,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6394,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6488,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6999,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,8687,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,25938,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,39084,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,49833,to_date('23-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,238,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,275,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,288,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,314,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,333,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,533,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,788,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,953,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1155,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4973,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5724,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6465,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,8345,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,9366,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,11403,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,11457,to_date('25-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1255,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1951,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2600,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2760,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2855,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3539,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3720,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4881,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5696,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6612,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,6905,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,10002,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,12539,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,25244,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,32172,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,33722,to_date('26-JAN-98','DD-MON-RR'),3,999,1,126.99)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,10002,to_date('26-JAN-98','DD-MON-RR'),4,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2054,to_date('28-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,5084,to_date('28-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,7053,to_date('28-JAN-98','DD-MON-RR'),2,999,1,128.32)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,254,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,276,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,307,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,411,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1322,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1567,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1604,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1645,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1786,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1837,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1949,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,1971,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2054,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2079,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2383,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2406,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,2748,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3279,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3316,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3732,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3913,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,3960,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4053,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4621,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
Into ODMR_SALES_DATA (PROD_ID,CUST_ID,TIME_ID,CHANNEL_ID,PROMO_ID,QUANTITY_SOLD,AMOUNT_SOLD) values (25,4942,to_date('28-JAN-98','DD-MON-RR'),3,999,1,126.55)
select * from dual;

COMMIT;