<COST_SETTING>

  -- apply result for test
  v_apply_data := generateUniqueName;
  execSQL('CREATE TABLE '||v_apply_data||' <TABLE_PARALLEL_HINT> AS SELECT <PARALLEL_HINT> "'||v_caseid||'", t.* FROM '||v_test_data||' s, TABLE(PREDICTION_SET(<MODEL_NAME_PARAM> <TEST_APPLY_COST_OPTION>)) t');
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_apply_data, 'TABLE', NULL, 'Apply Data');

  -- test metric
  v_test_metric := generateUniqueName;
  execSQL('CREATE TABLE '||v_test_metric||' (METRIC_NAME VARCHAR2(30), METRIC_VARCHAR_VALUE VARCHAR2(128), METRIC_NUM_VALUE NUMBER) <COMPRESSION_METHOD> <PRIORITY_LEVEL>');
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_test_metric, 'TABLE', NULL, 'Test Metric');

  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''MODEL_SCHEMA'', SUBSTR(''<MODEL_NAME_PARAM>'', 1 ,INSTR(''<MODEL_NAME_PARAM>'', ''.'', 1, 1)-1))');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''MODEL_NAME'', SUBSTR(''<MODEL_NAME_PARAM>'', INSTR(''<MODEL_NAME_PARAM>'',''.'', -1, 1)+1))');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''MINING_FUNCTION'', ''CLASSIFICATION'')');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''TARGET_ATTRIBUTE'', '''||v_target||''')');

  EXECUTE IMMEDIATE 'SELECT "'||v_target||'" FROM '||v_test_data||' GROUP BY "'||v_target||'" ORDER BY count(*) ASC' BULK COLLECT INTO v_targets;
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''LEAST_TARGET_VALUE'', '''||v_targets(1)||''')');

  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE) SELECT ''TEST_ROWS'', count(*) FROM '||v_test_data);

  -- confusion matrix
  v_confusion_matrix := generateUniqueName;
  DBMS_DATA_MINING.COMPUTE_CONFUSION_MATRIX (
    accuracy                    => v_accuracy,
    apply_result_table_name     => v_apply_data,
    target_table_name           => v_test_data,
    case_id_column_name         => '"'||v_caseid||'"',
    target_column_name          => '"'||v_target||'"',
    confusion_matrix_table_name => v_confusion_matrix,
    score_column_name           => 'PREDICTION',
    score_criterion_column_name => '<SCORE_CRITERION>',
    score_criterion_type        => '<SCORE_CRITERION>');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''ACCURACY'', NVL('||v_accuracy||', 0)*100)');
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_confusion_matrix, 'TABLE', NULL, 'Confusion Matrix');
  
  -- average accuracy
  v_sql := 
    'INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE)
    WITH
    a as
      (SELECT a.actual_target_value, sum(a.value) recall_total
         FROM '||v_confusion_matrix||' a
         group by a.actual_target_value)
      ,
    b as
      (SELECT count(distinct b.actual_target_value) num_recalls
         FROM '||v_confusion_matrix||' b)
      ,
    c as
      (SELECT c.actual_target_value, value
         FROM '||v_confusion_matrix||' c
         where actual_target_value = predicted_target_value)
      ,
    d as
      (SELECT NVL(sum(c.value/GREATEST(0.0001, a.recall_total)), 0) tot_accuracy
         FROM a, c
         where a.actual_target_value = c.actual_target_value(+))
    SELECT ''AVG_ACCURACY'', d.tot_accuracy/GREATEST(0.0001, b.num_recalls) * 100 avg_accuracy
    FROM b, d';
  execSQL(v_sql);

  -- predictive confidence
  v_sql := 
    'INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE)
    WITH
    a as
      (SELECT a.actual_target_value, sum(a.value) recall_total
         FROM '||v_confusion_matrix||' a
         group by a.actual_target_value)
      ,
    b as
      (SELECT count(distinct b.actual_target_value) num_classes
         FROM '||v_confusion_matrix||' b)
      ,
    c as
      (SELECT c.actual_target_value, value
         FROM '||v_confusion_matrix||' c
         WHERE actual_target_value = predicted_target_value)
      ,
    d as
      (SELECT NVL(sum(c.value/a.recall_total), 0) tot_accuracy
         FROM a, c
         WHERE a.actual_target_value = c.actual_target_value(+))
    SELECT ''PREDICTIVE_CONFIDENCE'', GREATEST(0, ((1 - (1 - d.tot_accuracy/GREATEST(0.0001, b.num_classes)) / GREATEST(0.0001, ((b.num_classes-1)/GREATEST(0.0001, b.num_classes)))) * 100))
    FROM b, d';
  execSQL(v_sql);
  
<COMPUTE_TOTAL_COST>
<TEST_TARGET_VALUES>
<GEN_LIFT_RESULT>
<GEN_ROC_RESULT>