package org.jdesktop.animation.timing.triggers;

public class ComponentFocusEvent extends TriggerEvent
{
    public static final ComponentFocusEvent FOCUS_IN;
    public static final ComponentFocusEvent FOCUS_OUT;
    
    protected ComponentFocusEvent(final String name) {
        super(name);
    }
    
    @Override
    public TriggerEvent getOppositeEvent() {
        if (this == ComponentFocusEvent.FOCUS_IN) {
            return ComponentFocusEvent.FOCUS_OUT;
        }
        return ComponentFocusEvent.FOCUS_IN;
    }
    
    static {
        FOCUS_IN = new ComponentFocusEvent("FocusIn");
        FOCUS_OUT = new ComponentFocusEvent("FocusOut");
    }
}