package org.jdesktop.animation.timing.triggers;

import java.util.EventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jdesktop.animation.timing.TimingController;

public class ActionTrigger extends Trigger
{

	private class ActionTriggerListener extends TriggerListener implements ActionListener
	{
		protected ActionTriggerListener(final TimingController timer, final Trigger.TriggerAction action) {
			super(timer, action);
		}
		
		public void actionPerformed(final ActionEvent ae) {
			this.pullTrigger();
		}
	}
    public ActionTrigger(final TimingController timer, final Object source, final Trigger.TriggerAction action) {
        this.setupListener(timer, source, action, null);
    }
    
    @Override
    protected void setupListener(final TimingController timer, final Object source, final Trigger.TriggerAction action, final TriggerEvent event) {
        try {
            final ActionTrigger.ActionTriggerListener listener = new ActionTrigger.ActionTriggerListener(timer, action);
            this.setupListener(source, (EventListener)listener, "addActionListener", ActionListener.class);
        }
        catch (Exception e) {
            System.out.println("Exception creating action listener for object " + source + ": " + e);
        }
    }
}