package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import java.awt.Point;

class KeyValuesPoint extends KeyValues<Point>
{
    public KeyValuesPoint(final Point... values) {
        super(values);
        for (final Point value : values) {
            this.values.add(value);
        }
    }
    
    @Override
    public Class<?> getType() {
        return Point.class;
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int i0, final int i1, final float fraction) {
        final Point value = (Point)((Point)this.values.get(i0)).clone();
        if (i0 != i1) {
            final Point v0 = (Point)this.values.get(i0);
            final Point v2 = (Point)this.values.get(i1);
            final Point point = value;
            point.x += (int)((v2.x - v0.x) * fraction + 0.5);
            final Point point2 = value;
            point2.y += (int)((v2.y - v0.y) * fraction + 0.5);
        }
        try {
            method.invoke(object, value);
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVFloat.setValue:" + e);
        }
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int index) {
        try {
            method.invoke(object, this.values.get(index));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVFloat.setValue:" + e);
        }
    }
}