package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import java.awt.Color;

class KeyValuesColor extends KeyValues<Color>
{
    public KeyValuesColor(final Color... values) {
        super(values);
        for (final Color value : values) {
            this.values.add(value);
        }
    }
    
    @Override
    public Class<?> getType() {
        return Color.class;
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int i0, final int i1, final float fraction) {
        Color lowerValue = (Color)this.values.get(i0);
        if (lowerValue == null) {
            lowerValue = (Color)this.startValue;
        }
        Color value;
        if (i0 == i1) {
            value = lowerValue;
        }
        else {
            final Color v0 = lowerValue;
            final Color v2 = (Color)this.values.get(i1);
            final int red = (int)(v0.getRed() + (v2.getRed() - v0.getRed()) * fraction + 0.5);
            final int green = (int)(v0.getGreen() + (v2.getGreen() - v0.getGreen()) * fraction + 0.5);
            final int blue = (int)(v0.getBlue() + (v2.getBlue() - v0.getBlue()) * fraction + 0.5);
            final int alpha = (int)(v0.getAlpha() + (v2.getAlpha() - v0.getAlpha()) * fraction + 0.5);
            value = new Color(red, green, blue, alpha);
        }
        try {
            method.invoke(object, value);
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVColor.setValue:" + e);
        }
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int index) {
        try {
            method.invoke(object, this.values.get(index));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVColor.setValue:" + e);
        }
    }
}