package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;

public abstract class KeyValues<T>
{
    protected ArrayList<T> values;
    protected Object startValue;
    
    protected KeyValues() {
        this.values = new ArrayList<T>();
    }
    
    protected KeyValues(final Object[] values) {
        this.values = new ArrayList<T>();
        if (values.length == 1) {
            this.values.add(null);
        }
    }
    
    protected KeyValues(final float[] values) {
        this.values = new ArrayList<T>();
        if (values.length == 1) {
            this.values.add(null);
        }
    }
    
    protected KeyValues(final int[] values) {
        this.values = new ArrayList<T>();
        if (values.length == 1) {
            this.values.add(null);
        }
    }
    
    protected KeyValues(final double[] values) {
        this.values = new ArrayList<T>();
        if (values.length == 1) {
            this.values.add(null);
        }
    }
    
    public int getSize() {
        return this.values.size();
    }
    
    public static KeyValues createKeyValues(final int... values) {
        return (KeyValues)new KeyValuesInt(values);
    }
    
    public static KeyValues createKeyValues(final float... values) {
        return (KeyValues)new KeyValuesFloat(values);
    }
    
    public static KeyValues createKeyValues(final double... values) {
        return (KeyValues)new KeyValuesDouble(values);
    }
    
    public static KeyValues createKeyValues(final Point... values) {
        return (KeyValues)new KeyValuesPoint(values);
    }
    
    public static KeyValues createKeyValues(final Dimension... values) {
        return (KeyValues)new KeyValuesDimension(values);
    }
    
    public static KeyValues createKeyValues(final Rectangle... values) {
        return (KeyValues)new KeyValuesRectangle(values);
    }
    
    public static KeyValues createKeyValues(final Color... values) {
        return (KeyValues)new KeyValuesColor(values);
    }
    
    public abstract Class<?> getType();
    
    public void setStartValue(final Object startValue) {
        if (this.isToAnimation()) {
            this.startValue = startValue;
        }
    }
    
    boolean isToAnimation() {
        return this.values.get(0) == null;
    }
    
    public abstract void setValue(final Object p0, final Method p1, final int p2, final int p3, final float p4);
    
    public abstract void setValue(final Object p0, final Method p1, final int p2);
}