package org.jdesktop.animation.timing;

public class Envelope
{

    public enum EndBehavior
    {
        HOLD, 
        RESET;
    }
    
    public enum RepeatBehavior
    {
        FORWARD, 
        REVERSE;
    }

    private double repeatCount;
    private int begin;
    private RepeatBehavior repeatBehavior;
    private EndBehavior endBehavior;
    
    public Envelope(final double repeatCount, final int begin, final RepeatBehavior repeatBehavior, final EndBehavior endBehavior) {
        if (begin < 0 || endBehavior == null || (repeatCount != -1.0 && repeatCount <= 0.0)) {
            String errorMessage = "Errors: ";
            if (begin < 0) {
                errorMessage = errorMessage + "begin " + begin + " cannot be negative\n";
            }
            if (endBehavior == null) {
                errorMessage += "endBehavior cannot be null\n";
            }
            if (repeatCount != -1.0 && repeatCount <= 0.0) {
                errorMessage = errorMessage + "cannot have zero or negative value of repeatCount (" + repeatCount + ")\n";
            }
            throw new IllegalArgumentException(errorMessage);
        }
        this.repeatCount = repeatCount;
        this.begin = begin;
        this.repeatBehavior = repeatBehavior;
        this.endBehavior = endBehavior;
    }
    
    public double getRepeatCount() {
        return this.repeatCount;
    }
    
    public int getBegin() {
        return this.begin;
    }
    
    public RepeatBehavior getRepeatBehavior() {
        return this.repeatBehavior;
    }
    
    public EndBehavior getEndBehavior() {
        return this.endBehavior;
    }
    
}
