DROP TABLE DEMO_STATES;
DROP TABLE DEMO_COUNTIES;
DROP TABLE DEMO_CITIES;

delete from USER_SDO_GEOM_METADATA where TABLE_NAME = 'DEMO_STATES' and COLUMN_NAME = 'GEOM';

delete from USER_SDO_GEOM_METADATA where TABLE_NAME = 'DEMO_COUNTIES' and COLUMN_NAME = 'GEOM';

delete from USER_SDO_GEOM_METADATA where TABLE_NAME = 'DEMO_CITIES' and COLUMN_NAME = 'LOCATION';

drop index DEMO_STATES_SDX FORCE;
drop index DEMO_COUNTIES_SDX FORCE;
drop index DEMO_CITIES_SDX FORCE;

commit;

CREATE TABLE DEMO_STATES
  (
    "STATE"      VARCHAR2(26 BYTE),
    "STATE_ABRV" VARCHAR2(2 BYTE),
    "FIPSST"     VARCHAR2(2 BYTE),
    "TOTPOP"     NUMBER,
    "PCTSMPLD"   NUMBER,
    "LANDSQMI"   NUMBER,
    "POPPSQMI"   NUMBER,
    "FEMALE"     NUMBER,
    "RURAL"      NUMBER,
    "ONFARMS"    NUMBER,
    "INFAMILY"   NUMBER,
    "ALONE"      NUMBER,
    "GROUPQTR"   NUMBER,
    "POPINHHS"   NUMBER,
    "PCTFEMAL"   NUMBER,
    "PCTGQ"      NUMBER,
    "WHITE"      NUMBER,
    "BLACK"      NUMBER,
    "ASIANPI"    NUMBER,
    "AMINDIAN"   NUMBER,
    "HISPANIC"   NUMBER,
    "PCTWHITE"   NUMBER,
    "PCTBLACK"   NUMBER,
    "PCTASIAN"   NUMBER,
    "PCTAMIND"   NUMBER,
    "PCTHISP"    NUMBER,
    "PCT0_4"     NUMBER,
    "PCT5_9"     NUMBER,
    "PCT10_13"   NUMBER,
    "PCT14_17"   NUMBER,
    "PCT18_24"   NUMBER,
    "PCT25_34"   NUMBER,
    "PCT35_44"   NUMBER,
    "PCT45_54"   NUMBER,
    "PCT55_59"   NUMBER,
    "PCT60_64"   NUMBER,
    "PCT65_74"   NUMBER,
    "PCT75_84"   NUMBER,
    "PCT85_UP"   NUMBER,
    "PCT0_19"    NUMBER,
    "PCT20_39"   NUMBER,
    "PCT40_64"   NUMBER,
    "PCT65_UP"   NUMBER,
    "AGE0_4"     NUMBER,
    "AGE5_9"     NUMBER,
    "AGE10_13"   NUMBER,
    "AGE14_17"   NUMBER,
    "AGE18_24"   NUMBER,
    "AGE25_34"   NUMBER,
    "AGE35_44"   NUMBER,
    "AGE45_54"   NUMBER,
    "AGE55_59"   NUMBER,
    "AGE60_64"   NUMBER,
    "AGE65_74"   NUMBER,
    "AGE75_84"   NUMBER,
    "AGE85_UP"   NUMBER,
    "AGE0_19"    NUMBER,
    "AGE20_39"   NUMBER,
    "AGE40_64"   NUMBER,
    "AGE65_UP"   NUMBER,
    "AGE0_17"    NUMBER,
    "AGE18_44"   NUMBER,
    "AGE45_64"   NUMBER,
    "MEDAGE"     NUMBER,
    "TOTHHS"     NUMBER,
    "AVGHHSZ"    NUMBER,
    "HHS1OV65"   NUMBER,
    "HHS1"       NUMBER,
    "HHS2"       NUMBER,
    "HHS3_4"     NUMBER,
    "HHS5_UP"    NUMBER,
    "PCTHHS1"    NUMBER,
    "PCTHHS2"    NUMBER,
    "PCTHHS3_"   NUMBER,
    "PCTHHS5_"   NUMBER,
    "FAMILIES"   NUMBER,
    "MCFAMS"     NUMBER,
    "MCWCHILD"   NUMBER,
    "FEMHEAD"    NUMBER,
    "FEMHEADC"   NUMBER,
    "NONFHHS"    NUMBER,
    "PCTFAMHH"   NUMBER,
    "PCTMCFAM"   NUMBER,
    "PCTMCWCH"   NUMBER,
    "PCTFEMHE"   NUMBER,
    "PCTFEMHC"   NUMBER,
    "PCTNFHHS"   NUMBER,
    "HHI0_10"    NUMBER,
    "HHI10_15"   NUMBER,
    "HHI15_25"   NUMBER,
    "HHI25_35"   NUMBER,
    "HHI35_50"   NUMBER,
    "HHI50_75"   NUMBER,
    "HHI75_99"   NUMBER,
    "HHI100UP"   NUMBER,
    "PHI0_10"    NUMBER,
    "PHI10_15"   NUMBER,
    "PHI15_25"   NUMBER,
    "PHI25_35"   NUMBER,
    "PHI35_50"   NUMBER,
    "PHI50_75"   NUMBER,
    "PHI75_99"   NUMBER,
    "PHI100UP"   NUMBER,
    "PHI0_15"    NUMBER,
    "PHI0_25"    NUMBER,
    "PHI0_35"    NUMBER,
    "PHI0_50"    NUMBER,
    "PHI0_75"    NUMBER,
    "PHI0_99"    NUMBER,
    "MEDHHINC"   NUMBER,
    "AVGHHINC"   NUMBER,
    "GEOM" "MDSYS"."SDO_GEOMETRY"
  );
  
  COMMIT;

CREATE OR REPLACE PROCEDURE INSERT_DEMO_STATES(
        STATE VARCHAR2,
        STATE_ABRV VARCHAR2,
        FIPSST VARCHAR2,
        TOTPOP NUMBER,
        PCTSMPLD NUMBER,
        LANDSQMI NUMBER,
        POPPSQMI NUMBER,
        FEMALE NUMBER,
        RURAL NUMBER,
        ONFARMS NUMBER,
        INFAMILY NUMBER,
        ALONE NUMBER,
        GROUPQTR NUMBER,
        POPINHHS NUMBER,
        PCTFEMAL NUMBER,
        PCTGQ NUMBER,
        WHITE NUMBER,
        BLACK NUMBER,
        ASIANPI NUMBER,
        AMINDIAN NUMBER,
        HISPANIC NUMBER,
        PCTWHITE NUMBER,
        PCTBLACK NUMBER,
        PCTASIAN NUMBER,
        PCTAMIND NUMBER,
        PCTHISP NUMBER,
        PCT0_4 NUMBER,
        PCT5_9 NUMBER,
        PCT10_13 NUMBER,
        PCT14_17 NUMBER,
        PCT18_24 NUMBER,
        PCT25_34 NUMBER,
        PCT35_44 NUMBER,
        PCT45_54 NUMBER,
        PCT55_59 NUMBER,
        PCT60_64 NUMBER,
        PCT65_74 NUMBER,
        PCT75_84 NUMBER,
        PCT85_UP NUMBER,
        PCT0_19 NUMBER,
        PCT20_39 NUMBER,
        PCT40_64 NUMBER,
        PCT65_UP NUMBER,
        AGE0_4 NUMBER,
        AGE5_9 NUMBER,
        AGE10_13 NUMBER,
        AGE14_17 NUMBER,
        AGE18_24 NUMBER,
        AGE25_34 NUMBER,
        AGE35_44 NUMBER,
        AGE45_54 NUMBER,
        AGE55_59 NUMBER,
        AGE60_64 NUMBER,
        AGE65_74 NUMBER,
        AGE75_84 NUMBER,
        AGE85_UP NUMBER,
        AGE0_19 NUMBER,
        AGE20_39 NUMBER,
        AGE40_64 NUMBER,
        AGE65_UP NUMBER,
        AGE0_17 NUMBER,
        AGE18_44 NUMBER,
        AGE45_64 NUMBER,
        MEDAGE NUMBER,
        TOTHHS NUMBER,
        AVGHHSZ NUMBER,
        HHS1OV65 NUMBER,
        HHS1 NUMBER,
        HHS2 NUMBER,
        HHS3_4 NUMBER,
        HHS5_UP NUMBER,
        PCTHHS1 NUMBER,
        PCTHHS2 NUMBER,
        PCTHHS3_ NUMBER,
        PCTHHS5_ NUMBER,
        FAMILIES NUMBER,
        MCFAMS NUMBER,
        MCWCHILD NUMBER,
        FEMHEAD NUMBER,
        FEMHEADC NUMBER,
        NONFHHS NUMBER,
        PCTFAMHH NUMBER,
        PCTMCFAM NUMBER,
        PCTMCWCH NUMBER,
        PCTFEMHE NUMBER,
        PCTFEMHC NUMBER,
        PCTNFHHS NUMBER,
        HHI0_10 NUMBER,
        HHI10_15 NUMBER,
        HHI15_25 NUMBER,
        HHI25_35 NUMBER,
        HHI35_50 NUMBER,
        HHI50_75 NUMBER,
        HHI75_99 NUMBER,
        HHI100UP NUMBER,
        PHI0_10 NUMBER,
        PHI10_15 NUMBER,
        PHI15_25 NUMBER,
        PHI25_35 NUMBER,
        PHI35_50 NUMBER,
        PHI50_75 NUMBER,
        PHI75_99 NUMBER,
        PHI100UP NUMBER,
        PHI0_15 NUMBER,
        PHI0_25 NUMBER,
        PHI0_35 NUMBER,
        PHI0_50 NUMBER,
        PHI0_75 NUMBER,
        PHI0_99 NUMBER,
        MEDHHINC NUMBER,
        AVGHHINC NUMBER,
        GEOM MDSYS.SDO_GEOMETRY)
IS
BEGIN
  Insert into DEMO_STATES (STATE,STATE_ABRV,FIPSST,TOTPOP,PCTSMPLD,LANDSQMI,POPPSQMI,FEMALE,RURAL,ONFARMS,INFAMILY,ALONE,
  GROUPQTR,POPINHHS,PCTFEMAL,PCTGQ,WHITE,BLACK,ASIANPI,AMINDIAN,HISPANIC,PCTWHITE,PCTBLACK,PCTASIAN,PCTAMIND,PCTHISP,
  PCT0_4,PCT5_9,PCT10_13,PCT14_17,PCT18_24,PCT25_34,PCT35_44,PCT45_54,PCT55_59,PCT60_64,PCT65_74,PCT75_84,PCT85_UP,
  PCT0_19,PCT20_39,PCT40_64,PCT65_UP,AGE0_4,AGE5_9,AGE10_13,AGE14_17,AGE18_24,AGE25_34,AGE35_44,AGE45_54,AGE55_59,
  AGE60_64,AGE65_74,AGE75_84,AGE85_UP,AGE0_19,AGE20_39,AGE40_64,AGE65_UP,AGE0_17,AGE18_44,AGE45_64,MEDAGE,TOTHHS,
  AVGHHSZ,HHS1OV65,HHS1,HHS2,HHS3_4,HHS5_UP,PCTHHS1,PCTHHS2,PCTHHS3_,PCTHHS5_,FAMILIES,MCFAMS,MCWCHILD,FEMHEAD,
  FEMHEADC,NONFHHS,PCTFAMHH,PCTMCFAM,PCTMCWCH,PCTFEMHE,PCTFEMHC,PCTNFHHS,HHI0_10,HHI10_15,HHI15_25,HHI25_35,HHI35_50,
  HHI50_75,HHI75_99,HHI100UP,PHI0_10,PHI10_15,PHI15_25,PHI25_35,PHI35_50,PHI50_75,PHI75_99,PHI100UP,PHI0_15,PHI0_25,
  PHI0_35,PHI0_50,PHI0_75,PHI0_99,MEDHHINC,AVGHHINC,GEOM)
  VALUES (STATE,STATE_ABRV,FIPSST,TOTPOP,PCTSMPLD,LANDSQMI,POPPSQMI,FEMALE,RURAL,ONFARMS,INFAMILY,ALONE,GROUPQTR,POPINHHS,
  PCTFEMAL,PCTGQ,WHITE,BLACK,ASIANPI,AMINDIAN,HISPANIC,PCTWHITE,PCTBLACK,PCTASIAN,PCTAMIND,PCTHISP,PCT0_4,PCT5_9,PCT10_13,
  PCT14_17,PCT18_24,PCT25_34,PCT35_44,PCT45_54,PCT55_59,PCT60_64,PCT65_74,PCT75_84,PCT85_UP,PCT0_19,PCT20_39,PCT40_64,PCT65_UP,
  AGE0_4,AGE5_9,AGE10_13,AGE14_17,AGE18_24,AGE25_34,AGE35_44,AGE45_54,AGE55_59,AGE60_64,AGE65_74,AGE75_84,AGE85_UP,AGE0_19,
  AGE20_39,AGE40_64,AGE65_UP,AGE0_17,AGE18_44,AGE45_64,MEDAGE,TOTHHS,AVGHHSZ,HHS1OV65,HHS1,HHS2,HHS3_4,HHS5_UP,PCTHHS1,
  PCTHHS2,PCTHHS3_,PCTHHS5_,FAMILIES,MCFAMS,MCWCHILD,FEMHEAD,FEMHEADC,NONFHHS,PCTFAMHH,PCTMCFAM,PCTMCWCH,PCTFEMHE,
  PCTFEMHC,PCTNFHHS,HHI0_10,HHI10_15,HHI15_25,HHI25_35,HHI35_50,HHI50_75,HHI75_99,HHI100UP,PHI0_10,PHI10_15,PHI15_25,
  PHI25_35,PHI35_50,PHI50_75,PHI75_99,PHI100UP,PHI0_15,PHI0_25,PHI0_35,PHI0_50,PHI0_75,PHI0_99,MEDHHINC,AVGHHINC,GEOM);
END;
/
COMMIT;


DECLARE
geom MDSYS.SDO_GEOMETRY;
BEGIN

geom := 
MDSYS.SDO_GEOMETRY(2003,8265,null,
MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-114.81282,32.494221,-113.403648,32.060863,-113.333031,32.039032,-112.969223,31.925663,-111.365921,
31.425982,-111.074387,31.332207,-111.074181,31.33214,-110.459534,31.333403,-110.263756,31.333094,-109.999985,31.333044,
-109.049431,31.332397,-109.046997,32.4263,-109.046494,32.7775,-109.046616,33.2089,-109.04631,33.778179,-109.045517,
34.57925,-109.045212,34.959682,-109.045319,36.002327,-109.044571,36.999088,-110,36.997967,-110.469505,36.998001,
-110.5,37.004265,-110.75,37.003201,-111.133018,37.00079,-111.412048,37.001514,-112,37.000977,-112.539604,37.000683,
-112.898598,37.000401,-113.484375,37,-114.049797,37.000423,-114.049812,36.843151,-114.049789,36.654728,-114.045029,
36.442993,-114.047722,36.289616,-114.046051,36.194084,-114.059509,36.189381,-114.06723,36.180679,-114.085175,
36.147228,-114.091377,36.140053,-114.099075,36.12167,-114.110214,36.119892,-114.122353,36.111591,-114.122421,
36.104759,-114.116661,36.100906,-114.113739,36.09523,-114.121094,36.086819,-114.136101,36.059479,-114.137405,
36.041302,-114.146011,36.035141,-114.147392,36.028027,-114.153336,36.023876,-114.165672,36.027752,-114.176025,
36.027664,-114.191582,36.021008,-114.212898,36.015629,-114.232491,36.014305,-114.251854,36.020206,-114.265923,
36.029251,-114.272362,36.046417,-114.279404,36.046375,-114.290733,36.050343,-114.297493,36.056911,-114.30999,
36.057281,-114.314751,36.059513,-114.313408,36.066635,-114.304939,36.074902,-114.307632,36.082458,-114.327972,
36.105518,-114.336472,36.108036,-114.345154,36.11834,-114.362305,36.130264,-114.371307,36.143131,-114.375,
36.144188,-114.382011,36.141682,-114.404671,36.147388,-114.413826,36.146717,-114.426361,36.136326,-114.445801,
36.125988,-114.452522,36.130745,-114.457558,36.138603,-114.46283,36.139717,-114.469345,36.138821,-114.486221,
36.129417,-114.502373,36.126961,-114.507072,36.128162,-114.509941,36.132504,-114.5009,36.143394,-114.51091,
36.150974,-114.531731,36.148201,-114.539169,36.152199,-114.571213,36.15163,-114.581261,36.146271,-114.596397,
36.142124,-114.615883,36.130119,-114.621071,36.132153,-114.627037,36.141033,-114.630905,36.142326,-114.636368,
36.13607,-114.659134,36.124168,-114.664597,36.116722,-114.672081,36.116371,-114.678917,36.110672,-114.683167,
36.109684,-114.693024,36.11319,-114.702637,36.109024,-114.735352,36.104389,-114.751305,36.092278,-114.754799,
36.087189,-114.754669,36.081623,-114.742531,36.070557,-114.73465,36.056702,-114.74276,36.044575,-114.743065,
36.040241,-114.733017,36.038124,-114.721046,36.031425,-114.723289,36.026711,-114.737961,36.015079,-114.742226,
36.008663,-114.739059,35.992733,-114.74276,35.983742,-114.727501,35.956306,-114.730347,35.943935,-114.706711,
35.928082,-114.707703,35.912331,-114.699455,35.901787,-114.670967,35.877407,-114.661797,35.873299,-114.661598,
35.869598,-114.670998,35.865101,-114.682404,35.8629,-114.689301,35.859699,-114.693604,35.854198,-114.703796,
35.8517,-114.704201,35.844898,-114.695602,35.833801,-114.695,35.829601,-114.702904,35.814602,-114.711304,35.806198,
-114.698105,35.790199,-114.7006,35.7691,-114.693604,35.756901,-114.697197,35.751301,-114.696701,35.7328,-114.704597,
35.708302,-114.700401,35.701199,-114.682404,35.6894,-114.679802,35.685501,-114.689201,35.6647,-114.688599,35.651424,-114.676308,
35.641499,-114.664597,35.621899,-114.657402,35.619099,-114.652603,35.610802,-114.653503,35.597599,-114.658798,35.587502,
-114.674706,35.580002,-114.666901,35.574001,-114.662598,35.564701,-114.661201,35.545502,-114.656105,35.534401,-114.663399,
35.5219,-114.668106,35.521301,-114.675201,35.515499,-114.6782,35.502117,-114.676842,35.489754,-114.672096,35.481716,
-114.673058,35.475544,-114.665573,35.466866,-114.666878,35.460411,-114.662315,35.445923,-114.654846,35.437759,-114.652618,
35.430603,-114.626335,35.409512,-114.619423,35.392864,-114.617165,35.379665,-114.603516,35.353588,-114.595131,35.325241,
-114.596703,35.296959,-114.586327,35.262379,-114.57917,35.209644,-114.57132,35.200592,-114.568443,35.183479,-114.571953,
35.138729,-114.577728,35.128754,-114.583504,35.125,-114.59832,35.121052,-114.61805,35.121723,-114.627632,35.118942,
-114.645958,35.101871,-114.638733,35.094482,-114.621719,35.088703,-114.612335,35.083096,-114.603935,35.074833,-114.602112,
35.068588,-114.605896,35.058941,-114.626328,35.04472,-114.633949,35.03373,-114.637222,35.017128,-114.632217,35.002083,
-114.62822,34.986149,-114.634438,34.965149,-114.628967,34.943039,-114.632454,34.924606,-114.630081,34.907261,-114.635925,
34.889103,-114.632256,34.869968,-114.623146,34.859737,-114.599854,34.847355,-114.586044,34.835667,-114.575653,34.815296,
-114.570213,34.794289,-114.551888,34.766869,-114.528824,34.750816,-114.515823,34.73674,-114.491226,34.725697,-114.48671,
34.716621,-114.470192,34.712208,-114.464455,34.691196,-114.449715,34.666828,-114.457191,34.657104,-114.440674,34.642525,
-114.437943,34.621449,-114.423409,34.610443,-114.424545,34.600834,-114.436012,34.596066,-114.421593,34.5807,-114.404442,
34.56963,-114.380051,34.529713,-114.377335,34.507275,-114.381569,34.495747,-114.380913,34.476028,-114.38591,34.457901,
-114.372925,34.446926,-114.336685,34.450905,-114.330978,34.44664,-114.325928,34.437843,-114.300232,34.426796,-114.29261,
34.41951,-114.290367,34.409771,-114.286018,34.405327,-114.262131,34.40036,-114.23349,34.376648,-114.225327,34.365906,
-114.198692,34.361359,-114.176125,34.349293,-114.168022,34.3395,-114.156425,34.317848,-114.137505,34.303215,-114.135887,
34.274364,-114.130432,34.262714,-114.132484,34.25845,-114.163864,34.259686,-114.163086,34.253338,-114.165344,34.25,
-114.173813,34.247288,-114.177269,34.239956,-114.210976,34.211525,-114.224419,34.203629,-114.224159,34.193878,-114.228935,
34.186913,-114.239929,34.183216,-114.256248,34.172825,-114.267677,34.170162,-114.274483,34.172134,-114.286514,34.170517,
-114.319992,34.138618,-114.335327,34.134022,-114.352249,34.133102,-114.365738,34.118561,-114.378448,34.115971,-114.389778,
34.110069,-114.400818,34.111637,-114.410896,34.110016,-114.419708,34.103451,-114.432594,34.088394,-114.434639,34.079712,
-114.438553,34.057877,-114.434158,34.037769,-114.437477,34.022591,-114.449417,34.012562,-114.46508,34.010971,-114.466522,
34.005177,-114.458397,34,-114.45784,33.995541,-114.46714,33.992859,-114.4991,33.961773,-114.507881,33.957508,-114.515076,
33.958088,-114.522339,33.954647,-114.534691,33.934635,-114.532906,33.925076,-114.517647,33.9175,-114.510719,33.911076,
-114.507126,33.90379,-114.507919,33.900623,-114.512924,33.897942,-114.523499,33.901569,-114.525078,33.900215,-114.521973,
33.892563,-114.503006,33.876053,-114.502625,33.866432,-114.513885,33.85862,-114.524879,33.859985,-114.529816,33.855419,
-114.51918,33.825363,-114.521927,33.818958,-114.527267,33.814945,-114.504074,33.760445,-114.503693,33.75098,-114.511559,
33.734192,-114.495773,33.719135,-114.493408,33.707901,-114.494926,33.698433,-114.52317,33.685856,-114.530739,33.675087,
-114.52948,33.666801,-114.513275,33.660156,-114.517555,33.655903,-114.529793,33.654442,-114.53241,33.651634,-114.523018,
33.634678,-114.525581,33.630238,-114.530251,33.628189,-114.530426,33.623886,-114.521057,33.612518,-114.528397,33.606628,
-114.539833,33.591389,-114.539513,33.580593,-114.536003,33.570934,-114.523819,33.552204,-114.558113,33.531796,-114.560173,
33.516712,-114.568741,33.509193,-114.579681,33.506439,-114.591583,33.49865,-114.600914,33.481369,-114.622131,33.456535,
-114.621498,33.447529,-114.626335,33.433525,-114.634392,33.422699,-114.64875,33.413605,-114.657593,33.41301,-114.673111,
33.41827,-114.687157,33.417915,-114.694862,33.415096,-114.700943,33.40836,-114.719269,33.407864,-114.724747,33.404026,
-114.70652,33.382511,-114.706558,33.376598,-114.698265,33.361118,-114.69725,33.352413,-114.700142,33.336983,-114.707169,
33.323391,-114.722832,33.312077,-114.730431,33.302402,-114.720879,33.286949,-114.693657,33.279755,-114.679718,33.273544,
-114.671295,33.258465,-114.688751,33.246395,-114.672836,33.223087,-114.677963,33.203415,-114.674568,33.185455,-114.679459,
33.169682,-114.678566,33.159485,-114.686287,33.142159,-114.696037,33.131172,-114.705383,33.105297,-114.707031,33.091064,
-114.703934,33.087013,-114.688232,33.084,-114.686203,33.07093,-114.673508,33.057133,-114.672874,33.041859,-114.66153,
33.032631,-114.657043,33.033787,-114.645195,33.048862,-114.638771,33.045254,-114.627502,33.031013,-114.617996,33.027164,
-114.588989,33.026192,-114.583977,33.028191,-114.577507,33.035336,-114.570869,33.036587,-114.530296,33.032356,-114.515671,
33.027576,-114.507179,33.019669,-114.50045,33.007519,-114.492157,32.971741,-114.487839,32.969906,-114.475754,32.975136,
-114.467827,32.971611,-114.467278,32.955219,-114.479439,32.937889,-114.480003,32.93364,-114.475853,32.923588,-114.463196,
32.912399,-114.462112,32.905758,-114.468193,32.845112,-114.493408,32.823189,-114.50943,32.816376,-114.528847,32.795433,
-114.531647,32.776878,-114.52607,32.75705,-114.538315,32.756905,-114.538437,32.749767,-114.563667,32.749508,-114.563728,
32.742252,-114.580956,32.742275,-114.581001,32.734901,-114.614304,32.734463,-114.614799,32.728401,-114.616875,32.728168,
-114.687737,32.737545,-114.70079,32.745586,-114.713737,32.730343,-114.718849,32.718716,-114.748169,32.663486,-114.748688,
32.661732,-114.749405,32.661156,-114.749908,32.66021,-114.764114,32.648834,-114.764091,32.648495,-114.76252,32.644566,
-114.763695,32.643753,-114.763596,32.642616,-114.778427,32.63353,-114.781166,32.625561,-114.781723,32.625324,-114.781784,
32.624252,-114.789467,32.622047,-114.789986,32.62183,-114.790092,32.621872,-114.79039,32.621784,-114.79834,32.624992,
-114.79924,32.624603,-114.806129,32.620216,-114.807251,32.603123,-114.801567,32.599316,-114.801582,32.599125,-114.800758,
32.598541,-114.798943,32.592129,-114.803108,32.582787,-114.803139,32.582443,-114.802498,32.580406,-114.800682,32.578201,
-114.801567,32.577469,-114.801086,32.575958,-114.812195,32.568657,-114.813034,32.563251,-114.80835,32.558659,-114.807663,
32.558708,-114.796341,32.566368,-114.792435,32.569408,-114.792389,32.569046,-114.792023,32.56929,-114.792076,32.566776,
-114.790756,32.556973,-114.792374,32.553555,-114.792381,32.553097,-114.792648,32.552967,-114.792976,32.552277,-114.803162,
32.547234,-114.803612,32.542404,-114.801392,32.536362,-114.812561,32.524132,-114.809113,32.517925,-114.803253,32.516434,
-114.803253,32.516399,-114.802879,32.516323,-114.801422,32.513138,-114.803284,32.511631,-114.803291,32.510319,-114.805222,
32.510063,-114.806938,32.508671,-114.813484,32.507912,-114.813248,32.503067,-114.811531,32.5,-114.81282,32.494221));

INSERT_DEMO_STATES(
'Arizona','AZ','04',3665228,12.7988,113622.6875,32.2578,1857232,458153,6967,3053980,335745,79920,
3585308,50.6716,2.1801,2967682,110062,54127,204589,680628,80.9531,3.0024,1.4765,5.581,18.5664,7.9228,
7.664,5.7119,5.4033,10.5097,17.4531,14.4648,9.6757,3.9575,4.2099,7.9169,4.0976,1.0039,29.7265,32.6718,
24.5703,13.0195,290422,280940,209356,198065,385268,639702,530192,354711,145054,154318,290177,150221,
36802,1089657,1197670,900701,477200,978783,1555162,654083,32.3307,1371885,2.6134,122072,335745,475924,
397326,162890,24.4726,34.6875,28.9609,11.873,949418,764373,344302,138233,85385,422467,69.2031,80.5,36.2578,
14.5585,8.9921,30.7929,213242,135940,269528,228335,239525,182396,56045,46874,15.5429,9.9082,19.6445,16.6406,
17.457,13.2949,4.0849,3.4165,25.4492,45.0937,61.7421,79.1875,92.4843,96.5781,27540,35425,
geom);
COMMIT;
      
END;
/


DECLARE
geom MDSYS.SDO_GEOMETRY;
BEGIN

  
geom := 
MDSYS.SDO_GEOMETRY(2007,8265,null,
MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,71,1003,1,137,1003,1,165,1003,1,201,1003,1,275,1003,1,353,1003,1,411,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-118.576416,33.475281,-118.606041,33.478664,-118.60096,33.46851,-118.58065,33.450737,-118.572182,
33.438042,-118.559486,33.432961,-118.534103,33.430424,-118.514633,33.420269,-118.49855,33.420269,-118.487549,33.417728,
-118.483322,33.406727,-118.483322,33.388107,-118.487549,33.355946,-118.480774,33.3424,-118.465546,33.326321,-118.438461,
33.317856,-118.419838,33.316162,-118.388527,33.31955,-118.374138,33.317856,-118.354675,33.311932,-118.334358,33.300083,
-118.325897,33.297543,-118.310654,33.303467,-118.301353,33.313625,-118.306427,33.329704,-118.315735,33.343246,-118.363136,
33.387257,-118.37075,33.41011,-118.424919,33.427883,-118.45031,33.432114,-118.479088,33.448196,-118.496857,33.443119,
-118.502007,33.450352,-118.535789,33.475281,-118.576416,33.475281,-118.605766,33.014275,-118.592896,33.012344,-118.585823,
33.006554,-118.582458,33,-118.576164,32.975674,-118.549789,32.944149,-118.540146,32.910046,-118.528557,32.901043,-118.507324,
32.869514,-118.49897,32.851501,-118.472588,32.83799,-118.437851,32.814186,-118.423691,32.80003,-118.41597,32.806465,-118.401817,
32.812256,-118.399887,32.819977,-118.390877,32.823189,-118.381874,32.823837,-118.355499,32.816116,-118.347771,32.820618,
-118.452003,32.900398,-118.463577,32.912621,-118.478378,32.919697,-118.495102,32.931923,-118.520844,32.964737,-118.545937,
32.989185,-118.546577,32.998833,-118.560089,33.011703,-118.563301,33.023926,-118.573601,33.032932,-118.592896,33.036152,
-118.605766,33.032288,-118.605766,33.014275,-119.442253,34.014381,-119.436928,34.009716,-119.420486,34.004383,-119.410721,
34.005714,-119.395607,34.002609,-119.389618,34.002827,-119.376953,34.010822,-119.356071,34.015938,-119.36451,34.017487,
-119.390945,34.006161,-119.407158,34.00705,-119.420486,34.015266,-119.433372,34.015938,-119.442253,34.014381,-119.572403,
33.258213,-119.564743,33.245968,-119.538719,33.230659,-119.511681,33.221989,-119.475456,33.213825,-119.454033,33.214848,
-119.438217,33.218929,-119.421379,33.228622,-119.43515,33.2327,-119.460663,33.256683,-119.502495,33.270458,-119.52494,
33.283722,-119.534637,33.28474,-119.549438,33.280151,-119.552597,33.276299,-119.558624,33.271477,-119.578011,33.278111,
-119.572403,33.258213,-119.917366,34.077023,-119.928993,34.059586,-119.905746,34.054352,-119.876099,34.031101,-119.876099,
34.022381,-119.886559,34.008427,-119.88279,34,-119.873772,33.980522,-119.84877,33.965992,-119.816803,33.960758,-119.753433,
33.962505,-119.721466,33.959015,-119.675537,33.977619,-119.658684,33.986919,-119.603455,33.988663,-119.560432,33.994476,
-119.545319,34.007267,-119.538345,34.021217,-119.525551,34.027031,-119.519157,34.034588,-119.530205,34.042728,-119.562759,
34.056095,-119.584274,34.053772,-119.605202,34.040401,-119.607521,34.036331,-119.607521,34.025867,-119.616241,34.018311,
-119.637749,34.015404,-119.65345,34.01947,-119.676697,34.020058,-119.714485,34.043888,-119.758667,34.058426,-119.797615,
34.057259,-119.809822,34.052608,-119.83831,34.065399,-119.856911,34.071213,-119.917366,34.077023,-120.248718,34.001453,
-120.246399,33.997383,-120.237099,33.991573,-120.223145,33.988083,-120.217339,33.977036,-120.19059,33.947971,-120.176643,
33.924717,-120.166763,33.915997,-120.134781,33.90263,-120.118507,33.89333,-120.108627,33.895073,-120.101646,33.904953,
-120.08828,33.909019,-120.048164,33.915417,-120.019676,33.934021,-120.00457,33.940411,-119.99469,33.942158,-119.966782,
33.941574,-119.969101,33.952042,-119.974922,33.956108,-119.978409,33.974712,-119.976662,33.98111,-119.980736,33.985176,
-120,33.98032,-120.02375,33.985176,-120.04351,33.997383,-120.048164,34.016567,-120.042351,34.027611,-120.042938,34.035751,
-120.052818,34.038074,-120.08828,34.020058,-120.108627,34.020638,-120.143501,34.026447,-120.158043,34.014244,-120.173149,
34.007847,-120.195824,34.005524,-120.229546,34.00959,-120.239426,34.007847,-120.248718,34.001453,-120.451462,34.02948,
-120.436462,34.029053,-120.426315,34.025387,-120.41832,34.027729,-120.41539,34.031624,-120.406815,34.031818,-120.35788,
34.013885,-120.348328,34.020123,-120.319283,34.01915,-120.294724,34.021683,-120.307388,34.027729,-120.315384,34.040009,
-120.330002,34.049171,-120.348915,34.047028,-120.357498,34.050144,-120.359642,34.05463,-120.354179,34.059891,-120.360809,
34.073734,-120.36763,34.076855,-120.367432,34.069252,-120.371338,34.064571,-120.395119,34.050144,-120.408768,34.052292,
-120.413055,34.055996,-120.427483,34.048195,-120.436836,34.038841,-120.440544,34.036888,-120.447571,34.037472,-120.451462,
34.02948,-123.724495,38.916698,-123.708305,38.909416,-123.663795,38.874611,-123.644363,38.842236,-123.603081,38.820381,
-123.579605,38.800957,-123.53244,38.768513,-123.532417,38.768497,-123.530769,38.759399,-123.523438,38.749401,-123.512924,
38.741718,-123.497566,38.738083,-123.483017,38.727173,-123.459579,38.717064,-123.452705,38.706959,-123.438148,38.693619,
-123.431686,38.6819,-123.408646,38.66209,-123.401779,38.649158,-123.370247,38.607124,-123.357315,38.597015,-123.348824,
38.596207,-123.341141,38.58651,-123.332657,38.563873,-123.309616,38.555786,-123.302742,38.546898,-123.276199,38.531998,
-123.248055,38.509037,-123.199173,38.491627,-123.18029,38.481998,-123.140663,38.456078,-123.128075,38.451263,-123.113258,
38.422009,-123.104736,38.417191,-123.098816,38.410156,-123.094742,38.399788,-123.095116,38.392754,-123.089188,38.39312,
-123.083633,38.38905,-123.076225,38.373123,-123.068817,38.363865,-123.066589,38.353497,-123.068817,38.331276,-123.071777,
38.324612,-123.076591,38.322762,-123.060295,38.299801,-123.053635,38.298687,-123.050674,38.302391,-123.051407,38.307575,
-123.045853,38.312019,-123.036598,38.313133,-123.02549,38.311279,-123.001617,38.295795,-122.985153,38.273102,-122.973907,
38.26318,-122.966629,38.25061,-122.971268,38.236725,-122.994408,38.240032,-122.964645,38.195717,-122.966629,38.183147,
-122.959351,38.1805,-122.951416,38.169254,-122.948112,38.149418,-122.961334,38.107082,-123.008301,38.00655,-123.019547,
38.000591,-123.023514,37.99398,-122.973251,37.991333,-122.980522,38.009853,-122.959351,38.027714,-122.940834,38.031021,
-122.925621,38.027714,-122.890572,38.027054,-122.8694,38.021759,-122.851547,38.014484,-122.818474,37.995964,-122.795319,
37.974796,-122.781433,37.947681,-122.764893,37.937096,-122.736458,37.925194,-122.729179,37.913948,-122.72654,37.903362,
-122.701401,37.89212,-122.692139,37.900715,-122.680229,37.90535,-122.665016,37.90601,-122.649811,37.902039,-122.629303,
37.887489,-122.625992,37.880211,-122.616074,37.875584,-122.600861,37.87426,-122.586967,37.861691,-122.557205,37.844498,
-122.526398,37.815201,-122.522507,37.824902,-122.512367,37.824554,-122.510803,37.824501,-122.509605,37.824036,-122.498703,
37.819801,-122.494766,37.822613,-122.491898,37.824661,-122.490295,37.825802,-122.476997,37.825802,-122.477501,37.830502,
-122.476997,37.830654,-122.471199,37.832401,-122.470352,37.836517,-122.478325,37.847488,-122.477333,37.856464,-122.456718,
37.864109,-122.450737,37.871426,-122.437111,37.879398,-122.43644,37.882061,-122.447746,37.894028,-122.460373,37.897018,
-122.467361,37.901344,-122.479324,37.916637,-122.499275,37.926277,-122.50293,37.935253,-122.496613,37.938576,-122.486641,
37.936581,-122.477997,37.941898,-122.484978,37.948883,-122.488968,37.96484,-122.474342,37.97448,-122.456055,37.979469,
-122.446083,37.984787,-122.455727,37.997089,-122.46537,38.003735,-122.494286,38.015373,-122.496941,38.021687,-122.498611,
38.029999,-122.495949,38.039639,-122.48764,38.064903,-122.482323,38.071556,-122.488304,38.104469,-122.487808,38.108936,
-122.487366,38.112923,-122.421486,38.127777,-122.409821,38.136593,-122.403458,38.147873,-122.401733,38.149067,-122.398232,
38.151489,-122.352402,38.136002,-122.310509,38.113392,-122.294502,38.1003,-122.268272,38.068577,-122.264854,38.060097,
-122.261833,38.052589,-122.26371,38.043564,-122.272736,38.039429,-122.287025,38.021755,-122.306198,38.0116,-122.315224,
38.011223,-122.326508,38.003704,-122.335915,38.002953,-122.366371,38.01273,-122.368248,38.007088,-122.361855,37.988663,
-122.367874,37.97776,-122.372009,37.975124,-122.382538,37.976257,-122.392311,37.962341,-122.398331,37.958958,-122.410362,
37.960083,-122.414505,37.963093,-122.428413,37.965347,-122.428413,37.960835,-122.408478,37.931881,-122.389679,37.921726,
-122.387421,37.91571,-122.388931,37.909321,-122.369751,37.90443,-122.36261,37.90443,-122.358849,37.908943,-122.349449,
37.90744,-122.328392,37.908569,-122.319359,37.90443,-122.311928,37.897423,-122.311905,37.8974,-122.297028,37.835888,
-122.300484,37.828487,-122.320709,37.812698,-122.33107,37.797409,-122.319229,37.779644,-122.274338,37.763363,-122.240288,
37.718468,-122.213158,37.699226,-122.193909,37.693802,-122.179611,37.686401,-122.165794,37.672092,-122.155434,37.651863,
-122.151489,37.627693,-122.145073,37.607956,-122.144089,37.580826,-122.110535,37.52951,-122.110535,37.510765,-122.117516,
37.508755,-122.130562,37.505001,-122.138763,37.507607,-122.154793,37.500523,-122.174545,37.509472,-122.191322,37.52177,
-122.195427,37.536682,-122.215927,37.541531,-122.243134,37.557186,-122.252831,37.567623,-122.262894,37.572472,-122.300171,
37.576199,-122.310242,37.579182,-122.313965,37.591106,-122.359444,37.591484,-122.363922,37.597446,-122.353477,37.615341,
-122.363167,37.619812,-122.379578,37.635098,-122.378456,37.6474,-122.374352,37.655228,-122.379578,37.677593,-122.387779,
37.685425,-122.391502,37.707813,-122.391602,37.708401,-122.380875,37.710056,-122.372581,37.718094,-122.362473,37.715759,
-122.356247,37.730015,-122.365318,37.732609,-122.378799,37.751793,-122.386063,37.791973,-122.397987,37.805969,-122.405502,
37.81089,-122.418983,37.811413,-122.463051,37.804672,-122.477303,37.810631,-122.485077,37.790417,-122.491302,37.788078,
-122.504524,37.788078,-122.514114,37.780823,-122.502487,37.707222,-122.492439,37.643528,-122.498611,37.605766,-122.504776,
37.597294,-122.511711,37.598061,-122.517105,37.594208,-122.519417,37.537952,-122.517876,37.524853,-122.498611,37.495567,
-122.491669,37.493256,-122.490128,37.496342,-122.481659,37.499424,-122.471642,37.500191,-122.450829,37.480156,-122.446205,
37.465515,-122.44313,37.433922,-122.430023,37.412346,-122.399971,37.350693,-122.408447,37.279797,-122.417603,37.240974,
-122.406609,37.220665,-122.40387,37.196167,-122.393867,37.181786,-122.385628,37.183361,-122.378441,37.181091,-122.365799,
37.172215,-122.35981,37.158573,-122.358902,37.149403,-122.341919,37.140453,-122.336143,37.134327,-122.338318,37.120953,
-122.336182,37.117706,-122.328499,37.112522,-122.31282,37.118214,-122.303207,37.115276,-122.292175,37.106895,-122.280602,
37.098099,-122.266998,37.080032,-122.221893,37.0252,-122.205101,37.014,-122.198601,37.012501,-122.152107,36.9762,-122.142105,
36.976501,-122.127899,36.966301,-122.104897,36.956001,-122.075203,36.9505,-122.025101,36.950298,-122.022301,36.9622,
-121.984589,36.960503,-121.972496,36.954498,-121.9506,36.9715,-121.938896,36.977402,-121.928001,36.977299,-121.904495,
36.9688,-121.879105,36.950199,-121.863998,36.934399,-121.808922,36.850853,-121.788094,36.805969,-121.804031,36.751228,
-121.804726,36.726284,-121.810272,36.699261,-121.817894,36.670849,-121.829674,36.645905,-121.847687,36.623035,-121.865013,
36.607101,-121.881638,36.600861,-121.889961,36.603638,-121.903816,36.62096,-121.928062,36.636894,-121.934303,36.636894,
-121.944695,36.615417,-121.956482,36.609871,-121.973106,36.582848,-121.970337,36.568989,-121.952316,36.560677,-121.945389,
36.565525,-121.937073,36.562752,-121.93222,36.558598,-121.928757,36.550282,-121.925293,36.528107,-121.928757,36.523254,
-121.953018,36.522564,-121.953018,36.516327,-121.943314,36.505932,-121.945389,36.489304,-121.929459,36.452579,-121.918365,
36.433872,-121.905197,36.354183,-121.892731,36.341019,-121.894806,36.312607,-121.901733,36.306374,-121.89827,36.301525,
-121.887184,36.301525,-121.880951,36.293209,-121.848381,36.273804,-121.827591,36.246086,-121.812355,36.234306,-121.790871,
36.232231,-121.713943,36.192139,-121.65464,36.140511,-121.628067,36.111374,-121.620903,36.09808,-121.617325,36.084278,
-121.604546,36.070477,-121.591766,36.063831,-121.590233,36.047985,-121.581032,36.040318,-121.571831,36.023449,-121.566208,
36.018845,-121.546272,36.018337,-121.509979,36.006069,-121.501801,35.99942,-121.484413,35.968746,-121.471634,35.913029,
-121.466019,35.909451,-121.464478,35.886955,-121.445053,35.870087,-121.414894,35.856285,-121.382179,35.819481,-121.35508,
35.802612,-121.348228,35.796112,-121.324966,35.77401,-121.324966,35.75605,-121.318985,35.745277,-121.311798,35.70816,
-121.287857,35.68182,-121.284264,35.665058,-121.248344,35.654285,-121.224403,35.650692,-121.206444,35.639915,-121.194466,
35.636326,-121.175308,35.638721,-121.160942,35.627945,-121.120239,35.580055,-121.10228,35.547729,-121.004105,35.459133,
-120.978958,35.456738,-120.949036,35.447159,-120.90593,35.448357,-120.90229,35.445171,-120.879593,35.423218,-120.867615,
35.399273,-120.864021,35.376526,-120.864021,35.342999,-120.866425,35.328632,-120.877197,35.2999,-120.892761,35.274757,
-120.897552,35.256798,-120.891563,35.242432,-120.872406,35.220879,-120.854446,35.205315,-120.800575,35.180172,-120.765846,
35.159821,-120.751488,35.157425,-120.751488,35.176579,-120.737122,35.180172,-120.717957,35.171791,-120.696419,35.168201,
-120.665283,35.15144,-120.649719,35.146652,-120.636131,35.126534,-120.631088,35.10952,-120.628662,35.071907,-120.630943,
35.044647,-120.638985,35.002094,-120.648796,34.974957,-120.664551,34.931347,-120.670227,34.901569,-120.656036,34.897316,
-120.637611,34.87746,-120.613503,34.863281,-120.607826,34.844845,-120.62059,34.795212,-120.637611,34.755508,-120.626266,
34.737072,-120.603577,34.710129,-120.600739,34.694527,-120.610664,34.663334,-120.641861,34.599518,-120.646118,34.576828,
-120.636192,34.559811,-120.614922,34.5513,-120.580887,34.555557,-120.553947,34.539955,-120.509979,34.522942,-120.491547,
34.490322,-120.475945,34.473309,-120.470268,34.447781,-120.451843,34.440693,-120.419228,34.450615,-120.334137,34.461964,
-120.220688,34.471889,-120.141281,34.471889,-120.090225,34.459129,-119.995216,34.456291,-119.973946,34.446365,-119.952675,
34.432182,-119.928566,34.433601,-119.87468,34.406654,-119.840637,34.40382,-119.836395,34.41375,-119.782501,34.415165,
-119.731445,34.395313,-119.704506,34.395313,-119.690331,34.402405,-119.677559,34.41375,-119.643532,34.415165,-119.612328,
34.419418,-119.579712,34.412327,-119.4757,34.373199,-119.470421,34.37624,-119.458557,34.373867,-119.441956,34.354885,
-119.422966,34.348557,-119.398438,34.33036,-119.388954,34.315331,-119.37075,34.318497,-119.351768,34.306629,-119.335953,
34.288437,-119.301933,34.27103,-119.292442,34.274197,-119.278992,34.267075,-119.264755,34.2299,-119.247353,34.196674,
-119.22995,34.166615,-119.214127,34.145256,-119.201469,34.142883,-119.183281,34.134972,-119.127907,34.100166,-119.109711,
34.093842,-119.099434,34.098583,-119.087563,34.097004,-119.051971,34.082764,-119.036934,34.082764,-119.003716,34.064571,
-118.99501,34.065361,-118.943748,34.04583,-118.935982,34.042866,-118.849792,34.032928,-118.81411,34.008209,-118.806465,
34.000065,-118.794334,34.006767,-118.786179,34.019539,-118.758705,34.02533,-118.743744,34.032112,-118.704323,34.029663,
-118.680466,34.031055,-118.647682,34.037502,-118.53923,34.037121,-118.5186,34.0275,-118.496506,34.009499,-118.4757,
33.987499,-118.441505,33.9403,-118.408295,33.876801,-118.401604,33.8615,-118.399002,33.843201,-118.390305,33.838402,
-118.390602,33.815399,-118.393997,33.803501,-118.404106,33.800201,-118.427505,33.7747,-118.410103,33.740616,-118.395294,
33.735115,-118.385559,33.740196,-118.378792,33.740616,-118.374138,33.736385,-118.359329,33.736385,-118.350861,33.727501,
-118.295425,33.707607,-118.292885,33.7038,-118.280617,33.707184,-118.271729,33.713955,-118.253952,33.739349,-118.245064,
33.747387,-118.235748,33.751198,-118.222214,33.752468,-118.180321,33.763046,-118.147308,33.757969,-118.132072,33.752468,
-118.116257,33.742897,-118.10009,33.733109,-118.088776,33.728779,-118.002258,33.655243,-117.940033,33.619972,-117.927055,
33.605663,-117.878807,33.592354,-117.839401,33.573502,-117.807701,33.551102,-117.783997,33.5415,-117.737907,33.494202,
-117.737297,33.488998,-117.732986,33.484978,-117.725601,33.483398,-117.714294,33.460499,-117.691002,33.4594,-117.682671,
33.461342,-117.644707,33.440701,-117.630798,33.4305,-117.607025,33.406288,-117.595627,33.387623,-117.595001,33.3866,
-117.571144,33.378109,-117.548477,33.365299,-117.499199,33.327847,-117.448936,33.271667,-117.354317,33.156353,-117.313904,
33.091305,-117.302078,33.056808,-117.277443,33.000629,-117.260689,32.939522,-117.251816,32.885315,-117.251816,32.866589,
-117.26181,32.852428,-117.278427,32.849831,-117.281387,32.834061,-117.278427,32.821251,-117.25576,32.792667,-117.2528,
32.755215,-117.256744,32.714806,-117.245903,32.666508,-117.241959,32.664539,-117.235054,32.668484,-117.230225,32.677952,
-117.218689,32.686897,-117.199661,32.689896,-117.18261,32.683914,-117.16526,32.669594,-117.140442,32.629059,-117.134529,
32.614277,-117.133545,32.56105,-117.128761,32.554695,-117.124184,32.534878,-117.044525,32.540909,-117.041107,32.541199,
-117.039993,32.541248,-117.035583,32.54158,-116.860207,32.556618,-116.105339,32.61853,-114.718849,32.718716,-114.713737,
32.730343,-114.70079,32.745586,-114.687737,32.737545,-114.616875,32.728168,-114.614799,32.728401,-114.614304,32.734463,
-114.581001,32.734901,-114.580956,32.742275,-114.563728,32.742252,-114.563667,32.749508,-114.538437,32.749767,-114.538315,
32.756905,-114.52607,32.75705,-114.531647,32.776878,-114.528847,32.795433,-114.50943,32.816376,-114.493408,32.823189,
-114.468193,32.845112,-114.462112,32.905758,-114.463196,32.912399,-114.475853,32.923588,-114.480003,32.93364,-114.479439,
32.937889,-114.467278,32.955219,-114.467827,32.971611,-114.475754,32.975136,-114.487839,32.969906,-114.492157,32.971741,
-114.50045,33.007519,-114.507179,33.019669,-114.515671,33.027576,-114.530296,33.032356,-114.570869,33.036587,-114.577507,
33.035336,-114.583977,33.028191,-114.588989,33.026192,-114.617996,33.027164,-114.627502,33.031013,-114.638771,33.045254,
-114.645195,33.048862,-114.657043,33.033787,-114.66153,33.032631,-114.672874,33.041859,-114.673508,33.057133,-114.686203,
33.07093,-114.688232,33.084,-114.703934,33.087013,-114.707031,33.091064,-114.705383,33.105297,-114.696037,33.131172,
-114.686287,33.142159,-114.678566,33.159485,-114.679459,33.169682,-114.674568,33.185455,-114.677963,33.203415,-114.672836,
33.223087,-114.688751,33.246395,-114.671295,33.258465,-114.679718,33.273544,-114.693657,33.279755,-114.720879,33.286949,
-114.730431,33.302402,-114.722832,33.312077,-114.707169,33.323391,-114.700142,33.336983,-114.69725,33.352413,-114.698265,
33.361118,-114.706558,33.376598,-114.70652,33.382511,-114.724747,33.404026,-114.719269,33.407864,-114.700943,33.40836,
-114.694862,33.415096,-114.687157,33.417915,-114.673111,33.41827,-114.657593,33.41301,-114.64875,33.413605,-114.634392,
33.422699,-114.626335,33.433525,-114.621498,33.447529,-114.622131,33.456535,-114.600914,33.481369,-114.591583,33.49865,
-114.579681,33.506439,-114.568741,33.509193,-114.560173,33.516712,-114.558113,33.531796,-114.523819,33.552204,-114.536003,
33.570934,-114.539513,33.580593,-114.539833,33.591389,-114.528397,33.606628,-114.521057,33.612518,-114.530426,33.623886,
-114.530251,33.628189,-114.525581,33.630238,-114.523018,33.634678,-114.53241,33.651634,-114.529793,33.654442,-114.517555,
33.655903,-114.513275,33.660156,-114.52948,33.666801,-114.530739,33.675087,-114.52317,33.685856,-114.494926,33.698433,
-114.493408,33.707901,-114.495773,33.719135,-114.511559,33.734192,-114.503693,33.75098,-114.504074,33.760445,-114.527267,
33.814945,-114.521927,33.818958,-114.51918,33.825363,-114.529816,33.855419,-114.524879,33.859985,-114.513885,33.85862,
-114.502625,33.866432,-114.503006,33.876053,-114.521973,33.892563,-114.525078,33.900215,-114.523499,33.901569,-114.512924,
33.897942,-114.507919,33.900623,-114.507126,33.90379,-114.510719,33.911076,-114.517647,33.9175,-114.532906,33.925076,
-114.534691,33.934635,-114.522339,33.954647,-114.515076,33.958088,-114.507881,33.957508,-114.4991,33.961773,-114.46714,
33.992859,-114.45784,33.995541,-114.458397,34,-114.466522,34.005177,-114.46508,34.010971,-114.449417,34.012562,-114.437477,
34.022591,-114.434158,34.037769,-114.438553,34.057877,-114.434639,34.079712,-114.432594,34.088394,-114.419708,34.103451,
-114.410896,34.110016,-114.400818,34.111637,-114.389778,34.110069,-114.378448,34.115971,-114.365738,34.118561,-114.352249,
34.133102,-114.335327,34.134022,-114.319992,34.138618,-114.286514,34.170517,-114.274483,34.172134,-114.267677,34.170162,
-114.256248,34.172825,-114.239929,34.183216,-114.228935,34.186913,-114.224159,34.193878,-114.224419,34.203629,-114.210976,
34.211525,-114.177269,34.239956,-114.173813,34.247288,-114.165344,34.25,-114.163086,34.253338,-114.163864,34.259686,
-114.132484,34.25845,-114.130432,34.262714,-114.135887,34.274364,-114.137505,34.303215,-114.156425,34.317848,-114.168022,
34.3395,-114.176125,34.349293,-114.198692,34.361359,-114.225327,34.365906,-114.23349,34.376648,-114.262131,34.40036,
-114.286018,34.405327,-114.290367,34.409771,-114.29261,34.41951,-114.300232,34.426796,-114.325928,34.437843,-114.330978,
34.44664,-114.336685,34.450905,-114.372925,34.446926,-114.38591,34.457901,-114.380913,34.476028,-114.381569,34.495747,
-114.377335,34.507275,-114.380051,34.529713,-114.404442,34.56963,-114.421593,34.5807,-114.436012,34.596066,-114.424545,
34.600834,-114.423409,34.610443,-114.437943,34.621449,-114.440674,34.642525,-114.457191,34.657104,-114.449715,34.666828,
-114.464455,34.691196,-114.470192,34.712208,-114.48671,34.716621,-114.491226,34.725697,-114.515823,34.73674,-114.528824,
34.750816,-114.551888,34.766869,-114.570213,34.794289,-114.575653,34.815296,-114.586044,34.835667,-114.599854,34.847355,
-114.623146,34.859737,-114.632256,34.869968,-114.635925,34.889103,-114.630081,34.907261,-114.632454,34.924606,-114.628967,
34.943039,-114.634438,34.965149,-114.62822,34.986149,-114.632217,35.002083,-115.646362,35.809021,-115.897507,36.004211,
-117.165108,36.971176,-117.831802,37.465,-118.427193,37.89629,-119.155991,38.414833,-119.327408,38.534882,-119.434067,
38.609127,-119.449615,38.620056,-119.584435,38.713306,-119.903305,38.933414,-120,38.999668,-120.00145,39.067585,-120.002411,
39.112782,-120.003441,39.165684,-120.004295,39.316444,-120.00209,39.445206,-120.00029,39.722511,-119.996246,40,-119.994888,
40.5,-119.998817,41.184078,-119.998116,41.994652,-120.293373,41.993053,-120.878403,41.9939,-121.03421,41.993443,-121.25,
41.997692,-121.446503,41.997303,-122.288399,42.0079,-122.377068,42.009655,-122.633598,42.005001,-122.892815,42.00275,
-123.044106,42.003201,-123.144798,42.009399,-123.229599,42.004002,-123.34639,41.999264,-123.433601,42.001801,-123.516739,
42.001015,-123.623375,42,-123.655823,41.9953,-123.726974,41.997173,-123.82029,41.99564,-124.210136,41.998016,-124.203751,
41.983608,-124.205978,41.958057,-124.209038,41.950851,-124.201988,41.935848,-124.207245,41.888355,-124.218399,41.846596,
-124.229477,41.818844,-124.243835,41.792465,-124.254799,41.78318,-124.247673,41.771385,-124.238121,41.769974,-124.212303,
41.751579,-124.199577,41.744865,-124.191803,41.750168,-124.170578,41.743095,-124.163155,41.739204,-124.153252,41.728947,
-124.143707,41.712685,-124.133446,41.656456,-124.124252,41.645493,-124.112587,41.616138,-124.100204,41.601997,-124.103745,
41.59457,-124.097023,41.586437,-124.100563,41.579365,-124.099495,41.571232,-124.091019,41.552841,-124.080048,41.546124,
-124.080048,41.513237,-124.064072,41.465057,-124.064018,41.464897,-124.062897,41.427952,-124.068031,41.395813,-124.094467,
41.276043,-124.121498,41.18988,-124.140266,41.14801,-124.160187,41.141788,-124.158936,41.069572,-124.147736,41.049652,
-124.129059,41.047165,-124.112869,41.028488,-124.11412,41.004833,-124.14151,40.913944,-124.16143,40.867874,-124.193802,
40.815582,-124.31208,40.641277,-124.335739,40.600189,-124.370598,40.531712,-124.386787,40.508057,-124.407951,40.438335,
-124.388031,40.404716,-124.370598,40.392269,-124.348183,40.313828,-124.35939,40.281456,-124.361877,40.256557,-124.318306,
40.222939,-124.226173,40.166912,-124.185089,40.129559,-124.137779,40.115864,-124.106651,40.098434,-124.08548,40.076023,
-124.078011,40.062328,-124.079254,40.02747,-124.069298,40.018753,-124.05809,40.022488,-124.040665,40.017509,-124.02359,
40.002712,-124.022087,40.001411,-123.97422,39.954361,-123.952393,39.921028,-123.928253,39.908386,-123.903542,39.859543,
-123.884583,39.846325,-123.85183,39.833107,-123.846657,39.82449,-123.836891,39.77507,-123.837463,39.750935,-123.82885,
39.721058,-123.809303,39.711285,-123.793793,39.690601,-123.781151,39.610725,-123.786896,39.605553,-123.785744,39.596355,
-123.765633,39.556709,-123.775398,39.522804,-123.803009,39.478424,-123.814339,39.448475,-123.820816,39.407196,-123.820816,
39.375629,-123.824051,39.349728,-123.796532,39.270409,-123.778717,39.233177,-123.769005,39.194324,-123.735016,39.156284,
-123.718018,39.125523,-123.690498,39.045395,-123.690498,39.019497,-123.701836,38.991165,-123.717209,38.966885,-123.730965,
38.953934,-123.741486,38.954742,-123.730164,38.937744,-123.724495,38.916698));


INSERT_DEMO_STATES(
'California','CA','06',29760016,12.6992,155946.375,190.8347,14878464,2188142,150535,24807312,2416266,
735442,29024576,49.9948,2.4711,20555648,2198766,2847834,248929,7557548,69.0625,7.3876,
9.5683,0.8364,25.3945,7.9853,7.499,5.4169,5.1025,11.1718,19.2851,15.6132,9.9316,3.7944,3.7036,
6.2675,3.2524,0.9691,28.9765,35.8515,24.6718,10.4882,2376474,2231942,1612344,1518718,3325042,
5739292,4646812,2955980,1129239,1102312,1865417,967997,288445,8623768,10671240,7343148,3121858,
7739476,13711144,5187532,31.6637,10399696,2.7909,835690,2416266,3219778,3251930,1511724,23.2304,
30.957,31.2656,14.5351,7218876,5603624,2752644,1161674,661698,3180822,69.4062,77.6093,38.125,16.0898,
9.166,30.582,1197503,771755,1576520,1530233,1888147,1909072,792419,734051,11.5136,7.4208,15.1582,14.7128,
18.1523,18.3554,7.6191,7.0576,18.9335,34.0937,48.8046,66.9531,85.3125,92.9375,35798,46246,
geom);
COMMIT;
      
END;
/


DECLARE
geom MDSYS.SDO_GEOMETRY;
BEGIN


geom := 
MDSYS.SDO_GEOMETRY(2007,8265,null,
MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,321,1003,1,409,1003,1,563,1003,1,609,1003,1,647,1003,1,727,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-80.831322,24.813154,-80.851379,24.803854,-80.851006,24.801849,-80.822929,24.811878,-80.797226,
24.810783,-80.787743,24.821905,-80.740883,24.84725,-80.734863,24.848162,-80.728661,24.855453,-80.703133,24.867853,-80.690376,
24.880981,-80.643517,24.906691,-80.610878,24.938051,-80.59848,24.946074,-80.566208,24.956203,-80.564201,24.961018,-80.551964,
24.971251,-80.549149,24.977068,-80.530296,24.997932,-80.517456,25.001944,-80.514847,25.008764,-80.494186,25.023411,-80.489365,
25.029831,-80.491577,25.038456,-80.469315,25.063532,-80.462486,25.068348,-80.443634,25.075169,-80.43119,25.08901,-80.418755,
25.09824,-80.406448,25.103733,-80.377365,25.129807,-80.372856,25.136576,-80.371101,25.145098,-80.366333,25.151115,-80.358315,
25.15287,-80.352051,25.163902,-80.350296,25.168665,-80.353554,25.180948,-80.350792,25.188971,-80.343529,25.194487,-80.339516,
25.20702,-80.33049,25.216549,-80.322212,25.233847,-80.317703,25.235849,-80.314697,25.240864,-80.30793,25.25691,-80.283104,
25.291004,-80.272072,25.316324,-80.259544,25.324598,-80.250542,25.341444,-80.249763,25.342897,-80.240242,25.348162,-80.239487,
25.358942,-80.222687,25.395794,-80.206062,25.41086,-80.18985,25.454458,-80.189598,25.460726,-80.176811,25.483538,-80.177818,
25.50234,-80.175812,25.517633,-80.177559,25.518887,-80.180824,25.511366,-80.190598,25.501337,-80.18985,25.495571,-80.183327,
25.49131,-80.183327,25.48805,-80.18985,25.479277,-80.20639,25.432144,-80.212662,25.427382,-80.210152,25.415348,-80.22094,
25.406574,-80.242989,25.399303,-80.250015,25.394793,-80.256279,25.381254,-80.259544,25.358191,-80.265045,25.353647,-80.275337,
25.345154,-80.278099,25.334373,-80.290375,25.323343,-80.29113,25.314819,-80.304665,25.305294,-80.307426,25.30028,-80.328987,
25.28624,-80.334755,25.28624,-80.340515,25.291004,-80.351051,25.28624,-80.364586,25.285488,-80.366837,25.283232,-80.366837,
25.281225,-80.360565,25.278217,-80.345528,25.273956,-80.340767,25.263927,-80.332237,25.259666,-80.336502,25.235849,-80.340767,
25.225824,-80.351799,25.211283,-80.357315,25.207771,-80.372856,25.204763,-80.393417,25.19198,-80.386177,25.186142,-80.388649,
25.16741,-80.397423,25.147104,-80.403442,25.140085,-80.41246,25.138832,-80.425323,25.144432,-80.433029,25.144667,-80.448448,
25.152142,-80.449615,25.147001,-80.441673,25.138826,-80.440742,25.132984,-80.450554,25.125977,-80.447044,25.121304,-80.443077,
25.121304,-80.434196,25.111025,-80.446815,25.0921,-80.453354,25.089998,-80.460129,25.092567,-80.467606,25.091166,-80.461769,
25.084156,-80.461998,25.07855,-80.487938,25.052851,-80.497513,25.04701,-80.506859,25.032059,-80.51503,25.030188,-80.515739,
25.017805,-80.519005,25.015703,-80.526711,25.017105,-80.546577,25.014069,-80.544243,25.002853,-80.553352,24.985098,-80.570168,
24.964539,-80.576012,24.962904,-80.583488,24.966408,-80.589912,24.964491,-80.595741,24.967588,-80.59848,24.964491,-80.599396,
24.950632,-80.605225,24.949537,-80.610329,24.952089,-80.614159,24.944981,-80.622185,24.944069,-80.62455,24.939327,-80.622002,
24.93714,-80.622185,24.933493,-80.642609,24.914528,-80.661385,24.90432,-80.661926,24.899944,-80.689835,24.885174,-80.696938,
24.884809,-80.704964,24.879704,-80.705872,24.87314,-80.716629,24.865849,-80.732857,24.864937,-80.750183,24.845608,-80.766953,
24.837585,-80.787376,24.841963,-80.799049,24.839045,-80.810165,24.83321,-80.819649,24.823729,-80.831322,24.813154,-81.097359,
24.712847,-81.125778,24.708014,-81.124313,24.704205,-81.115959,24.698639,-81.107605,24.687654,-81.089447,24.691168,-81.074944,
24.690144,-81.078316,24.695415,-81.077286,24.699518,-81.072014,24.709332,-81.067329,24.712847,-81.039932,24.724419,-81.032318,
24.722954,-81.023537,24.716215,-80.974907,24.741432,-80.972878,24.745899,-80.945061,24.763197,-80.912201,24.764347,-80.906731,
24.768528,-80.903275,24.779627,-80.883804,24.787554,-80.885536,24.792887,-80.931808,24.775015,-80.936562,24.775446,-80.94593,
24.769827,-80.954575,24.769247,-80.977348,24.755844,-80.981819,24.755844,-80.988594,24.75988,-80.989601,24.750656,-80.995079,
24.748062,-80.997528,24.743017,-81.010361,24.739702,-81.023239,24.734232,-81.036125,24.742289,-81.042435,24.742582,-81.050774,
24.7376,-81.054146,24.731743,-81.05957,24.730129,-81.069824,24.722075,-81.074219,24.721342,-81.077881,24.723686,-81.082275,
24.717974,-81.097359,24.712847,-81.812027,24.55508,-81.812386,24.544102,-81.788086,24.545902,-81.777328,24.549494,-81.686867,
24.557819,-81.656525,24.572636,-81.631828,24.576868,-81.602211,24.58604,-81.562698,24.606499,-81.519661,24.617081,-81.510498,
24.626251,-81.507675,24.647413,-81.50132,24.656588,-81.490746,24.658705,-81.444176,24.656588,-81.4216,24.643888,-81.394089,
24.619198,-81.381393,24.622021,-81.365166,24.62978,-81.33342,24.637541,-81.266403,24.658705,-81.243118,24.668579,-81.240997,
24.676342,-81.258636,24.675636,-81.277687,24.66717,-81.293205,24.668579,-81.310135,24.677046,-81.315781,24.694683,-81.322838,
24.70315,-81.341881,24.707382,-81.358109,24.708088,-81.376457,24.721493,-81.394791,24.744772,-81.40255,24.730661,-81.399734,
24.708794,-81.409607,24.705973,-81.426544,24.715141,-81.437836,24.734896,-81.451935,24.746887,-81.45829,24.737719,-81.457581,
24.717964,-81.460411,24.706676,-81.470284,24.706676,-81.480164,24.715849,-81.490028,24.715849,-81.494972,24.706676,-81.518257,
24.701033,-81.529541,24.68128,-81.542236,24.68128,-81.55423,24.691862,-81.563408,24.692568,-81.573982,24.675636,-81.591621,
24.65941,-81.614197,24.650238,-81.614197,24.641771,-81.625488,24.633307,-81.633949,24.622021,-81.648064,24.616377,-81.66217,
24.614258,-81.673454,24.605087,-81.710144,24.595209,-81.722839,24.584627,-81.732719,24.585335,-81.740479,24.588861,-81.747536,
24.58604,-81.754593,24.579691,-81.763443,24.577753,-81.76667,24.583511,-81.774773,24.584593,-81.781967,24.576855,-81.789711,
24.574333,-81.793846,24.577934,-81.79493,24.590891,-81.797623,24.594311,-81.799606,24.592871,-81.804764,24.56793,-81.812027,
24.55508,-82.202301,26.551708,-82.180901,26.475901,-82.173103,26.4673,-82.148903,26.455097,-82.126854,26.435921,-82.098305,
26.424601,-82.075203,26.421698,-82.056,26.428301,-82.014107,26.4517,-82.0168,26.453699,-82.031601,26.452099,-82.060768,
26.468779,-82.076042,26.465912,-82.088448,26.454775,-82.09227,26.455412,-82.10659,26.466232,-82.129494,26.477688,-82.14859,
26.478006,-82.160049,26.484053,-82.175957,26.50028,-82.195045,26.550554,-82.19899,26.55294,-82.202301,26.551708,-82.836487,
28.071817,-82.826523,28.056314,-82.821426,28.044859,-82.827965,28.018867,-82.829376,27.995678,-82.830124,27.967978,-82.81987,
27.964975,-82.815857,27.974806,-82.81131,27.973991,-82.809723,27.982403,-82.823242,28.003275,-82.820999,28.01062,-82.816338,
28.012253,-82.814339,28.035612,-82.818344,28.055786,-82.828766,28.070118,-82.826897,28.085623,-82.833687,28.086224,-82.836487,
28.071817,-85.220474,29.679995,-85.219376,29.676712,-85.184738,29.663221,-85.155937,29.645357,-85.141724,29.633692,-85.12458,
29.627857,-85.097168,29.625,-85.062813,29.600828,-85.050781,29.586575,-85.04229,29.587511,-84.957458,29.61249,-84.873581,
29.65687,-84.799225,29.681351,-84.775543,29.69289,-84.719681,29.737711,-84.69445,29.76306,-84.694832,29.769474,-84.699455,
29.768551,-84.719803,29.745434,-84.792847,29.69643,-84.819199,29.683949,-84.874207,29.66823,-84.911659,29.649736,-84.922752,
29.648811,-84.931999,29.637718,-84.968056,29.617376,-84.98748,29.609978,-85.018448,29.604429,-85.024002,29.600733,-85.049423,
29.603045,-85.076241,29.617376,-85.092865,29.632599,-85.093231,29.643536,-85.075729,29.672703,-85.090309,29.681816,-85.105263,
29.686922,-85.12458,29.688379,-85.144272,29.682911,-85.197136,29.682547,-85.220474,29.679995,-87.634949,30.865702,-87.625999,
30.856508,-87.627335,30.847776,-87.617294,30.840168,-87.6157,30.834278,-87.604675,30.83128,-87.600502,30.82044,-87.581886,
30.812216,-87.57206,30.800346,-87.568291,30.79991,-87.559502,30.79026,-87.552063,30.786066,-87.550713,30.781342,-87.545067,
30.778479,-87.546173,30.771832,-87.537102,30.762342,-87.535385,30.749586,-87.529999,30.740709,-87.510925,30.732796,-87.501511,
30.720987,-87.492279,30.720119,-87.483681,30.715403,-87.481674,30.717375,-87.477974,30.713318,-87.479439,30.709833,-87.475166,
30.708941,-87.475349,30.705069,-87.469971,30.704723,-87.468033,30.700142,-87.4636,30.700533,-87.45768,30.696568,-87.451424,
30.699615,-87.440399,30.690685,-87.430389,30.688456,-87.426476,30.683092,-87.418968,30.678553,-87.406982,30.674974,-87.403328,
30.657532,-87.398003,30.655191,-87.394852,30.645496,-87.39505,30.615089,-87.398941,30.605762,-87.407745,30.601042,-87.40554,
30.598682,-87.40876,30.583508,-87.412781,30.576405,-87.411964,30.574387,-87.410172,30.575121,-87.410896,30.573181,-87.416283,
30.572256,-87.418671,30.561644,-87.426056,30.559879,-87.42791,30.553967,-87.435463,30.548946,-87.4366,30.540855,-87.440361,
30.540054,-87.441795,30.536798,-87.43959,30.53022,-87.444221,30.531549,-87.442902,30.5299,-87.446609,30.526875,-87.444099,
30.524099,-87.447479,30.522015,-87.445786,30.517132,-87.447342,30.514587,-87.445198,30.513786,-87.449944,30.514496,-87.444733,
30.507299,-87.439713,30.506454,-87.431,30.4981,-87.431702,30.492701,-87.428398,30.4883,-87.433907,30.487499,-87.432907,
30.4841,-87.4356,30.480301,-87.430603,30.4764,-87.429604,30.4704,-87.424301,30.464701,-87.414703,30.4571,-87.407906,
30.4562,-87.399902,30.4508,-87.379997,30.449699,-87.368706,30.444433,-87.367462,30.434298,-87.384377,30.421415,-87.395706,
30.4174,-87.4048,30.409401,-87.422707,30.409901,-87.429604,30.4063,-87.434303,30.397301,-87.440704,30.3913,-87.438705,
30.3806,-87.451401,30.367001,-87.451103,30.3454,-87.461105,30.3351,-87.471901,30.3316,-87.493599,30.3304,-87.502594,
30.327206,-87.505959,30.319197,-87.505798,30.3123,-87.503906,30.3078,-87.5,30.306,-87.483704,30.3046,-87.475906,
30.307699,-87.462997,30.3076,-87.450104,30.3109,-87.4524,30.299999,-87.518402,30.283701,-87.518402,30.280224,-87.518341,
30.280233,-87.419884,30.296926,-87.329987,30.315968,-87.251999,30.316065,-87.181152,30.324156,-86.869904,30.378231,-86.850609,
30.380384,-86.799461,30.38608,-86.748482,30.391731,-86.680305,30.395317,-86.633003,30.396099,-86.523216,30.38678,-86.506676,
30.38208,-86.464081,30.383638,-86.397377,30.378443,-86.396263,30.378279,-86.321594,30.367205,-86.230148,30.345585,-86.072571,
30.297363,-85.996368,30.269203,-85.995796,30.26899,-85.922661,30.237823,-85.829094,30.188431,-85.786446,30.163263,-85.755836,
30.141159,-85.729805,30.116598,-85.711754,30.10441,-85.645401,30.073715,-85.621025,30.0683,-85.617867,30.064238,-85.598915,
30.055662,-85.586273,30.046635,-85.580856,30.035801,-85.548355,30.001495,-85.51992,29.977573,-85.493286,29.962679,-85.469818,
29.95681,-85.459885,29.958164,-85.424225,29.948687,-85.397141,29.932436,-85.388962,29.924164,-85.363815,29.898708,-85.354309,
29.884686,-85.336739,29.849089,-85.332375,29.845695,-85.325089,29.844757,-85.317543,29.838686,-85.311501,29.814165,-85.302673,
29.807886,-85.303284,29.776375,-85.306152,29.758148,-85.305199,29.724697,-85.30854,29.702719,-85.318336,29.690535,-85.348206,
29.685755,-85.357048,29.687426,-85.375923,29.708214,-85.380699,29.717293,-85.404594,29.790401,-85.406975,29.805695,-85.406021,
29.829586,-85.397186,29.861362,-85.391144,29.872892,-85.405899,29.86561,-85.412415,29.856377,-85.41571,29.846636,-85.417603,
29.835981,-85.415169,29.804996,-85.397949,29.740288,-85.37281,29.685463,-85.35511,29.662231,-85.344849,29.654579,-85.345337,
29.669987,-85.330048,29.67811,-85.304237,29.683126,-85.287041,29.683603,-85.258026,29.67963,-85.24453,29.686556,-85.219734,
29.693483,-85.217178,29.694036,-85.107445,29.717793,-85.083672,29.718952,-85.022774,29.712572,-84.991463,29.715471,-84.980446,
29.721851,-84.902733,29.73403,-84.892883,29.722431,-84.885918,29.723013,-84.885338,29.729971,-84.880699,29.73461,-84.864464,
29.743307,-84.807632,29.765345,-84.776894,29.780422,-84.688751,29.829714,-84.660912,29.840155,-84.63929,29.851749,-84.59613,
29.880041,-84.574554,29.888193,-84.540024,29.907373,-84.513176,29.915525,-84.503586,29.915525,-84.491592,29.910732,-84.473373,
29.92272,-84.463783,29.926077,-84.449402,29.92272,-84.44268,29.91217,-84.433098,29.904978,-84.425423,29.90258,-84.406242,
29.901621,-84.377945,29.89299,-84.34726,29.896826,-84.341507,29.901142,-84.335274,29.91217,-84.333351,29.923677,-84.335754,
29.937105,-84.340065,29.945257,-84.340065,29.960348,-84.340065,29.976906,-84.355927,29.990993,-84.361603,30.00078,-84.365723,
30.023445,-84.356956,30.058474,-84.334297,30.070322,-84.31369,30.068775,-84.302872,30.064655,-84.296173,30.057959,-84.283813,
30.056414,-84.275055,30.060534,-84.271454,30.068262,-84.273514,30.090925,-84.269394,30.099169,-84.262695,30.103291,-84.253937,
30.103804,-84.246208,30.101231,-84.245697,30.094019,-84.235909,30.08423,-84.202942,30.082684,-84.183884,30.077534,-84.176674,
30.071869,-84.166367,30.069805,-84.155556,30.072382,-84.123619,30.090927,-84.081886,30.092472,-84.075592,30.09457,-84.058701,
30.100201,-84.04377,30.101744,-84.019562,30.101231,-84.011322,30.097624,-84.001015,30.096594,-83.991798,30.088089,-83.974236,
30.071869,-83.95311,30.061565,-83.927353,30.036324,-83.915504,30.032719,-83.878418,30.013144,-83.856262,30.004387,-83.835663,
29.988934,-83.821243,29.982237,-83.807327,29.978115,-83.78466,29.977085,-83.773849,29.973995,-83.759911,29.964579,-83.749123,
29.959572,-83.729538,29.942595,-83.680481,29.917614,-83.668213,29.90626,-83.638695,29.885366,-83.620987,29.84767,-83.593735,
29.819054,-83.586464,29.814058,-83.58329,29.779085,-83.577385,29.768641,-83.564667,29.759556,-83.559219,29.745022,-83.551941,
29.735029,-83.53923,29.725039,-83.525833,29.718678,-83.509933,29.71232,-83.501305,29.713909,-83.496758,29.712093,-83.479507,
29.687794,-83.460197,29.6803,-83.455887,29.675758,-83.43045,29.676666,-83.415497,29.665344,-83.413651,29.663948,-83.405693,
29.652594,-83.404106,29.641693,-83.402519,29.628748,-83.406609,29.621254,-83.401382,29.614443,-83.400703,29.602406,-83.407509,
29.588099,-83.402977,29.565163,-83.404106,29.542681,-83.394569,29.515882,-83.387306,29.513384,-83.370499,29.499758,-83.360283,
29.499987,-83.353699,29.494989,-83.350288,29.488857,-83.34166,29.486814,-83.33075,29.475006,-83.321671,29.476139,-83.315086,
29.47296,-83.296684,29.443892,-83.289421,29.437534,-83.271255,29.430494,-83.249001,29.43322,-83.236282,29.430721,-83.229019,
29.422318,-83.217667,29.419594,-83.20903,29.397566,-83.203354,29.393703,-83.200401,29.373039,-83.189507,29.363047,-83.182236,
29.348059,-83.173836,29.346468,-83.169518,29.341019,-83.164299,29.323986,-83.150673,29.328527,-83.124229,29.321783,-83.120804,
29.317385,-83.119026,29.315104,-83.108475,29.271318,-83.094391,29.26586,-83.082039,29.264137,-83.074577,29.24403,-83.069122,
29.239433,-83.068253,29.234552,-83.069122,29.23053,-83.073715,29.229094,-83.078316,29.221052,-83.069687,29.213297,-83.070549,
29.191465,-83.053322,29.174232,-83.023735,29.166763,-83.015976,29.167625,-83.001328,29.175669,-82.987541,29.177677,-82.980072,
29.170498,-82.947327,29.167337,-82.91861,29.167912,-82.876381,29.160444,-82.847366,29.163031,-82.835304,29.153837,-82.820366,
29.159582,-82.812042,29.157284,-82.808304,29.153837,-82.805145,29.14838,-82.806587,29.127413,-82.799973,29.107592,-82.801987,
29.094091,-82.812904,29.084614,-82.816353,29.079729,-82.815773,29.07571,-82.785042,29.075422,-82.781593,29.07255,-82.782166,
29.062784,-82.760338,29.056463,-82.757462,29.051582,-82.758331,29.035496,-82.752296,29.026304,-82.754303,29.015102,-82.76178,
28.99758,-82.75753,28.99435,-82.756531,28.993591,-82.751312,28.993158,-82.740005,28.996418,-82.73587,28.99555,-82.733917,
28.992941,-82.735657,28.978807,-82.733917,28.972939,-82.724571,28.963154,-82.723923,28.953806,-82.712395,28.949457,-82.710655,
28.935978,-82.697609,28.93228,-82.695435,28.926628,-82.699783,28.918585,-82.689568,28.905104,-82.668694,28.901627,-82.660431,
28.903364,-82.653915,28.90206,-82.647171,28.892059,-82.637161,28.883656,-82.642609,28.865269,-82.638039,28.85541,-82.638336,
28.846144,-82.639664,28.842611,-82.654083,28.830109,-82.646431,28.819075,-82.644661,28.795094,-82.641281,28.793182,-82.638931,
28.784355,-82.646873,28.777294,-82.641869,28.761112,-82.645844,28.755226,-82.649666,28.741253,-82.660851,28.73875,-82.661285,
28.736837,-82.648491,28.722126,-82.647308,28.715212,-82.649223,28.707268,-82.637138,28.69684,-82.638695,28.694338,-82.64019,
28.691938,-82.641273,28.68774,-82.646439,28.683397,-82.646439,28.676161,-82.654091,28.67037,-82.651398,28.665199,-82.650162,
28.651552,-82.652641,28.645967,-82.661331,28.637695,-82.654922,28.623634,-82.654922,28.617844,-82.659676,28.610605,-82.658012,
28.601505,-82.650787,28.588062,-82.649132,28.578758,-82.654076,28.535728,-82.672775,28.501312,-82.667168,28.488222,-82.669785,
28.47139,-82.685493,28.464657,-82.683624,28.45755,-82.670158,28.457174,-82.667168,28.451191,-82.673874,28.433416,-82.674644,
28.431366,-82.688858,28.421263,-82.694099,28.422384,-82.697464,28.419395,-82.700829,28.404058,-82.707001,28.390966,-82.704567,
28.374134,-82.711487,28.360668,-82.717667,28.360668,-82.718979,28.341215,-82.732437,28.321953,-82.736176,28.305305,-82.732819,
28.286604,-82.743469,28.278563,-82.743469,28.267714,-82.750587,28.254248,-82.750015,28.250132,-82.754883,28.240406,-82.752823,
28.237413,-82.75563,28.228624,-82.768723,28.209171,-82.771713,28.207115,-82.781998,28.207676,-82.784622,28.198698,-82.799026,
28.185232,-82.800896,28.17345,-82.800346,28.17223,-82.785126,28.138557,-82.782974,28.125616,-82.785126,28.114292,-82.782166,
28.100271,-82.783508,28.08005,-82.78109,28.076546,-82.781898,28.070074,-82.785942,28.064953,-82.784866,28.053898,-82.791603,
28.033136,-82.793762,28.004826,-82.80751,27.954138,-82.816719,27.935127,-82.824142,27.922585,-82.827194,27.913616,-82.832176,
27.908089,-82.842224,27.90885,-82.840759,27.918262,-82.833916,27.941023,-82.825127,27.960344,-82.832497,27.962492,-82.8358,
27.950113,-82.841972,27.933418,-82.847778,27.912004,-82.851234,27.889801,-82.851837,27.873577,-82.849358,27.863411,-82.849304,
27.8629,-82.844482,27.847565,-82.837906,27.8363,-82.827919,27.820959,-82.787598,27.788401,-82.783905,27.780178,-82.770157,
27.767118,-82.761559,27.745119,-82.753998,27.73584,-82.746613,27.730856,-82.742996,27.724669,-82.739044,27.709373,-82.73848,
27.657566,-82.740578,27.644806,-82.738739,27.635721,-82.737862,27.631351,-82.736382,27.624048,-82.736954,27.61548,-82.731819,
27.614717,-82.707626,27.623478,-82.716225,27.666967,-82.714943,27.687031,-82.706833,27.693859,-82.69574,27.698982,-82.668846,
27.702824,-82.651779,27.699409,-82.641106,27.702398,-82.632561,27.710934,-82.625732,27.726301,-82.624458,27.734838,-82.622742,
27.78606,-82.619331,27.789476,-82.61293,27.789476,-82.606094,27.792891,-82.605247,27.798866,-82.591583,27.815941,-82.566315,
27.825377,-82.55957,27.827892,-82.52372,27.833014,-82.492126,27.822344,-82.472923,27.821489,-82.460541,27.816368,-82.446877,
27.806122,-82.438347,27.793743,-82.434929,27.77667,-82.436638,27.76984,-82.443893,27.759596,-82.476784,27.747068,-82.482452,
27.742393,-82.478119,27.732044,-82.479118,27.726034,-82.483795,27.720692,-82.493141,27.719357,-82.512505,27.707336,-82.555374,
27.644558,-82.564255,27.631546,-82.564926,27.619526,-82.569939,27.611177,-82.582962,27.596823,-82.588295,27.593817,-82.596313,
27.593817,-82.609001,27.581797,-82.612007,27.571779,-82.627029,27.558758,-82.647064,27.533384,-82.662422,27.523033,-82.675774,
27.518692,-82.70816,27.523033,-82.742615,27.539047,-82.746521,27.537678,-82.744705,27.5331,-82.714272,27.500116,-82.6912,
27.444044,-82.692001,27.436899,-82.675301,27.424,-82.642998,27.3894,-82.642792,27.389099,-82.624039,27.361883,-82.592972,
27.330345,-82.588974,27.32152,-82.567596,27.297199,-82.563522,27.286484,-82.569939,27.279127,-82.569397,27.2759,-82.561104,
27.2687,-82.545143,27.26008,-82.539902,27.254,-82.512505,27.207199,-82.509789,27.206301,-82.497314,27.175119,-82.477203,
27.1409,-82.46907,27.113279,-82.465508,27.110399,-82.460503,27.0996,-82.445908,27.060301,-82.419403,27.020399,-82.400803,
26.9846,-82.375946,26.945484,-82.349838,26.904354,-82.326843,26.876497,-82.301125,26.839937,-82.289268,26.82744,-82.283806,
26.817234,-82.271904,26.78894,-82.269249,26.782633,-82.264862,26.754793,-82.264832,26.719036,-82.260345,26.716927,-82.257217,
26.735903,-82.249046,26.760405,-82.237465,26.784218,-82.237289,26.784578,-82.229767,26.789152,-82.220627,26.788826,-82.195145,
26.774124,-82.176849,26.772491,-82.171623,26.777718,-82.150711,26.782944,-82.148102,26.788172,-82.156593,26.852201,-82.175217,
26.903164,-82.174561,26.909698,-82.154312,26.924398,-82.138306,26.924398,-82.122299,26.946285,-82.114784,26.950859,-82.106613,
26.953472,-82.094528,26.953472,-82.089294,26.957066,-82.07917,26.9587,-82.064796,26.953472,-82.061211,26.949226,-82.057289,
26.936485,-82.059898,26.931257,-82.069046,26.926031,-82.085373,26.927011,-82.096817,26.916229,-82.091911,26.892384,-82.087334,
26.887484,-82.077538,26.883562,-82.06839,26.883562,-82.060883,26.879642,-82.053688,26.86919,-82.052711,26.858408,-82.05304,
26.842402,-82.055977,26.83358,-82.052711,26.818226,-82.054672,26.799606,-82.057938,26.792418,-82.062515,26.788826,-82.060913,
26.775517,-82.061882,26.770311,-82.067146,26.742161,-82.083275,26.709538,-82.087669,26.68498,-82.092064,26.675083,-82.092064,
26.666655,-82.096466,26.663721,-82.104156,26.665188,-82.124321,26.699276,-82.139793,26.704245,-82.166374,26.706211,-82.176224,
26.702766,-82.182625,26.696857,-82.185081,26.686028,-82.181145,26.679628,-82.168839,26.67569,-82.164894,26.666336,-82.15358,
26.658459,-82.145699,26.647629,-82.132896,26.614641,-82.111725,26.529966,-82.106316,26.516674,-82.102379,26.496489,-82.106812,
26.488611,-82.104836,26.48418,-82.093513,26.485167,-82.070862,26.49255,-82.044777,26.49255,-82.010811,26.48418,-81.978806,
26.47975,-81.970924,26.472858,-81.963997,26.468651,-81.966995,26.46055,-81.961082,26.454145,-81.928093,26.438889,-81.907913,
26.423134,-81.902496,26.415749,-81.902496,26.40984,-81.870003,26.37735,-81.854744,26.349779,-81.846962,26.329998,-81.834183,
26.297485,-81.820862,26.23637,-81.815308,26.1735,-81.81073,26.149706,-81.800377,26.08593,-81.76899,26.024618,-81.761742,
26.004423,-81.749992,25.993217,-81.746231,25.967312,-81.747734,25.961929,-81.752396,25.95878,-81.751823,25.951939,-81.743843,
25.947378,-81.738144,25.940536,-81.732437,25.930271,-81.729591,25.91773,-81.730164,25.908037,-81.718758,25.901196,-81.713623,
25.894924,-81.687965,25.848742,-81.683975,25.84532,-81.677704,25.844179,-81.666306,25.88238,-81.653763,25.894924,-81.617844,
25.896633,-81.581352,25.889791,-81.569946,25.889791,-81.549423,25.898914,-81.526619,25.901196,-81.515785,25.896065,-81.511223,
25.887512,-81.504951,25.88295,-81.483856,25.889791,-81.475868,25.887512,-81.461617,25.868696,-81.448502,25.869267,-81.417145,
25.862995,-81.40062,25.855583,-81.384079,25.839619,-81.34816,25.817385,-81.344452,25.802547,-81.343597,25.799137,-81.351585,
25.7712,-81.345879,25.752956,-81.343597,25.733,-81.33593,25.715504,-81.317909,25.70409,-81.303497,25.698084,-81.290878,
25.686069,-81.281876,25.681866,-81.275864,25.672255,-81.272255,25.660242,-81.272255,25.648228,-81.258438,25.643421,-81.246429,
25.630808,-81.241623,25.612787,-81.241623,25.594769,-81.235619,25.585758,-81.232613,25.568939,-81.224808,25.556927,-81.212189,
25.549116,-81.206787,25.542509,-81.204987,25.532898,-81.210396,25.518482,-81.210991,25.50647,-81.198975,25.491451,-81.168343,
25.463221,-81.166931,25.449728,-81.156326,25.431614,-81.150581,25.414827,-81.151466,25.387442,-81.146172,25.383024,-81.137329,
25.379932,-81.128494,25.379932,-81.124962,25.376398,-81.124962,25.360497,-81.121422,25.353428,-81.121872,25.3468,-81.130707,
25.342827,-81.137772,25.342384,-81.146606,25.334433,-81.151901,25.325596,-81.151466,25.312786,-81.161186,25.294674,-81.167366,
25.269493,-81.172234,25.235922,-81.172234,25.220901,-81.158096,25.209415,-81.146606,25.190865,-81.142632,25.179819,-81.142189,
25.155964,-81.130707,25.155523,-81.121422,25.151991,-81.101547,25.134319,-81.09536,25.12681,-81.091385,25.117092,-81.087418,
25.115324,-81.050743,25.128134,-81.025566,25.129019,-80.999062,25.124161,-80.97654,25.131226,-80.946495,25.132551,-80.921753,
25.140505,-80.900108,25.138737,-80.900993,25.154198,-80.897453,25.163033,-80.885536,25.167007,-80.874931,25.173634,-80.850906,
25.176483,-80.849052,25.176704,-80.848671,25.176577,-80.836235,25.172428,-80.830528,25.167084,-80.827332,25.159958,-80.809151,
25.166372,-80.798157,25.164944,-80.791855,25.164124,-80.77977,25.16255,-80.76918,25.161171,-80.765327,25.160669,-80.756577,
25.157103,-80.755714,25.156752,-80.752365,25.151173,-80.751434,25.149626,-80.743324,25.142487,-80.74305,25.142244,-80.742531,
25.141787,-80.730057,25.141787,-80.722931,25.144638,-80.714027,25.143211,-80.707253,25.138935,-80.70369,25.140005,-80.698799,
25.153736,-80.697868,25.156357,-80.694939,25.164572,-80.694427,25.166016,-80.692673,25.166067,-80.679893,25.166445,-80.673233,
25.166641,-80.669975,25.166737,-80.66922,25.166758,-80.658089,25.167084,-80.657082,25.167459,-80.647438,25.171059,-80.634216,
25.175991,-80.619957,25.177059,-80.616821,25.176079,-80.615013,25.175516,-80.614258,25.175278,-80.602501,25.187037,-80.594307,
25.189886,-80.593956,25.192524,-80.59359,25.195232,-80.592728,25.196098,-80.590385,25.198439,-80.584686,25.199863,-80.584633,
25.200033,-80.584114,25.201572,-80.583618,25.20307,-80.584259,25.204737,-80.590034,25.219816,-80.584328,25.226942,-80.569717,
25.237988,-80.561165,25.239412,-80.533028,25.230148,-80.520088,25.221783,-80.516258,25.219303,-80.515533,25.218359,-80.514153,
25.216549,-80.507797,25.208239,-80.50618,25.206129,-80.50322,25.202257,-80.499565,25.200558,-80.498177,25.199913,-80.496201,
25.198997,-80.495987,25.199203,-80.495583,25.199598,-80.488091,25.206861,-80.487671,25.207272,-80.487862,25.212143,-80.488174,
25.220308,-80.475136,25.229332,-80.474632,25.229519,-80.469612,25.23138,-80.458557,25.235479,-80.456642,25.236187,-80.448853,
25.239075,-80.446053,25.240112,-80.444656,25.240017,-80.440056,25.239704,-80.438301,25.239584,-80.435875,25.23942,-80.43502,
25.239361,-80.431519,25.241615,-80.426506,25.263678,-80.404945,25.280975,-80.403687,25.286491,-80.384888,25.301031,-80.379875,
25.312565,-80.37001,25.322571,-80.36171,25.328341,-80.352699,25.329062,-80.338989,25.335552,-80.327087,25.354668,-80.314102,
25.366207,-80.305809,25.384602,-80.308693,25.38965,-80.318069,25.388569,-80.325287,25.393978,-80.327805,25.40155,-80.326729,
25.422831,-80.319511,25.437256,-80.325287,25.437256,-80.330696,25.441944,-80.340431,25.470436,-80.340431,25.497847,-80.331413,
25.517321,-80.330338,25.530304,-80.321678,25.537878,-80.313385,25.53932,-80.302925,25.567451,-80.308914,25.588055,-80.308914,
25.602558,-80.305824,25.61521,-80.295639,25.627245,-80.272186,25.637735,-80.269104,25.642982,-80.26725,25.65687,-80.258301,
25.676619,-80.245033,25.697603,-80.248421,25.71365,-80.23362,25.727228,-80.210777,25.740498,-80.199623,25.747475,-80.180801,
25.747822,-80.158936,25.726919,-80.162025,25.715811,-80.177444,25.685877,-80.163254,25.675076,-80.158623,25.664583,-80.155235,
25.667051,-80.153381,25.67415,-80.155846,25.682175,-80.15554,25.699764,-80.146896,25.721674,-80.146591,25.738338,-80.132507,
25.764437,-80.127907,25.793301,-80.121597,25.815201,-80.1194,25.850599,-80.123085,25.900185,-80.117783,25.974791,-80.109802,
26.0868,-80.105499,26.096081,-80.101601,26.1474,-80.0896,26.231501,-80.083397,26.256304,-80.080307,26.257401,-80.0755,
26.3183,-80.074936,26.32044,-80.070801,26.3361,-80.060799,26.4443,-80.051308,26.5072,-80.042305,26.545099,-80.036598,
26.594,-80.036003,26.675699,-80.033104,26.714899,-80.037704,26.766001,-80.032471,26.773594,-80.033501,26.7871,-80.031601,
26.796,-80.035797,26.8144,-80.071518,26.945597,-80.080482,26.970385,-80.088303,26.992014,-80.090225,27.005344,-80.099762,
27.032677,-80.142273,27.119375,-80.150024,27.14312,-80.153694,27.168871,-80.16114,27.191456,-80.197609,27.258053,-80.19973,
27.262934,-80.240211,27.355904,-80.268867,27.411339,-80.312317,27.525526,-80.320541,27.556797,-80.331184,27.597231,-80.345551,
27.617544,-80.351326,27.62991,-80.351944,27.642315,-80.383926,27.73974,-80.446709,27.86046,-80.44725,27.861504,-80.492958,
27.940805,-80.532761,28.017076,-80.560104,28.077702,-80.574844,28.121208,-80.594505,28.197599,-80.6063,28.273102,-80.607803,
28.312801,-80.6036,28.363703,-80.591599,28.403,-80.569611,28.432343,-80.563103,28.4375,-80.531136,28.449114,-80.526962,
28.451426,-80.525124,28.456884,-80.561203,28.530275,-80.567535,28.561506,-80.575821,28.58622,-80.617027,28.634291,-80.644402,
28.673409,-80.703888,28.748066,-80.731941,28.790306,-80.873199,29.002199,-80.894707,29.037432,-80.908997,29.068399,-80.935303,
29.097601,-80.960564,29.137217,-81.046906,29.3076,-81.102097,29.427383,-81.125,29.476969,-81.163803,29.555176,-81.213173,
29.670332,-81.213936,29.672106,-81.227547,29.711695,-81.240189,29.736746,-81.259094,29.792517,-81.263344,29.817551,-81.26519,
29.859156,-81.270645,29.88286,-81.276749,29.900213,-81.288635,29.914036,-81.30571,29.957434,-81.379097,30.252399,-81.3918,
30.3032,-81.397934,30.36116,-81.397102,30.3811,-81.393303,30.3965,-81.407349,30.422319,-81.410995,30.481655,-81.42482,
30.505718,-81.434303,30.522223,-81.439285,30.541222,-81.44371,30.588545,-81.427612,30.697668,-81.434517,30.709368,-81.451424,
30.709248,-81.472786,30.713076,-81.485764,30.725042,-81.489723,30.725864,-81.516304,30.722,-81.531998,30.723801,-81.534904,
30.7197,-81.533905,30.710501,-81.538704,30.708401,-81.542801,30.7097,-81.548904,30.717699,-81.557907,30.712099,-81.563004,
30.7117,-81.563103,30.7174,-81.573906,30.722099,-81.586998,30.723499,-81.595398,30.717899,-81.597603,30.7199,-81.597107,
30.726801,-81.601402,30.7293,-81.605797,30.7276,-81.606003,30.718901,-81.610504,30.7157,-81.614601,30.7222,-81.6231,
30.723,-81.620903,30.7306,-81.624802,30.736099,-81.629303,30.7344,-81.630302,30.728001,-81.633102,30.7285,-81.636505,
30.733603,-81.643105,30.728201,-81.652107,30.728201,-81.654503,30.7332,-81.651901,30.741301,-81.654732,30.744101,-81.663506,
30.743099,-81.659897,30.75,-81.663422,30.753656,-81.683502,30.747999,-81.681107,30.7444,-81.673401,30.748301,-81.669998,
30.7465,-81.669502,30.7411,-81.672997,30.738701,-81.680603,30.741501,-81.689102,30.741199,-81.694954,30.74818,-81.701302,
30.745216,-81.710739,30.747314,-81.7201,30.7444,-81.732399,30.749399,-81.732414,30.754688,-81.742912,30.758968,-81.742256,
30.765259,-81.755249,30.768085,-81.76123,30.774717,-81.76944,30.776548,-81.773888,30.767179,-81.771965,30.763779,-81.782661,
30.760975,-81.783104,30.765495,-81.786934,30.769432,-81.784523,30.773357,-81.793449,30.786594,-81.79763,30.784723,-81.797195,
30.781044,-81.808693,30.789782,-81.819954,30.789537,-81.824097,30.786619,-81.829529,30.788996,-81.840546,30.786152,-81.842224,
30.786888,-81.840561,30.792061,-81.846458,30.790316,-81.852791,30.794207,-81.868774,30.792522,-81.871994,30.797775,-81.883377,
30.800014,-81.882896,30.804892,-81.885551,30.811251,-81.891449,30.815712,-81.892815,30.824629,-81.902046,30.829233,-81.905266,
30.827776,-81.907631,30.824343,-81.904961,30.817039,-81.909409,30.814869,-81.929329,30.817244,-81.930153,30.819452,-81.935509,
30.82056,-81.93409,30.823099,-81.939339,30.829548,-81.939102,30.826763,-81.943047,30.827917,-81.94191,30.825266,-81.949951,
30.827263,-81.95993,30.820936,-81.964752,30.816475,-81.961647,30.813656,-81.964165,30.812429,-81.962608,30.808208,-81.965439,
30.806444,-81.962692,30.796293,-81.969704,30.790344,-81.973091,30.779219,-81.979225,30.776182,-81.98877,30.779823,-82.004715,
30.79158,-82.006279,30.790182,-82.008636,30.792612,-82.014587,30.788902,-82.01384,30.790783,-82.01722,30.791424,-82.017693,
30.787415,-82.023033,30.78776,-82.024307,30.783291,-82.011757,30.76289,-82.021126,30.757551,-82.018082,30.75503,-82.022194,
30.755123,-82.028557,30.750748,-82.032806,30.750443,-82.036499,30.754555,-82.037949,30.753408,-82.041145,30.737749,-82.039207,
30.73633,-82.046082,30.72714,-82.039185,30.722649,-82.040115,30.71921,-82.037727,30.718409,-82.039764,30.715084,-82.036591,
30.706352,-82.039932,30.700624,-82.043457,30.700716,-82.041687,30.690861,-82.044334,30.683781,-82.04895,30.682474,-82.046593,
30.681236,-82.050652,30.675207,-82.046669,30.666315,-82.048767,30.664713,-82.046913,30.66077,-82.049957,30.661823,-82.049675,
30.655315,-82.042007,30.648483,-82.039253,30.640898,-82.041298,30.635948,-82.036552,30.6318,-82.037483,30.629919,-82.033905,
30.629118,-82.035713,30.626713,-82.031288,30.623316,-82.032135,30.619831,-82.029594,30.61919,-82.028664,30.621595,-82.027504,
30.606491,-82.020378,30.60358,-82.015869,30.601471,-82.012276,30.593538,-82.012199,30.586227,-82.010483,30.586456,-82.010925,
30.583454,-82.006271,30.576944,-82.008255,30.576784,-82.006378,30.574949,-82.008499,30.571192,-82.006065,30.565163,-82.00885,
30.563375,-82.005638,30.563259,-82.00824,30.560099,-82.010674,30.560947,-82.008881,30.554094,-82.011452,30.552834,-82.009972,
30.550495,-82.013382,30.549856,-82.013626,30.542294,-82.019424,30.532394,-82.017654,30.532394,-82.018875,30.528589,-82.015533,
30.528587,-82.018341,30.527306,-82.019035,30.523594,-82.016579,30.52137,-82.018845,30.51878,-82.015488,30.519421,-82.014938,
30.512774,-82.017296,30.506884,-82.015656,30.498175,-82.018013,30.49577,-82.015869,30.495033,-82.018387,30.49185,-82.015663,
30.483553,-82.019424,30.482935,-82.017441,30.479473,-82.019714,30.479244,-82.017075,30.474981,-82.024109,30.466572,-82.022469,
30.461002,-82.028435,30.455593,-82.028374,30.447161,-82.032455,30.441479,-82.034096,30.442234,-82.040283,30.436527,-82.033913,
30.427521,-82.036079,30.424587,-82.034096,30.420094,-82.043884,30.414345,-82.040894,30.414551,-82.04351,30.412807,-82.04203,
30.411135,-82.043938,30.40749,-82.041374,30.40646,-82.044624,30.404739,-82.044044,30.401325,-82.035973,30.384674,-82.038338,
30.382301,-82.037292,30.371506,-82.044708,30.3671,-82.042122,30.365183,-82.045029,30.365993,-82.048714,30.362753,-82.05024,
30.362104,-82.058235,30.358906,-82.062607,30.360313,-82.065987,30.355408,-82.072395,30.361221,-82.081268,30.35857,-82.094856,
30.360546,-82.09903,30.363905,-82.101135,30.362467,-82.101585,30.366322,-82.105324,30.368647,-82.110283,30.36499,-82.115608,
30.367912,-82.11834,30.364159,-82.126747,30.368057,-82.129204,30.366821,-82.1278,30.36517,-82.134361,30.361872,-82.140038,
30.36474,-82.148659,30.3608,-82.158089,30.359795,-82.162025,30.356884,-82.167839,30.359842,-82.170219,30.358696,-82.174149,
30.364908,-82.18132,30.368345,-82.180611,30.372126,-82.18396,30.373478,-82.185097,30.378662,-82.19001,30.375706,-82.193108,
30.378546,-82.192093,30.384415,-82.194527,30.388884,-82.199608,30.389502,-82.198311,30.39138,-82.205032,30.402451,-82.204048,
30.405199,-82.206963,30.406208,-82.207649,30.420624,-82.211143,30.42477,-82.21003,30.432587,-82.206703,30.435314,-82.20768,
30.438889,-82.20414,30.444277,-82.204742,30.45491,-82.207687,30.456696,-82.20787,30.460272,-82.201759,30.476522,-82.202003,
30.485666,-82.212479,30.5,-82.227097,30.51005,-82.230537,30.517109,-82.230911,30.526527,-82.240524,30.537432,-82.239288,
30.544882,-82.234528,30.549284,-82.234451,30.557627,-82.224281,30.564802,-82.217186,30.565262,-82.214996,30.568359,-82.419044,
30.58152,-82.459694,30.584051,-82.584122,30.59161,-82.689415,30.597502,-83.136749,30.623756,-83.309586,30.634211,-83.341141,
30.636141,-83.357193,30.637115,-83.611794,30.651054,-83.743996,30.658188,-84.007507,30.6719,-84.083794,30.675604,-84.281311,
30.685062,-84.380798,30.6898,-84.474503,30.6926,-84.863541,30.711304,-84.864777,30.711351,-84.869835,30.721706,-84.883904,
30.732401,-84.887604,30.7416,-84.896202,30.750401,-84.907402,30.750401,-84.914307,30.753201,-84.915108,30.761,-84.920197,
30.7658,-84.918106,30.777901,-84.927902,30.7918,-84.928398,30.804899,-84.937508,30.8207,-84.935402,30.8347,-84.932198,
30.8381,-84.926903,30.8389,-84.925705,30.842501,-84.936203,30.8568,-84.936501,30.8596,-84.932404,30.8641,-84.939903,
30.8724,-84.934502,30.8834,-84.942596,30.8883,-84.9562,30.9074,-84.966797,30.917101,-84.971107,30.927999,-84.9832,
30.934601,-84.980202,30.9611,-84.984901,30.9673,-85,30.971001,-85.005173,30.97452,-85.002441,31.000498,-85.243706,
31.0007,-85.488365,30.996883,-85.498337,30.996748,-86.035103,30.993139,-86.187302,30.993841,-86.388702,30.994001,-86.688362,
30.994326,-86.724358,30.996687,-86.785957,30.996798,-87.162651,30.998875,-87.237709,30.996212,-87.255005,30.998104,-87.598946,
30.997276,-87.589363,30.965315,-87.591354,30.95335,-87.607826,30.924307,-87.61602,30.90127,-87.622215,30.897324,-87.620796,
30.88731,-87.629471,30.87993,-87.634949,30.865702));


INSERT_DEMO_STATES(
'Florida','FL','12',12937920,12.3984,53988,239.6442,6682848,1967481,47436,10671192,1300064,304798,12633128,
51.6531,2.3554,10755696,1755958,150200,42619,1555031,83.125,13.5703,1.1608,0.3294,12.0175,6.5126,6.3027,4.6806,
4.6425,9.1679,16.4921,13.9707,10.1132,4.539,5.2656,10.6289,6.0888,1.5888,24.746,30.4101,26.5273,18.3046,842642,
815450,605655,600753,1186258,2133804,1807682,1308480,587269,681289,1375246,787811,205586,3202058,3934816,3432408,
2368642,2864500,5127744,2577038,36.4931,5138360,2.4585,602035,1300064,1935187,1455963,447146,25.3007,37.6562,28.332,
8.7011,3541308,2849156,1082110,533410,292238,1597052,68.9062,80.4531,30.5546,15.0625,8.2519,31.0781,775560,509728,
1032504,869992,882335,660462,209795,197984,15.0917,9.9199,20.0937,16.9296,17.1679,12.8535,4.082,3.853,25.0117,
45.1015,62.0312,79.2031,92.0625,96.1406,27483,36517,
geom);
COMMIT;

      
END;
/


DECLARE
geom MDSYS.SDO_GEOMETRY;
BEGIN


geom:=MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-79.762146,42.269817,-79.761597,
41.999016,-79.610306,41.9986,
-79.061493,41.999199,-78.919098,
41.998058,-78.308395,41.999352,
-78.206871,41.999531,-77.750214,
41.998714,-77.610107,41.999298,
-77.125,41.999325,-76.966003,
42.001202,-76.927399,42.001598,
-76.558449,42.00008,-76.147202,
41.998688,-76.106194,41.998783,
-75.761505,41.997711,-75.483803,
41.999168,-75.359962,41.999359,
-75.341507,41.992687,-75.337982,
41.986614,-75.342583,41.97279,
-75.329704,41.968147,-75.320427,
41.960785,-75.31855,41.954151,
-75.313202,41.950096,-75.302048,
41.948296,-75.300789,41.953785,
-75.294098,41.95451,-75.289764,
41.942802,-75.27948,41.938831,
-75.276939,41.922123,-75.267944,
41.906967,-75.268158,41.901882,
-75.273163,41.89703,-75.271675,
41.887272,-75.261009,41.883698,
-75.257942,41.877022,-75.264198,
41.87067,-75.26091,41.863712,
-75.251587,41.861954,-75.241524,
41.867031,-75.232002,41.859371,
-75.224121,41.857368,-75.215355,
41.867363,-75.204384,41.869781,
-75.194771,41.867199,-75.185638,
41.859844,-75.17952,41.869846,
-75.174957,41.872574,-75.169525,
41.870205,-75.169121,41.859173,
-75.164551,41.851501,-75.156898,
41.84824,-75.146835,41.850811,
-75.140633,41.851994,-75.131371,
41.845058,-75.115982,41.844551,
-75.113724,41.822697,-75.100418,
41.81826,-75.089874,41.811489,
-75.076614,41.815201,-75.072266,
41.812813,-75.077278,41.79842,
-75.081802,41.796394,-75.093262,
41.796299,-75.10041,41.789562,
-75.105026,41.774117,-75.100357,
41.76881,-75.093201,41.768272,
-75.077385,41.771561,-75.065285,
41.766602,-75.06076,41.764111,
-75.053619,41.751575,-75.055206,
41.735081,-75.050247,41.713219,
-75.052612,41.711308,-75.067017,
41.712502,-75.069214,41.708073,
-75.053131,41.688305,-75.051674,
41.679871,-75.059723,41.672234,
-75.050308,41.662468,-75.049049,
41.633694,-75.044037,41.622528,
-75.045898,41.616116,-75.058304,
41.618069,-75.061943,41.616341,
-75.06076,41.610317,-75.074188,
41.608498,-75.074997,41.605625,
-75.070084,41.601917,-75.060402,
41.590725,-75.047142,41.583172,
-75.040878,41.569599,-75.027725,
41.563454,-75.018913,41.551716,
-75.016533,41.544155,-75.025185,
41.539711,-75.025146,41.535011,
-75.009941,41.528374,-75.003372,
41.522884,-75.001297,41.519203,
-75.003532,41.508011,-74.988029,
41.508648,-74.984756,41.506523,
-74.982559,41.498398,-74.985985,
41.485775,-74.983727,41.480804,
-74.958649,41.476307,-74.945145,
41.483398,-74.933846,41.482513,
-74.925377,41.47736,-74.910995,
41.474083,-74.90728,41.46104,
-74.904594,41.459717,-74.890755,
41.455235,-74.889679,41.450687,
-74.89679,41.442089,-74.893013,
41.438526,-74.858971,41.444336,
-74.837303,41.431538,-74.831062,
41.430412,-74.826424,41.431644,
-74.818382,41.440414,-74.809418,
41.442905,-74.801949,41.438515,
-74.79689,41.425301,-74.792503,
41.421986,-74.784729,41.422302,
-74.773628,41.426262,-74.761215,
41.423122,-74.755081,41.424881,
-74.744217,41.430546,-74.737083,
41.429134,-74.73513,41.422607,
-74.741478,41.41132,-74.741348,
41.405029,-74.734032,41.396885,
-74.716377,41.39249,-74.708847,
41.378807,-74.691521,41.367233,
-74.690163,41.361465,-74.695305,
41.35733,-74.461754,41.25,-74.366302,
41.202801,-74.234879,41.142788,
-74.213707,41.1339,-73.905434,
40.997498,-73.894402,40.997101,
-73.896904,40.981602,-73.918503,
40.9174,-73.933998,40.881901,
-73.953903,40.8489,-73.9636,
40.826801,-73.985344,40.797417,
-74.014198,40.7565,-74.026703,
40.699799,-74.034866,40.686726,
-74.056305,40.651299,-74.087402,
40.651299,-74.0942,40.6478,
-74.110397,40.6479,-74.143799,
40.6418,-74.161491,40.644012,
-74.18644,40.645973,-74.202629,
40.630951,-74.206413,40.606949,
-74.201019,40.598747,-74.205002,
40.593498,-74.208511,40.588848,
-74.209396,40.576199,-74.215202,
40.560501,-74.218597,40.557098,
-74.232002,40.559101,-74.249054,
40.549496,-74.251854,40.542194,
-74.246651,40.520859,-74.254982,
40.515724,-74.259506,40.497101,
-74.257202,40.493187,-74.257126,
40.493191,-74.217216,40.503563,
-74.210945,40.510387,-74.206032,
40.512024,-74.193207,40.510658,
-74.183929,40.519665,-74.178474,
40.51939,-74.14463,40.534946,
-74.13781,40.529758,-74.133713,
40.531673,-74.123619,40.541496,
-74.112152,40.54668,-74.068497,
40.583797,-74.053482,40.602623,
-74.042648,40.603928,-74.032372,
40.605164,-74.009392,40.599468,
-73.999374,40.59024,-73.999184,
40.584545,-74.000755,40.580814,
-74.009392,40.58062,-74.013321,
40.577278,-74.011742,40.57375,
-74.002518,40.570801,-73.991722,
40.56982,-73.950485,40.574532,
-73.944458,40.564663,-73.93914,
40.555962,-73.940231,40.543407,
-73.922768,40.551048,-73.863281,
40.565784,-73.828896,40.57888,
-73.772682,40.590889,-73.760674,
40.590889,-73.756348,40.586205,
-73.754761,40.584488,-73.740303,
40.585972,-73.645821,40.582268,
-73.599876,40.587078,-73.592102,
40.584862,-73.57766,40.586712,
-73.571732,40.583748,-73.561356,
40.583378,-73.425964,40.608772,
-73.424202,40.6091,-73.342201,
40.632217,-73.326569,40.632717,
-73.314659,40.628246,-73.310928,
40.61956,-73.260551,40.621052,
-73.176819,40.636761,-73.084839,
40.658249,-73.033272,40.672001,
-72.884567,40.726151,-72.816666,
40.746784,-72.756485,40.763111,
-72.753059,40.762257,-72.619827,
40.799217,-72.506363,40.83102,
-72.421387,40.857574,-72.353333,
40.88121,-72.217957,40.934219,
-72.142029,40.961437,-71.918549,
41.038795,-71.903511,41.039513,
-71.874855,41.051689,-71.856232,
41.070313,-71.866974,41.077477,
-71.89563,41.076759,-71.905655,
41.086071,-71.91497,41.081776,
-71.959373,41.071743,-71.96225,
41.062431,-71.95723,41.045959,
-71.965111,41.04166,-71.973701,
41.040234,-71.980148,41.043095,
-71.983017,41.047394,-71.99305,
41.047394,-72.022415,41.020889,
-72.039604,41.019455,-72.052498,
41.022324,-72.061806,41.01659,
-72.066826,41.010143,-72.076851,
41.009426,-72.084015,40.996536,
-72.09333,40.992237,-72.107651,
40.99295,-72.118393,41.000835,
-72.128426,41.015877,-72.136307,
41.020172,-72.138451,41.040943,
-72.16066,41.053123,-72.175697,
41.047394,-72.18071,41.038795,
-72.190742,41.03307,-72.200058,
41.030914,-72.231567,41.044525,
-72.263084,41.04166,-72.273834,
41.050255,-72.282425,41.068878,
-72.276695,41.076759,-72.280991,
41.081055,-72.292458,41.081055,
-72.308929,41.084641,-72.320389,
41.090366,-72.323257,41.100395,
-72.253777,41.134064,-72.253059,
41.141228,-72.238014,41.154835,
-72.237297,41.159847,-72.24733,
41.160564,-72.258781,41.158417,
-72.266663,41.154121,-72.277962,
41.158173,-72.286186,41.157299,
-72.313309,41.147617,-72.320091,
41.140835,-72.331711,41.136959,
-72.340431,41.140835,-72.354958,
41.138897,-72.358833,41.13018,
-72.365616,41.123402,-72.383049,
41.114681,-72.391769,41.10112,
-72.406296,41.091434,-72.426643,
41.086594,-72.446976,41.084656,
-72.455696,41.072063,-72.477974,
41.051723,-72.517685,41.0401,
-72.562241,41.013943,-72.57193,
41.003292,-72.631981,40.98101,
-72.678482,40.978104,-72.692039,
40.980045,-72.771461,40.966484,
-72.835396,40.968418,-72.866394,
40.963577,-72.899323,40.962608,
-73.006844,40.965511,-73.053337,
40.964546,-73.08239,40.972298,
-73.104675,40.968418,-73.119324,
40.977081,-73.132698,40.96751,
-73.151054,40.966045,-73.158035,
40.96788,-73.159874,40.966412,
-73.145554,40.955395,-73.147751,
40.930798,-73.165741,40.92382,
-73.227432,40.906559,-73.267815,
40.914272,-73.294624,40.924183,
-73.323257,40.928955,-73.331703,
40.930061,-73.352631,40.926758,
-73.375031,40.937035,-73.393394,
40.954659,-73.399635,40.955029,
-73.402199,40.952087,-73.404037,
40.92345,-73.406975,40.920143,
-73.417625,40.918312,-73.429008,
40.920143,-73.430161,40.928635,
-73.430305,40.929699,-73.437103,
40.934799,-73.4617,40.936901,
-73.485802,40.946301,-73.493904,
40.9398,-73.496902,40.92308,
-73.507652,40.918736,-73.527718,
40.916763,-73.528893,40.914013,
-73.550529,40.908508,-73.566254,
40.915588,-73.570976,40.915588,
-73.582779,40.909294,-73.594574,
40.907719,-73.605988,40.901821,
-73.631935,40.900639,-73.649239,
40.880981,-73.655144,40.877831,
-73.656319,40.86446,-73.664978,
40.85738,-73.676773,40.856201,
-73.714134,40.869572,-73.721214,
40.865639,-73.731834,40.866032,
-73.727112,40.85659,-73.72908,
40.852268,-73.73774,40.849121,
-73.743629,40.841255,-73.757401,
40.832996,-73.753464,40.823555,
-73.757004,40.817265,-73.779999,
40.812,-73.797615,40.815208,
-73.813286,40.82724,-73.815666,
40.830597,-73.815102,40.843185,
-73.808807,40.846966,-73.800415,
40.847801,-73.790627,40.867668,
-73.784477,40.869617,-73.785622,
40.877769,-73.784096,40.880333,
-73.782066,40.883743,-73.775291,
40.882423,-73.770927,40.879185,
-73.767265,40.880775,-73.767487,
40.886189,-73.770348,40.888039,
-73.770432,40.893879,-73.766266,
40.901756,-73.761955,40.906811,
-73.743484,40.917889,-73.742065,
40.927429,-73.735222,40.925835,
-73.734261,40.921223,-73.731407,
40.927589,-73.725197,40.928223,
-73.722656,40.941586,-73.716454,
40.944763,-73.708504,40.944443,
-73.698326,40.939514,-73.69149,
40.944286,-73.686081,40.943649,
-73.677177,40.963688,-73.662506,
40.966099,-73.660393,40.968224,
-73.659958,40.974625,-73.656815,
40.977722,-73.658051,40.985401,
-73.657646,40.985874,-73.660095,
40.987812,-73.657486,40.98875,
-73.659798,40.999401,-73.655106,
41.0116,-73.728203,41.100601,
-73.634201,41.1441,-73.555695,
41.179588,-73.485771,41.211452,
-73.483147,41.212666,-73.503075,
41.237259,-73.551392,41.295326,
-73.545158,41.36628,-73.543854,
41.37653,-73.537399,41.441002,
-73.53112,41.520153,-73.530495,
41.5271,-73.518494,41.666737,
-73.508362,41.791496,-73.497025,
41.921726,-73.487755,42.049549,
-73.497314,42.049583,-73.508575,
42.086166,-73.483696,42.154774,
-73.460655,42.217442,-73.431755,
42.296055,-73.411331,42.351543,
-73.383957,42.425407,-73.352974,
42.509918,-73.307327,42.632835,
-73.265411,42.745861,-73.276871,
42.745941,-73.291389,42.801846,
-73.284203,42.813789,-73.287514,
42.820065,-73.285835,42.834015,
-73.279121,42.833332,-73.278755,
42.837479,-73.275192,42.934357,
-73.274742,42.943577,-73.270485,
43.03064,-73.264511,43.123322,
-73.259605,43.21677,-73.255081,
43.314602,-73.251297,43.40863,
-73.249207,43.461742,-73.248146,
43.523106,-73.241837,43.532276,
-73.246078,43.539478,-73.250572,
43.543362,-73.24826,43.544987,
-73.250854,43.550362,-73.249084,
43.553791,-73.254936,43.555527,
-73.253052,43.556786,-73.256378,
43.561817,-73.26461,43.569069,
-73.269447,43.569847,-73.268028,
43.571907,-73.278259,43.574566,
-73.281303,43.573513,-73.281746,
43.577511,-73.285362,43.579205,
-73.295738,43.576717,-73.297783,
43.579323,-73.292557,43.584442,
-73.297371,43.587257,-73.291573,
43.599148,-73.298462,43.609962,
-73.303215,43.609711,-73.300758,
43.617256,-73.302521,43.623772,
-73.306679,43.627953,-73.311615,
43.624027,-73.318298,43.628433,
-73.32814,43.625847,-73.334633,
43.62793,-73.340515,43.62458,
-73.344955,43.626213,-73.349197,
43.621391,-73.355087,43.626163,
-73.366005,43.623375,-73.372337,
43.624424,-73.370277,43.619328,
-73.376831,43.608761,-73.37291,
43.604782,-73.377785,43.598289,
-73.383949,43.597218,-73.382385,
43.591637,-73.387321,43.590744,
-73.382797,43.586102,-73.385696,
43.583199,-73.38382,43.576702,
-73.391045,43.574192,-73.391991,
43.570145,-73.396645,43.567883,
-73.40435,43.570263,-73.420822,
43.581425,-73.429077,43.583927,
-73.431671,43.588219,-73.422058,
43.602955,-73.424149,43.612293,
-73.418114,43.621624,-73.429024,
43.636478,-73.425659,43.64423,
-73.415955,43.65239,-73.407883,
43.673367,-73.40435,43.691345,
-73.395958,43.69677,-73.386322,
43.711277,-73.371056,43.725269,
-73.370331,43.743839,-73.363106,
43.753082,-73.350868,43.771378,
-73.357986,43.785873,-73.376801,
43.79871,-73.379723,43.808331,
-73.393188,43.822136,-73.388824,
43.832344,-73.373993,43.842739,
-73.373329,43.846828,-73.382477,
43.854946,-73.374657,43.876171,
-73.383926,43.890892,-73.396309,
43.902988,-73.408173,43.929829,
-73.407257,43.967258,-73.413048,
43.979923,-73.40641,44.011429,
-73.407784,44.020226,-73.412865,
44.028252,-73.423065,44.032379,
-73.438179,44.044952,-73.429672,
44.079361,-73.415451,44.101189,
-73.414078,44.107616,-73.411743,
44.112633,-73.416191,44.132771,
-73.403694,44.144245,-73.401413,
44.15221,-73.395958,44.166073,
-73.397324,44.173794,-73.390091,
44.181194,-73.391014,44.190838,
-73.384415,44.193108,-73.382683,
44.197128,-73.362442,44.208492,
-73.362251,44.213268,-73.355705,
44.219505,-73.350319,44.230305,
-73.342743,44.234482,-73.343666,
44.237995,-73.330925,44.244205,
-73.32402,44.243843,-73.313828,
44.264019,-73.311455,44.274189,
-73.324654,44.309971,-73.324425,
44.333794,-73.327385,44.343319,
-73.335068,44.356827,-73.334,
44.372238,-73.315445,44.388466,
-73.294159,44.438114,-73.300545,
44.454662,-73.299576,44.47287,
-73.307137,44.500286,-73.321266,
44.513584,-73.321632,44.520275,
-73.322899,44.525875,-73.32988,
44.529156,-73.332024,44.535877,
-73.339226,44.542881,-73.339058,
44.546795,-73.343361,44.551861,
-73.356628,44.557426,-73.361916,
44.563538,-73.375374,44.575771,
-73.376091,44.581993,-73.382271,
44.589272,-73.377235,44.595413,
-73.377274,44.599552,-73.383354,
44.612141,-73.390656,44.618309,
-73.386917,44.626881,-73.387207,
44.636326,-73.378983,44.641434,
-73.384903,44.646641,-73.378746,
44.652119,-73.379494,44.656727,
-73.375,44.661846,-73.370087,
44.663437,-73.373146,44.668697,
-73.372139,44.675117,-73.372055,
44.677197,-73.36763,44.678471,
-73.370567,44.684811,-73.365723,
44.687504,-73.361656,44.694973,
-73.366402,44.697517,-73.366173,
44.74102,-73.352493,44.760635,
-73.347511,44.772942,-73.333878,
44.786469,-73.335464,44.80407,
-73.341858,44.808784,-73.353897,
44.820343,-73.368698,44.827969,
-73.379875,44.837967,-73.382019,
44.849312,-73.380249,44.856995,
-73.36953,44.866638,-73.356644,
44.904453,-73.34317,44.913677,
-73.33905,44.919327,-73.338661,
44.96471,-73.350639,44.976185,
-73.355057,44.987312,-73.343552,
45.010799,-73.640129,45.003429,
-73.875,45.001183,-74.027786,
44.99564,-74.15062,44.99131,
-74.335541,44.991863,-74.457222,
44.996964,-74.457886,44.99699,
-74.66185,44.99955,-74.670677,
45.006157,-74.673416,45.000896,
-74.678368,45.000328,-74.678802,45,
-74.680061,45.000134,-74.684341,
44.999645,-74.694557,45.001701,
-74.694916,45.00174,-74.722946,
44.998005,-74.726601,44.994812,
-74.731674,44.990372,-74.745018,
44.990528,-74.76059,44.994896,
-74.763771,45.005573,-74.793518,
45.004601,-74.801994,45.014523,
-74.817558,45.011669,-74.826942,
45.015804,-74.866997,45.000481,
-74.88839,44.999599,-74.901085,
44.992706,-74.90831,44.983311,
-74.972809,44.983356,-74.993103,
44.977406,-74.999619,44.966061,
-75.005501,44.958355,-75.015793,
44.952812,-75.027473,44.946522,
-75.060211,44.934563,-75.06031,
44.934521,-75.06517,44.929401,
-75.097,44.927017,-75.105431,
44.919491,-75.11792,44.921291,
-75.134758,44.915051,-75.140213,
44.896626,-75.165466,44.893272,
-75.203354,44.877495,-75.218918,
44.877518,-75.228973,44.867844,
-75.246025,44.863976,-75.249031,
44.862068,-75.255859,44.857597,
-75.25618,44.857533,-75.256439,
44.857368,-75.307083,44.835163,
-75.302315,44.82658,-75.334084,
44.80632,-75.344879,44.809086,
-75.370224,44.785656,-75.370285,
44.782825,-75.387703,44.779968,
-75.397346,44.773411,-75.414131,
44.772476,-75.424278,44.756268,
-75.472229,44.723846,-75.473793,
44.72298,-75.477974,44.720165,
-75.50341,44.706532,-75.506477,
44.704834,-75.61869,44.619576,
-75.662491,44.59201,-75.662704,
44.591873,-75.766541,44.515793,
-75.808098,44.471588,-75.821152,
44.432186,-75.860367,44.403214,
-75.860779,44.402939,-75.871819,
44.394787,-75.913246,44.368076,
-75.913307,44.368034,-75.922043,
44.368835,-75.929794,44.35955,
-75.949867,44.349079,-75.970512,
44.342789,-75.978607,44.346832,
-76.00132,44.347488,-76.045555,
44.33168,-76.097679,44.2995,
-76.112267,44.297989,-76.118462,
44.294804,-76.131218,44.296593,
-76.16217,44.280731,-76.164597,
44.239559,-76.15274,44.244701,
-76.129913,44.247871,-76.114685,
44.256752,-76.107712,44.247871,
-76.108353,44.238361,-76.119766,
44.226307,-76.15274,44.2206,
-76.182549,44.20665,-76.192696,
44.207283,-76.207916,44.202209,
-76.21109,44.193333,-76.257393,
44.166061,-76.268806,44.160351,
-76.281487,44.159718,-76.291641,
44.155277,-76.299248,44.150837,
-76.311928,44.136883,-76.322083,
44.132442,-76.336029,44.12991,
-76.346817,44.123569,-76.365211,
44.111515,-76.371552,44.100735,
-76.36203,44.094391,-76.356331,
44.07917,-76.360771,44.076,
-76.360771,44.06966,-76.346817,
44.070927,-76.33857,44.074734,
-76.334763,44.069023,-76.335403,
44.063953,-76.316368,44.058876,
-76.305595,44.058243,-76.300514,
44.049995,-76.299881,44.030972,
-76.310036,44.026531,-76.302414,
44.008774,-76.289101,44.010677,
-76.277687,44.005604,-76.268166,
43.992283,-76.280853,43.971989,
-76.28212,43.961208,-76.271347,
43.961208,-76.265633,43.965649,
-76.254852,43.965649,-76.239632,
43.975796,-76.232025,43.984039,
-76.209824,43.976429,-76.201576,
43.968185,-76.174301,43.963745,
-76.169861,43.958672,-76.157814,
43.959305,-76.130547,43.929497,
-76.126747,43.909836,-76.12928,
43.894615,-76.1464,43.887642,
-76.155281,43.890175,-76.203484,
43.864807,-76.216797,43.862267,
-76.226944,43.864807,-76.232025,
43.870518,-76.222504,43.878761,
-76.22187,43.885101,-76.228851,
43.887005,-76.253586,43.879391,
-76.261192,43.881294,-76.276413,
43.874954,-76.297974,43.855927,
-76.299881,43.838169,-76.294174,
43.835632,-76.289734,43.838169,
-76.277687,43.839439,-76.270706,
43.824215,-76.256752,43.825485,
-76.233917,43.805191,-76.223778,
43.786163,-76.208549,43.732258,
-76.200462,43.680126,-76.196053,
43.651634,-76.203278,43.575363,
-76.219086,43.544205,-76.230713,
43.531185,-76.246529,43.52607,
-76.27861,43.520489,-76.293022,
43.513512,-76.316277,43.514908,
-76.331627,43.511189,-76.334877,
43.514442,-76.346039,43.513512,
-76.353477,43.515839,-76.367897,
43.525139,-76.403236,43.524208,
-76.419975,43.520489,-76.472527,
43.493984,-76.486481,43.47538,
-76.565536,43.448406,-76.596222,
43.42981,-76.599945,43.424229,
-76.607849,43.423763,-76.617104,
43.417351,-76.623077,43.413212,
-76.630959,43.413418,-76.670937,
43.364952,-76.698502,43.344456,
-76.709053,43.346622,-76.718147,
43.343544,-76.722183,43.343403,
-76.731979,43.343063,-76.767731,
43.318958,-76.784264,43.311516,
-76.843819,43.304901,-76.866142,
43.29332,-76.881035,43.292492,
-76.898399,43.296627,-76.94471,
43.272644,-76.956299,43.270988,
-76.975311,43.2743,-77.010048,
43.270164,-77.043961,43.270164,
-77.049751,43.277607,-77.070427,
43.281738,-77.1035,43.287533,
-77.122528,43.286705,-77.144859,
43.290012,-77.171326,43.280914,
-77.192001,43.284225,-77.218468,
43.284225,-77.270569,43.277607,
-77.313576,43.280087,-77.368996,
43.277607,-77.375,43.276779,
-77.423943,43.270039,-77.445541,
43.261246,-77.46714,43.257244,
-77.486343,43.250843,-77.501534,
43.250046,-77.531937,43.234844,
-77.553535,43.235645,-77.57753,
43.242844,-77.629524,43.271641,
-77.655121,43.278839,-77.702316,
43.307636,-77.713516,43.321236,
-77.760712,43.339638,-77.799911,
43.338837,-77.830307,43.342037,
-77.977486,43.367634,-77.995102,
43.3652,-77.99601,43.36533,
-78.013374,43.367813,-78.028702,
43.36581,-78.038696,43.369808,
-78.064674,43.369808,-78.101311,
43.374474,-78.153946,43.375141,
-78.162598,43.375141,-78.182587,
43.369808,-78.207901,43.371807,
-78.248535,43.368477,-78.255867,
43.372475,-78.271187,43.370476,
-78.312485,43.37381,-78.341133,
43.371807,-78.392426,43.375805,
-78.439728,43.371807,-78.465973,
43.372395,-78.494164,43.373024,
-78.536911,43.369862,-78.636658,
43.357193,-78.696823,43.338192,
-78.731667,43.338192,-78.77916,
43.325523,-78.807663,43.32394,
-78.836159,43.317608,-78.855164,
43.309692,-78.873772,43.307335,
-78.972725,43.280796,-79.000435,
43.277233,-79.070702,43.262402,
-79.056305,43.254101,-79.053101,
43.222,-79.057304,43.210602,
-79.048904,43.1996,-79.053307,
43.173599,-79.046799,43.1623,
-79.042603,43.1436,-79.044304,43.138,
-79.056999,43.126801,-79.069801,
43.120201,-79.062202,43.115299,
-79.058197,43.106899,-79.0662,43.091,
-79.0756,43.081299,-79.074707,
43.077801,-79.019501,43.067902,
-79.007401,43.065701,-78.999702,
43.056,-79.012001,43.0289,-79.023506,
43.0163,-79.020203,42.994701,
-79.011803,42.985199,-78.975304,
42.9687,-78.961998,42.957699,
-78.932602,42.955799,-78.919106,
42.9468,-78.909401,42.933201,
-78.905907,42.923302,-78.905998,
42.899899,-78.906075,42.899742,
-78.89447,42.887508,-78.89167,
42.876877,-78.863693,42.838276,
-78.865936,42.823174,-78.864258,
42.811985,-78.852509,42.790726,
-78.85363,42.78289,-78.862022,
42.778416,-78.865936,42.771702,
-78.91909,42.736458,-78.943703,
42.731419,-78.969429,42.72023,
-78.991814,42.705128,-79.018661,
42.701214,-79.04776,42.6917,
-79.056152,42.674358,-79.063423,
42.668762,-79.064545,42.64415,
-79.072372,42.639111,-79.078529,
42.639671,-79.093636,42.630165,
-79.112656,42.612259,-79.12384,
42.59156,-79.132233,42.589882,
-79.131676,42.58429,-79.137077,
42.569687,-79.140038,42.561695,
-79.151047,42.55069,-79.160683,
42.552753,-79.170311,42.547935,
-79.1772,42.55069,-79.19165,
42.544491,-79.201279,42.544491,
-79.207474,42.541054,-79.250824,
42.531422,-79.254265,42.525227,
-79.27285,42.518345,-79.278351,
42.510777,-79.293488,42.509399,
-79.316887,42.501831,-79.332024,
42.487381,-79.353355,42.492886,
-79.359543,42.488068,-79.359543,
42.481873,-79.362991,42.477745,
-79.369873,42.475685,-79.382942,
42.465359,-79.392578,42.462608,
-79.406334,42.45229,-79.419418,
42.452976,-79.424232,42.441963,
-79.424232,42.433022,-79.447624,
42.415127,-79.464828,42.406185,
-79.473091,42.405495,-79.531578,
42.369713,-79.553596,42.361458,
-79.589378,42.341499,-79.596954,
42.341499,-79.607269,42.338058,
-79.613464,42.329113,-79.617592,
42.330486,-79.682274,42.298149,
-79.762146,42.269817));

INSERT_DEMO_STATES('New York', 'NY', '36', 17990448, 14.2988, 47215.7187, 381.0266, 9375272, 2826210,
82256, 14927096, 1788656, 543722, 17446720, 52.1124, 3.0219, 13398000, 2860590,
689262, 59081, 2151742, 74.4687, 15.9003, 3.831, 0.3283, 11.9589, 6.9335, 6.5458,
5.1445, 5.0322, 10.6464, 17.5039, 15.121, 10.8085, 4.5078, 4.622, 7.5468, 4.2382,
1.3425, 26.6289, 33.0703, 27.1679, 13.1269, 1247407, 1177729, 925671, 905494,
1915585, 3149060, 2720494, 1944588, 810990, 831544, 1357726, 762626, 241541,
4790740, 5949580, 4888240, 2361892, 4256300, 7785136, 3587122, 33.9789, 6634432,
2.6297, 713730, 1788656, 1938056, 2110200, 797522, 26.957, 29.2109, 31.8046,
12.0195, 4528888, 3391850, 1554039, 903490, 470215, 2105546, 68.25, 74.8906,
34.3125, 19.9492, 10.3808, 31.7343, 1032184, 494101, 999183, 950695, 1145247,
1108921, 454648, 449455, 15.5566, 7.4472, 15.0605, 14.3281, 17.2617, 16.7109,
6.8525, 6.7744, 23.0039, 38.0625, 52.3906, 69.6562, 86.3593, 93.2187, 32965, 44121,
geom);
COMMIT;
END;
/

CREATE TABLE DEMO_COUNTIES
  (
    "GEOM" "MDSYS"."SDO_GEOMETRY" ,
    "COUNTY"     VARCHAR2(31 BYTE),
    "FIPSSTCO"   VARCHAR2(5 BYTE),
    "STATE"      VARCHAR2(30 BYTE),
    "STATE_ABRV" VARCHAR2(2 BYTE),
    "FIPSST"     VARCHAR2(2 BYTE),
    "LANDSQMI"   NUMBER,
    "TOTPOP"     NUMBER,
    "POPPSQMI"   NUMBER
  );
  
  COMMIT;

CREATE OR REPLACE PROCEDURE INSERT_DEMO_COUNTIES(
    GEOM MDSYS.SDO_GEOMETRY,
    COUNTY     VARCHAR2,
    FIPSSTCO   VARCHAR2,
    STATE      VARCHAR2,
    STATE_ABRV VARCHAR2,
    FIPSST     VARCHAR2,
    LANDSQMI   NUMBER,
    TOTPOP     NUMBER,
    POPPSQMI  NUMBER)
IS
BEGIN
  Insert into DEMO_COUNTIES (GEOM,COUNTY,FIPSSTCO,STATE,STATE_ABRV,FIPSST,LANDSQMI,TOTPOP,POPPSQMI)
  VALUES (GEOM,COUNTY,FIPSSTCO,STATE,STATE_ABRV,FIPSST,LANDSQMI,TOTPOP,POPPSQMI);
END;
/
COMMIT;

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-110,36.997967,-110,35.662647,
-109.826279,35.662479,-109.826225,
35.51767,-109.843094,35.517864,
-109.842545,34.953148,-109.843948,
34.822533,-109.851135,34.822487,
-109.8498,34.647205,-109.864578,
34.560677,-109.846107,34.473427,
-109.848724,34.1259,-109.858734,
34.12595,-109.858543,34.067783,
-109.858627,33.777634,-109.891113,
33.777729,-109.891136,33.567802,
-109.884804,33.568184,-109.881218,
33.571369,-109.877525,33.559383,
-109.868073,33.562485,-109.867821,
33.557465,-109.853592,33.545193,
-109.846809,33.55014,-109.84568,
33.547897,-109.851997,33.539856,
-109.850136,33.535252,-109.848091,
33.534359,-109.844116,33.54089,
-109.844368,33.534016,-109.83651,
33.529163,-109.832939,33.531246,
-109.83252,33.535278,-109.829895,
33.535439,-109.828995,33.531845,
-109.822861,33.527836,-109.825485,
33.522587,-109.818466,33.520481,
-109.822899,33.509624,-109.818001,
33.510357,-109.812912,33.505363,
-109.803673,33.503826,-109.804932,
33.500507,-109.81321,33.5,
-109.812096,33.497055,-109.806091,
33.497532,-109.807114,33.489285,
-109.811646,33.488846,-109.811836,
33.484295,-109.805847,33.48484,
-109.802223,33.481842,-109.803841,
33.487507,-109.800262,33.48875,
-109.796043,33.483719,-109.791153,
33.485092,-109.783905,33.481689,
-109.782791,33.476456,-109.766113,
33.475533,-109.761795,33.477364,
-109.760727,33.481579,-109.753433,
33.481117,-109.746101,33.484715,
-109.745674,33.489616,-109.740891,
33.49379,-109.743576,33.50304,
-109.740059,33.509338,-109.727264,
33.516285,-109.730522,33.521484,
-109.724098,33.523251,-109.724258,
33.519653,-109.720345,33.519104,
-109.721001,33.522655,-109.712006,
33.525589,-109.715591,33.530743,
-109.708397,33.531155,-109.705879,
33.533264,-109.705803,33.539864,
-109.699837,33.534981,-109.695412,
33.539471,-109.690613,33.539337,
-109.690186,33.54174,-109.684441,
33.543324,-109.677956,33.552391,
-109.678688,33.556789,-109.664734,
33.555275,-109.665253,33.557911,
-109.671715,33.559769,-109.670181,
33.567303,-109.675789,33.569,
-109.673546,33.571335,-109.674942,
33.573212,-109.667053,33.578342,
-109.659866,33.5788,-109.659698,
33.583698,-109.652008,33.583263,
-109.64415,33.586033,-109.631233,
33.584541,-109.625786,33.589645,
-109.622185,33.583851,-109.61956,
33.583557,-109.614883,33.594048,
-109.60952,33.592701,-109.603607,
33.600857,-109.60627,33.607018,
-109.60408,33.612148,-109.597458,
33.610409,-109.597862,33.613155,
-109.589195,33.616386,-109.58503,
33.612999,-109.58046,33.613159,
-109.579086,33.615883,-109.581573,
33.618015,-109.577065,33.617786,
-109.561134,33.626385,-109.558006,
33.625832,-109.554062,33.620007,
-109.545723,33.620766,-109.546211,
33.618153,-109.543854,33.617027,
-109.539665,33.624496,-109.532303,
33.619522,-109.524277,33.61879,
-109.527458,33.623257,-109.51683,
33.635147,-109.518883,33.645775,
-109.513725,33.641788,-109.509979,
33.645267,-109.504662,33.643665,
-109.500488,33.652363,-109.494797,
33.652832,-109.489204,33.659061,
-109.489037,33.655121,-109.485817,
33.656631,-109.482994,33.654228,
-109.480827,33.655075,-109.485603,
33.661949,-109.482117,33.661377,
-109.478912,33.664627,-109.48333,
33.672527,-109.480644,33.683685,
-109.482948,33.686661,-109.479393,
33.687809,-109.480186,33.690807,
-109.474792,33.690102,-109.471504,
33.696835,-109.461121,33.692921,
-109.461037,33.696308,-109.445198,
33.708504,-109.448906,33.708565,
-109.448349,33.710949,-109.443031,
33.710537,-109.439667,33.7131,
-109.423195,33.710213,-109.421417,
33.711861,-109.413193,33.707901,
-109.409546,33.715733,-109.404366,
33.710346,-109.400337,33.717583,
-109.395294,33.712723,-109.394585,
33.71637,-109.379204,33.724125,
-109.368851,33.722431,-109.360382,
33.727982,-109.352432,33.724937,
-109.352325,33.729195,-109.364227,
33.739906,-109.361107,33.745956,
-109.362396,33.751724,-109.353905,
33.764755,-109.35495,33.76897,
-109.347076,33.77747,-109.04631,
33.778179,-109.045517,34.57925,
-109.045212,34.959682,-109.045319,
36.002327,-109.044571,36.999088,-110,
36.997967)),'Apache','04001',
'Arizona','AZ','04',11203.7578,61591,5.4973);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-109.113373,32.426102,-109.226601,
32.426399,-109.227203,32.4244,
-109.431396,32.427502,-110.169693,
32.426304,-110.450867,32.427284,
-110.450386,32.253727,-110.447144,
32.253731,-110.446686,32.211277,
-110.449081,32.079708,-110.450851,
32.077183,-110.451103,31.73118,
-110.451614,31.613844,-110.45993,
31.613947,-110.459984,31.612049,
-110.459534,31.333403,-110.263756,
31.333094,-109.999985,31.333044,
-109.049431,31.332397,-109.046997,
32.4263,-109.113373,32.426102)),
'Cochise','04003','Arizona','AZ','04',6168.9335,97624,15.825);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-111.412048,37.001514,-112,37.000977,
-112.539604,37.000683,-112.539383,
36.997334,-112.543243,36.996464,
-112.541672,36.992916,-112.544151,
36.993237,-112.543243,36.985245,
-112.538612,36.981949,-112.538559,
36.977898,-112.534454,36.975491,
-112.534653,36.97176,-112.532318,
36.971718,-112.530067,36.966927,
-112.531387,36.956604,-112.528618,
36.952484,-112.544937,36.937447,
-112.543625,36.930557,-112.544312,
36.927559,-112.547646,36.928177,
-112.545425,36.921265,-112.547707,
36.912773,-112.551811,36.915012,
-112.552666,36.906796,-112.556458,
36.906223,-112.562752,36.898968,
-112.566063,36.899059,-112.565323,
36.897297,-112.569313,36.89592,
-112.570045,36.888367,-112.573639,
36.886856,-112.571648,36.879028,
-112.576576,36.875,-112.57296,
36.87291,-112.577835,36.868305,
-112.574554,36.864918,-112.586121,
36.857979,-112.584755,36.854431,
-112.58757,36.849895,-112.584091,
36.847382,-112.592209,36.840599,
-112.592628,36.832451,-112.599434,
36.831715,-112.595757,36.826702,
-112.600113,36.824116,-112.600594,
36.816902,-112.598434,36.814983,
-112.599365,36.810291,-112.596664,
36.808964,-112.599937,36.806652,
-112.602158,36.808662,-112.605629,
36.807838,-112.602921,36.800034,
-112.60685,36.800671,-112.609497,
36.802319,-112.607925,36.797924,
-112.613823,36.797764,-112.611198,
36.795151,-112.61293,36.787209,
-112.619049,36.782925,-112.616135,
36.774776,-112.611839,36.77663,
-112.611763,36.774849,-112.617783,
36.769398,-112.620377,36.769741,
-112.620003,36.763992,-112.614845,
36.762577,-112.614334,36.757313,
-112.609467,36.755779,-112.610718,
36.752232,-112.616005,36.755001,
-112.616234,36.750473,-112.612991,
36.74913,-112.611343,36.742859,
-112.615829,36.744621,-112.617516,
36.741348,-112.613762,36.740685,
-112.6119,36.737434,-112.614151,
36.73613,-112.617882,36.738735,
-112.62101,36.737888,-112.621033,
36.735096,-112.615891,36.734272,
-112.614342,36.727501,-112.619949,
36.730244,-112.622047,36.723511,
-112.615906,36.721523,-112.622475,
36.72065,-112.622955,36.717468,
-112.627312,36.716026,-112.623253,
36.710552,-112.62561,36.707211,
-112.630013,36.706207,-112.626518,
36.701534,-112.629623,36.695103,
-112.62812,36.692127,-112.633949,
36.686592,-112.632225,36.679836,
-112.63768,36.674526,-112.632355,
36.658089,-112.6269,36.654789,
-112.629852,36.65033,-112.625336,
36.648079,-112.628662,36.645863,
-112.627876,36.637829,-112.624138,
36.634708,-112.626152,36.629631,
-112.621773,36.626743,-112.62236,
36.61552,-112.617958,36.614449,
-112.621559,36.607693,-112.619202,
36.602451,-112.622833,36.599747,
-112.620247,36.595558,-112.625618,
36.593224,-112.621864,36.591686,
-112.628258,36.589725,-112.625427,
36.582531,-112.629089,36.581619,
-112.627213,36.577202,-112.633118,
36.577709,-112.634766,36.575809,
-112.63147,36.574455,-112.631737,
36.570656,-112.643456,36.571255,
-112.641014,36.566055,-112.647835,
36.564457,-112.647209,36.561275,
-112.655724,36.553928,-112.649422,
36.550331,-112.653198,36.546444,
-112.650963,36.544613,-112.659157,
36.543285,-112.659271,36.538406,
-112.655045,36.536919,-112.658714,
36.530304,-112.652527,36.529045,
-112.65477,36.521442,-112.651939,
36.518307,-112.655258,36.514713,
-112.651398,36.509399,-112.646095,
36.510475,-112.644226,36.508049,
-112.647041,36.503147,-112.640686,
36.50182,-112.64518,36.497192,
-112.642761,36.495838,-112.639839,
36.498177,-112.634598,36.491901,
-112.639732,36.488674,-112.634857,
36.484234,-112.628082,36.486679,
-112.624817,36.486149,-112.625725,
36.483658,-112.620956,36.484776,
-112.625099,36.479336,-112.62191,
36.474426,-112.630959,36.470127,
-112.628181,36.468937,-112.628181,
36.465,-112.632294,36.462299,
-112.6343,36.464066,-112.642639,
36.461067,-112.644112,36.457085,
-112.64077,36.456715,-112.639786,
36.448727,-112.646156,36.447014,
-112.641312,36.446232,-112.639221,
36.443165,-112.635849,36.443733,
-112.638489,36.439476,-112.645683,
36.440002,-112.641579,36.437214,
-112.643562,36.434326,-112.638802,
36.434486,-112.640556,36.43174,
-112.637589,36.424984,-112.628777,
36.428417,-112.630028,36.424019,
-112.626915,36.423172,-112.626633,
36.417606,-112.622948,36.414585,
-112.623787,36.406845,-112.630096,
36.401997,-112.628769,36.397213,
-112.631409,36.394833,-112.628746,
36.391636,-112.637856,36.389214,
-112.646454,36.383369,-112.652466,
36.361736,-112.667679,36.34663,
-112.680824,36.341679,-112.685509,
36.345238,-112.687851,36.35326,
-112.696739,36.355381,-112.721825,
36.346958,-112.725754,36.34206,
-112.719391,36.325188,-112.72213,
36.319992,-112.731049,36.31778,
-112.748283,36.325481,-112.755043,
36.324364,-112.760933,36.310066,
-112.765404,36.305729,-112.786728,
36.300838,-112.788574,36.288887,
-112.793007,36.284412,-112.797623,
36.283844,-112.811798,36.288582,
-112.823753,36.288361,-112.82888,
36.28706,-112.841545,36.276752,
-112.865784,36.282536,-112.875397,
36.278263,-112.883575,36.26384,
-112.897499,36.25478,-112.902199,
36.253731,-112.91433,36.25816,
-112.922653,36.257759,-112.929344,
36.246082,-112.934563,36.242802,
-112.980453,36.231789,-112.988953,
36.232578,-113.005585,36.238773,
-113.018349,36.236725,-113.037506,
36.226627,-113.052002,36.209385,
-113.094711,36.193584,-113.113335,
36.183243,-113.120598,36.173798,
-113.127251,36.169495,-113.136322,
36.166443,-113.148407,36.173695,
-113.15612,36.174324,-113.16217,
36.171761,-113.171806,36.16275,
-113.2005,36.149593,-113.204529,
36.133209,-113.200912,36.119061,
-113.215073,36.107632,-113.217682,
36.099396,-113.224159,36.09116,
-113.230377,36.089542,-113.245483,
36.093357,-113.256401,36.088516,
-113.276321,36.097057,-113.299828,
36.095749,-113.31266,36.100021,
-113.319206,36.096786,-113.322899,
36.090851,-113.330009,36.06834,
-113.345016,36.05677,-113.349571,
36.050495,-113.353409,36.040382,
-113.347595,36.01313,-113.339378,
36.0033,-113.339653,35.986633,
-113.333794,35.979465,-113.321075,
35.97596,-113.316498,35.968628,
-113.31826,35.965801,-113.31665,
35.960835,-113.327896,35.950153,
-113.324753,35.934666,-113.334091,
35.913868,-113.327095,35.9077,
-113.322128,35.898815,-113.310417,
35.893272,-113.308456,35.887341,
-113.311943,35.875,-113.30986,
35.862408,-113.3256,35.841999,
-113.325081,35.829865,-113.332504,
35.821693,-113.328743,35.813038,
-113.33326,35.803043,-113.333397,
35.528046,-113.304214,35.531143,
-113.279099,35.528984,-113.264442,
35.530087,-113.21804,35.508881,
-113.19838,35.510975,-113.171005,
35.505348,-113.154305,35.493301,
-113.147301,35.4786,-113.085304,
35.452999,-112.975113,35.392902,
-112.96302,35.381256,-112.952675,
35.35611,-112.944046,35.352604,
-112.88192,35.342422,-112.803352,
35.32531,-112.784317,35.315765,
-112.764122,35.313999,-112.754105,
35.306297,-112.733948,35.305065,
-112.694115,35.311581,-112.675636,
35.306717,-112.658371,35.291763,
-112.654732,35.291904,-112.643791,
35.299721,-112.630226,35.299953,
-112.622185,35.296043,-112.618027,
35.289951,-112.619888,35.274853,
-112.603264,35.269215,-112.576668,
35.243389,-112.541069,35.236328,
-112.5,35.24247,-112.47197,35.2383,
-112.465088,35.24752,-112.440018,
35.26046,-112.441566,35.149395,
-112.334991,35.148266,-112.333809,
34.973007,-112.322289,34.973022,
-111.808502,34.9762,-111.808601,
34.981098,-111.777107,34.9813,
-111.779106,34.8181,-111.777199,
34.803299,-111.551399,34.802502,
-111.55442,34.472172,-111.548088,
34.46085,-111.545692,34.465378,
-111.541176,34.465157,-111.542007,
34.471195,-111.538391,34.475433,
-111.535179,34.471882,-111.536171,
34.467674,-111.527267,34.470554,
-111.519547,34.481419,-111.523865,
34.494946,-111.520508,34.498955,
-111.518059,34.498646,-111.518501,
34.494698,-111.516373,34.494125,
-111.501289,34.498184,-111.512955,
34.491905,-111.509621,34.489063,
-111.513222,34.486362,-111.51255,
34.484413,-111.509369,34.483624,
-111.508118,34.479305,-111.511345,
34.48037,-111.511742,34.467812,
-111.519447,34.46685,-111.520958,
34.462555,-111.522919,34.463879,
-111.53157,34.460911,-111.539787,
34.456802,-111.539711,34.454823,
-111.535751,34.455345,-111.534653,
34.453648,-111.522499,34.455017,
-111.518974,34.458248,-111.516754,
34.455566,-111.508263,34.454636,
-111.496269,34.461208,-111.485199,
34.463757,-111.478958,34.460758,
-111.471352,34.462238,-111.470467,
34.45694,-111.474075,34.45911,
-111.479553,34.455788,-111.476341,
34.450447,-111.484344,34.454678,
-111.485344,34.452892,-111.488403,
34.454437,-111.488739,34.450417,
-111.492699,34.451916,-111.495285,
34.446716,-111.503128,34.444214,
-111.501122,34.442165,-111.505898,
34.438133,-111.512863,34.444401,
-111.517914,34.446423,-111.521217,
34.445354,-111.516785,34.444988,
-111.518311,34.441929,-111.515121,
34.440086,-111.518997,34.437237,
-111.517944,34.433208,-111.51696,
34.430363,-111.521919,34.427094,
-111.528984,34.435577,-111.527832,
34.423004,-111.534264,34.42347,
-111.53904,34.428631,-111.541031,
34.423939,-111.549576,34.419422,
-111.544968,34.415432,-111.541389,
34.416531,-111.535332,34.414455,
-111.535347,34.41188,-111.52317,
34.411587,-111.514458,34.414185,
-111.507797,34.422161,-111.502708,
34.422039,-111.499741,34.427551,
-111.4972,34.420593,-111.493195,
34.418377,-111.491165,34.422714,
-111.492867,34.434231,-111.490402,
34.430759,-111.486259,34.429787,
-111.483101,34.431381,-111.483696,
34.435074,-111.480278,34.433559,
-111.474281,34.43605,-111.476669,
34.431747,-111.466454,34.437714,
-111.476593,34.429462,-111.467018,
34.429523,-111.469658,34.428326,
-111.468826,34.426609,-111.478989,
34.42741,-111.481018,34.424755,
-111.480804,34.422764,-111.477005,
34.422455,-111.479919,34.419521,
-111.474838,34.416538,-111.47934,
34.415852,-111.478722,34.414349,
-111.466064,34.414051,-111.464401,
34.412418,-111.466446,34.409492,
-111.461197,34.411144,-111.463806,
34.415085,-111.459816,34.423134,
-111.459419,34.425125,-111.453079,
34.427044,-111.45443,34.430565,
-111.449738,34.431263,-111.450577,
34.43483,-111.442009,34.43396,
-111.443382,34.441383,-111.436134,
34.438316,-111.432762,34.439976,
-111.434906,34.44643,-111.43045,
34.444744,-111.425682,34.448235,
-111.418541,34.443382,-111.416573,
34.44516,-111.410721,34.442577,
-111.406555,34.444202,-111.406891,
34.446339,-111.400734,34.443008,
-111.397545,34.443741,-111.39782,
34.440144,-111.406647,34.438015,
-111.403404,34.430748,-111.406273,
34.427345,-111.410561,34.433453,
-111.417053,34.432629,-111.421242,
34.437214,-111.424751,34.435711,
-111.420639,34.432163,-111.426865,
34.420319,-111.423515,34.414127,
-111.427048,34.412895,-111.421356,
34.405979,-111.424034,34.394615,
-111.428581,34.390747,-111.425629,
34.386147,-111.420898,34.393581,
-111.422455,34.390572,-111.421181,
34.387726,-111.418488,34.388023,
-111.417793,34.376968,-111.41658,
34.380543,-111.411057,34.382236,
-111.40831,34.37711,-111.399979,
34.378723,-111.395866,34.38538,
-111.386887,34.387486,-111.383476,
34.390396,-111.388153,34.390911,
-111.388985,34.393673,-111.385727,
34.397774,-111.402702,34.397724,
-111.410561,34.40797,-111.408409,
34.410267,-111.405411,34.408619,
-111.400482,34.410828,-111.398529,
34.422604,-111.400146,34.4249,
-111.398041,34.427624,-111.396332,
34.42844,-111.396461,34.425884,
-111.392097,34.42371,-111.387466,
34.42458,-111.386742,34.429111,
-111.383247,34.430363,-111.384285,
34.432381,-111.378395,34.430786,
-111.376083,34.436211,-111.372314,
34.436871,-111.370979,34.439606,
-111.366158,34.440289,-111.36264,
34.436001,-111.351189,34.440968,
-111.349503,34.439915,-111.353668,
34.434887,-111.350861,34.432266,
-111.354515,34.429749,-111.354538,
34.425652,-111.349831,34.423218,
-111.346321,34.425236,-111.336472,
34.422112,-111.334976,34.423355,
-111.331291,34.424835,-111.32724,
34.421967,-111.323608,34.422565,
-111.320053,34.427738,-111.316956,
34.426376,-111.314156,34.42915,
-111.310051,34.426758,-111.306114,
34.434078,-111.300377,34.432423,
-111.296112,34.437176,-111.288269,
34.435955,-111.28627,34.439819,
-111.278442,34.439903,-111.277939,
34.438251,-111.272003,34.444485,
-111.261276,34.442795,-111.259422,
34.447678,-111.255791,34.446747,
-111.253365,34.452236,-111.251152,
34.451283,-111.25,34.453339,
-111.245407,34.450062,-111.243874,
34.446117,-111.247055,34.442173,
-111.244453,34.442352,-111.244377,
34.438343,-111.239899,34.437149,
-111.239204,34.431408,-111.235207,
34.429916,-111.226997,34.431728,
-111.225075,34.424706,-111.221466,
34.425621,-111.221176,34.418896,
-111.220413,34.415752,-111.21434,
34.417801,-111.213936,34.412899,
-111.211006,34.413334,-111.208878,
34.408329,-111.197845,34.409187,
-111.194382,34.404636,-111.182465,
34.410061,-111.180588,34.407906,
-111.177483,34.408321,-111.177139,
34.403671,-111.172256,34.405598,
-111.16964,34.401039,-111.163902,
34.404396,-111.160294,34.403786,
-111.159599,34.399845,-111.155075,
34.399078,-111.154503,34.395088,
-111.151375,34.39423,-111.151566,
34.388332,-111.14817,34.384808,
-111.150963,34.37896,-111.146408,
34.375153,-111.139595,34.375721,
-111.143051,34.377819,-111.13913,
34.385803,-111.135017,34.385368,
-111.134438,34.388256,-111.128853,
34.385181,-111.127357,34.39061,
-111.120407,34.38356,-111.115189,
34.385044,-111.10965,34.383614,
-111.110893,34.391483,-111.10128,
34.389496,-111.099525,34.393974,
-111.095116,34.396748,-111.094093,
34.393242,-111.086815,34.394962,
-111.083946,34.393154,-111.086906,
34.391411,-111.078941,34.389046,
-111.079536,34.385574,-111.075531,
34.386799,-111.076263,34.380638,
-111.071274,34.378429,-111.066338,
34.379944,-111.060341,34.377277,
-111.058258,34.3806,-111.053566,
34.378979,-111.050827,34.375481,
-111.052734,34.370708,-111.050308,
34.370369,-111.049889,34.37373,
-111.045898,34.375,-111.042984,
34.379593,-111.036659,34.371555,
-111.038956,34.370029,-111.04084,
34.371273,-111.05088,34.356991,
-111.056168,34.360332,-111.056618,
34.353436,-111.051994,34.352573,
-111.049316,34.347118,-111.043533,
34.342911,-111.032486,34.3409,
-111.028206,34.341202,-111.029793,
34.343288,-111.027557,34.346344,
-111.030647,34.349541,-111.025192,
34.353786,-111.033081,34.362461,
-111.026855,34.363335,-111.022865,
34.372372,-111.019463,34.373123,
-111.019852,34.361645,-111.013306,
34.361496,-111.009438,34.35844,
-111.007942,34.362408,-111.00528,
34.361031,-111.003036,34.356232,
-111.005234,34.351204,-110.998817,
34.349968,-110.99752,34.351624,
-110.996628,34.344093,-110.974731,
34.336605,-110.968033,34.323757,
-110.958176,34.31443,-110.952927,
34.313896,-110.950432,34.31876,
-110.945419,34.317245,-110.940948,
34.310608,-110.92646,34.310463,
-110.904976,34.300133,-110.89624,
34.302406,-110.894547,34.295452,
-110.886925,34.29311,-110.883171,
34.289532,-110.888039,34.286304,
-110.883179,34.280342,-110.864349,
34.270947,-110.852264,34.269966,
-110.846878,34.265594,-110.847206,
34.271034,-110.843338,34.26833,
-110.835075,34.269279,-110.825867,
34.275249,-110.825439,34.277641,
-110.830902,34.27684,-110.831848,
34.278454,-110.834145,34.275879,
-110.83429,34.279449,-110.837097,
34.280613,-110.819427,34.288574,
-110.823898,34.295353,-110.828644,
34.295769,-110.834114,34.300621,
-110.844643,34.303837,-110.84523,
34.307095,-110.837776,34.308784,
-110.833221,34.302921,-110.832024,
34.304131,-110.829857,34.301788,
-110.827438,34.303516,-110.824982,
34.301067,-110.823219,34.302525,
-110.823196,34.300274,-110.817719,
34.300095,-110.810631,34.295315,
-110.811127,34.303089,-110.808578,
34.302898,-110.807999,34.308121,
-110.804207,34.311234,-110.802139,
34.298012,-110.795326,34.299057,
-110.795059,34.307068,-110.792969,
34.304955,-110.787399,34.309021,
-110.786324,34.305622,-110.789101,
34.302921,-110.787331,34.29771,
-110.780495,34.307636,-110.782181,
34.299454,-110.763939,34.292397,
-110.760582,34.28783,-110.75721,
34.279297,-110.766022,34.268955,
-110.766289,34.258961,-110.76255,
34.258369,-110.75,34.263271,-110.75,
37.003201,-111.133018,37.00079,
-111.412048,37.001514)),'Coconino',
'04005','Arizona','AZ','04',18615.9375,96591,5.1886);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-111.55442,34.472172,-111.553513,
34.439255,-111.561592,34.434998,
-111.562088,34.432178,-111.571236,
34.429634,-111.572563,34.422993,
-111.580078,34.419464,-111.581902,
34.421387,-111.586937,34.420174,
-111.590607,34.422077,-111.592102,
34.419121,-111.595169,34.420719,
-111.600365,34.419254,-111.604233,
34.415703,-111.604095,34.411556,
-111.608208,34.409885,-111.610558,
34.405483,-111.614838,34.404907,
-111.618263,34.400623,-111.629776,
34.397373,-111.630196,34.393154,
-111.646576,34.39312,-111.648819,
34.389706,-111.658768,34.386387,
-111.656479,34.367718,-111.666733,
34.347561,-111.666763,34.343533,
-111.663811,34.341854,-111.665077,
34.331207,-111.662453,34.330288,
-111.661995,34.324471,-111.664696,
34.323441,-111.662544,34.322338,
-111.662788,34.317829,-111.668365,
34.310223,-111.667465,34.307819,
-111.672836,34.307728,-111.683968,
34.298477,-111.67646,34.28931,
-111.673309,34.294624,-111.664726,
34.29689,-111.66291,34.295105,
-111.664627,34.286217,-111.684441,
34.282097,-111.679741,34.271511,
-111.67572,34.268627,-111.680939,
34.261639,-111.689598,34.260017,
-111.689514,34.256168,-111.696655,
34.248676,-111.69735,34.245106,
-111.693207,34.242928,-111.700081,
34.239079,-111.697487,34.229847,
-111.703079,34.228336,-111.704681,
34.213928,-111.704185,34.212116,
-111.695305,34.211021,-111.689949,
34.204926,-111.6894,34.199703,
-111.696739,34.192852,-111.699821,
34.193405,-111.701889,34.197868,
-111.709915,34.199841,-111.711235,
34.197456,-111.706245,34.19125,
-111.709221,34.187191,-111.697197,
34.19022,-111.693619,34.187515,
-111.693649,34.182224,-111.704506,
34.181492,-111.705246,34.175468,
-111.714043,34.165569,-111.719078,
34.163895,-111.719574,34.159771,
-111.711502,34.151237,-111.477158,
34.151073,-111.493057,34.13274,
-111.490631,34.130848,-111.481285,
34.131554,-111.478912,34.130016,
-111.481293,34.125,-111.480141,
34.119076,-111.474281,34.118771,
-111.47068,34.111504,-111.48539,
34.09539,-111.477486,34.08709,
-111.478485,34.084164,-111.475571,
34.080364,-111.463699,34.072624,
-111.460785,34.063095,-111.462265,
34.059185,-111.471916,34.05817,
-111.46801,34.047798,-111.47113,
34.042393,-111.483192,34.040176,
-111.48642,34.035706,-111.492554,
34.038063,-111.497055,34.029171,
-111.494461,34.023506,-111.496742,
34.018467,-111.495239,34.01405,
-111.499763,34.008579,-111.494087,
33.999779,-111.471741,34.004646,
-111.470009,34.002724,-111.465843,
34.005905,-111.457687,34.002167,
-111.453728,34.004711,-111.448708,
34.000111,-111.444389,34.001137,
-111.439766,33.99662,-111.442123,
33.991333,-111.433968,33.986767,
-111.432487,33.983562,-111.447403,
33.973244,-111.448196,33.968563,
-111.451866,33.965889,-111.451668,
33.960968,-111.447319,33.957748,
-111.451561,33.948929,-111.448616,
33.943558,-111.446381,33.934818,
-111.451355,33.933727,-111.448578,
33.929691,-111.450218,33.919834,
-111.436798,33.916134,-111.42524,
33.926067,-111.404381,33.919174,
-111.407913,33.911926,-111.40731,
33.905243,-111.412308,33.901413,
-111.410744,33.89156,-111.412697,
33.888367,-111.410515,33.883556,
-111.404831,33.882069,-111.404961,
33.879494,-111.395363,33.876892,
-111.395622,33.868523,-111.38652,
33.86245,-111.391632,33.854794,
-111.394783,33.841183,-111.389458,
33.837654,-111.391808,33.835857,
-111.382874,33.83358,-111.37188,
33.824211,-111.370834,33.81881,
-111.383553,33.816448,-111.387642,
33.805313,-111.377815,33.793671,
-111.382111,33.78809,-111.380508,
33.785183,-111.384773,33.783138,
-111.388763,33.776619,-111.38588,
33.773163,-111.388687,33.770763,
-111.386436,33.763187,-111.38147,
33.760918,-111.386131,33.75,
-111.380447,33.747616,-111.37233,
33.749298,-111.371445,33.745167,
-111.355606,33.738792,-111.354141,
33.7332,-111.351227,33.733475,
-111.335686,33.72031,-111.337929,
33.715855,-111.336327,33.708942,
-111.337639,33.702702,-111.330711,
33.688293,-111.325325,33.684334,
-111.314217,33.681347,-111.298836,
33.663776,-111.286507,33.658569,
-111.286514,33.651978,-111.272926,
33.638401,-111.268394,33.628933,
-111.257431,33.62104,-111.249542,
33.624462,-111.237679,33.618401,
-111.223007,33.602814,-111.206779,
33.620525,-111.208038,33.635029,
-111.1996,33.640209,-111.178925,
33.659828,-111.172859,33.660076,
-111.1688,33.667469,-111.152672,
33.677559,-111.03923,33.466053,
-110.974037,33.342041,-110.946022,
33.25,-110.782173,32.984612,
-110.764442,32.985989,-110.762901,
33.004631,-110.757225,33.004833,
-110.750465,33.010399,-110.746124,
33.010265,-110.744202,33.017185,
-110.737572,33.019478,-110.736809,
33.022343,-110.728546,33.026859,
-110.728111,33.035244,-110.723213,
33.042374,-110.715622,33.040657,
-110.715141,33.050598,-110.724831,
33.069317,-110.720421,33.072823,
-110.720238,33.075985,-110.712013,
33.077637,-110.71077,33.081257,
-110.705559,33.083603,-110.692345,
33.076813,-110.689003,33.078625,
-110.688507,33.08403,-110.694221,
33.086346,-110.689842,33.088886,
-110.682167,33.088154,-110.682907,
33.097847,-110.678871,33.101032,
-110.677132,33.111111,-110.672066,
33.111477,-110.664711,33.119999,
-110.661797,33.119198,-110.66114,
33.113491,-110.655861,33.113491,
-110.637947,33.133366,-110.633141,
33.142368,-110.608498,33.142693,
-110.597794,33.137772,-110.596489,
33.133968,-110.592484,33.133739,
-110.586136,33.137112,-110.580093,
33.143913,-110.580933,33.146572,
-110.568275,33.14465,-110.566292,
33.147697,-110.561386,33.148453,
-110.558029,33.155029,-110.549103,
33.152782,-110.549477,33.157936,
-110.544846,33.168819,-110.533485,
33.160339,-110.524155,33.159397,
-110.523552,33.161987,-110.526756,
33.163296,-110.529816,33.16153,
-110.534088,33.165218,-110.527573,
33.170788,-110.526405,33.176807,
-110.515617,33.175632,-110.50312,
33.186314,-110.479126,33.182213,
-110.464478,33.182491,-110.461494,
33.184811,-110.463585,33.192295,
-110.453285,33.197979,-110.45108,
33.194042,-110.448364,33.194469,
-110.445778,33.189789,-110.431984,
33.187656,-110.429085,33.190922,
-110.41996,33.193516,-110.418976,
33.191055,-110.407944,33.191978,
-110.405235,33.197403,-110.401932,
33.196175,-110.399864,33.198318,
-110.420609,33.216152,-110.416672,
33.227402,-110.421501,33.228615,
-110.427002,33.235878,-110.434593,
33.239136,-110.436134,33.251228,
-110.443146,33.255333,-110.443008,
33.262276,-110.448135,33.265251,
-110.448494,33.273979,-110.454193,
33.282112,-110.452805,33.290543,
-110.457222,33.292423,-110.456375,
33.295033,-110.44648,33.300259,
-110.450195,33.316433,-110.443481,
33.325897,-110.447815,33.34182,
-110.446922,33.34885,-110.44381,
33.352081,-110.451233,33.362186,
-110.449158,33.365875,-110.44146,
33.368736,-110.44075,33.381386,
-110.427231,33.387939,-110.419289,
33.385166,-110.41259,33.401291,
-110.408577,33.399162,-110.394096,
33.404266,-110.387794,33.402477,
-110.383583,33.40683,-110.381317,
33.402954,-110.36898,33.399429,
-110.368294,33.396564,-110.365456,
33.400253,-110.362427,33.398056,
-110.355927,33.404335,-110.351341,
33.403465,-110.350716,33.408279,
-110.346649,33.408005,-110.348061,
33.410431,-110.345253,33.416412,
-110.347244,33.420261,-110.340668,
33.421547,-110.341545,33.426357,
-110.329414,33.426975,-110.320229,
33.433002,-110.312881,33.433483,
-110.308952,33.430069,-110.30455,
33.431698,-110.302582,33.428696,
-110.294632,33.428925,-110.271919,
33.44191,-110.263702,33.435101,
-110.251923,33.438419,-110.245651,
33.436749,-110.2369,33.442158,
-110.233299,33.439663,-110.228104,
33.444061,-110.226677,33.440559,
-110.221519,33.440102,-110.217224,
33.435314,-110.20961,33.441845,
-110.205292,33.439255,-110.196846,
33.443012,-110.189438,33.441753,
-110.192413,33.446632,-110.189903,
33.451653,-110.181839,33.446568,
-110.181183,33.449657,-110.176079,
33.448261,-110.168289,33.451626,
-110.168861,33.46566,-110,33.465862,
-110,33.576931,-110,34,-110.75,34,
-110.75,34.263271,-110.76255,
34.258369,-110.766289,34.258961,
-110.766022,34.268955,-110.75721,
34.279297,-110.760582,34.28783,
-110.763939,34.292397,-110.782181,
34.299454,-110.780495,34.307636,
-110.787331,34.29771,-110.789101,
34.302921,-110.786324,34.305622,
-110.787399,34.309021,-110.792969,
34.304955,-110.795059,34.307068,
-110.795326,34.299057,-110.802139,
34.298012,-110.804207,34.311234,
-110.807999,34.308121,-110.808578,
34.302898,-110.811127,34.303089,
-110.810631,34.295315,-110.817719,
34.300095,-110.823196,34.300274,
-110.823219,34.302525,-110.824982,
34.301067,-110.827438,34.303516,
-110.829857,34.301788,-110.832024,
34.304131,-110.833221,34.302921,
-110.837776,34.308784,-110.84523,
34.307095,-110.844643,34.303837,
-110.834114,34.300621,-110.828644,
34.295769,-110.823898,34.295353,
-110.819427,34.288574,-110.837097,
34.280613,-110.83429,34.279449,
-110.834145,34.275879,-110.831848,
34.278454,-110.830902,34.27684,
-110.825439,34.277641,-110.825867,
34.275249,-110.835075,34.269279,
-110.843338,34.26833,-110.847206,
34.271034,-110.846878,34.265594,
-110.852264,34.269966,-110.864349,
34.270947,-110.883179,34.280342,
-110.888039,34.286304,-110.883171,
34.289532,-110.886925,34.29311,
-110.894547,34.295452,-110.89624,
34.302406,-110.904976,34.300133,
-110.92646,34.310463,-110.940948,
34.310608,-110.945419,34.317245,
-110.950432,34.31876,-110.952927,
34.313896,-110.958176,34.31443,
-110.968033,34.323757,-110.974731,
34.336605,-110.996628,34.344093,
-110.99752,34.351624,-110.998817,
34.349968,-111.005234,34.351204,
-111.003036,34.356232,-111.00528,
34.361031,-111.007942,34.362408,
-111.009438,34.35844,-111.013306,
34.361496,-111.019852,34.361645,
-111.019463,34.373123,-111.022865,
34.372372,-111.026855,34.363335,
-111.033081,34.362461,-111.025192,
34.353786,-111.030647,34.349541,
-111.027557,34.346344,-111.029793,
34.343288,-111.028206,34.341202,
-111.032486,34.3409,-111.043533,
34.342911,-111.049316,34.347118,
-111.051994,34.352573,-111.056618,
34.353436,-111.056168,34.360332,
-111.05088,34.356991,-111.04084,
34.371273,-111.038956,34.370029,
-111.036659,34.371555,-111.042984,
34.379593,-111.045898,34.375,
-111.049889,34.37373,-111.050308,
34.370369,-111.052734,34.370708,
-111.050827,34.375481,-111.053566,
34.378979,-111.058258,34.3806,
-111.060341,34.377277,-111.066338,
34.379944,-111.071274,34.378429,
-111.076263,34.380638,-111.075531,
34.386799,-111.079536,34.385574,
-111.078941,34.389046,-111.086906,
34.391411,-111.083946,34.393154,
-111.086815,34.394962,-111.094093,
34.393242,-111.095116,34.396748,
-111.099525,34.393974,-111.10128,
34.389496,-111.110893,34.391483,
-111.10965,34.383614,-111.115189,
34.385044,-111.120407,34.38356,
-111.127357,34.39061,-111.128853,
34.385181,-111.134438,34.388256,
-111.135017,34.385368,-111.13913,
34.385803,-111.143051,34.377819,
-111.139595,34.375721,-111.146408,
34.375153,-111.150963,34.37896,
-111.14817,34.384808,-111.151566,
34.388332,-111.151375,34.39423,
-111.154503,34.395088,-111.155075,
34.399078,-111.159599,34.399845,
-111.160294,34.403786,-111.163902,
34.404396,-111.16964,34.401039,
-111.172256,34.405598,-111.177139,
34.403671,-111.177483,34.408321,
-111.180588,34.407906,-111.182465,
34.410061,-111.194382,34.404636,
-111.197845,34.409187,-111.208878,
34.408329,-111.211006,34.413334,
-111.213936,34.412899,-111.21434,
34.417801,-111.220413,34.415752,
-111.221176,34.418896,-111.221466,
34.425621,-111.225075,34.424706,
-111.226997,34.431728,-111.235207,
34.429916,-111.239204,34.431408,
-111.239899,34.437149,-111.244377,
34.438343,-111.244453,34.442352,
-111.247055,34.442173,-111.243874,
34.446117,-111.245407,34.450062,
-111.25,34.453339,-111.251152,
34.451283,-111.253365,34.452236,
-111.255791,34.446747,-111.259422,
34.447678,-111.261276,34.442795,
-111.272003,34.444485,-111.277939,
34.438251,-111.278442,34.439903,
-111.28627,34.439819,-111.288269,
34.435955,-111.296112,34.437176,
-111.300377,34.432423,-111.306114,
34.434078,-111.310051,34.426758,
-111.314156,34.42915,-111.316956,
34.426376,-111.320053,34.427738,
-111.323608,34.422565,-111.32724,
34.421967,-111.331291,34.424835,
-111.334976,34.423355,-111.336472,
34.422112,-111.346321,34.425236,
-111.349831,34.423218,-111.354538,
34.425652,-111.354515,34.429749,
-111.350861,34.432266,-111.353668,
34.434887,-111.349503,34.439915,
-111.351189,34.440968,-111.36264,
34.436001,-111.366158,34.440289,
-111.370979,34.439606,-111.372314,
34.436871,-111.376083,34.436211,
-111.378395,34.430786,-111.384285,
34.432381,-111.383247,34.430363,
-111.386742,34.429111,-111.387466,
34.42458,-111.392097,34.42371,
-111.396461,34.425884,-111.396332,
34.42844,-111.398041,34.427624,
-111.400146,34.4249,-111.398529,
34.422604,-111.400482,34.410828,
-111.405411,34.408619,-111.408409,
34.410267,-111.410561,34.40797,
-111.402702,34.397724,-111.385727,
34.397774,-111.388985,34.393673,
-111.388153,34.390911,-111.383476,
34.390396,-111.386887,34.387486,
-111.395866,34.38538,-111.399979,
34.378723,-111.40831,34.37711,
-111.411057,34.382236,-111.41658,
34.380543,-111.417793,34.376968,
-111.418488,34.388023,-111.421181,
34.387726,-111.422455,34.390572,
-111.420898,34.393581,-111.425629,
34.386147,-111.428581,34.390747,
-111.424034,34.394615,-111.421356,
34.405979,-111.427048,34.412895,
-111.423515,34.414127,-111.426865,
34.420319,-111.420639,34.432163,
-111.424751,34.435711,-111.421242,
34.437214,-111.417053,34.432629,
-111.410561,34.433453,-111.406273,
34.427345,-111.403404,34.430748,
-111.406647,34.438015,-111.39782,
34.440144,-111.397545,34.443741,
-111.400734,34.443008,-111.406891,
34.446339,-111.406555,34.444202,
-111.410721,34.442577,-111.416573,
34.44516,-111.418541,34.443382,
-111.425682,34.448235,-111.43045,
34.444744,-111.434906,34.44643,
-111.432762,34.439976,-111.436134,
34.438316,-111.443382,34.441383,
-111.442009,34.43396,-111.450577,
34.43483,-111.449738,34.431263,
-111.45443,34.430565,-111.453079,
34.427044,-111.459419,34.425125,
-111.459816,34.423134,-111.463806,
34.415085,-111.461197,34.411144,
-111.466446,34.409492,-111.464401,
34.412418,-111.466064,34.414051,
-111.478722,34.414349,-111.47934,
34.415852,-111.474838,34.416538,
-111.479919,34.419521,-111.477005,
34.422455,-111.480804,34.422764,
-111.481018,34.424755,-111.478989,
34.42741,-111.468826,34.426609,
-111.469658,34.428326,-111.467018,
34.429523,-111.476593,34.429462,
-111.466454,34.437714,-111.476669,
34.431747,-111.474281,34.43605,
-111.480278,34.433559,-111.483696,
34.435074,-111.483101,34.431381,
-111.486259,34.429787,-111.490402,
34.430759,-111.492867,34.434231,
-111.491165,34.422714,-111.493195,
34.418377,-111.4972,34.420593,
-111.499741,34.427551,-111.502708,
34.422039,-111.507797,34.422161,
-111.514458,34.414185,-111.52317,
34.411587,-111.535347,34.41188,
-111.535332,34.414455,-111.541389,
34.416531,-111.544968,34.415432,
-111.549576,34.419422,-111.541031,
34.423939,-111.53904,34.428631,
-111.534264,34.42347,-111.527832,
34.423004,-111.528984,34.435577,
-111.521919,34.427094,-111.51696,
34.430363,-111.517944,34.433208,
-111.518997,34.437237,-111.515121,
34.440086,-111.518311,34.441929,
-111.516785,34.444988,-111.521217,
34.445354,-111.517914,34.446423,
-111.512863,34.444401,-111.505898,
34.438133,-111.501122,34.442165,
-111.503128,34.444214,-111.495285,
34.446716,-111.492699,34.451916,
-111.488739,34.450417,-111.488403,
34.454437,-111.485344,34.452892,
-111.484344,34.454678,-111.476341,
34.450447,-111.479553,34.455788,
-111.474075,34.45911,-111.470467,
34.45694,-111.471352,34.462238,
-111.478958,34.460758,-111.485199,
34.463757,-111.496269,34.461208,
-111.508263,34.454636,-111.516754,
34.455566,-111.518974,34.458248,
-111.522499,34.455017,-111.534653,
34.453648,-111.535751,34.455345,
-111.539711,34.454823,-111.539787,
34.456802,-111.53157,34.460911,
-111.522919,34.463879,-111.520958,
34.462555,-111.519447,34.46685,
-111.511742,34.467812,-111.511345,
34.48037,-111.508118,34.479305,
-111.509369,34.483624,-111.51255,
34.484413,-111.513222,34.486362,
-111.509621,34.489063,-111.512955,
34.491905,-111.501289,34.498184,
-111.516373,34.494125,-111.518501,
34.494698,-111.518059,34.498646,
-111.520508,34.498955,-111.523865,
34.494946,-111.519547,34.481419,
-111.527267,34.470554,-111.536171,
34.467674,-111.535179,34.471882,
-111.538391,34.475433,-111.542007,
34.471195,-111.541176,34.465157,
-111.545692,34.465378,-111.548088,
34.46085,-111.55442,34.472172)),
'Gila','04007','Arizona','AZ','04',4767.2539,40216,8.4358);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-110,33.576931,-110,33.465862,
-110.168861,33.46566,-110.168289,
33.451626,-110.176079,33.448261,
-110.181183,33.449657,-110.181839,
33.446568,-110.189903,33.451653,
-110.192413,33.446632,-110.189438,
33.441753,-110.196846,33.443012,
-110.205292,33.439255,-110.20961,
33.441845,-110.217224,33.435314,
-110.221519,33.440102,-110.226677,
33.440559,-110.228104,33.444061,
-110.233299,33.439663,-110.2369,
33.442158,-110.245651,33.436749,
-110.251923,33.438419,-110.263702,
33.435101,-110.271919,33.44191,
-110.294632,33.428925,-110.302582,
33.428696,-110.30455,33.431698,
-110.308952,33.430069,-110.312881,
33.433483,-110.320229,33.433002,
-110.329414,33.426975,-110.341545,
33.426357,-110.340668,33.421547,
-110.347244,33.420261,-110.345253,
33.416412,-110.348061,33.410431,
-110.346649,33.408005,-110.350716,
33.408279,-110.351341,33.403465,
-110.355927,33.404335,-110.362427,
33.398056,-110.365456,33.400253,
-110.368294,33.396564,-110.36898,
33.399429,-110.381317,33.402954,
-110.383583,33.40683,-110.387794,
33.402477,-110.394096,33.404266,
-110.408577,33.399162,-110.41259,
33.401291,-110.419289,33.385166,
-110.427231,33.387939,-110.44075,
33.381386,-110.44146,33.368736,
-110.449158,33.365875,-110.451233,
33.362186,-110.44381,33.352081,
-110.446922,33.34885,-110.447815,
33.34182,-110.443481,33.325897,
-110.450195,33.316433,-110.44648,
33.300259,-110.456375,33.295033,
-110.457222,33.292423,-110.452805,
33.290543,-110.454193,33.282112,
-110.448494,33.273979,-110.448135,
33.265251,-110.443008,33.262276,
-110.443146,33.255333,-110.436134,
33.251228,-110.434593,33.239136,
-110.427002,33.235878,-110.421501,
33.228615,-110.416672,33.227402,
-110.420609,33.216152,-110.399864,
33.198318,-110.401932,33.196175,
-110.405235,33.197403,-110.407944,
33.191978,-110.418976,33.191055,
-110.41996,33.193516,-110.429085,
33.190922,-110.431984,33.187656,
-110.445778,33.189789,-110.448364,
33.194469,-110.447929,32.625,
-110.448517,32.513721,-110.450577,
32.513737,-110.450867,32.427284,
-110.169693,32.426304,-109.431396,
32.427502,-109.227203,32.4244,
-109.226601,32.426399,-109.113373,
32.426102,-109.225456,32.529022,
-109.225334,32.542957,-109.210648,
32.584221,-109.218864,32.60162,
-109.205635,32.635731,-109.212341,
32.653561,-109.213219,32.680595,
-109.247551,32.750153,-109.251747,
32.750172,-109.317528,32.842712,
-109.332802,32.843201,-109.49511,
33.078346,-109.494797,33.652832,
-109.500488,33.652363,-109.504662,
33.643665,-109.509979,33.645267,
-109.513725,33.641788,-109.518883,
33.645775,-109.51683,33.635147,
-109.527458,33.623257,-109.524277,
33.61879,-109.532303,33.619522,
-109.539665,33.624496,-109.543854,
33.617027,-109.546211,33.618153,
-109.545723,33.620766,-109.554062,
33.620007,-109.558006,33.625832,
-109.561134,33.626385,-109.577065,
33.617786,-109.581573,33.618015,
-109.579086,33.615883,-109.58046,
33.613159,-109.58503,33.612999,
-109.589195,33.616386,-109.597862,
33.613155,-109.597458,33.610409,
-109.60408,33.612148,-109.60627,
33.607018,-109.603607,33.600857,
-109.60952,33.592701,-109.614883,
33.594048,-109.61956,33.583557,
-109.622185,33.583851,-109.625786,
33.589645,-109.631233,33.584541,
-109.64415,33.586033,-109.652008,
33.583263,-109.659698,33.583698,
-109.659866,33.5788,-109.667053,
33.578342,-109.674942,33.573212,
-109.673546,33.571335,-109.675789,
33.569,-109.670181,33.567303,
-109.671715,33.559769,-109.665253,
33.557911,-109.664734,33.555275,
-109.678688,33.556789,-109.677956,
33.552391,-109.684441,33.543324,
-109.690186,33.54174,-109.690613,
33.539337,-109.695412,33.539471,
-109.699837,33.534981,-109.705803,
33.539864,-109.705879,33.533264,
-109.708397,33.531155,-109.715591,
33.530743,-109.712006,33.525589,
-109.721001,33.522655,-109.720345,
33.519104,-109.724258,33.519653,
-109.724098,33.523251,-109.730522,
33.521484,-109.727264,33.516285,
-109.740059,33.509338,-109.743576,
33.50304,-109.740891,33.49379,
-109.745674,33.489616,-109.746101,
33.484715,-109.753433,33.481117,
-109.760727,33.481579,-109.761795,
33.477364,-109.766113,33.475533,
-109.782791,33.476456,-109.783905,
33.481689,-109.791153,33.485092,
-109.796043,33.483719,-109.800262,
33.48875,-109.803841,33.487507,
-109.802223,33.481842,-109.805847,
33.48484,-109.811836,33.484295,
-109.811646,33.488846,-109.807114,
33.489285,-109.806091,33.497532,
-109.812096,33.497055,-109.81321,
33.5,-109.804932,33.500507,
-109.803673,33.503826,-109.812912,
33.505363,-109.818001,33.510357,
-109.822899,33.509624,-109.818466,
33.520481,-109.825485,33.522587,
-109.822861,33.527836,-109.828995,
33.531845,-109.829895,33.535439,
-109.83252,33.535278,-109.832939,
33.531246,-109.83651,33.529163,
-109.844368,33.534016,-109.844116,
33.54089,-109.848091,33.534359,
-109.850136,33.535252,-109.851997,
33.539856,-109.84568,33.547897,
-109.846809,33.55014,-109.853592,
33.545193,-109.867821,33.557465,
-109.868073,33.562485,-109.877525,
33.559383,-109.881218,33.571369,
-109.884804,33.568184,-109.891136,
33.567802,-109.895744,33.56789,
-109.897079,33.57362,-109.899925,
33.575432,-109.913414,33.575916,
-109.92292,33.567623,-109.937309,
33.570557,-109.94117,33.568474,
-109.949623,33.573284,-109.958984,
33.572437,-109.961555,33.579948,
-109.965492,33.578571,-109.966209,
33.572498,-109.968727,33.577354,
-109.980629,33.576206,-109.983009,
33.579002,-109.993629,33.582573,-110,
33.576931)),'Graham','04009',
'Arizona','AZ','04',4628.8476,26554,5.7366);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-109.494797,33.652832,-109.49511,
33.078346,-109.332802,32.843201,
-109.317528,32.842712,-109.251747,
32.750172,-109.247551,32.750153,
-109.213219,32.680595,-109.212341,
32.653561,-109.205635,32.635731,
-109.218864,32.60162,-109.210648,
32.584221,-109.225334,32.542957,
-109.225456,32.529022,-109.113373,
32.426102,-109.046997,32.4263,
-109.046494,32.7775,-109.046616,
33.2089,-109.04631,33.778179,
-109.347076,33.77747,-109.35495,
33.76897,-109.353905,33.764755,
-109.362396,33.751724,-109.361107,
33.745956,-109.364227,33.739906,
-109.352325,33.729195,-109.352432,
33.724937,-109.360382,33.727982,
-109.368851,33.722431,-109.379204,
33.724125,-109.394585,33.71637,
-109.395294,33.712723,-109.400337,
33.717583,-109.404366,33.710346,
-109.409546,33.715733,-109.413193,
33.707901,-109.421417,33.711861,
-109.423195,33.710213,-109.439667,
33.7131,-109.443031,33.710537,
-109.448349,33.710949,-109.448906,
33.708565,-109.445198,33.708504,
-109.461037,33.696308,-109.461121,
33.692921,-109.471504,33.696835,
-109.474792,33.690102,-109.480186,
33.690807,-109.479393,33.687809,
-109.482948,33.686661,-109.480644,
33.683685,-109.48333,33.672527,
-109.478912,33.664627,-109.482117,
33.661377,-109.485603,33.661949,
-109.480827,33.655075,-109.482994,
33.654228,-109.485817,33.656631,
-109.489037,33.655121,-109.489204,
33.659061,-109.494797,33.652832)),
'Greenlee','04011','Arizona','AZ','04',1846.8193,8008,4.3361);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-114.137505,34.303215,-114.135887,
34.274364,-114.130432,34.262714,
-114.132484,34.25845,-114.163864,
34.259686,-114.163086,34.253338,
-114.165344,34.25,-114.173813,
34.247288,-114.177269,34.239956,
-114.210976,34.211525,-114.224419,
34.203629,-114.224159,34.193878,
-114.228935,34.186913,-114.239929,
34.183216,-114.256248,34.172825,
-114.267677,34.170162,-114.274483,
34.172134,-114.286514,34.170517,
-114.319992,34.138618,-114.335327,
34.134022,-114.352249,34.133102,
-114.365738,34.118561,-114.378448,
34.115971,-114.389778,34.110069,
-114.400818,34.111637,-114.410896,
34.110016,-114.419708,34.103451,
-114.432594,34.088394,-114.434639,
34.079712,-114.438553,34.057877,
-114.434158,34.037769,-114.437477,
34.022591,-114.449417,34.012562,
-114.46508,34.010971,-114.466522,
34.005177,-114.458397,34,-114.45784,
33.995541,-114.46714,33.992859,
-114.4991,33.961773,-114.507881,
33.957508,-114.515076,33.958088,
-114.522339,33.954647,-114.534691,
33.934635,-114.532906,33.925076,
-114.517647,33.9175,-114.510719,
33.911076,-114.507126,33.90379,
-114.507919,33.900623,-114.512924,
33.897942,-114.523499,33.901569,
-114.525078,33.900215,-114.521973,
33.892563,-114.503006,33.876053,
-114.502625,33.866432,-114.513885,
33.85862,-114.524879,33.859985,
-114.529816,33.855419,-114.51918,
33.825363,-114.521927,33.818958,
-114.527267,33.814945,-114.504074,
33.760445,-114.503693,33.75098,
-114.511559,33.734192,-114.495773,
33.719135,-114.493408,33.707901,
-114.494926,33.698433,-114.52317,
33.685856,-114.530739,33.675087,
-114.52948,33.666801,-114.513275,
33.660156,-114.517555,33.655903,
-114.529793,33.654442,-114.53241,
33.651634,-114.523018,33.634678,
-114.525581,33.630238,-114.530251,
33.628189,-114.530426,33.623886,
-114.521057,33.612518,-114.528397,
33.606628,-114.539833,33.591389,
-114.539513,33.580593,-114.536003,
33.570934,-114.523819,33.552204,
-114.558113,33.531796,-114.560173,
33.516712,-114.568741,33.509193,
-114.579681,33.506439,-114.591583,
33.49865,-114.600914,33.481369,
-114.622131,33.456535,-114.621498,
33.447529,-114.626335,33.433525,
-114.634392,33.422699,-114.64875,
33.413605,-114.657593,33.41301,
-114.673111,33.41827,-114.687157,
33.417915,-114.694862,33.415096,
-114.700943,33.40836,-114.719269,
33.407864,-114.724747,33.404026,
-114.70652,33.382511,-114.706558,
33.376598,-114.698265,33.361118,
-114.69725,33.352413,-114.700142,
33.336983,-114.707169,33.323391,
-114.722832,33.312077,-114.730431,
33.302402,-114.720879,33.286949,
-114.693657,33.279755,-114.679718,
33.273544,-114.671295,33.258465,
-114.688751,33.246395,-114.672836,
33.223087,-114.677963,33.203415,
-114.674568,33.185455,-114.679459,
33.169682,-114.678566,33.159485,
-114.686287,33.142159,-114.696037,
33.131172,-114.705383,33.105297,
-114.707031,33.091064,-114.703934,
33.087013,-114.688232,33.084,
-114.686203,33.07093,-114.673508,
33.057133,-114.672874,33.041859,
-114.66153,33.032631,-114.657043,
33.033787,-114.645195,33.048862,
-114.638771,33.045254,-114.627502,
33.031013,-114.617996,33.027164,
-114.588989,33.026192,-114.583977,
33.028191,-114.577507,33.035336,
-114.570869,33.036587,-114.530296,
33.032356,-114.515671,33.027576,
-114.370743,33.027451,-114.37001,
33.029976,-114.267975,33.029778,
-114.267036,33.463547,-113.957275,
33.464622,-113.957283,33.377544,
-113.333176,33.377388,-113.333,
33.999199,-113.332748,34.317856,
-113.342461,34.318874,-113.340729,
34.312309,-113.349785,34.300629,
-113.358299,34.294975,-113.368484,
34.291946,-113.38578,34.294861,
-113.397942,34.30022,-113.411217,
34.294334,-113.419868,34.299126,
-113.43248,34.301483,-113.448174,
34.299469,-113.465393,34.30402,
-113.471207,34.301846,-113.475296,
34.305389,-113.480614,34.303078,
-113.488564,34.305134,-113.497742,
34.30254,-113.5065,34.304745,
-113.515518,34.310177,-113.522888,
34.308758,-113.525536,34.310474,
-113.534203,34.308071,-113.539139,
34.305878,-113.543747,34.299763,
-113.547859,34.288433,-113.567825,
34.274696,-113.568382,34.269314,
-113.581261,34.259777,-113.585968,
34.243378,-113.596458,34.237164,
-113.598618,34.233322,-113.604919,
34.229332,-113.606598,34.231621,
-113.61145,34.230953,-113.616852,
34.227264,-113.625969,34.229027,
-113.637794,34.223194,-113.641922,
34.227524,-113.644653,34.220722,
-113.647545,34.222008,-113.654495,
34.216473,-113.658241,34.217274,
-113.663231,34.212009,-113.674606,
34.213108,-113.67775,34.209812,
-113.705078,34.212124,-113.709129,
34.216675,-113.713013,34.217545,
-113.715225,34.221916,-113.721725,
34.222626,-113.731575,34.240997,
-113.749458,34.23914,-113.773788,
34.228905,-113.780273,34.229172,
-113.790665,34.234051,-113.801964,
34.236118,-113.811813,34.231808,
-113.815727,34.235332,-113.82132,
34.226723,-113.834557,34.223145,
-113.838181,34.22477,-113.848228,
34.240398,-113.849808,34.25,
-113.854523,34.252625,-113.871742,
34.254929,-113.892097,34.249329,
-113.904694,34.248337,-113.928329,
34.249344,-113.938789,34.254841,
-113.962578,34.258121,-114.007828,
34.25412,-114.01609,34.259567,
-114.021843,34.267586,-114.030167,
34.260075,-114.036346,34.260788,
-114.036613,34.265942,-114.044472,
34.267773,-114.049026,34.277016,
-114.058121,34.280704,-114.066643,
34.290272,-114.084785,34.294621,
-114.090805,34.299042,-114.099976,
34.299297,-114.110809,34.295033,
-114.127609,34.304089,-114.137505,
34.303215)),'LaPaz','04012',
'Arizona','AZ','04',4498.7968,13844,3.0772);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-113.333,33.999199,-113.333176,
33.377388,-113.33316,32.504883,
-112.577148,32.505131,-112.203026,
32.506702,-112.201263,33.086971,
-112.202591,33.310383,-112.192894,
33.298431,-112.196815,33.288929,
-112.195007,33.284081,-112.19693,
33.27787,-112.190735,33.264446,
-112.180351,33.262527,-112.173729,
33.263554,-112.173454,33.258049,
-112.168945,33.259682,-112.159683,
33.253902,-112.148323,33.253822,
-112.13958,33.247116,-112.138702,
33.243519,-112.134262,33.242119,
-112.131027,33.23307,-112.125793,
33.235474,-112.121521,33.234741,
-112.113167,33.227482,-112.099327,
33.230968,-112.094505,33.229984,
-112.088966,33.225151,-112.087517,
33.220276,-112.091339,33.208912,
-112.082802,33.204514,-111.892349,
33.204765,-111.892319,33.203201,
-111.582062,33.205433,-111.583603,
33.378601,-111.580002,33.378601,
-111.579933,33.465855,-111.25,
33.464851,-111.03923,33.466053,
-111.152672,33.677559,-111.1688,
33.667469,-111.172859,33.660076,
-111.178925,33.659828,-111.1996,
33.640209,-111.208038,33.635029,
-111.206779,33.620525,-111.223007,
33.602814,-111.237679,33.618401,
-111.249542,33.624462,-111.257431,
33.62104,-111.268394,33.628933,
-111.272926,33.638401,-111.286514,
33.651978,-111.286507,33.658569,
-111.298836,33.663776,-111.314217,
33.681347,-111.325325,33.684334,
-111.330711,33.688293,-111.337639,
33.702702,-111.336327,33.708942,
-111.337929,33.715855,-111.335686,
33.72031,-111.351227,33.733475,
-111.354141,33.7332,-111.355606,
33.738792,-111.371445,33.745167,
-111.37233,33.749298,-111.380447,
33.747616,-111.386131,33.75,
-111.38147,33.760918,-111.386436,
33.763187,-111.388687,33.770763,
-111.38588,33.773163,-111.388763,
33.776619,-111.384773,33.783138,
-111.380508,33.785183,-111.382111,
33.78809,-111.377815,33.793671,
-111.387642,33.805313,-111.383553,
33.816448,-111.370834,33.81881,
-111.37188,33.824211,-111.382874,
33.83358,-111.391808,33.835857,
-111.389458,33.837654,-111.394783,
33.841183,-111.391632,33.854794,
-111.38652,33.86245,-111.395622,
33.868523,-111.395363,33.876892,
-111.404961,33.879494,-111.404831,
33.882069,-111.410515,33.883556,
-111.412697,33.888367,-111.410744,
33.89156,-111.412308,33.901413,
-111.40731,33.905243,-111.407913,
33.911926,-111.404381,33.919174,
-111.42524,33.926067,-111.436798,
33.916134,-111.450218,33.919834,
-111.448578,33.929691,-111.451355,
33.933727,-111.446381,33.934818,
-111.448616,33.943558,-111.451561,
33.948929,-111.447319,33.957748,
-111.451668,33.960968,-111.451866,
33.965889,-111.448196,33.968563,
-111.447403,33.973244,-111.432487,
33.983562,-111.433968,33.986767,
-111.442123,33.991333,-111.439766,
33.99662,-111.444389,34.001137,
-111.448708,34.000111,-111.453728,
34.004711,-111.457687,34.002167,
-111.465843,34.005905,-111.470009,
34.002724,-111.471741,34.004646,
-111.494087,33.999779,-111.724609,
33.999813,-112.163795,34.048107,
-112.160675,34.042263,-112.157402,
34.043842,-112.153107,34.041416,
-112.164085,34.035919,-112.160812,
34.017094,-112.164619,34.012764,
-112.170692,34.017761,-112.182213,
34.012814,-112.179665,34.004246,
-112.192619,33.991184,-112.196159,
33.973911,-112.20108,33.970592,
-112.213921,33.967403,-112.214134,
33.963554,-112.23085,33.95446,
-112.24044,33.956287,-112.239471,
33.949074,-112.235626,33.947609,
-112.240646,33.940346,-112.235321,
33.939888,-112.230972,33.935448,
-112.234505,33.916363,-112.242737,
33.91534,-112.24015,33.909321,
-112.242325,33.905502,-112.258018,
33.904819,-112.274467,33.892937,
-112.276901,33.889801,-112.275322,
33.882278,-112.743217,33.999866,
-112.770905,33.999886,-113.333,
33.999199)),'Maricopa','04013',
'Arizona','AZ','04',9202.4687,2122100,230.6011);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-112.898598,37.000401,-113.484375,37,
-114.049797,37.000423,-114.049812,
36.843151,-114.049789,36.654728,
-114.045029,36.442993,-114.047722,
36.289616,-114.046051,36.194084,
-114.059509,36.189381,-114.06723,
36.180679,-114.085175,36.147228,
-114.091377,36.140053,-114.099075,
36.12167,-114.110214,36.119892,
-114.122353,36.111591,-114.122421,
36.104759,-114.116661,36.100906,
-114.113739,36.09523,-114.121094,
36.086819,-114.136101,36.059479,
-114.137405,36.041302,-114.146011,
36.035141,-114.147392,36.028027,
-114.153336,36.023876,-114.165672,
36.027752,-114.176025,36.027664,
-114.191582,36.021008,-114.212898,
36.015629,-114.232491,36.014305,
-114.251854,36.020206,-114.265923,
36.029251,-114.272362,36.046417,
-114.279404,36.046375,-114.290733,
36.050343,-114.297493,36.056911,
-114.30999,36.057281,-114.314751,
36.059513,-114.313408,36.066635,
-114.304939,36.074902,-114.307632,
36.082458,-114.327972,36.105518,
-114.336472,36.108036,-114.345154,
36.11834,-114.362305,36.130264,
-114.371307,36.143131,-114.375,
36.144188,-114.382011,36.141682,
-114.404671,36.147388,-114.413826,
36.146717,-114.426361,36.136326,
-114.445801,36.125988,-114.452522,
36.130745,-114.457558,36.138603,
-114.46283,36.139717,-114.469345,
36.138821,-114.486221,36.129417,
-114.502373,36.126961,-114.507072,
36.128162,-114.509941,36.132504,
-114.5009,36.143394,-114.51091,
36.150974,-114.531731,36.148201,
-114.539169,36.152199,-114.571213,
36.15163,-114.581261,36.146271,
-114.596397,36.142124,-114.615883,
36.130119,-114.621071,36.132153,
-114.627037,36.141033,-114.630905,
36.142326,-114.636368,36.13607,
-114.659134,36.124168,-114.664597,
36.116722,-114.672081,36.116371,
-114.678917,36.110672,-114.683167,
36.109684,-114.693024,36.11319,
-114.702637,36.109024,-114.735352,
36.104389,-114.751305,36.092278,
-114.754799,36.087189,-114.754669,
36.081623,-114.742531,36.070557,
-114.73465,36.056702,-114.74276,
36.044575,-114.743065,36.040241,
-114.733017,36.038124,-114.721046,
36.031425,-114.723289,36.026711,
-114.737961,36.015079,-114.742226,
36.008663,-114.739059,35.992733,
-114.74276,35.983742,-114.727501,
35.956306,-114.730347,35.943935,
-114.706711,35.928082,-114.707703,
35.912331,-114.699455,35.901787,
-114.670967,35.877407,-114.661797,
35.873299,-114.661598,35.869598,
-114.670998,35.865101,-114.682404,
35.8629,-114.689301,35.859699,
-114.693604,35.854198,-114.703796,
35.8517,-114.704201,35.844898,
-114.695602,35.833801,-114.695,
35.829601,-114.702904,35.814602,
-114.711304,35.806198,-114.698105,
35.790199,-114.7006,35.7691,
-114.693604,35.756901,-114.697197,
35.751301,-114.696701,35.7328,
-114.704597,35.708302,-114.700401,
35.701199,-114.682404,35.6894,
-114.679802,35.685501,-114.689201,
35.6647,-114.688599,35.651424,
-114.676308,35.641499,-114.664597,
35.621899,-114.657402,35.619099,
-114.652603,35.610802,-114.653503,
35.597599,-114.658798,35.587502,
-114.674706,35.580002,-114.666901,
35.574001,-114.662598,35.564701,
-114.661201,35.545502,-114.656105,
35.534401,-114.663399,35.5219,
-114.668106,35.521301,-114.675201,
35.515499,-114.6782,35.502117,
-114.676842,35.489754,-114.672096,
35.481716,-114.673058,35.475544,
-114.665573,35.466866,-114.666878,
35.460411,-114.662315,35.445923,
-114.654846,35.437759,-114.652618,
35.430603,-114.626335,35.409512,
-114.619423,35.392864,-114.617165,
35.379665,-114.603516,35.353588,
-114.595131,35.325241,-114.596703,
35.296959,-114.586327,35.262379,
-114.57917,35.209644,-114.57132,
35.200592,-114.568443,35.183479,
-114.571953,35.138729,-114.577728,
35.128754,-114.583504,35.125,
-114.59832,35.121052,-114.61805,
35.121723,-114.627632,35.118942,
-114.645958,35.101871,-114.638733,
35.094482,-114.621719,35.088703,
-114.612335,35.083096,-114.603935,
35.074833,-114.602112,35.068588,
-114.605896,35.058941,-114.626328,
35.04472,-114.633949,35.03373,
-114.637222,35.017128,-114.632217,
35.002083,-114.62822,34.986149,
-114.634438,34.965149,-114.628967,
34.943039,-114.632454,34.924606,
-114.630081,34.907261,-114.635925,
34.889103,-114.632256,34.869968,
-114.623146,34.859737,-114.599854,
34.847355,-114.586044,34.835667,
-114.575653,34.815296,-114.570213,
34.794289,-114.551888,34.766869,
-114.528824,34.750816,-114.515823,
34.73674,-114.491226,34.725697,
-114.48671,34.716621,-114.470192,
34.712208,-114.464455,34.691196,
-114.449715,34.666828,-114.457191,
34.657104,-114.440674,34.642525,
-114.437943,34.621449,-114.423409,
34.610443,-114.424545,34.600834,
-114.436012,34.596066,-114.421593,
34.5807,-114.404442,34.56963,
-114.380051,34.529713,-114.377335,
34.507275,-114.381569,34.495747,
-114.380913,34.476028,-114.38591,
34.457901,-114.372925,34.446926,
-114.336685,34.450905,-114.330978,
34.44664,-114.325928,34.437843,
-114.300232,34.426796,-114.29261,
34.41951,-114.290367,34.409771,
-114.286018,34.405327,-114.262131,
34.40036,-114.23349,34.376648,
-114.225327,34.365906,-114.198692,
34.361359,-114.176125,34.349293,
-114.168022,34.3395,-114.156425,
34.317848,-114.137505,34.303215,
-114.127609,34.304089,-114.110809,
34.295033,-114.099976,34.299297,
-114.090805,34.299042,-114.084785,
34.294621,-114.066643,34.290272,
-114.058121,34.280704,-114.049026,
34.277016,-114.044472,34.267773,
-114.036613,34.265942,-114.036346,
34.260788,-114.030167,34.260075,
-114.021843,34.267586,-114.01609,
34.259567,-114.007828,34.25412,
-113.962578,34.258121,-113.938789,
34.254841,-113.928329,34.249344,
-113.904694,34.248337,-113.892097,
34.249329,-113.871742,34.254929,
-113.854523,34.252625,-113.849808,
34.25,-113.848228,34.240398,
-113.838181,34.22477,-113.834557,
34.223145,-113.82132,34.226723,
-113.815727,34.235332,-113.811813,
34.231808,-113.801964,34.236118,
-113.790665,34.234051,-113.780273,
34.229172,-113.773788,34.228905,
-113.749458,34.23914,-113.731575,
34.240997,-113.721725,34.222626,
-113.715225,34.221916,-113.713013,
34.217545,-113.709129,34.216675,
-113.705078,34.212124,-113.67775,
34.209812,-113.674606,34.213108,
-113.663231,34.212009,-113.658241,
34.217274,-113.654495,34.216473,
-113.647545,34.222008,-113.644653,
34.220722,-113.641922,34.227524,
-113.637794,34.223194,-113.625969,
34.229027,-113.616852,34.227264,
-113.61145,34.230953,-113.606598,
34.231621,-113.604919,34.229332,
-113.598618,34.233322,-113.596458,
34.237164,-113.585968,34.243378,
-113.581261,34.259777,-113.568382,
34.269314,-113.567825,34.274696,
-113.547859,34.288433,-113.543747,
34.299763,-113.539139,34.305878,
-113.534203,34.308071,-113.525536,
34.310474,-113.522888,34.308758,
-113.515518,34.310177,-113.5065,
34.304745,-113.497742,34.30254,
-113.488564,34.305134,-113.480614,
34.303078,-113.475296,34.305389,
-113.471207,34.301846,-113.465393,
34.30402,-113.448174,34.299469,
-113.43248,34.301483,-113.419868,
34.299126,-113.411217,34.294334,
-113.397942,34.30022,-113.38578,
34.294861,-113.368484,34.291946,
-113.358299,34.294975,-113.349785,
34.300629,-113.340729,34.312309,
-113.342461,34.318874,-113.332748,
34.317856,-113.333397,35.528046,
-113.33326,35.803043,-113.328743,
35.813038,-113.332504,35.821693,
-113.325081,35.829865,-113.3256,
35.841999,-113.30986,35.862408,
-113.311943,35.875,-113.308456,
35.887341,-113.310417,35.893272,
-113.322128,35.898815,-113.327095,
35.9077,-113.334091,35.913868,
-113.324753,35.934666,-113.327896,
35.950153,-113.31665,35.960835,
-113.31826,35.965801,-113.316498,
35.968628,-113.321075,35.97596,
-113.333794,35.979465,-113.339653,
35.986633,-113.339378,36.0033,
-113.347595,36.01313,-113.353409,
36.040382,-113.349571,36.050495,
-113.345016,36.05677,-113.330009,
36.06834,-113.322899,36.090851,
-113.319206,36.096786,-113.31266,
36.100021,-113.299828,36.095749,
-113.276321,36.097057,-113.256401,
36.088516,-113.245483,36.093357,
-113.230377,36.089542,-113.224159,
36.09116,-113.217682,36.099396,
-113.215073,36.107632,-113.200912,
36.119061,-113.204529,36.133209,
-113.2005,36.149593,-113.171806,
36.16275,-113.16217,36.171761,
-113.15612,36.174324,-113.148407,
36.173695,-113.136322,36.166443,
-113.127251,36.169495,-113.120598,
36.173798,-113.113335,36.183243,
-113.094711,36.193584,-113.052002,
36.209385,-113.037506,36.226627,
-113.018349,36.236725,-113.005585,
36.238773,-112.988953,36.232578,
-112.980453,36.231789,-112.934563,
36.242802,-112.929344,36.246082,
-112.922653,36.257759,-112.91433,
36.25816,-112.902199,36.253731,
-112.897499,36.25478,-112.883575,
36.26384,-112.875397,36.278263,
-112.865784,36.282536,-112.841545,
36.276752,-112.82888,36.28706,
-112.823753,36.288361,-112.811798,
36.288582,-112.797623,36.283844,
-112.793007,36.284412,-112.788574,
36.288887,-112.786728,36.300838,
-112.765404,36.305729,-112.760933,
36.310066,-112.755043,36.324364,
-112.748283,36.325481,-112.731049,
36.31778,-112.72213,36.319992,
-112.719391,36.325188,-112.725754,
36.34206,-112.721825,36.346958,
-112.696739,36.355381,-112.687851,
36.35326,-112.685509,36.345238,
-112.680824,36.341679,-112.667679,
36.34663,-112.652466,36.361736,
-112.646454,36.383369,-112.637856,
36.389214,-112.628746,36.391636,
-112.631409,36.394833,-112.628769,
36.397213,-112.630096,36.401997,
-112.623787,36.406845,-112.622948,
36.414585,-112.626633,36.417606,
-112.626915,36.423172,-112.630028,
36.424019,-112.628777,36.428417,
-112.637589,36.424984,-112.640556,
36.43174,-112.638802,36.434486,
-112.643562,36.434326,-112.641579,
36.437214,-112.645683,36.440002,
-112.638489,36.439476,-112.635849,
36.443733,-112.639221,36.443165,
-112.641312,36.446232,-112.646156,
36.447014,-112.639786,36.448727,
-112.64077,36.456715,-112.644112,
36.457085,-112.642639,36.461067,
-112.6343,36.464066,-112.632294,
36.462299,-112.628181,36.465,
-112.628181,36.468937,-112.630959,
36.470127,-112.62191,36.474426,
-112.625099,36.479336,-112.620956,
36.484776,-112.625725,36.483658,
-112.624817,36.486149,-112.628082,
36.486679,-112.634857,36.484234,
-112.639732,36.488674,-112.634598,
36.491901,-112.639839,36.498177,
-112.642761,36.495838,-112.64518,
36.497192,-112.640686,36.50182,
-112.647041,36.503147,-112.644226,
36.508049,-112.646095,36.510475,
-112.651398,36.509399,-112.655258,
36.514713,-112.651939,36.518307,
-112.65477,36.521442,-112.652527,
36.529045,-112.658714,36.530304,
-112.655045,36.536919,-112.659271,
36.538406,-112.659157,36.543285,
-112.650963,36.544613,-112.653198,
36.546444,-112.649422,36.550331,
-112.655724,36.553928,-112.647209,
36.561275,-112.647835,36.564457,
-112.641014,36.566055,-112.643456,
36.571255,-112.631737,36.570656,
-112.63147,36.574455,-112.634766,
36.575809,-112.633118,36.577709,
-112.627213,36.577202,-112.629089,
36.581619,-112.625427,36.582531,
-112.628258,36.589725,-112.621864,
36.591686,-112.625618,36.593224,
-112.620247,36.595558,-112.622833,
36.599747,-112.619202,36.602451,
-112.621559,36.607693,-112.617958,
36.614449,-112.62236,36.61552,
-112.621773,36.626743,-112.626152,
36.629631,-112.624138,36.634708,
-112.627876,36.637829,-112.628662,
36.645863,-112.625336,36.648079,
-112.629852,36.65033,-112.6269,
36.654789,-112.632355,36.658089,
-112.63768,36.674526,-112.632225,
36.679836,-112.633949,36.686592,
-112.62812,36.692127,-112.629623,
36.695103,-112.626518,36.701534,
-112.630013,36.706207,-112.62561,
36.707211,-112.623253,36.710552,
-112.627312,36.716026,-112.622955,
36.717468,-112.622475,36.72065,
-112.615906,36.721523,-112.622047,
36.723511,-112.619949,36.730244,
-112.614342,36.727501,-112.615891,
36.734272,-112.621033,36.735096,
-112.62101,36.737888,-112.617882,
36.738735,-112.614151,36.73613,
-112.6119,36.737434,-112.613762,
36.740685,-112.617516,36.741348,
-112.615829,36.744621,-112.611343,
36.742859,-112.612991,36.74913,
-112.616234,36.750473,-112.616005,
36.755001,-112.610718,36.752232,
-112.609467,36.755779,-112.614334,
36.757313,-112.614845,36.762577,
-112.620003,36.763992,-112.620377,
36.769741,-112.617783,36.769398,
-112.611763,36.774849,-112.611839,
36.77663,-112.616135,36.774776,
-112.619049,36.782925,-112.61293,
36.787209,-112.611198,36.795151,
-112.613823,36.797764,-112.607925,
36.797924,-112.609497,36.802319,
-112.60685,36.800671,-112.602921,
36.800034,-112.605629,36.807838,
-112.602158,36.808662,-112.599937,
36.806652,-112.596664,36.808964,
-112.599365,36.810291,-112.598434,
36.814983,-112.600594,36.816902,
-112.600113,36.824116,-112.595757,
36.826702,-112.599434,36.831715,
-112.592628,36.832451,-112.592209,
36.840599,-112.584091,36.847382,
-112.58757,36.849895,-112.584755,
36.854431,-112.586121,36.857979,
-112.574554,36.864918,-112.577835,
36.868305,-112.57296,36.87291,
-112.576576,36.875,-112.571648,
36.879028,-112.573639,36.886856,
-112.570045,36.888367,-112.569313,
36.89592,-112.565323,36.897297,
-112.566063,36.899059,-112.562752,
36.898968,-112.556458,36.906223,
-112.552666,36.906796,-112.551811,
36.915012,-112.547707,36.912773,
-112.545425,36.921265,-112.547646,
36.928177,-112.544312,36.927559,
-112.543625,36.930557,-112.544937,
36.937447,-112.528618,36.952484,
-112.531387,36.956604,-112.530067,
36.966927,-112.532318,36.971718,
-112.534653,36.97176,-112.534454,
36.975491,-112.538559,36.977898,
-112.538612,36.981949,-112.543243,
36.985245,-112.544151,36.993237,
-112.541672,36.992916,-112.543243,
36.996464,-112.539383,36.997334,
-112.539604,37.000683,-112.898598,
37.000401)),'Mohave','04015',
'Arizona','AZ','04',13310.1328,93497,7.0244);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-110.75,37.003201,-110.75,34.263271,
-110.75,34,-110,34,-110,33.576931,
-109.993629,33.582573,-109.983009,
33.579002,-109.980629,33.576206,
-109.968727,33.577354,-109.966209,
33.572498,-109.965492,33.578571,
-109.961555,33.579948,-109.958984,
33.572437,-109.949623,33.573284,
-109.94117,33.568474,-109.937309,
33.570557,-109.92292,33.567623,
-109.913414,33.575916,-109.899925,
33.575432,-109.897079,33.57362,
-109.895744,33.56789,-109.891136,
33.567802,-109.891113,33.777729,
-109.858627,33.777634,-109.858543,
34.067783,-109.858734,34.12595,
-109.848724,34.1259,-109.846107,
34.473427,-109.864578,34.560677,
-109.8498,34.647205,-109.851135,
34.822487,-109.843948,34.822533,
-109.842545,34.953148,-109.843094,
35.517864,-109.826225,35.51767,
-109.826279,35.662479,-110,35.662647,
-110,36.997967,-110.469505,36.998001,
-110.5,37.004265,-110.75,37.003201)),
'Navajo','04017','Arizona','AZ','04',9952.0937,77658,7.8031);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-113.33316,32.504883,-113.333031,
32.039032,-112.969223,31.925663,
-111.365921,31.425982,-111.365959,
31.521202,-111.163078,31.521736,
-111.163536,31.725897,-110.85495,
31.726566,-110.854996,31.731609,
-110.451103,31.73118,-110.450851,
32.077183,-110.449081,32.079708,
-110.446686,32.211277,-110.447144,
32.253731,-110.450386,32.253727,
-110.450867,32.427284,-110.450577,
32.513737,-110.844261,32.513695,
-110.844292,32.511139,-110.964134,
32.510658,-111.156387,32.511875,
-111.15638,32.501591,-111.189583,
32.501244,-111.568573,32.501324,
-111.568581,32.506702,-112.203026,
32.506702,-112.577148,32.505131,
-113.33316,32.504883)),'Pima',
'04019','Arizona','AZ','04',9185.4296,666880,72.6018);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-111.03923,33.466053,-111.25,
33.464851,-111.579933,33.465855,
-111.580002,33.378601,-111.583603,
33.378601,-111.582062,33.205433,
-111.892319,33.203201,-111.892349,
33.204765,-112.082802,33.204514,
-112.091339,33.208912,-112.087517,
33.220276,-112.088966,33.225151,
-112.094505,33.229984,-112.099327,
33.230968,-112.113167,33.227482,
-112.121521,33.234741,-112.125793,
33.235474,-112.131027,33.23307,
-112.134262,33.242119,-112.138702,
33.243519,-112.13958,33.247116,
-112.148323,33.253822,-112.159683,
33.253902,-112.168945,33.259682,
-112.173454,33.258049,-112.173729,
33.263554,-112.180351,33.262527,
-112.190735,33.264446,-112.19693,
33.27787,-112.195007,33.284081,
-112.196815,33.288929,-112.192894,
33.298431,-112.202591,33.310383,
-112.201263,33.086971,-112.203026,
32.506702,-111.568581,32.506702,
-111.568573,32.501324,-111.189583,
32.501244,-111.15638,32.501591,
-111.156387,32.511875,-110.964134,
32.510658,-110.844292,32.511139,
-110.844261,32.513695,-110.450577,
32.513737,-110.448517,32.513721,
-110.447929,32.625,-110.448364,
33.194469,-110.45108,33.194042,
-110.453285,33.197979,-110.463585,
33.192295,-110.461494,33.184811,
-110.464478,33.182491,-110.479126,
33.182213,-110.50312,33.186314,
-110.515617,33.175632,-110.526405,
33.176807,-110.527573,33.170788,
-110.534088,33.165218,-110.529816,
33.16153,-110.526756,33.163296,
-110.523552,33.161987,-110.524155,
33.159397,-110.533485,33.160339,
-110.544846,33.168819,-110.549477,
33.157936,-110.549103,33.152782,
-110.558029,33.155029,-110.561386,
33.148453,-110.566292,33.147697,
-110.568275,33.14465,-110.580933,
33.146572,-110.580093,33.143913,
-110.586136,33.137112,-110.592484,
33.133739,-110.596489,33.133968,
-110.597794,33.137772,-110.608498,
33.142693,-110.633141,33.142368,
-110.637947,33.133366,-110.655861,
33.113491,-110.66114,33.113491,
-110.661797,33.119198,-110.664711,
33.119999,-110.672066,33.111477,
-110.677132,33.111111,-110.678871,
33.101032,-110.682907,33.097847,
-110.682167,33.088154,-110.689842,
33.088886,-110.694221,33.086346,
-110.688507,33.08403,-110.689003,
33.078625,-110.692345,33.076813,
-110.705559,33.083603,-110.71077,
33.081257,-110.712013,33.077637,
-110.720238,33.075985,-110.720421,
33.072823,-110.724831,33.069317,
-110.715141,33.050598,-110.715622,
33.040657,-110.723213,33.042374,
-110.728111,33.035244,-110.728546,
33.026859,-110.736809,33.022343,
-110.737572,33.019478,-110.744202,
33.017185,-110.746124,33.010265,
-110.750465,33.010399,-110.757225,
33.004833,-110.762901,33.004631,
-110.764442,32.985989,-110.782173,
32.984612,-110.946022,33.25,
-110.974037,33.342041,-111.03923,
33.466053)),'Pinal','04021',
'Arizona','AZ','04',5369.0703,116379,21.6757);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-111.365921,31.425982,-111.074387,
31.332207,-111.074181,31.33214,
-110.459534,31.333403,-110.459984,
31.612049,-110.45993,31.613947,
-110.451614,31.613844,-110.451103,
31.73118,-110.854996,31.731609,
-110.85495,31.726566,-111.163536,
31.725897,-111.163078,31.521736,
-111.365959,31.521202,-111.365921,
31.425982)),'SantaCruz','04023',
'Arizona','AZ','04',1237.5341,29676,23.9799);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-113.333397,35.528046,-113.332748,
34.317856,-113.333,33.999199,
-112.770905,33.999886,-112.743217,
33.999866,-112.275322,33.882278,
-112.276901,33.889801,-112.274467,
33.892937,-112.258018,33.904819,
-112.242325,33.905502,-112.24015,
33.909321,-112.242737,33.91534,
-112.234505,33.916363,-112.230972,
33.935448,-112.235321,33.939888,
-112.240646,33.940346,-112.235626,
33.947609,-112.239471,33.949074,
-112.24044,33.956287,-112.23085,
33.95446,-112.214134,33.963554,
-112.213921,33.967403,-112.20108,
33.970592,-112.196159,33.973911,
-112.192619,33.991184,-112.179665,
34.004246,-112.182213,34.012814,
-112.170692,34.017761,-112.164619,
34.012764,-112.160812,34.017094,
-112.164085,34.035919,-112.153107,
34.041416,-112.157402,34.043842,
-112.160675,34.042263,-112.163795,
34.048107,-111.724609,33.999813,
-111.494087,33.999779,-111.499763,
34.008579,-111.495239,34.01405,
-111.496742,34.018467,-111.494461,
34.023506,-111.497055,34.029171,
-111.492554,34.038063,-111.48642,
34.035706,-111.483192,34.040176,
-111.47113,34.042393,-111.46801,
34.047798,-111.471916,34.05817,
-111.462265,34.059185,-111.460785,
34.063095,-111.463699,34.072624,
-111.475571,34.080364,-111.478485,
34.084164,-111.477486,34.08709,
-111.48539,34.09539,-111.47068,
34.111504,-111.474281,34.118771,
-111.480141,34.119076,-111.481293,
34.125,-111.478912,34.130016,
-111.481285,34.131554,-111.490631,
34.130848,-111.493057,34.13274,
-111.477158,34.151073,-111.711502,
34.151237,-111.719574,34.159771,
-111.719078,34.163895,-111.714043,
34.165569,-111.705246,34.175468,
-111.704506,34.181492,-111.693649,
34.182224,-111.693619,34.187515,
-111.697197,34.19022,-111.709221,
34.187191,-111.706245,34.19125,
-111.711235,34.197456,-111.709915,
34.199841,-111.701889,34.197868,
-111.699821,34.193405,-111.696739,
34.192852,-111.6894,34.199703,
-111.689949,34.204926,-111.695305,
34.211021,-111.704185,34.212116,
-111.704681,34.213928,-111.703079,
34.228336,-111.697487,34.229847,
-111.700081,34.239079,-111.693207,
34.242928,-111.69735,34.245106,
-111.696655,34.248676,-111.689514,
34.256168,-111.689598,34.260017,
-111.680939,34.261639,-111.67572,
34.268627,-111.679741,34.271511,
-111.684441,34.282097,-111.664627,
34.286217,-111.66291,34.295105,
-111.664726,34.29689,-111.673309,
34.294624,-111.67646,34.28931,
-111.683968,34.298477,-111.672836,
34.307728,-111.667465,34.307819,
-111.668365,34.310223,-111.662788,
34.317829,-111.662544,34.322338,
-111.664696,34.323441,-111.661995,
34.324471,-111.662453,34.330288,
-111.665077,34.331207,-111.663811,
34.341854,-111.666763,34.343533,
-111.666733,34.347561,-111.656479,
34.367718,-111.658768,34.386387,
-111.648819,34.389706,-111.646576,
34.39312,-111.630196,34.393154,
-111.629776,34.397373,-111.618263,
34.400623,-111.614838,34.404907,
-111.610558,34.405483,-111.608208,
34.409885,-111.604095,34.411556,
-111.604233,34.415703,-111.600365,
34.419254,-111.595169,34.420719,
-111.592102,34.419121,-111.590607,
34.422077,-111.586937,34.420174,
-111.581902,34.421387,-111.580078,
34.419464,-111.572563,34.422993,
-111.571236,34.429634,-111.562088,
34.432178,-111.561592,34.434998,
-111.553513,34.439255,-111.55442,
34.472172,-111.551399,34.802502,
-111.777199,34.803299,-111.779106,
34.8181,-111.777107,34.9813,
-111.808601,34.981098,-111.808502,
34.9762,-112.322289,34.973022,
-112.333809,34.973007,-112.334991,
35.148266,-112.441566,35.149395,
-112.440018,35.26046,-112.465088,
35.24752,-112.47197,35.2383,-112.5,
35.24247,-112.541069,35.236328,
-112.576668,35.243389,-112.603264,
35.269215,-112.619888,35.274853,
-112.618027,35.289951,-112.622185,
35.296043,-112.630226,35.299953,
-112.643791,35.299721,-112.654732,
35.291904,-112.658371,35.291763,
-112.675636,35.306717,-112.694115,
35.311581,-112.733948,35.305065,
-112.754105,35.306297,-112.764122,
35.313999,-112.784317,35.315765,
-112.803352,35.32531,-112.88192,
35.342422,-112.944046,35.352604,
-112.952675,35.35611,-112.96302,
35.381256,-112.975113,35.392902,
-113.085304,35.452999,-113.147301,
35.4786,-113.154305,35.493301,
-113.171005,35.505348,-113.19838,
35.510975,-113.21804,35.508881,
-113.264442,35.530087,-113.279099,
35.528984,-113.304214,35.531143,
-113.333397,35.528046)),'Yavapai',
'04025','Arizona','AZ','04',8122.1484,107714,13.2617);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-114.515671,33.027576,-114.507179,
33.019669,-114.50045,33.007519,
-114.492157,32.971741,-114.487839,
32.969906,-114.475754,32.975136,
-114.467827,32.971611,-114.467278,
32.955219,-114.479439,32.937889,
-114.480003,32.93364,-114.475853,
32.923588,-114.463196,32.912399,
-114.462112,32.905758,-114.468193,
32.845112,-114.493408,32.823189,
-114.50943,32.816376,-114.528847,
32.795433,-114.531647,32.776878,
-114.52607,32.75705,-114.538315,
32.756905,-114.538437,32.749767,
-114.563667,32.749508,-114.563728,
32.742252,-114.580956,32.742275,
-114.581001,32.734901,-114.614304,
32.734463,-114.614799,32.728401,
-114.616875,32.728168,-114.687737,
32.737545,-114.70079,32.745586,
-114.713737,32.730343,-114.718849,
32.718716,-114.748169,32.663486,
-114.748688,32.661732,-114.749405,
32.661156,-114.749908,32.66021,
-114.764114,32.648834,-114.764091,
32.648495,-114.76252,32.644566,
-114.763695,32.643753,-114.763596,
32.642616,-114.778427,32.63353,
-114.781166,32.625561,-114.781723,
32.625324,-114.781784,32.624252,
-114.789467,32.622047,-114.789986,
32.62183,-114.790092,32.621872,
-114.79039,32.621784,-114.79834,
32.624992,-114.79924,32.624603,
-114.806129,32.620216,-114.807251,
32.603123,-114.801567,32.599316,
-114.801582,32.599125,-114.800758,
32.598541,-114.798943,32.592129,
-114.803108,32.582787,-114.803139,
32.582443,-114.802498,32.580406,
-114.800682,32.578201,-114.801567,
32.577469,-114.801086,32.575958,
-114.812195,32.568657,-114.813034,
32.563251,-114.80835,32.558659,
-114.807663,32.558708,-114.796341,
32.566368,-114.792435,32.569408,
-114.792389,32.569046,-114.792023,
32.56929,-114.792076,32.566776,
-114.790756,32.556973,-114.792374,
32.553555,-114.792381,32.553097,
-114.792648,32.552967,-114.792976,
32.552277,-114.803162,32.547234,
-114.803612,32.542404,-114.801392,
32.536362,-114.812561,32.524132,
-114.809113,32.517925,-114.803253,
32.516434,-114.803253,32.516399,
-114.802879,32.516323,-114.801422,
32.513138,-114.803284,32.511631,
-114.803291,32.510319,-114.805222,
32.510063,-114.806938,32.508671,
-114.813484,32.507912,-114.813248,
32.503067,-114.811531,32.5,
-114.81282,32.494221,-113.403648,
32.060863,-113.333031,32.039032,
-113.33316,32.504883,-113.333176,
33.377388,-113.957283,33.377544,
-113.957275,33.464622,-114.267036,
33.463547,-114.267975,33.029778,
-114.37001,33.029976,-114.370743,
33.027451,-114.515671,33.027576)),
'Yuma','04027','Arizona','AZ','04',5513.4921,106895,19.3878);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.311928,37.897423,-122.311905,
37.8974,-122.297028,37.835888,
-122.300484,37.828487,-122.320709,
37.812698,-122.33107,37.797409,
-122.319229,37.779644,-122.274338,
37.763363,-122.240288,37.718468,
-122.213158,37.699226,-122.193909,
37.693802,-122.179611,37.686401,
-122.165794,37.672092,-122.155434,
37.651863,-122.151489,37.627693,
-122.145073,37.607956,-122.144089,
37.580826,-122.110535,37.52951,
-122.110535,37.510765,-122.117516,
37.508755,-122.108505,37.4977,
-122.080399,37.477901,-122.050171,
37.459068,-122.03511,37.465027,
-121.995598,37.4673,-121.978943,
37.460953,-121.958199,37.4646,
-121.9505,37.462898,-121.945702,
37.4636,-121.945999,37.4688,
-121.943802,37.469601,-121.942505,
37.465477,-121.93013,37.460709,
-121.931694,37.455605,-121.927376,
37.457455,-121.924187,37.454601,
-121.907722,37.463089,-121.889587,
37.468307,-121.887955,37.470749,
-121.879211,37.471657,-121.864197,
37.484699,-121.471603,37.482235,
-121.470871,37.481853,-121.468224,
37.489758,-121.484398,37.502602,
-121.492302,37.502499,-121.495003,
37.505001,-121.496506,37.513302,
-121.500999,37.5186,-121.497597,
37.522701,-121.503105,37.526001,
-121.521103,37.524899,-121.538597,
37.5299,-121.544701,37.5326,
-121.5494,37.539398,-121.555603,
37.542801,-121.555626,37.820335,
-121.6231,37.799198,-121.959702,
37.7187,-121.971397,37.7286,
-121.988907,37.7337,-121.9925,
37.738201,-122,37.739101,-122.010704,
37.747501,-122.009705,37.755199,
-121.996704,37.763302,-122.013,
37.7803,-122.029404,37.7878,
-122.044403,37.798199,-122.139702,
37.804699,-122.147705,37.813801,
-122.156601,37.817902,-122.165802,
37.813499,-122.184906,37.820801,
-122.184196,37.837101,-122.193001,
37.8409,-122.202705,37.851299,
-122.207703,37.8521,-122.220398,
37.865101,-122.215202,37.8689,
-122.216301,37.871799,-122.224701,
37.879299,-122.242996,37.883301,
-122.247803,37.887001,-122.248703,
37.893299,-122.251907,37.893501,
-122.255707,37.899601,-122.260307,
37.8997,-122.264801,37.904499,
-122.269997,37.905899,-122.287399,
37.897999,-122.309799,37.8979,
-122.311928,37.897423)),'Alameda',
'06001','California','CA','06',737.3569,1279182,1734.8203);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-119.903305,38.933414,-119.904205,
38.928181,-119.891113,38.91851,
-119.886299,38.918037,-119.878853,
38.899513,-119.883476,38.894299,
-119.878525,38.886631,-119.881798,
38.881084,-119.887794,38.879238,
-119.877357,38.87455,-119.876274,
38.870289,-119.879288,38.864872,
-119.892471,38.856792,-119.89975,
38.857506,-119.905296,38.855598,
-119.907478,38.834438,-119.9217,
38.830048,-119.922783,38.825043,
-119.920296,38.821831,-119.929932,
38.815277,-119.930511,38.812241,
-119.941505,38.802727,-119.942963,
38.796925,-119.938759,38.793655,
-119.945877,38.786491,-119.946915,
38.781734,-119.963936,38.776081,
-120.071373,38.702862,-120.071465,
38.510078,-120.071541,38.447166,
-120.065598,38.448257,-120.052612,
38.455685,-120.018982,38.433468,
-119.883736,38.356274,-119.86898,
38.367584,-119.853966,38.372566,
-119.836533,38.3825,-119.813683,
38.387604,-119.800659,38.401512,
-119.783478,38.404953,-119.778877,
38.407803,-119.769554,38.406754,
-119.75,38.417221,-119.708694,
38.417679,-119.697495,38.409313,
-119.692619,38.378986,-119.69902,
38.365303,-119.668518,38.348381,
-119.638199,38.326969,-119.636215,
38.327995,-119.630852,38.334827,
-119.631065,38.344292,-119.626907,
38.348141,-119.634567,38.353996,
-119.61602,38.364712,-119.605614,
38.367271,-119.61377,38.380043,
-119.617432,38.38192,-119.621086,
38.393963,-119.600204,38.405445,
-119.591408,38.398964,-119.582687,
38.397034,-119.579781,38.400578,
-119.568611,38.404091,-119.562027,
38.409088,-119.560364,38.419922,
-119.564789,38.422665,-119.569008,
38.434948,-119.561646,38.438679,
-119.555428,38.447556,-119.557983,
38.460529,-119.555229,38.469826,
-119.545074,38.474182,-119.541328,
38.481312,-119.544373,38.490124,
-119.541862,38.499783,-119.556511,
38.502228,-119.558205,38.505581,
-119.555214,38.516712,-119.559944,
38.525627,-119.565872,38.52536,
-119.567055,38.5378,-119.569992,
38.541821,-119.573105,38.540916,
-119.583298,38.552109,-119.586365,
38.558445,-119.585716,38.566154,
-119.589523,38.568768,-119.588303,
38.573654,-119.595016,38.581944,
-119.594543,38.590424,-119.598808,
38.593441,-119.607864,38.59481,
-119.611526,38.600574,-119.618065,
38.603619,-119.620071,38.614517,
-119.617462,38.619411,-119.618446,
38.624371,-119.615639,38.626003,
-119.61692,38.631744,-119.612129,
38.655865,-119.613655,38.665974,
-119.606422,38.666447,-119.59832,
38.670326,-119.590446,38.682201,
-119.590843,38.690228,-119.578491,
38.705757,-119.584435,38.713306,
-119.903305,38.933414)),'Alpine',
'06003','California','CA','06',738.5258,1113,1.507);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.071373,38.702862,-120.080589,
38.700367,-120.101982,38.706055,
-120.110992,38.705109,-120.121521,
38.695457,-120.122353,38.687027,
-120.115677,38.679871,-120.122108,
38.666721,-120.127495,38.665154,
-120.131218,38.6604,-120.134079,
38.654617,-120.130379,38.649906,
-120.135986,38.641308,-120.139473,
38.63826,-120.14463,38.639839,
-120.151382,38.638008,-120.157082,
38.633324,-120.177628,38.633858,
-120.190292,38.631245,-120.20079,
38.624763,-120.204216,38.627987,
-120.213455,38.628979,-120.21315,
38.622879,-120.220062,38.616016,
-120.222153,38.597191,-120.228073,
38.594925,-120.231941,38.586803,
-120.249664,38.584072,-120.259201,
38.577557,-120.265503,38.56509,
-120.264984,38.56118,-120.279465,
38.559174,-120.284889,38.556267,
-120.296593,38.556179,-120.301056,
38.5495,-120.31675,38.543442,
-120.336617,38.545654,-120.345009,
38.541744,-120.354683,38.547344,
-120.362808,38.54464,-120.37738,
38.544746,-120.382515,38.538734,
-120.387611,38.540543,-120.401382,
38.537712,-120.411934,38.531265,
-120.423988,38.530396,-120.432816,
38.52676,-120.441307,38.528858,
-120.448799,38.528591,-120.463974,
38.522778,-120.484207,38.5214,
-120.489944,38.517529,-120.509369,
38.511669,-120.53624,38.509483,
-120.552864,38.511887,-120.578743,
38.503513,-120.591438,38.5047,
-120.605682,38.502525,-120.611122,
38.504715,-120.627068,38.50322,
-120.649475,38.510094,-120.658615,
38.515816,-120.676178,38.517925,
-120.681938,38.526367,-120.689743,
38.527946,-120.703262,38.536091,
-120.705765,38.535107,-120.717857,
38.542103,-120.721413,38.54723,
-120.729515,38.548233,-120.735687,
38.545761,-120.73822,38.548393,
-120.746353,38.548454,-120.747406,
38.553535,-120.753273,38.55122,
-120.759239,38.554977,-120.767685,
38.552647,-120.77774,38.554455,
-120.783134,38.55098,-120.793152,
38.55764,-120.799332,38.556293,
-120.803436,38.55991,-120.809387,
38.557941,-120.811302,38.560001,
-120.808746,38.561462,-120.81192,
38.562244,-120.815445,38.558308,
-120.822121,38.559883,-120.823868,
38.556179,-120.83194,38.555927,
-120.83474,38.551647,-120.840591,
38.556152,-120.848259,38.550941,
-120.854897,38.548691,-120.855331,
38.542831,-120.861214,38.543243,
-120.862694,38.535324,-120.870293,
38.536625,-120.872574,38.542782,
-120.87542,38.543373,-120.882965,
38.536327,-120.87957,38.530926,
-120.884079,38.525024,-120.888458,
38.524776,-120.891747,38.529057,
-120.901848,38.531208,-120.904243,
38.52462,-120.907738,38.524185,
-120.90963,38.520756,-120.921867,
38.519199,-120.925385,38.514942,
-120.935463,38.51952,-120.939713,
38.528629,-120.950577,38.521351,
-120.957161,38.522766,-120.963654,
38.520344,-120.968964,38.520985,
-120.973328,38.515968,-120.986366,
38.516609,-120.993736,38.513695,-121,
38.518639,-121.006081,38.519199,
-121.010468,38.512482,-121.018303,
38.508846,-121.026306,38.50816,
-121.025185,38.298,-120.994469,
38.225536,-120.97097,38.217625,
-120.967827,38.220161,-120.962944,
38.219563,-120.952621,38.226231,
-120.935806,38.22057,-120.923592,
38.228107,-120.914528,38.229992,
-120.902039,38.222317,-120.89193,
38.221279,-120.887321,38.227985,
-120.881653,38.23064,-120.878578,
38.241001,-120.875504,38.23978,
-120.867332,38.245216,-120.855438,
38.247852,-120.849213,38.257137,
-120.845749,38.264359,-120.833786,
38.267754,-120.820999,38.275536,
-120.81665,38.28363,-120.809494,
38.281689,-120.806694,38.288807,
-120.802322,38.288952,-120.797432,
38.285675,-120.789497,38.288681,
-120.776604,38.287788,-120.766251,
38.290401,-120.753876,38.288353,
-120.750275,38.296574,-120.737183,
38.307838,-120.729897,38.308029,
-120.71154,38.315285,-120.687149,
38.31897,-120.673759,38.330795,
-120.671066,38.329266,-120.664207,
38.331642,-120.655373,38.33086,
-120.64547,38.334633,-120.637329,
38.340942,-120.630562,38.34005,
-120.626854,38.355835,-120.618607,
38.357834,-120.617477,38.366592,
-120.609024,38.370785,-120.613617,
38.372841,-120.616295,38.378384,
-120.613281,38.382664,-120.61422,
38.389275,-120.609589,38.391819,
-120.607857,38.397724,-120.574539,
38.401505,-120.569534,38.407475,
-120.570641,38.414021,-120.558983,
38.415234,-120.540436,38.422909,
-120.536186,38.418526,-120.529121,
38.419003,-120.526207,38.423027,
-120.522224,38.422798,-120.503975,
38.439148,-120.504044,38.444305,
-120.497063,38.444519,-120.49881,
38.447678,-120.494331,38.449696,
-120.49276,38.447136,-120.484909,
38.445724,-120.466705,38.448933,
-120.460365,38.446255,-120.451111,
38.450191,-120.447105,38.452911,
-120.442558,38.462044,-120.422249,
38.473457,-120.413696,38.473156,
-120.411423,38.468739,-120.388733,
38.467316,-120.379723,38.461132,
-120.363914,38.466652,-120.352646,
38.465561,-120.337112,38.467529,
-120.33004,38.465263,-120.318115,
38.471191,-120.303535,38.472221,
-120.293816,38.477364,-120.282349,
38.475555,-120.26815,38.477859,
-120.258942,38.48687,-120.239845,
38.485432,-120.234528,38.489941,
-120.22493,38.490879,-120.216423,
38.49781,-120.208374,38.500847,
-120.1633,38.494324,-120.145691,
38.495407,-120.13839,38.498421,
-120.122421,38.496059,-120.110466,
38.498653,-120.1073,38.503796,
-120.102348,38.505581,-120.099297,
38.504116,-120.091202,38.507595,
-120.07901,38.507507,-120.071465,
38.510078,-120.071373,38.702862)),
'Amador','06005','California','CA','06',592.4638,30039,50.7017);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.04538,39.797768,-122.039032,
39.79287,-122.032539,39.799507,
-122.026817,39.800549,-122.023079,
39.798641,-122.024506,39.788269,
-122.031326,39.778843,-122.017311,
39.762756,-122.004372,39.757881,
-121.994072,39.75,-121.98101,
39.734188,-121.970367,39.731922,
-121.968391,39.739803,-121.962852,
39.741596,-121.959091,39.734329,
-121.966354,39.724758,-121.964714,
39.719803,-121.961433,39.717842,
-121.956154,39.719189,-121.950256,
39.73288,-121.945595,39.729698,
-121.948914,39.719269,-121.940231,
39.698669,-121.94294,39.692039,
-121.955818,39.687469,-121.95916,
39.678032,-121.972504,39.676041,
-121.983276,39.670238,-121.99337,
39.671295,-121.996277,39.668652,
-121.995911,39.66415,-121.988564,
39.660183,-121.975906,39.664288,
-121.965706,39.651707,-121.967995,
39.648064,-121.978195,39.648045,
-121.991333,39.641617,-121.990005,
39.627148,-121.982445,39.62352,
-121.978279,39.616203,-121.98127,
39.61153,-121.99379,39.605213,
-121.994278,39.581722,-122.002258,
39.573929,-122,39.568615,-121.992516,
39.567848,-121.989532,39.56498,
-121.991631,39.562168,-122.001968,
39.559616,-121.993744,39.536594,
-121.984573,39.531143,-121.98214,
39.533035,-121.974625,39.532646,
-121.972946,39.528969,-121.944099,
39.536194,-121.855438,39.536842,
-121.855385,39.532757,-121.876259,
39.509663,-121.874054,39.503422,
-121.876045,39.501896,-121.869789,
39.485241,-121.872437,39.478722,
-121.868271,39.466316,-121.873756,
39.46064,-121.869675,39.448833,
-121.872955,39.447411,-121.875847,
39.438461,-121.874115,39.428028,
-121.876953,39.427776,-121.876633,
39.422943,-121.883224,39.410294,
-121.888954,39.384007,-121.882774,
39.374043,-121.890594,39.366219,
-121.892456,39.358669,-121.898033,
39.357388,-121.896385,39.344387,
-121.893295,39.341209,-121.901962,
39.330223,-121.907227,39.304024,
-121.629021,39.305775,-121.631073,
39.30204,-121.622772,39.295872,
-121.617165,39.301174,-121.619675,
39.303394,-121.610107,39.319397,
-121.603127,39.318138,-121.601173,
39.31155,-121.59314,39.307938,
-121.58419,39.311684,-121.574615,
39.310947,-121.562614,39.305058,
-121.547653,39.308876,-121.546036,
39.312286,-121.535347,39.31432,
-121.52948,39.318371,-121.503372,
39.318268,-121.496941,39.314526,
-121.493683,39.319164,-121.48304,
39.318115,-121.483017,39.326241,
-121.476685,39.329056,-121.473885,
39.33345,-121.468414,39.333557,
-121.462013,39.33112,-121.456451,
39.33551,-121.445839,39.330597,
-121.433693,39.337528,-121.425186,
39.335079,-121.414574,39.340137,
-121.405472,39.340176,-121.405846,
39.344524,-121.402138,39.345531,
-121.402069,39.349651,-121.386566,
39.355911,-121.381256,39.363121,
-121.371338,39.365021,-121.371429,
39.373669,-121.366013,39.37822,
-121.358864,39.399113,-121.361992,
39.404285,-121.350143,39.416046,
-121.332916,39.425892,-121.334427,
39.430584,-121.339668,39.431816,
-121.344276,39.439091,-121.344048,
39.452682,-121.337349,39.454411,
-121.337189,39.465099,-121.332367,
39.465202,-121.332352,39.468952,
-121.322952,39.468761,-121.322845,
39.475822,-121.313713,39.476013,
-121.313904,39.487072,-121.309074,
39.486931,-121.309128,39.497875,
-121.304352,39.497929,-121.304047,
39.519699,-121.275681,39.520515,
-121.276215,39.512871,-121.239105,
39.513283,-121.239471,39.526703,
-121.208931,39.527348,-121.184174,
39.526863,-121.184326,39.51984,
-121.158226,39.519707,-121.157951,
39.52623,-121.148842,39.526554,
-121.148849,39.555412,-121.139824,
39.555664,-121.140144,39.562389,
-121.115395,39.563656,-121.115273,
39.567215,-121.105904,39.567303,
-121.1064,39.585388,-121.078484,
39.585373,-121.07563,39.597378,
-121.078278,39.603458,-121.087852,
39.603416,-121.087822,39.613655,
-121.096664,39.613808,-121.096474,
39.621017,-121.115265,39.621128,
-121.115555,39.628159,-121.135651,
39.628281,-121.135345,39.656921,
-121.154007,39.656895,-121.154106,
39.66404,-121.161835,39.663967,
-121.161942,39.671223,-121.170074,
39.6712,-121.17012,39.685677,
-121.189217,39.685463,-121.189461,
39.700005,-121.207642,39.700546,
-121.209808,39.725765,-121.228477,
39.725784,-121.228699,39.740334,
-121.247192,39.740154,-121.249565,
39.754082,-121.266953,39.75436,
-121.267197,39.768913,-121.284775,
39.767738,-121.283875,39.781693,
-121.288429,39.781773,-121.288391,
39.785553,-121.293152,39.785618,
-121.293053,39.789364,-121.30674,
39.789482,-121.306633,39.796734,
-121.315811,39.796783,-121.317368,
39.811008,-121.331253,39.811169,
-121.331192,39.825794,-121.349785,
39.825832,-121.349953,39.840427,
-121.359444,39.840855,-121.36013,
39.855591,-121.379135,39.855591,
-121.379059,39.862984,-121.39743,
39.862995,-121.397888,39.871387,
-121.410858,39.871536,-121.409912,
39.90052,-121.428879,39.900433,
-121.428932,39.914951,-121.40992,
39.915207,-121.410011,39.92955,
-121.419495,39.929569,-121.4188,
39.95871,-121.409309,39.958527,
-121.409203,39.987385,-121.418739,
39.987667,-121.418404,40.015884,
-121.408478,40.015842,-121.408562,
40.030739,-121.399254,40.03064,
-121.399269,40.052212,-121.381187,
40.051945,-121.38092,40.05711,
-121.375999,40.057209,-121.375771,
40.071865,-121.366066,40.072002,
-121.365738,40.08617,-121.37571,
40.086189,-121.375359,40.108765,
-121.384933,40.108799,-121.384773,
40.116047,-121.403717,40.115685,
-121.403435,40.151764,-121.4356,
40.152027,-121.44175,40.148819,
-121.441833,40.1297,-121.451668,
40.129837,-121.45192,40.121964,
-121.479874,40.122482,-121.479889,
40.115208,-121.489777,40.115402,
-121.489792,40.108158,-121.50946,
40.108097,-121.509476,40.100636,
-121.58532,40.100639,-121.585052,
40.093414,-121.594711,40.093578,
-121.594559,40.057816,-121.597366,
40.057724,-121.597473,40.055202,
-121.607559,40.055202,-121.607651,
40.046867,-121.616203,40.04723,
-121.616722,40.039536,-121.625,
40.039616,-121.625,40.025749,
-121.635086,40.025928,-121.634354,
39.996941,-121.64476,39.997177,
-121.644951,39.982605,-121.702225,
39.984516,-121.706505,39.977081,
-121.723984,39.967808,-121.728683,
39.956226,-121.734886,39.95369,
-121.743652,39.942013,-121.748421,
39.925858,-121.749573,39.906933,
-121.7658,39.897484,-121.775139,
39.888977,-121.805016,39.888336,
-121.802956,39.884464,-122.043846,
39.88393,-122.039619,39.879929,
-122.054604,39.864094,-122.057205,
39.850803,-122.068184,39.840603,
-122.055527,39.827374,-122.063766,
39.811619,-122.048866,39.803432,
-122.04538,39.797768)),'Butte',
'06007','California','CA','06',1639.3183,182120,111.0948);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.071465,38.510078,-120.07901,
38.507507,-120.091202,38.507595,
-120.099297,38.504116,-120.102348,
38.505581,-120.1073,38.503796,
-120.110466,38.498653,-120.122421,
38.496059,-120.13839,38.498421,
-120.145691,38.495407,-120.1633,
38.494324,-120.208374,38.500847,
-120.216423,38.49781,-120.22493,
38.490879,-120.234528,38.489941,
-120.239845,38.485432,-120.258942,
38.48687,-120.26815,38.477859,
-120.282349,38.475555,-120.293816,
38.477364,-120.303535,38.472221,
-120.318115,38.471191,-120.33004,
38.465263,-120.337112,38.467529,
-120.352646,38.465561,-120.363914,
38.466652,-120.379723,38.461132,
-120.388733,38.467316,-120.411423,
38.468739,-120.413696,38.473156,
-120.422249,38.473457,-120.442558,
38.462044,-120.447105,38.452911,
-120.451111,38.450191,-120.460365,
38.446255,-120.466705,38.448933,
-120.484909,38.445724,-120.49276,
38.447136,-120.494331,38.449696,
-120.49881,38.447678,-120.497063,
38.444519,-120.504044,38.444305,
-120.503975,38.439148,-120.522224,
38.422798,-120.526207,38.423027,
-120.529121,38.419003,-120.536186,
38.418526,-120.540436,38.422909,
-120.558983,38.415234,-120.570641,
38.414021,-120.569534,38.407475,
-120.574539,38.401505,-120.607857,
38.397724,-120.609589,38.391819,
-120.61422,38.389275,-120.613281,
38.382664,-120.616295,38.378384,
-120.613617,38.372841,-120.609024,
38.370785,-120.617477,38.366592,
-120.618607,38.357834,-120.626854,
38.355835,-120.630562,38.34005,
-120.637329,38.340942,-120.64547,
38.334633,-120.655373,38.33086,
-120.664207,38.331642,-120.671066,
38.329266,-120.673759,38.330795,
-120.687149,38.31897,-120.71154,
38.315285,-120.729897,38.308029,
-120.737183,38.307838,-120.750275,
38.296574,-120.753876,38.288353,
-120.766251,38.290401,-120.776604,
38.287788,-120.789497,38.288681,
-120.797432,38.285675,-120.802322,
38.288952,-120.806694,38.288807,
-120.809494,38.281689,-120.81665,
38.28363,-120.820999,38.275536,
-120.833786,38.267754,-120.845749,
38.264359,-120.849213,38.257137,
-120.855438,38.247852,-120.867332,
38.245216,-120.875504,38.23978,
-120.878578,38.241001,-120.881653,
38.23064,-120.887321,38.227985,
-120.89193,38.221279,-120.902039,
38.222317,-120.914528,38.229992,
-120.923592,38.228107,-120.935806,
38.22057,-120.952621,38.226231,
-120.962944,38.219563,-120.967827,
38.220161,-120.97097,38.217625,
-120.994469,38.225536,-120.937798,
38.088402,-120.9254,38.077499,
-120.875,38.028973,-120.760254,
37.931145,-120.727631,37.897743,
-120.652824,37.832355,-120.636856,
37.847893,-120.632751,37.86068,
-120.615936,37.870129,-120.603706,
37.873318,-120.604263,37.876125,
-120.595406,37.882984,-120.59565,
37.888222,-120.586487,37.895294,
-120.569717,37.89492,-120.563042,
37.90369,-120.561165,37.914143,
-120.554993,37.916256,-120.550072,
37.921753,-120.541611,37.920254,
-120.536583,37.926937,-120.538986,
37.935883,-120.53421,37.944481,
-120.513931,37.953453,-120.514053,
37.962223,-120.525375,37.969368,
-120.526962,37.975773,-120.542038,
37.975311,-120.539078,37.97913,
-120.52655,37.983021,-120.533783,
37.991253,-120.520622,37.995235,
-120.51783,38.0023,-120.514381,
38.00433,-120.508255,38,-120.51252,
37.995689,-120.508171,37.991585,
-120.503487,37.991219,-120.498344,
37.996265,-120.499298,38.007305,
-120.491745,38.011208,-120.4879,
38.009144,-120.481743,38.012463,
-120.462723,38.010468,-120.462196,
38.012852,-120.4674,38.014412,
-120.468468,38.018696,-120.461075,
38.022476,-120.452888,38.041424,
-120.442383,38.051765,-120.441498,
38.058811,-120.43808,38.06089,
-120.430206,38.060596,-120.430206,
38.072929,-120.423607,38.072994,
-120.420509,38.078827,-120.413605,
38.081985,-120.409592,38.087952,
-120.408981,38.102482,-120.386909,
38.115334,-120.376572,38.135757,
-120.370346,38.137951,-120.370232,
38.14056,-120.37532,38.142841,
-120.369804,38.150715,-120.356514,
38.15395,-120.358482,38.161385,
-120.352547,38.163879,-120.348892,
38.170265,-120.339516,38.172028,
-120.339424,38.1777,-120.336243,
38.178135,-120.338615,38.183716,
-120.334496,38.185043,-120.334618,
38.188019,-120.331253,38.188316,
-120.329285,38.195248,-120.32534,
38.19603,-120.316757,38.206642,
-120.306587,38.224506,-120.300522,
38.229816,-120.290222,38.234093,
-120.288765,38.245941,-120.271423,
38.259823,-120.272987,38.264446,
-120.26976,38.270782,-120.261055,
38.276478,-120.255043,38.286198,
-120.245926,38.290268,-120.235687,
38.298759,-120.236237,38.30162,
-120.227509,38.314751,-120.20417,
38.32972,-120.192726,38.349049,
-120.18988,38.350193,-120.188515,
38.35685,-120.183777,38.35891,
-120.175461,38.373867,-120.160187,
38.380993,-120.156929,38.385864,
-120.140854,38.393883,-120.135979,
38.393379,-120.133904,38.396629,
-120.12719,38.395916,-120.114525,
38.401299,-120.086861,38.403481,
-120.079803,38.410206,-120.069244,
38.413406,-120.066887,38.415562,
-120.063316,38.414852,-120.048027,
38.419449,-120.039536,38.426006,
-120.028862,38.42477,-120.018982,
38.433468,-120.052612,38.455685,
-120.065598,38.448257,-120.071541,
38.447166,-120.071465,38.510078)),
'Calaveras','06009','California','CA','06',1020.0126,31998,31.3701);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.737961,39.383385,-122.783981,
39.383091,-122.773186,39.374817,
-122.767632,39.373863,-122.75885,
39.378246,-122.751144,39.370701,
-122.742378,39.368248,-122.741112,
39.365414,-122.741341,39.357578,
-122.744736,39.356335,-122.751259,
39.346165,-122.764206,39.342861,
-122.763382,39.336544,-122.767136,
39.331261,-122.767189,39.325603,
-122.771423,39.324097,-122.774368,
39.315296,-122.773941,39.311893,
-122.769394,39.310135,-122.765022,
39.301144,-122.757118,39.294064,
-122.755989,39.284424,-122.735634,
39.272694,-122.727539,39.273396,
-122.722107,39.265392,-122.716034,
39.263649,-122.715866,39.260574,
-122.711349,39.257126,-122.690262,
39.247543,-122.685753,39.241264,
-122.679825,39.238838,-122.680603,
39.234676,-122.675034,39.230942,
-122.678635,39.224644,-122.672417,
39.225815,-122.664261,39.217659,
-122.656815,39.214981,-122.64772,
39.214127,-122.634216,39.222961,
-122.622375,39.223324,-122.608719,
39.216301,-122.579536,39.211639,
-122.571274,39.204224,-122.540321,
39.207027,-122.533897,39.211708,
-122.514236,39.209328,-122.513367,
39.19733,-122.507309,39.190434,
-122.497452,39.191204,-122.490723,
39.175404,-122.48777,39.176414,
-122.474991,39.17271,-122.475937,
39.167149,-122.481483,39.163036,
-122.478302,39.158123,-122.477158,
39.154541,-122.481033,39.152359,
-122.473633,39.144478,-122.47982,
39.138737,-122.485542,39.141766,
-122.491829,39.139568,-122.495743,
39.140614,-122.493698,39.13596,
-122.499817,39.121185,-122.493111,
39.115185,-122.495018,39.111057,
-122.493248,39.104412,-122.487724,
39.099785,-122.484718,39.08564,
-122.48877,39.074345,-122.487595,
39.069317,-122.482796,39.067062,
-122.489441,39.065079,-122.490944,
39.053596,-122.464294,39.049221,
-122.466408,39.043514,-122.460182,
39.038776,-122.455963,39.038502,
-122.453766,39.034515,-122.436203,
39.021465,-122.412315,39.020317,
-122.40889,39.017616,-122.408272,
39.011459,-122.410835,38.998241,
-122.414642,38.997295,-122.413727,
38.993568,-122.418221,38.989281,
-122.415604,38.978146,-122.405937,
38.971519,-122.408035,38.962894,
-122.400818,38.955936,-122.392944,
38.955711,-122.371933,38.939919,
-122.366493,38.939137,-122.349022,
38.928879,-122.34034,38.927246,
-122.339088,38.924347,-122.085938,
38.926144,-121.83474,38.924576,
-121.836685,38.927456,-121.829117,
38.938946,-121.835487,38.94392,
-121.835518,38.94923,-121.839485,
38.954929,-121.830963,38.960575,
-121.833229,38.96883,-121.82032,
38.97485,-121.818062,38.988655,
-121.801025,38.989872,-121.79435,
38.996494,-121.805199,39.003471,
-121.818214,39.006126,-121.825409,
39.011295,-121.820099,39.020336,
-121.821686,39.028759,-121.823837,
39.031876,-121.82972,39.032772,
-121.828583,39.038033,-121.838737,
39.046837,-121.837898,39.064369,
-121.848785,39.071537,-121.868736,
39.066967,-121.888023,39.072479,
-121.893532,39.079082,-121.888657,
39.081272,-121.894157,39.086899,
-121.893288,39.096233,-121.89743,
39.096794,-121.898956,39.100319,
-121.904755,39.103195,-121.902443,
39.108166,-121.904457,39.114876,
-121.909584,39.113022,-121.91201,
39.114426,-121.908875,39.119396,
-121.910019,39.123257,-121.920486,
39.122227,-121.923935,39.128284,
-121.933044,39.130108,-121.938087,
39.136253,-121.936684,39.144093,
-121.919456,39.141449,-121.916138,
39.147388,-121.919037,39.153099,
-121.933151,39.161137,-121.938316,
39.174305,-121.944328,39.180199,
-121.940376,39.18655,-121.933533,
39.189938,-121.935562,39.194771,
-121.927414,39.198845,-121.931381,
39.211685,-121.936913,39.218346,
-121.935143,39.221203,-121.940331,
39.221893,-121.939293,39.229309,
-121.947098,39.240501,-121.945869,
39.25,-121.935661,39.268368,
-121.927963,39.271275,-121.926697,
39.275795,-121.920036,39.281185,
-121.921005,39.288418,-121.917854,
39.289539,-121.913971,39.298347,
-121.907013,39.301983,-121.907227,
39.304024,-121.901962,39.330223,
-121.893295,39.341209,-121.896385,
39.344387,-121.898033,39.357388,
-121.892456,39.358669,-121.890594,
39.366219,-121.882774,39.374043,
-121.888954,39.384007,-122.008652,
39.38398,-122.002625,39.397942,
-122.007767,39.413685,-122.124535,
39.414707,-122.135071,39.414616,
-122.134918,39.385609,-122.430191,
39.383896,-122.593445,39.385658,
-122.737961,39.383385)),'Colusa',
'06011','California','CA','06',1150.5791,16275,14.145);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.264854,38.060097,-122.261833,
38.052589,-122.26371,38.043564,
-122.272736,38.039429,-122.287025,
38.021755,-122.306198,38.0116,
-122.315224,38.011223,-122.326508,
38.003704,-122.335915,38.002953,
-122.366371,38.01273,-122.368248,
38.007088,-122.361855,37.988663,
-122.367874,37.97776,-122.372009,
37.975124,-122.382538,37.976257,
-122.392311,37.962341,-122.398331,
37.958958,-122.410362,37.960083,
-122.414505,37.963093,-122.428413,
37.965347,-122.428413,37.960835,
-122.408478,37.931881,-122.389679,
37.921726,-122.387421,37.91571,
-122.388931,37.909321,-122.369751,
37.90443,-122.36261,37.90443,
-122.358849,37.908943,-122.349449,
37.90744,-122.328392,37.908569,
-122.319359,37.90443,-122.311928,
37.897423,-122.309799,37.8979,
-122.287399,37.897999,-122.269997,
37.905899,-122.264801,37.904499,
-122.260307,37.8997,-122.255707,
37.899601,-122.251907,37.893501,
-122.248703,37.893299,-122.247803,
37.887001,-122.242996,37.883301,
-122.224701,37.879299,-122.216301,
37.871799,-122.215202,37.8689,
-122.220398,37.865101,-122.207703,
37.8521,-122.202705,37.851299,
-122.193001,37.8409,-122.184196,
37.837101,-122.184906,37.820801,
-122.165802,37.813499,-122.156601,
37.817902,-122.147705,37.813801,
-122.139702,37.804699,-122.044403,
37.798199,-122.029404,37.7878,
-122.013,37.7803,-121.996704,
37.763302,-122.009705,37.755199,
-122.010704,37.747501,-122,37.739101,
-121.9925,37.738201,-121.988907,
37.7337,-121.971397,37.7286,
-121.959702,37.7187,-121.6231,
37.799198,-121.555626,37.820335,
-121.550339,37.824078,-121.552788,
37.83326,-121.549866,37.83699,
-121.548859,37.834908,-121.544418,
37.836105,-121.539703,37.840042,
-121.538544,37.843628,-121.540787,
37.843903,-121.535049,37.851501,
-121.537903,37.853222,-121.541122,
37.850365,-121.541443,37.859688,
-121.549194,37.857414,-121.553253,
37.863617,-121.555817,37.860527,
-121.559982,37.861519,-121.561981,
37.855301,-121.566269,37.860023,
-121.569832,37.860039,-121.568497,
37.862984,-121.578316,37.859749,
-121.57933,37.862595,-121.573486,
37.86734,-121.578323,37.871536,
-121.579803,37.87706,-121.574051,
37.885757,-121.576111,37.8909,
-121.570908,37.893101,-121.567902,
37.8951,-121.567001,37.900578,
-121.572174,37.906509,-121.563461,
37.912941,-121.566757,37.920273,
-121.556396,37.924,-121.559738,
37.927719,-121.558578,37.932953,
-121.562408,37.936577,-121.564209,
37.946144,-121.560303,37.948723,
-121.562439,37.949745,-121.566483,
37.947105,-121.568909,37.948631,
-121.564407,37.956688,-121.575745,
37.956963,-121.565536,37.961571,
-121.572754,37.966457,-121.573288,
37.972435,-121.580154,37.977715,
-121.572495,37.980026,-121.581665,
37.984428,-121.576538,37.996056,
-121.579704,37.999401,-121.571251,
38.000309,-121.569778,38.004246,
-121.578674,38.005363,-121.58062,
38.009872,-121.577347,38.01273,
-121.568222,38.013695,-121.573051,
38.019775,-121.561363,38.017059,
-121.559006,38.018715,-121.5662,
38.026501,-121.566483,38.030769,
-121.572937,38.030563,-121.572327,
38.03804,-121.575546,38.042442,
-121.580002,38.042538,-121.582184,
38.040184,-121.579971,38.032372,
-121.583847,38.033051,-121.58577,
38.03701,-121.585754,38.058632,
-121.582474,38.062767,-121.582565,
38.068233,-121.572327,38.073776,
-121.576202,38.078171,-121.580231,
38.094048,-121.603859,38.09996,
-121.618698,38.099529,-121.627289,
38.098,-121.631531,38.088692,
-121.637024,38.086212,-121.644119,
38.087498,-121.660797,38.095699,
-121.671997,38.093601,-121.6782,
38.089401,-121.680801,38.0821,
-121.679794,38.062214,-121.698708,
38.0453,-121.736755,38.026711,
-121.762398,38.023602,-121.776413,
38.018997,-121.788544,38.018547,
-121.800209,38.021706,-121.809586,
38.02037,-121.817116,38.02227,
-121.831055,38.031181,-121.845734,
38.060036,-121.85257,38.064857,
-121.861389,38.066113,-121.866333,
38.056976,-121.873657,38.050758,
-121.905731,38.045086,-121.934357,
38.048878,-121.976372,38.066921,
-122.014107,38.063564,-122.027336,
38.059273,-122.060036,38.062222,
-122.122894,38.035797,-122.147507,
38.031799,-122.163506,38.034801,
-122.182785,38.054077,-122.199768,
38.058018,-122.244171,38.064049,
-122.264267,38.060001,-122.264854,
38.060097)),'ContraCosta','06013',
'California','CA','06',720.1621,803732,1116.0419);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-124.210136,41.998016,-124.203751,
41.983608,-124.205978,41.958057,
-124.209038,41.950851,-124.201988,
41.935848,-124.207245,41.888355,
-124.218399,41.846596,-124.229477,
41.818844,-124.243835,41.792465,
-124.254799,41.78318,-124.247673,
41.771385,-124.238121,41.769974,
-124.212303,41.751579,-124.199577,
41.744865,-124.191803,41.750168,
-124.170578,41.743095,-124.163155,
41.739204,-124.153252,41.728947,
-124.143707,41.712685,-124.133446,
41.656456,-124.124252,41.645493,
-124.112587,41.616138,-124.100204,
41.601997,-124.103745,41.59457,
-124.097023,41.586437,-124.100563,
41.579365,-124.099495,41.571232,
-124.091019,41.552841,-124.080048,
41.546124,-124.080048,41.513237,
-124.064072,41.465057,-123.884521,
41.466007,-123.884514,41.464008,
-123.769379,41.464348,-123.769066,
41.380932,-123.660194,41.382244,
-123.654297,41.388584,-123.654831,
41.395458,-123.64048,41.400345,
-123.637741,41.40752,-123.640839,
41.415817,-123.647385,41.420979,
-123.63662,41.428253,-123.620842,
41.432789,-123.616997,41.443123,
-123.611221,41.449112,-123.614754,
41.453117,-123.610458,41.461727,
-123.62545,41.466953,-123.631233,
41.473618,-123.629395,41.47728,
-123.636597,41.48254,-123.633286,
41.486233,-123.639565,41.507526,
-123.644958,41.512577,-123.644638,
41.519161,-123.641449,41.522858,
-123.646873,41.535168,-123.651627,
41.539547,-123.655594,41.538773,
-123.669106,41.544285,-123.681366,
41.543209,-123.689072,41.552475,
-123.692711,41.552017,-123.692711,
41.557152,-123.680359,41.571926,
-123.68792,41.58223,-123.686722,
41.585281,-123.680168,41.586899,
-123.681145,41.595032,-123.696411,
41.591103,-123.697685,41.595875,
-123.70536,41.595848,-123.714493,
41.591473,-123.717911,41.595417,
-123.714928,41.606709,-123.710251,
41.609077,-123.709854,41.615181,
-123.701576,41.623539,-123.695374,
41.628395,-123.695465,41.634026,
-123.679276,41.634117,-123.687271,
41.652885,-123.68409,41.66021,
-123.687424,41.660332,-123.688408,
41.669598,-123.684219,41.676205,
-123.661667,41.693626,-123.6689,
41.701889,-123.667992,41.706638,
-123.659035,41.714214,-123.658699,
41.72036,-123.664932,41.732315,
-123.672508,41.734425,-123.677132,
41.738705,-123.682251,41.769791,
-123.687157,41.781384,-123.68293,
41.784687,-123.673424,41.785789,
-123.675087,41.789654,-123.670937,
41.79615,-123.679543,41.800991,
-123.687279,41.801865,-123.692543,
41.814777,-123.697037,41.817348,
-123.702187,41.820534,-123.702507,
41.829651,-123.68174,41.837299,
-123.669601,41.835594,-123.670158,
41.845146,-123.661285,41.852581,
-123.660362,41.856636,-123.648308,
41.860485,-123.651093,41.8657,
-123.650215,41.873074,-123.645325,
41.876812,-123.651138,41.879086,
-123.644066,41.883713,-123.64164,
41.889515,-123.638222,41.890461,
-123.634476,41.88768,-123.623291,
41.888592,-123.615875,41.881969,
-123.605125,41.880936,-123.60363,
41.888256,-123.596199,41.894337,
-123.598228,41.899162,-123.5923,
41.906479,-123.57679,41.903145,
-123.56427,41.903305,-123.558319,
41.906128,-123.552277,41.915386,
-123.553215,41.93021,-123.547668,
41.933487,-123.546494,41.938595,
-123.532082,41.955334,-123.535118,
41.977486,-123.539757,41.985474,
-123.533089,41.991093,-123.518677,
41.995323,-123.516739,42.001015,
-123.623375,42,-123.655823,41.9953,
-123.726974,41.997173,-123.82029,
41.99564,-124.210136,41.998016)),
'DelNorte','06015','California','CA','06',1007.7133,23460,23.2804);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.00145,39.067585,-120.142639,
39.067379,-120.142578,39.060291,
-120.152,39.060425,-120.151955,
39.045898,-120.16394,39.045879,
-120.164009,39.038582,-120.182533,
39.038464,-120.183083,39.031109,
-120.239136,39.030983,-120.239388,
39.023762,-120.327095,39.02253,
-120.434036,39.028481,-120.444107,
39.018215,-120.444122,39.010197,
-120.452827,38.995281,-120.450829,
38.987728,-120.458923,38.984776,
-120.460594,38.978462,-120.469971,
38.965813,-120.485001,38.957516,
-120.486458,38.952515,-120.491806,
38.948898,-120.490982,38.944027,
-120.501511,38.941319,-120.503632,
38.935532,-120.509346,38.934669,
-120.511215,38.931396,-120.526276,
38.931656,-120.533745,38.926006,
-120.542847,38.927521,-120.545341,
38.920681,-120.552048,38.920177,
-120.55571,38.915211,-120.570763,
38.914253,-120.584869,38.9226,
-120.586044,38.931545,-120.591995,
38.932022,-120.593346,38.936234,
-120.604881,38.93465,-120.610893,
38.943024,-120.621056,38.94313,
-120.628822,38.946468,-120.635361,
38.943428,-120.641594,38.944485,
-120.643761,38.946819,-120.653435,
38.94838,-120.654747,38.953594,
-120.672089,38.958817,-120.673164,
38.962475,-120.682785,38.967579,
-120.679939,38.9776,-120.684181,
38.983505,-120.68383,38.989361,
-120.687675,38.989864,-120.692131,
38.985332,-120.703529,38.981327,
-120.715904,38.987228,-120.721298,
38.993294,-120.721825,38.998962,
-120.728226,39.003853,-120.735001,
39.000702,-120.740601,39.00153,
-120.743065,39.004955,-120.747223,
39.003246,-120.745209,39.010502,
-120.749168,39.009422,-120.751778,
39.005329,-120.756882,39.007774,
-120.75975,39.005535,-120.762482,
39.006458,-120.762794,39.004234,
-120.759094,39.003414,-120.761604,
39.001865,-120.765884,39.005215,
-120.762772,39.009472,-120.766991,
39.009453,-120.787254,38.999542,
-120.797081,38.996109,-120.801216,
39.001106,-120.811417,39.000359,
-120.814697,38.994507,-120.822464,
38.993275,-120.827415,38.989956,
-120.828293,38.980461,-120.833984,
38.971584,-120.837646,38.971786,
-120.839699,38.9757,-120.84919,
38.976501,-120.854408,38.967941,
-120.851151,38.959385,-120.856422,
38.956776,-120.858261,38.9519,
-120.887062,38.959793,-120.900887,
38.953209,-120.912735,38.955452,
-120.922485,38.961132,-120.93544,
38.964188,-120.939522,38.960899,
-120.937263,38.957035,-120.937592,
38.935757,-120.957039,38.93914,
-120.965012,38.932781,-120.990929,
38.927299,-120.990425,38.923389,-121,
38.917755,-121.004158,38.920128,
-121.010323,38.916546,-121.017281,
38.918591,-121.032608,38.913025,
-121.039436,38.915615,-121.042702,
38.907391,-121.052963,38.899345,
-121.052834,38.896976,-121.047104,
38.895473,-121.043236,38.89043,
-121.060898,38.88224,-121.05587,
38.877407,-121.052208,38.868446,
-121.060768,38.859985,-121.056915,
38.847904,-121.072525,38.842705,
-121.081215,38.834991,-121.086288,
38.833378,-121.088913,38.827698,
-121.082848,38.822624,-121.083199,
38.819103,-121.083839,38.816544,
-121.090126,38.81464,-121.095665,
38.814785,-121.097633,38.818352,
-121.106499,38.815792,-121.098831,
38.810398,-121.098099,38.804066,
-121.100349,38.798126,-121.104355,
38.797054,-121.103889,38.7864,
-121.110046,38.77536,-121.119728,
38.770241,-121.122765,38.752254,
-121.129059,38.74995,-121.13549,
38.737858,-121.147774,38.731602,
-121.142754,38.717297,-121.144798,
38.711899,-121.140198,38.712299,
-121.132301,38.705799,-121.1231,
38.7108,-121.117706,38.717499,
-121.026306,38.50816,-121.018303,
38.508846,-121.010468,38.512482,
-121.006081,38.519199,-121,38.518639,
-120.993736,38.513695,-120.986366,
38.516609,-120.973328,38.515968,
-120.968964,38.520985,-120.963654,
38.520344,-120.957161,38.522766,
-120.950577,38.521351,-120.939713,
38.528629,-120.935463,38.51952,
-120.925385,38.514942,-120.921867,
38.519199,-120.90963,38.520756,
-120.907738,38.524185,-120.904243,
38.52462,-120.901848,38.531208,
-120.891747,38.529057,-120.888458,
38.524776,-120.884079,38.525024,
-120.87957,38.530926,-120.882965,
38.536327,-120.87542,38.543373,
-120.872574,38.542782,-120.870293,
38.536625,-120.862694,38.535324,
-120.861214,38.543243,-120.855331,
38.542831,-120.854897,38.548691,
-120.848259,38.550941,-120.840591,
38.556152,-120.83474,38.551647,
-120.83194,38.555927,-120.823868,
38.556179,-120.822121,38.559883,
-120.815445,38.558308,-120.81192,
38.562244,-120.808746,38.561462,
-120.811302,38.560001,-120.809387,
38.557941,-120.803436,38.55991,
-120.799332,38.556293,-120.793152,
38.55764,-120.783134,38.55098,
-120.77774,38.554455,-120.767685,
38.552647,-120.759239,38.554977,
-120.753273,38.55122,-120.747406,
38.553535,-120.746353,38.548454,
-120.73822,38.548393,-120.735687,
38.545761,-120.729515,38.548233,
-120.721413,38.54723,-120.717857,
38.542103,-120.705765,38.535107,
-120.703262,38.536091,-120.689743,
38.527946,-120.681938,38.526367,
-120.676178,38.517925,-120.658615,
38.515816,-120.649475,38.510094,
-120.627068,38.50322,-120.611122,
38.504715,-120.605682,38.502525,
-120.591438,38.5047,-120.578743,
38.503513,-120.552864,38.511887,
-120.53624,38.509483,-120.509369,
38.511669,-120.489944,38.517529,
-120.484207,38.5214,-120.463974,
38.522778,-120.448799,38.528591,
-120.441307,38.528858,-120.432816,
38.52676,-120.423988,38.530396,
-120.411934,38.531265,-120.401382,
38.537712,-120.387611,38.540543,
-120.382515,38.538734,-120.37738,
38.544746,-120.362808,38.54464,
-120.354683,38.547344,-120.345009,
38.541744,-120.336617,38.545654,
-120.31675,38.543442,-120.301056,
38.5495,-120.296593,38.556179,
-120.284889,38.556267,-120.279465,
38.559174,-120.264984,38.56118,
-120.265503,38.56509,-120.259201,
38.577557,-120.249664,38.584072,
-120.231941,38.586803,-120.228073,
38.594925,-120.222153,38.597191,
-120.220062,38.616016,-120.21315,
38.622879,-120.213455,38.628979,
-120.204216,38.627987,-120.20079,
38.624763,-120.190292,38.631245,
-120.177628,38.633858,-120.157082,
38.633324,-120.151382,38.638008,
-120.14463,38.639839,-120.139473,
38.63826,-120.135986,38.641308,
-120.130379,38.649906,-120.134079,
38.654617,-120.131218,38.6604,
-120.127495,38.665154,-120.122108,
38.666721,-120.115677,38.679871,
-120.122353,38.687027,-120.121521,
38.695457,-120.110992,38.705109,
-120.101982,38.706055,-120.080589,
38.700367,-120.071373,38.702862,
-119.963936,38.776081,-119.946915,
38.781734,-119.945877,38.786491,
-119.938759,38.793655,-119.942963,
38.796925,-119.941505,38.802727,
-119.930511,38.812241,-119.929932,
38.815277,-119.920296,38.821831,
-119.922783,38.825043,-119.9217,
38.830048,-119.907478,38.834438,
-119.905296,38.855598,-119.89975,
38.857506,-119.892471,38.856792,
-119.879288,38.864872,-119.876274,
38.870289,-119.877357,38.87455,
-119.887794,38.879238,-119.881798,
38.881084,-119.878525,38.886631,
-119.883476,38.894299,-119.878853,
38.899513,-119.886299,38.918037,
-119.891113,38.91851,-119.904205,
38.928181,-119.903305,38.933414,-120,
38.999668,-120.00145,39.067585)),
'ElDorado','06017','California','CA','06',1711.2031,125995,73.6293);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-119.0214,37.5858,-119.311226,
37.352783,-119.314392,37.347427,
-119.310577,37.342995,-119.311264,
37.339764,-119.324814,37.335472,
-119.323586,37.332569,-119.315483,
37.328182,-119.315445,37.323387,
-119.317833,37.321053,-119.322868,
37.320869,-119.333839,37.312263,
-119.332642,37.304207,-119.325645,
37.292767,-119.330658,37.273933,
-119.325188,37.27039,-119.320915,
37.253914,-119.321152,37.246445,
-119.32988,37.240238,-119.332649,
37.223969,-119.336624,37.21946,
-119.329552,37.214817,-119.329041,
37.207127,-119.336273,37.200077,
-119.342049,37.189411,-119.352425,
37.186184,-119.358459,37.181625,
-119.360481,37.168125,-119.373344,
37.164501,-119.374054,37.15752,
-119.382843,37.154121,-119.385475,
37.149704,-119.398827,37.149887,
-119.404137,37.158909,-119.414833,
37.163502,-119.424843,37.164352,
-119.43116,37.162624,-119.433914,
37.147007,-119.44175,37.144104,
-119.461227,37.144951,-119.467682,
37.127857,-119.46508,37.120316,
-119.46962,37.110249,-119.481125,
37.109623,-119.490227,37.119781,
-119.492058,37.124401,-119.487854,
37.13554,-119.489098,37.138634,
-119.504379,37.149986,-119.508362,
37.150551,-119.516502,37.146824,
-119.52404,37.128304,-119.538956,
37.1353,-119.549919,37.145233,
-119.560097,37.142895,-119.562637,
37.138893,-119.562584,37.12846,
-119.567703,37.117184,-119.555939,
37.115646,-119.548302,37.117069,
-119.536736,37.105125,-119.540421,
37.096268,-119.552795,37.092422,
-119.558075,37.088238,-119.562386,
37.074871,-119.559608,37.070782,
-119.560638,37.065376,-119.567451,
37.063622,-119.58387,37.065674,
-119.595993,37.071316,-119.603935,
37.071068,-119.608696,37.064743,
-119.612633,37.052029,-119.60939,
37.045719,-119.620148,37.026657,
-119.631203,37.021034,-119.634399,
37.021595,-119.634979,37.025394,
-119.628059,37.034672,-119.638374,
37.043339,-119.648483,37.043549,
-119.658401,37.038986,-119.657639,
37.013378,-119.669945,37.009312,
-119.689796,37.012039,-119.697098,
37.008801,-119.712105,36.991699,
-119.731796,36.978401,-119.739502,
36.970001,-119.741707,36.9538,
-119.735634,36.953205,-119.733429,
36.946476,-119.750999,36.935902,
-119.749504,36.928501,-119.755997,
36.920601,-119.771599,36.918598,
-119.774307,36.909302,-119.788597,
36.894299,-119.784508,36.880001,
-119.788101,36.875999,-119.796463,
36.873367,-119.804199,36.864201,
-119.808701,36.862499,-119.811707,
36.852501,-119.8162,36.848701,
-119.822304,36.848701,-119.834999,
36.853298,-119.842003,36.861301,
-119.846107,36.860199,-119.851997,
36.851799,-119.860397,36.855301,
-119.864906,36.848,-119.883904,
36.858601,-119.888306,36.852001,
-119.904999,36.850399,-119.912903,
36.8452,-119.926308,36.848701,
-119.931602,36.844398,-119.933701,
36.838001,-119.943375,36.83408,
-119.956993,36.836277,-119.967773,
36.832355,-119.975899,36.835087,
-119.978638,36.839794,-119.983528,
36.841084,-119.989235,36.838024,
-119.991501,36.829121,-119.998116,
36.827457,-120.012306,36.828293,
-120.019302,36.824791,-120.020981,
36.819118,-120.026367,36.814777,
-120.039856,36.815285,-120.049187,
36.821644,-120.05584,36.823063,
-120.069183,36.818512,-120.075104,
36.824596,-120.078835,36.825375,
-120.089684,36.821804,-120.096985,
36.815418,-120.102882,36.813633,
-120.116081,36.813904,-120.135345,
36.809601,-120.155952,36.797665,
-120.161873,36.799129,-120.167625,
36.80386,-120.171715,36.802883,
-120.172592,36.795448,-120.18045,
36.789822,-120.180359,36.784557,
-120.187958,36.776917,-120.198479,
36.780804,-120.201218,36.790073,
-120.209946,36.788857,-120.215805,
36.790615,-120.219872,36.78487,
-120.231728,36.781368,-120.229424,
36.769287,-120.244072,36.77084,
-120.247932,36.775162,-120.255646,
36.770081,-120.260201,36.772533,
-120.268471,36.771572,-120.271835,
36.773884,-120.279404,36.766243,
-120.281906,36.768078,-120.280869,
36.772331,-120.284508,36.773556,
-120.288429,36.770527,-120.286949,
36.764877,-120.288818,36.763107,
-120.293037,36.766392,-120.292175,
36.772285,-120.305054,36.770317,
-120.304314,36.773335,-120.298805,
36.774624,-120.299362,36.777683,
-120.311584,36.782078,-120.314896,
36.778336,-120.320717,36.777748,
-120.323349,36.779945,-120.321266,
36.784645,-120.323219,36.786358,
-120.333618,36.782936,-120.333382,
36.791519,-120.343071,36.791435,
-120.346664,36.79821,-120.349953,
36.795486,-120.343506,36.787464,
-120.344116,36.785099,-120.354881,
36.787399,-120.36805,36.784855,
-120.371964,36.78907,-120.368668,
36.795597,-120.373016,36.800537,
-120.367218,36.807037,-120.368156,
36.809986,-120.375923,36.808723,
-120.378189,36.817261,-120.387665,
36.824429,-120.399727,36.822693,
-120.40889,36.840134,-120.416573,
36.83604,-120.419884,36.839745,
-120.425369,36.840549,-120.430923,
36.847485,-120.433937,36.851189,
-120.439041,36.850277,-120.437782,
36.855125,-120.446205,36.856728,
-120.447495,36.860203,-120.455132,
36.862492,-120.448891,36.869293,
-120.44986,36.871578,-120.458122,
36.874695,-120.452599,36.880814,
-120.465538,36.889713,-120.459869,
36.902393,-120.462685,36.905365,
-120.454315,36.905731,-120.449417,
36.913101,-120.461205,36.9174,
-120.456116,36.923809,-120.461838,
36.928524,-120.466179,36.936897,
-120.474617,36.940304,-120.477783,
36.948311,-120.477051,36.954838,
-120.487854,36.966457,-120.48307,
36.972519,-120.49334,36.976131,
-120.49839,36.981945,-120.499565,
36.996082,-120.503242,36.998096,
-120.501938,37.000492,-120.507874,37,
-120.507523,37.005821,-120.511711,
37.010239,-120.523064,37.013607,
-120.529778,37.012741,-120.529884,
37.019695,-120.536613,37.019356,
-120.536507,37.023243,-120.543983,
37.02647,-120.537361,37.034206,
-120.536674,37.039951,-120.541206,
37.04414,-120.917709,36.740433,
-120.602707,36.488293,-120.596153,
36.488285,-120.595558,36.328533,
-120.59922,36.328331,-120.603889,
36.324154,-120.611511,36.324409,
-120.611694,36.320892,-120.616913,
36.318859,-120.618919,36.319988,
-120.629524,36.316936,-120.643341,
36.319061,-120.645126,36.317043,
-120.662125,36.314426,-120.681831,
36.294304,-120.679451,36.290722,
-120.681877,36.286835,-120.671616,
36.280533,-120.675186,36.276878,
-120.673241,36.272778,-120.677574,
36.267361,-120.678864,36.26532,
-120.671951,36.257721,-120.677116,
36.255386,-120.680771,36.251419,
-120.678734,36.246704,-120.669899,
36.241898,-120.665909,36.236034,
-120.650688,36.230701,-120.648262,
36.223991,-120.639992,36.219849,
-120.625916,36.203266,-120.638214,
36.196507,-120.64373,36.179192,
-120.647858,36.179462,-120.650986,
36.174129,-120.648933,36.168049,
-120.662056,36.171196,-120.663246,
36.165691,-120.671036,36.16431,
-120.666985,36.16061,-120.663704,
36.147312,-120.663254,36.141399,
-120.66655,36.138096,-120.654732,
36.131821,-120.65152,36.125221,
-120.652199,36.118855,-120.644424,
36.116241,-120.647781,36.108028,
-120.6409,36.101311,-120.634361,
36.101051,-120.632599,36.103363,
-120.625679,36.097183,-120.613258,
36.095112,-120.610657,36.095676,
-120.611366,36.099091,-120.607681,
36.099361,-120.607025,36.102737,
-120.598366,36.100922,-120.588799,
36.089645,-120.592178,36.088573,
-120.595093,36.078259,-120.586868,
36.066669,-120.565659,36.052971,
-120.544418,36.046165,-120.539413,
36.036705,-120.528404,36.034336,
-120.526001,36.035748,-120.528809,
36.024319,-120.519012,36.020924,
-120.518761,36.026718,-120.516579,
36.027584,-120.509941,36.022114,
-120.506897,36.024197,-120.507355,
36.021622,-120.501961,36.020336,
-120.5,36.022377,-120.496155,
36.01947,-120.487335,36.014919,
-120.485222,36.011219,-120.477715,
36.010223,-120.479462,36.005966,
-120.471855,35.997433,-120.448715,
35.988472,-120.448105,35.985153,
-120.438683,35.979614,-120.435104,
35.970779,-120.43206,35.968971,
-120.421799,35.973789,-120.407562,
35.976006,-120.393021,35.967911,
-120.387886,35.969299,-120.359421,
35.964458,-120.361511,35.95945,
-120.356552,35.955589,-120.35553,
35.948097,-120.348663,35.944103,
-120.344849,35.944893,-120.334908,
35.937134,-120.335732,35.923683,
-120.3311,35.918831,-120.331314,
35.915565,-120.325005,35.913162,
-120.321938,35.907856,-120.314087,
35.907223,-119.958237,36.181454,
-119.95916,36.40099,-119.751602,
36.402199,-119.749504,36.405201,
-119.751198,36.4091,-119.746002,
36.416401,-119.736397,36.4175,
-119.7341,36.415798,-119.729599,
36.4207,-119.720306,36.417702,
-119.7108,36.419399,-119.703796,
36.426998,-119.685402,36.4259,
-119.680199,36.4296,-119.670502,
36.431,-119.671799,36.427299,
-119.665802,36.4188,-119.572083,
36.488995,-119.46537,36.575287,
-119.304001,36.573601,-119.303802,
36.660702,-118.983902,36.6572,
-118.981506,36.741699,-118.554108,
36.739201,-118.554558,36.744808,
-118.359657,36.744839,-118.361198,
36.747799,-118.368301,36.750099,
-118.370796,36.761299,-118.373802,
36.764198,-118.371101,36.767101,
-118.375504,36.772202,-118.375107,
36.778599,-118.379303,36.782299,
-118.371872,36.794609,-118.373093,
36.80024,-118.390198,36.821037,
-118.392792,36.829735,-118.388824,
36.834534,-118.37056,36.836147,
-118.361237,36.844067,-118.361298,
36.861423,-118.364624,36.862347,
-118.365234,36.868969,-118.369247,
36.871758,-118.366203,36.8815,
-118.361504,36.883701,-118.359901,
36.887798,-118.368301,36.898499,
-118.366501,36.907101,-118.370102,
36.908699,-118.3806,36.925999,
-118.387505,36.945599,-118.395706,
36.957401,-118.403801,36.9576,
-118.403503,36.972099,-118.4086,
36.9753,-118.410202,36.983002,
-118.418602,36.987499,-118.417999,
36.9949,-118.411301,36.998402,
-118.427048,37.011299,-118.422173,
37.017002,-118.421822,37.025871,
-118.428566,37.034012,-118.438286,
37.039063,-118.440788,37.045078,
-118.434029,37.049805,-118.437294,
37.055958,-118.435112,37.057331,
-118.436203,37.059883,-118.448021,
37.069206,-118.4664,37.066811,
-118.470207,37.072727,-118.485641,
37.07748,-118.491722,37.087532,
-118.502167,37.095287,-118.510925,
37.092884,-118.521194,37.098423,
-118.528831,37.105148,-118.529991,
37.111248,-118.544128,37.11544,
-118.563171,37.113277,-118.567474,
37.11536,-118.568085,37.122669,
-118.582146,37.122463,-118.590141,
37.136658,-118.591721,37.13821,
-118.599174,37.136665,-118.612473,
37.143078,-118.628563,37.137493,
-118.633652,37.138927,-118.64035,
37.137299,-118.645584,37.140846,
-118.653648,37.141891,-118.655762,
37.147278,-118.666245,37.154705,
-118.665558,37.161453,-118.671707,
37.167408,-118.6633,37.178211,
-118.666191,37.182514,-118.665512,
37.189564,-118.680405,37.204502,
-118.674675,37.214211,-118.678162,
37.21452,-118.678177,37.22002,
-118.685478,37.227638,-118.681305,
37.234047,-118.683609,37.237652,
-118.6828,37.244434,-118.673897,
37.249035,-118.664383,37.261986,
-118.681152,37.28054,-118.684273,
37.290535,-118.693939,37.301849,
-118.694008,37.306087,-118.697617,
37.305653,-118.715065,37.328278,
-118.727798,37.323067,-118.732018,
37.317955,-118.740166,37.315403,
-118.742889,37.319611,-118.756905,
37.328903,-118.773399,37.334869,
-118.77916,37.334942,-118.785782,
37.343445,-118.780563,37.35648,
-118.767654,37.359901,-118.769119,
37.366287,-118.766731,37.367733,
-118.772377,37.375,-118.777649,
37.376022,-118.778595,37.381657,
-118.781693,37.382774,-118.789078,
37.3941,-118.781075,37.407776,
-118.7826,37.41338,-118.778801,
37.421745,-118.774727,37.424644,
-118.769539,37.422146,-118.766556,
37.42371,-118.764137,37.429794,
-118.759216,37.433701,-118.757896,
37.441338,-118.762329,37.456604,
-118.771179,37.458614,-118.774055,
37.46312,-118.776939,37.469433,
-118.784096,37.473953,-118.785088,
37.478748,-118.796135,37.488781,
-118.803322,37.489002,-118.809326,
37.486111,-118.814568,37.487873,
-118.831841,37.480259,-118.835068,
37.482586,-118.840942,37.480961,
-118.848801,37.475925,-118.855095,
37.478458,-118.859802,37.501598,
-118.866501,37.507198,-118.880707,
37.510399,-118.882706,37.520199,
-118.890106,37.525398,-118.900902,
37.5261,-118.9002,37.5313,
-118.916107,37.5504,-118.928703,
37.549,-118.938004,37.554501,
-118.941704,37.562199,-118.951706,
37.565899,-118.955399,37.562801,
-118.958801,37.563202,-118.963104,
37.558201,-118.971504,37.559502,
-118.975998,37.5569,-118.983902,
37.567402,-118.989601,37.5672,
-119.001305,37.571201,-119.007301,
37.577599,-119.0214,37.5858)),
'Fresno','06019','California','CA','06',5962.1835,667490,111.9539);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.936539,39.798279,-122.937294,
39.748238,-122.9114,39.748287,
-122.911766,39.708847,-122.891571,
39.709019,-122.889305,39.623035,
-122.883385,39.610886,-122.884239,
39.580227,-122.734535,39.580788,
-122.735443,39.508656,-122.730545,
39.479359,-122.731499,39.450871,
-122.740639,39.435349,-122.737961,
39.383385,-122.593445,39.385658,
-122.430191,39.383896,-122.134918,
39.385609,-122.135071,39.414616,
-122.124535,39.414707,-122.007767,
39.413685,-122.002625,39.397942,
-122.008652,39.38398,-121.888954,
39.384007,-121.883224,39.410294,
-121.876633,39.422943,-121.876953,
39.427776,-121.874115,39.428028,
-121.875847,39.438461,-121.872955,
39.447411,-121.869675,39.448833,
-121.873756,39.46064,-121.868271,
39.466316,-121.872437,39.478722,
-121.869789,39.485241,-121.876045,
39.501896,-121.874054,39.503422,
-121.876259,39.509663,-121.855385,
39.532757,-121.855438,39.536842,
-121.944099,39.536194,-121.972946,
39.528969,-121.974625,39.532646,
-121.98214,39.533035,-121.984573,
39.531143,-121.993744,39.536594,
-122.001968,39.559616,-121.991631,
39.562168,-121.989532,39.56498,
-121.992516,39.567848,-122,39.568615,
-122.002258,39.573929,-121.994278,
39.581722,-121.99379,39.605213,
-121.98127,39.61153,-121.978279,
39.616203,-121.982445,39.62352,
-121.990005,39.627148,-121.991333,
39.641617,-121.978195,39.648045,
-121.967995,39.648064,-121.965706,
39.651707,-121.975906,39.664288,
-121.988564,39.660183,-121.995911,
39.66415,-121.996277,39.668652,
-121.99337,39.671295,-121.983276,
39.670238,-121.972504,39.676041,
-121.95916,39.678032,-121.955818,
39.687469,-121.94294,39.692039,
-121.940231,39.698669,-121.948914,
39.719269,-121.945595,39.729698,
-121.950256,39.73288,-121.956154,
39.719189,-121.961433,39.717842,
-121.964714,39.719803,-121.966354,
39.724758,-121.959091,39.734329,
-121.962852,39.741596,-121.968391,
39.739803,-121.970367,39.731922,
-121.98101,39.734188,-121.994072,
39.75,-122.004372,39.757881,
-122.017311,39.762756,-122.031326,
39.778843,-122.024506,39.788269,
-122.023079,39.798641,-122.026817,
39.800549,-122.032539,39.799507,
-122.039032,39.79287,-122.04538,
39.797768,-122.843307,39.800629,
-122.936539,39.798279)),'Glenn',
'06021','California','CA','06',1314.6582,24798,18.8626);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-124.064072,41.465057,-124.064018,
41.464897,-124.062897,41.427952,
-124.068031,41.395813,-124.094467,
41.276043,-124.121498,41.18988,
-124.140266,41.14801,-124.160187,
41.141788,-124.158936,41.069572,
-124.147736,41.049652,-124.129059,
41.047165,-124.112869,41.028488,
-124.11412,41.004833,-124.14151,
40.913944,-124.16143,40.867874,
-124.193802,40.815582,-124.31208,
40.641277,-124.335739,40.600189,
-124.370598,40.531712,-124.386787,
40.508057,-124.407951,40.438335,
-124.388031,40.404716,-124.370598,
40.392269,-124.348183,40.313828,
-124.35939,40.281456,-124.361877,
40.256557,-124.318306,40.222939,
-124.226173,40.166912,-124.185089,
40.129559,-124.137779,40.115864,
-124.106651,40.098434,-124.08548,
40.076023,-124.078011,40.062328,
-124.079254,40.02747,-124.069298,
40.018753,-124.05809,40.022488,
-124.040665,40.017509,-124.02359,
40.002712,-123.543327,40.002052,
-123.543121,40.498783,-123.541862,
40.733715,-123.546944,40.746517,
-123.550659,40.748268,-123.549751,
40.756226,-123.553009,40.759644,
-123.549042,40.762943,-123.549034,
40.765682,-123.553352,40.766796,
-123.548714,40.775948,-123.557129,
40.781212,-123.556458,40.787395,
-123.558884,40.790413,-123.563644,
40.787846,-123.565094,40.788952,
-123.564697,40.796371,-123.556625,
40.793884,-123.552917,40.796452,
-123.555061,40.80896,-123.561371,
40.809841,-123.567574,40.819881,
-123.558472,40.83046,-123.565086,
40.835121,-123.562958,40.842373,
-123.572716,40.84483,-123.574677,
40.858139,-123.586563,40.858929,
-123.579437,40.868145,-123.583809,
40.869888,-123.589951,40.867424,
-123.59684,40.877762,-123.609093,
40.879116,-123.600555,40.880096,
-123.596046,40.884247,-123.607246,
40.895271,-123.6036,40.900856,
-123.614769,40.914303,-123.612511,
40.922428,-123.620331,40.925903,
-123.622589,40.929424,-123.6213,
40.93185,-123.610199,40.929401,
-123.598106,40.931301,-123.590401,
40.927502,-123.5867,40.927898,
-123.580399,40.9333,-123.570503,
40.937199,-123.566505,40.936699,
-123.568802,40.946701,-123.558998,
40.950401,-123.540001,40.9398,
-123.539803,40.9324,-123.532707,
40.930901,-123.528603,40.935001,
-123.526505,40.932732,-123.513702,
40.9249,-123.510597,40.920502,
-123.495506,40.916302,-123.480301,
40.9151,-123.476799,40.9282,
-123.466507,40.938301,-123.4468,
40.943901,-123.444504,40.947201,
-123.443703,40.956299,-123.451797,
40.960201,-123.452103,40.964298,
-123.435402,40.973801,-123.433701,
40.9827,-123.426102,40.9884,
-123.426949,41,-123.424599,41.003654,
-123.418907,41.009819,-123.404877,
41.013042,-123.409149,41.020821,
-123.406067,41.030766,-123.418129,
41.034664,-123.422569,41.043343,
-123.422089,41.058285,-123.429565,
41.063412,-123.434059,41.06076,
-123.441406,41.061264,-123.45137,
41.068676,-123.456787,41.068359,
-123.458443,41.073883,-123.462845,
41.076496,-123.457123,41.083931,
-123.463333,41.09267,-123.462196,
41.09478,-123.455292,41.090641,
-123.445168,41.08902,-123.438644,
41.09269,-123.440063,41.094948,
-123.434669,41.102497,-123.433128,
41.111801,-123.428085,41.118149,
-123.428246,41.14492,-123.430328,
41.147877,-123.427605,41.152206,
-123.43145,41.162476,-123.42057,
41.166687,-123.415787,41.165676,
-123.409203,41.170853,-123.407127,
41.180092,-123.415932,41.197151,
-123.426544,41.203487,-123.428749,
41.208977,-123.434441,41.213097,
-123.435837,41.218922,-123.433205,
41.223026,-123.436729,41.227039,
-123.449738,41.231392,-123.454147,
41.236683,-123.441261,41.251663,
-123.442894,41.27319,-123.460587,
41.28236,-123.461975,41.285244,
-123.454315,41.292969,-123.455719,
41.300442,-123.459167,41.303455,
-123.458427,41.310387,-123.462273,
41.317879,-123.471306,41.321701,
-123.472832,41.326523,-123.47747,
41.3298,-123.477203,41.340462,
-123.481346,41.353806,-123.472923,
41.366344,-123.479851,41.372139,
-123.488243,41.377819,-123.497093,
41.379063,-123.5,41.382721,
-123.660194,41.382244,-123.769066,
41.380932,-123.769379,41.464348,
-123.884514,41.464008,-123.884521,
41.466007,-124.064072,41.465057)),
'Humboldt','06023','California','CA','06',3572.1816,119118,33.3459);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-116.084328,33.425903,-116.080246,
33.074799,-116.102409,33.074623,
-116.102295,32.72644,-116.104797,
32.726437,-116.105339,32.61853,
-114.718849,32.718716,-114.713737,
32.730343,-114.70079,32.745586,
-114.687737,32.737545,-114.616875,
32.728168,-114.614799,32.728401,
-114.614304,32.734463,-114.581001,
32.734901,-114.580956,32.742275,
-114.563728,32.742252,-114.563667,
32.749508,-114.538437,32.749767,
-114.538315,32.756905,-114.52607,
32.75705,-114.531647,32.776878,
-114.528847,32.795433,-114.50943,
32.816376,-114.493408,32.823189,
-114.468193,32.845112,-114.462112,
32.905758,-114.463196,32.912399,
-114.475853,32.923588,-114.480003,
32.93364,-114.479439,32.937889,
-114.467278,32.955219,-114.467827,
32.971611,-114.475754,32.975136,
-114.487839,32.969906,-114.492157,
32.971741,-114.50045,33.007519,
-114.507179,33.019669,-114.515671,
33.027576,-114.530296,33.032356,
-114.570869,33.036587,-114.577507,
33.035336,-114.583977,33.028191,
-114.588989,33.026192,-114.617996,
33.027164,-114.627502,33.031013,
-114.638771,33.045254,-114.645195,
33.048862,-114.657043,33.033787,
-114.66153,33.032631,-114.672874,
33.041859,-114.673508,33.057133,
-114.686203,33.07093,-114.688232,
33.084,-114.703934,33.087013,
-114.707031,33.091064,-114.705383,
33.105297,-114.696037,33.131172,
-114.686287,33.142159,-114.678566,
33.159485,-114.679459,33.169682,
-114.674568,33.185455,-114.677963,
33.203415,-114.672836,33.223087,
-114.688751,33.246395,-114.671295,
33.258465,-114.679718,33.273544,
-114.693657,33.279755,-114.720879,
33.286949,-114.730431,33.302402,
-114.722832,33.312077,-114.707169,
33.323391,-114.700142,33.336983,
-114.69725,33.352413,-114.698265,
33.361118,-114.706558,33.376598,
-114.70652,33.382511,-114.724747,
33.404026,-114.719269,33.407864,
-114.700943,33.40836,-114.694862,
33.415096,-114.687157,33.417915,
-114.673111,33.41827,-114.657593,
33.41301,-114.64875,33.413605,
-114.634392,33.422699,-114.626335,
33.433525,-114.83007,33.433681,
-114.83004,33.430065,-115.062393,
33.428078,-115.46669,33.428375,
-115.46669,33.426964,-115.5,
33.426846,-116.084328,33.425903)),
'Imperial','06025','California','CA','06',4174.3359,109303,26.1845);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-118.774055,37.46312,-118.771179,
37.458614,-118.762329,37.456604,
-118.757896,37.441338,-118.759216,
37.433701,-118.764137,37.429794,
-118.766556,37.42371,-118.769539,
37.422146,-118.774727,37.424644,
-118.778801,37.421745,-118.7826,
37.41338,-118.781075,37.407776,
-118.789078,37.3941,-118.781693,
37.382774,-118.778595,37.381657,
-118.777649,37.376022,-118.772377,
37.375,-118.766731,37.367733,
-118.769119,37.366287,-118.767654,
37.359901,-118.780563,37.35648,
-118.785782,37.343445,-118.77916,
37.334942,-118.773399,37.334869,
-118.756905,37.328903,-118.742889,
37.319611,-118.740166,37.315403,
-118.732018,37.317955,-118.727798,
37.323067,-118.715065,37.328278,
-118.697617,37.305653,-118.694008,
37.306087,-118.693939,37.301849,
-118.684273,37.290535,-118.681152,
37.28054,-118.664383,37.261986,
-118.673897,37.249035,-118.6828,
37.244434,-118.683609,37.237652,
-118.681305,37.234047,-118.685478,
37.227638,-118.678177,37.22002,
-118.678162,37.21452,-118.674675,
37.214211,-118.680405,37.204502,
-118.665512,37.189564,-118.666191,
37.182514,-118.6633,37.178211,
-118.671707,37.167408,-118.665558,
37.161453,-118.666245,37.154705,
-118.655762,37.147278,-118.653648,
37.141891,-118.645584,37.140846,
-118.64035,37.137299,-118.633652,
37.138927,-118.628563,37.137493,
-118.612473,37.143078,-118.599174,
37.136665,-118.591721,37.13821,
-118.590141,37.136658,-118.582146,
37.122463,-118.568085,37.122669,
-118.567474,37.11536,-118.563171,
37.113277,-118.544128,37.11544,
-118.529991,37.111248,-118.528831,
37.105148,-118.521194,37.098423,
-118.510925,37.092884,-118.502167,
37.095287,-118.491722,37.087532,
-118.485641,37.07748,-118.470207,
37.072727,-118.4664,37.066811,
-118.448021,37.069206,-118.436203,
37.059883,-118.435112,37.057331,
-118.437294,37.055958,-118.434029,
37.049805,-118.440788,37.045078,
-118.438286,37.039063,-118.428566,
37.034012,-118.421822,37.025871,
-118.422173,37.017002,-118.427048,
37.011299,-118.411301,36.998402,
-118.417999,36.9949,-118.418602,
36.987499,-118.410202,36.983002,
-118.4086,36.9753,-118.403503,
36.972099,-118.403801,36.9576,
-118.395706,36.957401,-118.387505,
36.945599,-118.3806,36.925999,
-118.370102,36.908699,-118.366501,
36.907101,-118.368301,36.898499,
-118.359901,36.887798,-118.361504,
36.883701,-118.366203,36.8815,
-118.369247,36.871758,-118.365234,
36.868969,-118.364624,36.862347,
-118.361298,36.861423,-118.361237,
36.844067,-118.37056,36.836147,
-118.388824,36.834534,-118.392792,
36.829735,-118.390198,36.821037,
-118.373093,36.80024,-118.371872,
36.794609,-118.379303,36.782299,
-118.375107,36.778599,-118.375504,
36.772202,-118.371101,36.767101,
-118.373802,36.764198,-118.370796,
36.761299,-118.368301,36.750099,
-118.361198,36.747799,-118.359657,
36.744839,-118.349998,36.740799,
-118.338707,36.729099,-118.333801,
36.705399,-118.345802,36.696602,
-118.360107,36.695202,-118.365501,
36.691299,-118.360107,36.6861,
-118.351105,36.682999,-118.346603,
36.672401,-118.338997,36.672798,
-118.330307,36.669498,-118.328598,
36.665501,-118.334702,36.661701,
-118.336655,36.654869,-118.324303,
36.647202,-118.317902,36.639,
-118.320396,36.627499,-118.310104,
36.625,-118.308403,36.621498,
-118.301903,36.619099,-118.301506,
36.6147,-118.292999,36.605202,
-118.288101,36.603401,-118.280701,
36.604599,-118.273705,36.597401,
-118.277107,36.5924,-118.288101,
36.590801,-118.287102,36.583801,
-118.293198,36.577499,-118.288902,
36.573299,-118.291702,36.567501,
-118.290306,36.559399,-118.278503,
36.555199,-118.274002,36.550598,
-118.264397,36.551601,-118.2593,
36.544201,-118.251106,36.542198,
-118.247704,36.533298,-118.25,
36.5289,-118.248505,36.524101,
-118.245796,36.5215,-118.237907,
36.523701,-118.236504,36.5116,
-118.240501,36.500099,-118.2341,
36.493801,-118.247505,36.487099,
-118.249001,36.482498,-118.236107,
36.4771,-118.231705,36.4664,
-118.222305,36.463402,-118.214996,
36.456799,-118.213303,36.448299,
-118.208702,36.4422,-118.213501,
36.434399,-118.2089,36.430401,
-118.202797,36.431301,-118.192703,
36.426601,-118.174004,36.426601,
-118.155907,36.432701,-118.153305,
36.4272,-118.145935,36.424049,
-118.137001,36.418098,-118.139397,
36.403599,-118.145302,36.398701,
-118.159103,36.393902,-118.162102,
36.389702,-118.156197,36.388401,
-118.152199,36.379601,-118.1464,
36.3792,-118.140106,36.3717,
-118.129601,36.370399,-118.121597,
36.354801,-118.123306,36.352001,
-118.099403,36.346199,-118.100906,
36.339401,-118.096703,36.3312,
-118.102135,36.325459,-118.106644,
36.325672,-118.111603,36.322102,
-118.113251,36.319324,-118.110901,
36.308399,-118.120705,36.3069,
-118.119202,36.302299,-118.126091,
36.300285,-118.124107,36.286808,
-118.126686,36.280411,-118.121056,
36.27776,-118.11647,36.271229,
-118.118446,36.255623,-118.111305,
36.240101,-118.104301,36.2337,
-118.104301,36.228699,-118.108307,
36.225601,-118.104706,36.213501,
-118.093704,36.205002,-118.089798,
36.197399,-118.084999,36.197601,
-118.0728,36.189499,-118.069107,
36.178699,-118.060707,36.174,
-118.058403,36.1702,-118.061707,
36.1623,-118.058105,36.157902,
-118.0588,36.150902,-118.069397,
36.144501,-118.072701,36.139099,
-118.063705,36.1105,-118.067398,
36.108601,-118.065308,36.104,
-118.066399,36.093498,-118.062202,
36.089298,-118.056702,36.091702,
-118.049904,36.080299,-118.050797,
36.059601,-118.046997,36.056,
-118.047707,36.053299,-118.041801,
36.048599,-118.045403,36.042301,
-118.038597,36.034302,-118.040504,
36.0299,-118.036201,36.029202,
-118.033104,36.009701,-118.011169,
35.99836,-118.009758,35.991798,
-118.005325,35.989811,-118.002663,
35.983776,-118.003586,35.977211,
-118.008705,35.978233,-118.013657,
35.972946,-118.011597,35.968948,
-118.017136,35.962444,-118.015877,
35.954609,-118.010162,35.954655,
-118.005974,35.946541,-117.998352,
35.946655,-117.991035,35.943825,
-117.984474,35.9342,-117.982376,
35.926617,-117.98941,35.914101,
-117.988106,35.907951,-117.984467,
35.905365,-117.986168,35.8993,
-117.981148,35.894749,-117.983788,
35.887775,-117.988106,35.884167,
-117.9879,35.879826,-117.981956,
35.875,-117.980133,35.866962,
-117.989632,35.865875,-117.992752,
35.869663,-117.995789,35.869549,
-118.004585,35.862751,-118.006516,
35.858231,-118.003876,35.851315,
-118.004524,35.843327,-118.002007,
35.841343,-118.005287,35.829086,
-117.997696,35.823078,-118.006813,
35.817135,-118.006569,35.810051,
-118.009575,35.804436,-118.00663,
35.799973,-118.007133,35.789211,
-117.922211,35.786865,-117.923553,
35.798199,-117.632095,35.797298,
-117.250046,35.795052,-116.069458,
35.793503,-115.735046,35.793648,
-115.734901,35.809124,-115.646362,
35.809021,-115.897507,36.004211,
-117.165108,36.971176,-117.831802,
37.465,-118.203384,37.462711,
-118.774055,37.46312)),'Inyo',
'06027','California','CA','06',10190.3203,18281,1.7939);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.193169,35.789242,-120.19294,
35.614391,-120.084946,35.614559,
-120.085693,35.526588,-120.06768,
35.526356,-120.067924,35.512814,
-120.050262,35.51273,-120.050072,
35.498661,-120.032265,35.498676,
-120.032333,35.483685,-120.013634,
35.483688,-120.014687,35.46907,
-119.996407,35.468735,-119.996422,
35.439529,-119.879082,35.439167,
-119.879211,35.351246,-119.808388,
35.350899,-119.808487,35.263615,
-119.665703,35.262566,-119.6661,
35.174839,-119.552689,35.180008,
-119.560013,35.087704,-119.489677,
35.091835,-119.489754,35.07724,
-119.471771,35.076916,-119.471802,
34.901199,-119.441399,34.901299,
-119.381203,34.900963,-119.3815,
34.8797,-119.276001,34.8797,
-119.277397,34.8573,-119.242706,
34.857601,-119.242706,34.814201,
-118.975784,34.812222,-118.975792,
34.79068,-118.880966,34.790642,
-118.893539,34.817776,-118.446739,
34.81776,-117.666397,34.822544,
-117.631119,34.822289,-117.630402,
35.419605,-117.632767,35.451035,
-117.629318,35.45108,-117.629082,
35.539982,-117.629234,35.564117,
-117.633881,35.564152,-117.63398,
35.622364,-117.632935,35.651512,
-117.615501,35.651798,-117.615303,
35.680901,-117.651421,35.680828,
-117.651085,35.70998,-117.633354,
35.709976,-117.632095,35.797298,
-117.923553,35.798199,-117.922211,
35.786865,-118.007133,35.789211,
-118.066811,35.791588,-118.375,
35.790276,-118.469177,35.792683,
-118.506302,35.789761,-118.625847,
35.789585,-119.537163,35.789612,
-120.193169,35.789242)),'Kern',
'06029','California','CA','06',8140.2304,543477,66.7642);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.314087,35.907223,-120.275963,
35.906506,-120.242294,35.877708,
-120.24424,35.873161,-120.239273,
35.865967,-120.24501,35.864178,
-120.249313,35.857891,-120.25528,
35.855465,-120.254021,35.853027,
-120.256523,35.851913,-120.258331,
35.845093,-120.254112,35.842621,
-120.248856,35.829971,-120.243561,
35.824024,-120.237938,35.825787,
-120.218925,35.818951,-120.216911,
35.811642,-120.218452,35.806065,
-120.215576,35.80368,-120.212997,
35.78931,-120.193169,35.789242,
-119.537163,35.789612,-119.535416,
36.137966,-119.528358,36.137943,
-119.528671,36.26965,-119.473785,
36.268978,-119.473938,36.401005,
-119.528061,36.401653,-119.527473,
36.488972,-119.572083,36.488995,
-119.665802,36.4188,-119.671799,
36.427299,-119.670502,36.431,
-119.680199,36.4296,-119.685402,
36.4259,-119.703796,36.426998,
-119.7108,36.419399,-119.720306,
36.417702,-119.729599,36.4207,
-119.7341,36.415798,-119.736397,
36.4175,-119.746002,36.416401,
-119.751198,36.4091,-119.749504,
36.405201,-119.751602,36.402199,
-119.95916,36.40099,-119.958237,
36.181454,-120.314087,35.907223)),
'Kings','06031','California','CA','06',1389.247,101469,73.0388);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.884239,39.580227,-122.889198,
39.529137,-122.935585,39.53083,
-122.935585,39.516518,-123.024117,
39.518829,-123.023842,39.511299,
-123.043335,39.511318,-123.043282,
39.503704,-123.062065,39.503658,
-123.061905,39.452599,-123.071999,
39.452801,-123.069,39.4366,
-123.073799,39.436699,-123.073997,
39.407799,-123.055199,39.4077,
-123.056,39.378799,-123.046402,
39.3787,-123.047501,39.364201,
-123.036797,39.363998,-123.036598,
39.3363,-123.027603,39.3367,
-123.027603,39.321899,-123.0186,
39.321899,-123.018501,39.278099,
-123.003403,39.278301,-123.002502,
39.2575,-122.993378,39.25687,
-122.993729,39.236034,-123.011597,
39.236301,-123.011398,39.2211,
-123.019707,39.220798,-123.023201,
39.207199,-123.027702,39.206902,
-123.028603,39.199699,-123.032997,
39.199799,-123.033707,39.192501,
-123.039001,39.1926,-123.039803,
39.180801,-123.044304,39.180698,
-123.044701,39.173599,-123.076706,
39.173901,-123.077003,39.138832,
-123.086403,39.1385,-123.0839,
39.095402,-123.093102,39.095402,
-123.093094,39.080631,-123.091904,
39.072102,-123.082603,39.071899,
-123.082703,39.064602,-123.064003,
39.064499,-123.064102,39.050098,
-123.055,39.049999,-123.055107,
39.021198,-123.045906,39.021,
-123.045708,39.013901,-123.0364,
39.013802,-123.036201,39.006599,
-123.026901,39.006599,-123.026932,
38.996696,-123.017509,38.996716,
-123.017471,38.993061,-123.008148,
38.993279,-123.008141,38.997269,
-122.985527,38.997387,-122.985573,
38.983112,-122.976318,38.983006,
-122.976608,38.946789,-122.967178,
38.946609,-122.968811,38.932762,
-122.959084,38.932571,-122.960785,
38.925613,-122.94796,38.925545,
-122.947762,38.900318,-122.910255,
38.9016,-122.910248,38.895271,
-122.892784,38.895622,-122.893532,
38.880932,-122.874596,38.880924,
-122.875397,38.873226,-122.856659,
38.87336,-122.857384,38.865948,
-122.83889,38.866123,-122.838989,
38.858093,-122.82029,38.858021,
-122.820488,38.850235,-122.816544,
38.849937,-122.817207,38.844685,
-122.811043,38.843006,-122.810982,
38.838509,-122.80513,38.836323,
-122.794823,38.839088,-122.790291,
38.830528,-122.779091,38.826935,
-122.768501,38.820045,-122.765579,
38.813995,-122.758652,38.808525,
-122.747078,38.803925,-122.745094,
38.799343,-122.747124,38.787891,
-122.736923,38.781136,-122.733459,
38.772705,-122.728439,38.770802,
-122.727242,38.766315,-122.721596,
38.763107,-122.723053,38.756657,
-122.707489,38.748928,-122.711235,
38.742321,-122.709282,38.732178,
-122.69957,38.728657,-122.694351,
38.713184,-122.673134,38.706448,
-122.668304,38.708466,-122.661087,
38.706032,-122.64579,38.706638,
-122.643219,38.699665,-122.635956,
38.693825,-122.638397,38.689152,
-122.624367,38.674496,-122.626305,
38.667599,-122.462799,38.705299,
-122.414703,38.768101,-122.401802,
38.772999,-122.407906,38.776402,
-122.408997,38.785599,-122.411201,
38.7859,-122.396904,38.8041,
-122.378304,38.8022,-122.372398,
38.817101,-122.380905,38.8339,
-122.402802,38.855701,-122.393967,
38.864349,-122.390114,38.868816,
-122.404579,38.879967,-122.404175,
38.883503,-122.414467,38.897202,
-122.420959,38.900993,-122.402946,
38.925392,-122.339088,38.924347,
-122.34034,38.927246,-122.349022,
38.928879,-122.366493,38.939137,
-122.371933,38.939919,-122.392944,
38.955711,-122.400818,38.955936,
-122.408035,38.962894,-122.405937,
38.971519,-122.415604,38.978146,
-122.418221,38.989281,-122.413727,
38.993568,-122.414642,38.997295,
-122.410835,38.998241,-122.408272,
39.011459,-122.40889,39.017616,
-122.412315,39.020317,-122.436203,
39.021465,-122.453766,39.034515,
-122.455963,39.038502,-122.460182,
39.038776,-122.466408,39.043514,
-122.464294,39.049221,-122.490944,
39.053596,-122.489441,39.065079,
-122.482796,39.067062,-122.487595,
39.069317,-122.48877,39.074345,
-122.484718,39.08564,-122.487724,
39.099785,-122.493248,39.104412,
-122.495018,39.111057,-122.493111,
39.115185,-122.499817,39.121185,
-122.493698,39.13596,-122.495743,
39.140614,-122.491829,39.139568,
-122.485542,39.141766,-122.47982,
39.138737,-122.473633,39.144478,
-122.481033,39.152359,-122.477158,
39.154541,-122.478302,39.158123,
-122.481483,39.163036,-122.475937,
39.167149,-122.474991,39.17271,
-122.48777,39.176414,-122.490723,
39.175404,-122.497452,39.191204,
-122.507309,39.190434,-122.513367,
39.19733,-122.514236,39.209328,
-122.533897,39.211708,-122.540321,
39.207027,-122.571274,39.204224,
-122.579536,39.211639,-122.608719,
39.216301,-122.622375,39.223324,
-122.634216,39.222961,-122.64772,
39.214127,-122.656815,39.214981,
-122.664261,39.217659,-122.672417,
39.225815,-122.678635,39.224644,
-122.675034,39.230942,-122.680603,
39.234676,-122.679825,39.238838,
-122.685753,39.241264,-122.690262,
39.247543,-122.711349,39.257126,
-122.715866,39.260574,-122.716034,
39.263649,-122.722107,39.265392,
-122.727539,39.273396,-122.735634,
39.272694,-122.755989,39.284424,
-122.757118,39.294064,-122.765022,
39.301144,-122.769394,39.310135,
-122.773941,39.311893,-122.774368,
39.315296,-122.771423,39.324097,
-122.767189,39.325603,-122.767136,
39.331261,-122.763382,39.336544,
-122.764206,39.342861,-122.751259,
39.346165,-122.744736,39.356335,
-122.741341,39.357578,-122.741112,
39.365414,-122.742378,39.368248,
-122.751144,39.370701,-122.75885,
39.378246,-122.767632,39.373863,
-122.773186,39.374817,-122.783981,
39.383091,-122.737961,39.383385,
-122.740639,39.435349,-122.731499,
39.450871,-122.730545,39.479359,
-122.735443,39.508656,-122.734535,
39.580788,-122.884239,39.580227)),
'Lake','06033','California','CA','06',1258.247,50631,40.2392);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.330704,41.183998,-121.331253,
40.905506,-121.318878,40.90601,
-121.321907,40.497704,-121.3256,
40.497696,-121.326744,40.445484,
-121.060341,40.446648,-121.060425,
40.256531,-121.040451,40.256588,
-121.040451,40.234905,-121.002846,
40.23505,-121.002663,40.221088,
-120.945122,40.220921,-120.946091,
40.206612,-120.927002,40.206566,
-120.927513,40.192039,-120.889587,
40.192226,-120.88961,40.19952,
-120.870697,40.199547,-120.87072,
40.241753,-120.852043,40.241905,
-120.852135,40.24894,-120.842537,
40.249001,-120.842438,40.256126,
-120.832993,40.256271,-120.832748,
40.270836,-120.81395,40.270836,
-120.813576,40.277943,-120.794937,
40.27784,-120.795532,40.301262,
-120.772743,40.301537,-120.772667,
40.308788,-120.763283,40.308823,
-120.763336,40.316116,-120.72551,
40.316036,-120.725349,40.30854,
-120.651093,40.307758,-120.650581,
40.300552,-120.641273,40.300499,
-120.641449,40.293289,-120.621597,
40.293121,-120.621735,40.285816,
-120.575768,40.285538,-120.575668,
40.263901,-120.547653,40.263702,
-120.547607,40.256378,-120.528648,
40.256306,-120.528679,40.249298,
-120.50975,40.249039,-120.509613,
40.234798,-120.490662,40.234894,
-120.490997,40.22039,-120.481407,
40.220284,-120.481789,40.205898,
-120.453278,40.205853,-120.453247,
40.191456,-120.443878,40.191383,
-120.444839,40.176956,-120.43531,
40.176762,-120.435318,40.169662,
-120.415878,40.169544,-120.416199,
40.162186,-120.40657,40.162258,
-120.406906,40.147457,-120.397209,
40.147465,-120.397255,40.140739,
-120.378067,40.140656,-120.378349,
40.129608,-120.359375,40.129623,
-120.359566,40.122616,-120.340416,
40.122658,-120.34034,40.115345,
-120.265518,40.115967,-120.264595,
40.107849,-120.245743,40.107979,
-120.245857,40.085907,-120.208603,
40.086109,-120.209846,40.042858,
-120.20034,40.042824,-120.200226,
40.013573,-120.18145,40.013447,
-120.181419,39.998619,-120.171967,
39.998425,-120.172234,39.98399,
-120.162369,39.983875,-120.162613,
39.968758,-120.153297,39.968632,
-120.153343,39.962448,-120.143974,
39.962387,-120.143951,39.955166,
-120.134682,39.955135,-120.134735,
39.947861,-120.125671,39.947849,
-120.125534,39.939648,-120.107727,
39.939606,-120.107849,39.910473,
-120.098518,39.910435,-120.098305,
39.881317,-120.107063,39.881359,
-120.106773,39.794304,-120.110023,
39.780968,-120.109589,39.765873,
-120.118553,39.765724,-120.11808,
39.751183,-120.126602,39.751026,
-120.12674,39.736256,-120.145561,
39.7365,-120.146111,39.707752,
-120.014702,39.708813,-120.014778,
39.722462,-120.00029,39.722511,
-119.996246,40,-119.994888,40.5,
-119.998817,41.184078,-120.665581,
41.183949,-121.330704,41.183998)),
'Lassen','06035','California','CA','06',4556.707,27598,6.0565);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2007,8265,null,
MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,67,1003,1,137,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-118.423691,32.80003,-118.41597,
32.806465,-118.401817,32.812256,
-118.399887,32.819977,-118.390877,
32.823189,-118.381874,32.823837,
-118.355499,32.816116,-118.347771,
32.820618,-118.452003,32.900398,
-118.463577,32.912621,-118.478378,
32.919697,-118.495102,32.931923,
-118.520844,32.964737,-118.545937,
32.989185,-118.546577,32.998833,
-118.560089,33.011703,-118.563301,
33.023926,-118.573601,33.032932,
-118.592896,33.036152,-118.605766,
33.032288,-118.605766,33.014275,
-118.592896,33.012344,-118.585823,
33.006554,-118.582458,33,-118.576164,
32.975674,-118.549789,32.944149,
-118.540146,32.910046,-118.528557,
32.901043,-118.507324,32.869514,
-118.49897,32.851501,-118.472588,
32.83799,-118.437851,32.814186,
-118.423691,32.80003,-118.325897,
33.297543,-118.310654,33.303467,
-118.301353,33.313625,-118.306427,
33.329704,-118.315735,33.343246,
-118.363136,33.387257,-118.37075,
33.41011,-118.424919,33.427883,
-118.45031,33.432114,-118.479088,
33.448196,-118.496857,33.443119,
-118.502007,33.450352,-118.535789,
33.475281,-118.576416,33.475281,
-118.606041,33.478664,-118.60096,
33.46851,-118.58065,33.450737,
-118.572182,33.438042,-118.559486,
33.432961,-118.534103,33.430424,
-118.514633,33.420269,-118.49855,
33.420269,-118.487549,33.417728,
-118.483322,33.406727,-118.483322,
33.388107,-118.487549,33.355946,
-118.480774,33.3424,-118.465546,
33.326321,-118.438461,33.317856,
-118.419838,33.316162,-118.388527,
33.31955,-118.374138,33.317856,
-118.354675,33.311932,-118.334358,
33.300083,-118.325897,33.297543,
-118.880966,34.790642,-118.635681,
34.291729,-118.631409,34.26387,
-118.63163,34.240208,-118.666626,
34.240398,-118.667038,34.168095,
-118.787773,34.16851,-118.939873,
34.074959,-118.943748,34.04583,
-118.935982,34.042866,-118.849792,
34.032928,-118.81411,34.008209,
-118.806465,34.000065,-118.794334,
34.006767,-118.786179,34.019539,
-118.758705,34.02533,-118.743744,
34.032112,-118.704323,34.029663,
-118.680466,34.031055,-118.647682,
34.037502,-118.53923,34.037121,
-118.5186,34.0275,-118.496506,
34.009499,-118.4757,33.987499,
-118.441505,33.9403,-118.408295,
33.876801,-118.401604,33.8615,
-118.399002,33.843201,-118.390305,
33.838402,-118.390602,33.815399,
-118.393997,33.803501,-118.404106,
33.800201,-118.427505,33.7747,
-118.410103,33.740616,-118.395294,
33.735115,-118.385559,33.740196,
-118.378792,33.740616,-118.374138,
33.736385,-118.359329,33.736385,
-118.350861,33.727501,-118.295425,
33.707607,-118.292885,33.7038,
-118.280617,33.707184,-118.271729,
33.713955,-118.253952,33.739349,
-118.245064,33.747387,-118.235748,
33.751198,-118.222214,33.752468,
-118.180321,33.763046,-118.147308,
33.757969,-118.132072,33.752468,
-118.116257,33.742897,-118.1138,
33.746101,-118.091003,33.758701,
-118.092621,33.76778,-118.098106,
33.776798,-118.083702,33.8032,
-118.071701,33.815102,-118.062508,
33.8195,-118.062599,33.831501,
-118.058304,33.835201,-118.058304,
33.8461,-118.053986,33.846188,
-118.054108,33.8498,-118.049797,
33.849899,-118.049706,33.8535,
-118.045326,33.8535,-118.045502,
33.858799,-118.040855,33.858723,
-118.041107,33.8624,-118.036797,
33.862499,-118.036797,33.866001,
-118.027901,33.866001,-118.027901,
33.873199,-118.010506,33.873299,
-118.010506,33.880901,-118.001701,
33.880901,-118.001801,33.8881,
-117.993202,33.8881,-117.993103,
33.895401,-117.984398,33.895302,
-117.984398,33.902599,-117.9757,
33.902599,-117.975502,33.9459,
-117.782402,33.9464,-117.792999,
33.953999,-117.792908,33.968102,
-117.801804,33.9683,-117.802002,
33.975601,-117.784401,34.004799,
-117.766701,34.004601,-117.7668,
34.0238,-117.735504,34.018501,
-117.729599,34.0215,-117.718597,
34.0597,-117.676704,34.165119,
-117.644722,34.289944,-117.658669,
34.451488,-117.659103,34.558048,
-117.666145,34.558018,-117.666397,
34.822544,-118.446739,34.81776,
-118.893539,34.817776,-118.880966,
34.790642)),'LosAngeles','06037',
'California','CA','06',4059.2753,8863160,2183.4335);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-119.308006,37.778061,-119.582603,
37.560398,-119.583237,37.494759,
-119.614159,37.494743,-119.614502,
37.461578,-119.650185,37.461411,
-119.650208,37.417889,-119.760811,
37.417175,-120.051056,37.183163,
-120.06369,37.177868,-120.093849,
37.172577,-120.102486,37.168003,
-120.11409,37.16571,-120.131805,
37.167416,-120.141563,37.16412,
-120.151955,37.166077,-120.163567,
37.162758,-120.173126,37.165985,
-120.175491,37.162319,-120.186592,
37.160309,-120.193794,37.163208,
-120.212646,37.164375,-120.218498,
37.162212,-120.221962,37.164028,
-120.242874,37.157066,-120.248383,
37.157829,-120.275032,37.152229,
-120.288864,37.152679,-120.295387,
37.149357,-120.302856,37.14114,
-120.309883,37.141197,-120.31498,
37.137878,-120.32354,37.136436,
-120.327599,37.133942,-120.327316,
37.131145,-120.340195,37.124653,
-120.353104,37.123413,-120.36245,
37.119759,-120.383881,37.124645,
-120.387817,37.12104,-120.392563,
37.121361,-120.401833,37.116768,
-120.405731,37.110924,-120.413803,
37.110958,-120.415955,37.108261,
-120.420341,37.109718,-120.451851,
37.09893,-120.45507,37.100399,
-120.464493,37.097832,-120.468765,
37.094391,-120.475677,37.096447,
-120.541206,37.04414,-120.536674,
37.039951,-120.537361,37.034206,
-120.543983,37.02647,-120.536507,
37.023243,-120.536613,37.019356,
-120.529884,37.019695,-120.529778,
37.012741,-120.523064,37.013607,
-120.511711,37.010239,-120.507523,
37.005821,-120.507874,37,-120.501938,
37.000492,-120.503242,36.998096,
-120.499565,36.996082,-120.49839,
36.981945,-120.49334,36.976131,
-120.48307,36.972519,-120.487854,
36.966457,-120.477051,36.954838,
-120.477783,36.948311,-120.474617,
36.940304,-120.466179,36.936897,
-120.461838,36.928524,-120.456116,
36.923809,-120.461205,36.9174,
-120.449417,36.913101,-120.454315,
36.905731,-120.462685,36.905365,
-120.459869,36.902393,-120.465538,
36.889713,-120.452599,36.880814,
-120.458122,36.874695,-120.44986,
36.871578,-120.448891,36.869293,
-120.455132,36.862492,-120.447495,
36.860203,-120.446205,36.856728,
-120.437782,36.855125,-120.439041,
36.850277,-120.433937,36.851189,
-120.430923,36.847485,-120.425369,
36.840549,-120.419884,36.839745,
-120.416573,36.83604,-120.40889,
36.840134,-120.399727,36.822693,
-120.387665,36.824429,-120.378189,
36.817261,-120.375923,36.808723,
-120.368156,36.809986,-120.367218,
36.807037,-120.373016,36.800537,
-120.368668,36.795597,-120.371964,
36.78907,-120.36805,36.784855,
-120.354881,36.787399,-120.344116,
36.785099,-120.343506,36.787464,
-120.349953,36.795486,-120.346664,
36.79821,-120.343071,36.791435,
-120.333382,36.791519,-120.333618,
36.782936,-120.323219,36.786358,
-120.321266,36.784645,-120.323349,
36.779945,-120.320717,36.777748,
-120.314896,36.778336,-120.311584,
36.782078,-120.299362,36.777683,
-120.298805,36.774624,-120.304314,
36.773335,-120.305054,36.770317,
-120.292175,36.772285,-120.293037,
36.766392,-120.288818,36.763107,
-120.286949,36.764877,-120.288429,
36.770527,-120.284508,36.773556,
-120.280869,36.772331,-120.281906,
36.768078,-120.279404,36.766243,
-120.271835,36.773884,-120.268471,
36.771572,-120.260201,36.772533,
-120.255646,36.770081,-120.247932,
36.775162,-120.244072,36.77084,
-120.229424,36.769287,-120.231728,
36.781368,-120.219872,36.78487,
-120.215805,36.790615,-120.209946,
36.788857,-120.201218,36.790073,
-120.198479,36.780804,-120.187958,
36.776917,-120.180359,36.784557,
-120.18045,36.789822,-120.172592,
36.795448,-120.171715,36.802883,
-120.167625,36.80386,-120.161873,
36.799129,-120.155952,36.797665,
-120.135345,36.809601,-120.116081,
36.813904,-120.102882,36.813633,
-120.096985,36.815418,-120.089684,
36.821804,-120.078835,36.825375,
-120.075104,36.824596,-120.069183,
36.818512,-120.05584,36.823063,
-120.049187,36.821644,-120.039856,
36.815285,-120.026367,36.814777,
-120.020981,36.819118,-120.019302,
36.824791,-120.012306,36.828293,
-119.998116,36.827457,-119.991501,
36.829121,-119.989235,36.838024,
-119.983528,36.841084,-119.978638,
36.839794,-119.975899,36.835087,
-119.967773,36.832355,-119.956993,
36.836277,-119.943375,36.83408,
-119.933701,36.838001,-119.931602,
36.844398,-119.926308,36.848701,
-119.912903,36.8452,-119.904999,
36.850399,-119.888306,36.852001,
-119.883904,36.858601,-119.864906,
36.848,-119.860397,36.855301,
-119.851997,36.851799,-119.846107,
36.860199,-119.842003,36.861301,
-119.834999,36.853298,-119.822304,
36.848701,-119.8162,36.848701,
-119.811707,36.852501,-119.808701,
36.862499,-119.804199,36.864201,
-119.796463,36.873367,-119.788101,
36.875999,-119.784508,36.880001,
-119.788597,36.894299,-119.774307,
36.909302,-119.771599,36.918598,
-119.755997,36.920601,-119.749504,
36.928501,-119.750999,36.935902,
-119.733429,36.946476,-119.735634,
36.953205,-119.741707,36.9538,
-119.739502,36.970001,-119.731796,
36.978401,-119.712105,36.991699,
-119.697098,37.008801,-119.689796,
37.012039,-119.669945,37.009312,
-119.657639,37.013378,-119.658401,
37.038986,-119.648483,37.043549,
-119.638374,37.043339,-119.628059,
37.034672,-119.634979,37.025394,
-119.634399,37.021595,-119.631203,
37.021034,-119.620148,37.026657,
-119.60939,37.045719,-119.612633,
37.052029,-119.608696,37.064743,
-119.603935,37.071068,-119.595993,
37.071316,-119.58387,37.065674,
-119.567451,37.063622,-119.560638,
37.065376,-119.559608,37.070782,
-119.562386,37.074871,-119.558075,
37.088238,-119.552795,37.092422,
-119.540421,37.096268,-119.536736,
37.105125,-119.548302,37.117069,
-119.555939,37.115646,-119.567703,
37.117184,-119.562584,37.12846,
-119.562637,37.138893,-119.560097,
37.142895,-119.549919,37.145233,
-119.538956,37.1353,-119.52404,
37.128304,-119.516502,37.146824,
-119.508362,37.150551,-119.504379,
37.149986,-119.489098,37.138634,
-119.487854,37.13554,-119.492058,
37.124401,-119.490227,37.119781,
-119.481125,37.109623,-119.46962,
37.110249,-119.46508,37.120316,
-119.467682,37.127857,-119.461227,
37.144951,-119.44175,37.144104,
-119.433914,37.147007,-119.43116,
37.162624,-119.424843,37.164352,
-119.414833,37.163502,-119.404137,
37.158909,-119.398827,37.149887,
-119.385475,37.149704,-119.382843,
37.154121,-119.374054,37.15752,
-119.373344,37.164501,-119.360481,
37.168125,-119.358459,37.181625,
-119.352425,37.186184,-119.342049,
37.189411,-119.336273,37.200077,
-119.329041,37.207127,-119.329552,
37.214817,-119.336624,37.21946,
-119.332649,37.223969,-119.32988,
37.240238,-119.321152,37.246445,
-119.320915,37.253914,-119.325188,
37.27039,-119.330658,37.273933,
-119.325645,37.292767,-119.332642,
37.304207,-119.333839,37.312263,
-119.322868,37.320869,-119.317833,
37.321053,-119.315445,37.323387,
-119.315483,37.328182,-119.323586,
37.332569,-119.324814,37.335472,
-119.311264,37.339764,-119.310577,
37.342995,-119.314392,37.347427,
-119.311226,37.352783,-119.0214,
37.5858,-119.026001,37.595798,
-119.033401,37.6036,-119.029816,
37.622295,-119.031601,37.6306,
-119.04435,37.637112,-119.05365,
37.645199,-119.05336,37.651249,
-119.059364,37.656048,-119.059708,
37.659172,-119.058578,37.665443,
-119.064194,37.684624,-119.072372,
37.692951,-119.081589,37.696613,
-119.087082,37.70274,-119.092155,
37.703697,-119.108719,37.724804,
-119.123337,37.734013,-119.137054,
37.736195,-119.139801,37.733318,
-119.146912,37.732826,-119.166473,
37.7383,-119.176125,37.734844,
-119.182762,37.739571,-119.185333,
37.736614,-119.191544,37.738022,
-119.198753,37.735905,-119.215363,
37.714191,-119.229019,37.717476,
-119.229652,37.721024,-119.242065,
37.728615,-119.25,37.730228,
-119.256905,37.724701,-119.260201,
37.7328,-119.263107,37.733002,
-119.267998,37.7393,-119.287399,
37.745098,-119.289703,37.749401,
-119.288101,37.7551,-119.293106,
37.7598,-119.292397,37.768002,
-119.307304,37.775799,-119.308006,
37.778061)),'Madera','06039',
'California','CA','06',2138.0507,88090,41.201);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-123.001617,38.295795,-122.985153,
38.273102,-122.973907,38.26318,
-122.966629,38.25061,-122.971268,
38.236725,-122.994408,38.240032,
-122.964645,38.195717,-122.966629,
38.183147,-122.959351,38.1805,
-122.951416,38.169254,-122.948112,
38.149418,-122.961334,38.107082,
-123.008301,38.00655,-123.019547,
38.000591,-123.023514,37.99398,
-122.973251,37.991333,-122.980522,
38.009853,-122.959351,38.027714,
-122.940834,38.031021,-122.925621,
38.027714,-122.890572,38.027054,
-122.8694,38.021759,-122.851547,
38.014484,-122.818474,37.995964,
-122.795319,37.974796,-122.781433,
37.947681,-122.764893,37.937096,
-122.736458,37.925194,-122.729179,
37.913948,-122.72654,37.903362,
-122.701401,37.89212,-122.692139,
37.900715,-122.680229,37.90535,
-122.665016,37.90601,-122.649811,
37.902039,-122.629303,37.887489,
-122.625992,37.880211,-122.616074,
37.875584,-122.600861,37.87426,
-122.586967,37.861691,-122.557205,
37.844498,-122.526398,37.815201,
-122.522507,37.824902,-122.512367,
37.824554,-122.510803,37.824501,
-122.509605,37.824036,-122.498703,
37.819801,-122.494766,37.822613,
-122.491898,37.824661,-122.490295,
37.825802,-122.476997,37.825802,
-122.477501,37.830502,-122.476997,
37.830654,-122.471199,37.832401,
-122.470352,37.836517,-122.478325,
37.847488,-122.477333,37.856464,
-122.456718,37.864109,-122.450737,
37.871426,-122.437111,37.879398,
-122.43644,37.882061,-122.447746,
37.894028,-122.460373,37.897018,
-122.467361,37.901344,-122.479324,
37.916637,-122.499275,37.926277,
-122.50293,37.935253,-122.496613,
37.938576,-122.486641,37.936581,
-122.477997,37.941898,-122.484978,
37.948883,-122.488968,37.96484,
-122.474342,37.97448,-122.456055,
37.979469,-122.446083,37.984787,
-122.455727,37.997089,-122.46537,
38.003735,-122.494286,38.015373,
-122.496941,38.021687,-122.498611,
38.029999,-122.495949,38.039639,
-122.48764,38.064903,-122.482323,
38.071556,-122.488304,38.104469,
-122.487808,38.108936,-122.499466,
38.111862,-122.506844,38.118179,
-122.512054,38.132317,-122.519012,
38.140781,-122.533737,38.149284,
-122.543381,38.158798,-122.548523,
38.157372,-122.556824,38.16024,
-122.556908,38.163612,-122.550888,
38.169083,-122.562103,38.169399,
-122.56337,38.175163,-122.567398,
38.177101,-122.564056,38.182678,
-122.569504,38.187199,-122.572105,
38.186401,-122.569603,38.183601,
-122.572144,38.18338,-122.573135,
38.186028,-122.577995,38.187172,
-122.579178,38.185658,-122.581024,
38.188103,-122.589401,38.186001,
-122.591721,38.188869,-122.599907,
38.185501,-122.603256,38.180702,
-122.624634,38.182503,-122.627121,
38.178864,-122.634598,38.17881,
-122.648224,38.181335,-122.65715,
38.186726,-122.662292,38.186371,
-122.666382,38.189896,-122.678543,
38.189735,-122.686996,38.195,
-122.700104,38.19622,-122.703598,
38.198738,-122.708237,38.19743,
-122.720772,38.20694,-122.7388,
38.2071,-122.898514,38.316814,
-122.908241,38.314323,-122.909431,
38.317459,-122.905571,38.319839,
-122.908501,38.320824,-122.914398,
38.320412,-122.919632,38.316887,
-122.915184,38.312744,-122.920303,
38.308693,-122.92437,38.312817,
-122.934013,38.309631,-122.93573,
38.31089,-122.93306,38.314072,
-122.938255,38.310959,-122.942818,
38.312565,-122.945053,38.311169,
-122.965034,38.317101,-122.968933,
38.310211,-122.980499,38.311218,
-122.983635,38.308033,-122.993637,
38.306271,-122.992996,38.299469,
-123.001617,38.295795)),'Marin',
'06041','California','CA','06',519.6865,230096,442.7587);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.386581,37.633774,-120.38665,
37.63343,-120.317871,37.521702,
-120.312706,37.50095,-120.29808,
37.488979,-120.299202,37.484356,
-120.278557,37.458012,-120.274078,
37.440784,-120.283142,37.432449,
-120.282387,37.424423,-120.274796,
37.418892,-120.253677,37.385468,
-120.246002,37.380276,-120.215485,
37.337395,-120.20253,37.313389,
-120.186699,37.301136,-120.181709,
37.291473,-120.185631,37.280334,
-120.17749,37.262482,-120.142815,
37.239258,-120.104599,37.225082,
-120.089073,37.221527,-120.066559,
37.200542,-120.061218,37.19804,
-120.051056,37.183163,-119.760811,
37.417175,-119.650208,37.417889,
-119.650185,37.461411,-119.614502,
37.461578,-119.614159,37.494743,
-119.583237,37.494759,-119.582603,
37.560398,-119.308006,37.778061,
-119.309998,37.7798,-119.306305,
37.782902,-119.309502,37.785702,
-119.310204,37.793598,-119.320801,
37.794102,-119.325996,37.7995,
-119.330902,37.799301,-119.338402,
37.805599,-119.344902,37.805698,
-119.348,37.810902,-119.353996,
37.811901,-119.350403,37.8256,
-119.371613,37.832958,-119.374519,
37.840946,-119.378769,37.840992,
-119.382736,37.836548,-119.391602,
37.838001,-119.401703,37.8353,
-119.406303,37.855,-119.414505,
37.854698,-119.420998,37.8578,
-119.425797,37.866798,-119.433197,
37.8652,-119.441704,37.859901,
-119.441002,37.867599,-119.4505,
37.871101,-119.4618,37.8685,
-119.469307,37.863098,-119.473305,
37.855701,-119.483101,37.864498,
-119.491302,37.863201,-119.5028,
37.868698,-119.514305,37.884499,
-119.522797,37.886799,-119.528801,
37.891201,-119.534706,37.904202,
-119.555702,37.901001,-119.557602,
37.903198,-119.561996,37.902599,
-119.573105,37.895699,-119.580597,
37.893799,-119.585907,37.887901,
-119.586304,37.878799,-119.583862,
37.875,-119.59687,37.86105,
-119.608604,37.853447,-119.618103,
37.853271,-119.623985,37.847794,
-119.6371,37.849201,-119.647598,
37.8451,-119.656708,37.834202,
-119.649902,37.8209,-119.652901,
37.810501,-119.658905,37.809502,
-119.666199,37.8013,-119.688705,
37.800301,-119.698601,37.7892,
-119.708801,37.793598,-119.721703,
37.787701,-119.732903,37.787998,
-119.745003,37.783001,-119.75,
37.773399,-119.761398,37.770401,
-119.767998,37.771198,-119.771004,
37.7668,-119.780106,37.7635,
-119.785103,37.7659,-119.790504,
37.764702,-119.80423,37.760197,
-119.804001,37.7565,-119.806801,
37.7551,-119.823799,37.762001,
-119.826904,37.768299,-119.836906,
37.770302,-119.841202,37.769199,
-119.840103,37.764301,-119.851372,
37.758278,-119.859596,37.7645,
-119.863503,37.772301,-119.867203,
37.7733,-119.874504,37.772598,
-119.871704,37.767601,-119.875,
37.763901,-119.883904,37.760799,
-119.893303,37.762199,-119.899101,
37.760399,-119.9002,37.7579,
-119.905998,37.757999,-119.9142,
37.762699,-119.922707,37.764099,
-119.940704,37.764,-119.963905,
37.782902,-119.970802,37.7841,
-119.997398,37.796299,-120.024406,
37.811577,-120.030861,37.811131,
-120.035286,37.807926,-120.043617,
37.813023,-120.047874,37.811272,
-120.054115,37.812866,-120.054665,
37.818214,-120.05661,37.824211,
-120.060547,37.826118,-120.064133,
37.822971,-120.078491,37.828884,
-120.084183,37.826633,-120.084412,
37.823589,-120.089447,37.822163,
-120.089264,37.810822,-120.097725,
37.807804,-120.099716,37.800739,
-120.114769,37.793236,-120.11898,
37.789646,-120.11837,37.785934,
-120.12323,37.785599,-120.126221,
37.781643,-120.141121,37.783104,
-120.153,37.788334,-120.160789,
37.787479,-120.172623,37.795723,
-120.173111,37.799683,-120.177353,
37.794731,-120.181648,37.795403,
-120.179436,37.788792,-120.181793,
37.783714,-120.18766,37.780296,
-120.182381,37.775154,-120.187958,
37.768009,-120.196693,37.769623,
-120.200089,37.763222,-120.214798,
37.765354,-120.215706,37.763161,
-120.223099,37.763706,-120.225731,
37.760406,-120.229637,37.763863,
-120.237206,37.765335,-120.239891,
37.758568,-120.238464,37.753792,
-120.244286,37.750622,-120.252312,
37.750809,-120.256157,37.747875,
-120.260719,37.74081,-120.256874,
37.735229,-120.259697,37.733631,
-120.275055,37.73904,-120.281395,
37.745453,-120.285736,37.739967,
-120.282784,37.733707,-120.285469,
37.729519,-120.306664,37.73568,
-120.314438,37.733833,-120.32019,
37.726112,-120.325089,37.726135,
-120.331314,37.729664,-120.334541,
37.726551,-120.344185,37.725735,
-120.337074,37.709179,-120.332275,
37.706833,-120.328789,37.697338,
-120.321579,37.687405,-120.318436,
37.686497,-120.30529,37.665489,
-120.311287,37.663017,-120.308723,
37.656757,-120.311554,37.653736,
-120.324921,37.649033,-120.344048,
37.666985,-120.352455,37.675079,
-120.361443,37.67289,-120.365288,
37.680862,-120.378677,37.681057,
-120.385605,37.684914,-120.390907,
37.683628,-120.391487,37.675423,
-120.394424,37.672199,-120.391693,
37.669983,-120.393105,37.668186,
-120.374123,37.652275,-120.386581,
37.633774)),'Mariposa','06043',
'California','CA','06',1450.9648,14302,9.8568);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-124.02359,40.002712,-124.022087,
40.001411,-123.97422,39.954361,
-123.952393,39.921028,-123.928253,
39.908386,-123.903542,39.859543,
-123.884583,39.846325,-123.85183,
39.833107,-123.846657,39.82449,
-123.836891,39.77507,-123.837463,
39.750935,-123.82885,39.721058,
-123.809303,39.711285,-123.793793,
39.690601,-123.781151,39.610725,
-123.786896,39.605553,-123.785744,
39.596355,-123.765633,39.556709,
-123.775398,39.522804,-123.803009,
39.478424,-123.814339,39.448475,
-123.820816,39.407196,-123.820816,
39.375629,-123.824051,39.349728,
-123.796532,39.270409,-123.778717,
39.233177,-123.769005,39.194324,
-123.735016,39.156284,-123.718018,
39.125523,-123.690498,39.045395,
-123.690498,39.019497,-123.701836,
38.991165,-123.717209,38.966885,
-123.730965,38.953934,-123.741486,
38.954742,-123.730164,38.937744,
-123.724495,38.916698,-123.708305,
38.909416,-123.663795,38.874611,
-123.644363,38.842236,-123.603081,
38.820381,-123.579605,38.800957,
-123.532417,38.768517,-123.532104,
38.768547,-123.519081,38.758678,
-123.515221,38.767876,-123.508759,
38.767559,-123.506126,38.773796,
-123.498817,38.773933,-123.495918,
38.778694,-123.367111,38.777161,
-123.367279,38.806736,-123.135139,
38.809231,-123.135521,38.839542,
-123.080116,38.838501,-123.079887,
38.852535,-122.820488,38.850235,
-122.82029,38.858021,-122.838989,
38.858093,-122.83889,38.866123,
-122.857384,38.865948,-122.856659,
38.87336,-122.875397,38.873226,
-122.874596,38.880924,-122.893532,
38.880932,-122.892784,38.895622,
-122.910248,38.895271,-122.910255,
38.9016,-122.947762,38.900318,
-122.94796,38.925545,-122.960785,
38.925613,-122.959084,38.932571,
-122.968811,38.932762,-122.967178,
38.946609,-122.976608,38.946789,
-122.976318,38.983006,-122.985573,
38.983112,-122.985527,38.997387,
-123.008141,38.997269,-123.008148,
38.993279,-123.017471,38.993061,
-123.017509,38.996716,-123.026932,
38.996696,-123.026901,39.006599,
-123.036201,39.006599,-123.0364,
39.013802,-123.045708,39.013901,
-123.045906,39.021,-123.055107,
39.021198,-123.055,39.049999,
-123.064102,39.050098,-123.064003,
39.064499,-123.082703,39.064602,
-123.082603,39.071899,-123.091904,
39.072102,-123.093094,39.080631,
-123.093102,39.095402,-123.0839,
39.095402,-123.086403,39.1385,
-123.077003,39.138832,-123.076706,
39.173901,-123.044701,39.173599,
-123.044304,39.180698,-123.039803,
39.180801,-123.039001,39.1926,
-123.033707,39.192501,-123.032997,
39.199799,-123.028603,39.199699,
-123.027702,39.206902,-123.023201,
39.207199,-123.019707,39.220798,
-123.011398,39.2211,-123.011597,
39.236301,-122.993729,39.236034,
-122.993378,39.25687,-123.002502,
39.2575,-123.003403,39.278301,
-123.018501,39.278099,-123.0186,
39.321899,-123.027603,39.321899,
-123.027603,39.3367,-123.036598,
39.3363,-123.036797,39.363998,
-123.047501,39.364201,-123.046402,
39.3787,-123.056,39.378799,
-123.055199,39.4077,-123.073997,
39.407799,-123.073799,39.436699,
-123.069,39.4366,-123.071999,
39.452801,-123.061905,39.452599,
-123.062065,39.503658,-123.043282,
39.503704,-123.043335,39.511318,
-123.023842,39.511299,-123.024117,
39.518829,-122.935585,39.516518,
-122.935585,39.53083,-122.889198,
39.529137,-122.884239,39.580227,
-122.883385,39.610886,-122.889305,
39.623035,-122.891571,39.709019,
-122.911766,39.708847,-122.9114,
39.748287,-122.937294,39.748238,
-122.936539,39.798279,-122.942635,
39.802277,-122.945595,39.833595,
-122.955315,39.839336,-122.95903,
39.845287,-122.952881,39.854809,
-122.954697,39.859386,-122.950516,
39.867535,-122.952354,39.873074,
-122.948524,39.880024,-122.946976,
39.900623,-122.950371,39.906441,
-122.92009,39.916096,-122.919502,
39.929054,-122.911484,39.931606,
-122.908669,39.936512,-122.915459,
39.937454,-122.925705,39.945194,
-122.924362,39.96899,-122.932899,
39.978256,-123.543434,39.977142,
-123.543327,40.002052,-124.02359,
40.002712)),'Mendocino','06045',
'California','CA','06',3508.6796,80345,22.8989);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.38665,37.63343,-120.829819,
37.460247,-120.885391,37.440243,
-120.983353,37.399433,-120.992599,
37.3881,-120.9907,37.385067,
-120.989601,37.3876,-120.981201,
37.3857,-120.982201,37.376499,
-120.972504,37.377602,-120.976601,
37.371101,-120.972504,37.3694,
-120.9804,37.365799,-120.976501,
37.361801,-120.975143,37.350319,
-120.963181,37.345844,-121.221672,
37.138275,-121.225693,37.134895,
-121.22419,37.133526,-121.222099,
37.131687,-121.221672,37.130562,
-121.220711,37.125965,-121.216301,
37.1231,-121.22583,37.110844,
-121.224503,37.106899,-121.229874,
37.104591,-121.229401,37.097,
-121.241577,37.093121,-121.244446,
37.089203,-121.240936,37.085182,
-121.234459,37.086292,-121.223602,
37.078999,-121.221367,37.073486,
-121.208603,37.068298,-121.207161,
37.061344,-121.211555,37.055122,
-121.217697,37.057198,-121.22348,
37.056293,-121.223473,37.039799,
-121.235107,37.036999,-121.239601,
37.031834,-121.247604,37.033737,
-121.244949,37.025631,-121.232307,
37.011799,-121.237152,37.009308,
-121.232101,36.999401,-121.240479,
36.997437,-121.245529,36.985279,
-121.231087,36.968945,-121.223061,
36.967484,-121.214371,36.9613,
-121.210762,36.957165,-121.217468,
36.947941,-121.228165,36.941086,
-121.233299,36.926197,-121.229111,
36.921291,-121.223152,36.919971,
-121.22068,36.910412,-121.216026,
36.913555,-121.206154,36.911572,
-121.197243,36.914387,-121.187759,
36.913288,-121.183266,36.909023,
-121.183266,36.896435,-121.173058,
36.885761,-121.16806,36.885044,
-121.162552,36.869297,-121.151588,
36.865402,-121.150841,36.858913,
-121.141998,36.846352,-121.140488,
36.836708,-120.932663,36.751945,
-120.917709,36.740433,-120.541206,
37.04414,-120.475677,37.096447,
-120.468765,37.094391,-120.464493,
37.097832,-120.45507,37.100399,
-120.451851,37.09893,-120.420341,
37.109718,-120.415955,37.108261,
-120.413803,37.110958,-120.405731,
37.110924,-120.401833,37.116768,
-120.392563,37.121361,-120.387817,
37.12104,-120.383881,37.124645,
-120.36245,37.119759,-120.353104,
37.123413,-120.340195,37.124653,
-120.327316,37.131145,-120.327599,
37.133942,-120.32354,37.136436,
-120.31498,37.137878,-120.309883,
37.141197,-120.302856,37.14114,
-120.295387,37.149357,-120.288864,
37.152679,-120.275032,37.152229,
-120.248383,37.157829,-120.242874,
37.157066,-120.221962,37.164028,
-120.218498,37.162212,-120.212646,
37.164375,-120.193794,37.163208,
-120.186592,37.160309,-120.175491,
37.162319,-120.173126,37.165985,
-120.163567,37.162758,-120.151955,
37.166077,-120.141563,37.16412,
-120.131805,37.167416,-120.11409,
37.16571,-120.102486,37.168003,
-120.093849,37.172577,-120.06369,
37.177868,-120.051056,37.183163,
-120.061218,37.19804,-120.066559,
37.200542,-120.089073,37.221527,
-120.104599,37.225082,-120.142815,
37.239258,-120.17749,37.262482,
-120.185631,37.280334,-120.181709,
37.291473,-120.186699,37.301136,
-120.20253,37.313389,-120.215485,
37.337395,-120.246002,37.380276,
-120.253677,37.385468,-120.274796,
37.418892,-120.282387,37.424423,
-120.283142,37.432449,-120.274078,
37.440784,-120.278557,37.458012,
-120.299202,37.484356,-120.29808,
37.488979,-120.312706,37.50095,
-120.317871,37.521702,-120.38665,
37.63343)),'Merced','06047',
'California','CA','06',1928.5595,178403,92.5057);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.446503,41.997303,-121.446419,
41.950237,-121.455772,41.949982,
-121.455826,41.776424,-121.447884,
41.776512,-121.445396,41.183601,
-121.330704,41.183998,-120.665581,
41.183949,-119.998817,41.184078,
-119.998116,41.994652,-120.293373,
41.993053,-120.878403,41.9939,
-121.03421,41.993443,-121.25,
41.997692,-121.446503,41.997303)),
'Modoc','06049','California','CA','06',3943.6855,9678,2.454);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-119.584435,38.713306,-119.578491,
38.705757,-119.590843,38.690228,
-119.590446,38.682201,-119.59832,
38.670326,-119.606422,38.666447,
-119.613655,38.665974,-119.612129,
38.655865,-119.61692,38.631744,
-119.615639,38.626003,-119.618446,
38.624371,-119.617462,38.619411,
-119.620071,38.614517,-119.618065,
38.603619,-119.611526,38.600574,
-119.607864,38.59481,-119.598808,
38.593441,-119.594543,38.590424,
-119.595016,38.581944,-119.588303,
38.573654,-119.589523,38.568768,
-119.585716,38.566154,-119.586365,
38.558445,-119.583298,38.552109,
-119.573105,38.540916,-119.569992,
38.541821,-119.567055,38.5378,
-119.565872,38.52536,-119.559944,
38.525627,-119.555214,38.516712,
-119.558205,38.505581,-119.556511,
38.502228,-119.541862,38.499783,
-119.544373,38.490124,-119.541328,
38.481312,-119.545074,38.474182,
-119.555229,38.469826,-119.557983,
38.460529,-119.555428,38.447556,
-119.561646,38.438679,-119.569008,
38.434948,-119.564789,38.422665,
-119.560364,38.419922,-119.562027,
38.409088,-119.568611,38.404091,
-119.579781,38.400578,-119.582687,
38.397034,-119.591408,38.398964,
-119.600204,38.405445,-119.621086,
38.393963,-119.617432,38.38192,
-119.61377,38.380043,-119.605614,
38.367271,-119.61602,38.364712,
-119.634567,38.353996,-119.626907,
38.348141,-119.631065,38.344292,
-119.630852,38.334827,-119.636215,
38.327995,-119.638199,38.326969,
-119.644173,38.320663,-119.64135,
38.315697,-119.643341,38.299686,
-119.641472,38.293926,-119.650505,
38.286549,-119.641823,38.278538,
-119.636757,38.278473,-119.629189,
38.268787,-119.612198,38.261505,
-119.611938,38.259193,-119.620697,
38.252029,-119.613014,38.242889,
-119.603897,38.239285,-119.603188,
38.235046,-119.623413,38.22876,
-119.622505,38.220482,-119.625664,
38.219444,-119.626099,38.213284,
-119.624016,38.206966,-119.629921,
38.204025,-119.63166,38.198944,
-119.618477,38.191147,-119.604637,
38.188496,-119.59742,38.181782,
-119.591263,38.185135,-119.584625,
38.18446,-119.577591,38.176937,
-119.580345,38.172588,-119.575493,
38.157745,-119.565651,38.157288,
-119.562843,38.154079,-119.545944,
38.154503,-119.545815,38.143353,
-119.530159,38.144569,-119.514526,
38.137436,-119.505486,38.137196,
-119.506783,38.152721,-119.50193,
38.159111,-119.495491,38.156734,
-119.495972,38.14938,-119.488129,
38.14352,-119.487518,38.132256,
-119.468452,38.128365,-119.47184,
38.117046,-119.46109,38.109188,
-119.456451,38.110634,-119.463501,
38.103672,-119.462692,38.098415,
-119.458809,38.096359,-119.453384,
38.096149,-119.448349,38.099644,
-119.444878,38.09314,-119.439468,
38.09576,-119.440559,38.102764,
-119.42955,38.116352,-119.422958,
38.107521,-119.411629,38.107941,
-119.401512,38.105633,-119.396034,
38.106899,-119.388885,38.099213,
-119.381859,38.097782,-119.379234,
38.092628,-119.373558,38.093605,
-119.370064,38.088676,-119.364075,
38.090279,-119.356133,38.083057,
-119.348854,38.085644,-119.344925,
38.083191,-119.334846,38.066364,
-119.326935,38.065784,-119.323227,
38.061016,-119.321655,38.049946,
-119.310204,38.044834,-119.312958,
38.034611,-119.307869,38.033245,
-119.303596,38.023968,-119.307159,
38.019573,-119.308014,38.006596,
-119.317398,37.9865,-119.313705,
37.981201,-119.321602,37.9711,
-119.314301,37.965401,-119.312904,
37.954399,-119.307404,37.946899,
-119.294907,37.942799,-119.286903,
37.933102,-119.279602,37.933899,
-119.263,37.926601,-119.264702,
37.915199,-119.262901,37.9123,
-119.233505,37.9104,-119.2257,
37.9067,-119.218903,37.898701,
-119.209801,37.899502,-119.209702,
37.894001,-119.2061,37.8895,
-119.200401,37.8881,-119.199104,
37.884602,-119.205399,37.883598,
-119.212303,37.873402,-119.211601,
37.856998,-119.215904,37.849701,
-119.209503,37.845699,-119.200798,
37.847599,-119.195198,37.844101,
-119.205902,37.84,-119.203003,
37.829899,-119.212303,37.8251,
-119.215904,37.818802,-119.204002,
37.8116,-119.200302,37.804401,
-119.202301,37.794998,-119.214302,
37.790001,-119.220306,37.779202,
-119.228203,37.777699,-119.229797,
37.774502,-119.235603,37.773701,
-119.242104,37.769199,-119.249199,
37.757511,-119.253998,37.756401,
-119.254906,37.745098,-119.260201,
37.7411,-119.267998,37.7393,
-119.263107,37.733002,-119.260201,
37.7328,-119.256905,37.724701,
-119.25,37.730228,-119.242065,
37.728615,-119.229652,37.721024,
-119.229019,37.717476,-119.215363,
37.714191,-119.198753,37.735905,
-119.191544,37.738022,-119.185333,
37.736614,-119.182762,37.739571,
-119.176125,37.734844,-119.166473,
37.7383,-119.146912,37.732826,
-119.139801,37.733318,-119.137054,
37.736195,-119.123337,37.734013,
-119.108719,37.724804,-119.092155,
37.703697,-119.087082,37.70274,
-119.081589,37.696613,-119.072372,
37.692951,-119.064194,37.684624,
-119.058578,37.665443,-119.059708,
37.659172,-119.059364,37.656048,
-119.05336,37.651249,-119.05365,
37.645199,-119.04435,37.637112,
-119.031601,37.6306,-119.029816,
37.622295,-119.033401,37.6036,
-119.026001,37.595798,-119.0214,
37.5858,-119.007301,37.577599,
-119.001305,37.571201,-118.989601,
37.5672,-118.983902,37.567402,
-118.975998,37.5569,-118.971504,
37.559502,-118.963104,37.558201,
-118.958801,37.563202,-118.955399,
37.562801,-118.951706,37.565899,
-118.941704,37.562199,-118.938004,
37.554501,-118.928703,37.549,
-118.916107,37.5504,-118.9002,
37.5313,-118.900902,37.5261,
-118.890106,37.525398,-118.882706,
37.520199,-118.880707,37.510399,
-118.866501,37.507198,-118.859802,
37.501598,-118.855095,37.478458,
-118.848801,37.475925,-118.840942,
37.480961,-118.835068,37.482586,
-118.831841,37.480259,-118.814568,
37.487873,-118.809326,37.486111,
-118.803322,37.489002,-118.796135,
37.488781,-118.785088,37.478748,
-118.784096,37.473953,-118.776939,
37.469433,-118.774055,37.46312,
-118.203384,37.462711,-117.831802,
37.465,-118.427193,37.89629,
-119.155991,38.414833,-119.327408,
38.534882,-119.434067,38.609127,
-119.449615,38.620056,-119.584435,
38.713306)),'Mono','06051',
'California','CA','06',3043.9628,9956,3.2707);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.808922,36.850853,-121.788094,
36.805969,-121.804031,36.751228,
-121.804726,36.726284,-121.810272,
36.699261,-121.817894,36.670849,
-121.829674,36.645905,-121.847687,
36.623035,-121.865013,36.607101,
-121.881638,36.600861,-121.889961,
36.603638,-121.903816,36.62096,
-121.928062,36.636894,-121.934303,
36.636894,-121.944695,36.615417,
-121.956482,36.609871,-121.973106,
36.582848,-121.970337,36.568989,
-121.952316,36.560677,-121.945389,
36.565525,-121.937073,36.562752,
-121.93222,36.558598,-121.928757,
36.550282,-121.925293,36.528107,
-121.928757,36.523254,-121.953018,
36.522564,-121.953018,36.516327,
-121.943314,36.505932,-121.945389,
36.489304,-121.929459,36.452579,
-121.918365,36.433872,-121.905197,
36.354183,-121.892731,36.341019,
-121.894806,36.312607,-121.901733,
36.306374,-121.89827,36.301525,
-121.887184,36.301525,-121.880951,
36.293209,-121.848381,36.273804,
-121.827591,36.246086,-121.812355,
36.234306,-121.790871,36.232231,
-121.713943,36.192139,-121.65464,
36.140511,-121.628067,36.111374,
-121.620903,36.09808,-121.617325,
36.084278,-121.604546,36.070477,
-121.591766,36.063831,-121.590233,
36.047985,-121.581032,36.040318,
-121.571831,36.023449,-121.566208,
36.018845,-121.546272,36.018337,
-121.509979,36.006069,-121.501801,
35.99942,-121.484413,35.968746,
-121.471634,35.913029,-121.466019,
35.909451,-121.464478,35.886955,
-121.445053,35.870087,-121.414894,
35.856285,-121.382179,35.819481,
-121.35508,35.802612,-121.348228,
35.796112,-120.863281,35.791767,
-120.212997,35.78931,-120.215576,
35.80368,-120.218452,35.806065,
-120.216911,35.811642,-120.218925,
35.818951,-120.237938,35.825787,
-120.243561,35.824024,-120.248856,
35.829971,-120.254112,35.842621,
-120.258331,35.845093,-120.256523,
35.851913,-120.254021,35.853027,
-120.25528,35.855465,-120.249313,
35.857891,-120.24501,35.864178,
-120.239273,35.865967,-120.24424,
35.873161,-120.242294,35.877708,
-120.275963,35.906506,-120.314087,
35.907223,-120.321938,35.907856,
-120.325005,35.913162,-120.331314,
35.915565,-120.3311,35.918831,
-120.335732,35.923683,-120.334908,
35.937134,-120.344849,35.944893,
-120.348663,35.944103,-120.35553,
35.948097,-120.356552,35.955589,
-120.361511,35.95945,-120.359421,
35.964458,-120.387886,35.969299,
-120.393021,35.967911,-120.407562,
35.976006,-120.421799,35.973789,
-120.43206,35.968971,-120.435104,
35.970779,-120.438683,35.979614,
-120.448105,35.985153,-120.448715,
35.988472,-120.471855,35.997433,
-120.479462,36.005966,-120.477715,
36.010223,-120.485222,36.011219,
-120.487335,36.014919,-120.496155,
36.01947,-120.5,36.022377,
-120.501961,36.020336,-120.507355,
36.021622,-120.506897,36.024197,
-120.509941,36.022114,-120.516579,
36.027584,-120.518761,36.026718,
-120.519012,36.020924,-120.528809,
36.024319,-120.526001,36.035748,
-120.528404,36.034336,-120.539413,
36.036705,-120.544418,36.046165,
-120.565659,36.052971,-120.586868,
36.066669,-120.595093,36.078259,
-120.592178,36.088573,-120.588799,
36.089645,-120.598366,36.100922,
-120.607025,36.102737,-120.607681,
36.099361,-120.611366,36.099091,
-120.610657,36.095676,-120.613258,
36.095112,-120.625679,36.097183,
-120.632599,36.103363,-120.634361,
36.101051,-120.6409,36.101311,
-120.647781,36.108028,-120.644424,
36.116241,-120.652199,36.118855,
-120.65152,36.125221,-120.654732,
36.131821,-120.66655,36.138096,
-120.663254,36.141399,-120.663704,
36.147312,-120.666985,36.16061,
-120.671036,36.16431,-120.663246,
36.165691,-120.662056,36.171196,
-120.648933,36.168049,-120.650986,
36.174129,-120.647858,36.179462,
-120.64373,36.179192,-120.638214,
36.196507,-120.625916,36.203266,
-120.639992,36.219849,-120.648262,
36.223991,-120.650688,36.230701,
-120.665909,36.236034,-120.669899,
36.241898,-120.678734,36.246704,
-120.680771,36.251419,-120.677116,
36.255386,-120.671951,36.257721,
-120.678864,36.26532,-120.677574,
36.267361,-120.681412,36.271999,
-120.687492,36.272224,-120.700951,
36.286201,-120.706726,36.285763,
-120.715179,36.292191,-120.721573,
36.292698,-120.724258,36.297039,
-120.745651,36.310284,-120.75193,
36.307838,-120.757324,36.308643,
-120.741928,36.298065,-120.732819,
36.284245,-120.730942,36.27541,
-120.723701,36.270351,-120.716667,
36.260056,-120.705376,36.227734,
-120.704445,36.206856,-120.71077,
36.198273,-120.717522,36.196716,
-120.731186,36.203739,-120.742653,
36.198929,-120.752075,36.199471,
-120.75489,36.203274,-120.757263,
36.201832,-120.760681,36.203457,
-120.762939,36.208954,-120.766243,
36.21019,-120.764542,36.213463,
-120.767761,36.213921,-120.771965,
36.220242,-120.780632,36.222809,
-120.782349,36.229057,-120.788284,
36.230705,-120.788368,36.23494,
-120.798141,36.235516,-120.80117,
36.237621,-120.799614,36.240093,
-120.805153,36.240368,-120.806282,
36.243664,-120.811142,36.245083,
-120.809792,36.251793,-120.812675,
36.250404,-120.813606,36.253162,
-120.819534,36.253922,-120.822334,
36.257149,-120.823608,36.25518,
-120.824883,36.257763,-120.828644,
36.257511,-120.828125,36.259438,
-120.832085,36.259117,-120.832657,
36.262547,-120.835846,36.262272,
-120.838394,36.270882,-120.835739,
36.27198,-120.843796,36.280628,
-120.849281,36.282207,-120.850441,
36.285709,-120.855362,36.284584,
-120.858696,36.290237,-120.87281,
36.294926,-120.882927,36.294006,
-120.888527,36.290417,-120.898109,
36.300861,-120.918953,36.31105,
-120.924522,36.308102,-120.925003,
36.301483,-120.932076,36.299789,
-120.93544,36.294182,-120.933205,
36.289925,-120.939957,36.28688,
-120.93914,36.282211,-120.951462,
36.275112,-120.955223,36.275616,
-120.958138,36.280861,-120.963402,
36.280514,-120.972649,36.290241,
-120.984207,36.293259,-120.987007,
36.285084,-120.986038,36.275909,
-120.991264,36.27018,-120.998924,
36.270912,-121.003456,36.26704,
-121.009331,36.268829,-121.010666,
36.264389,-121.013565,36.268578,
-121.017738,36.259628,-121.021431,
36.261372,-121.026039,36.259701,
-121.026031,36.275085,-121.034859,
36.27552,-121.034576,36.273048,
-121.039284,36.270859,-121.03978,
36.324005,-121.119087,36.387733,
-121.194099,36.447262,-121.19664,
36.455101,-121.208794,36.46484,
-121.21405,36.473244,-121.221321,
36.473877,-121.224434,36.472027,
-121.228477,36.475311,-121.227074,
36.484634,-121.231544,36.489079,
-121.229782,36.491756,-121.235832,
36.497662,-121.238258,36.504814,
-121.245857,36.50676,-121.253845,
36.503548,-121.25856,36.504501,
-121.267921,36.502003,-121.280952,
36.502739,-121.283928,36.505733,
-121.293015,36.506271,-121.296104,
36.503971,-121.299698,36.505836,
-121.307808,36.499458,-121.310928,
36.504623,-121.305717,36.512211,
-121.306152,36.51685,-121.302193,
36.518177,-121.294319,36.527164,
-121.299881,36.537312,-121.312439,
36.549957,-121.328102,36.555481,
-121.327637,36.561165,-121.330978,
36.562195,-121.330086,36.570042,
-121.332878,36.574444,-121.322479,
36.577591,-121.326309,36.585922,
-121.323181,36.588474,-121.322739,
36.602406,-121.317673,36.604893,
-121.317329,36.610069,-121.331535,
36.620644,-121.341049,36.631393,
-121.340584,36.638378,-121.348427,
36.643341,-121.349052,36.648396,
-121.351929,36.647915,-121.365211,
36.656647,-121.377289,36.652901,
-121.392815,36.654903,-121.395584,
36.656929,-121.40596,36.656075,
-121.41449,36.6731,-121.422806,
36.674377,-121.430519,36.678768,
-121.443283,36.673187,-121.457909,
36.68576,-121.467979,36.685474,
-121.471779,36.696926,-121.476433,
36.70306,-121.480659,36.704636,
-121.483078,36.714352,-121.460236,
36.717709,-121.452026,36.721241,
-121.450287,36.724831,-121.451599,
36.729248,-121.458168,36.734318,
-121.456337,36.736801,-121.459122,
36.737305,-121.461319,36.743893,
-121.470665,36.745579,-121.474602,
36.749252,-121.473648,36.757496,
-121.48159,36.765453,-121.501373,
36.760239,-121.50296,36.757248,
-121.596649,36.837395,-121.621033,
36.846249,-121.641403,36.8736,
-121.639587,36.879143,-121.642799,
36.8941,-121.644791,36.902611,
-121.648285,36.900459,-121.651489,
36.902016,-121.650635,36.909973,
-121.655334,36.914158,-121.665176,
36.912796,-121.679398,36.903198,
-121.685242,36.907902,-121.696381,
36.911655,-121.701263,36.908222,
-121.704475,36.90955,-121.705734,
36.911243,-121.698105,36.915901,
-121.703018,36.913124,-121.709198,
36.914902,-121.713791,36.908894,
-121.725143,36.914543,-121.726852,
36.911575,-121.733673,36.908775,
-121.74501,36.909081,-121.762939,
36.891598,-121.760864,36.88879,
-121.767975,36.889317,-121.768021,
36.885223,-121.775131,36.883289,
-121.78299,36.886055,-121.78595,
36.884865,-121.80191,36.868973,
-121.799438,36.857925,-121.808922,
36.850853)),'Monterey','06053',
'California','CA','06',3321.371,355660,107.0822);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.626305,38.667599,-122.622597,
38.664398,-122.6231,38.649899,
-122.633003,38.637001,-122.631905,
38.627701,-122.627197,38.623131,
-122.6325,38.619957,-122.632355,
38.61628,-122.638458,38.611755,
-122.645325,38.598686,-122.629402,
38.579102,-122.630737,38.569462,
-122.625824,38.570229,-122.621674,
38.567917,-122.619186,38.565426,
-122.619751,38.560413,-122.602196,
38.558876,-122.599136,38.555748,
-122.586563,38.552696,-122.572906,
38.540451,-122.565552,38.525635,
-122.553329,38.526321,-122.54953,
38.522224,-122.542801,38.520061,
-122.544205,38.516548,-122.541275,
38.51329,-122.547714,38.511719,
-122.544434,38.506889,-122.542068,
38.507584,-122.53447,38.501816,
-122.537109,38.497993,-122.541756,
38.498932,-122.54364,38.49577,
-122.530304,38.478634,-122.528503,
38.4697,-122.515152,38.470963,
-122.50473,38.464584,-122.508904,
38.462399,-122.508102,38.457802,
-122.492599,38.4566,-122.481903,
38.452801,-122.478912,38.443119,
-122.484413,38.437569,-122.486015,
38.431808,-122.490303,38.434502,
-122.496506,38.424599,-122.474503,
38.409199,-122.474304,38.406601,
-122.469505,38.404999,-122.467003,
38.400101,-122.469101,38.397598,
-122.464798,38.390499,-122.4468,
38.379398,-122.456741,38.368073,
-122.448601,38.361099,-122.436852,
38.357185,-122.425659,38.348858,
-122.426117,38.34613,-122.419037,
38.338432,-122.416199,38.339802,
-122.41095,38.334381,-122.412643,
38.33078,-122.408493,38.325821,
-122.408051,38.320641,-122.404312,
38.322205,-122.400864,38.314281,
-122.395065,38.30899,-122.3936,
38.304699,-122.400192,38.302818,
-122.402603,38.299713,-122.399734,
38.289635,-122.403503,38.281509,
-122.395905,38.272179,-122.386154,
38.273338,-122.388809,38.26078,
-122.372704,38.247501,-122.373505,
38.244598,-122.365707,38.247101,
-122.356598,38.225201,-122.357307,
38.209599,-122.348701,38.201199,
-122.349304,38.192402,-122.357002,
38.197498,-122.3591,38.195702,
-122.356102,38.192001,-122.355507,
38.183601,-122.357803,38.181499,
-122.365997,38.183102,-122.367302,
38.1814,-122.364304,38.166901,
-122.366501,38.158798,-122.370506,
38.1576,-122.390106,38.161499,
-122.4058,38.158901,-122.405998,
38.155899,-122.194305,38.155102,
-122.197906,38.159401,-122.193398,
38.164799,-122.196999,38.168499,
-122.202507,38.1688,-122.202103,
38.1716,-122.207802,38.172798,
-122.213997,38.179798,-122.211906,
38.184399,-122.2145,38.188499,
-122.208397,38.189999,-122.210403,
38.1922,-122.203903,38.198601,
-122.204597,38.208302,-122.200401,
38.2117,-122.193901,38.212399,
-122.195107,38.219002,-122.192307,
38.221298,-122.200706,38.240398,
-122.211403,38.248798,-122.209999,
38.2523,-122.2033,38.249401,
-122.194107,38.250801,-122.1922,
38.2565,-122.198601,38.258999,
-122.211906,38.259201,-122.215797,
38.262402,-122.215401,38.266102,
-122.211197,38.2729,-122.187302,
38.271702,-122.2024,38.292999,
-122.198105,38.301601,-122.201508,
38.304199,-122.200302,38.308102,
-122.204903,38.3158,-122.063705,
38.316002,-122.067101,38.318501,
-122.060303,38.327499,-122.068703,
38.342899,-122.072304,38.361,
-122.076599,38.3638,-122.087799,
38.3843,-122.108505,38.404701,
-122.113602,38.414001,-122.116905,
38.4142,-122.125305,38.429001,
-122.122505,38.447701,-122.103798,
38.490898,-122.106102,38.494598,
-122.105202,38.5084,-122.102211,
38.513374,-122.111649,38.526718,
-122.110558,38.530735,-122.114098,
38.534481,-122.112946,38.537983,
-122.127998,38.580994,-122.127907,
38.58709,-122.138306,38.609264,
-122.143326,38.612305,-122.150383,
38.625343,-122.159843,38.619392,
-122.164879,38.617775,-122.167267,
38.619392,-122.169296,38.629921,
-122.160126,38.635201,-122.164864,
38.64035,-122.163933,38.642529,
-122.161247,38.644192,-122.167213,
38.655392,-122.175041,38.658833,
-122.182159,38.65723,-122.19725,
38.669296,-122.202339,38.67728,
-122.198639,38.683407,-122.207123,
38.695633,-122.211487,38.696049,
-122.213539,38.693504,-122.220558,
38.696114,-122.223122,38.700081,
-122.221954,38.704609,-122.227325,
38.720718,-122.223938,38.72163,
-122.225441,38.727104,-122.234047,
38.740318,-122.240402,38.743248,
-122.249023,38.75536,-122.258179,
38.789616,-122.272896,38.809536,
-122.286911,38.840031,-122.300766,
38.83971,-122.301918,38.842495,
-122.31427,38.839569,-122.32296,
38.846352,-122.328674,38.842464,
-122.340996,38.842175,-122.348877,
38.835857,-122.384094,38.852577,
-122.393967,38.864349,-122.402802,
38.855701,-122.380905,38.8339,
-122.372398,38.817101,-122.378304,
38.8022,-122.396904,38.8041,
-122.411201,38.7859,-122.408997,
38.785599,-122.407906,38.776402,
-122.401802,38.772999,-122.414703,
38.768101,-122.462799,38.705299,
-122.626305,38.667599)),'Napa',
'06055','California','CA','06',753.7324,110765,146.9552);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.021095,39.391399,-121.024406,
39.389416,-121.030426,39.395596,
-121.033073,39.395618,-121.040955,
39.388302,-121.046135,39.389584,
-121.048729,39.395557,-121.058228,
39.39521,-121.061684,39.391186,
-121.082764,39.394798,-121.085854,
39.386425,-121.095322,39.387749,
-121.099998,39.38118,-121.10997,
39.381386,-121.115303,39.378727,
-121.126854,39.380047,-121.126183,
39.37265,-121.133202,39.371651,
-121.136414,39.363049,-121.144058,
39.355934,-121.142593,39.349987,
-121.153694,39.348732,-121.156204,
39.332718,-121.1614,39.332558,
-121.164253,39.338669,-121.175621,
39.338741,-121.181786,39.336632,
-121.183731,39.330753,-121.194534,
39.32959,-121.205269,39.316563,
-121.203911,39.307995,-121.199081,
39.302483,-121.213821,39.292988,
-121.217316,39.28429,-121.222809,
39.282547,-121.241501,39.283604,
-121.26506,39.272823,-121.265366,
39.268692,-121.25811,39.256527,
-121.268234,39.252232,-121.267723,
39.24036,-121.275009,39.231525,
-121.278465,39.230598,-121.278473,
39.034725,-121.256523,39.028233,
-121.248375,39.028179,-121.239571,
39.021408,-121.231682,39.024685,
-121.221146,39.012535,-121.216347,
39.012527,-121.204948,39.011787,
-121.203751,39.01561,-121.197823,
39.017601,-121.185478,39.012863,
-121.178055,39.020115,-121.171837,
39.018513,-121.151451,39.026859,
-121.148834,39.032513,-121.136391,
39.038067,-121.132782,39.034748,
-121.12384,39.032413,-121.125496,
39.030075,-121.122162,39.024635,
-121.114563,39.019077,-121.106972,
39.018097,-121.103996,39.012333,
-121.095818,39.013271,-121.09388,
39.011604,-121.088455,39.014488,
-121.078773,39.006985,-121.066994,
39.005451,-121.060593,39.010212,
-121.04055,39.013897,-121.030281,
39.026707,-121.028847,39.037502,
-121.02066,39.039696,-121.019135,
39.045853,-121.011856,39.048641,
-121.011681,39.052574,-121.007568,
39.051796,-121.005775,39.061405,
-121.001541,39.063004,-121.001427,
39.067554,-120.995819,39.06802,
-120.997292,39.072205,-120.99057,
39.076096,-120.995117,39.080605,
-120.990135,39.082024,-120.987694,
39.08548,-120.985275,39.10276,
-120.988632,39.111038,-120.978264,
39.110508,-120.972328,39.119644,
-120.967018,39.12207,-120.964737,
39.128258,-120.957939,39.131592,
-120.948471,39.13707,-120.946442,
39.143501,-120.939468,39.14537,
-120.935844,39.151501,-120.928879,
39.154079,-120.930527,39.156033,
-120.925392,39.15538,-120.92231,
39.157337,-120.923447,39.160954,
-120.907494,39.163857,-120.904915,
39.166233,-120.908051,39.170216,
-120.903519,39.173168,-120.895912,
39.176689,-120.891792,39.175362,
-120.868469,39.180481,-120.868591,
39.184963,-120.86412,39.187939,
-120.866096,39.189613,-120.859955,
39.19252,-120.856842,39.197533,
-120.85717,39.206131,-120.850464,
39.212242,-120.838203,39.215473,
-120.818001,39.228745,-120.799316,
39.235699,-120.773277,39.255501,
-120.767006,39.257118,-120.763298,
39.263203,-120.755791,39.264366,
-120.746544,39.27478,-120.727394,
39.287964,-120.709938,39.292427,
-120.702171,39.299683,-120.692215,
39.301949,-120.690506,39.30426,
-120.678284,39.306644,-120.67057,
39.310478,-120.669098,39.308308,
-120.661613,39.310135,-120.655014,
39.308266,-120.644722,39.315254,
-120.004295,39.316444,-120.00209,
39.445206,-120.504349,39.446171,
-120.508713,39.45491,-120.519775,
39.456566,-120.533287,39.464298,
-120.53318,39.48378,-120.538536,
39.486847,-120.540215,39.49099,
-120.548035,39.494568,-120.549629,
39.503727,-120.555603,39.506908,
-120.555595,39.513725,-120.55938,
39.516312,-120.567551,39.51601,
-120.570419,39.520538,-120.576622,
39.523331,-120.583145,39.52182,
-120.588493,39.523445,-120.596321,
39.520767,-120.597824,39.522301,
-120.61631,39.522106,-120.624435,
39.51984,-120.629227,39.524822,
-120.64975,39.52346,-120.654007,
39.526737,-120.676842,39.517956,
-120.677933,39.513699,-120.686356,
39.506744,-120.699989,39.502258,
-120.705505,39.493061,-120.715874,
39.489353,-120.712769,39.483063,
-120.725632,39.472122,-120.742157,
39.46711,-120.741272,39.461662,
-120.748848,39.457794,-120.751801,
39.4585,-120.754753,39.452877,
-120.760536,39.454044,-120.772697,
39.448788,-120.774879,39.450939,
-120.77948,39.446777,-120.783707,
39.448177,-120.785118,39.444401,
-120.790848,39.441429,-120.796272,
39.441933,-120.799286,39.437813,
-120.804832,39.438843,-120.810059,
39.436237,-120.812263,39.440147,
-120.815811,39.440857,-120.816895,
39.436581,-120.822174,39.437424,
-120.824829,39.435207,-120.835754,
39.440647,-120.842384,39.435226,
-120.853394,39.436504,-120.853828,
39.434013,-120.85675,39.435383,
-120.8638,39.430439,-120.874245,
39.431278,-120.875725,39.429626,
-120.877617,39.431274,-120.877769,
39.429104,-120.883629,39.429565,
-120.892632,39.4244,-120.909187,
39.426212,-120.911957,39.425091,
-120.913078,39.420238,-120.919922,
39.422646,-120.928764,39.420975,
-120.930832,39.417316,-120.94281,
39.419991,-120.957558,39.415806,
-120.971039,39.419163,-120.977966,
39.41795,-120.978996,39.411774,
-120.980858,39.414406,-120.985191,
39.411587,-120.99157,39.414536,
-121.005669,39.404922,-121.013962,
39.405586,-121.01355,39.402317,
-121.006264,39.399525,-121.016853,
39.395454,-121.021095,39.391399)),
'Nevada','06057','California','CA','06',957.4926,78510,81.9953);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-117.782402,33.9464,-117.975502,
33.9459,-117.9757,33.902599,
-117.984398,33.902599,-117.984398,
33.895302,-117.993103,33.895401,
-117.993202,33.8881,-118.001801,
33.8881,-118.001701,33.880901,
-118.010506,33.880901,-118.010506,
33.873299,-118.027901,33.873199,
-118.027901,33.866001,-118.036797,
33.866001,-118.036797,33.862499,
-118.041107,33.8624,-118.040855,
33.858723,-118.045502,33.858799,
-118.045326,33.8535,-118.049706,
33.8535,-118.049797,33.849899,
-118.054108,33.8498,-118.053986,
33.846188,-118.058304,33.8461,
-118.058304,33.835201,-118.062599,
33.831501,-118.062508,33.8195,
-118.071701,33.815102,-118.083702,
33.8032,-118.098106,33.776798,
-118.092621,33.76778,-118.091003,
33.758701,-118.1138,33.746101,
-118.116257,33.742897,-118.10009,
33.733109,-118.088776,33.728779,
-118.002258,33.655243,-117.940033,
33.619972,-117.927055,33.605663,
-117.878807,33.592354,-117.839401,
33.573502,-117.807701,33.551102,
-117.783997,33.5415,-117.737907,
33.494202,-117.737297,33.488998,
-117.732986,33.484978,-117.725601,
33.483398,-117.714294,33.460499,
-117.691002,33.4594,-117.682671,
33.461342,-117.644707,33.440701,
-117.630798,33.4305,-117.607025,
33.406288,-117.595627,33.387623,
-117.577599,33.453899,-117.556824,
33.451614,-117.537544,33.455631,
-117.507713,33.469639,-117.50885,
33.504993,-117.50885,33.509037,
-117.502876,33.508919,-117.502304,
33.520382,-117.509033,33.520523,
-117.509331,33.533985,-117.412109,
33.659023,-117.473694,33.703793,
-117.533119,33.710335,-117.535568,
33.757648,-117.579254,33.767971,
-117.662575,33.85894,-117.662712,
33.857513,-117.676819,33.858082,
-117.676231,33.868229,-117.671616,
33.869415,-117.672867,33.870815,
-117.679398,33.877399,-117.782402,
33.9464)),'Orange','06059',
'California','CA','06',789.5449,2410556,3053.0937);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.004295,39.316444,-120.644722,
39.315254,-120.655014,39.308266,
-120.661613,39.310135,-120.669098,
39.308308,-120.67057,39.310478,
-120.678284,39.306644,-120.690506,
39.30426,-120.692215,39.301949,
-120.702171,39.299683,-120.709938,
39.292427,-120.727394,39.287964,
-120.746544,39.27478,-120.755791,
39.264366,-120.763298,39.263203,
-120.767006,39.257118,-120.773277,
39.255501,-120.799316,39.235699,
-120.818001,39.228745,-120.838203,
39.215473,-120.850464,39.212242,
-120.85717,39.206131,-120.856842,
39.197533,-120.859955,39.19252,
-120.866096,39.189613,-120.86412,
39.187939,-120.868591,39.184963,
-120.868469,39.180481,-120.891792,
39.175362,-120.895912,39.176689,
-120.903519,39.173168,-120.908051,
39.170216,-120.904915,39.166233,
-120.907494,39.163857,-120.923447,
39.160954,-120.92231,39.157337,
-120.925392,39.15538,-120.930527,
39.156033,-120.928879,39.154079,
-120.935844,39.151501,-120.939468,
39.14537,-120.946442,39.143501,
-120.948471,39.13707,-120.957939,
39.131592,-120.964737,39.128258,
-120.967018,39.12207,-120.972328,
39.119644,-120.978264,39.110508,
-120.988632,39.111038,-120.985275,
39.10276,-120.987694,39.08548,
-120.990135,39.082024,-120.995117,
39.080605,-120.99057,39.076096,
-120.997292,39.072205,-120.995819,
39.06802,-121.001427,39.067554,
-121.001541,39.063004,-121.005775,
39.061405,-121.007568,39.051796,
-121.011681,39.052574,-121.011856,
39.048641,-121.019135,39.045853,
-121.02066,39.039696,-121.028847,
39.037502,-121.030281,39.026707,
-121.04055,39.013897,-121.060593,
39.010212,-121.066994,39.005451,
-121.078773,39.006985,-121.088455,
39.014488,-121.09388,39.011604,
-121.095818,39.013271,-121.103996,
39.012333,-121.106972,39.018097,
-121.114563,39.019077,-121.122162,
39.024635,-121.125496,39.030075,
-121.12384,39.032413,-121.132782,
39.034748,-121.136391,39.038067,
-121.148834,39.032513,-121.151451,
39.026859,-121.171837,39.018513,
-121.178055,39.020115,-121.185478,
39.012863,-121.197823,39.017601,
-121.203751,39.01561,-121.204948,
39.011787,-121.216347,39.012527,
-121.221146,39.012535,-121.231682,
39.024685,-121.239571,39.021408,
-121.248375,39.028179,-121.256523,
39.028233,-121.278473,39.034725,
-121.289154,39.036976,-121.292648,
39.04443,-121.301277,39.047935,
-121.303429,39.05257,-121.308098,
39.052666,-121.318398,39.04884,
-121.321945,39.043114,-121.328049,
39.044003,-121.334679,39.038895,
-121.352798,39.03141,-121.364578,
39.031849,-121.371315,39.027836,
-121.376007,39.021118,-121.384026,
39.017822,-121.383476,39.014599,
-121.404938,39.006523,-121.405708,
39.003864,-121.413834,39.002769,
-121.41333,38.926418,-121.468285,
38.926098,-121.468445,38.751377,
-121.483139,38.751297,-121.483398,
38.734699,-121.144798,38.711899,
-121.142754,38.717297,-121.147774,
38.731602,-121.13549,38.737858,
-121.129059,38.74995,-121.122765,
38.752254,-121.119728,38.770241,
-121.110046,38.77536,-121.103889,
38.7864,-121.104355,38.797054,
-121.100349,38.798126,-121.098099,
38.804066,-121.098831,38.810398,
-121.106499,38.815792,-121.097633,
38.818352,-121.095665,38.814785,
-121.090126,38.81464,-121.083839,
38.816544,-121.083199,38.819103,
-121.082848,38.822624,-121.088913,
38.827698,-121.086288,38.833378,
-121.081215,38.834991,-121.072525,
38.842705,-121.056915,38.847904,
-121.060768,38.859985,-121.052208,
38.868446,-121.05587,38.877407,
-121.060898,38.88224,-121.043236,
38.89043,-121.047104,38.895473,
-121.052834,38.896976,-121.052963,
38.899345,-121.042702,38.907391,
-121.039436,38.915615,-121.032608,
38.913025,-121.017281,38.918591,
-121.010323,38.916546,-121.004158,
38.920128,-121,38.917755,-120.990425,
38.923389,-120.990929,38.927299,
-120.965012,38.932781,-120.957039,
38.93914,-120.937592,38.935757,
-120.937263,38.957035,-120.939522,
38.960899,-120.93544,38.964188,
-120.922485,38.961132,-120.912735,
38.955452,-120.900887,38.953209,
-120.887062,38.959793,-120.858261,
38.9519,-120.856422,38.956776,
-120.851151,38.959385,-120.854408,
38.967941,-120.84919,38.976501,
-120.839699,38.9757,-120.837646,
38.971786,-120.833984,38.971584,
-120.828293,38.980461,-120.827415,
38.989956,-120.822464,38.993275,
-120.814697,38.994507,-120.811417,
39.000359,-120.801216,39.001106,
-120.797081,38.996109,-120.787254,
38.999542,-120.766991,39.009453,
-120.762772,39.009472,-120.765884,
39.005215,-120.761604,39.001865,
-120.759094,39.003414,-120.762794,
39.004234,-120.762482,39.006458,
-120.75975,39.005535,-120.756882,
39.007774,-120.751778,39.005329,
-120.749168,39.009422,-120.745209,
39.010502,-120.747223,39.003246,
-120.743065,39.004955,-120.740601,
39.00153,-120.735001,39.000702,
-120.728226,39.003853,-120.721825,
38.998962,-120.721298,38.993294,
-120.715904,38.987228,-120.703529,
38.981327,-120.692131,38.985332,
-120.687675,38.989864,-120.68383,
38.989361,-120.684181,38.983505,
-120.679939,38.9776,-120.682785,
38.967579,-120.673164,38.962475,
-120.672089,38.958817,-120.654747,
38.953594,-120.653435,38.94838,
-120.643761,38.946819,-120.641594,
38.944485,-120.635361,38.943428,
-120.628822,38.946468,-120.621056,
38.94313,-120.610893,38.943024,
-120.604881,38.93465,-120.593346,
38.936234,-120.591995,38.932022,
-120.586044,38.931545,-120.584869,
38.9226,-120.570763,38.914253,
-120.55571,38.915211,-120.552048,
38.920177,-120.545341,38.920681,
-120.542847,38.927521,-120.533745,
38.926006,-120.526276,38.931656,
-120.511215,38.931396,-120.509346,
38.934669,-120.503632,38.935532,
-120.501511,38.941319,-120.490982,
38.944027,-120.491806,38.948898,
-120.486458,38.952515,-120.485001,
38.957516,-120.469971,38.965813,
-120.460594,38.978462,-120.458923,
38.984776,-120.450829,38.987728,
-120.452827,38.995281,-120.444122,
39.010197,-120.444107,39.018215,
-120.434036,39.028481,-120.327095,
39.02253,-120.239388,39.023762,
-120.239136,39.030983,-120.183083,
39.031109,-120.182533,39.038464,
-120.164009,39.038582,-120.16394,
39.045879,-120.151955,39.045898,
-120.152,39.060425,-120.142578,
39.060291,-120.142639,39.067379,
-120.00145,39.067585,-120.002411,
39.112782,-120.003441,39.165684,
-120.004295,39.316444)),'Placer',
'06061','California','CA','06',1404.1699,172796,123.0591);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.496544,40.445713,-121.49334,
40.440533,-121.496796,40.432125,
-121.472717,40.424759,-121.478516,
40.419624,-121.483192,40.396679,
-121.481674,40.382977,-121.472458,
40.374676,-121.479904,40.366737,
-121.471329,40.351742,-121.467339,
40.349892,-121.437614,40.348015,
-121.427467,40.350407,-121.41098,
40.342834,-121.3964,40.342232,
-121.388451,40.339069,-121.379295,
40.340405,-121.366249,40.3311,
-121.366386,40.323013,-121.359642,
40.322346,-121.352753,40.315765,
-121.341187,40.309868,-121.341942,
40.306759,-121.348816,40.306057,
-121.355545,40.297588,-121.365608,
40.30117,-121.37056,40.29734,
-121.362465,40.287518,-121.359451,
40.279064,-121.362091,40.268234,
-121.360657,40.265053,-121.354523,
40.26228,-121.353378,40.247608,
-121.366325,40.236122,-121.360634,
40.2257,-121.365685,40.214149,
-121.375,40.210625,-121.383942,
40.210415,-121.392471,40.201511,
-121.399696,40.199928,-121.400528,
40.195465,-121.406273,40.191525,
-121.411659,40.194431,-121.432472,
40.196026,-121.441292,40.193031,
-121.441719,40.188595,-121.438522,
40.187946,-121.434967,40.182018,
-121.44397,40.177788,-121.441643,
40.161957,-121.444946,40.155952,
-121.440582,40.152172,-121.4356,
40.152027,-121.403435,40.151764,
-121.403717,40.115685,-121.384773,
40.116047,-121.384933,40.108799,
-121.375359,40.108765,-121.37571,
40.086189,-121.365738,40.08617,
-121.366066,40.072002,-121.375771,
40.071865,-121.375999,40.057209,
-121.38092,40.05711,-121.381187,
40.051945,-121.399269,40.052212,
-121.399254,40.03064,-121.408562,
40.030739,-121.408478,40.015842,
-121.418404,40.015884,-121.418739,
39.987667,-121.409203,39.987385,
-121.409309,39.958527,-121.4188,
39.95871,-121.419495,39.929569,
-121.410011,39.92955,-121.40992,
39.915207,-121.428932,39.914951,
-121.428879,39.900433,-121.409912,
39.90052,-121.410858,39.871536,
-121.397888,39.871387,-121.39743,
39.862995,-121.379059,39.862984,
-121.379135,39.855591,-121.36013,
39.855591,-121.359444,39.840855,
-121.349953,39.840427,-121.349785,
39.825832,-121.331192,39.825794,
-121.331253,39.811169,-121.317368,
39.811008,-121.315811,39.796783,
-121.306633,39.796734,-121.30674,
39.789482,-121.293053,39.789364,
-121.293152,39.785618,-121.288391,
39.785553,-121.288429,39.781773,
-121.283875,39.781693,-121.284775,
39.767738,-121.267197,39.768913,
-121.266953,39.75436,-121.249565,
39.754082,-121.247192,39.740154,
-121.228699,39.740334,-121.228477,
39.725784,-121.209808,39.725765,
-121.207642,39.700546,-121.189461,
39.700005,-121.189217,39.685463,
-121.17012,39.685677,-121.170074,
39.6712,-121.161942,39.671223,
-121.161835,39.663967,-121.154106,
39.66404,-121.154007,39.656895,
-121.135345,39.656921,-121.135651,
39.628281,-121.115555,39.628159,
-121.115265,39.621128,-121.096474,
39.621017,-121.096664,39.613808,
-121.087822,39.613655,-121.087852,
39.603416,-121.078278,39.603458,
-121.07563,39.597378,-121.008408,
39.639713,-121,39.638515,-120.985023,
39.644863,-120.982719,39.648983,
-120.977425,39.648941,-120.964111,
39.660656,-120.962601,39.665165,
-120.948334,39.672508,-120.950668,
39.676674,-120.939011,39.686443,
-120.938866,39.692963,-120.935455,
39.693302,-120.936493,39.700146,
-120.933083,39.701702,-120.933304,
39.738899,-120.924522,39.744453,
-120.921928,39.750874,-120.915741,
39.753342,-120.912819,39.757332,
-120.894157,39.759956,-120.886627,
39.767235,-120.8759,39.771633,
-120.869743,39.776985,-120.858475,
39.770615,-120.853325,39.760021,
-120.843254,39.756241,-120.843231,
39.751831,-120.838364,39.746456,
-120.827667,39.746929,-120.825226,
39.742107,-120.814499,39.747089,
-120.808197,39.720882,-120.793709,
39.718506,-120.790573,39.715092,
-120.791359,39.709812,-120.781929,
39.709949,-120.77993,39.712395,
-120.771248,39.71331,-120.769211,
39.717983,-120.748871,39.719742,
-120.741409,39.712646,-120.734032,
39.710854,-120.733551,39.708447,
-120.715111,39.706379,-120.702415,
39.692371,-120.69397,39.691814,
-120.678856,39.676693,-120.670265,
39.682549,-120.658699,39.686573,
-120.653679,39.694218,-120.653175,
39.706734,-120.146111,39.707752,
-120.145561,39.7365,-120.12674,
39.736256,-120.126602,39.751026,
-120.11808,39.751183,-120.118553,
39.765724,-120.109589,39.765873,
-120.110023,39.780968,-120.106773,
39.794304,-120.107063,39.881359,
-120.098305,39.881317,-120.098518,
39.910435,-120.107849,39.910473,
-120.107727,39.939606,-120.125534,
39.939648,-120.125671,39.947849,
-120.134735,39.947861,-120.134682,
39.955135,-120.143951,39.955166,
-120.143974,39.962387,-120.153343,
39.962448,-120.153297,39.968632,
-120.162613,39.968758,-120.162369,
39.983875,-120.172234,39.98399,
-120.171967,39.998425,-120.181419,
39.998619,-120.18145,40.013447,
-120.200226,40.013573,-120.20034,
40.042824,-120.209846,40.042858,
-120.208603,40.086109,-120.245857,
40.085907,-120.245743,40.107979,
-120.264595,40.107849,-120.265518,
40.115967,-120.34034,40.115345,
-120.340416,40.122658,-120.359566,
40.122616,-120.359375,40.129623,
-120.378349,40.129608,-120.378067,
40.140656,-120.397255,40.140739,
-120.397209,40.147465,-120.406906,
40.147457,-120.40657,40.162258,
-120.416199,40.162186,-120.415878,
40.169544,-120.435318,40.169662,
-120.43531,40.176762,-120.444839,
40.176956,-120.443878,40.191383,
-120.453247,40.191456,-120.453278,
40.205853,-120.481789,40.205898,
-120.481407,40.220284,-120.490997,
40.22039,-120.490662,40.234894,
-120.509613,40.234798,-120.50975,
40.249039,-120.528679,40.249298,
-120.528648,40.256306,-120.547607,
40.256378,-120.547653,40.263702,
-120.575668,40.263901,-120.575768,
40.285538,-120.621735,40.285816,
-120.621597,40.293121,-120.641449,
40.293289,-120.641273,40.300499,
-120.650581,40.300552,-120.651093,
40.307758,-120.725349,40.30854,
-120.72551,40.316036,-120.763336,
40.316116,-120.763283,40.308823,
-120.772667,40.308788,-120.772743,
40.301537,-120.795532,40.301262,
-120.794937,40.27784,-120.813576,
40.277943,-120.81395,40.270836,
-120.832748,40.270836,-120.832993,
40.256271,-120.842438,40.256126,
-120.842537,40.249001,-120.852135,
40.24894,-120.852043,40.241905,
-120.87072,40.241753,-120.870697,
40.199547,-120.88961,40.19952,
-120.889587,40.192226,-120.927513,
40.192039,-120.927002,40.206566,
-120.946091,40.206612,-120.945122,
40.220921,-121.002663,40.221088,
-121.002846,40.23505,-121.040451,
40.234905,-121.040451,40.256588,
-121.060425,40.256531,-121.060341,
40.446648,-121.326744,40.445484,
-121.336502,40.445599,-121.345459,
40.449833,-121.365021,40.446045,
-121.496544,40.445713)),'Plumas',
'06063','California','CA','06',2553.5214,19739,7.7301);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-117.672867,33.870815,-117.671616,
33.869415,-117.676231,33.868229,
-117.676819,33.858082,-117.662712,
33.857513,-117.662575,33.85894,
-117.579254,33.767971,-117.535568,
33.757648,-117.533119,33.710335,
-117.473694,33.703793,-117.412109,
33.659023,-117.509331,33.533985,
-117.509033,33.520523,-117.502304,
33.520382,-117.502876,33.508919,
-117.50885,33.509037,-117.50885,
33.504993,-117.363403,33.505001,
-117.369904,33.4907,-117.240799,
33.448898,-117.240601,33.4319,
-117.139801,33.432598,-117.029999,
33.430099,-117.029999,33.426899,
-116.5,33.426773,-116.196716,
33.428864,-116.084328,33.425903,
-115.5,33.426846,-115.46669,
33.426964,-115.46669,33.428375,
-115.062393,33.428078,-114.83004,
33.430065,-114.83007,33.433681,
-114.626335,33.433525,-114.621498,
33.447529,-114.622131,33.456535,
-114.600914,33.481369,-114.591583,
33.49865,-114.579681,33.506439,
-114.568741,33.509193,-114.560173,
33.516712,-114.558113,33.531796,
-114.523819,33.552204,-114.536003,
33.570934,-114.539513,33.580593,
-114.539833,33.591389,-114.528397,
33.606628,-114.521057,33.612518,
-114.530426,33.623886,-114.530251,
33.628189,-114.525581,33.630238,
-114.523018,33.634678,-114.53241,
33.651634,-114.529793,33.654442,
-114.517555,33.655903,-114.513275,
33.660156,-114.52948,33.666801,
-114.530739,33.675087,-114.52317,
33.685856,-114.494926,33.698433,
-114.493408,33.707901,-114.495773,
33.719135,-114.511559,33.734192,
-114.503693,33.75098,-114.504074,
33.760445,-114.527267,33.814945,
-114.521927,33.818958,-114.51918,
33.825363,-114.529816,33.855419,
-114.524879,33.859985,-114.513885,
33.85862,-114.502625,33.866432,
-114.503006,33.876053,-114.521973,
33.892563,-114.525078,33.900215,
-114.523499,33.901569,-114.512924,
33.897942,-114.507919,33.900623,
-114.507126,33.90379,-114.510719,
33.911076,-114.517647,33.9175,
-114.532906,33.925076,-114.534691,
33.934635,-114.522339,33.954647,
-114.515076,33.958088,-114.507881,
33.957508,-114.4991,33.961773,
-114.46714,33.992859,-114.45784,
33.995541,-114.458397,34,-114.466522,
34.005177,-114.46508,34.010971,
-114.449417,34.012562,-114.437477,
34.022591,-114.434158,34.037769,
-114.438553,34.057877,-114.434639,
34.079712,-114.832367,34.079575,
-115.315247,34.077831,-115.315399,
34.0341,-116.299759,34.034393,
-116.299789,34.032536,-116.315086,
34.032463,-116.928703,34.0341,
-116.928505,34.004902,-117.224503,
34.004299,-117.224503,34.0187,
-117.374504,34.019402,-117.374397,
34.034,-117.557503,34.033699,
-117.557198,33.988499,-117.609505,
33.9716,-117.610001,33.925098,
-117.654503,33.925098,-117.653999,
33.888802,-117.6754,33.888802,
-117.668106,33.880901,-117.672867,
33.870815)),'Riverside','06065',
'California','CA','06',7206.914,1170413,162.4013);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.601822,38.735935,-121.606544,
38.715664,-121.631378,38.695137,
-121.633057,38.689121,-121.630852,
38.680737,-121.593002,38.644199,
-121.586105,38.642799,-121.574997,
38.648701,-121.565804,38.645199,
-121.557198,38.608299,-121.548798,
38.599499,-121.543503,38.597801,
-121.538002,38.602001,-121.526604,
38.604698,-121.514702,38.602798,
-121.507599,38.596901,-121.505203,
38.586399,-121.507202,38.580601,
-121.519905,38.566299,-121.510223,
38.546383,-121.511551,38.541759,
-121.527397,38.5322,-121.529701,
38.528,-121.524506,38.523201,
-121.524109,38.519054,-121.550797,
38.513901,-121.558105,38.4981,
-121.546402,38.4813,-121.537704,
38.4748,-121.507797,38.4729,
-121.504105,38.469898,-121.499969,
38.450226,-121.501266,38.441982,
-121.505524,38.437374,-121.51429,
38.434608,-121.527374,38.434639,
-121.531532,38.431553,-121.512192,
38.398911,-121.513763,38.38728,
-121.523201,38.3792,-121.520576,
38.360191,-121.536163,38.347679,
-121.558289,38.342655,-121.574112,
38.327263,-121.583008,38.3316,
-121.591827,38.313152,-121.597443,
38.310192,-121.598877,38.301617,
-121.604111,38.296177,-121.604355,
38.285793,-121.599663,38.278465,
-121.602943,38.270191,-121.599182,
38.257904,-121.602142,38.237282,
-121.60099,38.221729,-121.609344,
38.208466,-121.611618,38.199039,
-121.620323,38.193665,-121.631233,
38.194336,-121.647362,38.185375,
-121.661842,38.181969,-121.676926,
38.164993,-121.684578,38.159729,
-121.691025,38.133217,-121.706146,
38.109921,-121.709824,38.086575,
-121.728287,38.082432,-121.742096,
38.087311,-121.799057,38.059727,
-121.826851,38.066303,-121.841377,
38.076817,-121.858528,38.071217,
-121.861389,38.066113,-121.85257,
38.064857,-121.845734,38.060036,
-121.831055,38.031181,-121.817116,
38.02227,-121.809586,38.02037,
-121.800209,38.021706,-121.788544,
38.018547,-121.776413,38.018997,
-121.762398,38.023602,-121.736755,
38.026711,-121.698708,38.0453,
-121.679794,38.062214,-121.680801,
38.0821,-121.6782,38.089401,
-121.671997,38.093601,-121.660797,
38.095699,-121.644119,38.087498,
-121.637024,38.086212,-121.631531,
38.088692,-121.627289,38.098,
-121.618698,38.099529,-121.603859,
38.09996,-121.580231,38.094048,
-121.566116,38.097404,-121.562973,
38.101505,-121.566116,38.106323,
-121.582443,38.113556,-121.583008,
38.120312,-121.575279,38.129135,
-121.556625,38.136833,-121.558113,
38.143967,-121.546143,38.148159,
-121.542717,38.147408,-121.540291,
38.151966,-121.535248,38.151665,
-121.535088,38.158241,-121.528236,
38.169106,-121.523293,38.172401,
-121.526772,38.181744,-121.523392,
38.1856,-121.527832,38.195415,
-121.519623,38.203014,-121.512123,
38.202488,-121.508873,38.204662,
-121.503273,38.212215,-121.505325,
38.22467,-121.490608,38.227776,
-121.489395,38.23307,-121.48571,
38.235905,-121.486,38.240002,
-121.477524,38.246258,-121.479439,
38.253056,-121.47541,38.257809,
-121.466164,38.259918,-121.454147,
38.256882,-121.4496,38.254673,
-121.443954,38.256702,-121.428658,
38.254848,-121.4245,38.250816,
-121.424606,38.243713,-121.419456,
38.237328,-121.403923,38.2304,
-121.400574,38.231647,-121.396065,
38.22765,-121.387794,38.233311,
-121.370049,38.229774,-121.366127,
38.231457,-121.362656,38.228527,
-121.352257,38.231087,-121.344002,
38.228226,-121.314415,38.235569,
-121.304062,38.234959,-121.291618,
38.239086,-121.28109,38.25024,
-121.275932,38.249184,-121.267395,
38.252415,-121.245811,38.244705,
-121.228386,38.246975,-121.220963,
38.244175,-121.214241,38.24752,
-121.202065,38.248062,-121.190369,
38.253521,-121.169792,38.249664,
-121.16243,38.252735,-121.151009,
38.263714,-121.139664,38.265488,
-121.126465,38.27515,-121.09861,
38.285713,-121.092545,38.284313,
-121.082893,38.286552,-121.062286,
38.297462,-121.052986,38.294987,
-121.048439,38.287773,-121.041977,
38.286091,-121.037781,38.288109,
-121.035042,38.294804,-121.025185,
38.298,-121.026306,38.50816,
-121.117706,38.717499,-121.1231,
38.7108,-121.132301,38.705799,
-121.140198,38.712299,-121.144798,
38.711899,-121.483398,38.734699,
-121.520706,38.7365,-121.601822,
38.735935)),'Sacramento','06067',
'California','CA','06',965.5253,1041219,1078.3955);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.580391,36.900604,-121.580307,
36.8992,-121.587799,36.901299,
-121.6063,36.899502,-121.618797,
36.908901,-121.628426,36.911736,
-121.636955,36.898415,-121.642799,
36.8941,-121.639587,36.879143,
-121.641403,36.8736,-121.621033,
36.846249,-121.596649,36.837395,
-121.50296,36.757248,-121.501373,
36.760239,-121.48159,36.765453,
-121.473648,36.757496,-121.474602,
36.749252,-121.470665,36.745579,
-121.461319,36.743893,-121.459122,
36.737305,-121.456337,36.736801,
-121.458168,36.734318,-121.451599,
36.729248,-121.450287,36.724831,
-121.452026,36.721241,-121.460236,
36.717709,-121.483078,36.714352,
-121.480659,36.704636,-121.476433,
36.70306,-121.471779,36.696926,
-121.467979,36.685474,-121.457909,
36.68576,-121.443283,36.673187,
-121.430519,36.678768,-121.422806,
36.674377,-121.41449,36.6731,
-121.40596,36.656075,-121.395584,
36.656929,-121.392815,36.654903,
-121.377289,36.652901,-121.365211,
36.656647,-121.351929,36.647915,
-121.349052,36.648396,-121.348427,
36.643341,-121.340584,36.638378,
-121.341049,36.631393,-121.331535,
36.620644,-121.317329,36.610069,
-121.317673,36.604893,-121.322739,
36.602406,-121.323181,36.588474,
-121.326309,36.585922,-121.322479,
36.577591,-121.332878,36.574444,
-121.330086,36.570042,-121.330978,
36.562195,-121.327637,36.561165,
-121.328102,36.555481,-121.312439,
36.549957,-121.299881,36.537312,
-121.294319,36.527164,-121.302193,
36.518177,-121.306152,36.51685,
-121.305717,36.512211,-121.310928,
36.504623,-121.307808,36.499458,
-121.299698,36.505836,-121.296104,
36.503971,-121.293015,36.506271,
-121.283928,36.505733,-121.280952,
36.502739,-121.267921,36.502003,
-121.25856,36.504501,-121.253845,
36.503548,-121.245857,36.50676,
-121.238258,36.504814,-121.235832,
36.497662,-121.229782,36.491756,
-121.231544,36.489079,-121.227074,
36.484634,-121.228477,36.475311,
-121.224434,36.472027,-121.221321,
36.473877,-121.21405,36.473244,
-121.208794,36.46484,-121.19664,
36.455101,-121.194099,36.447262,
-121.119087,36.387733,-121.03978,
36.324005,-121.039284,36.270859,
-121.034576,36.273048,-121.034859,
36.27552,-121.026031,36.275085,
-121.026039,36.259701,-121.021431,
36.261372,-121.017738,36.259628,
-121.013565,36.268578,-121.010666,
36.264389,-121.009331,36.268829,
-121.003456,36.26704,-120.998924,
36.270912,-120.991264,36.27018,
-120.986038,36.275909,-120.987007,
36.285084,-120.984207,36.293259,
-120.972649,36.290241,-120.963402,
36.280514,-120.958138,36.280861,
-120.955223,36.275616,-120.951462,
36.275112,-120.93914,36.282211,
-120.939957,36.28688,-120.933205,
36.289925,-120.93544,36.294182,
-120.932076,36.299789,-120.925003,
36.301483,-120.924522,36.308102,
-120.918953,36.31105,-120.898109,
36.300861,-120.888527,36.290417,
-120.882927,36.294006,-120.87281,
36.294926,-120.858696,36.290237,
-120.855362,36.284584,-120.850441,
36.285709,-120.849281,36.282207,
-120.843796,36.280628,-120.835739,
36.27198,-120.838394,36.270882,
-120.835846,36.262272,-120.832657,
36.262547,-120.832085,36.259117,
-120.828125,36.259438,-120.828644,
36.257511,-120.824883,36.257763,
-120.823608,36.25518,-120.822334,
36.257149,-120.819534,36.253922,
-120.813606,36.253162,-120.812675,
36.250404,-120.809792,36.251793,
-120.811142,36.245083,-120.806282,
36.243664,-120.805153,36.240368,
-120.799614,36.240093,-120.80117,
36.237621,-120.798141,36.235516,
-120.788368,36.23494,-120.788284,
36.230705,-120.782349,36.229057,
-120.780632,36.222809,-120.771965,
36.220242,-120.767761,36.213921,
-120.764542,36.213463,-120.766243,
36.21019,-120.762939,36.208954,
-120.760681,36.203457,-120.757263,
36.201832,-120.75489,36.203274,
-120.752075,36.199471,-120.742653,
36.198929,-120.731186,36.203739,
-120.717522,36.196716,-120.71077,
36.198273,-120.704445,36.206856,
-120.705376,36.227734,-120.716667,
36.260056,-120.723701,36.270351,
-120.730942,36.27541,-120.732819,
36.284245,-120.741928,36.298065,
-120.757324,36.308643,-120.75193,
36.307838,-120.745651,36.310284,
-120.724258,36.297039,-120.721573,
36.292698,-120.715179,36.292191,
-120.706726,36.285763,-120.700951,
36.286201,-120.687492,36.272224,
-120.681412,36.271999,-120.677574,
36.267361,-120.673241,36.272778,
-120.675186,36.276878,-120.671616,
36.280533,-120.681877,36.286835,
-120.679451,36.290722,-120.681831,
36.294304,-120.662125,36.314426,
-120.645126,36.317043,-120.643341,
36.319061,-120.629524,36.316936,
-120.618919,36.319988,-120.616913,
36.318859,-120.611694,36.320892,
-120.611511,36.324409,-120.603889,
36.324154,-120.59922,36.328331,
-120.595558,36.328533,-120.596153,
36.488285,-120.602707,36.488293,
-120.917709,36.740433,-120.932663,
36.751945,-121.140488,36.836708,
-121.141998,36.846352,-121.150841,
36.858913,-121.151588,36.865402,
-121.162552,36.869297,-121.16806,
36.885044,-121.173058,36.885761,
-121.183266,36.896435,-121.183266,
36.909023,-121.187759,36.913288,
-121.197243,36.914387,-121.206154,
36.911572,-121.216026,36.913555,
-121.22068,36.910412,-121.223152,
36.919971,-121.229111,36.921291,
-121.233299,36.926197,-121.228165,
36.941086,-121.217468,36.947941,
-121.210762,36.957165,-121.214371,
36.9613,-121.417198,36.960602,
-121.435707,36.9781,-121.446297,
36.983009,-121.449203,36.9888,
-121.461998,36.9856,-121.464905,
36.982201,-121.462509,36.978348,
-121.466888,36.976826,-121.487907,
36.9832,-121.511307,36.958801,
-121.5093,36.953602,-121.512703,
36.945099,-121.539505,36.9254,
-121.539505,36.9203,-121.557198,
36.911201,-121.559402,36.897701,
-121.568321,36.898235,-121.57399,
36.894203,-121.580391,36.900604)),
'SanBenito','06069','California','CA','06',1388.8955,36697,26.4217);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-117.632095,35.797298,-117.633354,
35.709976,-117.651085,35.70998,
-117.651421,35.680828,-117.615303,
35.680901,-117.615501,35.651798,
-117.632935,35.651512,-117.63398,
35.622364,-117.633881,35.564152,
-117.629234,35.564117,-117.629082,
35.539982,-117.629318,35.45108,
-117.632767,35.451035,-117.630402,
35.419605,-117.631119,34.822289,
-117.666397,34.822544,-117.666145,
34.558018,-117.659103,34.558048,
-117.658669,34.451488,-117.644722,
34.289944,-117.676704,34.165119,
-117.718597,34.0597,-117.729599,
34.0215,-117.735504,34.018501,
-117.7668,34.0238,-117.766701,
34.004601,-117.784401,34.004799,
-117.802002,33.975601,-117.801804,
33.9683,-117.792908,33.968102,
-117.792999,33.953999,-117.782402,
33.9464,-117.679398,33.877399,
-117.672867,33.870815,-117.668106,
33.880901,-117.6754,33.888802,
-117.653999,33.888802,-117.654503,
33.925098,-117.610001,33.925098,
-117.609505,33.9716,-117.557198,
33.988499,-117.557503,34.033699,
-117.374397,34.034,-117.374504,
34.019402,-117.224503,34.0187,
-117.224503,34.004299,-116.928505,
34.004902,-116.928703,34.0341,
-116.315086,34.032463,-116.299789,
34.032536,-116.299759,34.034393,
-115.315399,34.0341,-115.315247,
34.077831,-114.832367,34.079575,
-114.434639,34.079712,-114.432594,
34.088394,-114.419708,34.103451,
-114.410896,34.110016,-114.400818,
34.111637,-114.389778,34.110069,
-114.378448,34.115971,-114.365738,
34.118561,-114.352249,34.133102,
-114.335327,34.134022,-114.319992,
34.138618,-114.286514,34.170517,
-114.274483,34.172134,-114.267677,
34.170162,-114.256248,34.172825,
-114.239929,34.183216,-114.228935,
34.186913,-114.224159,34.193878,
-114.224419,34.203629,-114.210976,
34.211525,-114.177269,34.239956,
-114.173813,34.247288,-114.165344,
34.25,-114.163086,34.253338,
-114.163864,34.259686,-114.132484,
34.25845,-114.130432,34.262714,
-114.135887,34.274364,-114.137505,
34.303215,-114.156425,34.317848,
-114.168022,34.3395,-114.176125,
34.349293,-114.198692,34.361359,
-114.225327,34.365906,-114.23349,
34.376648,-114.262131,34.40036,
-114.286018,34.405327,-114.290367,
34.409771,-114.29261,34.41951,
-114.300232,34.426796,-114.325928,
34.437843,-114.330978,34.44664,
-114.336685,34.450905,-114.372925,
34.446926,-114.38591,34.457901,
-114.380913,34.476028,-114.381569,
34.495747,-114.377335,34.507275,
-114.380051,34.529713,-114.404442,
34.56963,-114.421593,34.5807,
-114.436012,34.596066,-114.424545,
34.600834,-114.423409,34.610443,
-114.437943,34.621449,-114.440674,
34.642525,-114.457191,34.657104,
-114.449715,34.666828,-114.464455,
34.691196,-114.470192,34.712208,
-114.48671,34.716621,-114.491226,
34.725697,-114.515823,34.73674,
-114.528824,34.750816,-114.551888,
34.766869,-114.570213,34.794289,
-114.575653,34.815296,-114.586044,
34.835667,-114.599854,34.847355,
-114.623146,34.859737,-114.632256,
34.869968,-114.635925,34.889103,
-114.630081,34.907261,-114.632454,
34.924606,-114.628967,34.943039,
-114.634438,34.965149,-114.62822,
34.986149,-114.632217,35.002083,
-115.646362,35.809021,-115.734901,
35.809124,-115.735046,35.793648,
-116.069458,35.793503,-117.250046,
35.795052,-117.632095,35.797298)),
'SanBernardino','06071','California','CA','06',20058.7812,1418380,70.7111);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-117.50885,33.504993,-117.507713,
33.469639,-117.537544,33.455631,
-117.556824,33.451614,-117.577599,
33.453899,-117.595627,33.387623,
-117.595001,33.3866,-117.571144,
33.378109,-117.548477,33.365299,
-117.499199,33.327847,-117.448936,
33.271667,-117.354317,33.156353,
-117.313904,33.091305,-117.302078,
33.056808,-117.277443,33.000629,
-117.260689,32.939522,-117.251816,
32.885315,-117.251816,32.866589,
-117.26181,32.852428,-117.278427,
32.849831,-117.281387,32.834061,
-117.278427,32.821251,-117.25576,
32.792667,-117.2528,32.755215,
-117.256744,32.714806,-117.245903,
32.666508,-117.241959,32.664539,
-117.235054,32.668484,-117.230225,
32.677952,-117.218689,32.686897,
-117.199661,32.689896,-117.18261,
32.683914,-117.16526,32.669594,
-117.140442,32.629059,-117.134529,
32.614277,-117.133545,32.56105,
-117.128761,32.554695,-117.124184,
32.534878,-117.044525,32.540909,
-117.041107,32.541199,-117.039993,
32.541248,-117.035583,32.54158,
-116.860207,32.556618,-116.105339,
32.61853,-116.104797,32.726437,
-116.102295,32.72644,-116.102409,
33.074623,-116.080246,33.074799,
-116.084328,33.425903,-116.196716,
33.428864,-116.5,33.426773,
-117.029999,33.426899,-117.029999,
33.430099,-117.139801,33.432598,
-117.240601,33.4319,-117.240799,
33.448898,-117.369904,33.4907,
-117.363403,33.505001,-117.50885,
33.504993)),'SanDiego','06073',
'California','CA','06',4203.7578,2498016,594.2338);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.391502,37.707813,-122.391602,
37.708401,-122.380875,37.710056,
-122.372581,37.718094,-122.362473,
37.715759,-122.356247,37.730015,
-122.365318,37.732609,-122.378799,
37.751793,-122.386063,37.791973,
-122.397987,37.805969,-122.405502,
37.81089,-122.418983,37.811413,
-122.463051,37.804672,-122.477303,
37.810631,-122.485077,37.790417,
-122.491302,37.788078,-122.504524,
37.788078,-122.514114,37.780823,
-122.502487,37.707222,-122.391502,
37.707813)),'SanFrancisco','06075',
'California','CA','06',46.6927,723959,15504.7343);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.025185,38.298,-121.035042,
38.294804,-121.037781,38.288109,
-121.041977,38.286091,-121.048439,
38.287773,-121.052986,38.294987,
-121.062286,38.297462,-121.082893,
38.286552,-121.092545,38.284313,
-121.09861,38.285713,-121.126465,
38.27515,-121.139664,38.265488,
-121.151009,38.263714,-121.16243,
38.252735,-121.169792,38.249664,
-121.190369,38.253521,-121.202065,
38.248062,-121.214241,38.24752,
-121.220963,38.244175,-121.228386,
38.246975,-121.245811,38.244705,
-121.267395,38.252415,-121.275932,
38.249184,-121.28109,38.25024,
-121.291618,38.239086,-121.304062,
38.234959,-121.314415,38.235569,
-121.344002,38.228226,-121.352257,
38.231087,-121.362656,38.228527,
-121.366127,38.231457,-121.370049,
38.229774,-121.387794,38.233311,
-121.396065,38.22765,-121.400574,
38.231647,-121.403923,38.2304,
-121.419456,38.237328,-121.424606,
38.243713,-121.4245,38.250816,
-121.428658,38.254848,-121.443954,
38.256702,-121.4496,38.254673,
-121.454147,38.256882,-121.466164,
38.259918,-121.47541,38.257809,
-121.479439,38.253056,-121.477524,
38.246258,-121.486,38.240002,
-121.48571,38.235905,-121.489395,
38.23307,-121.490608,38.227776,
-121.505325,38.22467,-121.503273,
38.212215,-121.508873,38.204662,
-121.512123,38.202488,-121.519623,
38.203014,-121.527832,38.195415,
-121.523392,38.1856,-121.526772,
38.181744,-121.523293,38.172401,
-121.528236,38.169106,-121.535088,
38.158241,-121.535248,38.151665,
-121.540291,38.151966,-121.542717,
38.147408,-121.546143,38.148159,
-121.558113,38.143967,-121.556625,
38.136833,-121.575279,38.129135,
-121.583008,38.120312,-121.582443,
38.113556,-121.566116,38.106323,
-121.562973,38.101505,-121.566116,
38.097404,-121.580231,38.094048,
-121.576202,38.078171,-121.572327,
38.073776,-121.582565,38.068233,
-121.582474,38.062767,-121.585754,
38.058632,-121.58577,38.03701,
-121.583847,38.033051,-121.579971,
38.032372,-121.582184,38.040184,
-121.580002,38.042538,-121.575546,
38.042442,-121.572327,38.03804,
-121.572937,38.030563,-121.566483,
38.030769,-121.5662,38.026501,
-121.559006,38.018715,-121.561363,
38.017059,-121.573051,38.019775,
-121.568222,38.013695,-121.577347,
38.01273,-121.58062,38.009872,
-121.578674,38.005363,-121.569778,
38.004246,-121.571251,38.000309,
-121.579704,37.999401,-121.576538,
37.996056,-121.581665,37.984428,
-121.572495,37.980026,-121.580154,
37.977715,-121.573288,37.972435,
-121.572754,37.966457,-121.565536,
37.961571,-121.575745,37.956963,
-121.564407,37.956688,-121.568909,
37.948631,-121.566483,37.947105,
-121.562439,37.949745,-121.560303,
37.948723,-121.564209,37.946144,
-121.562408,37.936577,-121.558578,
37.932953,-121.559738,37.927719,
-121.556396,37.924,-121.566757,
37.920273,-121.563461,37.912941,
-121.572174,37.906509,-121.567001,
37.900578,-121.567902,37.8951,
-121.570908,37.893101,-121.576111,
37.8909,-121.574051,37.885757,
-121.579803,37.87706,-121.578323,
37.871536,-121.573486,37.86734,
-121.57933,37.862595,-121.578316,
37.859749,-121.568497,37.862984,
-121.569832,37.860039,-121.566269,
37.860023,-121.561981,37.855301,
-121.559982,37.861519,-121.555817,
37.860527,-121.553253,37.863617,
-121.549194,37.857414,-121.541443,
37.859688,-121.541122,37.850365,
-121.537903,37.853222,-121.535049,
37.851501,-121.540787,37.843903,
-121.538544,37.843628,-121.539703,
37.840042,-121.544418,37.836105,
-121.548859,37.834908,-121.549866,
37.83699,-121.552788,37.83326,
-121.550339,37.824078,-121.555626,
37.820335,-121.555603,37.542801,
-121.5494,37.539398,-121.544701,
37.5326,-121.538597,37.5299,
-121.521103,37.524899,-121.503105,
37.526001,-121.497597,37.522701,
-121.500999,37.5186,-121.496506,
37.513302,-121.495003,37.505001,
-121.492302,37.502499,-121.484398,
37.502602,-121.468224,37.489758,
-121.470871,37.481853,-121.272705,
37.638401,-121.244102,37.664398,
-121.228905,37.6633,-121.228203,
37.668999,-121.220802,37.670399,
-121.220001,37.672501,-121.222107,
37.6838,-121.214706,37.688202,
-121.207306,37.686901,-121.2052,
37.694698,-121.200104,37.696301,
-121.198402,37.690498,-121.194702,
37.694801,-121.190399,37.690399,
-121.188026,37.691483,-121.185997,
37.687901,-121.179504,37.6884,
-121.181198,37.690601,-121.178101,
37.692902,-121.182602,37.693001,
-121.179306,37.694401,-121.181503,
37.698299,-121.175003,37.699501,
-121.178307,37.7024,-121.177399,
37.705601,-121.167702,37.699299,
-121.162598,37.7006,-121.165703,
37.702499,-121.163597,37.7047,
-121.158302,37.7047,-121.160797,
37.708,-121.158302,37.708599,
-121.157799,37.7173,-121.1558,
37.716702,-121.153503,37.720299,
-121.145203,37.718102,-121.140999,
37.722801,-121.137001,37.722401,
-121.135201,37.724701,-121.130707,
37.722198,-121.127403,37.7243,
-121.124397,37.722801,-121.122307,
37.724499,-121.1203,37.722,-121.1203,
37.7244,-121.115707,37.724201,
-121.115501,37.726398,-121.105103,
37.732601,-121.108398,37.734501,
-121.109001,37.742199,-121.105797,
37.7402,-121.1008,37.7411,
-121.099907,37.737499,-121.093803,
37.733398,-121.086906,37.741501,
-121.082199,37.741798,-121.076401,
37.737701,-121.069801,37.7384,
-121.065308,37.7411,-121.065598,
37.744999,-121.062103,37.743999,
-121.063507,37.7477,-121.060303,
37.7467,-121.059105,37.749599,
-121.053398,37.750702,-121.049904,
37.741901,-121.045403,37.742802,
-121.043701,37.7393,-121.040604,
37.741699,-121.037598,37.739399,
-121.035797,37.742699,-121.027702,
37.741001,-121.024704,37.742401,
-121.015198,37.756001,-121.010002,
37.7551,-121.013702,37.7533,
-121.011101,37.752998,-121.011307,
37.749599,-121.007103,37.749199,
-120.998199,37.753899,-120.997902,
37.757198,-120.991905,37.760899,
-120.952705,37.738701,-120.9412,
37.742401,-120.921906,37.737598,
-120.919701,37.7388,-120.922203,
37.757801,-120.925301,37.886799,
-120.9254,38.077499,-120.937798,
38.088402,-120.994469,38.225536,
-121.025185,38.298)),'SanJoaquin',
'06077','California','CA','06',1399.0175,480628,343.5466);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.348228,35.796112,-121.324966,
35.77401,-121.324966,35.75605,
-121.318985,35.745277,-121.311798,
35.70816,-121.287857,35.68182,
-121.284264,35.665058,-121.248344,
35.654285,-121.224403,35.650692,
-121.206444,35.639915,-121.194466,
35.636326,-121.175308,35.638721,
-121.160942,35.627945,-121.120239,
35.580055,-121.10228,35.547729,
-121.004105,35.459133,-120.978958,
35.456738,-120.949036,35.447159,
-120.90593,35.448357,-120.90229,
35.445171,-120.879593,35.423218,
-120.867615,35.399273,-120.864021,
35.376526,-120.864021,35.342999,
-120.866425,35.328632,-120.877197,
35.2999,-120.892761,35.274757,
-120.897552,35.256798,-120.891563,
35.242432,-120.872406,35.220879,
-120.854446,35.205315,-120.800575,
35.180172,-120.765846,35.159821,
-120.751488,35.157425,-120.751488,
35.176579,-120.737122,35.180172,
-120.717957,35.171791,-120.696419,
35.168201,-120.665283,35.15144,
-120.649719,35.146652,-120.636131,
35.126534,-120.631088,35.10952,
-120.628662,35.071907,-120.630943,
35.044647,-120.638985,35.002094,
-120.648796,34.974957,-120.648094,
34.974625,-120.633133,34.959583,
-120.615303,34.965973,-120.612137,
34.971294,-120.601013,34.972801,
-120.594498,34.966511,-120.584511,
34.967243,-120.574188,34.978317,
-120.55304,34.973621,-120.54351,
34.974571,-120.53421,34.984585,
-120.495224,34.993179,-120.437401,
34.9874,-120.364517,34.951305,
-120.352043,34.939308,-120.337944,
34.933056,-120.324089,34.922886,
-120.312843,34.903225,-120.298363,
34.907562,-120.299255,34.91547,
-120.292526,34.924831,-120.291359,
34.933266,-120.294212,34.948505,
-120.303001,34.956539,-120.300957,
34.963406,-120.314629,34.974953,
-120.31501,34.984028,-120.317978,
34.986076,-120.325264,34.985737,
-120.332932,34.995655,-120.333504,
35.001953,-120.328773,35.014771,
-120.320908,35.016285,-120.31192,
35.006008,-120.294449,35.015942,
-120.28479,35.014954,-120.277985,
35.010765,-120.279343,35.014473,
-120.277008,35.019093,-120.266182,
35.020576,-120.260406,35.026627,
-120.260338,35.021511,-120.2565,
35.017643,-120.25,35.029819,
-120.239853,35.022617,-120.208542,
35.021389,-120.209312,35.0238,
-120.204697,35.027431,-120.187401,
35.030403,-120.185585,35.036289,
-120.17952,35.038059,-120.183609,
35.049084,-120.178986,35.054417,
-120.178871,35.061558,-120.171219,
35.064323,-120.172913,35.070824,
-120.170273,35.070137,-120.165627,
35.075535,-120.154404,35.078213,
-120.154427,35.081577,-120.149002,
35.081402,-120.147743,35.084389,
-120.141815,35.082188,-120.139671,
35.086697,-120.143211,35.086838,
-120.14415,35.08931,-120.139259,
35.090557,-120.142059,35.095619,
-120.137093,35.094509,-120.134453,
35.097816,-120.128693,35.096027,
-120.129425,35.091743,-120.127121,
35.090908,-120.123161,35.099625,
-120.118355,35.09848,-120.115768,
35.106609,-120.107834,35.103703,
-120.107079,35.108898,-120.101303,
35.108471,-120.101265,35.113113,
-120.098557,35.112862,-120.096939,
35.109528,-120.094635,35.112633,
-120.079964,35.114513,-120.078255,
35.112774,-120.084587,35.10952,
-120.083549,35.107323,-120.079758,
35.104919,-120.071442,35.104736,
-120.066338,35.096779,-120.047508,
35.089912,-120.043053,35.086021,
-120.038322,35.089123,-120.031837,
35.087845,-120.028343,35.083595,
-120.023102,35.084068,-120.022415,
35.080364,-120.017288,35.082382,
-120.013077,35.081474,-120.012619,
35.0756,-120.004623,35.071815,
-120.001045,35.073231,-119.991585,
35.062958,-119.987587,35.064953,
-119.984032,35.061569,-119.978691,
35.06189,-119.979149,35.057598,
-119.976906,35.059502,-119.965973,
35.056343,-119.964058,35.058853,
-119.959717,35.055737,-119.954819,
35.057205,-119.9533,35.054611,
-119.951241,35.057369,-119.947792,
35.057205,-119.948006,35.055347,
-119.94175,35.054462,-119.93895,
35.058037,-119.93689,35.05711,
-119.938202,35.054993,-119.930641,
35.05637,-119.927444,35.059818,
-119.920822,35.052567,-119.917389,
35.053169,-119.916336,35.049004,
-119.908463,35.045979,-119.911125,
35.04472,-119.907707,35.042709,
-119.909279,35.039593,-119.900978,
35.038307,-119.901001,35.03582,
-119.88868,35.040657,-119.877304,
35.039745,-119.874123,35.035717,
-119.865028,35.035107,-119.862358,
35.031452,-119.853554,35.032177,
-119.847008,35.025444,-119.843201,
35.015499,-119.829857,35.005802,
-119.812202,35.000694,-119.808983,
35.002121,-119.80291,34.997635,
-119.800056,34.998882,-119.798035,
34.993271,-119.794342,34.991142,
-119.78624,34.988194,-119.779434,
34.990753,-119.762894,34.982109,
-119.754066,34.980022,-119.744598,
34.973701,-119.726051,34.976158,
-119.717598,34.9715,-119.6996,
34.9767,-119.683601,34.972095,
-119.672203,34.973499,-119.65432,
34.963829,-119.643303,34.953602,
-119.633904,34.953899,-119.623802,
34.9492,-119.612396,34.949699,
-119.591507,34.935101,-119.578903,
34.922798,-119.535599,34.898102,
-119.489502,34.897499,-119.489403,
34.901199,-119.471802,34.901199,
-119.471771,35.076916,-119.489754,
35.07724,-119.489677,35.091835,
-119.560013,35.087704,-119.552689,
35.180008,-119.6661,35.174839,
-119.665703,35.262566,-119.808487,
35.263615,-119.808388,35.350899,
-119.879211,35.351246,-119.879082,
35.439167,-119.996422,35.439529,
-119.996407,35.468735,-120.014687,
35.46907,-120.013634,35.483688,
-120.032333,35.483685,-120.032265,
35.498676,-120.050072,35.498661,
-120.050262,35.51273,-120.067924,
35.512814,-120.06768,35.526356,
-120.085693,35.526588,-120.084946,
35.614559,-120.19294,35.614391,
-120.193169,35.789242,-120.212997,
35.78931,-120.863281,35.791767,
-121.348228,35.796112)),
'SanLuisObispo','06079','California','CA','06',3303.9316,217162,65.7282);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.502487,37.707222,-122.492439,
37.643528,-122.498611,37.605766,
-122.504776,37.597294,-122.511711,
37.598061,-122.517105,37.594208,
-122.519417,37.537952,-122.517876,
37.524853,-122.498611,37.495567,
-122.491669,37.493256,-122.490128,
37.496342,-122.481659,37.499424,
-122.471642,37.500191,-122.450829,
37.480156,-122.446205,37.465515,
-122.44313,37.433922,-122.430023,
37.412346,-122.399971,37.350693,
-122.408447,37.279797,-122.417603,
37.240974,-122.406609,37.220665,
-122.40387,37.196167,-122.393867,
37.181786,-122.385628,37.183361,
-122.378441,37.181091,-122.365799,
37.172215,-122.35981,37.158573,
-122.358902,37.149403,-122.341919,
37.140453,-122.336143,37.134327,
-122.338318,37.120953,-122.336182,
37.117706,-122.328499,37.112522,
-122.31282,37.118214,-122.303207,
37.115276,-122.292175,37.106895,
-122.288307,37.113499,-122.310707,
37.147598,-122.316597,37.187,
-122.287506,37.186798,-122.267799,
37.189899,-122.241585,37.19009,
-122.241493,37.215191,-122.151703,
37.2155,-122.151413,37.2864,
-122.157349,37.293137,-122.165756,
37.295296,-122.160995,37.304291,
-122.165512,37.305672,-122.169739,
37.312035,-122.175781,37.312737,
-122.181252,37.309589,-122.185516,
37.315605,-122.191986,37.318336,
-122.184387,37.323795,-122.181961,
37.327374,-122.174004,37.325802,
-122.193893,37.347015,-122.201401,
37.363499,-122.198227,37.37431,
-122.1894,37.384899,-122.189026,
37.39407,-122.193405,37.407837,
-122.192001,37.412601,-122.186104,
37.416302,-122.189224,37.418201,
-122.186798,37.419601,-122.190216,
37.425133,-122.189507,37.431099,
-122.161552,37.453911,-122.154663,
37.454155,-122.151398,37.457802,
-122.146027,37.456642,-122.142159,
37.45826,-122.134323,37.453957,
-122.122757,37.452812,-122.120438,
37.455078,-122.122208,37.460869,
-122.112198,37.467602,-122.095352,
37.466164,-122.095688,37.461967,
-122.080399,37.477901,-122.108505,
37.4977,-122.117516,37.508755,
-122.130562,37.505001,-122.138763,
37.507607,-122.154793,37.500523,
-122.174545,37.509472,-122.191322,
37.52177,-122.195427,37.536682,
-122.215927,37.541531,-122.243134,
37.557186,-122.252831,37.567623,
-122.262894,37.572472,-122.300171,
37.576199,-122.310242,37.579182,
-122.313965,37.591106,-122.359444,
37.591484,-122.363922,37.597446,
-122.353477,37.615341,-122.363167,
37.619812,-122.379578,37.635098,
-122.378456,37.6474,-122.374352,
37.655228,-122.379578,37.677593,
-122.387779,37.685425,-122.391502,
37.707813,-122.502487,37.707222)),
'SanMateo','06081','California','CA','06',449.0314,649623,1446.7197);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2007,8265,null,
MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,59,1003,1,137,1003,1,
211,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.294724,34.021683,-120.307388,
34.027729,-120.315384,34.040009,
-120.330002,34.049171,-120.348915,
34.047028,-120.357498,34.050144,
-120.359642,34.05463,-120.354179,
34.059891,-120.360809,34.073734,
-120.36763,34.076855,-120.367432,
34.069252,-120.371338,34.064571,
-120.395119,34.050144,-120.408768,
34.052292,-120.413055,34.055996,
-120.427483,34.048195,-120.436836,
34.038841,-120.440544,34.036888,
-120.447571,34.037472,-120.451462,
34.02948,-120.436462,34.029053,
-120.426315,34.025387,-120.41832,
34.027729,-120.41539,34.031624,
-120.406815,34.031818,-120.35788,
34.013885,-120.348328,34.020123,
-120.319283,34.01915,-120.294724,
34.021683,-120.108627,33.895073,
-120.101646,33.904953,-120.08828,
33.909019,-120.048164,33.915417,
-120.019676,33.934021,-120.00457,
33.940411,-119.99469,33.942158,
-119.966782,33.941574,-119.969101,
33.952042,-119.974922,33.956108,
-119.978409,33.974712,-119.976662,
33.98111,-119.980736,33.985176,-120,
33.98032,-120.02375,33.985176,
-120.04351,33.997383,-120.048164,
34.016567,-120.042351,34.027611,
-120.042938,34.035751,-120.052818,
34.038074,-120.08828,34.020058,
-120.108627,34.020638,-120.143501,
34.026447,-120.158043,34.014244,
-120.173149,34.007847,-120.195824,
34.005524,-120.229546,34.00959,
-120.239426,34.007847,-120.248718,
34.001453,-120.246399,33.997383,
-120.237099,33.991573,-120.223145,
33.988083,-120.217339,33.977036,
-120.19059,33.947971,-120.176643,
33.924717,-120.166763,33.915997,
-120.134781,33.90263,-120.118507,
33.89333,-120.108627,33.895073,
-119.721466,33.959015,-119.675537,
33.977619,-119.658684,33.986919,
-119.603455,33.988663,-119.560432,
33.994476,-119.545319,34.007267,
-119.538345,34.021217,-119.525551,
34.027031,-119.519157,34.034588,
-119.530205,34.042728,-119.562759,
34.056095,-119.584274,34.053772,
-119.605202,34.040401,-119.607521,
34.036331,-119.607521,34.025867,
-119.616241,34.018311,-119.637749,
34.015404,-119.65345,34.01947,
-119.676697,34.020058,-119.714485,
34.043888,-119.758667,34.058426,
-119.797615,34.057259,-119.809822,
34.052608,-119.83831,34.065399,
-119.856911,34.071213,-119.917366,
34.077023,-119.928993,34.059586,
-119.905746,34.054352,-119.876099,
34.031101,-119.876099,34.022381,
-119.886559,34.008427,-119.88279,34,
-119.873772,33.980522,-119.84877,
33.965992,-119.816803,33.960758,
-119.753433,33.962505,-119.721466,
33.959015,-119.471802,34.901199,
-119.489403,34.901199,-119.489502,
34.897499,-119.535599,34.898102,
-119.578903,34.922798,-119.591507,
34.935101,-119.612396,34.949699,
-119.623802,34.9492,-119.633904,
34.953899,-119.643303,34.953602,
-119.65432,34.963829,-119.672203,
34.973499,-119.683601,34.972095,
-119.6996,34.9767,-119.717598,
34.9715,-119.726051,34.976158,
-119.744598,34.973701,-119.754066,
34.980022,-119.762894,34.982109,
-119.779434,34.990753,-119.78624,
34.988194,-119.794342,34.991142,
-119.798035,34.993271,-119.800056,
34.998882,-119.80291,34.997635,
-119.808983,35.002121,-119.812202,
35.000694,-119.829857,35.005802,
-119.843201,35.015499,-119.847008,
35.025444,-119.853554,35.032177,
-119.862358,35.031452,-119.865028,
35.035107,-119.874123,35.035717,
-119.877304,35.039745,-119.88868,
35.040657,-119.901001,35.03582,
-119.900978,35.038307,-119.909279,
35.039593,-119.907707,35.042709,
-119.911125,35.04472,-119.908463,
35.045979,-119.916336,35.049004,
-119.917389,35.053169,-119.920822,
35.052567,-119.927444,35.059818,
-119.930641,35.05637,-119.938202,
35.054993,-119.93689,35.05711,
-119.93895,35.058037,-119.94175,
35.054462,-119.948006,35.055347,
-119.947792,35.057205,-119.951241,
35.057369,-119.9533,35.054611,
-119.954819,35.057205,-119.959717,
35.055737,-119.964058,35.058853,
-119.965973,35.056343,-119.976906,
35.059502,-119.979149,35.057598,
-119.978691,35.06189,-119.984032,
35.061569,-119.987587,35.064953,
-119.991585,35.062958,-120.001045,
35.073231,-120.004623,35.071815,
-120.012619,35.0756,-120.013077,
35.081474,-120.017288,35.082382,
-120.022415,35.080364,-120.023102,
35.084068,-120.028343,35.083595,
-120.031837,35.087845,-120.038322,
35.089123,-120.043053,35.086021,
-120.047508,35.089912,-120.066338,
35.096779,-120.071442,35.104736,
-120.079758,35.104919,-120.083549,
35.107323,-120.084587,35.10952,
-120.078255,35.112774,-120.079964,
35.114513,-120.094635,35.112633,
-120.096939,35.109528,-120.098557,
35.112862,-120.101265,35.113113,
-120.101303,35.108471,-120.107079,
35.108898,-120.107834,35.103703,
-120.115768,35.106609,-120.118355,
35.09848,-120.123161,35.099625,
-120.127121,35.090908,-120.129425,
35.091743,-120.128693,35.096027,
-120.134453,35.097816,-120.137093,
35.094509,-120.142059,35.095619,
-120.139259,35.090557,-120.14415,
35.08931,-120.143211,35.086838,
-120.139671,35.086697,-120.141815,
35.082188,-120.147743,35.084389,
-120.149002,35.081402,-120.154427,
35.081577,-120.154404,35.078213,
-120.165627,35.075535,-120.170273,
35.070137,-120.172913,35.070824,
-120.171219,35.064323,-120.178871,
35.061558,-120.178986,35.054417,
-120.183609,35.049084,-120.17952,
35.038059,-120.185585,35.036289,
-120.187401,35.030403,-120.204697,
35.027431,-120.209312,35.0238,
-120.208542,35.021389,-120.239853,
35.022617,-120.25,35.029819,
-120.2565,35.017643,-120.260338,
35.021511,-120.260406,35.026627,
-120.266182,35.020576,-120.277008,
35.019093,-120.279343,35.014473,
-120.277985,35.010765,-120.28479,
35.014954,-120.294449,35.015942,
-120.31192,35.006008,-120.320908,
35.016285,-120.328773,35.014771,
-120.333504,35.001953,-120.332932,
34.995655,-120.325264,34.985737,
-120.317978,34.986076,-120.31501,
34.984028,-120.314629,34.974953,
-120.300957,34.963406,-120.303001,
34.956539,-120.294212,34.948505,
-120.291359,34.933266,-120.292526,
34.924831,-120.299255,34.91547,
-120.298363,34.907562,-120.312843,
34.903225,-120.324089,34.922886,
-120.337944,34.933056,-120.352043,
34.939308,-120.364517,34.951305,
-120.437401,34.9874,-120.495224,
34.993179,-120.53421,34.984585,
-120.54351,34.974571,-120.55304,
34.973621,-120.574188,34.978317,
-120.584511,34.967243,-120.594498,
34.966511,-120.601013,34.972801,
-120.612137,34.971294,-120.615303,
34.965973,-120.633133,34.959583,
-120.648094,34.974625,-120.648796,
34.974957,-120.664551,34.931347,
-120.670227,34.901569,-120.656036,
34.897316,-120.637611,34.87746,
-120.613503,34.863281,-120.607826,
34.844845,-120.62059,34.795212,
-120.637611,34.755508,-120.626266,
34.737072,-120.603577,34.710129,
-120.600739,34.694527,-120.610664,
34.663334,-120.641861,34.599518,
-120.646118,34.576828,-120.636192,
34.559811,-120.614922,34.5513,
-120.580887,34.555557,-120.553947,
34.539955,-120.509979,34.522942,
-120.491547,34.490322,-120.475945,
34.473309,-120.470268,34.447781,
-120.451843,34.440693,-120.419228,
34.450615,-120.334137,34.461964,
-120.220688,34.471889,-120.141281,
34.471889,-120.090225,34.459129,
-119.995216,34.456291,-119.973946,
34.446365,-119.952675,34.432182,
-119.928566,34.433601,-119.87468,
34.406654,-119.840637,34.40382,
-119.836395,34.41375,-119.782501,
34.415165,-119.731445,34.395313,
-119.704506,34.395313,-119.690331,
34.402405,-119.677559,34.41375,
-119.643532,34.415165,-119.612328,
34.419418,-119.579712,34.412327,
-119.4757,34.373199,-119.476707,
34.379799,-119.472397,34.379299,
-119.467506,34.388599,-119.450706,
34.396999,-119.444824,34.404266,
-119.444397,34.408901,-119.453415,
34.418472,-119.453552,34.421707,
-119.452057,34.428947,-119.444046,
34.429489,-119.439423,34.44199,
-119.442307,34.449524,-119.440521,
34.451828,-119.441399,34.901299,
-119.471802,34.901199)),
'SantaBarbara','06083','California','CA','06',2737.998,369608,134.9919);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.080399,37.477901,-122.095688,
37.461967,-122.095352,37.466164,
-122.112198,37.467602,-122.122208,
37.460869,-122.120438,37.455078,
-122.122757,37.452812,-122.134323,
37.453957,-122.142159,37.45826,
-122.146027,37.456642,-122.151398,
37.457802,-122.154663,37.454155,
-122.161552,37.453911,-122.189507,
37.431099,-122.190216,37.425133,
-122.186798,37.419601,-122.189224,
37.418201,-122.186104,37.416302,
-122.192001,37.412601,-122.193405,
37.407837,-122.189026,37.39407,
-122.1894,37.384899,-122.198227,
37.37431,-122.201401,37.363499,
-122.193893,37.347015,-122.174004,
37.325802,-122.181961,37.327374,
-122.184387,37.323795,-122.191986,
37.318336,-122.185516,37.315605,
-122.181252,37.309589,-122.175781,
37.312737,-122.169739,37.312035,
-122.165512,37.305672,-122.160995,
37.304291,-122.165756,37.295296,
-122.157349,37.293137,-122.151413,
37.2864,-122.147903,37.281601,
-122.148674,37.275597,-122.146599,
37.2747,-122.131401,37.2617,
-122.119904,37.258701,-122.104507,
37.240799,-122.102905,37.23431,
-122.0923,37.229301,-122.088501,
37.223099,-122.077744,37.223274,
-122.065102,37.210499,-122.054253,
37.212521,-122.039703,37.195202,
-122.029701,37.1898,-122.031998,
37.186199,-122.030807,37.180603,
-122.025467,37.176163,-122.026588,
37.174122,-122.024399,37.174133,
-122.026604,37.170898,-122.024895,
37.166111,-122.01683,37.164532,
-122.015327,37.165962,-122.011902,
37.161541,-121.999443,37.159172,
-121.990944,37.14407,-121.984657,
37.144207,-121.980797,37.140999,
-121.971138,37.141281,-121.955322,
37.129662,-121.923683,37.121792,
-121.909683,37.11359,-121.904877,
37.113194,-121.902687,37.110062,
-121.901695,37.11219,-121.894714,
37.110577,-121.888855,37.104694,
-121.883774,37.107891,-121.869003,
37.102299,-121.858948,37.104229,
-121.86071,37.099613,-121.847984,
37.099358,-121.836578,37.091248,
-121.83213,37.091019,-121.830673,
37.088295,-121.821175,37.088211,
-121.814224,37.081421,-121.815552,
37.077576,-121.81031,37.07291,
-121.809219,37.06992,-121.784103,
37.060947,-121.770905,37.052898,
-121.763702,37.052601,-121.762001,
37.048401,-121.754799,37.049198,
-121.738182,37.027092,-121.725105,
37.021,-121.7174,37.013802,
-121.721596,37.008976,-121.717705,
37.007607,-121.728569,36.997925,
-121.728699,36.993576,-121.737396,
36.990002,-121.733559,36.989353,
-121.71682,36.995613,-121.709801,
36.993,-121.709641,36.989777,
-121.704445,36.98941,-121.704185,
36.986298,-121.694305,36.985199,
-121.69677,36.972149,-121.689102,
36.9674,-121.6772,36.967899,
-121.676178,36.965595,-121.663727,
36.963764,-121.662201,36.9519,
-121.652504,36.950401,-121.652,
36.941799,-121.644737,36.932381,
-121.639969,36.932274,-121.641197,
36.936401,-121.636002,36.939098,
-121.629402,36.940601,-121.622902,
36.937698,-121.623703,36.940498,
-121.606102,36.926102,-121.589302,
36.926201,-121.589104,36.9193,
-121.580101,36.9193,-121.580391,
36.900604,-121.57399,36.894203,
-121.568321,36.898235,-121.559402,
36.897701,-121.557198,36.911201,
-121.539505,36.9203,-121.539505,
36.9254,-121.512703,36.945099,
-121.5093,36.953602,-121.511307,
36.958801,-121.487907,36.9832,
-121.466888,36.976826,-121.462509,
36.978348,-121.464905,36.982201,
-121.461998,36.9856,-121.449203,
36.9888,-121.446297,36.983009,
-121.435707,36.9781,-121.417198,
36.960602,-121.214371,36.9613,
-121.223061,36.967484,-121.231087,
36.968945,-121.245529,36.985279,
-121.240479,36.997437,-121.232101,
36.999401,-121.237152,37.009308,
-121.232307,37.011799,-121.244949,
37.025631,-121.247604,37.033737,
-121.239601,37.031834,-121.235107,
37.036999,-121.223473,37.039799,
-121.22348,37.056293,-121.217697,
37.057198,-121.211555,37.055122,
-121.207161,37.061344,-121.208603,
37.068298,-121.221367,37.073486,
-121.223602,37.078999,-121.234459,
37.086292,-121.240936,37.085182,
-121.244446,37.089203,-121.241577,
37.093121,-121.229401,37.097,
-121.229874,37.104591,-121.224503,
37.106899,-121.22583,37.110844,
-121.216301,37.1231,-121.220711,
37.125965,-121.221672,37.130562,
-121.222099,37.131687,-121.22419,
37.133526,-121.225693,37.134895,
-121.231255,37.139954,-121.236069,
37.157265,-121.261055,37.159386,
-121.280067,37.183662,-121.289917,
37.175488,-121.290482,37.170395,
-121.297508,37.166023,-121.301575,
37.168221,-121.305,37.166698,
-121.311836,37.170208,-121.312988,
37.167973,-121.32737,37.166012,
-121.331062,37.171047,-121.341339,
37.174252,-121.347656,37.181179,
-121.359894,37.18438,-121.383224,
37.16626,-121.380585,37.157196,
-121.382507,37.151546,-121.390091,
37.150806,-121.391945,37.148212,
-121.39798,37.150192,-121.405487,
37.158897,-121.406677,37.169064,
-121.412354,37.172386,-121.40786,
37.180901,-121.410477,37.185467,
-121.409271,37.191322,-121.414604,
37.199707,-121.415825,37.211323,
-121.420021,37.21489,-121.421165,
37.221996,-121.440697,37.23119,
-121.447693,37.237339,-121.454704,
37.2495,-121.456207,37.261005,
-121.453796,37.263203,-121.452919,
37.277248,-121.458,37.282799,
-121.452957,37.284111,-121.447609,
37.290363,-121.448601,37.293999,
-121.442505,37.2967,-121.435768,
37.292034,-121.430344,37.295055,
-121.422401,37.295353,-121.41732,
37.303341,-121.404701,37.31105,
-121.410889,37.324509,-121.408104,
37.3307,-121.419701,37.344799,
-121.418358,37.352051,-121.4226,
37.358898,-121.414803,37.37598,
-121.408028,37.380737,-121.411507,
37.3895,-121.422997,37.3937,
-121.435036,37.396194,-121.447113,
37.391743,-121.455597,37.395599,
-121.455307,37.406799,-121.47155,
37.423412,-121.467812,37.42506,
-121.469276,37.430187,-121.460808,
37.438866,-121.461861,37.451557,
-121.463638,37.454552,-121.466125,
37.453407,-121.471626,37.456448,
-121.473984,37.46212,-121.4832,
37.466099,-121.485718,37.475719,
-121.482361,37.475491,-121.476646,
37.480347,-121.473473,37.479412,
-121.471603,37.482235,-121.864197,
37.484699,-121.879211,37.471657,
-121.887955,37.470749,-121.889587,
37.468307,-121.907722,37.463089,
-121.924187,37.454601,-121.927376,
37.457455,-121.931694,37.455605,
-121.93013,37.460709,-121.942505,
37.465477,-121.943802,37.469601,
-121.945999,37.4688,-121.945702,
37.4636,-121.9505,37.462898,
-121.958199,37.4646,-121.978943,
37.460953,-121.995598,37.4673,
-122.03511,37.465027,-122.050171,
37.459068,-122.080399,37.477901)),
'SantaClara','06085','California','CA','06',1290.998,1497577,1160.0136);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.292175,37.106895,-122.280602,
37.098099,-122.266998,37.080032,
-122.221893,37.0252,-122.205101,
37.014,-122.198601,37.012501,
-122.152107,36.9762,-122.142105,
36.976501,-122.127899,36.966301,
-122.104897,36.956001,-122.075203,
36.9505,-122.025101,36.950298,
-122.022301,36.9622,-121.984589,
36.960503,-121.972496,36.954498,
-121.9506,36.9715,-121.938896,
36.977402,-121.928001,36.977299,
-121.904495,36.9688,-121.879105,
36.950199,-121.863998,36.934399,
-121.808922,36.850853,-121.799438,
36.857925,-121.80191,36.868973,
-121.78595,36.884865,-121.78299,
36.886055,-121.775131,36.883289,
-121.768021,36.885223,-121.767975,
36.889317,-121.760864,36.88879,
-121.762939,36.891598,-121.74501,
36.909081,-121.733673,36.908775,
-121.726852,36.911575,-121.725143,
36.914543,-121.713791,36.908894,
-121.709198,36.914902,-121.703018,
36.913124,-121.698105,36.915901,
-121.705734,36.911243,-121.704475,
36.90955,-121.701263,36.908222,
-121.696381,36.911655,-121.685242,
36.907902,-121.679398,36.903198,
-121.665176,36.912796,-121.655334,
36.914158,-121.650635,36.909973,
-121.651489,36.902016,-121.648285,
36.900459,-121.644791,36.902611,
-121.642799,36.8941,-121.636955,
36.898415,-121.628426,36.911736,
-121.618797,36.908901,-121.6063,
36.899502,-121.587799,36.901299,
-121.580307,36.8992,-121.580391,
36.900604,-121.580101,36.9193,
-121.589104,36.9193,-121.589302,
36.926201,-121.606102,36.926102,
-121.623703,36.940498,-121.622902,
36.937698,-121.629402,36.940601,
-121.636002,36.939098,-121.641197,
36.936401,-121.639969,36.932274,
-121.644737,36.932381,-121.652,
36.941799,-121.652504,36.950401,
-121.662201,36.9519,-121.663727,
36.963764,-121.676178,36.965595,
-121.6772,36.967899,-121.689102,
36.9674,-121.69677,36.972149,
-121.694305,36.985199,-121.704185,
36.986298,-121.704445,36.98941,
-121.709641,36.989777,-121.709801,
36.993,-121.71682,36.995613,
-121.733559,36.989353,-121.737396,
36.990002,-121.728699,36.993576,
-121.728569,36.997925,-121.717705,
37.007607,-121.721596,37.008976,
-121.7174,37.013802,-121.725105,
37.021,-121.738182,37.027092,
-121.754799,37.049198,-121.762001,
37.048401,-121.763702,37.052601,
-121.770905,37.052898,-121.784103,
37.060947,-121.809219,37.06992,
-121.81031,37.07291,-121.815552,
37.077576,-121.814224,37.081421,
-121.821175,37.088211,-121.830673,
37.088295,-121.83213,37.091019,
-121.836578,37.091248,-121.847984,
37.099358,-121.86071,37.099613,
-121.858948,37.104229,-121.869003,
37.102299,-121.883774,37.107891,
-121.888855,37.104694,-121.894714,
37.110577,-121.901695,37.11219,
-121.902687,37.110062,-121.904877,
37.113194,-121.909683,37.11359,
-121.923683,37.121792,-121.955322,
37.129662,-121.971138,37.141281,
-121.980797,37.140999,-121.984657,
37.144207,-121.990944,37.14407,
-121.999443,37.159172,-122.011902,
37.161541,-122.015327,37.165962,
-122.01683,37.164532,-122.024895,
37.166111,-122.026604,37.170898,
-122.024399,37.174133,-122.026588,
37.174122,-122.025467,37.176163,
-122.030807,37.180603,-122.031998,
37.186199,-122.029701,37.1898,
-122.039703,37.195202,-122.054253,
37.212521,-122.065102,37.210499,
-122.077744,37.223274,-122.088501,
37.223099,-122.0923,37.229301,
-122.102905,37.23431,-122.104507,
37.240799,-122.119904,37.258701,
-122.131401,37.2617,-122.146599,
37.2747,-122.148674,37.275597,
-122.147903,37.281601,-122.151413,
37.2864,-122.151703,37.2155,
-122.241493,37.215191,-122.241585,
37.19009,-122.267799,37.189899,
-122.287506,37.186798,-122.316597,
37.187,-122.310707,37.147598,
-122.288307,37.113499,-122.292175,
37.106895)),'SantaCruz','06087',
'California','CA','06',445.5971,229734,515.5639);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.445396,41.183601,-122.125,
41.18309,-122.310997,41.185013,
-122.497246,41.182804,-122.497627,
41.179714,-122.491417,41.176102,
-122.474815,41.176647,-122.467163,
41.169365,-122.461838,41.167362,
-122.456314,41.168453,-122.448769,
41.159286,-122.444893,41.15937,
-122.449478,41.147064,-122.444862,
41.133476,-122.447197,41.130833,
-122.447449,41.118366,-122.452347,
41.113621,-122.450737,41.10836,
-122.456017,41.096741,-122.46701,
41.09697,-122.492172,41.086117,
-122.498886,41.087757,-122.505104,
41.086178,-122.51223,41.088356,
-122.527702,41.076881,-122.534737,
41.076,-122.538651,41.072735,
-122.536819,41.065174,-122.526489,
41.064342,-122.522041,41.059341,
-122.521233,41.052418,-122.526207,
41.045856,-122.527802,41.036644,
-122.526627,41.014523,-122.536751,
41.002518,-122.54409,41.005196,
-122.553329,41.003738,-122.554298,
40.999603,-122.561897,40.993816,
-122.562744,40.988781,-122.568054,
40.985126,-122.579651,40.983036,
-122.588066,40.985508,-122.590225,
40.97686,-122.593758,40.978073,
-122.60041,40.971668,-122.59996,
40.963993,-122.606354,40.955742,
-122.602089,40.940739,-122.60601,
40.938129,-122.6063,40.929855,
-122.611626,40.921375,-122.598885,
40.900475,-122.603806,40.897331,
-122.606422,40.88715,-122.613777,
40.88131,-122.623909,40.879826,
-122.625313,40.86721,-122.633247,
40.861423,-122.633545,40.857189,
-122.637756,40.853539,-122.638397,
40.845379,-122.654259,40.841686,
-122.656082,40.835533,-122.664917,
40.826008,-122.654114,40.808311,
-122.656326,40.802078,-122.660225,
40.800613,-122.657074,40.787689,
-122.664742,40.781944,-122.669365,
40.772926,-122.691704,40.760857,
-122.699348,40.759029,-122.699181,
40.755527,-122.70517,40.749687,
-122.71627,40.747314,-122.718719,
40.73951,-122.710991,40.73127,
-122.705627,40.724735,-122.710258,
40.710823,-122.71769,40.70797,
-122.721214,40.695618,-122.728767,
40.692379,-122.742767,40.69516,
-122.751137,40.689789,-122.750275,
40.685207,-122.74144,40.678932,
-122.740089,40.665527,-122.732445,
40.662556,-122.73262,40.657104,
-122.725883,40.650585,-122.734291,
40.639919,-122.733032,40.635471,
-122.71579,40.634563,-122.708527,
40.631329,-122.709717,40.613338,
-122.70504,40.61039,-122.705757,
40.605591,-122.70005,40.595947,
-122.69899,40.585873,-122.691734,
40.580605,-122.694168,40.572643,
-122.697662,40.569424,-122.706741,
40.569805,-122.721931,40.575329,
-122.740181,40.564255,-122.742798,
40.553902,-122.758118,40.556667,
-122.76635,40.55526,-122.784065,
40.541046,-122.784546,40.536667,
-122.781097,40.532001,-122.792488,
40.523563,-122.792122,40.514648,
-122.802986,40.510643,-122.81765,
40.511192,-122.82766,40.50713,
-122.844826,40.505314,-122.850952,
40.501083,-122.845322,40.493652,
-122.849991,40.485954,-122.856125,
40.482468,-122.875648,40.480412,
-122.884132,40.471016,-122.889015,
40.468952,-122.888153,40.465885,
-122.894234,40.459835,-122.895798,
40.450188,-122.900719,40.445408,
-122.905937,40.446396,-122.91658,
40.449905,-122.930168,40.44569,
-122.929527,40.442146,-122.936668,
40.437042,-122.937485,40.428989,
-122.953094,40.421635,-122.956657,
40.421524,-122.959869,40.426128,
-122.973793,40.419743,-122.997551,
40.41827,-122.998642,40.403694,
-122.995453,40.396511,-123.015266,
40.385723,-123.017166,40.372536,
-123.030006,40.363735,-123.036018,
40.364567,-123.038155,40.362858,
-123.043037,40.353863,-123.042839,
40.347145,-123.051941,40.346794,
-123.055756,40.349377,-123.064354,
40.345226,-123.062851,40.337635,
-123.067657,40.332363,-123.061562,
40.322178,-123.063454,40.32,
-123.060616,40.313572,-123.067703,
40.308384,-123.064026,40.298901,
-123.064339,40.287022,-123.055534,
40.285503,-123.046631,40.291851,
-123.040413,40.290821,-123.023376,
40.304001,-123.013664,40.302986,
-123.011032,40.306305,-122.995491,
40.308567,-122.976448,40.315052,
-122.969513,40.310661,-122.950592,
40.310345,-122.947838,40.308006,
-122.941208,40.312355,-122.93367,
40.313408,-122.928864,40.30785,
-122.917381,40.307049,-122.915527,
40.310684,-122.908417,40.313156,
-122.906052,40.318077,-122.902824,
40.316265,-122.901711,40.321983,
-122.876999,40.346691,-122.86409,
40.348183,-122.861641,40.345139,
-122.852814,40.34322,-122.838196,
40.345493,-122.835167,40.348557,
-122.82814,40.350117,-122.821861,
40.349495,-122.811478,40.351353,
-122.805473,40.355793,-122.786896,
40.355511,-122.761375,40.363239,
-122.752045,40.360374,-122.750359,
40.364426,-122.74099,40.365276,
-122.72908,40.358528,-122.730568,
40.347271,-122.710976,40.348446,
-122.687561,40.33746,-122.676132,
40.336384,-122.672607,40.33057,
-122.662323,40.332333,-122.650215,
40.328415,-122.644798,40.333313,
-122.633324,40.333923,-122.631348,
40.338661,-122.620781,40.340511,
-122.624046,40.347584,-122.609032,
40.346535,-122.595825,40.357365,
-122.584724,40.359406,-122.580185,
40.367458,-122.562859,40.365719,
-122.54953,40.375,-122.549484,
40.378502,-122.540535,40.376644,
-122.539818,40.382549,-122.531082,
40.37994,-122.529739,40.384289,
-122.520905,40.387966,-122.524857,
40.393208,-122.523445,40.394604,
-122.518867,40.393803,-122.512703,
40.388512,-122.503906,40.389542,
-122.499023,40.382603,-122.488731,
40.383778,-122.481575,40.380646,
-122.477211,40.384583,-122.468353,
40.383759,-122.461464,40.375591,
-122.451797,40.378639,-122.443901,
40.373524,-122.439796,40.373322,
-122.427742,40.375641,-122.421227,
40.379372,-122.415565,40.379417,
-122.411469,40.374664,-122.394653,
40.372211,-122.387627,40.374405,
-122.378746,40.372066,-122.36274,
40.37429,-122.341042,40.371029,
-122.335831,40.374298,-122.328896,
40.372883,-122.319923,40.375,
-122.309296,40.371189,-122.298317,
40.375622,-122.293022,40.380608,
-122.279739,40.375912,-122.263283,
40.379913,-122.255867,40.379498,
-122.250702,40.387341,-122.234421,
40.385521,-122.226051,40.389435,
-122.198288,40.377968,-122.192451,
40.392437,-122.191002,40.386147,
-122.186218,40.381523,-122.180832,
40.379036,-122.172035,40.379135,
-122.179214,40.384773,-122.186722,
40.385529,-122.182747,40.392258,
-122.16227,40.393234,-122.15892,
40.396919,-122.148178,40.398293,
-122.132523,40.397667,-122.127975,
40.399128,-122.127846,40.403931,
-122.120026,40.403522,-122.116974,
40.406727,-122.110931,40.405174,
-122.098213,40.414837,-122.097519,
40.410469,-122.094475,40.410007,
-122.09079,40.414406,-122.089951,
40.410721,-122.056129,40.416672,
-122.05101,40.420517,-122.043129,
40.418457,-122.034271,40.419758,
-122.029633,40.417492,-122.029121,
40.42115,-122.021095,40.424217,
-122.013824,40.421101,-122.008881,
40.42691,-121.998543,40.423199,
-121.992828,40.425861,-121.983368,
40.423023,-121.975403,40.421219,
-121.965942,40.422207,-121.940315,
40.415596,-121.92601,40.418503,
-121.913338,40.426254,-121.909752,
40.423119,-121.899719,40.421265,
-121.894241,40.427212,-121.888039,
40.428352,-121.878426,40.436314,
-121.850143,40.442822,-121.832535,
40.437767,-121.812508,40.441681,
-121.805107,40.44511,-121.789146,
40.442436,-121.78614,40.443737,
-121.774887,40.438084,-121.734543,
40.435909,-121.725197,40.441036,
-121.718468,40.448704,-121.706757,
40.450855,-121.696938,40.448223,
-121.684746,40.453007,-121.671776,
40.451038,-121.668938,40.447491,
-121.65387,40.441631,-121.644981,
40.434788,-121.612953,40.439156,
-121.607552,40.438358,-121.599342,
40.431885,-121.592064,40.431255,
-121.581451,40.43531,-121.575958,
40.442558,-121.564072,40.445908,
-121.496544,40.445713,-121.365021,
40.446045,-121.345459,40.449833,
-121.336502,40.445599,-121.326744,
40.445484,-121.3256,40.497696,
-121.321907,40.497704,-121.318878,
40.90601,-121.331253,40.905506,
-121.330704,41.183998,-121.445396,
41.183601)),'Shasta','06089',
'California','CA','06',3785.0058,147036,38.8469);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.146111,39.707752,-120.653175,
39.706734,-120.653679,39.694218,
-120.658699,39.686573,-120.670265,
39.682549,-120.678856,39.676693,
-120.69397,39.691814,-120.702415,
39.692371,-120.715111,39.706379,
-120.733551,39.708447,-120.734032,
39.710854,-120.741409,39.712646,
-120.748871,39.719742,-120.769211,
39.717983,-120.771248,39.71331,
-120.77993,39.712395,-120.781929,
39.709949,-120.791359,39.709812,
-120.790573,39.715092,-120.793709,
39.718506,-120.808197,39.720882,
-120.814499,39.747089,-120.825226,
39.742107,-120.827667,39.746929,
-120.838364,39.746456,-120.843231,
39.751831,-120.843254,39.756241,
-120.853325,39.760021,-120.858475,
39.770615,-120.869743,39.776985,
-120.8759,39.771633,-120.886627,
39.767235,-120.894157,39.759956,
-120.912819,39.757332,-120.915741,
39.753342,-120.921928,39.750874,
-120.924522,39.744453,-120.933304,
39.738899,-120.933083,39.701702,
-120.936493,39.700146,-120.935455,
39.693302,-120.938866,39.692963,
-120.939011,39.686443,-120.950668,
39.676674,-120.948334,39.672508,
-120.962601,39.665165,-120.964111,
39.660656,-120.977425,39.648941,
-120.982719,39.648983,-120.985023,
39.644863,-121,39.638515,-121.008408,
39.639713,-121.023323,39.559155,
-121.030586,39.558414,-121.037979,
39.55048,-121.046982,39.548534,
-121.050117,39.542156,-121.055946,
39.540531,-121.057098,39.536983,
-121.050095,39.524765,-121.052544,
39.522366,-121.04879,39.521172,
-121.048355,39.517765,-121.044037,
39.514378,-121.033356,39.514729,
-121.021095,39.391399,-121.016853,
39.395454,-121.006264,39.399525,
-121.01355,39.402317,-121.013962,
39.405586,-121.005669,39.404922,
-120.99157,39.414536,-120.985191,
39.411587,-120.980858,39.414406,
-120.978996,39.411774,-120.977966,
39.41795,-120.971039,39.419163,
-120.957558,39.415806,-120.94281,
39.419991,-120.930832,39.417316,
-120.928764,39.420975,-120.919922,
39.422646,-120.913078,39.420238,
-120.911957,39.425091,-120.909187,
39.426212,-120.892632,39.4244,
-120.883629,39.429565,-120.877769,
39.429104,-120.877617,39.431274,
-120.875725,39.429626,-120.874245,
39.431278,-120.8638,39.430439,
-120.85675,39.435383,-120.853828,
39.434013,-120.853394,39.436504,
-120.842384,39.435226,-120.835754,
39.440647,-120.824829,39.435207,
-120.822174,39.437424,-120.816895,
39.436581,-120.815811,39.440857,
-120.812263,39.440147,-120.810059,
39.436237,-120.804832,39.438843,
-120.799286,39.437813,-120.796272,
39.441933,-120.790848,39.441429,
-120.785118,39.444401,-120.783707,
39.448177,-120.77948,39.446777,
-120.774879,39.450939,-120.772697,
39.448788,-120.760536,39.454044,
-120.754753,39.452877,-120.751801,
39.4585,-120.748848,39.457794,
-120.741272,39.461662,-120.742157,
39.46711,-120.725632,39.472122,
-120.712769,39.483063,-120.715874,
39.489353,-120.705505,39.493061,
-120.699989,39.502258,-120.686356,
39.506744,-120.677933,39.513699,
-120.676842,39.517956,-120.654007,
39.526737,-120.64975,39.52346,
-120.629227,39.524822,-120.624435,
39.51984,-120.61631,39.522106,
-120.597824,39.522301,-120.596321,
39.520767,-120.588493,39.523445,
-120.583145,39.52182,-120.576622,
39.523331,-120.570419,39.520538,
-120.567551,39.51601,-120.55938,
39.516312,-120.555595,39.513725,
-120.555603,39.506908,-120.549629,
39.503727,-120.548035,39.494568,
-120.540215,39.49099,-120.538536,
39.486847,-120.53318,39.48378,
-120.533287,39.464298,-120.519775,
39.456566,-120.508713,39.45491,
-120.504349,39.446171,-120.00209,
39.445206,-120.00029,39.722511,
-120.014778,39.722462,-120.014702,
39.708813,-120.146111,39.707752)),
'Sierra','06091','California','CA','06',953.2695,3318,3.4806);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-123.229599,42.004002,-123.34639,
41.999264,-123.433601,42.001801,
-123.516739,42.001015,-123.518677,
41.995323,-123.533089,41.991093,
-123.539757,41.985474,-123.535118,
41.977486,-123.532082,41.955334,
-123.546494,41.938595,-123.547668,
41.933487,-123.553215,41.93021,
-123.552277,41.915386,-123.558319,
41.906128,-123.56427,41.903305,
-123.57679,41.903145,-123.5923,
41.906479,-123.598228,41.899162,
-123.596199,41.894337,-123.60363,
41.888256,-123.605125,41.880936,
-123.615875,41.881969,-123.623291,
41.888592,-123.634476,41.88768,
-123.638222,41.890461,-123.64164,
41.889515,-123.644066,41.883713,
-123.651138,41.879086,-123.645325,
41.876812,-123.650215,41.873074,
-123.651093,41.8657,-123.648308,
41.860485,-123.660362,41.856636,
-123.661285,41.852581,-123.670158,
41.845146,-123.669601,41.835594,
-123.68174,41.837299,-123.702507,
41.829651,-123.702187,41.820534,
-123.697037,41.817348,-123.692543,
41.814777,-123.687279,41.801865,
-123.679543,41.800991,-123.670937,
41.79615,-123.675087,41.789654,
-123.673424,41.785789,-123.68293,
41.784687,-123.687157,41.781384,
-123.682251,41.769791,-123.677132,
41.738705,-123.672508,41.734425,
-123.664932,41.732315,-123.658699,
41.72036,-123.659035,41.714214,
-123.667992,41.706638,-123.6689,
41.701889,-123.661667,41.693626,
-123.684219,41.676205,-123.688408,
41.669598,-123.687424,41.660332,
-123.68409,41.66021,-123.687271,
41.652885,-123.679276,41.634117,
-123.695465,41.634026,-123.695374,
41.628395,-123.701576,41.623539,
-123.709854,41.615181,-123.710251,
41.609077,-123.714928,41.606709,
-123.717911,41.595417,-123.714493,
41.591473,-123.70536,41.595848,
-123.697685,41.595875,-123.696411,
41.591103,-123.681145,41.595032,
-123.680168,41.586899,-123.686722,
41.585281,-123.68792,41.58223,
-123.680359,41.571926,-123.692711,
41.557152,-123.692711,41.552017,
-123.689072,41.552475,-123.681366,
41.543209,-123.669106,41.544285,
-123.655594,41.538773,-123.651627,
41.539547,-123.646873,41.535168,
-123.641449,41.522858,-123.644638,
41.519161,-123.644958,41.512577,
-123.639565,41.507526,-123.633286,
41.486233,-123.636597,41.48254,
-123.629395,41.47728,-123.631233,
41.473618,-123.62545,41.466953,
-123.610458,41.461727,-123.614754,
41.453117,-123.611221,41.449112,
-123.616997,41.443123,-123.620842,
41.432789,-123.63662,41.428253,
-123.647385,41.420979,-123.640839,
41.415817,-123.637741,41.40752,
-123.64048,41.400345,-123.654831,
41.395458,-123.654297,41.388584,
-123.660194,41.382244,-123.5,
41.382721,-123.497093,41.379063,
-123.488243,41.377819,-123.479851,
41.372139,-123.472923,41.366344,
-123.481346,41.353806,-123.477203,
41.340462,-123.47747,41.3298,
-123.472832,41.326523,-123.471306,
41.321701,-123.462273,41.317879,
-123.458427,41.310387,-123.459167,
41.303455,-123.455719,41.300442,
-123.454315,41.292969,-123.461975,
41.285244,-123.460587,41.28236,
-123.442894,41.27319,-123.441261,
41.251663,-123.454147,41.236683,
-123.449738,41.231392,-123.436729,
41.227039,-123.433205,41.223026,
-123.435837,41.218922,-123.434441,
41.213097,-123.428749,41.208977,
-123.426544,41.203487,-123.415932,
41.197151,-123.407127,41.180092,
-123.402817,41.174671,-123.396706,
41.174229,-123.392342,41.170864,
-123.391571,41.161358,-123.382904,
41.157883,-123.380035,41.151436,
-123.371819,41.152088,-123.361076,
41.161705,-123.352081,41.1632,
-123.328453,41.15181,-123.323792,
41.141693,-123.314217,41.140411,
-123.309364,41.143368,-123.302315,
41.143932,-123.293907,41.140797,
-123.283691,41.128605,-123.282784,
41.123596,-123.272247,41.123035,
-123.270622,41.11573,-123.260223,
41.105923,-123.257256,41.0937,
-123.248207,41.087318,-123.244072,
41.078129,-123.238327,41.075905,
-123.224083,41.076267,-123.216133,
41.073154,-123.207733,41.074806,
-123.202003,41.071903,-123.191963,
41.07753,-123.187134,41.077732,
-123.177788,41.075699,-123.164093,
41.078274,-123.154449,41.074879,
-123.147575,41.078587,-123.14019,
41.079319,-123.107925,41.075569,
-123.104744,41.065907,-123.097153,
41.063156,-123.095192,41.05954,
-123.078941,41.057705,-123.054039,
41.046844,-123.04483,41.03363,
-123.046425,41.024876,-123.035973,
41.004314,-123.01091,41.006912,
-123.002594,41.012653,-122.978989,
41.014454,-122.958504,41.010353,
-122.950882,41.006531,-122.943176,
40.994373,-122.933838,40.992569,
-122.923531,40.995808,-122.916389,
40.994129,-122.91275,40.999157,
-122.913315,41.007034,-122.904716,
41.00919,-122.900383,41.014786,
-122.901276,41.023926,-122.896225,
41.029316,-122.908089,41.041325,
-122.922188,41.072086,-122.940926,
41.07021,-122.952042,41.074413,
-122.96492,41.081039,-122.969826,
41.090298,-122.967949,41.103497,
-122.972931,41.105896,-122.973099,
41.10976,-122.958794,41.12413,
-122.964203,41.138443,-122.956924,
41.145802,-122.951775,41.147114,
-122.950523,41.150455,-122.956139,
41.16135,-122.953537,41.167538,
-122.961456,41.178009,-122.960197,
41.181664,-122.950172,41.185715,
-122.937233,41.178246,-122.928032,
41.178829,-122.923698,41.186798,
-122.914223,41.187321,-122.9077,
41.191669,-122.905739,41.19606,
-122.884773,41.205276,-122.879677,
41.203655,-122.869553,41.205223,
-122.858795,41.201664,-122.842796,
41.200359,-122.835564,41.20686,
-122.824043,41.210163,-122.815704,
41.207729,-122.810204,41.202583,
-122.80098,41.203178,-122.794418,
41.211494,-122.787193,41.212715,
-122.785591,41.217129,-122.780075,
41.218307,-122.775871,41.230976,
-122.763908,41.235317,-122.757187,
41.240936,-122.745331,41.241024,
-122.724159,41.247601,-122.723465,
41.261208,-122.710823,41.274925,
-122.699135,41.276207,-122.686226,
41.28146,-122.681114,41.278114,
-122.677933,41.279099,-122.676147,
41.285118,-122.662354,41.291775,
-122.651741,41.289867,-122.650414,
41.299728,-122.644447,41.304867,
-122.646553,41.322475,-122.640991,
41.32674,-122.626335,41.332161,
-122.61676,41.327656,-122.604095,
41.32933,-122.597786,41.324665,
-122.587921,41.326969,-122.585991,
41.333412,-122.579887,41.337799,
-122.585861,41.349831,-122.584114,
41.359138,-122.571762,41.365829,
-122.571541,41.368114,-122.559921,
41.366093,-122.539307,41.353283,
-122.541595,41.350277,-122.534584,
41.341564,-122.518784,41.343906,
-122.502762,41.343117,-122.501419,
41.333076,-122.477638,41.320217,
-122.500793,41.309242,-122.498093,
41.292179,-122.509041,41.288792,
-122.51284,41.280281,-122.510384,
41.269928,-122.512802,41.266918,
-122.512817,41.255344,-122.507118,
41.245415,-122.516327,41.23991,
-122.516983,41.236053,-122.511139,
41.226582,-122.521507,41.213657,
-122.514366,41.20512,-122.496269,
41.195702,-122.493896,41.191795,
-122.497246,41.182804,-122.310997,
41.185013,-122.125,41.18309,
-121.445396,41.183601,-121.447884,
41.776512,-121.455826,41.776424,
-121.455772,41.949982,-121.446419,
41.950237,-121.446503,41.997303,
-122.288399,42.0079,-122.377068,
42.009655,-122.633598,42.005001,
-122.892815,42.00275,-123.044106,
42.003201,-123.144798,42.009399,
-123.229599,42.004002)),'Siskiyou',
'06093','California','CA','06',6286.1796,43531,6.9248);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.102211,38.513374,-122.105202,
38.5084,-122.106102,38.494598,
-122.103798,38.490898,-122.122505,
38.447701,-122.125305,38.429001,
-122.116905,38.4142,-122.113602,
38.414001,-122.108505,38.404701,
-122.087799,38.3843,-122.076599,
38.3638,-122.072304,38.361,
-122.068703,38.342899,-122.060303,
38.327499,-122.067101,38.318501,
-122.063705,38.316002,-122.204903,
38.3158,-122.200302,38.308102,
-122.201508,38.304199,-122.198105,
38.301601,-122.2024,38.292999,
-122.187302,38.271702,-122.211197,
38.2729,-122.215401,38.266102,
-122.215797,38.262402,-122.211906,
38.259201,-122.198601,38.258999,
-122.1922,38.2565,-122.194107,
38.250801,-122.2033,38.249401,
-122.209999,38.2523,-122.211403,
38.248798,-122.200706,38.240398,
-122.192307,38.221298,-122.195107,
38.219002,-122.193901,38.212399,
-122.200401,38.2117,-122.204597,
38.208302,-122.203903,38.198601,
-122.210403,38.1922,-122.208397,
38.189999,-122.2145,38.188499,
-122.211906,38.184399,-122.213997,
38.179798,-122.207802,38.172798,
-122.202103,38.1716,-122.202507,
38.1688,-122.196999,38.168499,
-122.193398,38.164799,-122.197906,
38.159401,-122.194305,38.155102,
-122.405998,38.155899,-122.401733,
38.149067,-122.398232,38.151489,
-122.352402,38.136002,-122.310509,
38.113392,-122.294502,38.1003,
-122.268272,38.068577,-122.264854,
38.060097,-122.264267,38.060001,
-122.244171,38.064049,-122.199768,
38.058018,-122.182785,38.054077,
-122.163506,38.034801,-122.147507,
38.031799,-122.122894,38.035797,
-122.060036,38.062222,-122.027336,
38.059273,-122.014107,38.063564,
-121.976372,38.066921,-121.934357,
38.048878,-121.905731,38.045086,
-121.873657,38.050758,-121.866333,
38.056976,-121.861389,38.066113,
-121.858528,38.071217,-121.841377,
38.076817,-121.826851,38.066303,
-121.799057,38.059727,-121.742096,
38.087311,-121.728287,38.082432,
-121.709824,38.086575,-121.706146,
38.109921,-121.691025,38.133217,
-121.684578,38.159729,-121.676926,
38.164993,-121.661842,38.181969,
-121.647362,38.185375,-121.631233,
38.194336,-121.620323,38.193665,
-121.611618,38.199039,-121.609344,
38.208466,-121.60099,38.221729,
-121.602142,38.237282,-121.599182,
38.257904,-121.602943,38.270191,
-121.599663,38.278465,-121.604355,
38.285793,-121.604111,38.296177,
-121.598877,38.301617,-121.597443,
38.310192,-121.591827,38.313152,
-121.69326,38.313808,-121.693695,
38.527119,-121.699661,38.527519,
-121.709824,38.537521,-121.721703,
38.535301,-121.741241,38.540295,
-121.748718,38.530785,-121.764931,
38.525921,-121.770103,38.533001,
-121.778,38.530701,-121.785202,
38.523499,-121.795502,38.528,
-121.812851,38.526577,-121.831726,
38.530354,-121.839745,38.534431,
-121.858833,38.539009,-121.866943,
38.537006,-121.871521,38.539089,
-121.884995,38.539295,-121.892723,
38.534016,-121.908989,38.529903,
-121.924561,38.530094,-121.941345,
38.53373,-121.947517,38.527744,
-121.964516,38.523216,-121.975777,
38.515167,-121.977699,38.509247,
-121.982834,38.507248,-121.982193,
38.505791,-121.994591,38.500862,
-121.998291,38.496288,-122.01104,
38.488991,-122.019455,38.490047,
-122.03112,38.495007,-122.040703,
38.50589,-122.05603,38.517391,
-122.070976,38.513695,-122.090462,
38.516014,-122.093758,38.512928,
-122.102211,38.513374)),'Solano',
'06095','California','CA','06',828.0239,340421,411.1245);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-123.532417,38.768517,-123.530769,
38.759399,-123.523438,38.749401,
-123.512924,38.741718,-123.497566,
38.738083,-123.483017,38.727173,
-123.459579,38.717064,-123.452705,
38.706959,-123.438148,38.693619,
-123.431686,38.6819,-123.408646,
38.66209,-123.401779,38.649158,
-123.370247,38.607124,-123.357315,
38.597015,-123.348824,38.596207,
-123.341141,38.58651,-123.332657,
38.563873,-123.309616,38.555786,
-123.302742,38.546898,-123.276199,
38.531998,-123.248055,38.509037,
-123.199173,38.491627,-123.18029,
38.481998,-123.140663,38.456078,
-123.128075,38.451263,-123.113258,
38.422009,-123.104736,38.417191,
-123.098816,38.410156,-123.094742,
38.399788,-123.095116,38.392754,
-123.089188,38.39312,-123.083633,
38.38905,-123.076225,38.373123,
-123.068817,38.363865,-123.066589,
38.353497,-123.068817,38.331276,
-123.071777,38.324612,-123.076591,
38.322762,-123.060295,38.299801,
-123.053635,38.298687,-123.050674,
38.302391,-123.051407,38.307575,
-123.045853,38.312019,-123.036598,
38.313133,-123.02549,38.311279,
-123.001617,38.295795,-122.992996,
38.299469,-122.993637,38.306271,
-122.983635,38.308033,-122.980499,
38.311218,-122.968933,38.310211,
-122.965034,38.317101,-122.945053,
38.311169,-122.942818,38.312565,
-122.938255,38.310959,-122.93306,
38.314072,-122.93573,38.31089,
-122.934013,38.309631,-122.92437,
38.312817,-122.920303,38.308693,
-122.915184,38.312744,-122.919632,
38.316887,-122.914398,38.320412,
-122.908501,38.320824,-122.905571,
38.319839,-122.909431,38.317459,
-122.908241,38.314323,-122.898514,
38.316814,-122.7388,38.2071,
-122.720772,38.20694,-122.708237,
38.19743,-122.703598,38.198738,
-122.700104,38.19622,-122.686996,
38.195,-122.678543,38.189735,
-122.666382,38.189896,-122.662292,
38.186371,-122.65715,38.186726,
-122.648224,38.181335,-122.634598,
38.17881,-122.627121,38.178864,
-122.624634,38.182503,-122.603256,
38.180702,-122.599907,38.185501,
-122.591721,38.188869,-122.589401,
38.186001,-122.581024,38.188103,
-122.579178,38.185658,-122.577995,
38.187172,-122.573135,38.186028,
-122.572144,38.18338,-122.569603,
38.183601,-122.572105,38.186401,
-122.569504,38.187199,-122.564056,
38.182678,-122.567398,38.177101,
-122.56337,38.175163,-122.562103,
38.169399,-122.550888,38.169083,
-122.556908,38.163612,-122.556824,
38.16024,-122.548523,38.157372,
-122.543381,38.158798,-122.533737,
38.149284,-122.519012,38.140781,
-122.512054,38.132317,-122.506844,
38.118179,-122.499466,38.111862,
-122.487808,38.108936,-122.487366,
38.112923,-122.421486,38.127777,
-122.409821,38.136593,-122.403458,
38.147873,-122.401733,38.149067,
-122.405998,38.155899,-122.4058,
38.158901,-122.390106,38.161499,
-122.370506,38.1576,-122.366501,
38.158798,-122.364304,38.166901,
-122.367302,38.1814,-122.365997,
38.183102,-122.357803,38.181499,
-122.355507,38.183601,-122.356102,
38.192001,-122.3591,38.195702,
-122.357002,38.197498,-122.349304,
38.192402,-122.348701,38.201199,
-122.357307,38.209599,-122.356598,
38.225201,-122.365707,38.247101,
-122.373505,38.244598,-122.372704,
38.247501,-122.388809,38.26078,
-122.386154,38.273338,-122.395905,
38.272179,-122.403503,38.281509,
-122.399734,38.289635,-122.402603,
38.299713,-122.400192,38.302818,
-122.3936,38.304699,-122.395065,
38.30899,-122.400864,38.314281,
-122.404312,38.322205,-122.408051,
38.320641,-122.408493,38.325821,
-122.412643,38.33078,-122.41095,
38.334381,-122.416199,38.339802,
-122.419037,38.338432,-122.426117,
38.34613,-122.425659,38.348858,
-122.436852,38.357185,-122.448601,
38.361099,-122.456741,38.368073,
-122.4468,38.379398,-122.464798,
38.390499,-122.469101,38.397598,
-122.467003,38.400101,-122.469505,
38.404999,-122.474304,38.406601,
-122.474503,38.409199,-122.496506,
38.424599,-122.490303,38.434502,
-122.486015,38.431808,-122.484413,
38.437569,-122.478912,38.443119,
-122.481903,38.452801,-122.492599,
38.4566,-122.508102,38.457802,
-122.508904,38.462399,-122.50473,
38.464584,-122.515152,38.470963,
-122.528503,38.4697,-122.530304,
38.478634,-122.54364,38.49577,
-122.541756,38.498932,-122.537109,
38.497993,-122.53447,38.501816,
-122.542068,38.507584,-122.544434,
38.506889,-122.547714,38.511719,
-122.541275,38.51329,-122.544205,
38.516548,-122.542801,38.520061,
-122.54953,38.522224,-122.553329,
38.526321,-122.565552,38.525635,
-122.572906,38.540451,-122.586563,
38.552696,-122.599136,38.555748,
-122.602196,38.558876,-122.619751,
38.560413,-122.619186,38.565426,
-122.621674,38.567917,-122.625824,
38.570229,-122.630737,38.569462,
-122.629402,38.579102,-122.645325,
38.598686,-122.638458,38.611755,
-122.632355,38.61628,-122.6325,
38.619957,-122.627197,38.623131,
-122.631905,38.627701,-122.633003,
38.637001,-122.6231,38.649899,
-122.622597,38.664398,-122.626305,
38.667599,-122.624367,38.674496,
-122.638397,38.689152,-122.635956,
38.693825,-122.643219,38.699665,
-122.64579,38.706638,-122.661087,
38.706032,-122.668304,38.708466,
-122.673134,38.706448,-122.694351,
38.713184,-122.69957,38.728657,
-122.709282,38.732178,-122.711235,
38.742321,-122.707489,38.748928,
-122.723053,38.756657,-122.721596,
38.763107,-122.727242,38.766315,
-122.728439,38.770802,-122.733459,
38.772705,-122.736923,38.781136,
-122.747124,38.787891,-122.745094,
38.799343,-122.747078,38.803925,
-122.758652,38.808525,-122.765579,
38.813995,-122.768501,38.820045,
-122.779091,38.826935,-122.790291,
38.830528,-122.794823,38.839088,
-122.80513,38.836323,-122.810982,
38.838509,-122.811043,38.843006,
-122.817207,38.844685,-122.816544,
38.849937,-122.820488,38.850235,
-123.079887,38.852535,-123.080116,
38.838501,-123.135521,38.839542,
-123.135139,38.809231,-123.367279,
38.806736,-123.367111,38.777161,
-123.495918,38.778694,-123.498817,
38.773933,-123.506126,38.773796,
-123.508759,38.767559,-123.515221,
38.767876,-123.519081,38.758678,
-123.532104,38.768547,-123.532417,
38.768517)),'Sonoma','06097',
'California','CA','06',1575.9355,388222,246.3436);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.9254,38.077499,-120.925301,
37.886799,-120.922203,37.757801,
-120.919701,37.7388,-120.921906,
37.737598,-120.9412,37.742401,
-120.952705,37.738701,-120.991905,
37.760899,-120.997902,37.757198,
-120.998199,37.753899,-121.007103,
37.749199,-121.011307,37.749599,
-121.011101,37.752998,-121.013702,
37.7533,-121.010002,37.7551,
-121.015198,37.756001,-121.024704,
37.742401,-121.027702,37.741001,
-121.035797,37.742699,-121.037598,
37.739399,-121.040604,37.741699,
-121.043701,37.7393,-121.045403,
37.742802,-121.049904,37.741901,
-121.053398,37.750702,-121.059105,
37.749599,-121.060303,37.7467,
-121.063507,37.7477,-121.062103,
37.743999,-121.065598,37.744999,
-121.065308,37.7411,-121.069801,
37.7384,-121.076401,37.737701,
-121.082199,37.741798,-121.086906,
37.741501,-121.093803,37.733398,
-121.099907,37.737499,-121.1008,
37.7411,-121.105797,37.7402,
-121.109001,37.742199,-121.108398,
37.734501,-121.105103,37.732601,
-121.115501,37.726398,-121.115707,
37.724201,-121.1203,37.7244,
-121.1203,37.722,-121.122307,
37.724499,-121.124397,37.722801,
-121.127403,37.7243,-121.130707,
37.722198,-121.135201,37.724701,
-121.137001,37.722401,-121.140999,
37.722801,-121.145203,37.718102,
-121.153503,37.720299,-121.1558,
37.716702,-121.157799,37.7173,
-121.158302,37.708599,-121.160797,
37.708,-121.158302,37.7047,
-121.163597,37.7047,-121.165703,
37.702499,-121.162598,37.7006,
-121.167702,37.699299,-121.177399,
37.705601,-121.178307,37.7024,
-121.175003,37.699501,-121.181503,
37.698299,-121.179306,37.694401,
-121.182602,37.693001,-121.178101,
37.692902,-121.181198,37.690601,
-121.179504,37.6884,-121.185997,
37.687901,-121.188026,37.691483,
-121.190399,37.690399,-121.194702,
37.694801,-121.198402,37.690498,
-121.200104,37.696301,-121.2052,
37.694698,-121.207306,37.686901,
-121.214706,37.688202,-121.222107,
37.6838,-121.220001,37.672501,
-121.220802,37.670399,-121.228203,
37.668999,-121.228905,37.6633,
-121.244102,37.664398,-121.272705,
37.638401,-121.470871,37.481853,
-121.471603,37.482235,-121.473473,
37.479412,-121.476646,37.480347,
-121.482361,37.475491,-121.485718,
37.475719,-121.4832,37.466099,
-121.473984,37.46212,-121.471626,
37.456448,-121.466125,37.453407,
-121.463638,37.454552,-121.461861,
37.451557,-121.460808,37.438866,
-121.469276,37.430187,-121.467812,
37.42506,-121.47155,37.423412,
-121.455307,37.406799,-121.455597,
37.395599,-121.447113,37.391743,
-121.435036,37.396194,-121.422997,
37.3937,-121.411507,37.3895,
-121.408028,37.380737,-121.414803,
37.37598,-121.4226,37.358898,
-121.418358,37.352051,-121.419701,
37.344799,-121.408104,37.3307,
-121.410889,37.324509,-121.404701,
37.31105,-121.41732,37.303341,
-121.422401,37.295353,-121.430344,
37.295055,-121.435768,37.292034,
-121.442505,37.2967,-121.448601,
37.293999,-121.447609,37.290363,
-121.452957,37.284111,-121.458,
37.282799,-121.452919,37.277248,
-121.453796,37.263203,-121.456207,
37.261005,-121.454704,37.2495,
-121.447693,37.237339,-121.440697,
37.23119,-121.421165,37.221996,
-121.420021,37.21489,-121.415825,
37.211323,-121.414604,37.199707,
-121.409271,37.191322,-121.410477,
37.185467,-121.40786,37.180901,
-121.412354,37.172386,-121.406677,
37.169064,-121.405487,37.158897,
-121.39798,37.150192,-121.391945,
37.148212,-121.390091,37.150806,
-121.382507,37.151546,-121.380585,
37.157196,-121.383224,37.16626,
-121.359894,37.18438,-121.347656,
37.181179,-121.341339,37.174252,
-121.331062,37.171047,-121.32737,
37.166012,-121.312988,37.167973,
-121.311836,37.170208,-121.305,
37.166698,-121.301575,37.168221,
-121.297508,37.166023,-121.290482,
37.170395,-121.289917,37.175488,
-121.280067,37.183662,-121.261055,
37.159386,-121.236069,37.157265,
-121.231255,37.139954,-121.225693,
37.134895,-121.221672,37.138275,
-120.963181,37.345844,-120.975143,
37.350319,-120.976501,37.361801,
-120.9804,37.365799,-120.972504,
37.3694,-120.976601,37.371101,
-120.972504,37.377602,-120.982201,
37.376499,-120.981201,37.3857,
-120.989601,37.3876,-120.9907,
37.385067,-120.992599,37.3881,
-120.983353,37.399433,-120.885391,
37.440243,-120.829819,37.460247,
-120.38665,37.63343,-120.386581,
37.633774,-120.652824,37.832355,
-120.727631,37.897743,-120.760254,
37.931145,-120.875,38.028973,
-120.9254,38.077499)),'Stanislaus',
'06099','California','CA','06',1494.3046,370522,247.9559);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.907227,39.304024,-121.907013,
39.301983,-121.913971,39.298347,
-121.917854,39.289539,-121.921005,
39.288418,-121.920036,39.281185,
-121.926697,39.275795,-121.927963,
39.271275,-121.935661,39.268368,
-121.945869,39.25,-121.947098,
39.240501,-121.939293,39.229309,
-121.940331,39.221893,-121.935143,
39.221203,-121.936913,39.218346,
-121.931381,39.211685,-121.927414,
39.198845,-121.935562,39.194771,
-121.933533,39.189938,-121.940376,
39.18655,-121.944328,39.180199,
-121.938316,39.174305,-121.933151,
39.161137,-121.919037,39.153099,
-121.916138,39.147388,-121.919456,
39.141449,-121.936684,39.144093,
-121.938087,39.136253,-121.933044,
39.130108,-121.923935,39.128284,
-121.920486,39.122227,-121.910019,
39.123257,-121.908875,39.119396,
-121.91201,39.114426,-121.909584,
39.113022,-121.904457,39.114876,
-121.902443,39.108166,-121.904755,
39.103195,-121.898956,39.100319,
-121.89743,39.096794,-121.893288,
39.096233,-121.894157,39.086899,
-121.888657,39.081272,-121.893532,
39.079082,-121.888023,39.072479,
-121.868736,39.066967,-121.848785,
39.071537,-121.837898,39.064369,
-121.838737,39.046837,-121.828583,
39.038033,-121.82972,39.032772,
-121.823837,39.031876,-121.821686,
39.028759,-121.820099,39.020336,
-121.825409,39.011295,-121.818214,
39.006126,-121.805199,39.003471,
-121.79435,38.996494,-121.801025,
38.989872,-121.818062,38.988655,
-121.82032,38.97485,-121.833229,
38.96883,-121.830963,38.960575,
-121.839485,38.954929,-121.835518,
38.94923,-121.835487,38.94392,
-121.829117,38.938946,-121.836685,
38.927456,-121.83474,38.924576,
-121.827843,38.918575,-121.804451,
38.915169,-121.804771,38.910896,
-121.814178,38.911312,-121.809135,
38.907951,-121.790436,38.905502,
-121.792511,38.900818,-121.80291,
38.901825,-121.802017,38.897518,
-121.805695,38.890415,-121.816162,
38.882977,-121.813828,38.876625,
-121.802925,38.870079,-121.801437,
38.864609,-121.795486,38.866657,
-121.790909,38.862705,-121.785629,
38.863762,-121.782814,38.856544,
-121.776993,38.860832,-121.765121,
38.863888,-121.757362,38.86245,
-121.75882,38.86787,-121.747597,
38.871326,-121.743729,38.864258,
-121.729469,38.859104,-121.727089,
38.853508,-121.722382,38.852417,
-121.727608,38.846172,-121.724991,
38.841103,-121.728607,38.83968,
-121.729805,38.835838,-121.722359,
38.825703,-121.722275,38.803856,
-121.707039,38.801105,-121.700172,
38.803127,-121.694771,38.796806,
-121.689598,38.795727,-121.692299,
38.789921,-121.685577,38.77544,
-121.69146,38.767776,-121.686157,
38.763809,-121.679825,38.763729,
-121.675583,38.760288,-121.668945,
38.759407,-121.674461,38.75288,
-121.674431,38.745361,-121.671967,
38.742943,-121.669357,38.743839,
-121.667107,38.753616,-121.663635,
38.75568,-121.65699,38.754738,
-121.662621,38.768082,-121.656982,
38.768936,-121.652641,38.764385,
-121.640221,38.766254,-121.637825,
38.767632,-121.647392,38.772785,
-121.645088,38.774178,-121.639328,
38.772865,-121.633186,38.766991,
-121.630592,38.77536,-121.626846,
38.77784,-121.630508,38.782784,
-121.623039,38.785278,-121.60379,
38.779457,-121.59214,38.764416,
-121.592339,38.754086,-121.601822,
38.735935,-121.520706,38.7365,
-121.483398,38.734699,-121.483139,
38.751297,-121.468445,38.751377,
-121.468285,38.926098,-121.41333,
38.926418,-121.413834,39.002769,
-121.425537,38.998077,-121.425301,
38.996479,-121.436455,38.993736,
-121.440887,38.994968,-121.442757,
38.993431,-121.447533,38.997173,
-121.455246,38.998295,-121.474007,
38.992149,-121.480988,38.993607,
-121.486137,38.990749,-121.488579,
38.992157,-121.492622,38.984409,
-121.507965,38.982899,-121.523575,
38.971581,-121.542397,38.972553,
-121.552437,38.953869,-121.560402,
38.953548,-121.570221,38.939034,
-121.574341,38.918453,-121.580063,
38.925858,-121.580727,38.93882,
-121.576897,38.946873,-121.58152,
38.955807,-121.580109,38.965336,
-121.586296,38.973473,-121.588333,
38.99044,-121.578255,39.007679,
-121.598961,39.012211,-121.593338,
39.023144,-121.604561,39.032738,
-121.607101,39.03896,-121.609062,
39.057961,-121.584908,39.089771,
-121.587074,39.102024,-121.590485,
39.102695,-121.594879,39.099552,
-121.601128,39.100445,-121.602882,
39.11552,-121.596603,39.127899,
-121.606506,39.140999,-121.604401,
39.1502,-121.614532,39.167934,
-121.610077,39.175816,-121.61541,
39.178783,-121.617378,39.183182,
-121.611961,39.190582,-121.61412,
39.193481,-121.622604,39.19585,
-121.628014,39.204784,-121.623833,
39.207031,-121.620041,39.206261,
-121.619209,39.2136,-121.612549,
39.21397,-121.616943,39.220325,
-121.613235,39.228855,-121.626633,
39.22871,-121.627335,39.236366,
-121.634041,39.240589,-121.635368,
39.246178,-121.634842,39.26207,
-121.626007,39.259506,-121.620338,
39.263817,-121.627708,39.266689,
-121.631592,39.271084,-121.629852,
39.273533,-121.625,39.271629,
-121.621086,39.273441,-121.626259,
39.279526,-121.630592,39.29166,
-121.624481,39.292656,-121.622772,
39.295872,-121.631073,39.30204,
-121.629021,39.305775,-121.907227,
39.304024)),'Sutter','06101',
'California','CA','06',602.5883,64415,106.897);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-123.064339,40.287022,-123.060112,
40.277893,-123.044449,40.264751,
-123.035507,40.261402,-123.030365,
40.264954,-123.017448,40.262913,
-123.002029,40.253208,-122.984543,
40.248898,-122.976425,40.241413,
-122.9776,40.234703,-122.97377,
40.230717,-122.978897,40.214836,
-122.977081,40.206581,-122.972153,
40.203197,-122.969963,40.197304,
-122.973595,40.191589,-122.968933,
40.186432,-122.982811,40.172112,
-122.985298,40.159527,-122.983414,
40.153542,-122.988487,40.145252,
-122.967438,40.13916,-122.972534,
40.130154,-122.968262,40.118584,
-122.969543,40.115822,-122.964333,
40.11142,-122.959969,40.100124,
-122.962601,40.095802,-122.96032,
40.089882,-122.966225,40.088848,
-122.972038,40.077293,-122.967049,
40.073944,-122.967278,40.068932,
-122.960449,40.067009,-122.949791,
40.056042,-122.947769,40.049873,
-122.953094,40.044971,-122.948639,
40.031116,-122.955254,40.020069,
-122.954201,40.015987,-122.948326,
40.012253,-122.950745,39.998951,
-122.937653,39.991436,-122.933861,
39.986317,-122.935966,39.981991,
-122.932899,39.978256,-122.924362,
39.96899,-122.925705,39.945194,
-122.915459,39.937454,-122.908669,
39.936512,-122.911484,39.931606,
-122.919502,39.929054,-122.92009,
39.916096,-122.950371,39.906441,
-122.946976,39.900623,-122.948524,
39.880024,-122.952354,39.873074,
-122.950516,39.867535,-122.954697,
39.859386,-122.952881,39.854809,
-122.95903,39.845287,-122.955315,
39.839336,-122.945595,39.833595,
-122.942635,39.802277,-122.936539,
39.798279,-122.843307,39.800629,
-122.04538,39.797768,-122.048866,
39.803432,-122.063766,39.811619,
-122.055527,39.827374,-122.068184,
39.840603,-122.057205,39.850803,
-122.054604,39.864094,-122.039619,
39.879929,-122.043846,39.88393,
-121.802956,39.884464,-121.805016,
39.888336,-121.775139,39.888977,
-121.7658,39.897484,-121.749573,
39.906933,-121.748421,39.925858,
-121.743652,39.942013,-121.734886,
39.95369,-121.728683,39.956226,
-121.723984,39.967808,-121.706505,
39.977081,-121.702225,39.984516,
-121.644951,39.982605,-121.64476,
39.997177,-121.634354,39.996941,
-121.635086,40.025928,-121.625,
40.025749,-121.625,40.039616,
-121.616722,40.039536,-121.616203,
40.04723,-121.607651,40.046867,
-121.607559,40.055202,-121.597473,
40.055202,-121.597366,40.057724,
-121.594559,40.057816,-121.594711,
40.093578,-121.585052,40.093414,
-121.58532,40.100639,-121.509476,
40.100636,-121.50946,40.108097,
-121.489792,40.108158,-121.489777,
40.115402,-121.479889,40.115208,
-121.479874,40.122482,-121.45192,
40.121964,-121.451668,40.129837,
-121.441833,40.1297,-121.44175,
40.148819,-121.4356,40.152027,
-121.440582,40.152172,-121.444946,
40.155952,-121.441643,40.161957,
-121.44397,40.177788,-121.434967,
40.182018,-121.438522,40.187946,
-121.441719,40.188595,-121.441292,
40.193031,-121.432472,40.196026,
-121.411659,40.194431,-121.406273,
40.191525,-121.400528,40.195465,
-121.399696,40.199928,-121.392471,
40.201511,-121.383942,40.210415,
-121.375,40.210625,-121.365685,
40.214149,-121.360634,40.2257,
-121.366325,40.236122,-121.353378,
40.247608,-121.354523,40.26228,
-121.360657,40.265053,-121.362091,
40.268234,-121.359451,40.279064,
-121.362465,40.287518,-121.37056,
40.29734,-121.365608,40.30117,
-121.355545,40.297588,-121.348816,
40.306057,-121.341942,40.306759,
-121.341187,40.309868,-121.352753,
40.315765,-121.359642,40.322346,
-121.366386,40.323013,-121.366249,
40.3311,-121.379295,40.340405,
-121.388451,40.339069,-121.3964,
40.342232,-121.41098,40.342834,
-121.427467,40.350407,-121.437614,
40.348015,-121.467339,40.349892,
-121.471329,40.351742,-121.479904,
40.366737,-121.472458,40.374676,
-121.481674,40.382977,-121.483192,
40.396679,-121.478516,40.419624,
-121.472717,40.424759,-121.496796,
40.432125,-121.49334,40.440533,
-121.496544,40.445713,-121.564072,
40.445908,-121.575958,40.442558,
-121.581451,40.43531,-121.592064,
40.431255,-121.599342,40.431885,
-121.607552,40.438358,-121.612953,
40.439156,-121.644981,40.434788,
-121.65387,40.441631,-121.668938,
40.447491,-121.671776,40.451038,
-121.684746,40.453007,-121.696938,
40.448223,-121.706757,40.450855,
-121.718468,40.448704,-121.725197,
40.441036,-121.734543,40.435909,
-121.774887,40.438084,-121.78614,
40.443737,-121.789146,40.442436,
-121.805107,40.44511,-121.812508,
40.441681,-121.832535,40.437767,
-121.850143,40.442822,-121.878426,
40.436314,-121.888039,40.428352,
-121.894241,40.427212,-121.899719,
40.421265,-121.909752,40.423119,
-121.913338,40.426254,-121.92601,
40.418503,-121.940315,40.415596,
-121.965942,40.422207,-121.975403,
40.421219,-121.983368,40.423023,
-121.992828,40.425861,-121.998543,
40.423199,-122.008881,40.42691,
-122.013824,40.421101,-122.021095,
40.424217,-122.029121,40.42115,
-122.029633,40.417492,-122.034271,
40.419758,-122.043129,40.418457,
-122.05101,40.420517,-122.056129,
40.416672,-122.089951,40.410721,
-122.09079,40.414406,-122.094475,
40.410007,-122.097519,40.410469,
-122.098213,40.414837,-122.110931,
40.405174,-122.116974,40.406727,
-122.120026,40.403522,-122.127846,
40.403931,-122.127975,40.399128,
-122.132523,40.397667,-122.148178,
40.398293,-122.15892,40.396919,
-122.16227,40.393234,-122.182747,
40.392258,-122.186722,40.385529,
-122.179214,40.384773,-122.172035,
40.379135,-122.180832,40.379036,
-122.186218,40.381523,-122.191002,
40.386147,-122.192451,40.392437,
-122.198288,40.377968,-122.226051,
40.389435,-122.234421,40.385521,
-122.250702,40.387341,-122.255867,
40.379498,-122.263283,40.379913,
-122.279739,40.375912,-122.293022,
40.380608,-122.298317,40.375622,
-122.309296,40.371189,-122.319923,
40.375,-122.328896,40.372883,
-122.335831,40.374298,-122.341042,
40.371029,-122.36274,40.37429,
-122.378746,40.372066,-122.387627,
40.374405,-122.394653,40.372211,
-122.411469,40.374664,-122.415565,
40.379417,-122.421227,40.379372,
-122.427742,40.375641,-122.439796,
40.373322,-122.443901,40.373524,
-122.451797,40.378639,-122.461464,
40.375591,-122.468353,40.383759,
-122.477211,40.384583,-122.481575,
40.380646,-122.488731,40.383778,
-122.499023,40.382603,-122.503906,
40.389542,-122.512703,40.388512,
-122.518867,40.393803,-122.523445,
40.394604,-122.524857,40.393208,
-122.520905,40.387966,-122.529739,
40.384289,-122.531082,40.37994,
-122.539818,40.382549,-122.540535,
40.376644,-122.549484,40.378502,
-122.54953,40.375,-122.562859,
40.365719,-122.580185,40.367458,
-122.584724,40.359406,-122.595825,
40.357365,-122.609032,40.346535,
-122.624046,40.347584,-122.620781,
40.340511,-122.631348,40.338661,
-122.633324,40.333923,-122.644798,
40.333313,-122.650215,40.328415,
-122.662323,40.332333,-122.672607,
40.33057,-122.676132,40.336384,
-122.687561,40.33746,-122.710976,
40.348446,-122.730568,40.347271,
-122.72908,40.358528,-122.74099,
40.365276,-122.750359,40.364426,
-122.752045,40.360374,-122.761375,
40.363239,-122.786896,40.355511,
-122.805473,40.355793,-122.811478,
40.351353,-122.821861,40.349495,
-122.82814,40.350117,-122.835167,
40.348557,-122.838196,40.345493,
-122.852814,40.34322,-122.861641,
40.345139,-122.86409,40.348183,
-122.876999,40.346691,-122.901711,
40.321983,-122.902824,40.316265,
-122.906052,40.318077,-122.908417,
40.313156,-122.915527,40.310684,
-122.917381,40.307049,-122.928864,
40.30785,-122.93367,40.313408,
-122.941208,40.312355,-122.947838,
40.308006,-122.950592,40.310345,
-122.969513,40.310661,-122.976448,
40.315052,-122.995491,40.308567,
-123.011032,40.306305,-123.013664,
40.302986,-123.023376,40.304001,
-123.040413,40.290821,-123.046631,
40.291851,-123.055534,40.285503,
-123.064339,40.287022)),'Tehama',
'06103','California','CA','06',2950.539,49625,16.8189);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-123.407127,41.180092,-123.409203,
41.170853,-123.415787,41.165676,
-123.42057,41.166687,-123.43145,
41.162476,-123.427605,41.152206,
-123.430328,41.147877,-123.428246,
41.14492,-123.428085,41.118149,
-123.433128,41.111801,-123.434669,
41.102497,-123.440063,41.094948,
-123.438644,41.09269,-123.445168,
41.08902,-123.455292,41.090641,
-123.462196,41.09478,-123.463333,
41.09267,-123.457123,41.083931,
-123.462845,41.076496,-123.458443,
41.073883,-123.456787,41.068359,
-123.45137,41.068676,-123.441406,
41.061264,-123.434059,41.06076,
-123.429565,41.063412,-123.422089,
41.058285,-123.422569,41.043343,
-123.418129,41.034664,-123.406067,
41.030766,-123.409149,41.020821,
-123.404877,41.013042,-123.418907,
41.009819,-123.424599,41.003654,
-123.426949,41,-123.426102,40.9884,
-123.433701,40.9827,-123.435402,
40.973801,-123.452103,40.964298,
-123.451797,40.960201,-123.443703,
40.956299,-123.444504,40.947201,
-123.4468,40.943901,-123.466507,
40.938301,-123.476799,40.9282,
-123.480301,40.9151,-123.495506,
40.916302,-123.510597,40.920502,
-123.513702,40.9249,-123.526505,
40.932732,-123.528603,40.935001,
-123.532707,40.930901,-123.539803,
40.9324,-123.540001,40.9398,
-123.558998,40.950401,-123.568802,
40.946701,-123.566505,40.936699,
-123.570503,40.937199,-123.580399,
40.9333,-123.5867,40.927898,
-123.590401,40.927502,-123.598106,
40.931301,-123.610199,40.929401,
-123.6213,40.93185,-123.622589,
40.929424,-123.620331,40.925903,
-123.612511,40.922428,-123.614769,
40.914303,-123.6036,40.900856,
-123.607246,40.895271,-123.596046,
40.884247,-123.600555,40.880096,
-123.609093,40.879116,-123.59684,
40.877762,-123.589951,40.867424,
-123.583809,40.869888,-123.579437,
40.868145,-123.586563,40.858929,
-123.574677,40.858139,-123.572716,
40.84483,-123.562958,40.842373,
-123.565086,40.835121,-123.558472,
40.83046,-123.567574,40.819881,
-123.561371,40.809841,-123.555061,
40.80896,-123.552917,40.796452,
-123.556625,40.793884,-123.564697,
40.796371,-123.565094,40.788952,
-123.563644,40.787846,-123.558884,
40.790413,-123.556458,40.787395,
-123.557129,40.781212,-123.548714,
40.775948,-123.553352,40.766796,
-123.549034,40.765682,-123.549042,
40.762943,-123.553009,40.759644,
-123.549751,40.756226,-123.550659,
40.748268,-123.546944,40.746517,
-123.541862,40.733715,-123.543121,
40.498783,-123.543327,40.002052,
-123.543434,39.977142,-122.932899,
39.978256,-122.935966,39.981991,
-122.933861,39.986317,-122.937653,
39.991436,-122.950745,39.998951,
-122.948326,40.012253,-122.954201,
40.015987,-122.955254,40.020069,
-122.948639,40.031116,-122.953094,
40.044971,-122.947769,40.049873,
-122.949791,40.056042,-122.960449,
40.067009,-122.967278,40.068932,
-122.967049,40.073944,-122.972038,
40.077293,-122.966225,40.088848,
-122.96032,40.089882,-122.962601,
40.095802,-122.959969,40.100124,
-122.964333,40.11142,-122.969543,
40.115822,-122.968262,40.118584,
-122.972534,40.130154,-122.967438,
40.13916,-122.988487,40.145252,
-122.983414,40.153542,-122.985298,
40.159527,-122.982811,40.172112,
-122.968933,40.186432,-122.973595,
40.191589,-122.969963,40.197304,
-122.972153,40.203197,-122.977081,
40.206581,-122.978897,40.214836,
-122.97377,40.230717,-122.9776,
40.234703,-122.976425,40.241413,
-122.984543,40.248898,-123.002029,
40.253208,-123.017448,40.262913,
-123.030365,40.264954,-123.035507,
40.261402,-123.044449,40.264751,
-123.060112,40.277893,-123.064339,
40.287022,-123.064026,40.298901,
-123.067703,40.308384,-123.060616,
40.313572,-123.063454,40.32,
-123.061562,40.322178,-123.067657,
40.332363,-123.062851,40.337635,
-123.064354,40.345226,-123.055756,
40.349377,-123.051941,40.346794,
-123.042839,40.347145,-123.043037,
40.353863,-123.038155,40.362858,
-123.036018,40.364567,-123.030006,
40.363735,-123.017166,40.372536,
-123.015266,40.385723,-122.995453,
40.396511,-122.998642,40.403694,
-122.997551,40.41827,-122.973793,
40.419743,-122.959869,40.426128,
-122.956657,40.421524,-122.953094,
40.421635,-122.937485,40.428989,
-122.936668,40.437042,-122.929527,
40.442146,-122.930168,40.44569,
-122.91658,40.449905,-122.905937,
40.446396,-122.900719,40.445408,
-122.895798,40.450188,-122.894234,
40.459835,-122.888153,40.465885,
-122.889015,40.468952,-122.884132,
40.471016,-122.875648,40.480412,
-122.856125,40.482468,-122.849991,
40.485954,-122.845322,40.493652,
-122.850952,40.501083,-122.844826,
40.505314,-122.82766,40.50713,
-122.81765,40.511192,-122.802986,
40.510643,-122.792122,40.514648,
-122.792488,40.523563,-122.781097,
40.532001,-122.784546,40.536667,
-122.784065,40.541046,-122.76635,
40.55526,-122.758118,40.556667,
-122.742798,40.553902,-122.740181,
40.564255,-122.721931,40.575329,
-122.706741,40.569805,-122.697662,
40.569424,-122.694168,40.572643,
-122.691734,40.580605,-122.69899,
40.585873,-122.70005,40.595947,
-122.705757,40.605591,-122.70504,
40.61039,-122.709717,40.613338,
-122.708527,40.631329,-122.71579,
40.634563,-122.733032,40.635471,
-122.734291,40.639919,-122.725883,
40.650585,-122.73262,40.657104,
-122.732445,40.662556,-122.740089,
40.665527,-122.74144,40.678932,
-122.750275,40.685207,-122.751137,
40.689789,-122.742767,40.69516,
-122.728767,40.692379,-122.721214,
40.695618,-122.71769,40.70797,
-122.710258,40.710823,-122.705627,
40.724735,-122.710991,40.73127,
-122.718719,40.73951,-122.71627,
40.747314,-122.70517,40.749687,
-122.699181,40.755527,-122.699348,
40.759029,-122.691704,40.760857,
-122.669365,40.772926,-122.664742,
40.781944,-122.657074,40.787689,
-122.660225,40.800613,-122.656326,
40.802078,-122.654114,40.808311,
-122.664917,40.826008,-122.656082,
40.835533,-122.654259,40.841686,
-122.638397,40.845379,-122.637756,
40.853539,-122.633545,40.857189,
-122.633247,40.861423,-122.625313,
40.86721,-122.623909,40.879826,
-122.613777,40.88131,-122.606422,
40.88715,-122.603806,40.897331,
-122.598885,40.900475,-122.611626,
40.921375,-122.6063,40.929855,
-122.60601,40.938129,-122.602089,
40.940739,-122.606354,40.955742,
-122.59996,40.963993,-122.60041,
40.971668,-122.593758,40.978073,
-122.590225,40.97686,-122.588066,
40.985508,-122.579651,40.983036,
-122.568054,40.985126,-122.562744,
40.988781,-122.561897,40.993816,
-122.554298,40.999603,-122.553329,
41.003738,-122.54409,41.005196,
-122.536751,41.002518,-122.526627,
41.014523,-122.527802,41.036644,
-122.526207,41.045856,-122.521233,
41.052418,-122.522041,41.059341,
-122.526489,41.064342,-122.536819,
41.065174,-122.538651,41.072735,
-122.534737,41.076,-122.527702,
41.076881,-122.51223,41.088356,
-122.505104,41.086178,-122.498886,
41.087757,-122.492172,41.086117,
-122.46701,41.09697,-122.456017,
41.096741,-122.450737,41.10836,
-122.452347,41.113621,-122.447449,
41.118366,-122.447197,41.130833,
-122.444862,41.133476,-122.449478,
41.147064,-122.444893,41.15937,
-122.448769,41.159286,-122.456314,
41.168453,-122.461838,41.167362,
-122.467163,41.169365,-122.474815,
41.176647,-122.491417,41.176102,
-122.497627,41.179714,-122.497246,
41.182804,-122.493896,41.191795,
-122.496269,41.195702,-122.514366,
41.20512,-122.521507,41.213657,
-122.511139,41.226582,-122.516983,
41.236053,-122.516327,41.23991,
-122.507118,41.245415,-122.512817,
41.255344,-122.512802,41.266918,
-122.510384,41.269928,-122.51284,
41.280281,-122.509041,41.288792,
-122.498093,41.292179,-122.500793,
41.309242,-122.477638,41.320217,
-122.501419,41.333076,-122.502762,
41.343117,-122.518784,41.343906,
-122.534584,41.341564,-122.541595,
41.350277,-122.539307,41.353283,
-122.559921,41.366093,-122.571541,
41.368114,-122.571762,41.365829,
-122.584114,41.359138,-122.585861,
41.349831,-122.579887,41.337799,
-122.585991,41.333412,-122.587921,
41.326969,-122.597786,41.324665,
-122.604095,41.32933,-122.61676,
41.327656,-122.626335,41.332161,
-122.640991,41.32674,-122.646553,
41.322475,-122.644447,41.304867,
-122.650414,41.299728,-122.651741,
41.289867,-122.662354,41.291775,
-122.676147,41.285118,-122.677933,
41.279099,-122.681114,41.278114,
-122.686226,41.28146,-122.699135,
41.276207,-122.710823,41.274925,
-122.723465,41.261208,-122.724159,
41.247601,-122.745331,41.241024,
-122.757187,41.240936,-122.763908,
41.235317,-122.775871,41.230976,
-122.780075,41.218307,-122.785591,
41.217129,-122.787193,41.212715,
-122.794418,41.211494,-122.80098,
41.203178,-122.810204,41.202583,
-122.815704,41.207729,-122.824043,
41.210163,-122.835564,41.20686,
-122.842796,41.200359,-122.858795,
41.201664,-122.869553,41.205223,
-122.879677,41.203655,-122.884773,
41.205276,-122.905739,41.19606,
-122.9077,41.191669,-122.914223,
41.187321,-122.923698,41.186798,
-122.928032,41.178829,-122.937233,
41.178246,-122.950172,41.185715,
-122.960197,41.181664,-122.961456,
41.178009,-122.953537,41.167538,
-122.956139,41.16135,-122.950523,
41.150455,-122.951775,41.147114,
-122.956924,41.145802,-122.964203,
41.138443,-122.958794,41.12413,
-122.973099,41.10976,-122.972931,
41.105896,-122.967949,41.103497,
-122.969826,41.090298,-122.96492,
41.081039,-122.952042,41.074413,
-122.940926,41.07021,-122.922188,
41.072086,-122.908089,41.041325,
-122.896225,41.029316,-122.901276,
41.023926,-122.900383,41.014786,
-122.904716,41.00919,-122.913315,
41.007034,-122.91275,40.999157,
-122.916389,40.994129,-122.923531,
40.995808,-122.933838,40.992569,
-122.943176,40.994373,-122.950882,
41.006531,-122.958504,41.010353,
-122.978989,41.014454,-123.002594,
41.012653,-123.01091,41.006912,
-123.035973,41.004314,-123.046425,
41.024876,-123.04483,41.03363,
-123.054039,41.046844,-123.078941,
41.057705,-123.095192,41.05954,
-123.097153,41.063156,-123.104744,
41.065907,-123.107925,41.075569,
-123.14019,41.079319,-123.147575,
41.078587,-123.154449,41.074879,
-123.164093,41.078274,-123.177788,
41.075699,-123.187134,41.077732,
-123.191963,41.07753,-123.202003,
41.071903,-123.207733,41.074806,
-123.216133,41.073154,-123.224083,
41.076267,-123.238327,41.075905,
-123.244072,41.078129,-123.248207,
41.087318,-123.257256,41.0937,
-123.260223,41.105923,-123.270622,
41.11573,-123.272247,41.123035,
-123.282784,41.123596,-123.283691,
41.128605,-123.293907,41.140797,
-123.302315,41.143932,-123.309364,
41.143368,-123.314217,41.140411,
-123.323792,41.141693,-123.328453,
41.15181,-123.352081,41.1632,
-123.361076,41.161705,-123.371819,
41.152088,-123.380035,41.151436,
-123.382904,41.157883,-123.391571,
41.161358,-123.392342,41.170864,
-123.396706,41.174229,-123.402817,
41.174671,-123.407127,41.180092)),
'Trinity','06105','California','CA','06',3178.3183,13063,4.11);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-119.572083,36.488995,-119.527473,
36.488972,-119.528061,36.401653,
-119.473938,36.401005,-119.473785,
36.268978,-119.528671,36.26965,
-119.528358,36.137943,-119.535416,
36.137966,-119.537163,35.789612,
-118.625847,35.789585,-118.506302,
35.789761,-118.469177,35.792683,
-118.375,35.790276,-118.066811,
35.791588,-118.007133,35.789211,
-118.00663,35.799973,-118.009575,
35.804436,-118.006569,35.810051,
-118.006813,35.817135,-117.997696,
35.823078,-118.005287,35.829086,
-118.002007,35.841343,-118.004524,
35.843327,-118.003876,35.851315,
-118.006516,35.858231,-118.004585,
35.862751,-117.995789,35.869549,
-117.992752,35.869663,-117.989632,
35.865875,-117.980133,35.866962,
-117.981956,35.875,-117.9879,
35.879826,-117.988106,35.884167,
-117.983788,35.887775,-117.981148,
35.894749,-117.986168,35.8993,
-117.984467,35.905365,-117.988106,
35.907951,-117.98941,35.914101,
-117.982376,35.926617,-117.984474,
35.9342,-117.991035,35.943825,
-117.998352,35.946655,-118.005974,
35.946541,-118.010162,35.954655,
-118.015877,35.954609,-118.017136,
35.962444,-118.011597,35.968948,
-118.013657,35.972946,-118.008705,
35.978233,-118.003586,35.977211,
-118.002663,35.983776,-118.005325,
35.989811,-118.009758,35.991798,
-118.011169,35.99836,-118.033104,
36.009701,-118.036201,36.029202,
-118.040504,36.0299,-118.038597,
36.034302,-118.045403,36.042301,
-118.041801,36.048599,-118.047707,
36.053299,-118.046997,36.056,
-118.050797,36.059601,-118.049904,
36.080299,-118.056702,36.091702,
-118.062202,36.089298,-118.066399,
36.093498,-118.065308,36.104,
-118.067398,36.108601,-118.063705,
36.1105,-118.072701,36.139099,
-118.069397,36.144501,-118.0588,
36.150902,-118.058105,36.157902,
-118.061707,36.1623,-118.058403,
36.1702,-118.060707,36.174,
-118.069107,36.178699,-118.0728,
36.189499,-118.084999,36.197601,
-118.089798,36.197399,-118.093704,
36.205002,-118.104706,36.213501,
-118.108307,36.225601,-118.104301,
36.228699,-118.104301,36.2337,
-118.111305,36.240101,-118.118446,
36.255623,-118.11647,36.271229,
-118.121056,36.27776,-118.126686,
36.280411,-118.124107,36.286808,
-118.126091,36.300285,-118.119202,
36.302299,-118.120705,36.3069,
-118.110901,36.308399,-118.113251,
36.319324,-118.111603,36.322102,
-118.106644,36.325672,-118.102135,
36.325459,-118.096703,36.3312,
-118.100906,36.339401,-118.099403,
36.346199,-118.123306,36.352001,
-118.121597,36.354801,-118.129601,
36.370399,-118.140106,36.3717,
-118.1464,36.3792,-118.152199,
36.379601,-118.156197,36.388401,
-118.162102,36.389702,-118.159103,
36.393902,-118.145302,36.398701,
-118.139397,36.403599,-118.137001,
36.418098,-118.145935,36.424049,
-118.153305,36.4272,-118.155907,
36.432701,-118.174004,36.426601,
-118.192703,36.426601,-118.202797,
36.431301,-118.2089,36.430401,
-118.213501,36.434399,-118.208702,
36.4422,-118.213303,36.448299,
-118.214996,36.456799,-118.222305,
36.463402,-118.231705,36.4664,
-118.236107,36.4771,-118.249001,
36.482498,-118.247505,36.487099,
-118.2341,36.493801,-118.240501,
36.500099,-118.236504,36.5116,
-118.237907,36.523701,-118.245796,
36.5215,-118.248505,36.524101,
-118.25,36.5289,-118.247704,
36.533298,-118.251106,36.542198,
-118.2593,36.544201,-118.264397,
36.551601,-118.274002,36.550598,
-118.278503,36.555199,-118.290306,
36.559399,-118.291702,36.567501,
-118.288902,36.573299,-118.293198,
36.577499,-118.287102,36.583801,
-118.288101,36.590801,-118.277107,
36.5924,-118.273705,36.597401,
-118.280701,36.604599,-118.288101,
36.603401,-118.292999,36.605202,
-118.301506,36.6147,-118.301903,
36.619099,-118.308403,36.621498,
-118.310104,36.625,-118.320396,
36.627499,-118.317902,36.639,
-118.324303,36.647202,-118.336655,
36.654869,-118.334702,36.661701,
-118.328598,36.665501,-118.330307,
36.669498,-118.338997,36.672798,
-118.346603,36.672401,-118.351105,
36.682999,-118.360107,36.6861,
-118.365501,36.691299,-118.360107,
36.695202,-118.345802,36.696602,
-118.333801,36.705399,-118.338707,
36.729099,-118.349998,36.740799,
-118.359657,36.744839,-118.554558,
36.744808,-118.554108,36.739201,
-118.981506,36.741699,-118.983902,
36.6572,-119.303802,36.660702,
-119.304001,36.573601,-119.46537,
36.575287,-119.572083,36.488995)),
'Tulare','06107','California','CA','06',4823.4921,311921,64.6669);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-120.018982,38.433468,-120.028862,
38.42477,-120.039536,38.426006,
-120.048027,38.419449,-120.063316,
38.414852,-120.066887,38.415562,
-120.069244,38.413406,-120.079803,
38.410206,-120.086861,38.403481,
-120.114525,38.401299,-120.12719,
38.395916,-120.133904,38.396629,
-120.135979,38.393379,-120.140854,
38.393883,-120.156929,38.385864,
-120.160187,38.380993,-120.175461,
38.373867,-120.183777,38.35891,
-120.188515,38.35685,-120.18988,
38.350193,-120.192726,38.349049,
-120.20417,38.32972,-120.227509,
38.314751,-120.236237,38.30162,
-120.235687,38.298759,-120.245926,
38.290268,-120.255043,38.286198,
-120.261055,38.276478,-120.26976,
38.270782,-120.272987,38.264446,
-120.271423,38.259823,-120.288765,
38.245941,-120.290222,38.234093,
-120.300522,38.229816,-120.306587,
38.224506,-120.316757,38.206642,
-120.32534,38.19603,-120.329285,
38.195248,-120.331253,38.188316,
-120.334618,38.188019,-120.334496,
38.185043,-120.338615,38.183716,
-120.336243,38.178135,-120.339424,
38.1777,-120.339516,38.172028,
-120.348892,38.170265,-120.352547,
38.163879,-120.358482,38.161385,
-120.356514,38.15395,-120.369804,
38.150715,-120.37532,38.142841,
-120.370232,38.14056,-120.370346,
38.137951,-120.376572,38.135757,
-120.386909,38.115334,-120.408981,
38.102482,-120.409592,38.087952,
-120.413605,38.081985,-120.420509,
38.078827,-120.423607,38.072994,
-120.430206,38.072929,-120.430206,
38.060596,-120.43808,38.06089,
-120.441498,38.058811,-120.442383,
38.051765,-120.452888,38.041424,
-120.461075,38.022476,-120.468468,
38.018696,-120.4674,38.014412,
-120.462196,38.012852,-120.462723,
38.010468,-120.481743,38.012463,
-120.4879,38.009144,-120.491745,
38.011208,-120.499298,38.007305,
-120.498344,37.996265,-120.503487,
37.991219,-120.508171,37.991585,
-120.51252,37.995689,-120.508255,38,
-120.514381,38.00433,-120.51783,
38.0023,-120.520622,37.995235,
-120.533783,37.991253,-120.52655,
37.983021,-120.539078,37.97913,
-120.542038,37.975311,-120.526962,
37.975773,-120.525375,37.969368,
-120.514053,37.962223,-120.513931,
37.953453,-120.53421,37.944481,
-120.538986,37.935883,-120.536583,
37.926937,-120.541611,37.920254,
-120.550072,37.921753,-120.554993,
37.916256,-120.561165,37.914143,
-120.563042,37.90369,-120.569717,
37.89492,-120.586487,37.895294,
-120.59565,37.888222,-120.595406,
37.882984,-120.604263,37.876125,
-120.603706,37.873318,-120.615936,
37.870129,-120.632751,37.86068,
-120.636856,37.847893,-120.652824,
37.832355,-120.386581,37.633774,
-120.374123,37.652275,-120.393105,
37.668186,-120.391693,37.669983,
-120.394424,37.672199,-120.391487,
37.675423,-120.390907,37.683628,
-120.385605,37.684914,-120.378677,
37.681057,-120.365288,37.680862,
-120.361443,37.67289,-120.352455,
37.675079,-120.344048,37.666985,
-120.324921,37.649033,-120.311554,
37.653736,-120.308723,37.656757,
-120.311287,37.663017,-120.30529,
37.665489,-120.318436,37.686497,
-120.321579,37.687405,-120.328789,
37.697338,-120.332275,37.706833,
-120.337074,37.709179,-120.344185,
37.725735,-120.334541,37.726551,
-120.331314,37.729664,-120.325089,
37.726135,-120.32019,37.726112,
-120.314438,37.733833,-120.306664,
37.73568,-120.285469,37.729519,
-120.282784,37.733707,-120.285736,
37.739967,-120.281395,37.745453,
-120.275055,37.73904,-120.259697,
37.733631,-120.256874,37.735229,
-120.260719,37.74081,-120.256157,
37.747875,-120.252312,37.750809,
-120.244286,37.750622,-120.238464,
37.753792,-120.239891,37.758568,
-120.237206,37.765335,-120.229637,
37.763863,-120.225731,37.760406,
-120.223099,37.763706,-120.215706,
37.763161,-120.214798,37.765354,
-120.200089,37.763222,-120.196693,
37.769623,-120.187958,37.768009,
-120.182381,37.775154,-120.18766,
37.780296,-120.181793,37.783714,
-120.179436,37.788792,-120.181648,
37.795403,-120.177353,37.794731,
-120.173111,37.799683,-120.172623,
37.795723,-120.160789,37.787479,
-120.153,37.788334,-120.141121,
37.783104,-120.126221,37.781643,
-120.12323,37.785599,-120.11837,
37.785934,-120.11898,37.789646,
-120.114769,37.793236,-120.099716,
37.800739,-120.097725,37.807804,
-120.089264,37.810822,-120.089447,
37.822163,-120.084412,37.823589,
-120.084183,37.826633,-120.078491,
37.828884,-120.064133,37.822971,
-120.060547,37.826118,-120.05661,
37.824211,-120.054665,37.818214,
-120.054115,37.812866,-120.047874,
37.811272,-120.043617,37.813023,
-120.035286,37.807926,-120.030861,
37.811131,-120.024406,37.811577,
-119.997398,37.796299,-119.970802,
37.7841,-119.963905,37.782902,
-119.940704,37.764,-119.922707,
37.764099,-119.9142,37.762699,
-119.905998,37.757999,-119.9002,
37.7579,-119.899101,37.760399,
-119.893303,37.762199,-119.883904,
37.760799,-119.875,37.763901,
-119.871704,37.767601,-119.874504,
37.772598,-119.867203,37.7733,
-119.863503,37.772301,-119.859596,
37.7645,-119.851372,37.758278,
-119.840103,37.764301,-119.841202,
37.769199,-119.836906,37.770302,
-119.826904,37.768299,-119.823799,
37.762001,-119.806801,37.7551,
-119.804001,37.7565,-119.80423,
37.760197,-119.790504,37.764702,
-119.785103,37.7659,-119.780106,
37.7635,-119.771004,37.7668,
-119.767998,37.771198,-119.761398,
37.770401,-119.75,37.773399,
-119.745003,37.783001,-119.732903,
37.787998,-119.721703,37.787701,
-119.708801,37.793598,-119.698601,
37.7892,-119.688705,37.800301,
-119.666199,37.8013,-119.658905,
37.809502,-119.652901,37.810501,
-119.649902,37.8209,-119.656708,
37.834202,-119.647598,37.8451,
-119.6371,37.849201,-119.623985,
37.847794,-119.618103,37.853271,
-119.608604,37.853447,-119.59687,
37.86105,-119.583862,37.875,
-119.586304,37.878799,-119.585907,
37.887901,-119.580597,37.893799,
-119.573105,37.895699,-119.561996,
37.902599,-119.557602,37.903198,
-119.555702,37.901001,-119.534706,
37.904202,-119.528801,37.891201,
-119.522797,37.886799,-119.514305,
37.884499,-119.5028,37.868698,
-119.491302,37.863201,-119.483101,
37.864498,-119.473305,37.855701,
-119.469307,37.863098,-119.4618,
37.8685,-119.4505,37.871101,
-119.441002,37.867599,-119.441704,
37.859901,-119.433197,37.8652,
-119.425797,37.866798,-119.420998,
37.8578,-119.414505,37.854698,
-119.406303,37.855,-119.401703,
37.8353,-119.391602,37.838001,
-119.382736,37.836548,-119.378769,
37.840992,-119.374519,37.840946,
-119.371613,37.832958,-119.350403,
37.8256,-119.353996,37.811901,
-119.348,37.810902,-119.344902,
37.805698,-119.338402,37.805599,
-119.330902,37.799301,-119.325996,
37.7995,-119.320801,37.794102,
-119.310204,37.793598,-119.309502,
37.785702,-119.306305,37.782902,
-119.309998,37.7798,-119.308006,
37.778061,-119.307304,37.775799,
-119.292397,37.768002,-119.293106,
37.7598,-119.288101,37.7551,
-119.289703,37.749401,-119.287399,
37.745098,-119.267998,37.7393,
-119.260201,37.7411,-119.254906,
37.745098,-119.253998,37.756401,
-119.249199,37.757511,-119.242104,
37.769199,-119.235603,37.773701,
-119.229797,37.774502,-119.228203,
37.777699,-119.220306,37.779202,
-119.214302,37.790001,-119.202301,
37.794998,-119.200302,37.804401,
-119.204002,37.8116,-119.215904,
37.818802,-119.212303,37.8251,
-119.203003,37.829899,-119.205902,
37.84,-119.195198,37.844101,
-119.200798,37.847599,-119.209503,
37.845699,-119.215904,37.849701,
-119.211601,37.856998,-119.212303,
37.873402,-119.205399,37.883598,
-119.199104,37.884602,-119.200401,
37.8881,-119.2061,37.8895,
-119.209702,37.894001,-119.209801,
37.899502,-119.218903,37.898701,
-119.2257,37.9067,-119.233505,
37.9104,-119.262901,37.9123,
-119.264702,37.915199,-119.263,
37.926601,-119.279602,37.933899,
-119.286903,37.933102,-119.294907,
37.942799,-119.307404,37.946899,
-119.312904,37.954399,-119.314301,
37.965401,-119.321602,37.9711,
-119.313705,37.981201,-119.317398,
37.9865,-119.308014,38.006596,
-119.307159,38.019573,-119.303596,
38.023968,-119.307869,38.033245,
-119.312958,38.034611,-119.310204,
38.044834,-119.321655,38.049946,
-119.323227,38.061016,-119.326935,
38.065784,-119.334846,38.066364,
-119.344925,38.083191,-119.348854,
38.085644,-119.356133,38.083057,
-119.364075,38.090279,-119.370064,
38.088676,-119.373558,38.093605,
-119.379234,38.092628,-119.381859,
38.097782,-119.388885,38.099213,
-119.396034,38.106899,-119.401512,
38.105633,-119.411629,38.107941,
-119.422958,38.107521,-119.42955,
38.116352,-119.440559,38.102764,
-119.439468,38.09576,-119.444878,
38.09314,-119.448349,38.099644,
-119.453384,38.096149,-119.458809,
38.096359,-119.462692,38.098415,
-119.463501,38.103672,-119.456451,
38.110634,-119.46109,38.109188,
-119.47184,38.117046,-119.468452,
38.128365,-119.487518,38.132256,
-119.488129,38.14352,-119.495972,
38.14938,-119.495491,38.156734,
-119.50193,38.159111,-119.506783,
38.152721,-119.505486,38.137196,
-119.514526,38.137436,-119.530159,
38.144569,-119.545815,38.143353,
-119.545944,38.154503,-119.562843,
38.154079,-119.565651,38.157288,
-119.575493,38.157745,-119.580345,
38.172588,-119.577591,38.176937,
-119.584625,38.18446,-119.591263,
38.185135,-119.59742,38.181782,
-119.604637,38.188496,-119.618477,
38.191147,-119.63166,38.198944,
-119.629921,38.204025,-119.624016,
38.206966,-119.626099,38.213284,
-119.625664,38.219444,-119.622505,
38.220482,-119.623413,38.22876,
-119.603188,38.235046,-119.603897,
38.239285,-119.613014,38.242889,
-119.620697,38.252029,-119.611938,
38.259193,-119.612198,38.261505,
-119.629189,38.268787,-119.636757,
38.278473,-119.641823,38.278538,
-119.650505,38.286549,-119.641472,
38.293926,-119.643341,38.299686,
-119.64135,38.315697,-119.644173,
38.320663,-119.638199,38.326969,
-119.668518,38.348381,-119.69902,
38.365303,-119.692619,38.378986,
-119.697495,38.409313,-119.708694,
38.417679,-119.75,38.417221,
-119.769554,38.406754,-119.778877,
38.407803,-119.783478,38.404953,
-119.800659,38.401512,-119.813683,
38.387604,-119.836533,38.3825,
-119.853966,38.372566,-119.86898,
38.367584,-119.883736,38.356274,
-120.018982,38.433468)),'Tuolumne',
'06109','California','CA','06',2235.2656,48456,21.6779);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2007,8265,null,
MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,29,1003,1,65,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-119.389618,34.002827,-119.376953,
34.010822,-119.356071,34.015938,
-119.36451,34.017487,-119.390945,
34.006161,-119.407158,34.00705,
-119.420486,34.015266,-119.433372,
34.015938,-119.442253,34.014381,
-119.436928,34.009716,-119.420486,
34.004383,-119.410721,34.005714,
-119.395607,34.002609,-119.389618,
34.002827,-119.454033,33.214848,
-119.438217,33.218929,-119.421379,
33.228622,-119.43515,33.2327,
-119.460663,33.256683,-119.502495,
33.270458,-119.52494,33.283722,
-119.534637,33.28474,-119.549438,
33.280151,-119.552597,33.276299,
-119.558624,33.271477,-119.578011,
33.278111,-119.572403,33.258213,
-119.564743,33.245968,-119.538719,
33.230659,-119.511681,33.221989,
-119.475456,33.213825,-119.454033,
33.214848,-119.441399,34.901299,
-119.440521,34.451828,-119.442307,
34.449524,-119.439423,34.44199,
-119.444046,34.429489,-119.452057,
34.428947,-119.453552,34.421707,
-119.453415,34.418472,-119.444397,
34.408901,-119.444824,34.404266,
-119.450706,34.396999,-119.467506,
34.388599,-119.472397,34.379299,
-119.476707,34.379799,-119.4757,
34.373199,-119.470421,34.37624,
-119.458557,34.373867,-119.441956,
34.354885,-119.422966,34.348557,
-119.398438,34.33036,-119.388954,
34.315331,-119.37075,34.318497,
-119.351768,34.306629,-119.335953,
34.288437,-119.301933,34.27103,
-119.292442,34.274197,-119.278992,
34.267075,-119.264755,34.2299,
-119.247353,34.196674,-119.22995,
34.166615,-119.214127,34.145256,
-119.201469,34.142883,-119.183281,
34.134972,-119.127907,34.100166,
-119.109711,34.093842,-119.099434,
34.098583,-119.087563,34.097004,
-119.051971,34.082764,-119.036934,
34.082764,-119.003716,34.064571,
-118.99501,34.065361,-118.943748,
34.04583,-118.939873,34.074959,
-118.787773,34.16851,-118.667038,
34.168095,-118.666626,34.240398,
-118.63163,34.240208,-118.631409,
34.26387,-118.635681,34.291729,
-118.880966,34.790642,-118.975792,
34.79068,-118.975784,34.812222,
-119.242706,34.814201,-119.242706,
34.857601,-119.277397,34.8573,
-119.276001,34.8797,-119.3815,
34.8797,-119.381203,34.900963,
-119.441399,34.901299)),'Ventura',
'06111','California','CA','06',1845.6308,669016,362.486);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-122.339088,38.924347,-122.402946,
38.925392,-122.420959,38.900993,
-122.414467,38.897202,-122.404175,
38.883503,-122.404579,38.879967,
-122.390114,38.868816,-122.393967,
38.864349,-122.384094,38.852577,
-122.348877,38.835857,-122.340996,
38.842175,-122.328674,38.842464,
-122.32296,38.846352,-122.31427,
38.839569,-122.301918,38.842495,
-122.300766,38.83971,-122.286911,
38.840031,-122.272896,38.809536,
-122.258179,38.789616,-122.249023,
38.75536,-122.240402,38.743248,
-122.234047,38.740318,-122.225441,
38.727104,-122.223938,38.72163,
-122.227325,38.720718,-122.221954,
38.704609,-122.223122,38.700081,
-122.220558,38.696114,-122.213539,
38.693504,-122.211487,38.696049,
-122.207123,38.695633,-122.198639,
38.683407,-122.202339,38.67728,
-122.19725,38.669296,-122.182159,
38.65723,-122.175041,38.658833,
-122.167213,38.655392,-122.161247,
38.644192,-122.163933,38.642529,
-122.164864,38.64035,-122.160126,
38.635201,-122.169296,38.629921,
-122.167267,38.619392,-122.164879,
38.617775,-122.159843,38.619392,
-122.150383,38.625343,-122.143326,
38.612305,-122.138306,38.609264,
-122.127907,38.58709,-122.127998,
38.580994,-122.112946,38.537983,
-122.114098,38.534481,-122.110558,
38.530735,-122.111649,38.526718,
-122.102211,38.513374,-122.093758,
38.512928,-122.090462,38.516014,
-122.070976,38.513695,-122.05603,
38.517391,-122.040703,38.50589,
-122.03112,38.495007,-122.019455,
38.490047,-122.01104,38.488991,
-121.998291,38.496288,-121.994591,
38.500862,-121.982193,38.505791,
-121.982834,38.507248,-121.977699,
38.509247,-121.975777,38.515167,
-121.964516,38.523216,-121.947517,
38.527744,-121.941345,38.53373,
-121.924561,38.530094,-121.908989,
38.529903,-121.892723,38.534016,
-121.884995,38.539295,-121.871521,
38.539089,-121.866943,38.537006,
-121.858833,38.539009,-121.839745,
38.534431,-121.831726,38.530354,
-121.812851,38.526577,-121.795502,
38.528,-121.785202,38.523499,
-121.778,38.530701,-121.770103,
38.533001,-121.764931,38.525921,
-121.748718,38.530785,-121.741241,
38.540295,-121.721703,38.535301,
-121.709824,38.537521,-121.699661,
38.527519,-121.693695,38.527119,
-121.69326,38.313808,-121.591827,
38.313152,-121.583008,38.3316,
-121.574112,38.327263,-121.558289,
38.342655,-121.536163,38.347679,
-121.520576,38.360191,-121.523201,
38.3792,-121.513763,38.38728,
-121.512192,38.398911,-121.531532,
38.431553,-121.527374,38.434639,
-121.51429,38.434608,-121.505524,
38.437374,-121.501266,38.441982,
-121.499969,38.450226,-121.504105,
38.469898,-121.507797,38.4729,
-121.537704,38.4748,-121.546402,
38.4813,-121.558105,38.4981,
-121.550797,38.513901,-121.524109,
38.519054,-121.524506,38.523201,
-121.529701,38.528,-121.527397,
38.5322,-121.511551,38.541759,
-121.510223,38.546383,-121.519905,
38.566299,-121.507202,38.580601,
-121.505203,38.586399,-121.507599,
38.596901,-121.514702,38.602798,
-121.526604,38.604698,-121.538002,
38.602001,-121.543503,38.597801,
-121.548798,38.599499,-121.557198,
38.608299,-121.565804,38.645199,
-121.574997,38.648701,-121.586105,
38.642799,-121.593002,38.644199,
-121.630852,38.680737,-121.633057,
38.689121,-121.631378,38.695137,
-121.606544,38.715664,-121.601822,
38.735935,-121.592339,38.754086,
-121.59214,38.764416,-121.60379,
38.779457,-121.623039,38.785278,
-121.630508,38.782784,-121.626846,
38.77784,-121.630592,38.77536,
-121.633186,38.766991,-121.639328,
38.772865,-121.645088,38.774178,
-121.647392,38.772785,-121.637825,
38.767632,-121.640221,38.766254,
-121.652641,38.764385,-121.656982,
38.768936,-121.662621,38.768082,
-121.65699,38.754738,-121.663635,
38.75568,-121.667107,38.753616,
-121.669357,38.743839,-121.671967,
38.742943,-121.674431,38.745361,
-121.674461,38.75288,-121.668945,
38.759407,-121.675583,38.760288,
-121.679825,38.763729,-121.686157,
38.763809,-121.69146,38.767776,
-121.685577,38.77544,-121.692299,
38.789921,-121.689598,38.795727,
-121.694771,38.796806,-121.700172,
38.803127,-121.707039,38.801105,
-121.722275,38.803856,-121.722359,
38.825703,-121.729805,38.835838,
-121.728607,38.83968,-121.724991,
38.841103,-121.727608,38.846172,
-121.722382,38.852417,-121.727089,
38.853508,-121.729469,38.859104,
-121.743729,38.864258,-121.747597,
38.871326,-121.75882,38.86787,
-121.757362,38.86245,-121.765121,
38.863888,-121.776993,38.860832,
-121.782814,38.856544,-121.785629,
38.863762,-121.790909,38.862705,
-121.795486,38.866657,-121.801437,
38.864609,-121.802925,38.870079,
-121.813828,38.876625,-121.816162,
38.882977,-121.805695,38.890415,
-121.802017,38.897518,-121.80291,
38.901825,-121.792511,38.900818,
-121.790436,38.905502,-121.809135,
38.907951,-121.814178,38.911312,
-121.804771,38.910896,-121.804451,
38.915169,-121.827843,38.918575,
-121.83474,38.924576,-122.085938,
38.926144,-122.339088,38.924347)),
'Yolo','06113','California','CA','06',1012.2626,141092,139.3826);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-121.07563,39.597378,-121.078484,
39.585373,-121.1064,39.585388,
-121.105904,39.567303,-121.115273,
39.567215,-121.115395,39.563656,
-121.140144,39.562389,-121.139824,
39.555664,-121.148849,39.555412,
-121.148842,39.526554,-121.157951,
39.52623,-121.158226,39.519707,
-121.184326,39.51984,-121.184174,
39.526863,-121.208931,39.527348,
-121.239471,39.526703,-121.239105,
39.513283,-121.276215,39.512871,
-121.275681,39.520515,-121.304047,
39.519699,-121.304352,39.497929,
-121.309128,39.497875,-121.309074,
39.486931,-121.313904,39.487072,
-121.313713,39.476013,-121.322845,
39.475822,-121.322952,39.468761,
-121.332352,39.468952,-121.332367,
39.465202,-121.337189,39.465099,
-121.337349,39.454411,-121.344048,
39.452682,-121.344276,39.439091,
-121.339668,39.431816,-121.334427,
39.430584,-121.332916,39.425892,
-121.350143,39.416046,-121.361992,
39.404285,-121.358864,39.399113,
-121.366013,39.37822,-121.371429,
39.373669,-121.371338,39.365021,
-121.381256,39.363121,-121.386566,
39.355911,-121.402069,39.349651,
-121.402138,39.345531,-121.405846,
39.344524,-121.405472,39.340176,
-121.414574,39.340137,-121.425186,
39.335079,-121.433693,39.337528,
-121.445839,39.330597,-121.456451,
39.33551,-121.462013,39.33112,
-121.468414,39.333557,-121.473885,
39.33345,-121.476685,39.329056,
-121.483017,39.326241,-121.48304,
39.318115,-121.493683,39.319164,
-121.496941,39.314526,-121.503372,
39.318268,-121.52948,39.318371,
-121.535347,39.31432,-121.546036,
39.312286,-121.547653,39.308876,
-121.562614,39.305058,-121.574615,
39.310947,-121.58419,39.311684,
-121.59314,39.307938,-121.601173,
39.31155,-121.603127,39.318138,
-121.610107,39.319397,-121.619675,
39.303394,-121.617165,39.301174,
-121.622772,39.295872,-121.624481,
39.292656,-121.630592,39.29166,
-121.626259,39.279526,-121.621086,
39.273441,-121.625,39.271629,
-121.629852,39.273533,-121.631592,
39.271084,-121.627708,39.266689,
-121.620338,39.263817,-121.626007,
39.259506,-121.634842,39.26207,
-121.635368,39.246178,-121.634041,
39.240589,-121.627335,39.236366,
-121.626633,39.22871,-121.613235,
39.228855,-121.616943,39.220325,
-121.612549,39.21397,-121.619209,
39.2136,-121.620041,39.206261,
-121.623833,39.207031,-121.628014,
39.204784,-121.622604,39.19585,
-121.61412,39.193481,-121.611961,
39.190582,-121.617378,39.183182,
-121.61541,39.178783,-121.610077,
39.175816,-121.614532,39.167934,
-121.604401,39.1502,-121.606506,
39.140999,-121.596603,39.127899,
-121.602882,39.11552,-121.601128,
39.100445,-121.594879,39.099552,
-121.590485,39.102695,-121.587074,
39.102024,-121.584908,39.089771,
-121.609062,39.057961,-121.607101,
39.03896,-121.604561,39.032738,
-121.593338,39.023144,-121.598961,
39.012211,-121.578255,39.007679,
-121.588333,38.99044,-121.586296,
38.973473,-121.580109,38.965336,
-121.58152,38.955807,-121.576897,
38.946873,-121.580727,38.93882,
-121.580063,38.925858,-121.574341,
38.918453,-121.570221,38.939034,
-121.560402,38.953548,-121.552437,
38.953869,-121.542397,38.972553,
-121.523575,38.971581,-121.507965,
38.982899,-121.492622,38.984409,
-121.488579,38.992157,-121.486137,
38.990749,-121.480988,38.993607,
-121.474007,38.992149,-121.455246,
38.998295,-121.447533,38.997173,
-121.442757,38.993431,-121.440887,
38.994968,-121.436455,38.993736,
-121.425301,38.996479,-121.425537,
38.998077,-121.413834,39.002769,
-121.405708,39.003864,-121.404938,
39.006523,-121.383476,39.014599,
-121.384026,39.017822,-121.376007,
39.021118,-121.371315,39.027836,
-121.364578,39.031849,-121.352798,
39.03141,-121.334679,39.038895,
-121.328049,39.044003,-121.321945,
39.043114,-121.318398,39.04884,
-121.308098,39.052666,-121.303429,
39.05257,-121.301277,39.047935,
-121.292648,39.04443,-121.289154,
39.036976,-121.278473,39.034725,
-121.278465,39.230598,-121.275009,
39.231525,-121.267723,39.24036,
-121.268234,39.252232,-121.25811,
39.256527,-121.265366,39.268692,
-121.26506,39.272823,-121.241501,
39.283604,-121.222809,39.282547,
-121.217316,39.28429,-121.213821,
39.292988,-121.199081,39.302483,
-121.203911,39.307995,-121.205269,
39.316563,-121.194534,39.32959,
-121.183731,39.330753,-121.181786,
39.336632,-121.175621,39.338741,
-121.164253,39.338669,-121.1614,
39.332558,-121.156204,39.332718,
-121.153694,39.348732,-121.142593,
39.349987,-121.144058,39.355934,
-121.136414,39.363049,-121.133202,
39.371651,-121.126183,39.37265,
-121.126854,39.380047,-121.115303,
39.378727,-121.10997,39.381386,
-121.099998,39.38118,-121.095322,
39.387749,-121.085854,39.386425,
-121.082764,39.394798,-121.061684,
39.391186,-121.058228,39.39521,
-121.048729,39.395557,-121.046135,
39.389584,-121.040955,39.388302,
-121.033073,39.395618,-121.030426,
39.395596,-121.024406,39.389416,
-121.021095,39.391399,-121.033356,
39.514729,-121.044037,39.514378,
-121.048355,39.517765,-121.04879,
39.521172,-121.052544,39.522366,
-121.050095,39.524765,-121.057098,
39.536983,-121.055946,39.540531,
-121.050117,39.542156,-121.046982,
39.548534,-121.037979,39.55048,
-121.030586,39.558414,-121.023323,
39.559155,-121.008408,39.639713,
-121.07563,39.597378)),'Yuba',
'06115','California','CA','06',630.3437,58228,92.3749);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.529663,29.940971,-82.530373,
29.932632,-82.539536,29.928852,
-82.541901,29.925552,-82.548508,
29.925484,-82.550949,29.92844,
-82.554657,29.928465,-82.561157,
29.924522,-82.561317,29.921864,
-82.566574,29.920671,-82.567863,
29.917372,-82.571922,29.918219,
-82.579124,29.91485,-82.576118,
29.913097,-82.576035,29.894629,
-82.5802,29.894615,-82.580162,
29.887411,-82.592712,29.887278,
-82.592506,29.872984,-82.589691,
29.872763,-82.586502,29.866667,
-82.591217,29.865999,-82.593025,
29.861759,-82.602509,29.857656,
-82.606453,29.852842,-82.610977,
29.851969,-82.616554,29.857788,
-82.620346,29.85845,-82.622993,
29.853018,-82.618149,29.850384,
-82.617783,29.8472,-82.631065,
29.849239,-82.630699,29.842892,
-82.634674,29.839434,-82.634651,
29.834232,-82.641479,29.827404,
-82.652069,29.82585,-82.655098,
29.829424,-82.658745,29.83,
-82.656601,29.564573,-82.656494,
29.535378,-82.556671,29.537313,
-82.556892,29.479916,-82.496506,
29.478127,-82.496414,29.485254,
-82.406792,29.484802,-82.212021,
29.48386,-82.210365,29.481155,
-82.214745,29.47673,-82.210396,
29.473499,-82.211861,29.471298,
-82.208458,29.470474,-82.207985,
29.466417,-82.205521,29.466692,
-82.2062,29.472034,-82.203239,
29.471714,-82.201981,29.469421,
-82.199783,29.470362,-82.201859,
29.468021,-82.188232,29.460094,
-82.190514,29.45952,-82.188622,
29.454752,-82.192078,29.452299,
-82.199402,29.456285,-82.19487,
29.457813,-82.193634,29.461189,
-82.196266,29.462467,-82.204369,
29.46032,-82.212906,29.465376,
-82.21196,29.46376,-82.217957,
29.455959,-82.21196,29.44824,
-82.213654,29.43302,-82.211327,
29.429443,-82.202423,29.426512,
-82.198868,29.421814,-82.197289,
29.42296,-82.192818,29.420828,
-82.178291,29.422363,-82.176109,
29.420597,-82.171608,29.424885,
-82.167343,29.42454,-82.167549,
29.426878,-82.156265,29.422064,
-82.156364,29.425615,-82.153336,
29.422544,-82.150894,29.426416,
-82.151711,29.421879,-82.148415,
29.416996,-82.14064,29.419905,
-82.145287,29.423441,-82.134735,
29.434732,-82.126968,29.432758,
-82.125,29.428757,-82.119102,
29.428333,-82.116913,29.432116,
-82.101303,29.438049,-82.095848,
29.42985,-82.098907,29.42701,-82.097,
29.421585,-82.099609,29.422239,
-82.099403,29.418535,-82.095718,
29.420158,-82.09465,29.429947,
-82.091759,29.428371,-82.090248,
29.430487,-82.08831,29.425949,
-82.086662,29.426416,-82.087799,
29.435455,-82.0811,29.440102,
-82.070671,29.433996,-82.07148,
29.443018,-82.067345,29.44355,
-82.064201,29.439327,-82.057205,
29.439533,-82.056084,29.47139,
-82.056282,29.656824,-82.049316,
29.713051,-82.054634,29.718424,
-82.050026,29.732027,-82.050896,
29.735054,-82.054909,29.736177,
-82.057571,29.745461,-82.055405,
29.747227,-82.056274,29.75038,
-82.05954,29.748762,-82.074898,
29.760691,-82.087906,29.760298,
-82.079994,29.767267,-82.078865,
29.774832,-82.08197,29.77804,
-82.0924,29.778933,-82.093819,
29.781384,-82.09742,29.780649,
-82.10273,29.783628,-82.109306,
29.782843,-82.109062,29.79047,
-82.117729,29.790352,-82.117775,
29.797947,-82.121872,29.801611,
-82.121849,29.80509,-82.124229,
29.805046,-82.1241,29.823444,
-82.130302,29.823433,-82.130341,
29.830584,-82.133301,29.830584,
-82.133301,29.835709,-82.146736,
29.835653,-82.146736,29.838472,
-82.163864,29.839399,-82.173698,
29.836994,-82.192047,29.848248,
-82.198357,29.84811,-82.208687,
29.843822,-82.233681,29.845058,
-82.233826,29.848745,-82.238358,
29.848799,-82.241135,29.85211,
-82.254791,29.849474,-82.260345,
29.846336,-82.265518,29.8473,
-82.272957,29.842789,-82.28064,
29.844164,-82.29612,29.852304,
-82.305199,29.852896,-82.305382,
29.859715,-82.314095,29.859724,
-82.314346,29.867365,-82.323914,
29.867567,-82.33551,29.878567,
-82.345589,29.876406,-82.35405,
29.878559,-82.358543,29.877298,
-82.363014,29.881399,-82.374222,
29.878988,-82.37928,29.880552,
-82.379509,29.882454,-82.388374,
29.881334,-82.389557,29.884428,
-82.397713,29.885805,-82.40123,
29.889772,-82.404991,29.896214,
-82.406189,29.912714,-82.409958,
29.914595,-82.408798,29.916473,
-82.413086,29.921885,-82.418953,
29.922892,-82.422852,29.919777,
-82.433815,29.929266,-82.435181,
29.928097,-82.439102,29.93096,
-82.441757,29.928923,-82.447266,
29.931694,-82.452209,29.925528,
-82.461517,29.931416,-82.463493,
29.928459,-82.469177,29.928114,
-82.470177,29.92557,-82.477257,
29.931849,-82.477623,29.934666,
-82.484337,29.936453,-82.484337,
29.939407,-82.499199,29.938555,
-82.50164,29.941788,-82.510483,
29.944908,-82.522057,29.943171,
-82.524239,29.945143,-82.529663,
29.940971)),'Alachua','12001',
'Florida','FL','12',874.1489,181596,207.7402);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.459694,30.584051,-82.45723,
30.442532,-82.458549,30.136213,
-82.359543,30.139057,-82.359558,
30.140806,-82.142815,30.142879,
-82.049591,30.142899,-82.049583,
30.186695,-82.049408,30.273195,
-82.05024,30.362104,-82.058235,
30.358906,-82.062607,30.360313,
-82.065987,30.355408,-82.072395,
30.361221,-82.081268,30.35857,
-82.094856,30.360546,-82.09903,
30.363905,-82.101135,30.362467,
-82.101585,30.366322,-82.105324,
30.368647,-82.110283,30.36499,
-82.115608,30.367912,-82.11834,
30.364159,-82.126747,30.368057,
-82.129204,30.366821,-82.1278,
30.36517,-82.134361,30.361872,
-82.140038,30.36474,-82.148659,
30.3608,-82.158089,30.359795,
-82.162025,30.356884,-82.167839,
30.359842,-82.170219,30.358696,
-82.174149,30.364908,-82.18132,
30.368345,-82.180611,30.372126,
-82.18396,30.373478,-82.185097,
30.378662,-82.19001,30.375706,
-82.193108,30.378546,-82.192093,
30.384415,-82.194527,30.388884,
-82.199608,30.389502,-82.198311,
30.39138,-82.205032,30.402451,
-82.204048,30.405199,-82.206963,
30.406208,-82.207649,30.420624,
-82.211143,30.42477,-82.21003,
30.432587,-82.206703,30.435314,
-82.20768,30.438889,-82.20414,
30.444277,-82.204742,30.45491,
-82.207687,30.456696,-82.20787,
30.460272,-82.201759,30.476522,
-82.202003,30.485666,-82.212479,30.5,
-82.227097,30.51005,-82.230537,
30.517109,-82.230911,30.526527,
-82.240524,30.537432,-82.239288,
30.544882,-82.234528,30.549284,
-82.234451,30.557627,-82.224281,
30.564802,-82.217186,30.565262,
-82.214996,30.568359,-82.419044,
30.58152,-82.459694,30.584051)),
'Baker','12003','Florida','FL','12',585.1494,18486,31.5919);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-85.435112,30.567474,-85.486137,
30.567299,-85.487839,30.43679,
-85.853706,30.440535,-85.860825,
30.43721,-85.864075,30.428041,
-85.870361,30.419764,-85.883987,
30.410254,-85.898209,30.410751,
-85.901749,30.407089,-85.90818,
30.40579,-85.924126,30.415939,
-85.940247,30.408373,-85.945633,
30.408016,-85.952301,30.412127,
-85.965248,30.410183,-85.964317,
30.407381,-85.972755,30.402229,
-85.976448,30.398338,-85.975815,
30.395901,-85.98233,30.391762,
-85.992676,30.389288,-85.994301,
30.301294,-85.996368,30.269203,
-85.995796,30.26899,-85.922661,
30.237823,-85.829094,30.188431,
-85.786446,30.163263,-85.755836,
30.141159,-85.729805,30.116598,
-85.711754,30.10441,-85.645401,
30.073715,-85.621025,30.0683,
-85.617867,30.064238,-85.598915,
30.055662,-85.586273,30.046635,
-85.580856,30.035801,-85.548355,
30.001495,-85.51992,29.977573,
-85.493286,29.962679,-85.469818,
29.95681,-85.459885,29.958164,
-85.424225,29.948687,-85.397141,
29.932436,-85.388962,29.924164,
-85.388641,29.924295,-85.3918,
30.000656,-85.389702,30.201208,
-85.384209,30.566652,-85.435112,
30.567474)),'Bay','12005','Florida',
'FL','12',763.6118,126994,166.3068);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.142815,30.142879,-82.146126,
30.132687,-82.144897,30.131334,
-82.141144,30.132868,-82.138168,
30.12826,-82.141899,30.117676,
-82.146904,30.110298,-82.170242,
30.098955,-82.180466,30.07024,
-82.208206,30.052177,-82.213493,
30.044062,-82.216766,30.045094,
-82.220741,30.037849,-82.226456,
30.033541,-82.24131,30.029247,
-82.25985,30.028128,-82.263283,
30.02107,-82.265671,30.020428,
-82.266258,30.012407,-82.27269,
30.005281,-82.273582,29.998682,
-82.279465,29.988529,-82.29068,
29.978767,-82.292206,29.97352,
-82.301025,29.967104,-82.307083,
29.956194,-82.313423,29.954453,
-82.321999,29.955368,-82.322243,
29.95381,-82.326424,29.954704,
-82.32534,29.956217,-82.327736,
29.957958,-82.341606,29.961393,
-82.345299,29.956556,-82.344238,
29.951241,-82.346916,29.942644,
-82.358253,29.933451,-82.371124,
29.935072,-82.389961,29.925682,
-82.409538,29.926809,-82.416397,
29.925779,-82.418953,29.922892,
-82.413086,29.921885,-82.408798,
29.916473,-82.409958,29.914595,
-82.406189,29.912714,-82.404991,
29.896214,-82.40123,29.889772,
-82.397713,29.885805,-82.389557,
29.884428,-82.388374,29.881334,
-82.379509,29.882454,-82.37928,
29.880552,-82.374222,29.878988,
-82.363014,29.881399,-82.358543,
29.877298,-82.35405,29.878559,
-82.345589,29.876406,-82.33551,
29.878567,-82.323914,29.867567,
-82.314346,29.867365,-82.314095,
29.859724,-82.305382,29.859715,
-82.305199,29.852896,-82.29612,
29.852304,-82.28064,29.844164,
-82.272957,29.842789,-82.265518,
29.8473,-82.260345,29.846336,
-82.254791,29.849474,-82.241135,
29.85211,-82.238358,29.848799,
-82.233826,29.848745,-82.233681,
29.845058,-82.208687,29.843822,
-82.198357,29.84811,-82.192047,
29.848248,-82.173698,29.836994,
-82.163864,29.839399,-82.146736,
29.838472,-82.146736,29.835653,
-82.133301,29.835709,-82.133301,
29.830584,-82.130341,29.830584,
-82.130302,29.823433,-82.1241,
29.823444,-82.124229,29.805046,
-82.121849,29.80509,-82.121872,
29.801611,-82.117775,29.797947,
-82.117729,29.790352,-82.109062,
29.79047,-82.109306,29.782843,
-82.10273,29.783628,-82.09742,
29.780649,-82.093819,29.781384,
-82.0924,29.778933,-82.08197,
29.77804,-82.078865,29.774832,
-82.079994,29.767267,-82.087906,
29.760298,-82.074898,29.760691,
-82.05954,29.748762,-82.056274,
29.75038,-82.055405,29.747227,
-82.057571,29.745461,-82.054909,
29.736177,-82.050896,29.735054,
-82.050026,29.732027,-82.054634,
29.718424,-82.049423,29.718426,
-82.046288,29.746885,-82.049591,
30.142899,-82.142815,30.142879)),
'Bradford','12007','Florida','FL','12',293.101,22515,76.8164);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-80.987473,28.612722,-80.975899,
28.608028,-80.971466,28.61132,
-80.968536,28.605503,-80.960609,
28.605295,-80.957977,28.601994,
-80.956635,28.604107,-80.951935,
28.604313,-80.953156,28.600147,
-80.949448,28.600195,-80.946663,
28.596581,-80.947891,28.595158,
-80.943565,28.593157,-80.947479,
28.58445,-80.940735,28.577732,
-80.939613,28.572174,-80.936111,
28.570829,-80.930313,28.563145,
-80.93425,28.558792,-80.931587,
28.556643,-80.934059,28.554235,
-80.934357,28.546431,-80.932014,
28.54224,-80.934364,28.540268,
-80.939407,28.541473,-80.939674,
28.535164,-80.936325,28.536566,
-80.934509,28.533293,-80.932175,
28.535212,-80.928375,28.532436,
-80.923729,28.532509,-80.920097,
28.524097,-80.916412,28.522587,
-80.912155,28.524355,-80.910706,
28.523195,-80.912674,28.522724,
-80.907295,28.519947,-80.906403,
28.511047,-80.896126,28.509167,
-80.892143,28.51181,-80.885345,
28.509319,-80.879807,28.498653,
-80.884132,28.494816,-80.882507,
28.49119,-80.875877,28.489155,
-80.878395,28.486265,-80.873619,
28.48147,-80.874359,28.476105,
-80.87114,28.471445,-80.874992,
28.469158,-80.876259,28.470642,
-80.881142,28.468281,-80.88678,
28.469536,-80.89006,28.466555,
-80.890999,28.468237,-80.89489,
28.46669,-80.893074,28.464214,
-80.896126,28.463011,-80.894272,
28.458887,-80.898323,28.456818,
-80.897438,28.453175,-80.890701,
28.445282,-80.894409,28.443188,
-80.89463,28.4375,-80.901398,
28.432878,-80.896996,28.427528,
-80.898918,28.425856,-80.895973,
28.422838,-80.896591,28.418219,
-80.888237,28.415403,-80.883133,
28.407393,-80.886711,28.403851,
-80.884727,28.395844,-80.887009,
28.396261,-80.889931,28.392582,
-80.888695,28.385302,-80.879822,
28.380138,-80.882256,28.374622,
-80.879509,28.372112,-80.875801,
28.373142,-80.872917,28.36993,
-80.873131,28.359215,-80.863129,
28.347204,-80.863098,28.084564,
-80.869537,28.084583,-80.869095,
27.822218,-80.5093,27.821756,
-80.507561,27.827686,-80.497047,
27.838221,-80.495018,27.850636,
-80.49131,27.854301,-80.454865,
27.854357,-80.447311,27.860455,
-80.446709,27.86046,-80.44725,
27.861504,-80.492958,27.940805,
-80.532761,28.017076,-80.560104,
28.077702,-80.574844,28.121208,
-80.594505,28.197599,-80.6063,
28.273102,-80.607803,28.312801,
-80.6036,28.363703,-80.591599,28.403,
-80.569611,28.432343,-80.563103,
28.4375,-80.531136,28.449114,
-80.526962,28.451426,-80.525124,
28.456884,-80.561203,28.530275,
-80.567535,28.561506,-80.575821,
28.58622,-80.617027,28.634291,
-80.644402,28.673409,-80.703888,
28.748066,-80.731941,28.790306,
-80.968117,28.78993,-80.964622,
28.613131,-80.987473,28.612722)),
'Brevard','12009','Florida','FL','12',1018.3188,398978,391.8002);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-80.881447,26.33345,-80.880028,
26.259096,-80.873161,25.979065,
-80.68026,25.978378,-80.680321,
25.95653,-80.295197,25.9564,
-80.295418,25.9702,-80.121101,
25.9748,-80.117783,25.974791,
-80.109802,26.0868,-80.105499,
26.096081,-80.101601,26.1474,
-80.0896,26.231501,-80.083397,
26.256304,-80.080307,26.257401,
-80.0755,26.3183,-80.074936,26.32044,
-80.088104,26.3204,-80.091904,
26.325701,-80.099106,26.3225,
-80.099304,26.3269,-80.102104,
26.327499,-80.204201,26.327499,
-80.226997,26.334299,-80.881447,
26.33345)),'Broward','12011',
'Florida','FL','12',1208.6845,1255488,1038.7216);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-85.384209,30.566652,-85.389702,
30.201208,-85.115936,30.199778,
-85.119026,30.209625,-85.110039,
30.209145,-85.112061,30.21595,
-85.110504,30.218203,-85.100403,
30.212328,-85.098961,30.219772,
-85.090607,30.222557,-85.091217,
30.229317,-85.080635,30.229109,
-85.083328,30.238466,-85.078545,
30.2423,-85.077812,30.25,-85.070114,
30.249195,-85.067825,30.258568,
-85.059799,30.261353,-85.064163,
30.270222,-85.058083,30.275894,
-85.059669,30.284832,-85.052818,
30.286772,-85.057007,30.303263,
-85.055077,30.304638,-85.047539,
30.30287,-85.050552,30.309935,
-85.048233,30.312473,-85.039192,
30.309731,-85.034378,30.312283,
-85.035088,30.314898,-85.046379,
30.319988,-85.04435,30.328594,
-85.050056,30.337973,-85.040466,
30.35552,-85.026085,30.362848,
-85.027512,30.364962,-85.038658,
30.365435,-85.040283,30.371895,
-85.031326,30.378462,-85.025185,
30.375645,-85.014687,30.387197,
-85.015648,30.395975,-85.027519,
30.398226,-85.029968,30.403074,
-85.016014,30.407804,-85.013741,
30.410452,-85.018181,30.413403,
-85.02951,30.412811,-85.032936,
30.418125,-85.031967,30.422453,
-85.015266,30.434166,-84.983292,
30.441643,-84.981316,30.443933,
-84.982887,30.447435,-84.995499,
30.44491,-85.001617,30.449587,-85,
30.456003,-84.986771,30.466356,
-84.988403,30.471922,-85,30.472221,
-85.004395,30.476015,-84.994545,
30.48888,-84.991104,30.504101,
-84.992363,30.519119,-84.973801,
30.552799,-84.961601,30.564899,
-84.965401,30.5714,-84.965508,30.58,
-84.962196,30.5823,-84.9524,30.5784,
-84.945198,30.580799,-84.945,
30.595301,-84.936501,30.599501,
-84.932602,30.606199,-85.168007,
30.60783,-85.165306,30.60504,
-85.16729,30.595509,-85.172089,
30.587696,-85.169357,30.579996,
-85.173073,30.577866,-85.173683,
30.574751,-85.171959,30.564142,
-85.384209,30.566652)),'Calhoun',
'12013','Florida','FL','12',567.2905,11011,19.4097);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.057663,27.031857,-82.255424,
27.03264,-82.255829,26.944984,
-82.375946,26.945484,-82.349838,
26.904354,-82.326843,26.876497,
-82.301125,26.839937,-82.289268,
26.82744,-82.283806,26.817234,
-82.271904,26.78894,-82.264862,
26.789087,-82.237465,26.784218,
-82.237289,26.784578,-82.229767,
26.789152,-82.220627,26.788826,
-82.195145,26.774124,-82.176849,
26.772491,-82.171623,26.777718,
-82.150711,26.782944,-82.148102,
26.788172,-82.156593,26.852201,
-82.175217,26.903164,-82.174561,
26.909698,-82.154312,26.924398,
-82.138306,26.924398,-82.122299,
26.946285,-82.114784,26.950859,
-82.106613,26.953472,-82.094528,
26.953472,-82.089294,26.957066,
-82.07917,26.9587,-82.064796,
26.953472,-82.061211,26.949226,
-82.057289,26.936485,-82.059898,
26.931257,-82.069046,26.926031,
-82.085373,26.927011,-82.096817,
26.916229,-82.091911,26.892384,
-82.087334,26.887484,-82.077538,
26.883562,-82.06839,26.883562,
-82.060883,26.879642,-82.053688,
26.86919,-82.052711,26.858408,
-82.05304,26.842402,-82.055977,
26.83358,-82.052711,26.818226,
-82.054672,26.799606,-82.057938,
26.792418,-82.062515,26.788826,
-82.060913,26.775517,-82.061882,
26.770311,-81.566292,26.769241,
-81.563042,27.033033,-81.98632,
27.034954,-81.997108,27.031239,
-82.057663,27.031857)),'Charlotte',
'12015','Florida','FL','12',693.5527,110975,160.0093);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.75753,28.99435,-82.756531,
28.993591,-82.751312,28.993158,
-82.740005,28.996418,-82.73587,
28.99555,-82.733917,28.992941,
-82.735657,28.978807,-82.733917,
28.972939,-82.724571,28.963154,
-82.723923,28.953806,-82.712395,
28.949457,-82.710655,28.935978,
-82.697609,28.93228,-82.695435,
28.926628,-82.699783,28.918585,
-82.689568,28.905104,-82.668694,
28.901627,-82.660431,28.903364,
-82.653915,28.90206,-82.647171,
28.892059,-82.637161,28.883656,
-82.642609,28.865269,-82.638039,
28.85541,-82.638336,28.846144,
-82.639664,28.842611,-82.654083,
28.830109,-82.646431,28.819075,
-82.644661,28.795094,-82.641281,
28.793182,-82.638931,28.784355,
-82.646873,28.777294,-82.641869,
28.761112,-82.645844,28.755226,
-82.649666,28.741253,-82.660851,
28.73875,-82.661285,28.736837,
-82.648491,28.722126,-82.647308,
28.715212,-82.649223,28.707268,
-82.637138,28.69684,-82.638695,
28.694338,-82.418533,28.694595,
-82.41819,28.665632,-82.263237,
28.667366,-82.260437,28.672695,
-82.260162,28.682455,-82.254021,
28.689848,-82.249084,28.701551,
-82.251503,28.705221,-82.249245,
28.707672,-82.251648,28.710316,
-82.249268,28.717506,-82.242172,
28.72349,-82.232872,28.730446,
-82.231544,28.735809,-82.218758,
28.743916,-82.217232,28.747984,
-82.213257,28.747549,-82.207817,
28.756924,-82.19931,28.757099,
-82.195297,28.759949,-82.188904,
28.758802,-82.184998,28.761505,
-82.182434,28.768614,-82.188431,
28.771399,-82.188118,28.777493,
-82.184639,28.78285,-82.169655,
28.791294,-82.169701,28.795881,
-82.179497,28.803053,-82.183823,
28.823364,-82.20517,28.834486,
-82.207123,28.840284,-82.212418,
28.84247,-82.219406,28.850502,
-82.232147,28.856319,-82.240326,
28.866524,-82.239365,28.869757,
-82.242714,28.876553,-82.273766,
28.896955,-82.277779,28.910616,
-82.282372,28.914434,-82.290176,
28.935335,-82.296127,28.938141,
-82.295052,28.942434,-82.297272,
28.948095,-82.30529,28.95228,
-82.311783,28.960089,-82.316147,
28.973061,-82.32119,28.973297,
-82.32122,28.97509,-82.341461,
28.987419,-82.345901,28.986891,
-82.361633,28.993561,-82.361809,
28.997972,-82.365715,29.002472,
-82.377686,29.000328,-82.378136,
29.004282,-82.387047,29.008802,
-82.393669,29.007727,-82.397629,
29.011145,-82.395027,29.01371,
-82.397682,29.016552,-82.402084,
29.015385,-82.402061,29.018778,
-82.418831,29.01289,-82.420158,
29.017956,-82.425629,29.018759,
-82.425194,29.021441,-82.429573,
29.020798,-82.432671,29.027514,
-82.436638,29.026987,-82.435333,
29.029257,-82.437683,29.02898,
-82.439377,29.032831,-82.441498,
29.032127,-82.442032,29.035404,
-82.44735,29.038954,-82.454361,
29.039499,-82.45874,29.047398,
-82.464027,29.0446,-82.467194,
29.047773,-82.470528,29.046492,
-82.473305,29.04834,-82.472099,
29.052326,-82.47654,29.050919,
-82.480888,29.05265,-82.484123,
29.050846,-82.487854,29.05168,
-82.487518,29.04792,-82.490425,
29.04814,-82.498184,29.041695,
-82.502686,29.041534,-82.508781,
29.037073,-82.511887,29.043186,
-82.517197,29.044027,-82.517204,
29.041798,-82.522537,29.039392,
-82.523651,29.041931,-82.525871,
29.040604,-82.52523,29.042751,
-82.530556,29.043377,-82.532112,
29.040804,-82.535294,29.040676,
-82.533943,29.043158,-82.535767,
29.044603,-82.538261,29.041998,
-82.54599,29.041542,-82.55619,
29.033611,-82.564316,29.035566,
-82.572372,29.032444,-82.577148,
29.027815,-82.596176,29.029314,
-82.601852,29.021042,-82.602303,
29.013201,-82.612831,29.00902,
-82.62941,29.013617,-82.631287,
29.016024,-82.638733,29.017672,
-82.641167,29.021254,-82.644554,
29.01988,-82.67337,29.025227,
-82.676079,29.025982,-82.677849,
29.030313,-82.684082,29.030268,
-82.690315,29.033592,-82.713036,
29.030149,-82.720512,29.025223,
-82.728539,29.014494,-82.741241,
29.011831,-82.742561,29.007772,
-82.75573,29.001608,-82.754623,
28.997726,-82.75753,28.99435)),
'Citrus','12017','Florida','FL','12',583.5019,93515,160.2648);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.049591,30.142899,-82.046288,
29.746885,-82.049423,29.718426,
-82.029282,29.718437,-82.024551,
29.725698,-82.007256,29.739288,
-81.994232,29.742928,-81.97641,
29.74687,-81.940193,29.747229,
-81.929779,29.758282,-81.923683,
29.780676,-81.914375,29.791149,
-81.890755,29.797907,-81.862122,
29.80022,-81.827591,29.824457,
-81.822937,29.825697,-81.812653,
29.836241,-81.580986,29.839378,
-81.599266,29.875,-81.607269,
29.902927,-81.607872,29.917408,
-81.598816,29.941456,-81.600296,
29.953638,-81.604477,29.962366,
-81.609535,29.969444,-81.624313,
29.981096,-81.675949,30.010168,
-81.687843,30.024496,-81.690575,
30.039392,-81.689911,30.058414,
-81.680542,30.083302,-81.682152,
30.103893,-81.680397,30.121,
-81.692307,30.144501,-81.690704,
30.1717,-81.681908,30.1812,
-81.679817,30.190226,-81.702805,
30.191242,-81.703697,30.188786,
-81.708389,30.190958,-81.725502,
30.190767,-81.733673,30.193228,
-81.739105,30.189081,-81.955696,
30.186089,-82.049583,30.186695,
-82.049591,30.142899)),'Clay',
'12019','Florida','FL','12',601.0405,105986,176.3374);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.846962,26.329998,-81.834183,
26.297485,-81.820862,26.23637,
-81.815308,26.1735,-81.81073,
26.149706,-81.800377,26.08593,
-81.76899,26.024618,-81.761742,
26.004423,-81.749992,25.993217,
-81.746231,25.967312,-81.747734,
25.961929,-81.752396,25.95878,
-81.751823,25.951939,-81.743843,
25.947378,-81.738144,25.940536,
-81.732437,25.930271,-81.729591,
25.91773,-81.730164,25.908037,
-81.718758,25.901196,-81.713623,
25.894924,-81.687965,25.848742,
-81.683975,25.84532,-81.677704,
25.844179,-81.666306,25.88238,
-81.653763,25.894924,-81.617844,
25.896633,-81.581352,25.889791,
-81.569946,25.889791,-81.549423,
25.898914,-81.526619,25.901196,
-81.515785,25.896065,-81.511223,
25.887512,-81.504951,25.88295,
-81.483856,25.889791,-81.475868,
25.887512,-81.461617,25.868696,
-81.448502,25.869267,-81.417145,
25.862995,-81.40062,25.855583,
-81.384079,25.839619,-81.34816,
25.817385,-81.344452,25.802547,
-81.100502,25.802944,-80.873314,
25.805229,-80.873161,25.979065,
-80.880028,26.259096,-81.268753,
26.252684,-81.271973,26.516718,
-81.563965,26.512972,-81.562378,
26.422268,-81.659706,26.420719,
-81.658096,26.317228,-81.819183,
26.31588,-81.819344,26.330116,
-81.846962,26.329998)),'Collier',
'12021','Florida','FL','12',2025.1074,152099,75.1065);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.689415,30.597502,-82.691818,
30.594343,-82.696617,30.596176,
-82.695892,30.591616,-82.706787,
30.583733,-82.703415,30.581602,
-82.705666,30.57514,-82.717766,
30.569042,-82.717552,30.566568,
-82.714859,30.567051,-82.718216,
30.563038,-82.72451,30.564505,
-82.72271,30.561045,-82.726898,
30.558409,-82.723953,30.553711,
-82.720749,30.553825,-82.722679,
30.548052,-82.719322,30.541615,
-82.716568,30.541269,-82.71431,
30.53174,-82.727119,30.530956,
-82.72847,30.525389,-82.723648,
30.517391,-82.718201,30.520741,
-82.716339,30.507145,-82.714729,
30.505182,-82.707687,30.506054,
-82.705544,30.502686,-82.708694,
30.498648,-82.705093,30.494501,
-82.706421,30.492302,-82.697083,
30.489325,-82.696838,30.484421,
-82.702286,30.483089,-82.699646,
30.47883,-82.701599,30.477224,
-82.694145,30.473124,-82.677582,
30.47159,-82.675758,30.464691,
-82.681229,30.464121,-82.680519,
30.461025,-82.671341,30.45289,
-82.66613,30.453279,-82.662903,
30.450964,-82.662987,30.448399,
-82.667351,30.450529,-82.668434,
30.446566,-82.673065,30.447737,
-82.662292,30.438637,-82.659309,
30.440584,-82.65638,30.431875,
-82.652565,30.428644,-82.654083,
30.421564,-82.649269,30.41785,
-82.651604,30.415537,-82.649719,
30.409166,-82.645599,30.407698,
-82.64711,30.395073,-82.650047,
30.391476,-82.658585,30.390631,
-82.658638,30.383505,-82.665939,
30.378187,-82.662743,30.36964,
-82.675377,30.363914,-82.6838,
30.354038,-82.68721,30.353212,
-82.681747,30.343542,-82.68412,
30.33802,-82.690514,30.332705,
-82.703903,30.332151,-82.716949,
30.321035,-82.724983,30.327887,
-82.722839,30.331461,-82.724747,
30.333544,-82.736549,30.328295,
-82.745552,30.317038,-82.760551,
30.323689,-82.760017,30.32818,
-82.763481,30.330542,-82.777664,
30.322985,-82.779381,30.324541,
-82.788177,30.323605,-82.789291,
30.327499,-82.793297,30.326721,
-82.792427,30.335382,-82.794754,
30.336666,-82.794128,29.985979,
-82.760567,29.986326,-82.759155,
29.975269,-82.762451,29.964569,
-82.785896,29.954515,-82.791664,
29.941982,-82.798607,29.936483,
-82.800262,29.932062,-82.794319,
29.931625,-82.791321,29.935452,
-82.789268,29.932655,-82.784195,
29.932678,-82.78096,29.925596,
-82.769958,29.92761,-82.772408,
29.924791,-82.771523,29.917391,
-82.774437,29.912144,-82.771255,
29.908476,-82.765106,29.907831,
-82.767677,29.906071,-82.767059,
29.901234,-82.769402,29.897682,
-82.758293,29.898479,-82.753304,
29.892361,-82.753441,29.881153,
-82.740974,29.865555,-82.737396,
29.865051,-82.732765,29.856436,
-82.721313,29.853622,-82.709244,
29.847439,-82.710587,29.845787,
-82.704613,29.83857,-82.695015,
29.834606,-82.658745,29.83,
-82.655098,29.829424,-82.652069,
29.82585,-82.641479,29.827404,
-82.634651,29.834232,-82.634674,
29.839434,-82.630699,29.842892,
-82.631065,29.849239,-82.617783,
29.8472,-82.618149,29.850384,
-82.622993,29.853018,-82.620346,
29.85845,-82.616554,29.857788,
-82.610977,29.851969,-82.606453,
29.852842,-82.602509,29.857656,
-82.593025,29.861759,-82.591217,
29.865999,-82.586502,29.866667,
-82.589691,29.872763,-82.592506,
29.872984,-82.592712,29.887278,
-82.580162,29.887411,-82.5802,
29.894615,-82.576035,29.894629,
-82.576118,29.913097,-82.579124,
29.91485,-82.571922,29.918219,
-82.567863,29.917372,-82.566574,
29.920671,-82.561317,29.921864,
-82.561157,29.924522,-82.554657,
29.928465,-82.550949,29.92844,
-82.548508,29.925484,-82.541901,
29.925552,-82.539536,29.928852,
-82.530373,29.932632,-82.529663,
29.940971,-82.530869,29.954952,
-82.533607,29.958506,-82.541023,
29.962952,-82.554024,29.963093,
-82.557137,29.968843,-82.569321,
29.974983,-82.576195,29.990843,
-82.571869,30.000444,-82.573341,
30.010426,-82.562607,30.015993,
-82.543533,30.020554,-82.536743,
30.025249,-82.534378,30.030682,
-82.540276,30.03561,-82.535789,
30.054585,-82.516518,30.078161,
-82.498688,30.088854,-82.490074,
30.089638,-82.468048,30.096888,
-82.457794,30.102734,-82.452713,
30.123087,-82.458389,30.128572,
-82.458549,30.136213,-82.45723,
30.442532,-82.459694,30.584051,
-82.584122,30.59161,-82.689415,
30.597502)),'Columbia','12023',
'Florida','FL','12',797.0234,42613,53.4651);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2007,8265,null,
MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,61,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-80.265045,25.353647,-80.256706,
25.3503,-80.251106,25.3416,
-80.250542,25.341444,-80.249763,
25.342897,-80.240242,25.348162,
-80.239487,25.358942,-80.222687,
25.395794,-80.206062,25.41086,
-80.18985,25.454458,-80.189598,
25.460726,-80.176811,25.483538,
-80.177818,25.50234,-80.175812,
25.517633,-80.177559,25.518887,
-80.180824,25.511366,-80.190598,
25.501337,-80.18985,25.495571,
-80.183327,25.49131,-80.183327,
25.48805,-80.18985,25.479277,
-80.20639,25.432144,-80.212662,
25.427382,-80.210152,25.415348,
-80.22094,25.406574,-80.242989,
25.399303,-80.250015,25.394793,
-80.256279,25.381254,-80.259544,
25.358191,-80.265045,25.353647,
-80.873161,25.979065,-80.873314,
25.805229,-80.873398,25.3636,
-80.862396,25.3638,-80.862198,
25.2425,-80.8582,25.242599,
-80.858345,25.210899,-80.858376,
25.176176,-80.850906,25.176483,
-80.849052,25.176704,-80.848671,
25.176577,-80.836235,25.172428,
-80.830528,25.167084,-80.827332,
25.159958,-80.809151,25.166372,
-80.798157,25.164944,-80.791855,
25.164124,-80.77977,25.16255,
-80.76918,25.161171,-80.765327,
25.160669,-80.756577,25.157103,
-80.755714,25.156752,-80.752365,
25.151173,-80.751434,25.149626,
-80.743324,25.142487,-80.74305,
25.142244,-80.742531,25.141787,
-80.730057,25.141787,-80.722931,
25.144638,-80.714027,25.143211,
-80.707253,25.138935,-80.70369,
25.140005,-80.698799,25.153736,
-80.697868,25.156357,-80.694939,
25.164572,-80.694427,25.166016,
-80.692673,25.166067,-80.679893,
25.166445,-80.673233,25.166641,
-80.669975,25.166737,-80.66922,
25.166758,-80.658089,25.167084,
-80.657082,25.167459,-80.647438,
25.171059,-80.634216,25.175991,
-80.619957,25.177059,-80.616821,
25.176079,-80.615013,25.175516,
-80.614258,25.175278,-80.602501,
25.187037,-80.594307,25.189886,
-80.593956,25.192524,-80.59359,
25.195232,-80.592728,25.196098,
-80.590385,25.198439,-80.584686,
25.199863,-80.584633,25.200033,
-80.584114,25.201572,-80.583618,
25.20307,-80.584259,25.204737,
-80.590034,25.219816,-80.584328,
25.226942,-80.569717,25.237988,
-80.561165,25.239412,-80.533028,
25.230148,-80.520088,25.221783,
-80.516258,25.219303,-80.515533,
25.218359,-80.514153,25.216549,
-80.507797,25.208239,-80.50618,
25.206129,-80.50322,25.202257,
-80.499565,25.200558,-80.498177,
25.199913,-80.496201,25.198997,
-80.495987,25.199203,-80.495583,
25.199598,-80.488091,25.206861,
-80.487671,25.207272,-80.487862,
25.212143,-80.488174,25.220308,
-80.475136,25.229332,-80.474632,
25.229519,-80.469612,25.23138,
-80.458557,25.235479,-80.456642,
25.236187,-80.448853,25.239075,
-80.446053,25.240112,-80.444656,
25.240017,-80.440056,25.239704,
-80.438301,25.239584,-80.435875,
25.23942,-80.43502,25.239361,
-80.431519,25.241615,-80.426506,
25.263678,-80.404945,25.280975,
-80.403687,25.286491,-80.384888,
25.301031,-80.379875,25.312565,
-80.37001,25.322571,-80.36171,
25.328341,-80.352699,25.329062,
-80.338989,25.335552,-80.327087,
25.354668,-80.314102,25.366207,
-80.305809,25.384602,-80.308693,
25.38965,-80.318069,25.388569,
-80.325287,25.393978,-80.327805,
25.40155,-80.326729,25.422831,
-80.319511,25.437256,-80.325287,
25.437256,-80.330696,25.441944,
-80.340431,25.470436,-80.340431,
25.497847,-80.331413,25.517321,
-80.330338,25.530304,-80.321678,
25.537878,-80.313385,25.53932,
-80.302925,25.567451,-80.308914,
25.588055,-80.308914,25.602558,
-80.305824,25.61521,-80.295639,
25.627245,-80.272186,25.637735,
-80.269104,25.642982,-80.26725,
25.65687,-80.258301,25.676619,
-80.245033,25.697603,-80.248421,
25.71365,-80.23362,25.727228,
-80.210777,25.740498,-80.199623,
25.747475,-80.180801,25.747822,
-80.158936,25.726919,-80.162025,
25.715811,-80.177444,25.685877,
-80.163254,25.675076,-80.158623,
25.664583,-80.155235,25.667051,
-80.153381,25.67415,-80.155846,
25.682175,-80.15554,25.699764,
-80.146896,25.721674,-80.146591,
25.738338,-80.132507,25.764437,
-80.127907,25.793301,-80.121597,
25.815201,-80.1194,25.850599,
-80.123085,25.900185,-80.117783,
25.974791,-80.121101,25.9748,
-80.295418,25.9702,-80.295197,
25.9564,-80.680321,25.95653,
-80.68026,25.978378,-80.873161,
25.979065)),'Dade','12025','Florida',
'FL','12',1944.3251,1937094,996.2807);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.055946,27.337942,-82.056686,
27.207441,-82.057663,27.031857,
-81.997108,27.031239,-81.98632,
27.034954,-81.563042,27.033033,
-81.563934,27.340401,-81.859024,
27.339939,-81.859138,27.336388,
-82.055946,27.337942)),'DeSoto',
'12027','Florida','FL','12',637.2177,23865,37.4518);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-83.319,29.822399,-83.319603,
29.778334,-83.326729,29.773409,
-83.3256,29.770567,-83.331642,
29.761745,-83.337051,29.760004,
-83.34243,29.746183,-83.345657,
29.743296,-83.343422,29.736723,
-83.347809,29.733353,-83.344971,
29.72703,-83.347244,29.714375,
-83.350281,29.712172,-83.351509,
29.70647,-83.350639,29.695694,
-83.365356,29.676117,-83.363159,
29.668423,-83.366692,29.665808,
-83.373497,29.665726,-83.399773,
29.673742,-83.415497,29.665344,
-83.413651,29.663948,-83.405693,
29.652594,-83.404106,29.641693,
-83.402519,29.628748,-83.406609,
29.621254,-83.401382,29.614443,
-83.400703,29.602406,-83.407509,
29.588099,-83.402977,29.565163,
-83.404106,29.542681,-83.394569,
29.515882,-83.387306,29.513384,
-83.370499,29.499758,-83.360283,
29.499987,-83.353699,29.494989,
-83.350288,29.488857,-83.34166,
29.486814,-83.33075,29.475006,
-83.321671,29.476139,-83.315086,
29.47296,-83.296684,29.443892,
-83.289421,29.437534,-83.271255,
29.430494,-83.249001,29.43322,
-83.236282,29.430721,-83.229019,
29.422318,-83.217667,29.419594,
-83.20903,29.397566,-83.203354,
29.393703,-83.200401,29.373039,
-83.189507,29.363047,-83.182236,
29.348059,-83.173836,29.346468,
-83.169518,29.341019,-83.164299,
29.323986,-83.150673,29.328527,
-83.124229,29.321783,-83.120804,
29.317385,-83.113098,29.317902,
-83.112038,29.324446,-83.104675,
29.325203,-83.098953,29.336628,
-83.090546,29.332514,-83.082352,
29.339621,-83.068672,29.343716,
-83.060677,29.34922,-83.061569,
29.352446,-83.072197,29.353624,
-83.062401,29.363993,-83.066078,
29.36824,-83.06575,29.372425,
-83.056274,29.378229,-83.045532,
29.380444,-83.034019,29.390314,
-83.033112,29.397711,-83.025574,
29.396776,-83.023399,29.398329,
-83.026024,29.405449,-83.021919,
29.412863,-83.027031,29.418711,
-83.025063,29.420109,-83.018105,
29.418392,-83.015984,29.421171,
-83.021088,29.427036,-83.021339,
29.43096,-83.012962,29.439533,
-83.012993,29.445663,-83.002144,
29.456293,-83.000664,29.46241,
-82.990089,29.46311,-82.984657,
29.469673,-82.986961,29.476309,
-82.982018,29.485182,-82.984467,
29.496088,-82.983032,29.515209,
-82.979607,29.518185,-82.972832,
29.517033,-82.969551,29.522079,
-82.978714,29.531633,-82.977501,
29.539658,-82.959511,29.553011,
-82.948059,29.557297,-82.948898,
29.565668,-82.944618,29.582067,
-82.943245,29.584991,-82.937843,
29.586943,-82.937492,29.591003,
-82.941971,29.592983,-82.948982,
29.585182,-82.955643,29.585875,
-82.962585,29.601673,-82.972313,
29.608736,-82.967857,29.616314,
-82.973206,29.624048,-82.968803,
29.630234,-82.956497,29.639339,
-82.957703,29.655111,-82.951973,
29.65958,-82.953331,29.664564,
-82.959373,29.670242,-82.954521,
29.676437,-82.959557,29.684084,
-82.956657,29.691444,-82.957527,
29.700264,-82.952202,29.703741,
-82.945488,29.699703,-82.937126,
29.703003,-82.943451,29.704666,
-82.947617,29.711958,-82.95369,
29.713987,-82.956741,29.718487,
-82.953957,29.722214,-82.946602,
29.714748,-82.943619,29.716198,
-82.943436,29.721588,-82.94928,
29.722948,-82.950043,29.725336,
-82.939026,29.74345,-82.938812,
29.749447,-82.94149,29.753807,
-82.949326,29.753485,-82.949829,
29.75769,-82.947777,29.765882,
-82.941376,29.77261,-82.936935,
29.784431,-82.920135,29.794985,
-82.92173,29.798229,-82.933571,
29.801222,-82.935715,29.807852,
-82.930176,29.818275,-82.920761,
29.823912,-82.958946,29.823717,
-82.959206,29.825209,-83.319,
29.822399)),'Dixie','12029',
'Florida','FL','12',703.9375,10585,15.0368);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.049408,30.273195,-82.049583,
30.186695,-81.955696,30.186089,
-81.739105,30.189081,-81.733673,
30.193228,-81.725502,30.190767,
-81.708389,30.190958,-81.703697,
30.188786,-81.702805,30.191242,
-81.679817,30.190226,-81.681908,
30.1812,-81.690704,30.1717,
-81.692307,30.144501,-81.680397,
30.121,-81.650703,30.1213,-81.624001,
30.1334,-81.612503,30.1327,
-81.590706,30.125601,-81.581001,
30.125401,-81.568001,30.1178,
-81.5392,30.119699,-81.538895,
30.103506,-81.433975,30.105293,
-81.437202,30.252094,-81.379097,
30.252399,-81.3918,30.3032,
-81.397934,30.36116,-81.397102,
30.3811,-81.393303,30.3965,
-81.407349,30.422319,-81.410995,
30.481655,-81.42482,30.505718,
-81.433891,30.506329,-81.442307,
30.5089,-81.4561,30.525101,
-81.480003,30.5343,-81.488106,
30.5427,-81.491104,30.5548,
-81.499702,30.5637,-81.514198,
30.567101,-81.524002,30.556101,
-81.520905,30.543699,-81.525002,
30.5336,-81.531708,30.5264,
-81.543106,30.5238,-81.5494,30.5317,
-81.551102,30.542801,-81.555397,
30.5443,-81.568001,30.5364,
-81.577469,30.537788,-81.585587,
30.544155,-81.589401,30.549601,
-81.583603,30.5648,-81.587997,
30.566299,-81.6035,30.558399,
-81.605797,30.5541,-81.609001,
30.553101,-81.614487,30.562393,
-81.601776,30.567308,-81.604706,
30.572601,-81.611176,30.575771,
-81.604599,30.5839,-81.606293,
30.58552,-81.615997,30.58,-81.625481,
30.585896,-81.635605,30.581259,
-81.637802,30.5777,-81.642693,
30.579809,-81.646301,30.575199,
-81.650307,30.5767,-81.650597,
30.5725,-81.656403,30.569599,
-81.661507,30.558201,-81.6642,
30.558201,-81.662903,30.554399,
-81.659103,30.552401,-81.664001,
30.5506,-81.673302,30.5564,
-81.668106,30.556999,-81.668106,
30.560301,-81.673302,30.5595,
-81.669907,30.562599,-81.674797,
30.565901,-81.677803,30.561899,
-81.684196,30.566099,-81.686707,
30.5627,-81.6884,30.566099,
-81.693306,30.566601,-81.693504,
30.563601,-81.696503,30.5637,
-81.695305,30.5658,-81.698799,
30.5693,-81.701599,30.5634,
-81.704903,30.563499,-81.703796,
30.566799,-81.709801,30.565701,
-81.733681,30.551258,-81.7341,
30.5427,-81.737106,30.5394,
-81.756302,30.531,-81.765106,30.5355,
-81.765503,30.5182,-81.781799,
30.503099,-81.794907,30.5051,
-81.809708,30.484301,-82.049408,
30.273195)),'Duval','12031',
'Florida','FL','12',773.7172,672971,869.7885);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-87.598946,30.997276,-87.589363,
30.965315,-87.591354,30.95335,
-87.607826,30.924307,-87.61602,
30.90127,-87.622215,30.897324,
-87.620796,30.88731,-87.629471,
30.87993,-87.634949,30.865702,
-87.625999,30.856508,-87.627335,
30.847776,-87.617294,30.840168,
-87.6157,30.834278,-87.604675,
30.83128,-87.600502,30.82044,
-87.581886,30.812216,-87.57206,
30.800346,-87.568291,30.79991,
-87.559502,30.79026,-87.552063,
30.786066,-87.550713,30.781342,
-87.545067,30.778479,-87.546173,
30.771832,-87.537102,30.762342,
-87.535385,30.749586,-87.529999,
30.740709,-87.510925,30.732796,
-87.501511,30.720987,-87.492279,
30.720119,-87.483681,30.715403,
-87.481674,30.717375,-87.477974,
30.713318,-87.479439,30.709833,
-87.475166,30.708941,-87.475349,
30.705069,-87.469971,30.704723,
-87.468033,30.700142,-87.4636,
30.700533,-87.45768,30.696568,
-87.451424,30.699615,-87.440399,
30.690685,-87.430389,30.688456,
-87.426476,30.683092,-87.418968,
30.678553,-87.406982,30.674974,
-87.403328,30.657532,-87.398003,
30.655191,-87.394852,30.645496,
-87.39505,30.615089,-87.398941,
30.605762,-87.407745,30.601042,
-87.40554,30.598682,-87.40876,
30.583508,-87.412781,30.576405,
-87.411964,30.574387,-87.410172,
30.575121,-87.410896,30.573181,
-87.416283,30.572256,-87.418671,
30.561644,-87.426056,30.559879,
-87.42791,30.553967,-87.435463,
30.548946,-87.4366,30.540855,
-87.440361,30.540054,-87.441795,
30.536798,-87.43959,30.53022,
-87.444221,30.531549,-87.442902,
30.5299,-87.446609,30.526875,
-87.444099,30.524099,-87.447479,
30.522015,-87.445786,30.517132,
-87.447342,30.514587,-87.445198,
30.513786,-87.449944,30.514496,
-87.444733,30.507299,-87.439713,
30.506454,-87.431,30.4981,-87.431702,
30.492701,-87.428398,30.4883,
-87.433907,30.487499,-87.432907,
30.4841,-87.4356,30.480301,
-87.430603,30.4764,-87.429604,
30.4704,-87.424301,30.464701,
-87.414703,30.4571,-87.407906,
30.4562,-87.399902,30.4508,
-87.379997,30.449699,-87.368706,
30.444433,-87.367462,30.434298,
-87.384377,30.421415,-87.395706,
30.4174,-87.4048,30.409401,
-87.422707,30.409901,-87.429604,
30.4063,-87.434303,30.397301,
-87.440704,30.3913,-87.438705,
30.3806,-87.451401,30.367001,
-87.451103,30.3454,-87.461105,
30.3351,-87.471901,30.3316,
-87.493599,30.3304,-87.502594,
30.327206,-87.505959,30.319197,
-87.505798,30.3123,-87.503906,
30.3078,-87.5,30.306,-87.483704,
30.3046,-87.475906,30.307699,
-87.462997,30.3076,-87.450104,
30.3109,-87.4524,30.299999,
-87.518402,30.283701,-87.518402,
30.280224,-87.518341,30.280233,
-87.419884,30.296926,-87.329987,
30.315968,-87.251999,30.316065,
-87.181152,30.324156,-86.869904,
30.378231,-86.850609,30.380384,
-86.850632,30.383423,-86.918221,
30.371435,-86.86248,30.381651,
-86.866432,30.392237,-86.936432,
30.38471,-86.997818,30.373734,
-87.017105,30.3722,-87.023201,
30.3694,-87.038506,30.3685,
-87.045403,30.370199,-87.060905,
30.363899,-87.080597,30.363001,
-87.086197,30.3592,-87.120796,
30.3535,-87.125,30.3501,-87.153,
30.3482,-87.180603,30.334,-87.191788,
30.337742,-87.195999,30.339701,
-87.211906,30.339899,-87.233307,
30.349001,-87.232819,30.379025,
-87.228256,30.384048,-87.152603,
30.4056,-87.136734,30.416544,
-87.134338,30.421841,-87.138046,
30.451712,-87.133682,30.467873,
-87.124603,30.4849,-87.124496,
30.497801,-87.127747,30.505104,
-87.138336,30.511681,-87.152702,
30.531099,-87.167908,30.541401,
-87.189598,30.548599,-87.195854,
30.548752,-87.210876,30.556065,
-87.222366,30.571392,-87.224876,
30.580671,-87.231552,30.586191,
-87.229759,30.589329,-87.233727,
30.591328,-87.233696,30.594929,
-87.245476,30.597088,-87.246078,
30.59992,-87.242943,30.602272,
-87.244736,30.60528,-87.249695,
30.605696,-87.259232,30.611313,
-87.257187,30.614496,-87.26091,
30.620832,-87.251984,30.623713,
-87.258835,30.62965,-87.256767,
30.634165,-87.264488,30.648493,
-87.264137,30.655558,-87.266296,
30.658072,-87.264214,30.662039,
-87.266808,30.664776,-87.266464,
30.677378,-87.268829,30.679144,
-87.265778,30.688807,-87.272568,
30.693857,-87.272713,30.70001,
-87.268372,30.700773,-87.270729,
30.703491,-87.270042,30.712442,
-87.273254,30.714096,-87.273232,
30.717623,-87.276695,30.713654,
-87.281425,30.719606,-87.289108,
30.720947,-87.292465,30.718687,
-87.294701,30.721325,-87.296494,
30.720526,-87.29483,30.718103,
-87.302299,30.719467,-87.302155,
30.722588,-87.308281,30.726746,
-87.312012,30.734432,-87.31208,
30.740379,-87.30851,30.745073,
-87.310478,30.75054,-87.306122,
30.75518,-87.307671,30.758287,
-87.304131,30.758165,-87.302361,
30.760727,-87.30497,30.760822,
-87.305,30.76371,-87.300346,
30.763557,-87.299637,30.765921,
-87.300812,30.767611,-87.304306,
30.76585,-87.305801,30.769957,
-87.310219,30.771254,-87.305534,
30.777582,-87.309258,30.776806,
-87.309235,30.782326,-87.312714,
30.78594,-87.305817,30.787636,
-87.309334,30.789469,-87.306938,
30.79101,-87.302422,30.789404,
-87.305817,30.792843,-87.305481,
30.798271,-87.302765,30.801483,
-87.298683,30.801872,-87.296486,
30.808498,-87.292793,30.811096,
-87.296906,30.81493,-87.297546,
30.825718,-87.301895,30.82897,
-87.302551,30.833754,-87.300331,
30.835392,-87.303368,30.838909,
-87.302216,30.841978,-87.307999,
30.842825,-87.306999,30.848618,
-87.31205,30.847469,-87.313522,
30.849302,-87.308853,30.863626,
-87.301552,30.863239,-87.297653,
30.870996,-87.299667,30.873804,
-87.296669,30.878357,-87.298302,
30.881191,-87.284515,30.887802,
-87.285477,30.90344,-87.290535,
30.908049,-87.289467,30.909496,
-87.285622,30.907862,-87.282394,
30.910227,-87.283531,30.915451,
-87.288994,30.916382,-87.28344,
30.919724,-87.286911,30.925259,
-87.275787,30.926174,-87.275658,
30.930801,-87.267242,30.934799,
-87.264893,30.93055,-87.260933,
30.935135,-87.259399,30.931467,
-87.256027,30.931002,-87.250626,
30.938562,-87.251862,30.943743,
-87.247467,30.941723,-87.244942,
30.946846,-87.241486,30.948402,
-87.238319,30.95801,-87.241348,
30.961676,-87.232002,30.968105,
-87.231255,30.963596,-87.227661,
30.96093,-87.218407,30.963572,
-87.213234,30.961851,-87.21302,
30.966761,-87.203529,30.970482,
-87.197159,30.976316,-87.19046,
30.975628,-87.18718,30.981262,
-87.174995,30.988436,-87.176033,
30.996405,-87.16906,30.992914,
-87.162651,30.998875,-87.237709,
30.996212,-87.255005,30.998104,
-87.598946,30.997276)),'Escambia',
'12033','Florida','FL','12',663.5283,262798,396.0612);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.523911,29.622158,-81.520119,
29.494648,-81.487801,29.448,
-81.486198,29.423901,-81.481102,
29.416201,-81.477707,29.3969,
-81.468307,29.392,-81.4552,29.3894,
-81.434196,29.3983,-81.431953,
29.399414,-81.429962,29.39687,
-81.425537,29.396938,-81.423416,
29.400421,-81.420952,29.399437,
-81.417503,29.2609,-81.150307,
29.265699,-81.156105,29.4107,
-81.14827,29.411592,-81.148827,
29.41642,-81.110909,29.426624,
-81.102097,29.427383,-81.125,
29.476969,-81.163803,29.555176,
-81.213173,29.670332,-81.227486,
29.67021,-81.232391,29.662895,
-81.247459,29.658863,-81.251015,
29.662048,-81.253593,29.661274,
-81.261391,29.668751,-81.269615,
29.659748,-81.272423,29.660528,
-81.270271,29.656469,-81.274551,
29.657249,-81.272949,29.655005,
-81.276314,29.654202,-81.274918,
29.652596,-81.282318,29.650122,
-81.28791,29.651661,-81.290535,
29.649529,-81.300789,29.650949,
-81.306068,29.642721,-81.309746,
29.641735,-81.318962,29.651089,
-81.324677,29.653381,-81.324295,
29.62529,-81.523911,29.622158)),
'Flagler','12035','Florida','FL','12',484.9375,28701,59.1849);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2007,8265,null,
MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,81,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-85.050781,29.586575,-85.04229,
29.587511,-84.957458,29.61249,
-84.873581,29.65687,-84.799225,
29.681351,-84.775543,29.69289,
-84.719681,29.737711,-84.69445,
29.76306,-84.694832,29.769474,
-84.699455,29.768551,-84.719803,
29.745434,-84.792847,29.69643,
-84.819199,29.683949,-84.874207,
29.66823,-84.911659,29.649736,
-84.922752,29.648811,-84.931999,
29.637718,-84.968056,29.617376,
-84.98748,29.609978,-85.018448,
29.604429,-85.024002,29.600733,
-85.049423,29.603045,-85.076241,
29.617376,-85.092865,29.632599,
-85.093231,29.643536,-85.075729,
29.672703,-85.090309,29.681816,
-85.105263,29.686922,-85.12458,
29.688379,-85.144272,29.682911,
-85.197136,29.682547,-85.220474,
29.679995,-85.219376,29.676712,
-85.184738,29.663221,-85.155937,
29.645357,-85.141724,29.633692,
-85.12458,29.627857,-85.097168,
29.625,-85.062813,29.600828,
-85.050781,29.586575,-85.025528,
29.971195,-85.012741,29.93693,
-85.019714,29.916874,-85.00943,
29.907328,-85.014771,29.902746,
-85.013161,29.895622,-85.015678,
29.882126,-85.012375,29.870886,
-85.015999,29.856819,-85.018326,
29.85413,-85.026833,29.853479,
-85.032646,29.844072,-85.032295,
29.828789,-85.021515,29.823006,
-85.019783,29.819666,-85.020622,
29.807163,-85.034431,29.794851,
-85.040169,29.779139,-85.047325,
29.781042,-85.049141,29.777666,
-85.06076,29.786089,-85.064857,
29.786818,-85.068764,29.78426,
-85.072037,29.771484,-85.078316,
29.768408,-85.109489,29.776585,
-85.206314,29.710978,-85.217178,
29.694036,-85.107445,29.717793,
-85.083672,29.718952,-85.022774,
29.712572,-84.991463,29.715471,
-84.980446,29.721851,-84.902733,
29.73403,-84.892883,29.722431,
-84.885918,29.723013,-84.885338,
29.729971,-84.880699,29.73461,
-84.864464,29.743307,-84.807632,
29.765345,-84.776894,29.780422,
-84.688751,29.829714,-84.660912,
29.840155,-84.63929,29.851749,
-84.59613,29.880041,-84.574554,
29.888193,-84.540024,29.907373,
-84.513176,29.915525,-84.503586,
29.915525,-84.491592,29.910732,
-84.473373,29.92272,-84.463783,
29.926077,-84.449402,29.92272,
-84.44268,29.91217,-84.433098,
29.904978,-84.425423,29.90258,
-84.406242,29.901621,-84.377945,
29.89299,-84.34726,29.896826,
-84.341507,29.901142,-84.335274,
29.91217,-84.333351,29.923677,
-84.335754,29.937105,-84.340065,
29.945257,-84.340065,29.960348,
-84.437515,29.976824,-84.443054,
29.981995,-84.453514,29.970959,
-84.458504,29.974995,-84.459778,
29.993172,-84.467819,30.00165,
-84.473343,30.001701,-84.489784,
29.987333,-84.514229,29.988873,
-84.512199,29.981836,-84.520493,
29.98028,-84.525383,29.98284,
-84.519058,29.994926,-84.525101,
30.005018,-84.530174,30.00742,
-84.542023,30.002098,-84.548973,
30.006895,-84.544739,30.010826,
-84.815346,30.011141,-85.007805,
30.013721,-85.005562,30.00939,
-85.010696,30.005083,-85.009766,30,
-85.014854,29.997355,-85.018394,
29.980631,-85.025528,29.971195)),
'Franklin','12037','Florida','FL','12',533.8911,8967,16.7955);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-84.864777,30.711351,-84.858421,
30.69643,-84.875,30.671801,
-84.889305,30.6614,-84.893105,
30.6465,-84.903801,30.6376,
-84.905304,30.6224,-84.912003,
30.617001,-84.927597,30.612301,
-84.932602,30.606199,-84.8834,
30.6054,-84.882706,30.5329,
-84.815903,30.5329,-84.815704,
30.518299,-84.781906,30.518499,
-84.781197,30.4596,-84.714188,
30.460205,-84.714211,30.417004,
-84.680618,30.417074,-84.68071,
30.387852,-84.646553,30.388184,
-84.645691,30.391413,-84.648026,
30.394167,-84.642975,30.397936,
-84.639763,30.396294,-84.625,
30.408903,-84.61277,30.40995,
-84.607246,30.415899,-84.591103,
30.411531,-84.580505,30.416914,
-84.579842,30.419535,-84.568916,
30.426664,-84.567223,30.431036,
-84.565002,30.430799,-84.566795,
30.433334,-84.561569,30.437702,
-84.55957,30.433819,-84.557365,
30.435795,-84.546227,30.436481,
-84.546013,30.440258,-84.530655,
30.439606,-84.526237,30.447302,
-84.520447,30.451191,-84.504478,
30.450708,-84.499268,30.45285,
-84.495399,30.4601,-84.484909,
30.455999,-84.481102,30.458927,
-84.474068,30.457741,-84.47261,
30.46011,-84.460602,30.455709,
-84.452637,30.462099,-84.437981,
30.461029,-84.434708,30.466,
-84.433281,30.463659,-84.423798,
30.467199,-84.42347,30.46373,
-84.421005,30.463619,-84.407906,
30.4727,-84.402702,30.4758,
-84.402435,30.48041,-84.397072,
30.483509,-84.397652,30.488211,
-84.395508,30.4904,-84.398689,
30.494431,-84.401428,30.494049,
-84.402359,30.499241,-84.404831,
30.49901,-84.402397,30.5049,
-84.404747,30.50794,-84.397125,
30.513861,-84.39489,30.51243,
-84.39579,30.51486,-84.392807,
30.51483,-84.395851,30.516399,
-84.391876,30.51701,-84.393463,
30.520479,-84.390701,30.5198,
-84.391846,30.525419,-84.388878,
30.52669,-84.391846,30.52947,
-84.391594,30.532829,-84.38829,
30.549219,-84.384102,30.5536,
-84.379005,30.55965,-84.382011,
30.562759,-84.378471,30.567711,
-84.3778,30.57398,-84.372398,30.5756,
-84.374489,30.57766,-84.372711,
30.577181,-84.369308,30.582529,
-84.364403,30.582911,-84.364182,
30.585079,-84.360062,30.58432,
-84.35479,30.591089,-84.349983,
30.592899,-84.346771,30.591761,
-84.349045,30.595409,-84.346748,
30.59358,-84.343468,30.595209,
-84.344154,30.598921,-84.343307,
30.596781,-84.340302,30.599939,
-84.33934,30.59708,-84.332504,
30.596201,-84.330566,30.60006,
-84.333679,30.60034,-84.33075,
30.60338,-84.331161,30.60676,
-84.329102,30.60671,-84.328621,
30.609579,-84.326309,30.60812,
-84.327301,30.61194,-84.323715,
30.61783,-84.321907,30.62071,
-84.318878,30.61891,-84.318825,
30.622089,-84.317307,30.621201,
-84.315254,30.625887,-84.312477,
30.626734,-84.313126,30.630541,
-84.305756,30.632689,-84.305695,
30.637289,-84.30101,30.639032,
-84.302017,30.651054,-84.300125,
30.653688,-84.30426,30.656345,
-84.301666,30.656414,-84.302246,
30.659437,-84.299545,30.66152,
-84.302811,30.662643,-84.300446,
30.664543,-84.305458,30.668875,
-84.302963,30.672745,-84.304291,
30.67627,-84.300026,30.67375,
-84.298569,30.676636,-84.300552,
30.676682,-84.30098,30.679682,
-84.298378,30.678629,-84.297691,
30.682087,-84.292175,30.680574,
-84.290588,30.683575,-84.288681,
30.68133,-84.287933,30.683802,
-84.281311,30.685062,-84.380798,
30.6898,-84.474503,30.6926,
-84.863541,30.711304,-84.864777,
30.711351)),'Gadsden','12039',
'Florida','FL','12',516.0693,41105,79.65);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.879951,29.886616,-82.876183,
29.884169,-82.875771,29.866297,
-82.888557,29.849884,-82.893021,
29.827229,-82.904114,29.824062,
-82.918861,29.823853,-82.920761,
29.823912,-82.930176,29.818275,
-82.935715,29.807852,-82.933571,
29.801222,-82.92173,29.798229,
-82.920135,29.794985,-82.936935,
29.784431,-82.941376,29.77261,
-82.947777,29.765882,-82.949829,
29.75769,-82.949326,29.753485,
-82.94149,29.753807,-82.938812,
29.749447,-82.939026,29.74345,
-82.950043,29.725336,-82.94928,
29.722948,-82.943436,29.721588,
-82.943619,29.716198,-82.946602,
29.714748,-82.953957,29.722214,
-82.956741,29.718487,-82.95369,
29.713987,-82.947617,29.711958,
-82.943451,29.704666,-82.937126,
29.703003,-82.945488,29.699703,
-82.952202,29.703741,-82.957527,
29.700264,-82.956657,29.691444,
-82.959557,29.684084,-82.954521,
29.676437,-82.959373,29.670242,
-82.953331,29.664564,-82.951973,
29.65958,-82.957703,29.655111,
-82.956497,29.639339,-82.968803,
29.630234,-82.973206,29.624048,
-82.967857,29.616314,-82.972313,
29.608736,-82.962585,29.601673,
-82.955643,29.585875,-82.948982,
29.585182,-82.941971,29.592983,
-82.937492,29.591003,-82.856766,
29.591078,-82.856659,29.583965,
-82.773071,29.584641,-82.773186,
29.577408,-82.757034,29.57744,
-82.756615,29.562225,-82.656601,
29.564573,-82.658745,29.83,
-82.695015,29.834606,-82.704613,
29.83857,-82.710587,29.845787,
-82.709244,29.847439,-82.721313,
29.853622,-82.732765,29.856436,
-82.737396,29.865051,-82.740974,
29.865555,-82.753441,29.881153,
-82.753304,29.892361,-82.758293,
29.898479,-82.769402,29.897682,
-82.767059,29.901234,-82.767677,
29.906071,-82.765106,29.907831,
-82.771255,29.908476,-82.774437,
29.912144,-82.771523,29.917391,
-82.772408,29.924791,-82.769958,
29.92761,-82.78096,29.925596,
-82.784195,29.932678,-82.789268,
29.932655,-82.791321,29.935452,
-82.794319,29.931625,-82.800262,
29.932062,-82.808586,29.932863,
-82.814369,29.929976,-82.832069,
29.912605,-82.839409,29.914734,
-82.841904,29.911892,-82.850403,
29.913883,-82.863045,29.911108,
-82.867599,29.903246,-82.866623,
29.899122,-82.871719,29.898203,
-82.875,29.890572,-82.879951,
29.886616)),'Gilchrist','12041',
'Florida','FL','12',348.8015,9667,27.7148);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.563042,27.033033,-81.566292,
26.769241,-81.459648,26.768618,
-81.459526,26.783228,-81.449455,
26.783297,-81.43499,26.783182,
-81.43528,26.768368,-80.945564,
26.768707,-80.885857,26.958586,
-80.871384,27.146738,-80.886192,
27.165548,-80.889709,27.16744,
-80.890923,27.164825,-80.892563,
27.166662,-80.897736,27.16609,
-80.897583,27.170357,-80.903526,
27.168844,-80.902039,27.170725,
-80.910446,27.174738,-80.906601,
27.179232,-80.909164,27.18531,
-80.906616,27.188725,-80.91124,
27.188795,-80.911346,27.191456,
-80.913834,27.189369,-80.918266,
27.190104,-80.920296,27.193521,
-80.925682,27.195082,-80.925468,
27.19726,-80.929726,27.196184,
-80.926834,27.198429,-80.931396,
27.200035,-80.935188,27.196482,
-80.937683,27.204119,-80.943275,
27.207397,-80.943398,27.210276,
-81.169136,27.209368,-81.168488,
27.121407,-81.267891,27.12077,
-81.267357,27.032129,-81.333214,
27.032036,-81.333214,27.039288,
-81.342155,27.039263,-81.342873,
27.031988,-81.563042,27.033033)),
'Glades','12043','Florida','FL','12',773.3706,7591,9.8154);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-85.389702,30.201208,-85.3918,
30.000656,-85.388641,29.924295,
-85.388962,29.924164,-85.363815,
29.898708,-85.354309,29.884686,
-85.336739,29.849089,-85.332375,
29.845695,-85.325089,29.844757,
-85.317543,29.838686,-85.311501,
29.814165,-85.302673,29.807886,
-85.303284,29.776375,-85.306152,
29.758148,-85.305199,29.724697,
-85.30854,29.702719,-85.318336,
29.690535,-85.348206,29.685755,
-85.357048,29.687426,-85.375923,
29.708214,-85.380699,29.717293,
-85.404594,29.790401,-85.406975,
29.805695,-85.406021,29.829586,
-85.397186,29.861362,-85.391144,
29.872892,-85.405899,29.86561,
-85.412415,29.856377,-85.41571,
29.846636,-85.417603,29.835981,
-85.415169,29.804996,-85.397949,
29.740288,-85.37281,29.685463,
-85.35511,29.662231,-85.344849,
29.654579,-85.345337,29.669987,
-85.330048,29.67811,-85.304237,
29.683126,-85.287041,29.683603,
-85.258026,29.67963,-85.24453,
29.686556,-85.219734,29.693483,
-85.217178,29.694036,-85.206314,
29.710978,-85.109489,29.776585,
-85.078316,29.768408,-85.072037,
29.771484,-85.068764,29.78426,
-85.064857,29.786818,-85.06076,
29.786089,-85.049141,29.777666,
-85.047325,29.781042,-85.040169,
29.779139,-85.034431,29.794851,
-85.020622,29.807163,-85.019783,
29.819666,-85.021515,29.823006,
-85.032295,29.828789,-85.032646,
29.844072,-85.026833,29.853479,
-85.018326,29.85413,-85.015999,
29.856819,-85.012375,29.870886,
-85.015678,29.882126,-85.013161,
29.895622,-85.014771,29.902746,
-85.00943,29.907328,-85.019714,
29.916874,-85.012741,29.93693,
-85.025528,29.971195,-85.029884,
29.987209,-85.036728,29.990326,
-85.044029,29.988165,-85.049812,
29.989918,-85.056595,30.003069,
-85.072006,30.004595,-85.084251,
30.014402,-85.091583,30.0117,
-85.093246,30.015524,-85.099068,
30.01512,-85.100494,30.017445,
-85.097435,30.01965,-85.097244,
30.023899,-85.099953,30.024176,
-85.1008,30.02099,-85.104614,
30.019968,-85.10881,30.025055,
-85.114754,30.023212,-85.131294,
30.037764,-85.129089,30.042345,
-85.135658,30.043432,-85.136978,
30.063616,-85.132263,30.067266,
-85.137222,30.069363,-85.138443,
30.072578,-85.134666,30.082586,
-85.138687,30.087296,-85.154106,
30.091845,-85.150406,30.096663,
-85.144997,30.097275,-85.148689,
30.111256,-85.141029,30.108664,
-85.141937,30.115248,-85.13308,
30.114779,-85.130318,30.117161,
-85.13192,30.120485,-85.140617,
30.120764,-85.145515,30.124464,
-85.144691,30.128834,-85.137451,
30.134535,-85.137527,30.139496,
-85.132179,30.144217,-85.138725,
30.146698,-85.133141,30.16044,
-85.139862,30.162638,-85.137619,
30.166609,-85.138794,30.172346,
-85.134071,30.175804,-85.134918,
30.18059,-85.126778,30.183659,
-85.121681,30.195259,-85.115936,
30.199778,-85.389702,30.201208)),
'Gulf','12045','Florida','FL','12',564.9599,11504,20.3624);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-83.309586,30.634211,-83.302406,
30.630888,-83.294594,30.63217,
-83.293053,30.629032,-83.27655,
30.628868,-83.271812,30.626921,
-83.267403,30.608624,-83.256714,
30.587523,-83.262886,30.582623,
-83.259872,30.574421,-83.26236,
30.569288,-83.256248,30.561611,
-83.26091,30.552862,-83.253616,
30.548416,-83.247276,30.540646,
-83.246147,30.534943,-83.249451,
30.532055,-83.244919,30.530567,
-83.239037,30.518612,-83.239571,
30.51506,-83.242607,30.516434,
-83.246284,30.512585,-83.240753,
30.505301,-83.242844,30.501017,
-83.240547,30.493698,-83.244743,
30.491772,-83.243706,30.478806,
-83.241821,30.477615,-83.243675,
30.473057,-83.217674,30.463741,
-83.219475,30.460396,-83.217537,
30.455173,-83.222694,30.451553,
-83.217133,30.446585,-83.220207,
30.44404,-83.221977,30.435999,
-83.218452,30.425575,-83.222107,
30.423306,-83.215729,30.417696,
-83.212608,30.420925,-83.209702,
30.420767,-83.205872,30.41181,
-83.203751,30.41449,-83.194397,
30.416437,-83.180229,30.410025,
-83.174469,30.39724,-83.178017,
30.391903,-83.173073,30.390574,
-83.171112,30.385008,-83.169098,
30.390665,-83.164566,30.392553,
-83.165283,30.398129,-83.158485,
30.400366,-83.155449,30.408026,
-83.159737,30.409584,-83.155045,
30.416822,-83.149864,30.418713,
-83.148117,30.41728,-83.141678,
30.422232,-83.135361,30.418419,
-83.129272,30.427296,-83.122223,
30.432192,-83.117477,30.431208,
-83.11132,30.433823,-83.084518,
30.437582,-83.082039,30.442303,
-83.07534,30.425165,-83.068848,
30.424295,-83.067978,30.428236,
-83.059753,30.427092,-83.060333,
30.429659,-83.051399,30.427572,
-83.048912,30.429955,-83.038498,
30.430412,-83.035583,30.428694,
-83.034447,30.430433,-83.015923,
30.422815,-83.008202,30.422178,
-83.00235,30.428659,-83.004837,
30.43148,-82.998016,30.43042,
-82.985008,30.425295,-82.983025,
30.418789,-82.977554,30.419638,
-82.974007,30.417095,-82.972504,
30.418953,-82.971886,30.416937,
-82.966187,30.417234,-82.963776,
30.414738,-82.956238,30.413387,
-82.955795,30.409927,-82.946854,
30.40592,-82.948784,30.400787,
-82.937904,30.398191,-82.935463,
30.394625,-82.932793,30.394785,
-82.929832,30.388597,-82.927719,
30.390638,-82.920685,30.385689,
-82.916145,30.385227,-82.915146,
30.382914,-82.910072,30.382591,
-82.908699,30.379889,-82.907562,
30.383966,-82.902618,30.384104,
-82.905922,30.387747,-82.889351,
30.385885,-82.893616,30.374374,
-82.888832,30.368324,-82.884628,
30.36665,-82.885078,30.364817,
-82.881165,30.366785,-82.872459,
30.36598,-82.871765,30.360685,
-82.868568,30.362019,-82.863701,
30.356911,-82.857895,30.358242,
-82.854431,30.35224,-82.852318,
30.356731,-82.852814,30.348713,
-82.844704,30.340717,-82.841743,
30.342848,-82.836143,30.3423,
-82.831757,30.346266,-82.827133,
30.34528,-82.825867,30.340149,
-82.812874,30.340197,-82.81115,
30.33662,-82.80439,30.345167,
-82.79995,30.343908,-82.794754,
30.336666,-82.792427,30.335382,
-82.793297,30.326721,-82.789291,
30.327499,-82.788177,30.323605,
-82.779381,30.324541,-82.777664,
30.322985,-82.763481,30.330542,
-82.760017,30.32818,-82.760551,
30.323689,-82.745552,30.317038,
-82.736549,30.328295,-82.724747,
30.333544,-82.722839,30.331461,
-82.724983,30.327887,-82.716949,
30.321035,-82.703903,30.332151,
-82.690514,30.332705,-82.68412,
30.33802,-82.681747,30.343542,
-82.68721,30.353212,-82.6838,
30.354038,-82.675377,30.363914,
-82.662743,30.36964,-82.665939,
30.378187,-82.658638,30.383505,
-82.658585,30.390631,-82.650047,
30.391476,-82.64711,30.395073,
-82.645599,30.407698,-82.649719,
30.409166,-82.651604,30.415537,
-82.649269,30.41785,-82.654083,
30.421564,-82.652565,30.428644,
-82.65638,30.431875,-82.659309,
30.440584,-82.662292,30.438637,
-82.673065,30.447737,-82.668434,
30.446566,-82.667351,30.450529,
-82.662987,30.448399,-82.662903,
30.450964,-82.66613,30.453279,
-82.671341,30.45289,-82.680519,
30.461025,-82.681229,30.464121,
-82.675758,30.464691,-82.677582,
30.47159,-82.694145,30.473124,
-82.701599,30.477224,-82.699646,
30.47883,-82.702286,30.483089,
-82.696838,30.484421,-82.697083,
30.489325,-82.706421,30.492302,
-82.705093,30.494501,-82.708694,
30.498648,-82.705544,30.502686,
-82.707687,30.506054,-82.714729,
30.505182,-82.716339,30.507145,
-82.718201,30.520741,-82.723648,
30.517391,-82.72847,30.525389,
-82.727119,30.530956,-82.71431,
30.53174,-82.716568,30.541269,
-82.719322,30.541615,-82.722679,
30.548052,-82.720749,30.553825,
-82.723953,30.553711,-82.726898,
30.558409,-82.72271,30.561045,
-82.72451,30.564505,-82.718216,
30.563038,-82.714859,30.567051,
-82.717552,30.566568,-82.717766,
30.569042,-82.705666,30.57514,
-82.703415,30.581602,-82.706787,
30.583733,-82.695892,30.591616,
-82.696617,30.596176,-82.691818,
30.594343,-82.689415,30.597502,
-83.136749,30.623756,-83.309586,
30.634211)),'Hamilton','12047',
'Florida','FL','12',514.7919,10930,21.2318);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.054543,27.646072,-82.055946,
27.337942,-81.859138,27.336388,
-81.859024,27.339939,-81.563934,
27.340401,-81.563522,27.646303,
-82.054543,27.646072)),'Hardee',
'12049','Florida','FL','12',637.2475,19499,30.5987);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.566292,26.769241,-81.563965,
26.512972,-81.271973,26.516718,
-81.268753,26.252684,-80.880028,
26.259096,-80.881447,26.33345,
-80.88633,26.666071,-80.885857,
26.958586,-80.945564,26.768707,
-81.43528,26.768368,-81.43499,
26.783182,-81.449455,26.783297,
-81.459526,26.783228,-81.459648,
26.768618,-81.566292,26.769241)),
'Hendry','12051','Florida','FL','12',1152.5019,25773,22.3626);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.638695,28.694338,-82.64019,
28.691938,-82.641273,28.68774,
-82.646439,28.683397,-82.646439,
28.676161,-82.654091,28.67037,
-82.651398,28.665199,-82.650162,
28.651552,-82.652641,28.645967,
-82.661331,28.637695,-82.654922,
28.623634,-82.654922,28.617844,
-82.659676,28.610605,-82.658012,
28.601505,-82.650787,28.588062,
-82.649132,28.578758,-82.654076,
28.535728,-82.672775,28.501312,
-82.667168,28.488222,-82.669785,
28.47139,-82.685493,28.464657,
-82.683624,28.45755,-82.670158,
28.457174,-82.667168,28.451191,
-82.673874,28.433416,-82.253632,
28.434549,-82.253685,28.478224,
-82.05545,28.478125,-82.054794,
28.521284,-82.058067,28.52478,
-82.069687,28.531452,-82.094086,
28.523127,-82.103592,28.532774,
-82.109718,28.543867,-82.11821,
28.540518,-82.12896,28.544668,
-82.13578,28.556271,-82.137833,
28.564754,-82.143982,28.565603,
-82.150215,28.570971,-82.155807,
28.572546,-82.166962,28.563614,
-82.168732,28.566593,-82.186699,
28.56843,-82.187241,28.572283,
-82.19194,28.574551,-82.197243,
28.575306,-82.199341,28.572807,
-82.207863,28.571737,-82.213913,
28.575092,-82.219475,28.582384,
-82.22197,28.593363,-82.228928,
28.600515,-82.233505,28.600401,
-82.23439,28.608393,-82.242371,
28.612961,-82.242706,28.61846,
-82.24765,28.622538,-82.24601,
28.625336,-82.248192,28.629206,
-82.253433,28.629353,-82.260384,
28.634766,-82.257042,28.648586,
-82.260796,28.646748,-82.267487,
28.647949,-82.274284,28.654333,
-82.2742,28.660414,-82.267197,
28.660503,-82.268089,28.662384,
-82.263237,28.667366,-82.41819,
28.665632,-82.418533,28.694595,
-82.638695,28.694338)),'Hernando',
'12053','Florida','FL','12',478.2143,101115,211.4427);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.563522,27.646303,-81.563934,
27.340401,-81.563042,27.033033,
-81.342873,27.031988,-81.342155,
27.039263,-81.333214,27.039288,
-81.333214,27.032036,-81.267357,
27.032129,-81.267891,27.12077,
-81.168488,27.121407,-81.169136,
27.209368,-80.943398,27.210276,
-80.942169,27.211597,-80.949608,
27.219542,-80.948143,27.221674,
-80.952675,27.220867,-80.951874,
27.224503,-80.955841,27.222857,
-80.957405,27.219025,-80.964325,
27.217646,-80.961639,27.215033,
-80.970665,27.217169,-80.980751,
27.22998,-80.98542,27.231127,
-80.982597,27.234154,-80.982796,
27.238638,-80.983353,27.24468,
-80.9814,27.243303,-80.981377,
27.246195,-80.993431,27.250877,
-80.992958,27.254026,-80.998077,
27.258978,-80.998253,27.266315,
-81.000946,27.267443,-80.998657,
27.271566,-80.999481,27.280535,
-80.997459,27.281176,-80.999374,
27.283606,-80.997375,27.287849,
-80.998978,27.291496,-80.995071,
27.296541,-81,27.295027,-81.004845,
27.302412,-81.0121,27.300877,
-81.013367,27.297531,-81.015884,
27.301821,-81.016891,27.300192,
-81.020782,27.302555,-81.021225,
27.300308,-81.025558,27.302328,
-81.029228,27.307236,-81.028824,
27.309116,-81.026642,27.308268,
-81.027023,27.313244,-81.028923,
27.312098,-81.032898,27.31946,
-81.029854,27.323364,-81.038109,
27.329691,-81.043549,27.328611,
-81.046425,27.340616,-81.041542,
27.344023,-81.042114,27.347395,
-81.039055,27.346821,-81.035225,
27.35033,-81.033432,27.348377,
-81.036751,27.345881,-81.033409,
27.346407,-81.031143,27.351521,
-81.034943,27.354385,-81.034988,
27.358835,-81.04081,27.359371,
-81.04187,27.362654,-81.051361,
27.3627,-81.053123,27.365068,
-81.049866,27.370007,-81.060974,
27.373482,-81.0634,27.37991,
-81.068741,27.382065,-81.081558,
27.385366,-81.084007,27.381912,
-81.08744,27.381639,-81.086952,
27.379974,-81.093674,27.381323,
-81.09877,27.379124,-81.102112,
27.383045,-81.112999,27.384439,
-81.116913,27.389896,-81.121178,
27.389757,-81.125557,27.394068,
-81.124184,27.396315,-81.126503,
27.401108,-81.123238,27.402805,
-81.132362,27.408312,-81.133133,
27.406134,-81.13678,27.410103,
-81.138481,27.408268,-81.13868,
27.411272,-81.142075,27.411823,
-81.143661,27.415813,-81.141655,
27.4168,-81.140938,27.422993,
-81.138527,27.42399,-81.14109,
27.428196,-81.139206,27.433607,
-81.143555,27.443033,-81.147057,
27.447165,-81.150566,27.445559,
-81.153473,27.450583,-81.151672,
27.452003,-81.158531,27.453403,
-81.15966,27.457073,-81.160179,
27.455673,-81.165031,27.456387,
-81.166603,27.459805,-81.168526,
27.458956,-81.173027,27.463015,
-81.170601,27.467438,-81.176346,
27.472845,-81.181023,27.482231,
-81.189224,27.482164,-81.197296,
27.487988,-81.199562,27.486109,
-81.201385,27.489019,-81.205322,
27.489454,-81.20401,27.498377,
-81.200256,27.499535,-81.202797,
27.502457,-81.201744,27.508417,
-81.198669,27.510063,-81.199699,
27.514742,-81.202011,27.512798,
-81.205193,27.514702,-81.212112,
27.523827,-81.210907,27.527634,
-81.213928,27.528341,-81.211555,
27.530844,-81.208,27.529737,
-81.208809,27.535093,-81.202682,
27.539009,-81.205673,27.542891,
-81.206558,27.546967,-81.198662,
27.545906,-81.196152,27.549656,
-81.192032,27.550451,-81.194824,
27.551311,-81.190216,27.553146,
-81.190834,27.556355,-81.185303,
27.558626,-81.177101,27.557953,
-81.174965,27.564005,-81.170906,
27.56522,-81.166428,27.574392,
-81.164696,27.572456,-81.160019,
27.574093,-81.161232,27.570446,
-81.156822,27.574184,-81.158623,
27.579115,-81.154709,27.586796,
-81.155136,27.591513,-81.149429,
27.59638,-81.142685,27.597385,
-81.140503,27.600595,-81.140785,
27.607935,-81.144997,27.615156,
-81.140167,27.626202,-81.142036,
27.62656,-81.14064,27.628395,
-81.142883,27.629103,-81.141571,
27.632999,-81.144249,27.638227,
-81.141907,27.639353,-81.142395,
27.642929,-81.335602,27.646091,
-81.563522,27.646303)),'Highlands',
'12055','Florida','FL','12',1028.3027,68432,66.5484);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.651344,28.172976,-82.648506,
27.9471,-82.601601,27.937,-82.587997,
27.927999,-82.577705,27.915701,
-82.568901,27.892599,-82.566315,
27.825377,-82.55957,27.827892,
-82.52372,27.833014,-82.492126,
27.822344,-82.472923,27.821489,
-82.460541,27.816368,-82.446877,
27.806122,-82.438347,27.793743,
-82.434929,27.77667,-82.436638,
27.76984,-82.443893,27.759596,
-82.476784,27.747068,-82.482452,
27.742393,-82.478119,27.732044,
-82.479118,27.726034,-82.483795,
27.720692,-82.493141,27.719357,
-82.512505,27.707336,-82.555374,
27.644558,-82.553856,27.645151,
-82.054543,27.646072,-82.05645,
28.171295,-82.106049,28.17136,
-82.416161,28.170755,-82.651344,
28.172976)),'Hillsborough','12057',
'Florida','FL','12',1050.8417,834054,793.7001);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-86.035103,30.993139,-86.037659,
30.704384,-85.844788,30.70294,
-85.845123,30.707781,-85.8423,
30.710661,-85.835289,30.710854,
-85.840027,30.716089,-85.839394,
30.71855,-85.836685,30.717205,
-85.834007,30.721163,-85.834984,
30.726,-85.833199,30.726641,
-85.831696,30.72323,-85.826035,
30.725897,-85.828445,30.730486,
-85.822746,30.735977,-85.823692,
30.738779,-85.829803,30.741409,
-85.824371,30.743811,-85.833092,
30.75,-85.827942,30.752401,
-85.832657,30.759665,-85.82859,
30.761038,-85.830605,30.766884,
-85.827843,30.774778,-85.81707,
30.782501,-85.821678,30.790588,
-85.751999,30.78965,-85.752045,
30.775534,-85.735184,30.775105,
-85.736122,30.74618,-85.618927,
30.743671,-85.621277,30.771349,
-85.603409,30.796652,-85.59919,
30.814436,-85.599838,30.830362,
-85.599838,30.843836,-85.596497,
30.848764,-85.594803,30.858938,
-85.584335,30.874546,-85.583786,
30.882496,-85.575706,30.898354,
-85.558067,30.915701,-85.55407,
30.925003,-85.547722,30.932198,
-85.538254,30.933962,-85.530418,
30.939253,-85.532539,30.95896,
-85.529282,30.974258,-85.522125,
30.975477,-85.498337,30.996748,
-86.035103,30.993139)),'Holmes',
'12059','Florida','FL','12',482.4624,15778,32.703);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-80.869095,27.822218,-80.88179,
27.822268,-80.88047,27.733389,
-80.874016,27.733547,-80.873375,
27.641996,-80.778267,27.642885,
-80.777382,27.55842,-80.680038,
27.558155,-80.320541,27.556797,
-80.331184,27.597231,-80.345551,
27.617544,-80.351326,27.62991,
-80.351944,27.642315,-80.383926,
27.73974,-80.446709,27.86046,
-80.447311,27.860455,-80.454865,
27.854357,-80.49131,27.854301,
-80.495018,27.850636,-80.497047,
27.838221,-80.507561,27.827686,
-80.5093,27.821756,-80.869095,
27.822218)),'IndianRiver','12061',
'Florida','FL','12',503.1625,90208,179.2818);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-85.488365,30.996883,-85.498337,
30.996748,-85.522125,30.975477,
-85.529282,30.974258,-85.532539,
30.95896,-85.530418,30.939253,
-85.538254,30.933962,-85.547722,
30.932198,-85.55407,30.925003,
-85.558067,30.915701,-85.575706,
30.898354,-85.583786,30.882496,
-85.584335,30.874546,-85.594803,
30.858938,-85.596497,30.848764,
-85.599838,30.843836,-85.599838,
30.830362,-85.482346,30.829597,
-85.482994,30.785686,-85.432343,
30.785267,-85.435112,30.567474,
-85.384209,30.566652,-85.171959,
30.564142,-85.173683,30.574751,
-85.173073,30.577866,-85.169357,
30.579996,-85.172089,30.587696,
-85.16729,30.595509,-85.165306,
30.60504,-85.168007,30.60783,
-84.932602,30.606199,-84.927597,
30.612301,-84.912003,30.617001,
-84.905304,30.6224,-84.903801,
30.6376,-84.893105,30.6465,
-84.889305,30.6614,-84.875,30.671801,
-84.858421,30.69643,-84.864777,
30.711351,-84.869835,30.721706,
-84.883904,30.732401,-84.887604,
30.7416,-84.896202,30.750401,
-84.907402,30.750401,-84.914307,
30.753201,-84.915108,30.761,
-84.920197,30.7658,-84.918106,
30.777901,-84.927902,30.7918,
-84.928398,30.804899,-84.937508,
30.8207,-84.935402,30.8347,
-84.932198,30.8381,-84.926903,
30.8389,-84.925705,30.842501,
-84.936203,30.8568,-84.936501,
30.8596,-84.932404,30.8641,
-84.939903,30.8724,-84.934502,
30.8834,-84.942596,30.8883,-84.9562,
30.9074,-84.966797,30.917101,
-84.971107,30.927999,-84.9832,
30.934601,-84.980202,30.9611,
-84.984901,30.9673,-85,30.971001,
-85.005173,30.97452,-85.002441,
31.000498,-85.243706,31.0007,
-85.488365,30.996883)),'Jackson',
'12063','Florida','FL','12',915.6186,41375,45.1879);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-84.007507,30.6719,-84.007797,
30.6091,-84.003197,30.6071,
-84.002602,30.58675,-83.996223,
30.577316,-83.998138,30.571274,
-83.990738,30.560396,-83.979301,
30.551195,-83.980438,30.549479,
-83.983643,30.551538,-83.987106,
30.547186,-83.983047,30.537752,
-83.984055,30.53212,-83.97728,
30.521786,-84.041306,30.5217,
-84.041603,30.4631,-84.074799,
30.434099,-84.075668,30.273415,
-84.075592,30.09457,-84.058701,
30.100201,-84.04377,30.101744,
-84.019562,30.101231,-84.011322,
30.097624,-84.001015,30.096594,
-83.991798,30.088089,-83.992302,
30.096001,-83.988106,30.103399,
-83.984596,30.104799,-83.977646,
30.122894,-83.969009,30.135712,
-83.972878,30.140129,-83.973465,
30.145695,-83.960686,30.151766,
-83.963036,30.157421,-83.957893,
30.161968,-83.957237,30.174002,
-83.953026,30.175379,-83.950203,
30.187599,-83.939705,30.1915,
-83.929604,30.189301,-83.926308,
30.1919,-83.927505,30.1947,
-83.923798,30.198799,-83.924797,
30.205952,-83.917519,30.217379,
-83.919098,30.219873,-83.916695,
30.225254,-83.921631,30.228643,
-83.916061,30.233683,-83.915962,
30.244858,-83.910027,30.247469,
-83.902611,30.247168,-83.902931,
30.248955,-83.897118,30.252146,
-83.896011,30.257366,-83.879486,
30.268972,-83.863441,30.271053,
-83.854469,30.273783,-83.853241,
30.277218,-83.844872,30.27738,
-83.838387,30.28171,-83.836983,
30.280725,-83.833794,30.286337,
-83.828812,30.28817,-83.829338,
30.291491,-83.827141,30.291422,
-83.825722,30.296988,-83.819809,
30.29969,-83.820045,30.303331,
-83.818146,30.304155,-83.821831,
30.307133,-83.820763,30.31192,
-83.815483,30.316891,-83.81076,
30.317852,-83.801178,30.315172,
-83.792465,30.318928,-83.787605,
30.32818,-83.787529,30.331936,
-83.793198,30.334799,-83.799355,
30.346823,-83.807594,30.348312,
-83.80426,30.352915,-83.807938,
30.36441,-83.805153,30.376324,
-83.79583,30.382233,-83.790474,
30.389879,-83.78788,30.388323,
-83.788383,30.382483,-83.782623,
30.379183,-83.780273,30.381611,
-83.766434,30.38188,-83.757851,
30.384993,-83.756203,30.396168,
-83.752182,30.398478,-83.750969,
30.408304,-83.746002,30.411758,
-83.739876,30.421333,-83.733376,
30.423672,-83.726639,30.432264,
-83.722038,30.433891,-83.723457,
30.442934,-83.728241,30.453884,
-83.723747,30.461123,-83.724937,
30.467878,-83.728905,30.472481,
-83.727119,30.48826,-83.735664,
30.498335,-83.736801,30.508137,
-83.726067,30.522888,-83.704483,
30.522818,-83.704353,30.537807,
-83.671188,30.537815,-83.671242,
30.552658,-83.637535,30.552467,
-83.637657,30.567268,-83.621315,
30.567148,-83.620857,30.581778,
-83.604309,30.581713,-83.604523,
30.638037,-83.612297,30.638538,
-83.611794,30.651054,-83.743996,
30.658188,-84.007507,30.6719)),
'Jefferson','12065','Florida','FL','12',597.685,11296,18.8995);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-83.367279,30.260244,-83.371033,
29.887714,-83.353127,29.887638,
-83.352997,29.822001,-83.319,
29.822399,-82.959206,29.825209,
-82.958946,29.823717,-82.920761,
29.823912,-82.918861,29.823853,
-82.904114,29.824062,-82.893021,
29.827229,-82.888557,29.849884,
-82.875771,29.866297,-82.876183,
29.884169,-82.879951,29.886616,
-82.884033,29.882257,-82.890251,
29.884686,-82.89325,29.889339,
-82.890999,29.890682,-82.886055,
29.887766,-82.885315,29.891346,
-82.898018,29.901211,-82.903908,
29.900724,-82.907784,29.897907,
-82.909149,29.889263,-82.915703,
29.891562,-82.918617,29.89794,
-82.912254,29.904606,-82.919159,
29.908026,-82.918739,29.914843,
-82.926033,29.921103,-82.920692,
29.929842,-82.92411,29.936287,
-82.923691,29.943077,-82.930939,
29.95717,-82.952553,29.959133,
-82.954292,29.966196,-82.960526,
29.974926,-82.963997,29.994318,
-82.974297,29.996408,-82.979568,
30.007166,-82.994759,30.005806,
-83.001465,30.008564,-83.013443,
30.031898,-83.027046,30.043161,
-83.034866,30.045559,-83.041649,
30.054344,-83.065117,30.064344,
-83.070274,30.070368,-83.069695,
30.081028,-83.087563,30.08272,
-83.099907,30.091084,-83.112053,
30.090933,-83.114204,30.093405,
-83.114388,30.102201,-83.117912,
30.10437,-83.123039,30.104158,
-83.133705,30.096701,-83.140701,
30.1033,-83.150101,30.103901,
-83.162598,30.1098,-83.167801,
30.100599,-83.179398,30.099199,
-83.184502,30.093901,-83.195396,
30.104401,-83.201202,30.1056,
-83.213707,30.1031,-83.2258,30.1131,
-83.225273,30.137772,-83.238838,
30.15254,-83.232384,30.16044,
-83.231743,30.16662,-83.247253,
30.179527,-83.250137,30.190268,
-83.250214,30.200424,-83.239822,
30.226522,-83.25,30.231459,
-83.252846,30.235434,-83.25116,
30.242922,-83.242554,30.247948,
-83.244194,30.249355,-83.250328,
30.247417,-83.253067,30.250395,
-83.251846,30.25852,-83.247391,
30.260452,-83.367279,30.260244)),
'Lafayette','12067','Florida','FL','12',542.7358,5578,10.2775);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.954384,28.959791,-81.954384,
28.55584,-81.95784,28.344896,
-81.857712,28.34568,-81.857826,
28.361584,-81.791084,28.361551,
-81.790932,28.346128,-81.657471,
28.346848,-81.657303,28.5625,
-81.656998,28.5688,-81.652802,
28.570601,-81.652,28.578699,
-81.648003,28.584299,-81.657402,
28.5924,-81.658928,28.778597,
-81.653458,28.782679,-81.647301,
28.781601,-81.648819,28.784273,
-81.646904,28.785601,-81.4142,
28.785299,-81.413925,28.793907,
-81.4198,28.814899,-81.417053,
28.824305,-81.408478,28.833797,
-81.394867,28.841845,-81.390427,
28.848602,-81.383301,28.851566,
-81.375214,28.862003,-81.374115,
28.869781,-81.372597,28.868799,
-81.366531,28.87336,-81.367149,
28.87896,-81.363281,28.878784,
-81.366173,28.88448,-81.365166,
28.889441,-81.357315,28.886784,
-81.354797,28.892817,-81.355774,
28.896769,-81.352882,28.896273,
-81.357773,28.899376,-81.360382,
28.906384,-81.35688,28.910273,
-81.359505,28.914177,-81.35434,
28.920641,-81.352142,28.920481,
-81.355583,28.929665,-81.351646,
28.932575,-81.353584,28.936928,
-81.349854,28.939024,-81.355331,
28.939745,-81.353554,28.946655,
-81.359505,28.944351,-81.353996,
28.94928,-81.360451,28.951296,
-81.358994,28.955744,-81.367744,
28.954992,-81.370834,28.957567,
-81.365822,28.960705,-81.369598,
28.968639,-81.364288,28.968288,
-81.360977,28.976513,-81.355438,
28.982271,-81.35611,28.986784,
-81.364624,28.992464,-81.375885,
28.993736,-81.372414,28.99824,
-81.378365,28.998678,-81.380905,
29.007298,-81.38839,29.010447,
-81.388412,29.016865,-81.391441,
29.019842,-81.395554,29.019388,
-81.394882,29.024265,-81.402969,
29.03241,-81.410118,29.031239,
-81.413467,29.037189,-81.419868,
29.03838,-81.426041,29.044722,
-81.432457,29.044296,-81.446289,
29.061871,-81.455498,29.062811,
-81.455978,29.071287,-81.461067,
29.075493,-81.45993,29.078941,
-81.45459,29.081724,-81.458672,
29.093573,-81.468063,29.096785,
-81.487175,29.092651,-81.5,29.096001,
-81.502266,29.097544,-81.500526,
29.102245,-81.502808,29.106195,
-81.506126,29.113325,-81.504471,
29.122391,-81.523506,29.156601,
-81.523308,29.167299,-81.531502,
29.171101,-81.532303,29.176901,
-81.543999,29.180201,-81.547905,
29.184601,-81.554398,29.184299,
-81.554001,29.188101,-81.561203,
29.1999,-81.572365,29.203245,
-81.595596,29.198814,-81.61219,
29.202866,-81.617157,29.209419,
-81.615105,29.217077,-81.618149,
29.225822,-81.634315,29.245049,
-81.634018,29.254045,-81.642105,
29.276739,-81.638901,29.047501,
-81.659401,29.047501,-81.658905,
28.960186,-81.954384,28.959791)),
'Lake','12069','Florida','FL','12',952.9414,152104,159.6151);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2007,8265,null,
MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,21,1003,1,67,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.271904,26.78894,-82.269249,
26.782633,-82.264862,26.754793,
-82.264832,26.719036,-82.260345,
26.716927,-82.257217,26.735903,
-82.249046,26.760405,-82.237465,
26.784218,-82.264862,26.789087,
-82.271904,26.78894,-82.098305,
26.424601,-82.075203,26.421698,
-82.056,26.428301,-82.014107,26.4517,
-82.0168,26.453699,-82.031601,
26.452099,-82.060768,26.468779,
-82.076042,26.465912,-82.088448,
26.454775,-82.09227,26.455412,
-82.10659,26.466232,-82.129494,
26.477688,-82.14859,26.478006,
-82.160049,26.484053,-82.175957,
26.50028,-82.195045,26.550554,
-82.19899,26.55294,-82.202301,
26.551708,-82.180901,26.475901,
-82.173103,26.4673,-82.148903,
26.455097,-82.126854,26.435921,
-82.098305,26.424601,-82.061882,
26.770311,-82.067146,26.742161,
-82.083275,26.709538,-82.087669,
26.68498,-82.092064,26.675083,
-82.092064,26.666655,-82.096466,
26.663721,-82.104156,26.665188,
-82.124321,26.699276,-82.139793,
26.704245,-82.166374,26.706211,
-82.176224,26.702766,-82.182625,
26.696857,-82.185081,26.686028,
-82.181145,26.679628,-82.168839,
26.67569,-82.164894,26.666336,
-82.15358,26.658459,-82.145699,
26.647629,-82.132896,26.614641,
-82.111725,26.529966,-82.106316,
26.516674,-82.102379,26.496489,
-82.106812,26.488611,-82.104836,
26.48418,-82.093513,26.485167,
-82.070862,26.49255,-82.044777,
26.49255,-82.010811,26.48418,
-81.978806,26.47975,-81.970924,
26.472858,-81.963997,26.468651,
-81.966995,26.46055,-81.961082,
26.454145,-81.928093,26.438889,
-81.907913,26.423134,-81.902496,
26.415749,-81.902496,26.40984,
-81.870003,26.37735,-81.854744,
26.349779,-81.846962,26.329998,
-81.819344,26.330116,-81.819183,
26.31588,-81.658096,26.317228,
-81.659706,26.420719,-81.562378,
26.422268,-81.563965,26.512972,
-81.566292,26.769241,-82.061882,
26.770311)),'Lee','12071','Florida',
'FL','12',803.4653,335113,417.0842);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-84.281311,30.685062,-84.287933,
30.683802,-84.288681,30.68133,
-84.290588,30.683575,-84.292175,
30.680574,-84.297691,30.682087,
-84.298378,30.678629,-84.30098,
30.679682,-84.300552,30.676682,
-84.298569,30.676636,-84.300026,
30.67375,-84.304291,30.67627,
-84.302963,30.672745,-84.305458,
30.668875,-84.300446,30.664543,
-84.302811,30.662643,-84.299545,
30.66152,-84.302246,30.659437,
-84.301666,30.656414,-84.30426,
30.656345,-84.300125,30.653688,
-84.302017,30.651054,-84.30101,
30.639032,-84.305695,30.637289,
-84.305756,30.632689,-84.313126,
30.630541,-84.312477,30.626734,
-84.315254,30.625887,-84.317307,
30.621201,-84.318825,30.622089,
-84.318878,30.61891,-84.321907,
30.62071,-84.323715,30.61783,
-84.327301,30.61194,-84.326309,
30.60812,-84.328621,30.609579,
-84.329102,30.60671,-84.331161,
30.60676,-84.33075,30.60338,
-84.333679,30.60034,-84.330566,
30.60006,-84.332504,30.596201,
-84.33934,30.59708,-84.340302,
30.599939,-84.343307,30.596781,
-84.344154,30.598921,-84.343468,
30.595209,-84.346748,30.59358,
-84.349045,30.595409,-84.346771,
30.591761,-84.349983,30.592899,
-84.35479,30.591089,-84.360062,
30.58432,-84.364182,30.585079,
-84.364403,30.582911,-84.369308,
30.582529,-84.372711,30.577181,
-84.374489,30.57766,-84.372398,
30.5756,-84.3778,30.57398,-84.378471,
30.567711,-84.382011,30.562759,
-84.379005,30.55965,-84.384102,
30.5536,-84.38829,30.549219,
-84.391594,30.532829,-84.391846,
30.52947,-84.388878,30.52669,
-84.391846,30.525419,-84.390701,
30.5198,-84.393463,30.520479,
-84.391876,30.51701,-84.395851,
30.516399,-84.392807,30.51483,
-84.39579,30.51486,-84.39489,
30.51243,-84.397125,30.513861,
-84.404747,30.50794,-84.402397,
30.5049,-84.404831,30.49901,
-84.402359,30.499241,-84.401428,
30.494049,-84.398689,30.494431,
-84.395508,30.4904,-84.397652,
30.488211,-84.397072,30.483509,
-84.402435,30.48041,-84.402702,
30.4758,-84.407906,30.4727,
-84.421005,30.463619,-84.42347,
30.46373,-84.423798,30.467199,
-84.433281,30.463659,-84.434708,
30.466,-84.437981,30.461029,
-84.452637,30.462099,-84.460602,
30.455709,-84.47261,30.46011,
-84.474068,30.457741,-84.481102,
30.458927,-84.484909,30.455999,
-84.495399,30.4601,-84.499268,
30.45285,-84.504478,30.450708,
-84.520447,30.451191,-84.526237,
30.447302,-84.530655,30.439606,
-84.546013,30.440258,-84.546227,
30.436481,-84.557365,30.435795,
-84.55957,30.433819,-84.561569,
30.437702,-84.566795,30.433334,
-84.565002,30.430799,-84.567223,
30.431036,-84.568916,30.426664,
-84.579842,30.419535,-84.580505,
30.416914,-84.591103,30.411531,
-84.607246,30.415899,-84.61277,
30.40995,-84.625,30.408903,
-84.639763,30.396294,-84.642975,
30.397936,-84.648026,30.394167,
-84.645691,30.391413,-84.646553,
30.388184,-84.663521,30.378107,
-84.663689,30.371099,-84.669304,
30.364941,-84.672699,30.363907,
-84.68055,30.367786,-84.681274,
30.361534,-84.684258,30.360413,
-84.68541,30.355137,-84.682838,
30.354254,-84.686272,30.352531,
-84.685089,30.349913,-84.693161,
30.348234,-84.694016,30.345381,
-84.696587,30.34631,-84.701271,
30.343197,-84.703568,30.335978,
-84.71508,30.332756,-84.710419,
30.324047,-84.7033,30.322517,
-84.700989,30.318085,-84.71344,
30.299974,-84.247772,30.303291,
-84.241325,30.274042,-84.075668,
30.273415,-84.074799,30.434099,
-84.041603,30.4631,-84.041306,
30.5217,-83.97728,30.521786,
-83.984055,30.53212,-83.983047,
30.537752,-83.987106,30.547186,
-83.983643,30.551538,-83.980438,
30.549479,-83.979301,30.551195,
-83.990738,30.560396,-83.998138,
30.571274,-83.996223,30.577316,
-84.002602,30.58675,-84.003197,
30.6071,-84.007797,30.6091,
-84.007507,30.6719,-84.083794,
30.675604,-84.281311,30.685062)),
'Leon','12073','Florida','FL','12',666.6806,192493,288.7331);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.937492,29.591003,-82.937843,
29.586943,-82.943245,29.584991,
-82.944618,29.582067,-82.948898,
29.565668,-82.948059,29.557297,
-82.959511,29.553011,-82.977501,
29.539658,-82.978714,29.531633,
-82.969551,29.522079,-82.972832,
29.517033,-82.979607,29.518185,
-82.983032,29.515209,-82.984467,
29.496088,-82.982018,29.485182,
-82.986961,29.476309,-82.984657,
29.469673,-82.990089,29.46311,
-83.000664,29.46241,-83.002144,
29.456293,-83.012993,29.445663,
-83.012962,29.439533,-83.021339,
29.43096,-83.021088,29.427036,
-83.015984,29.421171,-83.018105,
29.418392,-83.025063,29.420109,
-83.027031,29.418711,-83.021919,
29.412863,-83.026024,29.405449,
-83.023399,29.398329,-83.025574,
29.396776,-83.033112,29.397711,
-83.034019,29.390314,-83.045532,
29.380444,-83.056274,29.378229,
-83.06575,29.372425,-83.066078,
29.36824,-83.062401,29.363993,
-83.072197,29.353624,-83.061569,
29.352446,-83.060677,29.34922,
-83.068672,29.343716,-83.082352,
29.339621,-83.090546,29.332514,
-83.098953,29.336628,-83.104675,
29.325203,-83.112038,29.324446,
-83.113098,29.317902,-83.120804,
29.317385,-83.119026,29.315104,
-83.108475,29.271318,-83.094391,
29.26586,-83.082039,29.264137,
-83.074577,29.24403,-83.069122,
29.239433,-83.068253,29.234552,
-83.069122,29.23053,-83.073715,
29.229094,-83.078316,29.221052,
-83.069687,29.213297,-83.070549,
29.191465,-83.053322,29.174232,
-83.023735,29.166763,-83.015976,
29.167625,-83.001328,29.175669,
-82.987541,29.177677,-82.980072,
29.170498,-82.947327,29.167337,
-82.91861,29.167912,-82.876381,
29.160444,-82.847366,29.163031,
-82.835304,29.153837,-82.820366,
29.159582,-82.812042,29.157284,
-82.808304,29.153837,-82.805145,
29.14838,-82.806587,29.127413,
-82.799973,29.107592,-82.801987,
29.094091,-82.812904,29.084614,
-82.816353,29.079729,-82.815773,
29.07571,-82.785042,29.075422,
-82.781593,29.07255,-82.782166,
29.062784,-82.760338,29.056463,
-82.757462,29.051582,-82.758331,
29.035496,-82.752296,29.026304,
-82.754303,29.015102,-82.76178,
28.99758,-82.75753,28.99435,
-82.754623,28.997726,-82.75573,
29.001608,-82.742561,29.007772,
-82.741241,29.011831,-82.728539,
29.014494,-82.720512,29.025223,
-82.713036,29.030149,-82.690315,
29.033592,-82.684082,29.030268,
-82.677849,29.030313,-82.676079,
29.025982,-82.67337,29.025227,
-82.644554,29.01988,-82.641167,
29.021254,-82.638733,29.017672,
-82.631287,29.016024,-82.62941,
29.013617,-82.612831,29.00902,
-82.602303,29.013201,-82.601852,
29.021042,-82.596176,29.029314,
-82.577148,29.027815,-82.572372,
29.032444,-82.564316,29.035566,
-82.55619,29.033611,-82.54599,
29.041542,-82.538261,29.041998,
-82.535767,29.044603,-82.536125,
29.214493,-82.403336,29.215374,
-82.406792,29.484802,-82.496414,
29.485254,-82.496506,29.478127,
-82.556892,29.479916,-82.556671,
29.537313,-82.656494,29.535378,
-82.656601,29.564573,-82.756615,
29.562225,-82.757034,29.57744,
-82.773186,29.577408,-82.773071,
29.584641,-82.856659,29.583965,
-82.856766,29.591078,-82.937492,
29.591003)),'Levy','12075','Florida',
'FL','12',1118.25,25923,23.1817);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-84.932602,30.606199,-84.936501,
30.599501,-84.945,30.595301,
-84.945198,30.580799,-84.9524,
30.5784,-84.962196,30.5823,
-84.965508,30.58,-84.965401,30.5714,
-84.961601,30.564899,-84.973801,
30.552799,-84.992363,30.519119,
-84.991104,30.504101,-84.994545,
30.48888,-85.004395,30.476015,-85,
30.472221,-84.988403,30.471922,
-84.986771,30.466356,-85,30.456003,
-85.001617,30.449587,-84.995499,
30.44491,-84.982887,30.447435,
-84.981316,30.443933,-84.983292,
30.441643,-85.015266,30.434166,
-85.031967,30.422453,-85.032936,
30.418125,-85.02951,30.412811,
-85.018181,30.413403,-85.013741,
30.410452,-85.016014,30.407804,
-85.029968,30.403074,-85.027519,
30.398226,-85.015648,30.395975,
-85.014687,30.387197,-85.025185,
30.375645,-85.031326,30.378462,
-85.040283,30.371895,-85.038658,
30.365435,-85.027512,30.364962,
-85.026085,30.362848,-85.040466,
30.35552,-85.050056,30.337973,
-85.04435,30.328594,-85.046379,
30.319988,-85.035088,30.314898,
-85.034378,30.312283,-85.039192,
30.309731,-85.048233,30.312473,
-85.050552,30.309935,-85.047539,
30.30287,-85.055077,30.304638,
-85.057007,30.303263,-85.052818,
30.286772,-85.059669,30.284832,
-85.058083,30.275894,-85.064163,
30.270222,-85.059799,30.261353,
-85.067825,30.258568,-85.070114,
30.249195,-85.077812,30.25,
-85.078545,30.2423,-85.083328,
30.238466,-85.080635,30.229109,
-85.091217,30.229317,-85.090607,
30.222557,-85.098961,30.219772,
-85.100403,30.212328,-85.110504,
30.218203,-85.112061,30.21595,
-85.110039,30.209145,-85.119026,
30.209625,-85.115936,30.199778,
-85.121681,30.195259,-85.126778,
30.183659,-85.134918,30.18059,
-85.134071,30.175804,-85.138794,
30.172346,-85.137619,30.166609,
-85.139862,30.162638,-85.133141,
30.16044,-85.138725,30.146698,
-85.132179,30.144217,-85.137527,
30.139496,-85.137451,30.134535,
-85.144691,30.128834,-85.145515,
30.124464,-85.140617,30.120764,
-85.13192,30.120485,-85.130318,
30.117161,-85.13308,30.114779,
-85.141937,30.115248,-85.141029,
30.108664,-85.148689,30.111256,
-85.144997,30.097275,-85.150406,
30.096663,-85.154106,30.091845,
-85.138687,30.087296,-85.134666,
30.082586,-85.138443,30.072578,
-85.137222,30.069363,-85.132263,
30.067266,-85.136978,30.063616,
-85.135658,30.043432,-85.129089,
30.042345,-85.131294,30.037764,
-85.114754,30.023212,-85.10881,
30.025055,-85.104614,30.019968,
-85.1008,30.02099,-85.099953,
30.024176,-85.097244,30.023899,
-85.097435,30.01965,-85.100494,
30.017445,-85.099068,30.01512,
-85.093246,30.015524,-85.091583,
30.0117,-85.084251,30.014402,
-85.072006,30.004595,-85.056595,
30.003069,-85.049812,29.989918,
-85.044029,29.988165,-85.036728,
29.990326,-85.029884,29.987209,
-85.025528,29.971195,-85.018394,
29.980631,-85.014854,29.997355,
-85.009766,30,-85.010696,30.005083,
-85.005562,30.00939,-85.007805,
30.013721,-84.815346,30.011141,
-84.544739,30.010826,-84.543121,
30.012632,-84.546761,30.015268,
-84.548157,30.011208,-84.550667,
30.014406,-84.555794,30.014633,
-84.557625,30.021616,-84.562965,
30.022449,-84.561653,30.019911,
-84.565636,30.017126,-84.56842,
30.020197,-84.569572,30.016422,
-84.591141,30.029434,-84.599411,
30.038698,-84.59726,30.041113,
-84.59333,30.039982,-84.594276,
30.04211,-84.600105,30.042984,
-84.596741,30.046764,-84.603996,
30.046144,-84.609039,30.058306,
-84.615768,30.064793,-84.620682,
30.066496,-84.622093,30.063377,
-84.62619,30.062187,-84.626244,
30.065239,-84.63089,30.064926,
-84.628021,30.0688,-84.63324,
30.068266,-84.635368,30.071964,
-84.632866,30.073139,-84.639267,
30.078979,-84.637993,30.083549,
-84.641907,30.082479,-84.644867,
30.091078,-84.649765,30.092779,
-84.651505,30.097248,-84.654243,
30.09679,-84.654602,30.100042,
-84.650856,30.100851,-84.652428,
30.102934,-84.648308,30.104855,
-84.651955,30.104181,-84.651932,
30.106764,-84.648384,30.109085,
-84.653374,30.117983,-84.656502,
30.117006,-84.65728,30.113861,
-84.660255,30.11541,-84.661194,
30.120068,-84.667511,30.122465,
-84.665962,30.12397,-84.66935,30.125,
-84.670471,30.127968,-84.665543,
30.134287,-84.668152,30.134926,
-84.667091,30.137051,-84.669991,
30.137226,-84.672318,30.141033,
-84.668419,30.143106,-84.669296,
30.146576,-84.671768,30.147011,
-84.670464,30.149639,-84.67263,
30.150206,-84.668907,30.152266,
-84.670708,30.157555,-84.667732,
30.161238,-84.669197,30.163359,
-84.667091,30.163784,-84.669678,
30.165264,-84.665215,30.166262,
-84.667496,30.168177,-84.665016,
30.1698,-84.670128,30.173449,
-84.668175,30.17462,-84.668335,
30.182123,-84.670525,30.184767,
-84.672646,30.183887,-84.672684,
30.186794,-84.674438,30.183622,
-84.678345,30.187904,-84.676064,
30.200964,-84.681656,30.20219,
-84.680191,30.206841,-84.682144,
30.218122,-84.687737,30.221907,
-84.694702,30.222298,-84.695595,
30.227135,-84.69976,30.2276,
-84.697388,30.228943,-84.701599,
30.234913,-84.698685,30.233381,
-84.699181,30.236174,-84.697205,
30.23667,-84.700745,30.24321,
-84.698357,30.24552,-84.70562,
30.251617,-84.708977,30.253288,
-84.712311,30.250242,-84.715805,
30.251322,-84.726692,30.256521,
-84.7379,30.265457,-84.736641,
30.267715,-84.732254,30.267746,
-84.731033,30.27496,-84.727753,
30.275648,-84.727341,30.278194,
-84.730927,30.280243,-84.729294,
30.287239,-84.71344,30.299974,
-84.700989,30.318085,-84.7033,
30.322517,-84.710419,30.324047,
-84.71508,30.332756,-84.703568,
30.335978,-84.701271,30.343197,
-84.696587,30.34631,-84.694016,
30.345381,-84.693161,30.348234,
-84.685089,30.349913,-84.686272,
30.352531,-84.682838,30.354254,
-84.68541,30.355137,-84.684258,
30.360413,-84.681274,30.361534,
-84.68055,30.367786,-84.672699,
30.363907,-84.669304,30.364941,
-84.663689,30.371099,-84.663521,
30.378107,-84.646553,30.388184,
-84.68071,30.387852,-84.680618,
30.417074,-84.714211,30.417004,
-84.714188,30.460205,-84.781197,
30.4596,-84.781906,30.518499,
-84.815704,30.518299,-84.815903,
30.5329,-84.882706,30.5329,-84.8834,
30.6054,-84.932602,30.606199)),
'Liberty','12077','Florida','FL','12',835.7866,5569,6.6631);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-83.611794,30.651054,-83.612297,
30.638538,-83.604523,30.638037,
-83.604309,30.581713,-83.620857,
30.581778,-83.621315,30.567148,
-83.637657,30.567268,-83.637535,
30.552467,-83.671242,30.552658,
-83.671188,30.537815,-83.704353,
30.537807,-83.704483,30.522818,
-83.726067,30.522888,-83.736801,
30.508137,-83.735664,30.498335,
-83.727119,30.48826,-83.728905,
30.472481,-83.724937,30.467878,
-83.723747,30.461123,-83.728241,
30.453884,-83.723457,30.442934,
-83.722038,30.433891,-83.726639,
30.432264,-83.733376,30.423672,
-83.739876,30.421333,-83.746002,
30.411758,-83.750969,30.408304,
-83.752182,30.398478,-83.756203,
30.396168,-83.757851,30.384993,
-83.766434,30.38188,-83.780273,
30.381611,-83.782623,30.379183,
-83.788383,30.382483,-83.78788,
30.388323,-83.790474,30.389879,
-83.79583,30.382233,-83.805153,
30.376324,-83.807938,30.36441,
-83.80426,30.352915,-83.807594,
30.348312,-83.799355,30.346823,
-83.793198,30.334799,-83.787529,
30.331936,-83.787605,30.32818,
-83.792465,30.318928,-83.801178,
30.315172,-83.81076,30.317852,
-83.815483,30.316891,-83.820763,
30.31192,-83.821831,30.307133,
-83.818146,30.304155,-83.820045,
30.303331,-83.468903,30.304001,
-83.469398,30.260099,-83.367279,
30.260244,-83.247391,30.260452,
-83.237099,30.261408,-83.240433,
30.266806,-83.231812,30.283598,
-83.233147,30.291801,-83.225929,
30.301048,-83.212646,30.307055,
-83.210068,30.311661,-83.214493,
30.319616,-83.208038,30.33087,
-83.212898,30.344124,-83.211693,
30.347263,-83.207832,30.350555,
-83.203125,30.350683,-83.199364,
30.348,-83.190384,30.35166,
-83.193726,30.357409,-83.193008,
30.373816,-83.177849,30.383974,
-83.171112,30.385008,-83.173073,
30.390574,-83.178017,30.391903,
-83.174469,30.39724,-83.180229,
30.410025,-83.194397,30.416437,
-83.203751,30.41449,-83.205872,
30.41181,-83.209702,30.420767,
-83.212608,30.420925,-83.215729,
30.417696,-83.222107,30.423306,
-83.218452,30.425575,-83.221977,
30.435999,-83.220207,30.44404,
-83.217133,30.446585,-83.222694,
30.451553,-83.217537,30.455173,
-83.219475,30.460396,-83.217674,
30.463741,-83.243675,30.473057,
-83.241821,30.477615,-83.243706,
30.478806,-83.244743,30.491772,
-83.240547,30.493698,-83.242844,
30.501017,-83.240753,30.505301,
-83.246284,30.512585,-83.242607,
30.516434,-83.239571,30.51506,
-83.239037,30.518612,-83.244919,
30.530567,-83.249451,30.532055,
-83.246147,30.534943,-83.247276,
30.540646,-83.253616,30.548416,
-83.26091,30.552862,-83.256248,
30.561611,-83.26236,30.569288,
-83.259872,30.574421,-83.262886,
30.582623,-83.256714,30.587523,
-83.267403,30.608624,-83.271812,
30.626921,-83.27655,30.628868,
-83.293053,30.629032,-83.294594,
30.63217,-83.302406,30.630888,
-83.309586,30.634211,-83.341141,
30.636141,-83.357193,30.637115,
-83.611794,30.651054)),'Madison',
'12079','Florida','FL','12',691.8383,16569,23.9492);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.555374,27.644558,-82.564255,
27.631546,-82.564926,27.619526,
-82.569939,27.611177,-82.582962,
27.596823,-82.588295,27.593817,
-82.596313,27.593817,-82.609001,
27.581797,-82.612007,27.571779,
-82.627029,27.558758,-82.647064,
27.533384,-82.662422,27.523033,
-82.675774,27.518692,-82.70816,
27.523033,-82.742615,27.539047,
-82.746521,27.537678,-82.744705,
27.5331,-82.714272,27.500116,
-82.6912,27.444044,-82.692001,
27.436899,-82.675301,27.424,
-82.642998,27.3894,-82.642792,
27.389099,-82.449402,27.3881,
-82.447037,27.385698,-82.252457,
27.385921,-82.253784,27.208588,
-82.056686,27.207441,-82.055946,
27.337942,-82.054543,27.646072,
-82.553856,27.645151,-82.555374,
27.644558)),'Manatee','12081',
'Florida','FL','12',741.0742,211707,285.6755);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.406792,29.484802,-82.403336,
29.215374,-82.536125,29.214493,
-82.535767,29.044603,-82.533943,
29.043158,-82.535294,29.040676,
-82.532112,29.040804,-82.530556,
29.043377,-82.52523,29.042751,
-82.525871,29.040604,-82.523651,
29.041931,-82.522537,29.039392,
-82.517204,29.041798,-82.517197,
29.044027,-82.511887,29.043186,
-82.508781,29.037073,-82.502686,
29.041534,-82.498184,29.041695,
-82.490425,29.04814,-82.487518,
29.04792,-82.487854,29.05168,
-82.484123,29.050846,-82.480888,
29.05265,-82.47654,29.050919,
-82.472099,29.052326,-82.473305,
29.04834,-82.470528,29.046492,
-82.467194,29.047773,-82.464027,
29.0446,-82.45874,29.047398,
-82.454361,29.039499,-82.44735,
29.038954,-82.442032,29.035404,
-82.441498,29.032127,-82.439377,
29.032831,-82.437683,29.02898,
-82.435333,29.029257,-82.436638,
29.026987,-82.432671,29.027514,
-82.429573,29.020798,-82.425194,
29.021441,-82.425629,29.018759,
-82.420158,29.017956,-82.418831,
29.01289,-82.402061,29.018778,
-82.402084,29.015385,-82.397682,
29.016552,-82.395027,29.01371,
-82.397629,29.011145,-82.393669,
29.007727,-82.387047,29.008802,
-82.378136,29.004282,-82.377686,
29.000328,-82.365715,29.002472,
-82.361809,28.997972,-82.361633,
28.993561,-82.345901,28.986891,
-82.341461,28.987419,-82.32122,
28.97509,-82.32119,28.973297,
-82.316147,28.973061,-82.311783,
28.960089,-81.954384,28.959791,
-81.658905,28.960186,-81.659401,
29.047501,-81.638901,29.047501,
-81.642105,29.276739,-81.655045,
29.299078,-81.666428,29.300297,
-81.672096,29.304766,-81.681084,
29.324188,-81.680229,29.331152,
-81.675629,29.33839,-81.665306,
29.341093,-81.658821,29.336699,
-81.656578,29.33773,-81.660927,
29.343023,-81.657936,29.347794,
-81.66243,29.355589,-81.662247,
29.362236,-81.668762,29.371454,
-81.741623,29.370777,-81.742027,
29.429689,-81.775101,29.429001,
-81.776245,29.480335,-81.776398,
29.4872,-81.843025,29.486286,
-81.843201,29.520758,-81.845123,
29.521433,-81.8498,29.521093,
-81.849831,29.518524,-81.854279,
29.51638,-81.886169,29.512539,
-81.888313,29.508934,-81.896713,
29.512764,-81.896736,29.514879,
-81.901878,29.515743,-81.904831,
29.514608,-81.90432,29.512592,
-81.906891,29.514,-81.907204,
29.50901,-81.912239,29.503658,
-81.919571,29.511379,-81.932175,
29.516142,-81.937447,29.512224,
-81.944626,29.511559,-81.947037,
29.508808,-81.964256,29.503555,
-82.004578,29.501469,-82.031929,
29.492136,-82.043495,29.478477,
-82.056084,29.47139,-82.057205,
29.439533,-82.064201,29.439327,
-82.067345,29.44355,-82.07148,
29.443018,-82.070671,29.433996,
-82.0811,29.440102,-82.087799,
29.435455,-82.086662,29.426416,
-82.08831,29.425949,-82.090248,
29.430487,-82.091759,29.428371,
-82.09465,29.429947,-82.095718,
29.420158,-82.099403,29.418535,
-82.099609,29.422239,-82.097,
29.421585,-82.098907,29.42701,
-82.095848,29.42985,-82.101303,
29.438049,-82.116913,29.432116,
-82.119102,29.428333,-82.125,
29.428757,-82.126968,29.432758,
-82.134735,29.434732,-82.145287,
29.423441,-82.14064,29.419905,
-82.148415,29.416996,-82.151711,
29.421879,-82.150894,29.426416,
-82.153336,29.422544,-82.156364,
29.425615,-82.156265,29.422064,
-82.167549,29.426878,-82.167343,
29.42454,-82.171608,29.424885,
-82.176109,29.420597,-82.178291,
29.422363,-82.192818,29.420828,
-82.197289,29.42296,-82.198868,
29.421814,-82.202423,29.426512,
-82.211327,29.429443,-82.213654,
29.43302,-82.21196,29.44824,
-82.217957,29.455959,-82.21196,
29.46376,-82.212906,29.465376,
-82.204369,29.46032,-82.196266,
29.462467,-82.193634,29.461189,
-82.19487,29.457813,-82.199402,
29.456285,-82.192078,29.452299,
-82.188622,29.454752,-82.190514,
29.45952,-82.188232,29.460094,
-82.201859,29.468021,-82.199783,
29.470362,-82.201981,29.469421,
-82.203239,29.471714,-82.2062,
29.472034,-82.205521,29.466692,
-82.207985,29.466417,-82.208458,
29.470474,-82.211861,29.471298,
-82.210396,29.473499,-82.214745,
29.47673,-82.210365,29.481155,
-82.212021,29.48386,-82.406792,
29.484802)),'Marion','12083',
'Florida','FL','12',1578.7197,194833,123.4119);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-80.678078,27.205664,-80.67765,
27.121292,-80.75,27.062983,
-80.885857,26.958586,-80.142303,
26.956301,-80.142105,26.970699,
-80.080482,26.970385,-80.088303,
26.992014,-80.090225,27.005344,
-80.099762,27.032677,-80.142273,
27.119375,-80.150024,27.14312,
-80.153694,27.168871,-80.16114,
27.191456,-80.197609,27.258053,
-80.19973,27.262934,-80.285004,
27.263399,-80.285744,27.2057,
-80.678078,27.205664)),'Martin',
'12085','Florida','FL','12',555.5781,100900,181.6124);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2007,8265,null,
MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,89,1003,1,363,1003,1,
517,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.107605,24.687654,-81.089447,
24.691168,-81.074944,24.690144,
-81.078316,24.695415,-81.077286,
24.699518,-81.072014,24.709332,
-81.067329,24.712847,-81.039932,
24.724419,-81.032318,24.722954,
-81.023537,24.716215,-80.974907,
24.741432,-80.972878,24.745899,
-80.945061,24.763197,-80.912201,
24.764347,-80.906731,24.768528,
-80.903275,24.779627,-80.883804,
24.787554,-80.885536,24.792887,
-80.931808,24.775015,-80.936562,
24.775446,-80.94593,24.769827,
-80.954575,24.769247,-80.977348,
24.755844,-80.981819,24.755844,
-80.988594,24.75988,-80.989601,
24.750656,-80.995079,24.748062,
-80.997528,24.743017,-81.010361,
24.739702,-81.023239,24.734232,
-81.036125,24.742289,-81.042435,
24.742582,-81.050774,24.7376,
-81.054146,24.731743,-81.05957,
24.730129,-81.069824,24.722075,
-81.074219,24.721342,-81.077881,
24.723686,-81.082275,24.717974,
-81.097359,24.712847,-81.125778,
24.708014,-81.124313,24.704205,
-81.115959,24.698639,-81.107605,
24.687654,-80.265045,25.353647,
-80.275337,25.345154,-80.278099,
25.334373,-80.290375,25.323343,
-80.29113,25.314819,-80.304665,
25.305294,-80.307426,25.30028,
-80.328987,25.28624,-80.334755,
25.28624,-80.340515,25.291004,
-80.351051,25.28624,-80.364586,
25.285488,-80.366837,25.283232,
-80.366837,25.281225,-80.360565,
25.278217,-80.345528,25.273956,
-80.340767,25.263927,-80.332237,
25.259666,-80.336502,25.235849,
-80.340767,25.225824,-80.351799,
25.211283,-80.357315,25.207771,
-80.372856,25.204763,-80.393417,
25.19198,-80.386177,25.186142,
-80.388649,25.16741,-80.397423,
25.147104,-80.403442,25.140085,
-80.41246,25.138832,-80.425323,
25.144432,-80.433029,25.144667,
-80.448448,25.152142,-80.449615,
25.147001,-80.441673,25.138826,
-80.440742,25.132984,-80.450554,
25.125977,-80.447044,25.121304,
-80.443077,25.121304,-80.434196,
25.111025,-80.446815,25.0921,
-80.453354,25.089998,-80.460129,
25.092567,-80.467606,25.091166,
-80.461769,25.084156,-80.461998,
25.07855,-80.487938,25.052851,
-80.497513,25.04701,-80.506859,
25.032059,-80.51503,25.030188,
-80.515739,25.017805,-80.519005,
25.015703,-80.526711,25.017105,
-80.546577,25.014069,-80.544243,
25.002853,-80.553352,24.985098,
-80.570168,24.964539,-80.576012,
24.962904,-80.583488,24.966408,
-80.589912,24.964491,-80.595741,
24.967588,-80.59848,24.964491,
-80.599396,24.950632,-80.605225,
24.949537,-80.610329,24.952089,
-80.614159,24.944981,-80.622185,
24.944069,-80.62455,24.939327,
-80.622002,24.93714,-80.622185,
24.933493,-80.642609,24.914528,
-80.661385,24.90432,-80.661926,
24.899944,-80.689835,24.885174,
-80.696938,24.884809,-80.704964,
24.879704,-80.705872,24.87314,
-80.716629,24.865849,-80.732857,
24.864937,-80.750183,24.845608,
-80.766953,24.837585,-80.787376,
24.841963,-80.799049,24.839045,
-80.810165,24.83321,-80.819649,
24.823729,-80.831322,24.813154,
-80.851379,24.803854,-80.851006,
24.801849,-80.822929,24.811878,
-80.797226,24.810783,-80.787743,
24.821905,-80.740883,24.84725,
-80.734863,24.848162,-80.728661,
24.855453,-80.703133,24.867853,
-80.690376,24.880981,-80.643517,
24.906691,-80.610878,24.938051,
-80.59848,24.946074,-80.566208,
24.956203,-80.564201,24.961018,
-80.551964,24.971251,-80.549149,
24.977068,-80.530296,24.997932,
-80.517456,25.001944,-80.514847,
25.008764,-80.494186,25.023411,
-80.489365,25.029831,-80.491577,
25.038456,-80.469315,25.063532,
-80.462486,25.068348,-80.443634,
25.075169,-80.43119,25.08901,
-80.418755,25.09824,-80.406448,
25.103733,-80.377365,25.129807,
-80.372856,25.136576,-80.371101,
25.145098,-80.366333,25.151115,
-80.358315,25.15287,-80.352051,
25.163902,-80.350296,25.168665,
-80.353554,25.180948,-80.350792,
25.188971,-80.343529,25.194487,
-80.339516,25.20702,-80.33049,
25.216549,-80.322212,25.233847,
-80.317703,25.235849,-80.314697,
25.240864,-80.30793,25.25691,
-80.283104,25.291004,-80.272072,
25.316324,-80.259544,25.324598,
-80.250542,25.341444,-80.251106,
25.3416,-80.256706,25.3503,
-80.265045,25.353647,-81.812386,
24.544102,-81.788086,24.545902,
-81.777328,24.549494,-81.686867,
24.557819,-81.656525,24.572636,
-81.631828,24.576868,-81.602211,
24.58604,-81.562698,24.606499,
-81.519661,24.617081,-81.510498,
24.626251,-81.507675,24.647413,
-81.50132,24.656588,-81.490746,
24.658705,-81.444176,24.656588,
-81.4216,24.643888,-81.394089,
24.619198,-81.381393,24.622021,
-81.365166,24.62978,-81.33342,
24.637541,-81.266403,24.658705,
-81.243118,24.668579,-81.240997,
24.676342,-81.258636,24.675636,
-81.277687,24.66717,-81.293205,
24.668579,-81.310135,24.677046,
-81.315781,24.694683,-81.322838,
24.70315,-81.341881,24.707382,
-81.358109,24.708088,-81.376457,
24.721493,-81.394791,24.744772,
-81.40255,24.730661,-81.399734,
24.708794,-81.409607,24.705973,
-81.426544,24.715141,-81.437836,
24.734896,-81.451935,24.746887,
-81.45829,24.737719,-81.457581,
24.717964,-81.460411,24.706676,
-81.470284,24.706676,-81.480164,
24.715849,-81.490028,24.715849,
-81.494972,24.706676,-81.518257,
24.701033,-81.529541,24.68128,
-81.542236,24.68128,-81.55423,
24.691862,-81.563408,24.692568,
-81.573982,24.675636,-81.591621,
24.65941,-81.614197,24.650238,
-81.614197,24.641771,-81.625488,
24.633307,-81.633949,24.622021,
-81.648064,24.616377,-81.66217,
24.614258,-81.673454,24.605087,
-81.710144,24.595209,-81.722839,
24.584627,-81.732719,24.585335,
-81.740479,24.588861,-81.747536,
24.58604,-81.754593,24.579691,
-81.763443,24.577753,-81.76667,
24.583511,-81.774773,24.584593,
-81.781967,24.576855,-81.789711,
24.574333,-81.793846,24.577934,
-81.79493,24.590891,-81.797623,
24.594311,-81.799606,24.592871,
-81.804764,24.56793,-81.812027,
24.55508,-81.812386,24.544102,
-81.344452,25.802547,-81.343597,
25.799137,-81.351585,25.7712,
-81.345879,25.752956,-81.343597,
25.733,-81.33593,25.715504,
-81.317909,25.70409,-81.303497,
25.698084,-81.290878,25.686069,
-81.281876,25.681866,-81.275864,
25.672255,-81.272255,25.660242,
-81.272255,25.648228,-81.258438,
25.643421,-81.246429,25.630808,
-81.241623,25.612787,-81.241623,
25.594769,-81.235619,25.585758,
-81.232613,25.568939,-81.224808,
25.556927,-81.212189,25.549116,
-81.206787,25.542509,-81.204987,
25.532898,-81.210396,25.518482,
-81.210991,25.50647,-81.198975,
25.491451,-81.168343,25.463221,
-81.166931,25.449728,-81.156326,
25.431614,-81.150581,25.414827,
-81.151466,25.387442,-81.146172,
25.383024,-81.137329,25.379932,
-81.128494,25.379932,-81.124962,
25.376398,-81.124962,25.360497,
-81.121422,25.353428,-81.121872,
25.3468,-81.130707,25.342827,
-81.137772,25.342384,-81.146606,
25.334433,-81.151901,25.325596,
-81.151466,25.312786,-81.161186,
25.294674,-81.167366,25.269493,
-81.172234,25.235922,-81.172234,
25.220901,-81.158096,25.209415,
-81.146606,25.190865,-81.142632,
25.179819,-81.142189,25.155964,
-81.130707,25.155523,-81.121422,
25.151991,-81.101547,25.134319,
-81.09536,25.12681,-81.091385,
25.117092,-81.087418,25.115324,
-81.050743,25.128134,-81.025566,
25.129019,-80.999062,25.124161,
-80.97654,25.131226,-80.946495,
25.132551,-80.921753,25.140505,
-80.900108,25.138737,-80.900993,
25.154198,-80.897453,25.163033,
-80.885536,25.167007,-80.874931,
25.173634,-80.850906,25.176483,
-80.858376,25.176176,-80.858345,
25.210899,-80.8582,25.242599,
-80.862198,25.2425,-80.862396,
25.3638,-80.873398,25.3636,
-80.873314,25.805229,-81.100502,
25.802944,-81.344452,25.802547)),
'Monroe','12087','Florida','FL','12',997.0942,78024,78.2513);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.905266,30.827776,-81.907631,
30.824343,-81.904961,30.817039,
-81.909409,30.814869,-81.929329,
30.817244,-81.930153,30.819452,
-81.935509,30.82056,-81.93409,
30.823099,-81.939339,30.829548,
-81.939102,30.826763,-81.943047,
30.827917,-81.94191,30.825266,
-81.949951,30.827263,-81.95993,
30.820936,-81.964752,30.816475,
-81.961647,30.813656,-81.964165,
30.812429,-81.962608,30.808208,
-81.965439,30.806444,-81.962692,
30.796293,-81.969704,30.790344,
-81.973091,30.779219,-81.979225,
30.776182,-81.98877,30.779823,
-82.004715,30.79158,-82.006279,
30.790182,-82.008636,30.792612,
-82.014587,30.788902,-82.01384,
30.790783,-82.01722,30.791424,
-82.017693,30.787415,-82.023033,
30.78776,-82.024307,30.783291,
-82.011757,30.76289,-82.021126,
30.757551,-82.018082,30.75503,
-82.022194,30.755123,-82.028557,
30.750748,-82.032806,30.750443,
-82.036499,30.754555,-82.037949,
30.753408,-82.041145,30.737749,
-82.039207,30.73633,-82.046082,
30.72714,-82.039185,30.722649,
-82.040115,30.71921,-82.037727,
30.718409,-82.039764,30.715084,
-82.036591,30.706352,-82.039932,
30.700624,-82.043457,30.700716,
-82.041687,30.690861,-82.044334,
30.683781,-82.04895,30.682474,
-82.046593,30.681236,-82.050652,
30.675207,-82.046669,30.666315,
-82.048767,30.664713,-82.046913,
30.66077,-82.049957,30.661823,
-82.049675,30.655315,-82.042007,
30.648483,-82.039253,30.640898,
-82.041298,30.635948,-82.036552,
30.6318,-82.037483,30.629919,
-82.033905,30.629118,-82.035713,
30.626713,-82.031288,30.623316,
-82.032135,30.619831,-82.029594,
30.61919,-82.028664,30.621595,
-82.027504,30.606491,-82.020378,
30.60358,-82.015869,30.601471,
-82.012276,30.593538,-82.012199,
30.586227,-82.010483,30.586456,
-82.010925,30.583454,-82.006271,
30.576944,-82.008255,30.576784,
-82.006378,30.574949,-82.008499,
30.571192,-82.006065,30.565163,
-82.00885,30.563375,-82.005638,
30.563259,-82.00824,30.560099,
-82.010674,30.560947,-82.008881,
30.554094,-82.011452,30.552834,
-82.009972,30.550495,-82.013382,
30.549856,-82.013626,30.542294,
-82.019424,30.532394,-82.017654,
30.532394,-82.018875,30.528589,
-82.015533,30.528587,-82.018341,
30.527306,-82.019035,30.523594,
-82.016579,30.52137,-82.018845,
30.51878,-82.015488,30.519421,
-82.014938,30.512774,-82.017296,
30.506884,-82.015656,30.498175,
-82.018013,30.49577,-82.015869,
30.495033,-82.018387,30.49185,
-82.015663,30.483553,-82.019424,
30.482935,-82.017441,30.479473,
-82.019714,30.479244,-82.017075,
30.474981,-82.024109,30.466572,
-82.022469,30.461002,-82.028435,
30.455593,-82.028374,30.447161,
-82.032455,30.441479,-82.034096,
30.442234,-82.040283,30.436527,
-82.033913,30.427521,-82.036079,
30.424587,-82.034096,30.420094,
-82.043884,30.414345,-82.040894,
30.414551,-82.04351,30.412807,
-82.04203,30.411135,-82.043938,
30.40749,-82.041374,30.40646,
-82.044624,30.404739,-82.044044,
30.401325,-82.035973,30.384674,
-82.038338,30.382301,-82.037292,
30.371506,-82.044708,30.3671,
-82.042122,30.365183,-82.045029,
30.365993,-82.048714,30.362753,
-82.05024,30.362104,-82.049408,
30.273195,-81.809708,30.484301,
-81.794907,30.5051,-81.781799,
30.503099,-81.765503,30.5182,
-81.765106,30.5355,-81.756302,30.531,
-81.737106,30.5394,-81.7341,30.5427,
-81.733681,30.551258,-81.709801,
30.565701,-81.703796,30.566799,
-81.704903,30.563499,-81.701599,
30.5634,-81.698799,30.5693,
-81.695305,30.5658,-81.696503,
30.5637,-81.693504,30.563601,
-81.693306,30.566601,-81.6884,
30.566099,-81.686707,30.5627,
-81.684196,30.566099,-81.677803,
30.561899,-81.674797,30.565901,
-81.669907,30.562599,-81.673302,
30.5595,-81.668106,30.560301,
-81.668106,30.556999,-81.673302,
30.5564,-81.664001,30.5506,
-81.659103,30.552401,-81.662903,
30.554399,-81.6642,30.558201,
-81.661507,30.558201,-81.656403,
30.569599,-81.650597,30.5725,
-81.650307,30.5767,-81.646301,
30.575199,-81.642693,30.579809,
-81.637802,30.5777,-81.635605,
30.581259,-81.625481,30.585896,
-81.615997,30.58,-81.606293,30.58552,
-81.604599,30.5839,-81.611176,
30.575771,-81.604706,30.572601,
-81.601776,30.567308,-81.614487,
30.562393,-81.609001,30.553101,
-81.605797,30.5541,-81.6035,
30.558399,-81.587997,30.566299,
-81.583603,30.5648,-81.589401,
30.549601,-81.585587,30.544155,
-81.577469,30.537788,-81.568001,
30.5364,-81.555397,30.5443,
-81.551102,30.542801,-81.5494,
30.5317,-81.543106,30.5238,
-81.531708,30.5264,-81.525002,
30.5336,-81.520905,30.543699,
-81.524002,30.556101,-81.514198,
30.567101,-81.499702,30.5637,
-81.491104,30.5548,-81.488106,
30.5427,-81.480003,30.5343,-81.4561,
30.525101,-81.442307,30.5089,
-81.433891,30.506329,-81.42482,
30.505718,-81.434303,30.522223,
-81.439285,30.541222,-81.44371,
30.588545,-81.427612,30.697668,
-81.434517,30.709368,-81.451424,
30.709248,-81.472786,30.713076,
-81.485764,30.725042,-81.489723,
30.725864,-81.516304,30.722,
-81.531998,30.723801,-81.534904,
30.7197,-81.533905,30.710501,
-81.538704,30.708401,-81.542801,
30.7097,-81.548904,30.717699,
-81.557907,30.712099,-81.563004,
30.7117,-81.563103,30.7174,
-81.573906,30.722099,-81.586998,
30.723499,-81.595398,30.717899,
-81.597603,30.7199,-81.597107,
30.726801,-81.601402,30.7293,
-81.605797,30.7276,-81.606003,
30.718901,-81.610504,30.7157,
-81.614601,30.7222,-81.6231,30.723,
-81.620903,30.7306,-81.624802,
30.736099,-81.629303,30.7344,
-81.630302,30.728001,-81.633102,
30.7285,-81.636505,30.733603,
-81.643105,30.728201,-81.652107,
30.728201,-81.654503,30.7332,
-81.651901,30.741301,-81.654732,
30.744101,-81.663506,30.743099,
-81.659897,30.75,-81.663422,
30.753656,-81.683502,30.747999,
-81.681107,30.7444,-81.673401,
30.748301,-81.669998,30.7465,
-81.669502,30.7411,-81.672997,
30.738701,-81.680603,30.741501,
-81.689102,30.741199,-81.694954,
30.74818,-81.701302,30.745216,
-81.710739,30.747314,-81.7201,
30.7444,-81.732399,30.749399,
-81.732414,30.754688,-81.742912,
30.758968,-81.742256,30.765259,
-81.755249,30.768085,-81.76123,
30.774717,-81.76944,30.776548,
-81.773888,30.767179,-81.771965,
30.763779,-81.782661,30.760975,
-81.783104,30.765495,-81.786934,
30.769432,-81.784523,30.773357,
-81.793449,30.786594,-81.79763,
30.784723,-81.797195,30.781044,
-81.808693,30.789782,-81.819954,
30.789537,-81.824097,30.786619,
-81.829529,30.788996,-81.840546,
30.786152,-81.842224,30.786888,
-81.840561,30.792061,-81.846458,
30.790316,-81.852791,30.794207,
-81.868774,30.792522,-81.871994,
30.797775,-81.883377,30.800014,
-81.882896,30.804892,-81.885551,
30.811251,-81.891449,30.815712,
-81.892815,30.824629,-81.902046,
30.829233,-81.905266,30.827776)),
'Nassau','12089','Florida','FL','12',651.5034,43941,67.4454);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-86.785957,30.996798,-86.799461,
30.38608,-86.748482,30.391731,
-86.680305,30.395317,-86.633003,
30.396099,-86.523216,30.38678,
-86.506676,30.38208,-86.464081,
30.383638,-86.397377,30.378443,
-86.396263,30.378279,-86.393005,
30.511478,-86.388702,30.994001,
-86.688362,30.994326,-86.724358,
30.996687,-86.785957,30.996798)),
'Okaloosa','12091','Florida','FL','12',935.6259,143776,153.6682);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.142395,27.642929,-81.141907,
27.639353,-81.144249,27.638227,
-81.141571,27.632999,-81.142883,
27.629103,-81.14064,27.628395,
-81.142036,27.62656,-81.140167,
27.626202,-81.144997,27.615156,
-81.140785,27.607935,-81.140503,
27.600595,-81.142685,27.597385,
-81.149429,27.59638,-81.155136,
27.591513,-81.154709,27.586796,
-81.158623,27.579115,-81.156822,
27.574184,-81.161232,27.570446,
-81.160019,27.574093,-81.164696,
27.572456,-81.166428,27.574392,
-81.170906,27.56522,-81.174965,
27.564005,-81.177101,27.557953,
-81.185303,27.558626,-81.190834,
27.556355,-81.190216,27.553146,
-81.194824,27.551311,-81.192032,
27.550451,-81.196152,27.549656,
-81.198662,27.545906,-81.206558,
27.546967,-81.205673,27.542891,
-81.202682,27.539009,-81.208809,
27.535093,-81.208,27.529737,
-81.211555,27.530844,-81.213928,
27.528341,-81.210907,27.527634,
-81.212112,27.523827,-81.205193,
27.514702,-81.202011,27.512798,
-81.199699,27.514742,-81.198669,
27.510063,-81.201744,27.508417,
-81.202797,27.502457,-81.200256,
27.499535,-81.20401,27.498377,
-81.205322,27.489454,-81.201385,
27.489019,-81.199562,27.486109,
-81.197296,27.487988,-81.189224,
27.482164,-81.181023,27.482231,
-81.176346,27.472845,-81.170601,
27.467438,-81.173027,27.463015,
-81.168526,27.458956,-81.166603,
27.459805,-81.165031,27.456387,
-81.160179,27.455673,-81.15966,
27.457073,-81.158531,27.453403,
-81.151672,27.452003,-81.153473,
27.450583,-81.150566,27.445559,
-81.147057,27.447165,-81.143555,
27.443033,-81.139206,27.433607,
-81.14109,27.428196,-81.138527,
27.42399,-81.140938,27.422993,
-81.141655,27.4168,-81.143661,
27.415813,-81.142075,27.411823,
-81.13868,27.411272,-81.138481,
27.408268,-81.13678,27.410103,
-81.133133,27.406134,-81.132362,
27.408312,-81.123238,27.402805,
-81.126503,27.401108,-81.124184,
27.396315,-81.125557,27.394068,
-81.121178,27.389757,-81.116913,
27.389896,-81.112999,27.384439,
-81.102112,27.383045,-81.09877,
27.379124,-81.093674,27.381323,
-81.086952,27.379974,-81.08744,
27.381639,-81.084007,27.381912,
-81.081558,27.385366,-81.068741,
27.382065,-81.0634,27.37991,
-81.060974,27.373482,-81.049866,
27.370007,-81.053123,27.365068,
-81.051361,27.3627,-81.04187,
27.362654,-81.04081,27.359371,
-81.034988,27.358835,-81.034943,
27.354385,-81.031143,27.351521,
-81.033409,27.346407,-81.036751,
27.345881,-81.033432,27.348377,
-81.035225,27.35033,-81.039055,
27.346821,-81.042114,27.347395,
-81.041542,27.344023,-81.046425,
27.340616,-81.043549,27.328611,
-81.038109,27.329691,-81.029854,
27.323364,-81.032898,27.31946,
-81.028923,27.312098,-81.027023,
27.313244,-81.026642,27.308268,
-81.028824,27.309116,-81.029228,
27.307236,-81.025558,27.302328,
-81.021225,27.300308,-81.020782,
27.302555,-81.016891,27.300192,
-81.015884,27.301821,-81.013367,
27.297531,-81.0121,27.300877,
-81.004845,27.302412,-81,27.295027,
-80.995071,27.296541,-80.998978,
27.291496,-80.997375,27.287849,
-80.999374,27.283606,-80.997459,
27.281176,-80.999481,27.280535,
-80.998657,27.271566,-81.000946,
27.267443,-80.998253,27.266315,
-80.998077,27.258978,-80.992958,
27.254026,-80.993431,27.250877,
-80.981377,27.246195,-80.9814,
27.243303,-80.983353,27.24468,
-80.982796,27.238638,-80.982597,
27.234154,-80.98542,27.231127,
-80.980751,27.22998,-80.970665,
27.217169,-80.961639,27.215033,
-80.964325,27.217646,-80.957405,
27.219025,-80.955841,27.222857,
-80.951874,27.224503,-80.952675,
27.220867,-80.948143,27.221674,
-80.949608,27.219542,-80.942169,
27.211597,-80.943398,27.210276,
-80.943275,27.207397,-80.937683,
27.204119,-80.935188,27.196482,
-80.931396,27.200035,-80.926834,
27.198429,-80.929726,27.196184,
-80.925468,27.19726,-80.925682,
27.195082,-80.920296,27.193521,
-80.918266,27.190104,-80.913834,
27.189369,-80.911346,27.191456,
-80.91124,27.188795,-80.906616,
27.188725,-80.909164,27.18531,
-80.906601,27.179232,-80.910446,
27.174738,-80.902039,27.170725,
-80.903526,27.168844,-80.897583,
27.170357,-80.897736,27.16609,
-80.892563,27.166662,-80.890923,
27.164825,-80.889709,27.16744,
-80.886192,27.165548,-80.871384,
27.146738,-80.885857,26.958586,
-80.75,27.062983,-80.67765,27.121292,
-80.678078,27.205664,-80.680038,
27.558155,-80.777382,27.55842,
-80.778267,27.642885,-80.873375,
27.641996,-81.142395,27.642929)),
'Okeechobee','12093','Florida','FL','12',774.1997,29627,38.2678);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.4142,28.785299,-81.646904,
28.785601,-81.648819,28.784273,
-81.647301,28.781601,-81.653458,
28.782679,-81.658928,28.778597,
-81.657402,28.5924,-81.648003,
28.584299,-81.652,28.578699,
-81.652802,28.570601,-81.656998,
28.5688,-81.657303,28.5625,
-81.657471,28.346848,-80.863129,
28.347204,-80.873131,28.359215,
-80.872917,28.36993,-80.875801,
28.373142,-80.879509,28.372112,
-80.882256,28.374622,-80.879822,
28.380138,-80.888695,28.385302,
-80.889931,28.392582,-80.887009,
28.396261,-80.884727,28.395844,
-80.886711,28.403851,-80.883133,
28.407393,-80.888237,28.415403,
-80.896591,28.418219,-80.895973,
28.422838,-80.898918,28.425856,
-80.896996,28.427528,-80.901398,
28.432878,-80.89463,28.4375,
-80.894409,28.443188,-80.890701,
28.445282,-80.897438,28.453175,
-80.898323,28.456818,-80.894272,
28.458887,-80.896126,28.463011,
-80.893074,28.464214,-80.89489,
28.46669,-80.890999,28.468237,
-80.89006,28.466555,-80.88678,
28.469536,-80.881142,28.468281,
-80.876259,28.470642,-80.874992,
28.469158,-80.87114,28.471445,
-80.874359,28.476105,-80.873619,
28.48147,-80.878395,28.486265,
-80.875877,28.489155,-80.882507,
28.49119,-80.884132,28.494816,
-80.879807,28.498653,-80.885345,
28.509319,-80.892143,28.51181,
-80.896126,28.509167,-80.906403,
28.511047,-80.907295,28.519947,
-80.912674,28.522724,-80.910706,
28.523195,-80.912155,28.524355,
-80.916412,28.522587,-80.920097,
28.524097,-80.923729,28.532509,
-80.928375,28.532436,-80.932175,
28.535212,-80.934509,28.533293,
-80.936325,28.536566,-80.939674,
28.535164,-80.939407,28.541473,
-80.934364,28.540268,-80.932014,
28.54224,-80.934357,28.546431,
-80.934059,28.554235,-80.931587,
28.556643,-80.93425,28.558792,
-80.930313,28.563145,-80.936111,
28.570829,-80.939613,28.572174,
-80.940735,28.577732,-80.947479,
28.58445,-80.943565,28.593157,
-80.947891,28.595158,-80.946663,
28.596581,-80.949448,28.600195,
-80.953156,28.600147,-80.951935,
28.604313,-80.956635,28.604107,
-80.957977,28.601994,-80.960609,
28.605295,-80.968536,28.605503,
-80.971466,28.61132,-80.975899,
28.608028,-80.987473,28.612722,
-81.328102,28.610001,-81.328705,
28.639299,-81.459702,28.639799,
-81.459396,28.7129,-81.441704,28.715,
-81.430397,28.726299,-81.421104,
28.74,-81.41758,28.753645,-81.415306,
28.7547,-81.4142,28.785299)),
'Orange','12095','Florida','FL','12',907.4711,677491,746.5698);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.657471,28.346848,-81.657394,
28.258928,-81.557663,28.259071,
-81.524284,28.20072,-81.524429,
28.142511,-81.455826,28.142609,
-81.455521,28.085072,-81.346504,
28.0844,-81.349045,28.081451,
-81.347397,28.076,-81.346527,
28.068958,-81.348816,28.067263,
-81.3554,28.0662,-81.361526,
28.068771,-81.365402,28.0674,
-81.366707,28.0604,-81.364304,
28.0578,-81.364601,28.0466,-81.36235,
28.040981,-81.363571,28.037985,
-81.375854,28.0292,-81.376099,
28.024431,-81.380035,28.021919,
-81.381104,28.019152,-81.37661,
28.015327,-81.378593,28.01152,
-81.382851,28.011999,-81.386208,
28.01664,-81.392563,28.019136,
-81.394753,28.027727,-81.406303,
28.028576,-81.416931,28.037312,
-81.424545,28.040176,-81.428352,
28.039007,-81.428146,28.041056,
-81.433823,28.044785,-81.435936,
28.053375,-81.441246,28.058384,
-81.453987,28.057184,-81.459724,
28.051104,-81.459091,28.039167,
-81.449043,28.031696,-81.439011,
28.032576,-81.433121,28.021839,
-81.427872,28.016815,-81.428192,
28.01992,-81.424767,28.012096,
-81.420479,28.001968,-81.415375,
27.997663,-81.415085,28.000223,
-81.392548,28.004128,-81.387009,
28.003216,-81.378349,27.988544,
-81.381248,27.987345,-81.381859,
27.984097,-81.376831,27.983215,
-81.376701,27.977921,-81.370796,
27.977631,-81.368744,27.973492,
-81.350098,27.96386,-81.348183,
27.960663,-81.349091,27.953218,
-81.3368,27.950331,-81.33815,
27.939005,-81.345314,27.941389,
-81.347351,27.937189,-81.341026,
27.932261,-81.337723,27.933109,
-81.312912,27.921074,-81.311775,
27.913622,-81.31485,27.899176,
-81.306564,27.887344,-81.304527,
27.872753,-81.297302,27.862711,
-81.302315,27.86764,-81.304787,
27.862551,-81.302986,27.859753,
-81.299706,27.860851,-81.286186,
27.857182,-81.281418,27.857225,
-81.283195,27.851746,-81.28624,
27.851057,-81.283096,27.849339,
-81.272652,27.848785,-81.259949,
27.844402,-81.252754,27.847954,
-81.25,27.843916,-81.246834,
27.848389,-81.230782,27.842297,
-81.215523,27.82947,-81.214066,
27.823198,-81.20816,27.820745,
-81.21019,27.81703,-81.201851,
27.804501,-81.200714,27.797089,
-81.186096,27.778742,-81.187706,
27.774723,-81.184921,27.772638,
-81.181137,27.773853,-81.18129,
27.769957,-81.178299,27.770298,
-81.179283,27.765781,-81.172989,
27.760551,-81.174072,27.758261,
-81.177261,27.758902,-81.179306,
27.75528,-81.175056,27.745577,
-81.172989,27.747227,-81.170776,
27.745117,-81.171982,27.742846,
-81.165314,27.741884,-81.164902,
27.734819,-81.166939,27.734247,
-81.165932,27.73184,-81.168839,
27.731861,-81.167351,27.728354,
-81.169083,27.725946,-81.167168,
27.722919,-81.160965,27.723484,
-81.159248,27.718145,-81.150887,
27.717319,-81.146225,27.710188,
-81.146225,27.706083,-81.149376,
27.702484,-81.148033,27.69902,
-81.150398,27.699434,-81.147797,
27.696224,-81.149223,27.69166,
-81.146919,27.690584,-81.145119,
27.681894,-81.147133,27.681524,
-81.145126,27.679964,-81.144699,
27.669622,-81.14286,27.670584,
-81.131256,27.659,-81.132706,
27.647236,-81.134094,27.648773,
-81.137825,27.643873,-81.137527,
27.64673,-81.140015,27.646437,
-81.142395,27.642929,-80.873375,
27.641996,-80.874016,27.733547,
-80.88047,27.733389,-80.88179,
27.822268,-80.869095,27.822218,
-80.869537,28.084583,-80.863098,
28.084564,-80.863129,28.347204,
-81.657471,28.346848)),'Osceola',
'12097','Florida','FL','12',1321.7949,107728,81.5012);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-80.885857,26.958586,-80.88633,
26.666071,-80.881447,26.33345,
-80.226997,26.334299,-80.204201,
26.327499,-80.102104,26.327499,
-80.099304,26.3269,-80.099106,
26.3225,-80.091904,26.325701,
-80.088104,26.3204,-80.074936,
26.32044,-80.070801,26.3361,
-80.060799,26.4443,-80.051308,
26.5072,-80.042305,26.545099,
-80.036598,26.594,-80.036003,
26.675699,-80.033104,26.714899,
-80.037704,26.766001,-80.032471,
26.773594,-80.033501,26.7871,
-80.031601,26.796,-80.035797,26.8144,
-80.071518,26.945597,-80.080482,
26.970385,-80.142105,26.970699,
-80.142303,26.956301,-80.885857,
26.958586)),'PalmBeach','12099',
'Florida','FL','12',2033.9843,863518,424.5446);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.673874,28.433416,-82.674644,
28.431366,-82.688858,28.421263,
-82.694099,28.422384,-82.697464,
28.419395,-82.700829,28.404058,
-82.707001,28.390966,-82.704567,
28.374134,-82.711487,28.360668,
-82.717667,28.360668,-82.718979,
28.341215,-82.732437,28.321953,
-82.736176,28.305305,-82.732819,
28.286604,-82.743469,28.278563,
-82.743469,28.267714,-82.750587,
28.254248,-82.750015,28.250132,
-82.754883,28.240406,-82.752823,
28.237413,-82.75563,28.228624,
-82.768723,28.209171,-82.771713,
28.207115,-82.781998,28.207676,
-82.784622,28.198698,-82.799026,
28.185232,-82.800896,28.17345,
-82.800346,28.17223,-82.651344,
28.172976,-82.416161,28.170755,
-82.106049,28.17136,-82.1064,
28.258783,-82.056351,28.258673,
-82.056175,28.311632,-82.05545,
28.478125,-82.253685,28.478224,
-82.253632,28.434549,-82.673874,
28.433416)),'Pasco','12101',
'Florida','FL','12',744.8657,281131,377.425);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2007,8265,null,
MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1,39,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.81987,27.964975,-82.815857,
27.974806,-82.81131,27.973991,
-82.809723,27.982403,-82.823242,
28.003275,-82.820999,28.01062,
-82.816338,28.012253,-82.814339,
28.035612,-82.818344,28.055786,
-82.828766,28.070118,-82.826897,
28.085623,-82.833687,28.086224,
-82.836487,28.071817,-82.826523,
28.056314,-82.821426,28.044859,
-82.827965,28.018867,-82.829376,
27.995678,-82.830124,27.967978,
-82.81987,27.964975,-82.800346,
28.17223,-82.785126,28.138557,
-82.782974,28.125616,-82.785126,
28.114292,-82.782166,28.100271,
-82.783508,28.08005,-82.78109,
28.076546,-82.781898,28.070074,
-82.785942,28.064953,-82.784866,
28.053898,-82.791603,28.033136,
-82.793762,28.004826,-82.80751,
27.954138,-82.816719,27.935127,
-82.824142,27.922585,-82.827194,
27.913616,-82.832176,27.908089,
-82.842224,27.90885,-82.840759,
27.918262,-82.833916,27.941023,
-82.825127,27.960344,-82.832497,
27.962492,-82.8358,27.950113,
-82.841972,27.933418,-82.847778,
27.912004,-82.851234,27.889801,
-82.851837,27.873577,-82.849358,
27.863411,-82.849304,27.8629,
-82.844482,27.847565,-82.837906,
27.8363,-82.827919,27.820959,
-82.787598,27.788401,-82.783905,
27.780178,-82.770157,27.767118,
-82.761559,27.745119,-82.753998,
27.73584,-82.746613,27.730856,
-82.742996,27.724669,-82.739044,
27.709373,-82.73848,27.657566,
-82.740578,27.644806,-82.738739,
27.635721,-82.737862,27.631351,
-82.736382,27.624048,-82.736954,
27.61548,-82.731819,27.614717,
-82.707626,27.623478,-82.716225,
27.666967,-82.714943,27.687031,
-82.706833,27.693859,-82.69574,
27.698982,-82.668846,27.702824,
-82.651779,27.699409,-82.641106,
27.702398,-82.632561,27.710934,
-82.625732,27.726301,-82.624458,
27.734838,-82.622742,27.78606,
-82.619331,27.789476,-82.61293,
27.789476,-82.606094,27.792891,
-82.605247,27.798866,-82.591583,
27.815941,-82.566315,27.825377,
-82.568901,27.892599,-82.577705,
27.915701,-82.587997,27.927999,
-82.601601,27.937,-82.648506,27.9471,
-82.651344,28.172976,-82.800346,
28.17223)),'Pinellas','12103',
'Florida','FL','12',280.1079,851659,3040.4667);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.95784,28.344896,-81.958115,
28.307968,-81.967491,28.306911,
-81.976639,28.30904,-81.979568,
28.304928,-81.987038,28.304289,
-81.997185,28.317984,-82.006371,
28.322609,-82.015808,28.323441,
-82.027794,28.323233,-82.040466,
28.319967,-82.056175,28.311632,
-82.056351,28.258673,-82.1064,
28.258783,-82.106049,28.17136,
-82.05645,28.171295,-82.054543,
27.646072,-81.563522,27.646303,
-81.335602,27.646091,-81.142395,
27.642929,-81.140015,27.646437,
-81.137527,27.64673,-81.137825,
27.643873,-81.134094,27.648773,
-81.132706,27.647236,-81.131256,
27.659,-81.14286,27.670584,
-81.144699,27.669622,-81.145126,
27.679964,-81.147133,27.681524,
-81.145119,27.681894,-81.146919,
27.690584,-81.149223,27.69166,
-81.147797,27.696224,-81.150398,
27.699434,-81.148033,27.69902,
-81.149376,27.702484,-81.146225,
27.706083,-81.146225,27.710188,
-81.150887,27.717319,-81.159248,
27.718145,-81.160965,27.723484,
-81.167168,27.722919,-81.169083,
27.725946,-81.167351,27.728354,
-81.168839,27.731861,-81.165932,
27.73184,-81.166939,27.734247,
-81.164902,27.734819,-81.165314,
27.741884,-81.171982,27.742846,
-81.170776,27.745117,-81.172989,
27.747227,-81.175056,27.745577,
-81.179306,27.75528,-81.177261,
27.758902,-81.174072,27.758261,
-81.172989,27.760551,-81.179283,
27.765781,-81.178299,27.770298,
-81.18129,27.769957,-81.181137,
27.773853,-81.184921,27.772638,
-81.187706,27.774723,-81.186096,
27.778742,-81.200714,27.797089,
-81.201851,27.804501,-81.21019,
27.81703,-81.20816,27.820745,
-81.214066,27.823198,-81.215523,
27.82947,-81.230782,27.842297,
-81.246834,27.848389,-81.25,
27.843916,-81.252754,27.847954,
-81.259949,27.844402,-81.272652,
27.848785,-81.283096,27.849339,
-81.28624,27.851057,-81.283195,
27.851746,-81.281418,27.857225,
-81.286186,27.857182,-81.299706,
27.860851,-81.302986,27.859753,
-81.304787,27.862551,-81.302315,
27.86764,-81.297302,27.862711,
-81.304527,27.872753,-81.306564,
27.887344,-81.31485,27.899176,
-81.311775,27.913622,-81.312912,
27.921074,-81.337723,27.933109,
-81.341026,27.932261,-81.347351,
27.937189,-81.345314,27.941389,
-81.33815,27.939005,-81.3368,
27.950331,-81.349091,27.953218,
-81.348183,27.960663,-81.350098,
27.96386,-81.368744,27.973492,
-81.370796,27.977631,-81.376701,
27.977921,-81.376831,27.983215,
-81.381859,27.984097,-81.381248,
27.987345,-81.378349,27.988544,
-81.387009,28.003216,-81.392548,
28.004128,-81.415085,28.000223,
-81.415375,27.997663,-81.420479,
28.001968,-81.424767,28.012096,
-81.428192,28.01992,-81.427872,
28.016815,-81.433121,28.021839,
-81.439011,28.032576,-81.449043,
28.031696,-81.459091,28.039167,
-81.459724,28.051104,-81.453987,
28.057184,-81.441246,28.058384,
-81.435936,28.053375,-81.433823,
28.044785,-81.428146,28.041056,
-81.428352,28.039007,-81.424545,
28.040176,-81.416931,28.037312,
-81.406303,28.028576,-81.394753,
28.027727,-81.392563,28.019136,
-81.386208,28.01664,-81.382851,
28.011999,-81.378593,28.01152,
-81.37661,28.015327,-81.381104,
28.019152,-81.380035,28.021919,
-81.376099,28.024431,-81.375854,
28.0292,-81.363571,28.037985,
-81.36235,28.040981,-81.364601,
28.0466,-81.364304,28.0578,
-81.366707,28.0604,-81.365402,
28.0674,-81.361526,28.068771,
-81.3554,28.0662,-81.348816,
28.067263,-81.346527,28.068958,
-81.347397,28.076,-81.349045,
28.081451,-81.346504,28.0844,
-81.455521,28.085072,-81.455826,
28.142609,-81.524429,28.142511,
-81.524284,28.20072,-81.557663,
28.259071,-81.657394,28.258928,
-81.657471,28.346848,-81.790932,
28.346128,-81.791084,28.361551,
-81.857826,28.361584,-81.857712,
28.34568,-81.95784,28.344896)),
'Polk','12105','Florida','FL','12',1874.6054,405382,216.249);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.049423,29.718426,-82.054634,
29.718424,-82.049316,29.713051,
-82.056282,29.656824,-82.056084,
29.47139,-82.043495,29.478477,
-82.031929,29.492136,-82.004578,
29.501469,-81.964256,29.503555,
-81.947037,29.508808,-81.944626,
29.511559,-81.937447,29.512224,
-81.932175,29.516142,-81.919571,
29.511379,-81.912239,29.503658,
-81.907204,29.50901,-81.906891,
29.514,-81.90432,29.512592,
-81.904831,29.514608,-81.901878,
29.515743,-81.896736,29.514879,
-81.896713,29.512764,-81.888313,
29.508934,-81.886169,29.512539,
-81.854279,29.51638,-81.849831,
29.518524,-81.8498,29.521093,
-81.845123,29.521433,-81.843201,
29.520758,-81.843025,29.486286,
-81.776398,29.4872,-81.776245,
29.480335,-81.775101,29.429001,
-81.742027,29.429689,-81.741623,
29.370777,-81.668762,29.371454,
-81.662247,29.362236,-81.66243,
29.355589,-81.657936,29.347794,
-81.660927,29.343023,-81.656578,
29.33773,-81.658821,29.336699,
-81.665306,29.341093,-81.675629,
29.33839,-81.680229,29.331152,
-81.681084,29.324188,-81.452301,
29.377899,-81.44043,29.385201,
-81.440063,29.391047,-81.434196,
29.3983,-81.4552,29.3894,-81.468307,
29.392,-81.477707,29.3969,-81.481102,
29.416201,-81.486198,29.423901,
-81.487801,29.448,-81.520119,
29.494648,-81.523911,29.622158,
-81.525459,29.759132,-81.541626,
29.770275,-81.545494,29.780704,
-81.564095,29.798073,-81.580986,
29.839378,-81.812653,29.836241,
-81.822937,29.825697,-81.827591,
29.824457,-81.862122,29.80022,
-81.890755,29.797907,-81.914375,
29.791149,-81.923683,29.780676,
-81.929779,29.758282,-81.940193,
29.747229,-81.97641,29.74687,
-81.994232,29.742928,-82.007256,
29.739288,-82.024551,29.725698,
-82.029282,29.718437,-82.049423,
29.718426)),'Putnam','12107',
'Florida','FL','12',722.0488,65070,90.1184);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.680397,30.121,-81.682152,
30.103893,-81.680542,30.083302,
-81.689911,30.058414,-81.690575,
30.039392,-81.687843,30.024496,
-81.675949,30.010168,-81.624313,
29.981096,-81.609535,29.969444,
-81.604477,29.962366,-81.600296,
29.953638,-81.598816,29.941456,
-81.607872,29.917408,-81.607269,
29.902927,-81.599266,29.875,
-81.580986,29.839378,-81.564095,
29.798073,-81.545494,29.780704,
-81.541626,29.770275,-81.525459,
29.759132,-81.523911,29.622158,
-81.324295,29.62529,-81.324677,
29.653381,-81.318962,29.651089,
-81.309746,29.641735,-81.306068,
29.642721,-81.300789,29.650949,
-81.290535,29.649529,-81.28791,
29.651661,-81.282318,29.650122,
-81.274918,29.652596,-81.276314,
29.654202,-81.272949,29.655005,
-81.274551,29.657249,-81.270271,
29.656469,-81.272423,29.660528,
-81.269615,29.659748,-81.261391,
29.668751,-81.253593,29.661274,
-81.251015,29.662048,-81.247459,
29.658863,-81.232391,29.662895,
-81.227486,29.67021,-81.213173,
29.670332,-81.213936,29.672106,
-81.227547,29.711695,-81.240189,
29.736746,-81.259094,29.792517,
-81.263344,29.817551,-81.26519,
29.859156,-81.270645,29.88286,
-81.276749,29.900213,-81.288635,
29.914036,-81.30571,29.957434,
-81.379097,30.252399,-81.437202,
30.252094,-81.433975,30.105293,
-81.538895,30.103506,-81.5392,
30.119699,-81.568001,30.1178,
-81.581001,30.125401,-81.590706,
30.125601,-81.612503,30.1327,
-81.624001,30.1334,-81.650703,
30.1213,-81.680397,30.121)),
'St.Johns','12109','Florida','FL','12',608.9399,83829,137.6636);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-80.680038,27.558155,-80.678078,
27.205664,-80.285744,27.2057,
-80.285004,27.263399,-80.19973,
27.262934,-80.240211,27.355904,
-80.268867,27.411339,-80.312317,
27.525526,-80.320541,27.556797,
-80.680038,27.558155)),'St.Lucie',
'12111','Florida','FL','12',572.3925,150171,262.3564);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-87.162651,30.998875,-87.16906,
30.992914,-87.176033,30.996405,
-87.174995,30.988436,-87.18718,
30.981262,-87.19046,30.975628,
-87.197159,30.976316,-87.203529,
30.970482,-87.21302,30.966761,
-87.213234,30.961851,-87.218407,
30.963572,-87.227661,30.96093,
-87.231255,30.963596,-87.232002,
30.968105,-87.241348,30.961676,
-87.238319,30.95801,-87.241486,
30.948402,-87.244942,30.946846,
-87.247467,30.941723,-87.251862,
30.943743,-87.250626,30.938562,
-87.256027,30.931002,-87.259399,
30.931467,-87.260933,30.935135,
-87.264893,30.93055,-87.267242,
30.934799,-87.275658,30.930801,
-87.275787,30.926174,-87.286911,
30.925259,-87.28344,30.919724,
-87.288994,30.916382,-87.283531,
30.915451,-87.282394,30.910227,
-87.285622,30.907862,-87.289467,
30.909496,-87.290535,30.908049,
-87.285477,30.90344,-87.284515,
30.887802,-87.298302,30.881191,
-87.296669,30.878357,-87.299667,
30.873804,-87.297653,30.870996,
-87.301552,30.863239,-87.308853,
30.863626,-87.313522,30.849302,
-87.31205,30.847469,-87.306999,
30.848618,-87.307999,30.842825,
-87.302216,30.841978,-87.303368,
30.838909,-87.300331,30.835392,
-87.302551,30.833754,-87.301895,
30.82897,-87.297546,30.825718,
-87.296906,30.81493,-87.292793,
30.811096,-87.296486,30.808498,
-87.298683,30.801872,-87.302765,
30.801483,-87.305481,30.798271,
-87.305817,30.792843,-87.302422,
30.789404,-87.306938,30.79101,
-87.309334,30.789469,-87.305817,
30.787636,-87.312714,30.78594,
-87.309235,30.782326,-87.309258,
30.776806,-87.305534,30.777582,
-87.310219,30.771254,-87.305801,
30.769957,-87.304306,30.76585,
-87.300812,30.767611,-87.299637,
30.765921,-87.300346,30.763557,
-87.305,30.76371,-87.30497,30.760822,
-87.302361,30.760727,-87.304131,
30.758165,-87.307671,30.758287,
-87.306122,30.75518,-87.310478,
30.75054,-87.30851,30.745073,
-87.31208,30.740379,-87.312012,
30.734432,-87.308281,30.726746,
-87.302155,30.722588,-87.302299,
30.719467,-87.29483,30.718103,
-87.296494,30.720526,-87.294701,
30.721325,-87.292465,30.718687,
-87.289108,30.720947,-87.281425,
30.719606,-87.276695,30.713654,
-87.273232,30.717623,-87.273254,
30.714096,-87.270042,30.712442,
-87.270729,30.703491,-87.268372,
30.700773,-87.272713,30.70001,
-87.272568,30.693857,-87.265778,
30.688807,-87.268829,30.679144,
-87.266464,30.677378,-87.266808,
30.664776,-87.264214,30.662039,
-87.266296,30.658072,-87.264137,
30.655558,-87.264488,30.648493,
-87.256767,30.634165,-87.258835,
30.62965,-87.251984,30.623713,
-87.26091,30.620832,-87.257187,
30.614496,-87.259232,30.611313,
-87.249695,30.605696,-87.244736,
30.60528,-87.242943,30.602272,
-87.246078,30.59992,-87.245476,
30.597088,-87.233696,30.594929,
-87.233727,30.591328,-87.229759,
30.589329,-87.231552,30.586191,
-87.224876,30.580671,-87.222366,
30.571392,-87.210876,30.556065,
-87.195854,30.548752,-87.189598,
30.548599,-87.167908,30.541401,
-87.152702,30.531099,-87.138336,
30.511681,-87.127747,30.505104,
-87.124496,30.497801,-87.124603,
30.4849,-87.133682,30.467873,
-87.138046,30.451712,-87.134338,
30.421841,-87.136734,30.416544,
-87.152603,30.4056,-87.228256,
30.384048,-87.232819,30.379025,
-87.233307,30.349001,-87.211906,
30.339899,-87.195999,30.339701,
-87.191788,30.337742,-87.180603,
30.334,-87.153,30.3482,-87.125,
30.3501,-87.120796,30.3535,
-87.086197,30.3592,-87.080597,
30.363001,-87.060905,30.363899,
-87.045403,30.370199,-87.038506,
30.3685,-87.023201,30.3694,
-87.017105,30.3722,-86.997818,
30.373734,-86.936432,30.38471,
-86.866432,30.392237,-86.86248,
30.381651,-86.918221,30.371435,
-86.850632,30.383423,-86.850609,
30.380384,-86.799461,30.38608,
-86.785957,30.996798,-87.162651,
30.998875)),'SantaRosa','12113',
'Florida','FL','12',1015.645,81608,80.3508);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.642792,27.389099,-82.624039,
27.361883,-82.592972,27.330345,
-82.588974,27.32152,-82.567596,
27.297199,-82.563522,27.286484,
-82.569939,27.279127,-82.569397,
27.2759,-82.561104,27.2687,
-82.545143,27.26008,-82.539902,
27.254,-82.512505,27.207199,
-82.509789,27.206301,-82.497314,
27.175119,-82.477203,27.1409,
-82.46907,27.113279,-82.465508,
27.110399,-82.460503,27.0996,
-82.445908,27.060301,-82.419403,
27.020399,-82.400803,26.9846,
-82.375946,26.945484,-82.255829,
26.944984,-82.255424,27.03264,
-82.057663,27.031857,-82.056686,
27.207441,-82.253784,27.208588,
-82.252457,27.385921,-82.447037,
27.385698,-82.449402,27.3881,
-82.642792,27.389099)),'Sarasota',
'12115','Florida','FL','12',571.6552,277776,485.9147);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.4142,28.785299,-81.415306,
28.7547,-81.41758,28.753645,
-81.421104,28.74,-81.430397,
28.726299,-81.441704,28.715,
-81.459396,28.7129,-81.459702,
28.639799,-81.328705,28.639299,
-81.328102,28.610001,-80.987473,
28.612722,-80.990723,28.614647,
-80.987091,28.617632,-80.988983,
28.624245,-80.994759,28.621428,
-80.99958,28.627108,-80.998352,
28.630175,-81.00238,28.630358,
-81.007645,28.636402,-81.001602,
28.640091,-81.009018,28.658525,
-81.0075,28.661863,-81.021507,
28.673983,-81.021523,28.684958,
-81.016846,28.691757,-81.021088,
28.700279,-81.027969,28.704357,
-81.035065,28.708956,-81.033981,
28.717995,-81.039497,28.721952,
-81.036621,28.722574,-81.036942,
28.724476,-81.041367,28.725861,
-81.04187,28.72995,-81.051422,
28.73691,-81.060974,28.749134,
-81.054382,28.783039,-81.059395,
28.794672,-81.068031,28.80344,
-81.067635,28.812719,-81.074142,
28.815008,-81.076302,28.819056,
-81.085091,28.815489,-81.092163,
28.824385,-81.097954,28.821247,
-81.103714,28.824545,-81.105507,
28.828209,-81.120003,28.825888,
-81.126801,28.820608,-81.12336,
28.813856,-81.131294,28.806032,
-81.129501,28.799185,-81.140541,
28.795967,-81.136292,28.794081,
-81.136383,28.791952,-81.160591,
28.790592,-81.170944,28.782768,
-81.171425,28.785503,-81.177727,
28.785521,-81.179153,28.781616,
-81.181374,28.783279,-81.180557,
28.796144,-81.183678,28.796753,
-81.187805,28.793344,-81.19101,
28.795263,-81.197105,28.791552,
-81.213364,28.80344,-81.214668,
28.807535,-81.216705,28.80768,
-81.216354,28.814177,-81.22493,
28.821297,-81.223167,28.826496,
-81.226227,28.832209,-81.32029,
28.834543,-81.324226,28.837185,
-81.333694,28.840128,-81.341759,
28.846785,-81.358925,28.848017,
-81.35984,28.850033,-81.355522,
28.853489,-81.354752,28.8584,
-81.351395,28.857376,-81.352333,
28.862047,-81.364861,28.865423,
-81.360367,28.871073,-81.367149,
28.87896,-81.366531,28.87336,
-81.372597,28.868799,-81.374115,
28.869781,-81.375214,28.862003,
-81.383301,28.851566,-81.390427,
28.848602,-81.394867,28.841845,
-81.408478,28.833797,-81.417053,
28.824305,-81.4198,28.814899,
-81.413925,28.793907,-81.4142,
28.785299)),'Seminole','12117',
'Florida','FL','12',308.1689,287529,933.0229);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.311783,28.960089,-82.30529,
28.95228,-82.297272,28.948095,
-82.295052,28.942434,-82.296127,
28.938141,-82.290176,28.935335,
-82.282372,28.914434,-82.277779,
28.910616,-82.273766,28.896955,
-82.242714,28.876553,-82.239365,
28.869757,-82.240326,28.866524,
-82.232147,28.856319,-82.219406,
28.850502,-82.212418,28.84247,
-82.207123,28.840284,-82.20517,
28.834486,-82.183823,28.823364,
-82.179497,28.803053,-82.169701,
28.795881,-82.169655,28.791294,
-82.184639,28.78285,-82.188118,
28.777493,-82.188431,28.771399,
-82.182434,28.768614,-82.184998,
28.761505,-82.188904,28.758802,
-82.195297,28.759949,-82.19931,
28.757099,-82.207817,28.756924,
-82.213257,28.747549,-82.217232,
28.747984,-82.218758,28.743916,
-82.231544,28.735809,-82.232872,
28.730446,-82.242172,28.72349,
-82.249268,28.717506,-82.251648,
28.710316,-82.249245,28.707672,
-82.251503,28.705221,-82.249084,
28.701551,-82.254021,28.689848,
-82.260162,28.682455,-82.260437,
28.672695,-82.263237,28.667366,
-82.268089,28.662384,-82.267197,
28.660503,-82.2742,28.660414,
-82.274284,28.654333,-82.267487,
28.647949,-82.260796,28.646748,
-82.257042,28.648586,-82.260384,
28.634766,-82.253433,28.629353,
-82.248192,28.629206,-82.24601,
28.625336,-82.24765,28.622538,
-82.242706,28.61846,-82.242371,
28.612961,-82.23439,28.608393,
-82.233505,28.600401,-82.228928,
28.600515,-82.22197,28.593363,
-82.219475,28.582384,-82.213913,
28.575092,-82.207863,28.571737,
-82.199341,28.572807,-82.197243,
28.575306,-82.19194,28.574551,
-82.187241,28.572283,-82.186699,
28.56843,-82.168732,28.566593,
-82.166962,28.563614,-82.155807,
28.572546,-82.150215,28.570971,
-82.143982,28.565603,-82.137833,
28.564754,-82.13578,28.556271,
-82.12896,28.544668,-82.11821,
28.540518,-82.109718,28.543867,
-82.103592,28.532774,-82.094086,
28.523127,-82.069687,28.531452,
-82.058067,28.52478,-82.054794,
28.521284,-82.05545,28.478125,
-82.056175,28.311632,-82.040466,
28.319967,-82.027794,28.323233,
-82.015808,28.323441,-82.006371,
28.322609,-81.997185,28.317984,
-81.987038,28.304289,-81.979568,
28.304928,-81.976639,28.30904,
-81.967491,28.306911,-81.958115,
28.307968,-81.95784,28.344896,
-81.954384,28.55584,-81.954384,
28.959791,-82.311783,28.960089)),
'Sumter','12119','Florida','FL','12',545.583,31577,57.8775);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-83.171112,30.385008,-83.177849,
30.383974,-83.193008,30.373816,
-83.193726,30.357409,-83.190384,
30.35166,-83.199364,30.348,
-83.203125,30.350683,-83.207832,
30.350555,-83.211693,30.347263,
-83.212898,30.344124,-83.208038,
30.33087,-83.214493,30.319616,
-83.210068,30.311661,-83.212646,
30.307055,-83.225929,30.301048,
-83.233147,30.291801,-83.231812,
30.283598,-83.240433,30.266806,
-83.237099,30.261408,-83.247391,
30.260452,-83.251846,30.25852,
-83.253067,30.250395,-83.250328,
30.247417,-83.244194,30.249355,
-83.242554,30.247948,-83.25116,
30.242922,-83.252846,30.235434,
-83.25,30.231459,-83.239822,
30.226522,-83.250214,30.200424,
-83.250137,30.190268,-83.247253,
30.179527,-83.231743,30.16662,
-83.232384,30.16044,-83.238838,
30.15254,-83.225273,30.137772,
-83.2258,30.1131,-83.213707,30.1031,
-83.201202,30.1056,-83.195396,
30.104401,-83.184502,30.093901,
-83.179398,30.099199,-83.167801,
30.100599,-83.162598,30.1098,
-83.150101,30.103901,-83.140701,
30.1033,-83.133705,30.096701,
-83.123039,30.104158,-83.117912,
30.10437,-83.114388,30.102201,
-83.114204,30.093405,-83.112053,
30.090933,-83.099907,30.091084,
-83.087563,30.08272,-83.069695,
30.081028,-83.070274,30.070368,
-83.065117,30.064344,-83.041649,
30.054344,-83.034866,30.045559,
-83.027046,30.043161,-83.013443,
30.031898,-83.001465,30.008564,
-82.994759,30.005806,-82.979568,
30.007166,-82.974297,29.996408,
-82.963997,29.994318,-82.960526,
29.974926,-82.954292,29.966196,
-82.952553,29.959133,-82.930939,
29.95717,-82.923691,29.943077,
-82.92411,29.936287,-82.920692,
29.929842,-82.926033,29.921103,
-82.918739,29.914843,-82.919159,
29.908026,-82.912254,29.904606,
-82.918617,29.89794,-82.915703,
29.891562,-82.909149,29.889263,
-82.907784,29.897907,-82.903908,
29.900724,-82.898018,29.901211,
-82.885315,29.891346,-82.886055,
29.887766,-82.890999,29.890682,
-82.89325,29.889339,-82.890251,
29.884686,-82.884033,29.882257,
-82.879951,29.886616,-82.875,
29.890572,-82.871719,29.898203,
-82.866623,29.899122,-82.867599,
29.903246,-82.863045,29.911108,
-82.850403,29.913883,-82.841904,
29.911892,-82.839409,29.914734,
-82.832069,29.912605,-82.814369,
29.929976,-82.808586,29.932863,
-82.800262,29.932062,-82.798607,
29.936483,-82.791664,29.941982,
-82.785896,29.954515,-82.762451,
29.964569,-82.759155,29.975269,
-82.760567,29.986326,-82.794128,
29.985979,-82.794754,30.336666,
-82.79995,30.343908,-82.80439,
30.345167,-82.81115,30.33662,
-82.812874,30.340197,-82.825867,
30.340149,-82.827133,30.34528,
-82.831757,30.346266,-82.836143,
30.3423,-82.841743,30.342848,
-82.844704,30.340717,-82.852814,
30.348713,-82.852318,30.356731,
-82.854431,30.35224,-82.857895,
30.358242,-82.863701,30.356911,
-82.868568,30.362019,-82.871765,
30.360685,-82.872459,30.36598,
-82.881165,30.366785,-82.885078,
30.364817,-82.884628,30.36665,
-82.888832,30.368324,-82.893616,
30.374374,-82.889351,30.385885,
-82.905922,30.387747,-82.902618,
30.384104,-82.907562,30.383966,
-82.908699,30.379889,-82.910072,
30.382591,-82.915146,30.382914,
-82.916145,30.385227,-82.920685,
30.385689,-82.927719,30.390638,
-82.929832,30.388597,-82.932793,
30.394785,-82.935463,30.394625,
-82.937904,30.398191,-82.948784,
30.400787,-82.946854,30.40592,
-82.955795,30.409927,-82.956238,
30.413387,-82.963776,30.414738,
-82.966187,30.417234,-82.971886,
30.416937,-82.972504,30.418953,
-82.974007,30.417095,-82.977554,
30.419638,-82.983025,30.418789,
-82.985008,30.425295,-82.998016,
30.43042,-83.004837,30.43148,
-83.00235,30.428659,-83.008202,
30.422178,-83.015923,30.422815,
-83.034447,30.430433,-83.035583,
30.428694,-83.038498,30.430412,
-83.048912,30.429955,-83.051399,
30.427572,-83.060333,30.429659,
-83.059753,30.427092,-83.067978,
30.428236,-83.068848,30.424295,
-83.07534,30.425165,-83.082039,
30.442303,-83.084518,30.437582,
-83.11132,30.433823,-83.117477,
30.431208,-83.122223,30.432192,
-83.129272,30.427296,-83.135361,
30.418419,-83.141678,30.422232,
-83.148117,30.41728,-83.149864,
30.418713,-83.155045,30.416822,
-83.159737,30.409584,-83.155449,
30.408026,-83.158485,30.400366,
-83.165283,30.398129,-83.164566,
30.392553,-83.169098,30.390665,
-83.171112,30.385008)),'Suwannee',
'12121','Florida','FL','12',687.5629,26780,38.9491);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-83.820045,30.303331,-83.819809,
30.29969,-83.825722,30.296988,
-83.827141,30.291422,-83.829338,
30.291491,-83.828812,30.28817,
-83.833794,30.286337,-83.836983,
30.280725,-83.838387,30.28171,
-83.844872,30.27738,-83.853241,
30.277218,-83.854469,30.273783,
-83.863441,30.271053,-83.879486,
30.268972,-83.896011,30.257366,
-83.897118,30.252146,-83.902931,
30.248955,-83.902611,30.247168,
-83.910027,30.247469,-83.915962,
30.244858,-83.916061,30.233683,
-83.921631,30.228643,-83.916695,
30.225254,-83.919098,30.219873,
-83.917519,30.217379,-83.924797,
30.205952,-83.923798,30.198799,
-83.927505,30.1947,-83.926308,
30.1919,-83.929604,30.189301,
-83.939705,30.1915,-83.950203,
30.187599,-83.953026,30.175379,
-83.957237,30.174002,-83.957893,
30.161968,-83.963036,30.157421,
-83.960686,30.151766,-83.973465,
30.145695,-83.972878,30.140129,
-83.969009,30.135712,-83.977646,
30.122894,-83.984596,30.104799,
-83.988106,30.103399,-83.992302,
30.096001,-83.991798,30.088089,
-83.974236,30.071869,-83.95311,
30.061565,-83.927353,30.036324,
-83.915504,30.032719,-83.878418,
30.013144,-83.856262,30.004387,
-83.835663,29.988934,-83.821243,
29.982237,-83.807327,29.978115,
-83.78466,29.977085,-83.773849,
29.973995,-83.759911,29.964579,
-83.749123,29.959572,-83.729538,
29.942595,-83.680481,29.917614,
-83.668213,29.90626,-83.638695,
29.885366,-83.620987,29.84767,
-83.593735,29.819054,-83.586464,
29.814058,-83.58329,29.779085,
-83.577385,29.768641,-83.564667,
29.759556,-83.559219,29.745022,
-83.551941,29.735029,-83.53923,
29.725039,-83.525833,29.718678,
-83.509933,29.71232,-83.501305,
29.713909,-83.496758,29.712093,
-83.479507,29.687794,-83.460197,
29.6803,-83.455887,29.675758,
-83.43045,29.676666,-83.415497,
29.665344,-83.399773,29.673742,
-83.373497,29.665726,-83.366692,
29.665808,-83.363159,29.668423,
-83.365356,29.676117,-83.350639,
29.695694,-83.351509,29.70647,
-83.350281,29.712172,-83.347244,
29.714375,-83.344971,29.72703,
-83.347809,29.733353,-83.343422,
29.736723,-83.345657,29.743296,
-83.34243,29.746183,-83.337051,
29.760004,-83.331642,29.761745,
-83.3256,29.770567,-83.326729,
29.773409,-83.319603,29.778334,
-83.319,29.822399,-83.352997,
29.822001,-83.353127,29.887638,
-83.371033,29.887714,-83.367279,
30.260244,-83.469398,30.260099,
-83.468903,30.304001,-83.820045,
30.303331)),'Taylor','12123',
'Florida','FL','12',1041.7685,17111,16.4249);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-82.458549,30.136213,-82.458389,
30.128572,-82.452713,30.123087,
-82.457794,30.102734,-82.468048,
30.096888,-82.490074,30.089638,
-82.498688,30.088854,-82.516518,
30.078161,-82.535789,30.054585,
-82.540276,30.03561,-82.534378,
30.030682,-82.536743,30.025249,
-82.543533,30.020554,-82.562607,
30.015993,-82.573341,30.010426,
-82.571869,30.000444,-82.576195,
29.990843,-82.569321,29.974983,
-82.557137,29.968843,-82.554024,
29.963093,-82.541023,29.962952,
-82.533607,29.958506,-82.530869,
29.954952,-82.529663,29.940971,
-82.524239,29.945143,-82.522057,
29.943171,-82.510483,29.944908,
-82.50164,29.941788,-82.499199,
29.938555,-82.484337,29.939407,
-82.484337,29.936453,-82.477623,
29.934666,-82.477257,29.931849,
-82.470177,29.92557,-82.469177,
29.928114,-82.463493,29.928459,
-82.461517,29.931416,-82.452209,
29.925528,-82.447266,29.931694,
-82.441757,29.928923,-82.439102,
29.93096,-82.435181,29.928097,
-82.433815,29.929266,-82.422852,
29.919777,-82.418953,29.922892,
-82.416397,29.925779,-82.409538,
29.926809,-82.389961,29.925682,
-82.371124,29.935072,-82.358253,
29.933451,-82.346916,29.942644,
-82.344238,29.951241,-82.345299,
29.956556,-82.341606,29.961393,
-82.327736,29.957958,-82.32534,
29.956217,-82.326424,29.954704,
-82.322243,29.95381,-82.321999,
29.955368,-82.313423,29.954453,
-82.307083,29.956194,-82.301025,
29.967104,-82.292206,29.97352,
-82.29068,29.978767,-82.279465,
29.988529,-82.273582,29.998682,
-82.27269,30.005281,-82.266258,
30.012407,-82.265671,30.020428,
-82.263283,30.02107,-82.25985,
30.028128,-82.24131,30.029247,
-82.226456,30.033541,-82.220741,
30.037849,-82.216766,30.045094,
-82.213493,30.044062,-82.208206,
30.052177,-82.180466,30.07024,
-82.170242,30.098955,-82.146904,
30.110298,-82.141899,30.117676,
-82.138168,30.12826,-82.141144,
30.132868,-82.144897,30.131334,
-82.146126,30.132687,-82.142815,
30.142879,-82.359558,30.140806,
-82.359543,30.139057,-82.458549,
30.136213)),'Union','12125',
'Florida','FL','12',240.2572,10252,42.6708);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-81.681084,29.324188,-81.672096,
29.304766,-81.666428,29.300297,
-81.655045,29.299078,-81.642105,
29.276739,-81.634018,29.254045,
-81.634315,29.245049,-81.618149,
29.225822,-81.615105,29.217077,
-81.617157,29.209419,-81.61219,
29.202866,-81.595596,29.198814,
-81.572365,29.203245,-81.561203,
29.1999,-81.554001,29.188101,
-81.554398,29.184299,-81.547905,
29.184601,-81.543999,29.180201,
-81.532303,29.176901,-81.531502,
29.171101,-81.523308,29.167299,
-81.523506,29.156601,-81.504471,
29.122391,-81.506126,29.113325,
-81.502808,29.106195,-81.500526,
29.102245,-81.502266,29.097544,-81.5,
29.096001,-81.487175,29.092651,
-81.468063,29.096785,-81.458672,
29.093573,-81.45459,29.081724,
-81.45993,29.078941,-81.461067,
29.075493,-81.455978,29.071287,
-81.455498,29.062811,-81.446289,
29.061871,-81.432457,29.044296,
-81.426041,29.044722,-81.419868,
29.03838,-81.413467,29.037189,
-81.410118,29.031239,-81.402969,
29.03241,-81.394882,29.024265,
-81.395554,29.019388,-81.391441,
29.019842,-81.388412,29.016865,
-81.38839,29.010447,-81.380905,
29.007298,-81.378365,28.998678,
-81.372414,28.99824,-81.375885,
28.993736,-81.364624,28.992464,
-81.35611,28.986784,-81.355438,
28.982271,-81.360977,28.976513,
-81.364288,28.968288,-81.369598,
28.968639,-81.365822,28.960705,
-81.370834,28.957567,-81.367744,
28.954992,-81.358994,28.955744,
-81.360451,28.951296,-81.353996,
28.94928,-81.359505,28.944351,
-81.353554,28.946655,-81.355331,
28.939745,-81.349854,28.939024,
-81.353584,28.936928,-81.351646,
28.932575,-81.355583,28.929665,
-81.352142,28.920481,-81.35434,
28.920641,-81.359505,28.914177,
-81.35688,28.910273,-81.360382,
28.906384,-81.357773,28.899376,
-81.352882,28.896273,-81.355774,
28.896769,-81.354797,28.892817,
-81.357315,28.886784,-81.365166,
28.889441,-81.366173,28.88448,
-81.363281,28.878784,-81.367149,
28.87896,-81.360367,28.871073,
-81.364861,28.865423,-81.352333,
28.862047,-81.351395,28.857376,
-81.354752,28.8584,-81.355522,
28.853489,-81.35984,28.850033,
-81.358925,28.848017,-81.341759,
28.846785,-81.333694,28.840128,
-81.324226,28.837185,-81.32029,
28.834543,-81.226227,28.832209,
-81.223167,28.826496,-81.22493,
28.821297,-81.216354,28.814177,
-81.216705,28.80768,-81.214668,
28.807535,-81.213364,28.80344,
-81.197105,28.791552,-81.19101,
28.795263,-81.187805,28.793344,
-81.183678,28.796753,-81.180557,
28.796144,-81.181374,28.783279,
-81.179153,28.781616,-81.177727,
28.785521,-81.171425,28.785503,
-81.170944,28.782768,-81.160591,
28.790592,-81.136383,28.791952,
-81.136292,28.794081,-81.140541,
28.795967,-81.129501,28.799185,
-81.131294,28.806032,-81.12336,
28.813856,-81.126801,28.820608,
-81.120003,28.825888,-81.105507,
28.828209,-81.103714,28.824545,
-81.097954,28.821247,-81.092163,
28.824385,-81.085091,28.815489,
-81.076302,28.819056,-81.074142,
28.815008,-81.067635,28.812719,
-81.068031,28.80344,-81.059395,
28.794672,-81.054382,28.783039,
-81.060974,28.749134,-81.051422,
28.73691,-81.04187,28.72995,
-81.041367,28.725861,-81.036942,
28.724476,-81.036621,28.722574,
-81.039497,28.721952,-81.033981,
28.717995,-81.035065,28.708956,
-81.027969,28.704357,-81.021088,
28.700279,-81.016846,28.691757,
-81.021523,28.684958,-81.021507,
28.673983,-81.0075,28.661863,
-81.009018,28.658525,-81.001602,
28.640091,-81.007645,28.636402,
-81.00238,28.630358,-80.998352,
28.630175,-80.99958,28.627108,
-80.994759,28.621428,-80.988983,
28.624245,-80.987091,28.617632,
-80.990723,28.614647,-80.987473,
28.612722,-80.964622,28.613131,
-80.968117,28.78993,-80.731941,
28.790306,-80.873199,29.002199,
-80.894707,29.037432,-80.908997,
29.068399,-80.935303,29.097601,
-80.960564,29.137217,-81.046906,
29.3076,-81.102097,29.427383,
-81.110909,29.426624,-81.148827,
29.41642,-81.14827,29.411592,
-81.156105,29.4107,-81.150307,
29.265699,-81.417503,29.2609,
-81.420952,29.399437,-81.423416,
29.400421,-81.425537,29.396938,
-81.429962,29.39687,-81.431953,
29.399414,-81.434196,29.3983,
-81.440063,29.391047,-81.44043,
29.385201,-81.452301,29.377899,
-81.681084,29.324188)),'Volusia',
'12127','Florida','FL','12',1105.6865,370712,335.2773);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-84.71344,30.299974,-84.729294,
30.287239,-84.730927,30.280243,
-84.727341,30.278194,-84.727753,
30.275648,-84.731033,30.27496,
-84.732254,30.267746,-84.736641,
30.267715,-84.7379,30.265457,
-84.726692,30.256521,-84.715805,
30.251322,-84.712311,30.250242,
-84.708977,30.253288,-84.70562,
30.251617,-84.698357,30.24552,
-84.700745,30.24321,-84.697205,
30.23667,-84.699181,30.236174,
-84.698685,30.233381,-84.701599,
30.234913,-84.697388,30.228943,
-84.69976,30.2276,-84.695595,
30.227135,-84.694702,30.222298,
-84.687737,30.221907,-84.682144,
30.218122,-84.680191,30.206841,
-84.681656,30.20219,-84.676064,
30.200964,-84.678345,30.187904,
-84.674438,30.183622,-84.672684,
30.186794,-84.672646,30.183887,
-84.670525,30.184767,-84.668335,
30.182123,-84.668175,30.17462,
-84.670128,30.173449,-84.665016,
30.1698,-84.667496,30.168177,
-84.665215,30.166262,-84.669678,
30.165264,-84.667091,30.163784,
-84.669197,30.163359,-84.667732,
30.161238,-84.670708,30.157555,
-84.668907,30.152266,-84.67263,
30.150206,-84.670464,30.149639,
-84.671768,30.147011,-84.669296,
30.146576,-84.668419,30.143106,
-84.672318,30.141033,-84.669991,
30.137226,-84.667091,30.137051,
-84.668152,30.134926,-84.665543,
30.134287,-84.670471,30.127968,
-84.66935,30.125,-84.665962,30.12397,
-84.667511,30.122465,-84.661194,
30.120068,-84.660255,30.11541,
-84.65728,30.113861,-84.656502,
30.117006,-84.653374,30.117983,
-84.648384,30.109085,-84.651932,
30.106764,-84.651955,30.104181,
-84.648308,30.104855,-84.652428,
30.102934,-84.650856,30.100851,
-84.654602,30.100042,-84.654243,
30.09679,-84.651505,30.097248,
-84.649765,30.092779,-84.644867,
30.091078,-84.641907,30.082479,
-84.637993,30.083549,-84.639267,
30.078979,-84.632866,30.073139,
-84.635368,30.071964,-84.63324,
30.068266,-84.628021,30.0688,
-84.63089,30.064926,-84.626244,
30.065239,-84.62619,30.062187,
-84.622093,30.063377,-84.620682,
30.066496,-84.615768,30.064793,
-84.609039,30.058306,-84.603996,
30.046144,-84.596741,30.046764,
-84.600105,30.042984,-84.594276,
30.04211,-84.59333,30.039982,
-84.59726,30.041113,-84.599411,
30.038698,-84.591141,30.029434,
-84.569572,30.016422,-84.56842,
30.020197,-84.565636,30.017126,
-84.561653,30.019911,-84.562965,
30.022449,-84.557625,30.021616,
-84.555794,30.014633,-84.550667,
30.014406,-84.548157,30.011208,
-84.546761,30.015268,-84.543121,
30.012632,-84.544739,30.010826,
-84.548973,30.006895,-84.542023,
30.002098,-84.530174,30.00742,
-84.525101,30.005018,-84.519058,
29.994926,-84.525383,29.98284,
-84.520493,29.98028,-84.512199,
29.981836,-84.514229,29.988873,
-84.489784,29.987333,-84.473343,
30.001701,-84.467819,30.00165,
-84.459778,29.993172,-84.458504,
29.974995,-84.453514,29.970959,
-84.443054,29.981995,-84.437515,
29.976824,-84.340065,29.960348,
-84.340065,29.976906,-84.355927,
29.990993,-84.361603,30.00078,
-84.365723,30.023445,-84.356956,
30.058474,-84.334297,30.070322,
-84.31369,30.068775,-84.302872,
30.064655,-84.296173,30.057959,
-84.283813,30.056414,-84.275055,
30.060534,-84.271454,30.068262,
-84.273514,30.090925,-84.269394,
30.099169,-84.262695,30.103291,
-84.253937,30.103804,-84.246208,
30.101231,-84.245697,30.094019,
-84.235909,30.08423,-84.202942,
30.082684,-84.183884,30.077534,
-84.176674,30.071869,-84.166367,
30.069805,-84.155556,30.072382,
-84.123619,30.090927,-84.081886,
30.092472,-84.075592,30.09457,
-84.075668,30.273415,-84.241325,
30.274042,-84.247772,30.303291,
-84.71344,30.299974)),'Wakulla',
'12129','Florida','FL','12',606.5903,14202,23.4128);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-86.388702,30.994001,-86.393005,
30.511478,-86.396263,30.378279,
-86.321594,30.367205,-86.230148,
30.345585,-86.072571,30.297363,
-85.996368,30.269203,-85.994301,
30.301294,-85.992676,30.389288,
-85.993462,30.405693,-85.98423,
30.417307,-85.983696,30.421165,
-85.986664,30.423309,-85.979286,
30.432383,-85.97821,30.430672,
-85.974434,30.431238,-85.974434,
30.434032,-85.970177,30.435743,
-85.969177,30.430908,-85.96376,
30.439745,-85.949654,30.444559,
-85.934128,30.445059,-85.932495,
30.441448,-85.916214,30.438307,
-85.908943,30.442518,-85.902786,
30.442245,-85.89769,30.455923,
-85.89312,30.45612,-85.894539,
30.458618,-85.889427,30.470945,
-85.885803,30.471313,-85.88652,
30.465721,-85.87809,30.46665,
-85.870079,30.483906,-85.85984,
30.489941,-85.85807,30.496712,
-85.866379,30.498648,-85.867973,
30.506735,-85.873306,30.504623,
-85.875,30.507275,-85.878273,
30.504164,-85.883888,30.507648,
-85.883057,30.509014,-85.880363,
30.507273,-85.881371,30.510094,
-85.879158,30.512222,-85.882248,
30.516602,-85.887634,30.518353,
-85.882431,30.520758,-85.887131,
30.527763,-85.880676,30.534781,
-85.880104,30.531086,-85.877342,
30.531755,-85.880432,30.542866,
-85.878365,30.546101,-85.879898,
30.556011,-85.883438,30.559673,
-85.888504,30.559584,-85.891281,
30.565716,-85.888756,30.56859,
-85.889122,30.581347,-85.893936,
30.580635,-85.89312,30.584253,
-85.895416,30.586159,-85.903267,
30.584616,-85.909523,30.586685,
-85.908989,30.59721,-85.915985,
30.596596,-85.911346,30.602358,
-85.912025,30.606897,-85.908279,
30.613497,-85.913887,30.617092,
-85.91037,30.620638,-85.91349,
30.6215,-85.910812,30.623016,
-85.91095,30.630207,-85.915382,
30.636242,-85.907593,30.640001,
-85.905914,30.644707,-85.903046,
30.644085,-85.901154,30.647745,
-85.898514,30.647812,-85.897224,
30.645288,-85.894051,30.652161,
-85.889542,30.652334,-85.890663,
30.656261,-85.881714,30.656643,
-85.879234,30.661495,-85.875,
30.659828,-85.872986,30.663019,
-85.867195,30.662939,-85.875633,
30.667879,-85.870865,30.668941,
-85.871086,30.674906,-85.875557,
30.680647,-85.867409,30.680302,
-85.863373,30.685301,-85.865891,
30.690956,-85.86055,30.692616,
-85.858055,30.698383,-85.853554,
30.699903,-85.852325,30.698442,
-85.850822,30.701023,-85.844788,
30.70294,-86.037659,30.704384,
-86.035103,30.993139,-86.187302,
30.993841,-86.388702,30.994001)),
'Walton','12131','Florida','FL','12',1057.4892,27760,26.2508);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-85.844788,30.70294,-85.850822,
30.701023,-85.852325,30.698442,
-85.853554,30.699903,-85.858055,
30.698383,-85.86055,30.692616,
-85.865891,30.690956,-85.863373,
30.685301,-85.867409,30.680302,
-85.875557,30.680647,-85.871086,
30.674906,-85.870865,30.668941,
-85.875633,30.667879,-85.867195,
30.662939,-85.872986,30.663019,
-85.875,30.659828,-85.879234,
30.661495,-85.881714,30.656643,
-85.890663,30.656261,-85.889542,
30.652334,-85.894051,30.652161,
-85.897224,30.645288,-85.898514,
30.647812,-85.901154,30.647745,
-85.903046,30.644085,-85.905914,
30.644707,-85.907593,30.640001,
-85.915382,30.636242,-85.91095,
30.630207,-85.910812,30.623016,
-85.91349,30.6215,-85.91037,
30.620638,-85.913887,30.617092,
-85.908279,30.613497,-85.912025,
30.606897,-85.911346,30.602358,
-85.915985,30.596596,-85.908989,
30.59721,-85.909523,30.586685,
-85.903267,30.584616,-85.895416,
30.586159,-85.89312,30.584253,
-85.893936,30.580635,-85.889122,
30.581347,-85.888756,30.56859,
-85.891281,30.565716,-85.888504,
30.559584,-85.883438,30.559673,
-85.879898,30.556011,-85.878365,
30.546101,-85.880432,30.542866,
-85.877342,30.531755,-85.880104,
30.531086,-85.880676,30.534781,
-85.887131,30.527763,-85.882431,
30.520758,-85.887634,30.518353,
-85.882248,30.516602,-85.879158,
30.512222,-85.881371,30.510094,
-85.880363,30.507273,-85.883057,
30.509014,-85.883888,30.507648,
-85.878273,30.504164,-85.875,
30.507275,-85.873306,30.504623,
-85.867973,30.506735,-85.866379,
30.498648,-85.85807,30.496712,
-85.85984,30.489941,-85.870079,
30.483906,-85.87809,30.46665,
-85.88652,30.465721,-85.885803,
30.471313,-85.889427,30.470945,
-85.894539,30.458618,-85.89312,
30.45612,-85.89769,30.455923,
-85.902786,30.442245,-85.908943,
30.442518,-85.916214,30.438307,
-85.932495,30.441448,-85.934128,
30.445059,-85.949654,30.444559,
-85.96376,30.439745,-85.969177,
30.430908,-85.970177,30.435743,
-85.974434,30.434032,-85.974434,
30.431238,-85.97821,30.430672,
-85.979286,30.432383,-85.986664,
30.423309,-85.983696,30.421165,
-85.98423,30.417307,-85.993462,
30.405693,-85.992676,30.389288,
-85.98233,30.391762,-85.975815,
30.395901,-85.976448,30.398338,
-85.972755,30.402229,-85.964317,
30.407381,-85.965248,30.410183,
-85.952301,30.412127,-85.945633,
30.408016,-85.940247,30.408373,
-85.924126,30.415939,-85.90818,
30.40579,-85.901749,30.407089,
-85.898209,30.410751,-85.883987,
30.410254,-85.870361,30.419764,
-85.864075,30.428041,-85.860825,
30.43721,-85.853706,30.440535,
-85.487839,30.43679,-85.486137,
30.567299,-85.435112,30.567474,
-85.432343,30.785267,-85.482994,
30.785686,-85.482346,30.829597,
-85.599838,30.830362,-85.59919,
30.814436,-85.603409,30.796652,
-85.621277,30.771349,-85.618927,
30.743671,-85.736122,30.74618,
-85.735184,30.775105,-85.752045,
30.775534,-85.751999,30.78965,
-85.821678,30.790588,-85.81707,
30.782501,-85.827843,30.774778,
-85.830605,30.766884,-85.82859,
30.761038,-85.832657,30.759665,
-85.827942,30.752401,-85.833092,
30.75,-85.824371,30.743811,
-85.829803,30.741409,-85.823692,
30.738779,-85.822746,30.735977,
-85.828445,30.730486,-85.826035,
30.725897,-85.831696,30.72323,
-85.833199,30.726641,-85.834984,
30.726,-85.834007,30.721163,
-85.836685,30.717205,-85.839394,
30.71855,-85.840027,30.716089,
-85.835289,30.710854,-85.8423,
30.710661,-85.845123,30.707781,
-85.844788,30.70294)),'Washington',
'12133','Florida','FL','12',579.7797,16919,29.1817);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.809799,42.778801,-73.809998,
42.775101,-74.180702,42.729904,
-74.165108,42.717133,-74.169952,
42.691292,-74.170273,42.66732,
-74.182266,42.641682,-74.192993,
42.626991,-74.193916,42.618923,
-74.207123,42.605915,-74.210014,
42.597351,-74.218575,42.593567,
-74.243256,42.558083,-74.238571,
42.543781,-74.229416,42.528824,
-74.231071,42.519054,-74.225983,
42.507984,-74.22892,42.494305,
-74.244873,42.470188,-74.252846,
42.445267,-74.265282,42.419785,
-74.263878,42.407047,-74.254723,
42.408127,-73.933685,42.444733,
-73.818054,42.461334,-73.784149,
42.464153,-73.78598,42.487129,
-73.777519,42.503922,-73.761765,
42.525753,-73.752602,42.566502,
-73.7528,42.576599,-73.761703,
42.6007,-73.761703,42.610298,
-73.742203,42.654301,-73.729706,
42.664799,-73.702904,42.699902,
-73.704002,42.7094,-73.697701,
42.728699,-73.6894,42.738201,
-73.684219,42.766544,-73.6772,
42.783199,-73.681602,42.782902,
-73.682503,42.779701,-73.689598,
42.775299,-73.703598,42.782398,
-73.709396,42.787601,-73.7118,
42.795101,-73.720306,42.801201,
-73.717102,42.808102,-73.721802,
42.813,-73.723106,42.820599,
-73.727104,42.822498,-73.738106,
42.818802,-73.750603,42.8013,
-73.767105,42.785999,-73.777802,
42.791698,-73.782906,42.791698,
-73.798401,42.7794,-73.809799,
42.778801)),'Albany','36001',
'NewYork','NY','36',523.6762,292594,558.7299);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-78.309097,42.520939,-78.308395,
41.999352,-78.206871,41.999531,
-77.750214,41.998714,-77.731346,
42.404057,-77.726395,42.403976,
-77.723251,42.471149,-77.840515,
42.47451,-77.840973,42.517704,
-78.040794,42.518398,-78.038994,
42.520901,-78.309097,42.520939)),
'Allegany','36003','NewYork','NY','36',1030.1035,50470,48.995);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.933998,40.881901,-73.920403,
40.8764,-73.915802,40.875401,
-73.912003,40.879101,-73.907707,
40.876099,-73.9114,40.866402,
-73.928703,40.845402,-73.933998,
40.833,-73.932304,40.8078,-73.927803,
40.801998,-73.922905,40.801998,
-73.913101,40.796001,-73.890907,
40.790199,-73.889702,40.787201,
-73.874107,40.785801,-73.863304,
40.7971,-73.853203,40.799599,
-73.817703,40.805302,-73.787903,
40.799801,-73.782303,40.804298,
-73.779999,40.812,-73.797615,
40.815208,-73.813286,40.82724,
-73.815666,40.830597,-73.815102,
40.843185,-73.808807,40.846966,
-73.800415,40.847801,-73.790627,
40.867668,-73.784477,40.869617,
-73.785622,40.877769,-73.784096,
40.880333,-73.838905,40.893902,
-73.842003,40.903801,-73.853798,
40.907101,-73.851303,40.909801,
-73.854797,40.908798,-73.859901,
40.900299,-73.918503,40.9174,
-73.933998,40.881901)),'Bronx',
'36005','NewYork','NY','36',42.0232,1203789,28645.75);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-76.130531,42.410263,-76.130028,
42.401966,-76.12487,42.401943,
-76.124817,42.39193,-76.12056,
42.380669,-76.123207,42.380714,
-76.122795,42.367115,-76.114983,
42.367035,-76.114967,42.357212,
-76.112297,42.357193,-76.110268,
42.347271,-76.109642,42.337257,
-76.117058,42.337154,-76.116714,
42.326496,-76.112778,42.32645,
-76.112755,42.318531,-76.106743,
42.318661,-76.106606,42.310272,
-76.101974,42.310326,-76.101944,
42.303257,-76.099464,42.303326,
-76.099113,42.293579,-76.106918,
42.293457,-76.106934,42.287285,
-76.101578,42.287216,-76.10096,
42.278347,-76.088081,42.27869,
-76.087608,42.271637,-76.083801,
42.271744,-76.081032,42.258007,
-76.096985,42.257378,-76.096703,
42.249454,-76.091255,42.249561,
-76.084801,42.230431,-76.081474,
42.230412,-76.082909,42.213009,
-76.087044,42.212849,-76.085236,
42.193569,-76.087677,42.193535,
-76.087425,42.186752,-76.116577,
42.185535,-76.10891,42.101185,
-76.11171,42.101105,-76.105217,
42.031841,-76.106194,41.998783,
-75.761505,41.997711,-75.483803,
41.999168,-75.359962,41.999359,
-75.363235,42.001656,-75.364609,
42.008083,-75.379601,42.00211,
-75.390732,42.006733,-75.396942,
42.006519,-75.403549,42.012024,
-75.410416,42.029743,-75.422142,
42.041519,-75.4188,42.19495,
-75.637482,42.195549,-75.638664,
42.2486,-75.81974,42.248928,
-75.83667,42.244015,-75.844154,
42.259632,-75.852425,42.345272,
-75.864372,42.41563,-76.018089,
42.408989,-76.022285,42.408928,
-76.02256,42.412693,-76.130531,
42.410263)),'Broome','36007',
'NewYork','NY','36',706.7397,212160,300.1953);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-78.464203,42.536133,-78.467087,
42.533203,-78.469093,42.535011,
-78.477196,42.532787,-78.488731,
42.534615,-78.490944,42.530499,
-78.499603,42.52766,-78.512123,
42.527363,-78.519547,42.519272,
-78.527115,42.52129,-78.534805,
42.519711,-78.538864,42.513885,
-78.546585,42.517384,-78.552887,
42.515488,-78.554932,42.512562,
-78.560867,42.512856,-78.563118,
42.510185,-78.565742,42.512444,
-78.569489,42.510319,-78.572609,
42.512424,-78.577705,42.511097,
-78.580521,42.51416,-78.585709,
42.513588,-78.586609,42.509655,
-78.590279,42.509651,-78.591583,
42.512051,-78.59446,42.510429,
-78.599831,42.511524,-78.608414,
42.504414,-78.614693,42.506058,
-78.619385,42.501938,-78.621704,
42.504337,-78.626877,42.498116,
-78.638931,42.497295,-78.643188,
42.492176,-78.651291,42.490192,
-78.661636,42.492344,-78.665718,
42.487907,-78.672859,42.487705,
-78.675636,42.484093,-78.681221,
42.484207,-78.683426,42.477486,
-78.686943,42.475494,-78.692406,
42.476185,-78.693954,42.471748,
-78.70034,42.474216,-78.703011,
42.486427,-78.712639,42.483383,
-78.71579,42.486423,-78.719193,
42.483498,-78.72892,42.482166,
-78.731644,42.47876,-78.738182,
42.48045,-78.739632,42.473606,
-78.749428,42.473652,-78.751869,
42.468208,-78.764351,42.469975,
-78.758362,42.465401,-78.759285,
42.463093,-78.764114,42.461468,
-78.77198,42.464855,-78.775787,
42.464149,-78.778938,42.461315,
-78.770439,42.458138,-78.779305,
42.455299,-78.7966,42.46233,
-78.805984,42.458214,-78.809189,
42.458988,-78.817902,42.453159,
-78.833588,42.448036,-78.838066,
42.443005,-78.845505,42.444603,
-78.867264,42.442081,-78.870132,
42.439701,-78.877518,42.441227,
-78.884033,42.438007,-78.888535,
42.442032,-78.894836,42.439499,
-78.899582,42.448009,-78.905396,
42.445972,-78.911194,42.448696,
-78.919441,42.442249,-78.924377,
42.446091,-78.918266,42.449474,
-78.919029,42.453617,-78.933701,
42.462032,-78.938736,42.467724,
-78.949287,42.468346,-78.957344,
42.472523,-78.96347,42.486629,
-78.961914,42.493629,-78.966827,
42.493675,-78.980797,42.505867,
-78.986206,42.504768,-78.983894,
42.511837,-78.987976,42.513435,
-78.986839,42.519127,-78.992966,
42.530033,-79.005112,42.534679,
-79.013458,42.534561,-79.03286,
42.542561,-79.040802,42.537186,
-79.047867,42.538574,-79.051735,
42.535904,-79.061012,42.537796,
-79.059464,42.124664,-79.061493,
41.999199,-78.919098,41.998058,
-78.308395,41.999352,-78.309097,
42.520939,-78.464912,42.5191,
-78.464203,42.536133)),'Cattaraugus',
'36009','NewYork','NY','36',1309.7128,84234,64.3148);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-76.722183,43.343403,-76.713493,
43.249367,-76.702637,43.080143,
-76.706215,43.070717,-76.712074,
43.068623,-76.718094,43.062672,
-76.719437,43.037086,-76.714157,
43.024014,-76.711525,43.017975,
-76.721985,43.007797,-76.720985,
42.995365,-76.729141,42.987701,
-76.727951,42.978081,-76.737061,
42.970219,-76.739685,42.954407,
-76.734619,42.944744,-76.739502,
42.916767,-76.737785,42.902039,
-76.721573,42.869511,-76.717514,
42.838764,-76.719841,42.825378,
-76.740395,42.789352,-76.739799,
42.770035,-76.729279,42.71283,
-76.720024,42.700344,-76.688232,
42.674717,-76.66687,42.623386,
-76.614647,42.625298,-76.614365,
42.622196,-76.45919,42.627106,
-76.458817,42.618538,-76.26593,
42.62352,-76.275024,42.771187,
-76.275696,42.780403,-76.299118,
42.807392,-76.357323,42.849384,
-76.45108,42.845722,-76.463341,
43.006252,-76.492279,43.004902,
-76.499664,43.097656,-76.498169,
43.102592,-76.491577,43.106228,
-76.472115,43.104916,-76.476463,
43.125,-76.486649,43.143154,
-76.481575,43.145821,-76.473412,
43.14595,-76.479568,43.227451,
-76.481491,43.256573,-76.605347,
43.253506,-76.616577,43.411942,
-76.617104,43.417351,-76.623077,
43.413212,-76.630959,43.413418,
-76.670937,43.364952,-76.698502,
43.344456,-76.709053,43.346622,
-76.718147,43.343544,-76.722183,
43.343403)),'Cayuga','36011',
'NewYork','NY','36',693.1547,82313,118.7512);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-79.137077,42.569687,-79.140038,
42.561695,-79.151047,42.55069,
-79.160683,42.552753,-79.170311,
42.547935,-79.1772,42.55069,
-79.19165,42.544491,-79.201279,
42.544491,-79.207474,42.541054,
-79.250824,42.531422,-79.254265,
42.525227,-79.27285,42.518345,
-79.278351,42.510777,-79.293488,
42.509399,-79.316887,42.501831,
-79.332024,42.487381,-79.353355,
42.492886,-79.359543,42.488068,
-79.359543,42.481873,-79.362991,
42.477745,-79.369873,42.475685,
-79.382942,42.465359,-79.392578,
42.462608,-79.406334,42.45229,
-79.419418,42.452976,-79.424232,
42.441963,-79.424232,42.433022,
-79.447624,42.415127,-79.464828,
42.406185,-79.473091,42.405495,
-79.531578,42.369713,-79.553596,
42.361458,-79.589378,42.341499,
-79.596954,42.341499,-79.607269,
42.338058,-79.613464,42.329113,
-79.617592,42.330486,-79.682274,
42.298149,-79.762146,42.269817,
-79.761597,41.999016,-79.610306,
41.9986,-79.061493,41.999199,
-79.059464,42.124664,-79.061012,
42.537796,-79.090385,42.550129,
-79.082443,42.552769,-79.081955,
42.555347,-79.091331,42.555984,
-79.095329,42.564194,-79.104691,
42.562977,-79.104095,42.567726,
-79.108047,42.56992,-79.115166,
42.569984,-79.126038,42.565033,
-79.135506,42.568672,-79.137077,
42.569687)),'Chautauqua','36013',
'NewYork','NY','36',1061.9619,141895,133.6157);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-76.61969,42.28278,-76.619873,
42.2486,-76.642586,42.233646,
-76.648445,42.238022,-76.685989,
42.237549,-76.686111,42.24826,
-76.733009,42.247978,-76.734238,
42.293648,-76.843231,42.293682,
-76.96508,42.287369,-76.965347,
42.278419,-76.966003,42.001202,
-76.927399,42.001598,-76.558449,
42.00008,-76.561821,42.009033,
-76.541824,42.051655,-76.550903,
42.079552,-76.556557,42.12661,
-76.559746,42.131176,-76.554634,
42.13139,-76.558868,42.135231,
-76.557854,42.143078,-76.563881,
42.152477,-76.562874,42.155834,
-76.536842,42.155327,-76.536118,
42.25,-76.538689,42.281681,-76.61969,
42.28278)),'Chemung','36015',
'NewYork','NY','36',408.1203,95195,233.2521);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-75.89019,42.723778,-75.864372,
42.41563,-75.852425,42.345272,
-75.844154,42.259632,-75.83667,
42.244015,-75.81974,42.248928,
-75.638664,42.2486,-75.637482,
42.195549,-75.4188,42.19495,
-75.415695,42.314072,-75.414719,
42.320293,-75.407997,42.319698,
-75.410896,42.325485,-75.405342,
42.332115,-75.398529,42.337467,
-75.403023,42.348495,-75.395035,
42.353134,-75.393486,42.357506,
-75.400085,42.360367,-75.40403,
42.366089,-75.403038,42.375748,
-75.40696,42.379135,-75.404976,
42.385105,-75.395065,42.395782,
-75.393921,42.400543,-75.38179,
42.403282,-75.380951,42.407516,
-75.375336,42.410347,-75.375542,
42.416019,-75.379677,42.41671,
-75.377014,42.423801,-75.38427,
42.429066,-75.387062,42.445812,
-75.395088,42.459194,-75.400124,
42.461693,-75.401253,42.474205,
-75.404808,42.478645,-75.403877,
42.482414,-75.399521,42.483238,
-75.395721,42.48756,-75.399261,
42.497696,-75.396507,42.506695,
-75.400154,42.505871,-75.400368,
42.508434,-75.403618,42.509125,
-75.401451,42.51125,-75.390076,
42.510586,-75.384315,42.520187,
-75.387161,42.523552,-75.382599,
42.528751,-75.378174,42.535534,
-75.373032,42.536514,-75.36834,
42.551975,-75.365112,42.554535,
-75.361664,42.55217,-75.356743,
42.556061,-75.354141,42.55407,
-75.347992,42.560089,-75.339661,
42.560913,-75.331314,42.567322,
-75.331841,42.573589,-75.327202,
42.578049,-75.329964,42.581505,
-75.325043,42.590263,-75.335999,
42.593441,-75.339096,42.606319,
-75.33725,42.613319,-75.323563,
42.622723,-75.330185,42.630787,
-75.323624,42.634449,-75.323441,
42.644032,-75.328209,42.648289,
-75.331284,42.661415,-75.3283,
42.663864,-75.331528,42.668324,
-75.328117,42.672604,-75.330666,
42.674362,-75.327469,42.674751,
-75.32785,42.679852,-75.316132,
42.685345,-75.307198,42.705498,
-75.29985,42.717896,-75.297081,
42.718647,-75.296303,42.727959,
-75.300682,42.729263,-75.293327,
42.737865,-75.29599,42.744061,
-75.428368,42.738041,-75.429047,
42.745354,-75.89019,42.723778)),
'Chenango','36017','NewYork','NY','36',894.2651,51768,57.8888);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.027786,44.99564,-74.008171,
44.895275,-74.007095,44.836895,
-73.986794,44.707733,-73.96656,
44.709076,-73.946312,44.574825,
-73.933334,44.576153,-73.910095,
44.429653,-73.701134,44.445522,
-73.700714,44.440403,-73.695938,
44.442383,-73.686417,44.440468,
-73.669693,44.441307,-73.658752,
44.44384,-73.654678,44.448471,
-73.639374,44.452507,-73.629379,
44.458233,-73.613678,44.45446,
-73.602768,44.45808,-73.59684,
44.462624,-73.591118,44.461052,
-73.581383,44.464443,-73.573517,
44.464516,-73.562416,44.470963,
-73.555611,44.482204,-73.527328,
44.48798,-73.524315,44.492607,
-73.516876,44.488022,-73.501144,
44.488293,-73.497025,44.486031,
-73.490791,44.497868,-73.483582,
44.501213,-73.479408,44.506626,
-73.471252,44.507774,-73.471207,
44.514431,-73.465668,44.518906,
-73.460075,44.52,-73.459839,
44.523125,-73.463737,44.525135,
-73.461311,44.529591,-73.465218,
44.533615,-73.464264,44.537636,
-73.339058,44.546795,-73.343361,
44.551861,-73.356628,44.557426,
-73.361916,44.563538,-73.375374,
44.575771,-73.376091,44.581993,
-73.382271,44.589272,-73.377235,
44.595413,-73.377274,44.599552,
-73.383354,44.612141,-73.390656,
44.618309,-73.386917,44.626881,
-73.387207,44.636326,-73.378983,
44.641434,-73.384903,44.646641,
-73.378746,44.652119,-73.379494,
44.656727,-73.375,44.661846,
-73.370087,44.663437,-73.373146,
44.668697,-73.372139,44.675117,
-73.372055,44.677197,-73.36763,
44.678471,-73.370567,44.684811,
-73.365723,44.687504,-73.361656,
44.694973,-73.366402,44.697517,
-73.366173,44.74102,-73.352493,
44.760635,-73.347511,44.772942,
-73.333878,44.786469,-73.335464,
44.80407,-73.341858,44.808784,
-73.353897,44.820343,-73.368698,
44.827969,-73.379875,44.837967,
-73.382019,44.849312,-73.380249,
44.856995,-73.36953,44.866638,
-73.356644,44.904453,-73.34317,
44.913677,-73.33905,44.919327,
-73.338661,44.96471,-73.350639,
44.976185,-73.355057,44.987312,
-73.343552,45.010799,-73.640129,
45.003429,-73.875,45.001183,
-74.027786,44.99564)),'Clinton',
'36019','NewYork','NY','36',1039.2294,85969,82.7236);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.784149,42.464153,-73.776062,
42.460857,-73.778938,42.458813,
-73.774101,42.443958,-73.776245,
42.429855,-73.794762,42.377106,
-73.790955,42.363144,-73.793686,
42.356106,-73.783386,42.330276,
-73.784721,42.32,-73.780983,
42.305603,-73.787262,42.272919,
-73.803421,42.253567,-73.833031,
42.243973,-73.848244,42.230259,
-73.851715,42.220524,-73.849907,
42.209553,-73.855682,42.191326,
-73.875183,42.173828,-73.891975,
42.168453,-73.894264,42.156834,
-73.911095,42.127205,-73.92189,
42.109936,-73.930046,42.07869,
-73.917519,42.076385,-73.916016,
42.080814,-73.90377,42.078068,
-73.711357,42.005398,-73.527504,
41.977886,-73.521851,42.049877,
-73.497314,42.049583,-73.508575,
42.086166,-73.483696,42.154774,
-73.460655,42.217442,-73.431755,
42.296055,-73.411331,42.351543,
-73.383957,42.425407,-73.352974,
42.509918,-73.784149,42.464153)),
'Columbia','36021','NewYork','NY','36',635.6806,62982,99.0779);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-76.275024,42.771187,-76.26593,
42.62352,-76.2537,42.407497,
-76.130531,42.410263,-76.02256,
42.412693,-76.022285,42.408928,
-76.018089,42.408989,-75.864372,
42.41563,-75.89019,42.723778,
-75.896439,42.790897,-76.080528,
42.781532,-76.080566,42.779949,
-76.275024,42.771187)),'Cortland',
'36023','NewYork','NY','36',499.5971,48963,98.0048);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.711983,42.517723,-74.716843,
42.515942,-74.728653,42.517651,
-74.734131,42.513809,-74.743347,
42.515907,-74.752457,42.514187,
-74.771851,42.504341,-74.844521,
42.512516,-74.936897,42.471268,
-74.93763,42.478573,-74.964539,
42.475758,-74.984634,42.443607,
-74.986977,42.444256,-74.990219,
42.441029,-74.994293,42.439743,
-75.00061,42.442261,-75.003136,
42.44878,-75.015457,42.450249,
-75.018234,42.454163,-75.020218,
42.428963,-75.059464,42.430561,
-75.093803,42.420555,-75.125,
42.399799,-75.122406,42.397205,
-75.129311,42.393265,-75.127312,
42.391052,-75.143456,42.381321,
-75.147522,42.385586,-75.197624,
42.35825,-75.191315,42.379902,
-75.195518,42.376896,-75.209991,
42.376255,-75.217491,42.367416,
-75.227234,42.367252,-75.235962,
42.36425,-75.24781,42.367062,
-75.255043,42.364223,-75.261909,
42.366447,-75.272957,42.357029,
-75.270004,42.350895,-75.27877,
42.347168,-75.281975,42.34248,
-75.293571,42.338638,-75.298874,
42.330452,-75.305901,42.326607,
-75.306129,42.321991,-75.322983,
42.321072,-75.332047,42.318275,
-75.341751,42.314716,-75.353905,
42.318996,-75.371529,42.315685,
-75.376656,42.321392,-75.383774,
42.315159,-75.390587,42.319828,
-75.39859,42.314953,-75.40918,
42.316364,-75.415695,42.314072,
-75.4188,42.19495,-75.422142,
42.041519,-75.410416,42.029743,
-75.403549,42.012024,-75.396942,
42.006519,-75.390732,42.006733,
-75.379601,42.00211,-75.364609,
42.008083,-75.363235,42.001656,
-75.359962,41.999359,-75.341507,
41.992687,-75.337982,41.986614,
-75.342583,41.97279,-75.329704,
41.968147,-75.320427,41.960785,
-75.31855,41.954151,-75.313202,
41.950096,-75.302048,41.948296,
-75.300789,41.953785,-75.294098,
41.95451,-75.289764,41.942802,
-75.27948,41.938831,-75.276939,
41.922123,-75.267944,41.906967,
-75.268158,41.901882,-75.273163,
41.89703,-75.271675,41.887272,
-75.261009,41.883698,-75.257942,
41.877022,-75.264198,41.87067,
-75.26091,41.863712,-75.251587,
41.861954,-75.241524,41.867031,
-75.232002,41.859371,-75.224121,
41.857368,-75.215355,41.867363,
-75.204384,41.869781,-75.194771,
41.867199,-75.185638,41.859844,
-75.17952,41.869846,-75.174957,
41.872574,-75.169525,41.870205,
-75.169121,41.859173,-75.164551,
41.851501,-75.156898,41.84824,
-75.146835,41.850811,-74.78109,
42.016289,-74.554001,42.121395,
-74.531395,42.146389,-74.504387,
42.144833,-74.452118,42.169136,
-74.537712,42.201336,-74.428612,
42.348991,-74.443909,42.354935,
-74.619301,42.424313,-74.711983,
42.517723)),'Delaware','36025',
'NewYork','NY','36',1446.1914,47225,32.6547);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.497314,42.049583,-73.521851,
42.049877,-73.527504,41.977886,
-73.711357,42.005398,-73.90377,
42.078068,-73.916016,42.080814,
-73.917519,42.076385,-73.930046,
42.07869,-73.92672,42.070526,
-73.933151,42.060719,-73.937714,
42.029697,-73.933853,42.015568,
-73.953247,41.956978,-73.958466,
41.921055,-73.964828,41.913055,
-73.962639,41.900928,-73.945518,
41.881359,-73.939713,41.866768,
-73.949364,41.848545,-73.948753,
41.815647,-73.952866,41.787872,
-73.952034,41.770527,-73.941246,
41.754223,-73.941505,41.732601,
-73.947105,41.699299,-73.942902,
41.683998,-73.9478,41.6674,
-73.947304,41.6563,-73.953003,
41.625099,-73.953728,41.589886,
-73.959801,41.571468,-73.986343,
41.545528,-73.99765,41.519054,
-73.998337,41.503368,-73.995201,
41.498199,-73.999001,41.483299,
-74.000526,41.456455,-73.981987,
41.438908,-73.934189,41.48819,
-73.692848,41.512177,-73.58065,
41.526291,-73.530495,41.5271,
-73.518494,41.666737,-73.508362,
41.791496,-73.497025,41.921726,
-73.487755,42.049549,-73.497314,
42.049583)),'Dutchess','36027',
'NewYork','NY','36',801.5185,259462,323.7128);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-79.019501,43.067902,-79.007401,
43.065701,-78.999702,43.056,
-79.012001,43.0289,-79.023506,
43.0163,-79.020203,42.994701,
-79.011803,42.985199,-78.975304,
42.9687,-78.961998,42.957699,
-78.932602,42.955799,-78.919106,
42.9468,-78.909401,42.933201,
-78.905907,42.923302,-78.905998,
42.899899,-78.906075,42.899742,
-78.89447,42.887508,-78.89167,
42.876877,-78.863693,42.838276,
-78.865936,42.823174,-78.864258,
42.811985,-78.852509,42.790726,
-78.85363,42.78289,-78.862022,
42.778416,-78.865936,42.771702,
-78.91909,42.736458,-78.943703,
42.731419,-78.969429,42.72023,
-78.991814,42.705128,-79.018661,
42.701214,-79.04776,42.6917,
-79.056152,42.674358,-79.063423,
42.668762,-79.064545,42.64415,
-79.072372,42.639111,-79.078529,
42.639671,-79.093636,42.630165,
-79.112656,42.612259,-79.12384,
42.59156,-79.132233,42.589882,
-79.131676,42.58429,-79.137077,
42.569687,-79.135506,42.568672,
-79.126038,42.565033,-79.115166,
42.569984,-79.108047,42.56992,
-79.104095,42.567726,-79.104691,
42.562977,-79.095329,42.564194,
-79.091331,42.555984,-79.081955,
42.555347,-79.082443,42.552769,
-79.090385,42.550129,-79.061012,
42.537796,-79.051735,42.535904,
-79.047867,42.538574,-79.040802,
42.537186,-79.03286,42.542561,
-79.013458,42.534561,-79.005112,
42.534679,-78.992966,42.530033,
-78.986839,42.519127,-78.987976,
42.513435,-78.983894,42.511837,
-78.986206,42.504768,-78.980797,
42.505867,-78.966827,42.493675,
-78.961914,42.493629,-78.96347,
42.486629,-78.957344,42.472523,
-78.949287,42.468346,-78.938736,
42.467724,-78.933701,42.462032,
-78.919029,42.453617,-78.918266,
42.449474,-78.924377,42.446091,
-78.919441,42.442249,-78.911194,
42.448696,-78.905396,42.445972,
-78.899582,42.448009,-78.894836,
42.439499,-78.888535,42.442032,
-78.884033,42.438007,-78.877518,
42.441227,-78.870132,42.439701,
-78.867264,42.442081,-78.845505,
42.444603,-78.838066,42.443005,
-78.833588,42.448036,-78.817902,
42.453159,-78.809189,42.458988,
-78.805984,42.458214,-78.7966,
42.46233,-78.779305,42.455299,
-78.770439,42.458138,-78.778938,
42.461315,-78.775787,42.464149,
-78.77198,42.464855,-78.764114,
42.461468,-78.759285,42.463093,
-78.758362,42.465401,-78.764351,
42.469975,-78.751869,42.468208,
-78.749428,42.473652,-78.739632,
42.473606,-78.738182,42.48045,
-78.731644,42.47876,-78.72892,
42.482166,-78.719193,42.483498,
-78.71579,42.486423,-78.712639,
42.483383,-78.703011,42.486427,
-78.70034,42.474216,-78.693954,
42.471748,-78.692406,42.476185,
-78.686943,42.475494,-78.683426,
42.477486,-78.681221,42.484207,
-78.675636,42.484093,-78.672859,
42.487705,-78.665718,42.487907,
-78.661636,42.492344,-78.651291,
42.490192,-78.643188,42.492176,
-78.638931,42.497295,-78.626877,
42.498116,-78.621704,42.504337,
-78.619385,42.501938,-78.614693,
42.506058,-78.608414,42.504414,
-78.599831,42.511524,-78.59446,
42.510429,-78.591583,42.512051,
-78.590279,42.509651,-78.586609,
42.509655,-78.585709,42.513588,
-78.580521,42.51416,-78.577705,
42.511097,-78.572609,42.512424,
-78.569489,42.510319,-78.565742,
42.512444,-78.563118,42.510185,
-78.560867,42.512856,-78.554932,
42.512562,-78.552887,42.515488,
-78.546585,42.517384,-78.538864,
42.513885,-78.534805,42.519711,
-78.527115,42.52129,-78.519547,
42.519272,-78.512123,42.527363,
-78.499603,42.52766,-78.490944,
42.530499,-78.488731,42.534615,
-78.477196,42.532787,-78.469093,
42.535011,-78.467087,42.533203,
-78.464203,42.536133,-78.463486,
42.780399,-78.488403,42.780602,
-78.486511,42.867672,-78.464653,
42.867401,-78.464706,43.0882,
-78.468002,43.087601,-78.465202,
43.085999,-78.472504,43.0816,-78.472,
43.0839,-78.474602,43.082901,
-78.476906,43.086102,-78.481705,
43.0839,-78.484703,43.086102,
-78.489197,43.082699,-78.492798,
43.084301,-78.492706,43.081799,
-78.497704,43.081902,-78.500397,
43.085701,-78.497803,43.086899,
-78.503105,43.086899,-78.501198,
43.089001,-78.506302,43.089802,
-78.504402,43.093601,-78.508904,
43.0933,-78.510307,43.0979,
-78.515198,43.094799,-78.514305,
43.090801,-78.522202,43.089901,
-78.522705,43.0881,-78.528107,
43.088001,-78.527603,43.0905,
-78.5364,43.085602,-78.540504,
43.085899,-78.540802,43.090199,
-78.546906,43.09,-78.547203,43.0928,
-78.541504,43.093498,-78.545998,
43.098701,-78.5504,43.0965,
-78.550003,43.0938,-78.561104,
43.090199,-78.555107,43.0952,
-78.560303,43.097401,-78.564201,
43.0947,-78.565399,43.088501,
-78.576599,43.088699,-78.5728,
43.081902,-78.576202,43.0798,
-78.578598,43.087898,-78.582001,
43.088902,-78.585197,43.084301,
-78.580597,43.0802,-78.584702,
43.076599,-78.582901,43.0755,
-78.586998,43.073101,-78.591202,
43.076302,-78.594002,43.069599,
-78.595398,43.072498,-78.607201,
43.073002,-78.601799,43.076401,
-78.606796,43.0756,-78.612602,
43.077801,-78.6166,43.074699,
-78.617599,43.0779,-78.613106,
43.083801,-78.619797,43.087502,
-78.626907,43.0849,-78.632904,43.091,
-78.630501,43.0938,-78.6362,
43.093201,-78.6418,43.097198,
-78.6408,43.089802,-78.642403,
43.0882,-78.647102,43.0895,
-78.649101,43.0868,-78.646507,
43.0807,-78.664307,43.086201,
-78.679901,43.084202,-78.683105,
43.080002,-78.691307,43.088402,
-78.696907,43.085999,-78.707199,
43.0868,-78.709106,43.082699,
-78.715103,43.083199,-78.718307,
43.081001,-78.7276,43.086102,-78.736,
43.082199,-78.741501,43.074799,
-78.741203,43.068199,-78.757904,
43.070801,-78.770706,43.069401,
-78.778305,43.0653,-78.800507,
43.066101,-78.806801,43.062199,
-78.804504,43.055401,-78.807304,
43.053398,-78.829399,43.0513,
-78.832504,43.047699,-78.8256,
43.0336,-78.833603,43.024101,
-78.842003,43.018799,-78.851501,
43.019199,-78.861305,43.0228,
-78.876503,43.0215,-78.882202,
43.024101,-78.890404,43.0219,
-78.896507,43.044102,-78.911797,
43.054699,-78.945503,43.066898,
-79.009903,43.0695,-79.019501,
43.067902)),'Erie','36029',
'NewYork','NY','36',1044.4843,968532,927.2817);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.910095,44.429653,-74.141823,
44.407215,-74.093895,44.137562,
-74.282265,44.120491,-74.256401,
43.969734,-74.337227,43.925159,
-74.214088,43.81076,-74.201347,
43.820683,-74.149513,43.829319,
-74.139877,43.82637,-74.139091,
43.817657,-74.133545,43.817329,
-74.118881,43.809425,-74.092094,
43.804268,-74.086067,43.8088,
-74.069984,43.801594,-74.047478,
43.79628,-74.051666,43.788177,
-74.046562,43.781143,-74.055153,
43.768166,-74.057426,43.74445,
-73.438637,43.803623,-73.379723,
43.808331,-73.393188,43.822136,
-73.388824,43.832344,-73.373993,
43.842739,-73.373329,43.846828,
-73.382477,43.854946,-73.374657,
43.876171,-73.383926,43.890892,
-73.396309,43.902988,-73.408173,
43.929829,-73.407257,43.967258,
-73.413048,43.979923,-73.40641,
44.011429,-73.407784,44.020226,
-73.412865,44.028252,-73.423065,
44.032379,-73.438179,44.044952,
-73.429672,44.079361,-73.415451,
44.101189,-73.414078,44.107616,
-73.411743,44.112633,-73.416191,
44.132771,-73.403694,44.144245,
-73.401413,44.15221,-73.395958,
44.166073,-73.397324,44.173794,
-73.390091,44.181194,-73.391014,
44.190838,-73.384415,44.193108,
-73.382683,44.197128,-73.362442,
44.208492,-73.362251,44.213268,
-73.355705,44.219505,-73.350319,
44.230305,-73.342743,44.234482,
-73.343666,44.237995,-73.330925,
44.244205,-73.32402,44.243843,
-73.313828,44.264019,-73.311455,
44.274189,-73.324654,44.309971,
-73.324425,44.333794,-73.327385,
44.343319,-73.335068,44.356827,
-73.334,44.372238,-73.315445,
44.388466,-73.294159,44.438114,
-73.300545,44.454662,-73.299576,
44.47287,-73.307137,44.500286,
-73.321266,44.513584,-73.321632,
44.520275,-73.322899,44.525875,
-73.32988,44.529156,-73.332024,
44.535877,-73.339226,44.542881,
-73.339058,44.546795,-73.464264,
44.537636,-73.465218,44.533615,
-73.461311,44.529591,-73.463737,
44.525135,-73.459839,44.523125,
-73.460075,44.52,-73.465668,
44.518906,-73.471207,44.514431,
-73.471252,44.507774,-73.479408,
44.506626,-73.483582,44.501213,
-73.490791,44.497868,-73.497025,
44.486031,-73.501144,44.488293,
-73.516876,44.488022,-73.524315,
44.492607,-73.527328,44.48798,
-73.555611,44.482204,-73.562416,
44.470963,-73.573517,44.464516,
-73.581383,44.464443,-73.591118,
44.461052,-73.59684,44.462624,
-73.602768,44.45808,-73.613678,
44.45446,-73.629379,44.458233,
-73.639374,44.452507,-73.654678,
44.448471,-73.658752,44.44384,
-73.669693,44.441307,-73.686417,
44.440468,-73.695938,44.442383,
-73.700714,44.440403,-73.701134,
44.445522,-73.910095,44.429653)),
'Essex','36031','NewYork','NY','36',1796.6494,37152,20.6784);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.726601,44.994812,-74.72068,
44.952961,-74.642242,44.952576,
-74.609299,44.713451,-74.52607,
44.170574,-74.544868,44.169357,
-74.535545,44.099194,-74.282265,
44.120491,-74.093895,44.137562,
-74.141823,44.407215,-73.910095,
44.429653,-73.933334,44.576153,
-73.946312,44.574825,-73.96656,
44.709076,-73.986794,44.707733,
-74.007095,44.836895,-74.008171,
44.895275,-74.027786,44.99564,
-74.15062,44.99131,-74.335541,
44.991863,-74.457222,44.996964,
-74.457886,44.99699,-74.66185,
44.99955,-74.670677,45.006157,
-74.673416,45.000896,-74.678368,
45.000328,-74.678802,45,-74.680061,
45.000134,-74.684341,44.999645,
-74.694557,45.001701,-74.694916,
45.00174,-74.722946,44.998005,
-74.726601,44.994812)),'Franklin',
'36033','NewYork','NY','36',1631.33,46540,28.5288);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.71302,43.286076,-74.695557,
43.175533,-74.702003,43.171619,
-74.709656,43.172192,-74.718559,
43.164734,-74.718613,43.159927,
-74.710274,43.155609,-74.712059,
43.152908,-74.70874,43.149616,
-74.736191,43.143547,-74.728653,
43.126167,-74.729874,43.123329,
-74.737587,43.124634,-74.739952,
43.12051,-74.7481,43.121857,
-74.758888,43.119595,-74.758926,
43.114017,-74.770447,43.113197,
-74.768013,43.110107,-74.770325,
43.10128,-74.766228,43.090065,
-74.774147,43.083305,-74.774605,
43.078403,-74.770569,43.074833,
-74.770233,43.06559,-74.762901,
43.059853,-74.764252,43.054867,
-74.760361,43.047363,-74.542656,
42.985344,-74.097893,42.982861,
-74.140572,43.253906,-74.22464,
43.248096,-74.221329,43.221333,
-74.322792,43.214611,-74.326797,
43.241566,-74.535072,43.228043,
-74.713409,43.288937,-74.71302,
43.286076)),'Fulton','36035',
'NewYork','NY','36',496.09,54191,109.2361);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-78.465759,43.128559,-78.464706,
43.0882,-78.464653,42.867401,
-78.074402,42.870213,-78.074425,
42.863682,-77.995628,42.864933,
-77.995529,42.863121,-77.955246,
42.862484,-77.955803,42.9058,
-77.935501,42.905201,-77.934502,
42.945518,-77.911682,42.945004,
-77.910103,42.987701,-77.904388,
43.036995,-77.951309,43.039482,
-77.906197,43.133499,-77.997551,
43.132919,-78.411133,43.130585,
-78.465759,43.128559)),'Genesee',
'36037','NewYork','NY','36',494.048,60060,121.567);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.254723,42.408127,-74.245102,
42.377079,-74.247437,42.37907,
-74.259598,42.379036,-74.277054,
42.36327,-74.290939,42.361202,
-74.299881,42.362492,-74.312988,
42.35701,-74.321373,42.36058,
-74.331017,42.35704,-74.341377,
42.358395,-74.346497,42.35561,
-74.357582,42.364574,-74.376595,
42.370575,-74.379463,42.373791,
-74.443909,42.354935,-74.428612,
42.348991,-74.537712,42.201336,
-74.452118,42.169136,-74.307983,
42.114258,-74.2314,42.108353,
-74.075218,42.0965,-74.042816,
42.1703,-74.025299,42.162045,
-74.00399,42.163277,-74.002869,
42.176903,-73.918785,42.128826,
-73.911095,42.127205,-73.894264,
42.156834,-73.891975,42.168453,
-73.875183,42.173828,-73.855682,
42.191326,-73.849907,42.209553,
-73.851715,42.220524,-73.848244,
42.230259,-73.833031,42.243973,
-73.803421,42.253567,-73.787262,
42.272919,-73.780983,42.305603,
-73.784721,42.32,-73.783386,
42.330276,-73.793686,42.356106,
-73.790955,42.363144,-73.794762,
42.377106,-73.776245,42.429855,
-73.774101,42.443958,-73.778938,
42.458813,-73.776062,42.460857,
-73.784149,42.464153,-73.818054,
42.461334,-73.933685,42.444733,
-74.254723,42.408127)),'Greene',
'36039','NewYork','NY','36',647.7387,44739,69.0694);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.535545,44.099194,-74.854546,
44.070026,-74.776016,43.48661,
-74.868111,43.33976,-74.71302,
43.286076,-74.713409,43.288937,
-74.535072,43.228043,-74.326797,
43.241566,-74.322792,43.214611,
-74.221329,43.221333,-74.22464,
43.248096,-74.140572,43.253906,
-74.160522,43.371464,-74.215042,
43.728642,-74.057426,43.74445,
-74.055153,43.768166,-74.046562,
43.781143,-74.051666,43.788177,
-74.047478,43.79628,-74.069984,
43.801594,-74.086067,43.8088,
-74.092094,43.804268,-74.118881,
43.809425,-74.133545,43.817329,
-74.139091,43.817657,-74.139877,
43.82637,-74.149513,43.829319,
-74.201347,43.820683,-74.214088,
43.81076,-74.337227,43.925159,
-74.256401,43.969734,-74.282265,
44.120491,-74.535545,44.099194)),
'Hamilton','36041','NewYork','NY','36',1720.3935,5279,3.0684);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-75.170517,44.096897,-75.110542,
43.615162,-75.076973,43.330635,
-75.09214,43.328545,-75.093323,
43.323078,-75.100235,43.325108,
-75.107948,43.311584,-75.119598,
43.31044,-75.120689,43.304096,
-75.125443,43.307091,-75.148384,
43.305092,-75.146103,43.298695,
-75.148193,43.290543,-75.153008,
43.285648,-75.154053,43.279083,
-75.15889,43.273167,-75.159058,
43.26413,-75.162956,43.260025,
-75.160744,43.255737,-75.153175,
43.258259,-75.151367,43.246838,
-75.148643,43.247276,-75.148949,
43.250469,-75.144157,43.254917,
-75.136734,43.248737,-75.125,
43.24712,-75.123077,43.240978,
-75.094475,43.230976,-75.084328,
43.230469,-75.071892,43.234413,
-75.070351,43.232883,-75.074181,
43.229435,-75.069557,43.227264,
-75.161301,43.1147,-75.219505,
43.052399,-75.202042,42.880581,
-75.212555,42.879906,-75.211029,
42.85648,-75.140121,42.859695,
-75.101402,42.908291,-74.983543,
42.859333,-74.907143,42.824871,
-74.892693,42.83305,-74.879227,
42.898205,-74.76371,42.863163,
-74.740501,42.998241,-74.744202,
42.999187,-74.740639,43.014572,
-74.743889,43.029385,-74.748398,
43.036045,-74.759674,43.042183,
-74.760361,43.047363,-74.764252,
43.054867,-74.762901,43.059853,
-74.770233,43.06559,-74.770569,
43.074833,-74.774605,43.078403,
-74.774147,43.083305,-74.766228,
43.090065,-74.770325,43.10128,
-74.768013,43.110107,-74.770447,
43.113197,-74.758926,43.114017,
-74.758888,43.119595,-74.7481,
43.121857,-74.739952,43.12051,
-74.737587,43.124634,-74.729874,
43.123329,-74.728653,43.126167,
-74.736191,43.143547,-74.70874,
43.149616,-74.712059,43.152908,
-74.710274,43.155609,-74.718613,
43.159927,-74.718559,43.164734,
-74.709656,43.172192,-74.702003,
43.171619,-74.695557,43.175533,
-74.71302,43.286076,-74.868111,
43.33976,-74.776016,43.48661,
-74.854546,44.070026,-75.063141,
44.050335,-75.170517,44.096897)),
'Herkimer','36043','NewYork','NY','36',1411.6035,65797,46.6114);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-75.860367,44.403214,-75.860779,
44.402939,-75.871819,44.394787,
-75.913246,44.368076,-75.913307,
44.368034,-75.922043,44.368835,
-75.929794,44.35955,-75.949867,
44.349079,-75.970512,44.342789,
-75.978607,44.346832,-76.00132,
44.347488,-76.045555,44.33168,
-76.097679,44.2995,-76.112267,
44.297989,-76.118462,44.294804,
-76.131218,44.296593,-76.16217,
44.280731,-76.164597,44.239559,
-76.15274,44.244701,-76.129913,
44.247871,-76.114685,44.256752,
-76.107712,44.247871,-76.108353,
44.238361,-76.119766,44.226307,
-76.15274,44.2206,-76.182549,
44.20665,-76.192696,44.207283,
-76.207916,44.202209,-76.21109,
44.193333,-76.257393,44.166061,
-76.268806,44.160351,-76.281487,
44.159718,-76.291641,44.155277,
-76.299248,44.150837,-76.311928,
44.136883,-76.322083,44.132442,
-76.336029,44.12991,-76.346817,
44.123569,-76.365211,44.111515,
-76.371552,44.100735,-76.36203,
44.094391,-76.356331,44.07917,
-76.360771,44.076,-76.360771,
44.06966,-76.346817,44.070927,
-76.33857,44.074734,-76.334763,
44.069023,-76.335403,44.063953,
-76.316368,44.058876,-76.305595,
44.058243,-76.300514,44.049995,
-76.299881,44.030972,-76.310036,
44.026531,-76.302414,44.008774,
-76.289101,44.010677,-76.277687,
44.005604,-76.268166,43.992283,
-76.280853,43.971989,-76.28212,
43.961208,-76.271347,43.961208,
-76.265633,43.965649,-76.254852,
43.965649,-76.239632,43.975796,
-76.232025,43.984039,-76.209824,
43.976429,-76.201576,43.968185,
-76.174301,43.963745,-76.169861,
43.958672,-76.157814,43.959305,
-76.130547,43.929497,-76.126747,
43.909836,-76.12928,43.894615,
-76.1464,43.887642,-76.155281,
43.890175,-76.203484,43.864807,
-76.216797,43.862267,-76.226944,
43.864807,-76.232025,43.870518,
-76.222504,43.878761,-76.22187,
43.885101,-76.228851,43.887005,
-76.253586,43.879391,-76.261192,
43.881294,-76.276413,43.874954,
-76.297974,43.855927,-76.299881,
43.838169,-76.294174,43.835632,
-76.289734,43.838169,-76.277687,
43.839439,-76.270706,43.824215,
-76.256752,43.825485,-76.233917,
43.805191,-76.223778,43.786163,
-76.208549,43.732258,-76.200462,
43.680126,-76.140343,43.676861,
-76.023087,43.668083,-76.025452,
43.706951,-75.774918,43.688816,
-75.787117,43.788254,-75.850891,
43.791748,-75.840919,43.883911,
-75.758522,43.878719,-75.604034,
43.971294,-75.597015,43.966541,
-75.581764,43.968418,-75.577545,
43.965206,-75.543266,43.967728,
-75.550362,44.008095,-75.502197,
44.009487,-75.502373,44.036209,
-75.493721,44.046772,-75.503105,
44.051189,-75.484886,44.074108,
-75.546242,44.102913,-75.446472,
44.21759,-75.704994,44.331772,
-75.860367,44.403214)),'Jefferson',
'36045','NewYork','NY','36',1272.1054,110943,87.212);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.034866,40.686726,-74.056305,
40.651299,-74.057198,40.626801,
-74.042648,40.603928,-74.032372,
40.605164,-74.009392,40.599468,
-73.999374,40.59024,-73.999184,
40.584545,-74.000755,40.580814,
-74.009392,40.58062,-74.013321,
40.577278,-74.011742,40.57375,
-74.002518,40.570801,-73.991722,
40.56982,-73.950485,40.574532,
-73.944458,40.564663,-73.879601,
40.574299,-73.850197,40.5882,
-73.834801,40.606602,-73.833702,
40.628899,-73.848701,40.6436,
-73.855598,40.642601,-73.863907,
40.658001,-73.858101,40.659698,
-73.859001,40.662899,-73.856201,
40.663399,-73.858307,40.671398,
-73.861,40.671101,-73.862907,
40.678799,-73.866707,40.681599,
-73.869705,40.694801,-73.897102,
40.682301,-73.901802,40.691399,
-73.906403,40.693901,-73.904907,
40.6954,-73.922104,40.7089,
-73.922997,40.7159,-73.929504,
40.727402,-73.937798,40.729401,
-73.942398,40.735298,-73.952904,
40.738899,-73.962906,40.736,
-73.962105,40.724499,-73.967705,
40.716099,-73.969902,40.706699,
-73.972603,40.708801,-73.979202,
40.705101,-73.996307,40.703098,
-74.004402,40.6889,-74.019798,
40.679401,-74.034866,40.686726)),
'Kings','36047','NewYork','NY','36',70.5195,2300664,32624.4687);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-75.446472,44.21759,-75.546242,
44.102913,-75.484886,44.074108,
-75.503105,44.051189,-75.493721,
44.046772,-75.502373,44.036209,
-75.502197,44.009487,-75.550362,
44.008095,-75.543266,43.967728,
-75.577545,43.965206,-75.581764,
43.968418,-75.597015,43.966541,
-75.604034,43.971294,-75.758522,
43.878719,-75.840919,43.883911,
-75.850891,43.791748,-75.787117,
43.788254,-75.774918,43.688816,
-75.767143,43.625,-75.756554,
43.47031,-75.533882,43.419689,
-75.110542,43.615162,-75.170517,
44.096897,-75.446472,44.21759)),
'Lewis','36049','NewYork','NY','36',1275.3564,26796,21.0105);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-77.910103,42.987701,-77.911682,
42.945004,-77.934502,42.945518,
-77.935501,42.905201,-77.955803,
42.9058,-77.955246,42.862484,
-77.956596,42.66782,-77.962952,
42.661732,-77.969307,42.66198,
-77.974411,42.654503,-77.972145,
42.647213,-77.97673,42.645039,
-77.977379,42.638802,-77.983299,
42.633949,-77.983681,42.630043,
-77.988297,42.6278,-77.987579,
42.619308,-77.990051,42.615192,
-77.996765,42.616032,-78.005554,
42.610264,-78.012726,42.61105,
-78.017967,42.607094,-78.029228,
42.603745,-78.027138,42.598167,
-78.022156,42.596096,-78.015373,
42.599422,-78.006561,42.598778,
-78.00428,42.595325,-78.009018,
42.589249,-78.022507,42.584866,
-78.036858,42.587475,-78.050903,
42.576416,-78.04686,42.570194,
-78.034447,42.573463,-78.02858,
42.567909,-78.036064,42.566879,
-78.048279,42.557919,-78.052208,
42.548252,-78.049423,42.543865,
-78.061172,42.535797,-78.059906,
42.532253,-78.0494,42.538692,
-78.042831,42.535088,-78.041756,
42.532948,-78.048309,42.52684,
-78.041855,42.529148,-78.038994,
42.520901,-78.040794,42.518398,
-77.840973,42.517704,-77.840515,
42.47451,-77.723251,42.471149,
-77.720901,42.535,-77.661598,42.535,
-77.66021,42.580257,-77.490295,
42.577202,-77.48716,42.670212,
-77.599106,42.671902,-77.612167,
42.761135,-77.611954,42.763103,
-77.588501,42.762901,-77.58828,
42.853947,-77.552467,42.854,
-77.554733,42.863293,-77.551407,
42.863934,-77.551125,42.86702,
-77.549728,42.864159,-77.546806,
42.866264,-77.547798,42.869537,
-77.552872,42.869259,-77.548241,
42.874222,-77.55439,42.874359,
-77.54969,42.879177,-77.554634,
42.885735,-77.553543,42.889717,
-77.556808,42.889896,-77.553047,
42.892387,-77.557518,42.894859,
-77.554665,42.897758,-77.56073,
42.900166,-77.558556,42.907249,
-77.562065,42.915043,-77.559975,
42.917698,-77.563187,42.917469,
-77.563583,42.919708,-77.560791,
42.921856,-77.567223,42.928673,
-77.567169,42.935577,-77.573479,
42.935528,-77.580803,42.943901,
-77.635307,42.944401,-77.637802,
42.939899,-77.759003,42.940399,
-77.758904,42.9445,-77.7425,
42.944698,-77.738701,42.947601,
-77.732803,42.945,-77.731407,
42.947067,-77.734573,42.954578,
-77.728798,42.9529,-77.725304,
42.959301,-77.72422,42.972076,
-77.718559,42.973129,-77.721504,
42.979698,-77.732903,42.9818,
-77.731003,42.9883,-77.910103,
42.987701)),'Livingston','36051',
'NewYork','NY','36',632.0639,62372,98.6798);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-75.993752,43.183311,-75.989967,
43.179157,-75.992332,43.172867,
-75.989746,43.171406,-75.981873,
43.17271,-75.979713,43.170036,
-75.981369,43.167637,-75.974747,
43.163109,-75.977707,43.158531,
-75.971703,43.154694,-75.972229,
43.143738,-75.977501,43.140099,
-75.97747,43.135983,-75.972382,
43.140327,-75.967758,43.134888,
-75.96064,43.132763,-75.957832,
43.136101,-75.955643,43.133862,
-75.950523,43.134937,-75.953735,
43.133289,-75.95108,43.131596,
-75.956612,43.126884,-75.958885,
43.12796,-75.961166,43.123184,
-75.958527,43.123074,-75.959854,
43.119503,-75.956573,43.119938,
-75.958145,43.117634,-75.955276,
43.116673,-75.960495,43.11533,
-75.96582,43.119583,-75.969276,
43.110832,-75.974258,43.108128,
-75.970924,43.107601,-75.97699,
43.102978,-75.9758,43.090801,
-75.971504,43.092499,-75.971603,
43.089001,-75.968307,43.0877,
-75.968704,43.089901,-75.963905,
43.087002,-75.961105,43.0886,
-75.961998,43.085701,-75.954269,
43.088799,-75.951599,43.087399,
-75.950996,43.0896,-75.948906,
43.0868,-75.947502,43.089001,
-75.938599,43.0868,-75.938202,
43.0891,-75.934799,43.087101,
-75.931488,43.090176,-75.928658,
43.08728,-75.927231,43.090511,
-75.920174,43.089855,-75.917618,
43.086033,-75.896439,42.790897,
-75.89019,42.723778,-75.429047,
42.745354,-75.428368,42.738041,
-75.29599,42.744061,-75.291023,
42.751259,-75.285278,42.750641,
-75.280685,42.754208,-75.279716,
42.764297,-75.274437,42.765301,
-75.273354,42.77269,-75.266243,
42.774811,-75.264252,42.777622,
-75.263252,42.775658,-75.259277,
42.777004,-75.259315,42.780872,
-75.256111,42.780891,-75.257881,
42.782539,-75.251663,42.784706,
-75.253311,42.787247,-75.250366,
42.792095,-75.253395,42.795692,
-75.250687,42.797268,-75.249321,
42.811657,-75.242279,42.817604,
-75.246559,42.816711,-75.250351,
42.825153,-75.240303,42.834465,
-75.243317,42.838966,-75.242424,
42.843109,-75.247803,42.845051,
-75.244339,42.861683,-75.245148,
42.86422,-75.247726,42.864174,
-75.244965,42.868134,-75.24839,
42.871449,-75.437553,42.863251,
-75.444557,42.933022,-75.544594,
42.931702,-75.553154,43.037487,
-75.597481,43.035316,-75.598518,
43.043232,-75.608093,43.052971,
-75.599991,43.061527,-75.603325,
43.061665,-75.60495,43.064728,
-75.616035,43.06612,-75.616158,
43.069138,-75.619278,43.068909,
-75.622589,43.073776,-75.627876,
43.073757,-75.632591,43.076523,
-75.636581,43.074879,-75.641762,
43.081127,-75.639381,43.082542,
-75.641991,43.094906,-75.639771,
43.095554,-75.646347,43.100903,
-75.64502,43.104801,-75.649521,
43.10667,-75.65155,43.10537,
-75.655571,43.109013,-75.653481,
43.114044,-75.669617,43.115032,
-75.674171,43.117962,-75.673264,
43.121368,-75.681381,43.121048,
-75.680504,43.122898,-75.685501,
43.12439,-75.678978,43.127365,
-75.687157,43.129288,-75.688377,
43.13361,-75.693939,43.133198,
-75.696869,43.136494,-75.695335,
43.13953,-75.701797,43.136604,
-75.707047,43.137177,-75.707085,
43.150967,-75.716301,43.150551,
-75.714714,43.152637,-75.722588,
43.155449,-75.719429,43.159657,
-75.724304,43.162788,-75.72567,
43.157276,-75.727959,43.162102,
-75.731895,43.160679,-75.739204,
43.164749,-75.75,43.158382,
-75.777031,43.173538,-75.77935,
43.168282,-75.787033,43.16684,
-75.794228,43.160252,-75.840996,
43.160641,-75.853363,43.156723,
-75.858856,43.149403,-75.864189,
43.147251,-75.871506,43.14798,
-75.875,43.152004,-75.884605,
43.155537,-75.925407,43.161831,
-75.928627,43.163937,-75.928688,
43.169403,-75.933372,43.176632,
-75.953033,43.17107,-75.959282,
43.175144,-75.958969,43.180859,
-75.980064,43.177608,-75.98732,
43.183868,-75.992699,43.185173,
-75.993752,43.183311)),'Madison',
'36053','NewYork','NY','36',655.7602,69120,105.4042);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-77.99601,43.36533,-77.997551,
43.132919,-77.906197,43.133499,
-77.951309,43.039482,-77.904388,
43.036995,-77.910103,42.987701,
-77.731003,42.9883,-77.732903,
42.9818,-77.721504,42.979698,
-77.718559,42.973129,-77.72422,
42.972076,-77.725304,42.959301,
-77.728798,42.9529,-77.734573,
42.954578,-77.731407,42.947067,
-77.732803,42.945,-77.738701,
42.947601,-77.7425,42.944698,
-77.758904,42.9445,-77.759003,
42.940399,-77.637802,42.939899,
-77.635307,42.944401,-77.580803,
42.943901,-77.482803,42.9431,
-77.485703,43.0345,-77.371552,
43.034599,-77.375,43.276699,-77.375,
43.276779,-77.423943,43.270039,
-77.445541,43.261246,-77.46714,
43.257244,-77.486343,43.250843,
-77.501534,43.250046,-77.531937,
43.234844,-77.553535,43.235645,
-77.57753,43.242844,-77.629524,
43.271641,-77.655121,43.278839,
-77.702316,43.307636,-77.713516,
43.321236,-77.760712,43.339638,
-77.799911,43.338837,-77.830307,
43.342037,-77.977486,43.367634,
-77.995102,43.3652,-77.99601,
43.36533)),'Monroe','36055',
'NewYork','NY','36',659.1777,713968,1083.1181);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.760361,43.047363,-74.759674,
43.042183,-74.748398,43.036045,
-74.743889,43.029385,-74.740639,
43.014572,-74.744202,42.999187,
-74.740501,42.998241,-74.76371,
42.863163,-74.648712,42.829483,
-74.562309,42.812656,-74.45533,
42.772903,-74.32515,42.783268,
-74.289871,42.783733,-74.264114,
42.796524,-74.264938,42.799858,
-74.256279,42.805553,-74.257622,
42.811947,-74.084335,42.897415,
-74.093521,42.95562,-74.097893,
42.982861,-74.542656,42.985344,
-74.760361,43.047363)),'Montgomery',
'36057','NewYork','NY','36',404.7558,51981,128.4254);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.779999,40.812,-73.750801,
40.782902,-73.701508,40.752399,
-73.699905,40.739101,-73.707901,
40.7276,-73.7304,40.721901,
-73.726799,40.710499,-73.7258,40.68,
-73.728706,40.665699,-73.725105,
40.6521,-73.741707,40.647202,
-73.742798,40.640701,-73.739998,
40.635201,-73.7425,40.634998,
-73.742203,40.638,-73.746101,
40.634602,-73.768204,40.626301,
-73.7668,40.615101,-73.755302,
40.609798,-73.745598,40.611801,
-73.738602,40.603401,-73.737801,
40.593498,-73.744904,40.5937,
-73.756348,40.586205,-73.754761,
40.584488,-73.740303,40.585972,
-73.645821,40.582268,-73.599876,
40.587078,-73.592102,40.584862,
-73.57766,40.586712,-73.571732,
40.583748,-73.561356,40.583378,
-73.425964,40.608772,-73.426102,
40.6558,-73.423798,40.655499,
-73.423599,40.6689,-73.428505,
40.697899,-73.455803,40.842499,
-73.4645,40.859402,-73.462708,
40.8666,-73.467796,40.868,-73.476509,
40.87701,-73.477745,40.899208,
-73.490799,40.919399,-73.496902,
40.92308,-73.507652,40.918736,
-73.527718,40.916763,-73.528893,
40.914013,-73.550529,40.908508,
-73.566254,40.915588,-73.570976,
40.915588,-73.582779,40.909294,
-73.594574,40.907719,-73.605988,
40.901821,-73.631935,40.900639,
-73.649239,40.880981,-73.655144,
40.877831,-73.656319,40.86446,
-73.664978,40.85738,-73.676773,
40.856201,-73.714134,40.869572,
-73.721214,40.865639,-73.731834,
40.866032,-73.727112,40.85659,
-73.72908,40.852268,-73.73774,
40.849121,-73.743629,40.841255,
-73.757401,40.832996,-73.753464,
40.823555,-73.757004,40.817265,
-73.779999,40.812)),'Nassau','36059',
'NewYork','NY','36',286.7209,1287348,4489.8945);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.985344,40.797417,-74.014198,
40.7565,-74.026703,40.699799,
-74.034866,40.686726,-74.019798,
40.679401,-74.004402,40.6889,
-73.996307,40.703098,-73.979202,
40.705101,-73.972603,40.708801,
-73.969902,40.706699,-73.967705,
40.716099,-73.962105,40.724499,
-73.962906,40.736,-73.957397,
40.748699,-73.935707,40.770199,
-73.937401,40.7756,-73.934799,
40.7784,-73.928398,40.776798,
-73.917908,40.784199,-73.910507,
40.790699,-73.913101,40.796001,
-73.922905,40.801998,-73.927803,
40.801998,-73.932304,40.8078,
-73.933998,40.833,-73.928703,
40.845402,-73.9114,40.866402,
-73.907707,40.876099,-73.912003,
40.879101,-73.915802,40.875401,
-73.920403,40.8764,-73.933998,
40.881901,-73.953903,40.8489,
-73.9636,40.826801,-73.985344,
40.797417)),'NewYork','36061',
'NewYork','NY','36',28.3727,1487536,52428.3437);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-78.465973,43.372395,-78.494164,
43.373024,-78.536911,43.369862,
-78.636658,43.357193,-78.696823,
43.338192,-78.731667,43.338192,
-78.77916,43.325523,-78.807663,
43.32394,-78.836159,43.317608,
-78.855164,43.309692,-78.873772,
43.307335,-78.972725,43.280796,
-79.000435,43.277233,-79.070702,
43.262402,-79.056305,43.254101,
-79.053101,43.222,-79.057304,
43.210602,-79.048904,43.1996,
-79.053307,43.173599,-79.046799,
43.1623,-79.042603,43.1436,
-79.044304,43.138,-79.056999,
43.126801,-79.069801,43.120201,
-79.062202,43.115299,-79.058197,
43.106899,-79.0662,43.091,-79.0756,
43.081299,-79.074707,43.077801,
-79.019501,43.067902,-79.009903,
43.0695,-78.945503,43.066898,
-78.911797,43.054699,-78.896507,
43.044102,-78.890404,43.0219,
-78.882202,43.024101,-78.876503,
43.0215,-78.861305,43.0228,
-78.851501,43.019199,-78.842003,
43.018799,-78.833603,43.024101,
-78.8256,43.0336,-78.832504,
43.047699,-78.829399,43.0513,
-78.807304,43.053398,-78.804504,
43.055401,-78.806801,43.062199,
-78.800507,43.066101,-78.778305,
43.0653,-78.770706,43.069401,
-78.757904,43.070801,-78.741203,
43.068199,-78.741501,43.074799,
-78.736,43.082199,-78.7276,43.086102,
-78.718307,43.081001,-78.715103,
43.083199,-78.709106,43.082699,
-78.707199,43.0868,-78.696907,
43.085999,-78.691307,43.088402,
-78.683105,43.080002,-78.679901,
43.084202,-78.664307,43.086201,
-78.646507,43.0807,-78.649101,
43.0868,-78.647102,43.0895,
-78.642403,43.0882,-78.6408,
43.089802,-78.6418,43.097198,
-78.6362,43.093201,-78.630501,
43.0938,-78.632904,43.091,-78.626907,
43.0849,-78.619797,43.087502,
-78.613106,43.083801,-78.617599,
43.0779,-78.6166,43.074699,
-78.612602,43.077801,-78.606796,
43.0756,-78.601799,43.076401,
-78.607201,43.073002,-78.595398,
43.072498,-78.594002,43.069599,
-78.591202,43.076302,-78.586998,
43.073101,-78.582901,43.0755,
-78.584702,43.076599,-78.580597,
43.0802,-78.585197,43.084301,
-78.582001,43.088902,-78.578598,
43.087898,-78.576202,43.0798,
-78.5728,43.081902,-78.576599,
43.088699,-78.565399,43.088501,
-78.564201,43.0947,-78.560303,
43.097401,-78.555107,43.0952,
-78.561104,43.090199,-78.550003,
43.0938,-78.5504,43.0965,-78.545998,
43.098701,-78.541504,43.093498,
-78.547203,43.0928,-78.546906,43.09,
-78.540802,43.090199,-78.540504,
43.085899,-78.5364,43.085602,
-78.527603,43.0905,-78.528107,
43.088001,-78.522705,43.0881,
-78.522202,43.089901,-78.514305,
43.090801,-78.515198,43.094799,
-78.510307,43.0979,-78.508904,
43.0933,-78.504402,43.093601,
-78.506302,43.089802,-78.501198,
43.089001,-78.503105,43.086899,
-78.497803,43.086899,-78.500397,
43.085701,-78.497704,43.081902,
-78.492706,43.081799,-78.492798,
43.084301,-78.489197,43.082699,
-78.484703,43.086102,-78.481705,
43.0839,-78.476906,43.086102,
-78.474602,43.082901,-78.472,43.0839,
-78.472504,43.0816,-78.465202,
43.085999,-78.468002,43.087601,
-78.464706,43.0882,-78.465759,
43.128559,-78.46067,43.216164,
-78.466736,43.302753,-78.465973,
43.372395)),'Niagara','36063',
'NewYork','NY','36',522.8803,220756,422.1918);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-75.756554,43.47031,-75.814995,
43.483509,-75.887123,43.324951,
-75.863297,43.319202,-75.884605,
43.155537,-75.875,43.152004,
-75.871506,43.14798,-75.864189,
43.147251,-75.858856,43.149403,
-75.853363,43.156723,-75.840996,
43.160641,-75.794228,43.160252,
-75.787033,43.16684,-75.77935,
43.168282,-75.777031,43.173538,
-75.75,43.158382,-75.739204,
43.164749,-75.731895,43.160679,
-75.727959,43.162102,-75.72567,
43.157276,-75.724304,43.162788,
-75.719429,43.159657,-75.722588,
43.155449,-75.714714,43.152637,
-75.716301,43.150551,-75.707085,
43.150967,-75.707047,43.137177,
-75.701797,43.136604,-75.695335,
43.13953,-75.696869,43.136494,
-75.693939,43.133198,-75.688377,
43.13361,-75.687157,43.129288,
-75.678978,43.127365,-75.685501,
43.12439,-75.680504,43.122898,
-75.681381,43.121048,-75.673264,
43.121368,-75.674171,43.117962,
-75.669617,43.115032,-75.653481,
43.114044,-75.655571,43.109013,
-75.65155,43.10537,-75.649521,
43.10667,-75.64502,43.104801,
-75.646347,43.100903,-75.639771,
43.095554,-75.641991,43.094906,
-75.639381,43.082542,-75.641762,
43.081127,-75.636581,43.074879,
-75.632591,43.076523,-75.627876,
43.073757,-75.622589,43.073776,
-75.619278,43.068909,-75.616158,
43.069138,-75.616035,43.06612,
-75.60495,43.064728,-75.603325,
43.061665,-75.599991,43.061527,
-75.608093,43.052971,-75.598518,
43.043232,-75.597481,43.035316,
-75.553154,43.037487,-75.544594,
42.931702,-75.444557,42.933022,
-75.437553,42.863251,-75.24839,
42.871449,-75.243042,42.877808,
-75.212555,42.879906,-75.202042,
42.880581,-75.219505,43.052399,
-75.161301,43.1147,-75.069557,
43.227264,-75.074181,43.229435,
-75.070351,43.232883,-75.071892,
43.234413,-75.084328,43.230469,
-75.094475,43.230976,-75.123077,
43.240978,-75.125,43.24712,
-75.136734,43.248737,-75.144157,
43.254917,-75.148949,43.250469,
-75.148643,43.247276,-75.151367,
43.246838,-75.153175,43.258259,
-75.160744,43.255737,-75.162956,
43.260025,-75.159058,43.26413,
-75.15889,43.273167,-75.154053,
43.279083,-75.153008,43.285648,
-75.148193,43.290543,-75.146103,
43.298695,-75.148384,43.305092,
-75.125443,43.307091,-75.120689,
43.304096,-75.119598,43.31044,
-75.107948,43.311584,-75.100235,
43.325108,-75.093323,43.323078,
-75.09214,43.328545,-75.076973,
43.330635,-75.110542,43.615162,
-75.533882,43.419689,-75.756554,
43.47031)),'Oneida','36065',
'NewYork','NY','36',1212.5488,250836,206.8666);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-76.479568,43.227451,-76.473412,
43.14595,-76.481575,43.145821,
-76.486649,43.143154,-76.476463,
43.125,-76.472115,43.104916,
-76.491577,43.106228,-76.498169,
43.102592,-76.499664,43.097656,
-76.492279,43.004902,-76.463341,
43.006252,-76.45108,42.845722,
-76.357323,42.849384,-76.299118,
42.807392,-76.275696,42.780403,
-76.275024,42.771187,-76.080566,
42.779949,-76.080528,42.781532,
-75.896439,42.790897,-75.917618,
43.086033,-75.920174,43.089855,
-75.927231,43.090511,-75.928658,
43.08728,-75.931488,43.090176,
-75.934799,43.087101,-75.938202,
43.0891,-75.938599,43.0868,
-75.947502,43.089001,-75.948906,
43.0868,-75.950996,43.0896,
-75.951599,43.087399,-75.954269,
43.088799,-75.961998,43.085701,
-75.961105,43.0886,-75.963905,
43.087002,-75.968704,43.089901,
-75.968307,43.0877,-75.971603,
43.089001,-75.971504,43.092499,
-75.9758,43.090801,-75.97699,
43.102978,-75.970924,43.107601,
-75.974258,43.108128,-75.969276,
43.110832,-75.96582,43.119583,
-75.960495,43.11533,-75.955276,
43.116673,-75.958145,43.117634,
-75.956573,43.119938,-75.959854,
43.119503,-75.958527,43.123074,
-75.961166,43.123184,-75.958885,
43.12796,-75.956612,43.126884,
-75.95108,43.131596,-75.953735,
43.133289,-75.950523,43.134937,
-75.955643,43.133862,-75.957832,
43.136101,-75.96064,43.132763,
-75.967758,43.134888,-75.972382,
43.140327,-75.97747,43.135983,
-75.977501,43.140099,-75.972229,
43.143738,-75.971703,43.154694,
-75.977707,43.158531,-75.974747,
43.163109,-75.981369,43.167637,
-75.979713,43.170036,-75.981873,
43.17271,-75.989746,43.171406,
-75.992332,43.172867,-75.989967,
43.179157,-75.993752,43.183311,
-76.004784,43.17683,-76.003181,
43.179089,-76.008194,43.180466,
-76.011955,43.18549,-76.031937,
43.190689,-76.034897,43.195583,
-76.048912,43.202785,-76.052979,
43.202751,-76.052399,43.200768,
-76.056526,43.199104,-76.058243,
43.200768,-76.078751,43.199455,
-76.082718,43.206577,-76.079422,
43.209167,-76.076988,43.208305,
-76.085442,43.213055,-76.08139,
43.214287,-76.068611,43.212498,
-76.072365,43.214722,-76.079536,
43.215759,-76.079491,43.218449,
-76.080688,43.215714,-76.084801,
43.216801,-76.098381,43.22451,
-76.106575,43.224354,-76.1073,
43.227409,-76.116653,43.233585,
-76.131279,43.234463,-76.14019,
43.240288,-76.14888,43.239567,
-76.169403,43.246601,-76.203293,
43.271538,-76.21225,43.267063,
-76.209175,43.26358,-76.213326,
43.256603,-76.21096,43.243935,
-76.213745,43.239952,-76.20536,
43.237343,-76.202904,43.222198,
-76.194603,43.216999,-76.199104,
43.212502,-76.206528,43.216545,
-76.210999,43.210499,-76.208687,
43.20797,-76.218224,43.204704,
-76.2248,43.204899,-76.2342,
43.212299,-76.245003,43.2145,
-76.257797,43.236801,-76.264107,
43.236301,-76.267906,43.239601,
-76.273201,43.240101,-76.275902,
43.238701,-76.268105,43.2327,
-76.262398,43.218399,-76.271706,
43.203899,-76.28138,43.201023,
-76.28936,43.218433,-76.307884,
43.230721,-76.316467,43.229359,
-76.324562,43.232239,-76.344978,
43.232559,-76.479568,43.227451)),
'Onondaga','36067','NewYork','NY','36',780.1918,468973,601.0991);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-77.371552,43.034599,-77.485703,
43.0345,-77.482803,42.9431,
-77.580803,42.943901,-77.573479,
42.935528,-77.567169,42.935577,
-77.567223,42.928673,-77.560791,
42.921856,-77.563583,42.919708,
-77.563187,42.917469,-77.559975,
42.917698,-77.562065,42.915043,
-77.558556,42.907249,-77.56073,
42.900166,-77.554665,42.897758,
-77.557518,42.894859,-77.553047,
42.892387,-77.556808,42.889896,
-77.553543,42.889717,-77.554634,
42.885735,-77.54969,42.879177,
-77.55439,42.874359,-77.548241,
42.874222,-77.552872,42.869259,
-77.547798,42.869537,-77.546806,
42.866264,-77.549728,42.864159,
-77.551125,42.86702,-77.551407,
42.863934,-77.554733,42.863293,
-77.552467,42.854,-77.58828,
42.853947,-77.588501,42.762901,
-77.611954,42.763103,-77.612167,
42.761135,-77.599106,42.671902,
-77.48716,42.670212,-77.490295,
42.577202,-77.366798,42.576302,
-77.367401,42.667801,-77.357704,
42.6679,-77.354706,42.697102,
-77.346901,42.716301,-77.336998,
42.733898,-77.313301,42.7612,
-76.972755,42.764149,-76.977913,
42.773132,-76.97477,42.812717,
-76.978355,42.828884,-76.972885,
42.83707,-76.981667,42.862164,
-76.978844,42.869007,-76.963676,
42.872566,-76.964134,43.013096,
-77.133705,43.012402,-77.134514,
43.039825,-77.246902,43.0397,
-77.247101,43.034599,-77.371552,
43.034599)),'Ontario','36069',
'NewYork','NY','36',644.2983,95101,147.6038);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.367844,41.590897,-74.384697,
41.583553,-74.388382,41.583439,
-74.390785,41.58614,-74.396736,
41.576145,-74.406822,41.572285,
-74.408592,41.574707,-74.411118,
41.570843,-74.408043,41.569813,
-74.409081,41.568027,-74.418404,
41.569515,-74.4198,41.562382,
-74.423065,41.562767,-74.423149,
41.560135,-74.430038,41.558239,
-74.426476,41.556179,-74.434486,
41.553547,-74.435555,41.545975,
-74.438843,41.54705,-74.438873,
41.543022,-74.445297,41.543941,
-74.444717,41.537395,-74.451508,
41.532661,-74.455246,41.532936,
-74.457687,41.52747,-74.466118,
41.522842,-74.466415,41.5163,
-74.476097,41.510098,-74.475861,
41.504246,-74.752792,41.493652,
-74.761047,41.4907,-74.760361,
41.482342,-74.754944,41.478615,
-74.750969,41.464954,-74.760246,
41.460819,-74.759125,41.454319,
-74.762207,41.448513,-74.755951,
41.433796,-74.75161,41.432148,
-74.756111,41.428123,-74.755081,
41.424881,-74.744217,41.430546,
-74.737083,41.429134,-74.73513,
41.422607,-74.741478,41.41132,
-74.741348,41.405029,-74.734032,
41.396885,-74.716377,41.39249,
-74.708847,41.378807,-74.691521,
41.367233,-74.690163,41.361465,
-74.695305,41.35733,-74.461754,41.25,
-74.366302,41.202801,-74.234879,
41.142788,-73.981796,41.3246,
-73.96167,41.34845,-73.957214,
41.372112,-73.947716,41.394672,
-73.94976,41.398067,-73.962189,
41.402729,-73.967064,41.417332,
-73.981903,41.438812,-73.981987,
41.438908,-74.000526,41.456455,
-73.999001,41.483299,-73.995201,
41.498199,-73.998337,41.503368,
-73.99765,41.519054,-73.986343,
41.545528,-73.959801,41.571468,
-73.953728,41.589886,-74.054092,
41.580517,-74.054214,41.585972,
-74.068375,41.60574,-74.090439,
41.598461,-74.095428,41.606354,
-74.134918,41.615604,-74.126808,
41.582451,-74.185768,41.594036,
-74.187912,41.590698,-74.252007,
41.605282,-74.250595,41.62923,
-74.264679,41.632668,-74.267982,
41.628963,-74.280067,41.625538,
-74.291527,41.61861,-74.296127,
41.619183,-74.304482,41.615505,
-74.306282,41.608986,-74.313049,
41.610744,-74.319664,41.603333,
-74.330116,41.601181,-74.332161,
41.596764,-74.335327,41.597382,
-74.340874,41.59436,-74.350571,
41.598431,-74.354195,41.591885,
-74.367844,41.590897)),'Orange',
'36071','NewYork','NY','36',816.2333,307647,376.9104);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-78.465973,43.372395,-78.466736,
43.302753,-78.46067,43.216164,
-78.465759,43.128559,-78.411133,
43.130585,-77.997551,43.132919,
-77.99601,43.36533,-78.013374,
43.367813,-78.028702,43.36581,
-78.038696,43.369808,-78.064674,
43.369808,-78.101311,43.374474,
-78.153946,43.375141,-78.162598,
43.375141,-78.182587,43.369808,
-78.207901,43.371807,-78.248535,
43.368477,-78.255867,43.372475,
-78.271187,43.370476,-78.312485,
43.37381,-78.341133,43.371807,
-78.392426,43.375805,-78.439728,
43.371807,-78.465973,43.372395)),
'Orleans','36073','NewYork','NY','36',391.3581,41846,106.9249);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-76.200462,43.680126,-76.196053,
43.651634,-76.203278,43.575363,
-76.219086,43.544205,-76.230713,
43.531185,-76.246529,43.52607,
-76.27861,43.520489,-76.293022,
43.513512,-76.316277,43.514908,
-76.331627,43.511189,-76.334877,
43.514442,-76.346039,43.513512,
-76.353477,43.515839,-76.367897,
43.525139,-76.403236,43.524208,
-76.419975,43.520489,-76.472527,
43.493984,-76.486481,43.47538,
-76.565536,43.448406,-76.596222,
43.42981,-76.599945,43.424229,
-76.607849,43.423763,-76.617104,
43.417351,-76.616577,43.411942,
-76.605347,43.253506,-76.481491,
43.256573,-76.479568,43.227451,
-76.344978,43.232559,-76.324562,
43.232239,-76.316467,43.229359,
-76.307884,43.230721,-76.28936,
43.218433,-76.28138,43.201023,
-76.271706,43.203899,-76.262398,
43.218399,-76.268105,43.2327,
-76.275902,43.238701,-76.273201,
43.240101,-76.267906,43.239601,
-76.264107,43.236301,-76.257797,
43.236801,-76.245003,43.2145,
-76.2342,43.212299,-76.2248,
43.204899,-76.218224,43.204704,
-76.208687,43.20797,-76.210999,
43.210499,-76.206528,43.216545,
-76.199104,43.212502,-76.194603,
43.216999,-76.202904,43.222198,
-76.20536,43.237343,-76.213745,
43.239952,-76.21096,43.243935,
-76.213326,43.256603,-76.209175,
43.26358,-76.21225,43.267063,
-76.203293,43.271538,-76.169403,
43.246601,-76.14888,43.239567,
-76.14019,43.240288,-76.131279,
43.234463,-76.116653,43.233585,
-76.1073,43.227409,-76.106575,
43.224354,-76.098381,43.22451,
-76.084801,43.216801,-76.080688,
43.215714,-76.079491,43.218449,
-76.079536,43.215759,-76.072365,
43.214722,-76.068611,43.212498,
-76.08139,43.214287,-76.085442,
43.213055,-76.076988,43.208305,
-76.079422,43.209167,-76.082718,
43.206577,-76.078751,43.199455,
-76.058243,43.200768,-76.056526,
43.199104,-76.052399,43.200768,
-76.052979,43.202751,-76.048912,
43.202785,-76.034897,43.195583,
-76.031937,43.190689,-76.011955,
43.18549,-76.008194,43.180466,
-76.003181,43.179089,-76.004784,
43.17683,-75.993752,43.183311,
-75.992699,43.185173,-75.98732,
43.183868,-75.980064,43.177608,
-75.958969,43.180859,-75.959282,
43.175144,-75.953033,43.17107,
-75.933372,43.176632,-75.928688,
43.169403,-75.928627,43.163937,
-75.925407,43.161831,-75.884605,
43.155537,-75.863297,43.319202,
-75.887123,43.324951,-75.814995,
43.483509,-75.756554,43.47031,
-75.767143,43.625,-75.774918,
43.688816,-76.025452,43.706951,
-76.023087,43.668083,-76.140343,
43.676861,-76.200462,43.680126)),
'Oswego','36075','NewYork','NY','36',953.1655,121771,127.7542);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-75.24839,42.871449,-75.244965,
42.868134,-75.247726,42.864174,
-75.245148,42.86422,-75.244339,
42.861683,-75.247803,42.845051,
-75.242424,42.843109,-75.243317,
42.838966,-75.240303,42.834465,
-75.250351,42.825153,-75.246559,
42.816711,-75.242279,42.817604,
-75.249321,42.811657,-75.250687,
42.797268,-75.253395,42.795692,
-75.250366,42.792095,-75.253311,
42.787247,-75.251663,42.784706,
-75.257881,42.782539,-75.256111,
42.780891,-75.259315,42.780872,
-75.259277,42.777004,-75.263252,
42.775658,-75.264252,42.777622,
-75.266243,42.774811,-75.273354,
42.77269,-75.274437,42.765301,
-75.279716,42.764297,-75.280685,
42.754208,-75.285278,42.750641,
-75.291023,42.751259,-75.29599,
42.744061,-75.293327,42.737865,
-75.300682,42.729263,-75.296303,
42.727959,-75.297081,42.718647,
-75.29985,42.717896,-75.307198,
42.705498,-75.316132,42.685345,
-75.32785,42.679852,-75.327469,
42.674751,-75.330666,42.674362,
-75.328117,42.672604,-75.331528,
42.668324,-75.3283,42.663864,
-75.331284,42.661415,-75.328209,
42.648289,-75.323441,42.644032,
-75.323624,42.634449,-75.330185,
42.630787,-75.323563,42.622723,
-75.33725,42.613319,-75.339096,
42.606319,-75.335999,42.593441,
-75.325043,42.590263,-75.329964,
42.581505,-75.327202,42.578049,
-75.331841,42.573589,-75.331314,
42.567322,-75.339661,42.560913,
-75.347992,42.560089,-75.354141,
42.55407,-75.356743,42.556061,
-75.361664,42.55217,-75.365112,
42.554535,-75.36834,42.551975,
-75.373032,42.536514,-75.378174,
42.535534,-75.382599,42.528751,
-75.387161,42.523552,-75.384315,
42.520187,-75.390076,42.510586,
-75.401451,42.51125,-75.403618,
42.509125,-75.400368,42.508434,
-75.400154,42.505871,-75.396507,
42.506695,-75.399261,42.497696,
-75.395721,42.48756,-75.399521,
42.483238,-75.403877,42.482414,
-75.404808,42.478645,-75.401253,
42.474205,-75.400124,42.461693,
-75.395088,42.459194,-75.387062,
42.445812,-75.38427,42.429066,
-75.377014,42.423801,-75.379677,
42.41671,-75.375542,42.416019,
-75.375336,42.410347,-75.380951,
42.407516,-75.38179,42.403282,
-75.393921,42.400543,-75.395065,
42.395782,-75.404976,42.385105,
-75.40696,42.379135,-75.403038,
42.375748,-75.40403,42.366089,
-75.400085,42.360367,-75.393486,
42.357506,-75.395035,42.353134,
-75.403023,42.348495,-75.398529,
42.337467,-75.405342,42.332115,
-75.410896,42.325485,-75.407997,
42.319698,-75.414719,42.320293,
-75.415695,42.314072,-75.40918,
42.316364,-75.39859,42.314953,
-75.390587,42.319828,-75.383774,
42.315159,-75.376656,42.321392,
-75.371529,42.315685,-75.353905,
42.318996,-75.341751,42.314716,
-75.332047,42.318275,-75.322983,
42.321072,-75.306129,42.321991,
-75.305901,42.326607,-75.298874,
42.330452,-75.293571,42.338638,
-75.281975,42.34248,-75.27877,
42.347168,-75.270004,42.350895,
-75.272957,42.357029,-75.261909,
42.366447,-75.255043,42.364223,
-75.24781,42.367062,-75.235962,
42.36425,-75.227234,42.367252,
-75.217491,42.367416,-75.209991,
42.376255,-75.195518,42.376896,
-75.191315,42.379902,-75.197624,
42.35825,-75.147522,42.385586,
-75.143456,42.381321,-75.127312,
42.391052,-75.129311,42.393265,
-75.122406,42.397205,-75.125,
42.399799,-75.093803,42.420555,
-75.059464,42.430561,-75.020218,
42.428963,-75.018234,42.454163,
-75.015457,42.450249,-75.003136,
42.44878,-75.00061,42.442261,
-74.994293,42.439743,-74.990219,
42.441029,-74.986977,42.444256,
-74.984634,42.443607,-74.964539,
42.475758,-74.93763,42.478573,
-74.936897,42.471268,-74.844521,
42.512516,-74.771851,42.504341,
-74.752457,42.514187,-74.743347,
42.515907,-74.734131,42.513809,
-74.728653,42.517651,-74.716843,
42.515942,-74.711983,42.517723,
-74.672211,42.565071,-74.631042,
42.626598,-74.636177,42.651909,
-74.667931,42.750637,-74.665802,
42.791801,-74.648712,42.829483,
-74.76371,42.863163,-74.879227,
42.898205,-74.892693,42.83305,
-74.907143,42.824871,-74.983543,
42.859333,-75.101402,42.908291,
-75.140121,42.859695,-75.211029,
42.85648,-75.212555,42.879906,
-75.243042,42.877808,-75.24839,
42.871449)),'Otsego','36077',
'NewYork','NY','36',1002.7568,60517,60.3505);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.981987,41.438908,-73.981903,
41.438812,-73.967064,41.417332,
-73.962189,41.402729,-73.94976,
41.398067,-73.947716,41.394672,
-73.957214,41.372112,-73.96167,
41.34845,-73.981796,41.3246,
-73.983002,41.321602,-73.545158,
41.36628,-73.543854,41.37653,
-73.537399,41.441002,-73.53112,
41.520153,-73.530495,41.5271,
-73.58065,41.526291,-73.692848,
41.512177,-73.934189,41.48819,
-73.981987,41.438908)),'Putnam',
'36079','NewYork','NY','36',231.5,83941,362.5959);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.913101,40.796001,-73.910507,
40.790699,-73.917908,40.784199,
-73.928398,40.776798,-73.934799,
40.7784,-73.937401,40.7756,
-73.935707,40.770199,-73.957397,
40.748699,-73.962906,40.736,
-73.952904,40.738899,-73.942398,
40.735298,-73.937798,40.729401,
-73.929504,40.727402,-73.922997,
40.7159,-73.922104,40.7089,
-73.904907,40.6954,-73.906403,
40.693901,-73.901802,40.691399,
-73.897102,40.682301,-73.869705,
40.694801,-73.866707,40.681599,
-73.862907,40.678799,-73.861,
40.671101,-73.858307,40.671398,
-73.856201,40.663399,-73.859001,
40.662899,-73.858101,40.659698,
-73.863907,40.658001,-73.855598,
40.642601,-73.848701,40.6436,
-73.833702,40.628899,-73.834801,
40.606602,-73.850197,40.5882,
-73.879601,40.574299,-73.944458,
40.564663,-73.93914,40.555962,
-73.940231,40.543407,-73.922768,
40.551048,-73.863281,40.565784,
-73.828896,40.57888,-73.772682,
40.590889,-73.760674,40.590889,
-73.756348,40.586205,-73.744904,
40.5937,-73.737801,40.593498,
-73.738602,40.603401,-73.745598,
40.611801,-73.755302,40.609798,
-73.7668,40.615101,-73.768204,
40.626301,-73.746101,40.634602,
-73.742203,40.638,-73.7425,40.634998,
-73.739998,40.635201,-73.742798,
40.640701,-73.741707,40.647202,
-73.725105,40.6521,-73.728706,
40.665699,-73.7258,40.68,-73.726799,
40.710499,-73.7304,40.721901,
-73.707901,40.7276,-73.699905,
40.739101,-73.701508,40.752399,
-73.750801,40.782902,-73.779999,
40.812,-73.782303,40.804298,
-73.787903,40.799801,-73.817703,
40.805302,-73.853203,40.799599,
-73.863304,40.7971,-73.874107,
40.785801,-73.889702,40.787201,
-73.890907,40.790199,-73.913101,
40.796001)),'Queens','36081',
'NewYork','NY','36',109.3812,1951598,17842.1562);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.635902,42.941216,-73.651085,
42.938206,-73.660393,42.932873,
-73.679314,42.912216,-73.68351,
42.903702,-73.684578,42.891228,
-73.673637,42.875,-73.676346,
42.858501,-73.671051,42.839668,
-73.660103,42.818901,-73.658905,
42.808998,-73.662704,42.801899,
-73.6726,42.796101,-73.6772,
42.783199,-73.684219,42.766544,
-73.6894,42.738201,-73.697701,
42.728699,-73.704002,42.7094,
-73.702904,42.699902,-73.729706,
42.664799,-73.742203,42.654301,
-73.761703,42.610298,-73.761703,
42.6007,-73.7528,42.576599,
-73.752602,42.566502,-73.761765,
42.525753,-73.777519,42.503922,
-73.78598,42.487129,-73.784149,
42.464153,-73.352974,42.509918,
-73.307327,42.632835,-73.265411,
42.745861,-73.276871,42.745941,
-73.291389,42.801846,-73.284203,
42.813789,-73.287514,42.820065,
-73.285835,42.834015,-73.279121,
42.833332,-73.278755,42.837479,
-73.275192,42.934357,-73.274742,
42.943577,-73.380043,42.943676,
-73.380692,42.947746,-73.389214,
42.948322,-73.393921,42.953011,
-73.403458,42.951267,-73.404953,
42.955414,-73.408653,42.956856,
-73.421669,42.954857,-73.431061,
42.958572,-73.449715,42.951141,
-73.451042,42.944504,-73.635902,
42.941216)),'Rensselaer','36083',
'NewYork','NY','36',653.9169,154429,236.1597);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.161491,40.644012,-74.18644,
40.645973,-74.202629,40.630951,
-74.206413,40.606949,-74.201019,
40.598747,-74.205002,40.593498,
-74.208511,40.588848,-74.209396,
40.576199,-74.215202,40.560501,
-74.218597,40.557098,-74.232002,
40.559101,-74.249054,40.549496,
-74.251854,40.542194,-74.246651,
40.520859,-74.254982,40.515724,
-74.259506,40.497101,-74.257202,
40.493187,-74.257126,40.493191,
-74.217216,40.503563,-74.210945,
40.510387,-74.206032,40.512024,
-74.193207,40.510658,-74.183929,
40.519665,-74.178474,40.51939,
-74.14463,40.534946,-74.13781,
40.529758,-74.133713,40.531673,
-74.123619,40.541496,-74.112152,
40.54668,-74.068497,40.583797,
-74.053482,40.602623,-74.042648,
40.603928,-74.057198,40.626801,
-74.056305,40.651299,-74.087402,
40.651299,-74.0942,40.6478,
-74.110397,40.6479,-74.143799,
40.6418,-74.161491,40.644012)),
'Richmond','36085','NewYork','NY','36',58.5961,378977,6467.6093);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.981796,41.3246,-74.234879,
41.142788,-74.213707,41.1339,
-73.905434,40.997498,-73.894402,
40.997101,-73.889801,41.037498,
-73.894302,41.0578,-73.895302,
41.082298,-73.887901,41.138199,
-73.892906,41.150501,-73.912102,
41.167702,-73.931908,41.204899,
-73.953705,41.228901,-73.9618,
41.2341,-73.9617,41.241901,
-73.971199,41.247799,-73.972702,
41.2561,-73.9701,41.2631,-73.947906,
41.2845,-73.946304,41.289398,
-73.9674,41.301601,-73.9814,
41.314098,-73.983002,41.321602,
-73.981796,41.3246)),'Rockland',
'36087','NewYork','NY','36',174.1944,265475,1524.0146);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-75.860367,44.403214,-75.704994,
44.331772,-75.446472,44.21759,
-75.170517,44.096897,-75.063141,
44.050335,-74.854546,44.070026,
-74.535545,44.099194,-74.544868,
44.169357,-74.52607,44.170574,
-74.609299,44.713451,-74.642242,
44.952576,-74.72068,44.952961,
-74.726601,44.994812,-74.731674,
44.990372,-74.745018,44.990528,
-74.76059,44.994896,-74.763771,
45.005573,-74.793518,45.004601,
-74.801994,45.014523,-74.817558,
45.011669,-74.826942,45.015804,
-74.866997,45.000481,-74.88839,
44.999599,-74.901085,44.992706,
-74.90831,44.983311,-74.972809,
44.983356,-74.993103,44.977406,
-74.999619,44.966061,-75.005501,
44.958355,-75.015793,44.952812,
-75.027473,44.946522,-75.060211,
44.934563,-75.06031,44.934521,
-75.06517,44.929401,-75.097,
44.927017,-75.105431,44.919491,
-75.11792,44.921291,-75.134758,
44.915051,-75.140213,44.896626,
-75.165466,44.893272,-75.203354,
44.877495,-75.218918,44.877518,
-75.228973,44.867844,-75.246025,
44.863976,-75.249031,44.862068,
-75.255859,44.857597,-75.25618,
44.857533,-75.256439,44.857368,
-75.307083,44.835163,-75.302315,
44.82658,-75.334084,44.80632,
-75.344879,44.809086,-75.370224,
44.785656,-75.370285,44.782825,
-75.387703,44.779968,-75.397346,
44.773411,-75.414131,44.772476,
-75.424278,44.756268,-75.472229,
44.723846,-75.473793,44.72298,
-75.477974,44.720165,-75.50341,
44.706532,-75.506477,44.704834,
-75.61869,44.619576,-75.662491,
44.59201,-75.662704,44.591873,
-75.766541,44.515793,-75.808098,
44.471588,-75.821152,44.432186,
-75.860367,44.403214)),'St.Lawrence',
'36089','NewYork','NY','36',2685.2617,111974,41.6994);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.140572,43.253906,-74.097893,
42.982861,-74.093521,42.95562,
-74.055832,42.953251,-74.006905,
42.933701,-73.969902,42.911201,
-73.9645,42.9034,-73.955902,
42.897301,-73.918701,42.9105,
-73.905106,42.911201,-73.896301,
42.851002,-73.882202,42.8508,
-73.876305,42.834202,-73.858902,
42.819901,-73.842003,42.797798,
-73.829506,42.7901,-73.828102,
42.783699,-73.822601,42.780201,
-73.809799,42.778801,-73.798401,
42.7794,-73.782906,42.791698,
-73.777802,42.791698,-73.767105,
42.785999,-73.750603,42.8013,
-73.738106,42.818802,-73.727104,
42.822498,-73.723106,42.820599,
-73.721802,42.813,-73.717102,
42.808102,-73.720306,42.801201,
-73.7118,42.795101,-73.709396,
42.787601,-73.703598,42.782398,
-73.689598,42.775299,-73.682503,
42.779701,-73.681602,42.782902,
-73.6772,42.783199,-73.6726,
42.796101,-73.662704,42.801899,
-73.658905,42.808998,-73.660103,
42.818901,-73.671051,42.839668,
-73.676346,42.858501,-73.673637,
42.875,-73.684578,42.891228,
-73.68351,42.903702,-73.679314,
42.912216,-73.660393,42.932873,
-73.651085,42.938206,-73.635902,
42.941216,-73.629761,42.951427,
-73.631561,42.970543,-73.609299,
42.982761,-73.60714,42.999165,
-73.597549,43.007549,-73.593544,
43.01535,-73.586823,43.048473,
-73.578239,43.057262,-73.582199,
43.070114,-73.575737,43.082428,
-73.578758,43.089649,-73.573784,
43.100002,-73.57608,43.115765,
-73.586037,43.123592,-73.591499,
43.137444,-73.580658,43.152809,
-73.58374,43.165501,-73.588181,
43.166721,-73.590279,43.170399,
-73.581451,43.182415,-73.582787,
43.189568,-73.58625,43.192299,
-73.579666,43.209595,-73.586403,
43.22736,-73.593994,43.232559,
-73.597923,43.240875,-73.587296,
43.25745,-73.592796,43.267075,
-73.601173,43.268764,-73.600098,
43.279728,-73.588989,43.299343,
-73.595398,43.306049,-73.610275,
43.306473,-73.628593,43.303791,
-73.637238,43.306866,-73.643204,
43.3041,-73.642303,43.293201,
-73.651108,43.289501,-73.671715,
43.293083,-73.675598,43.285,
-73.661507,43.2728,-73.669998,
43.263802,-73.676903,43.263401,
-73.681198,43.2673,-73.685402,
43.2808,-73.690598,43.284,-73.696686,
43.278408,-73.705025,43.279285,
-73.711418,43.273766,-73.73513,
43.268826,-73.74041,43.264637,
-73.738007,43.255157,-73.744392,
43.242645,-73.760658,43.231789,
-73.767937,43.222054,-73.773125,
43.224659,-73.77993,43.234833,
-73.793327,43.246174,-73.803734,
43.250248,-73.815804,43.250916,
-73.819969,43.250572,-73.826294,
43.24551,-73.83535,43.250931,
-73.835999,43.265762,-73.825584,
43.277477,-73.827934,43.2845,
-73.82505,43.304199,-73.837349,
43.306541,-73.843391,43.318638,
-73.859077,43.328045,-73.853722,
43.337681,-73.864471,43.345428,
-73.865181,43.354107,-73.875572,
43.361851,-73.871407,43.372456,
-73.875,43.384426,-73.883728,
43.397919,-74.160522,43.371464,
-74.140572,43.253906)),'Saratoga',
'36091','NewYork','NY','36',811.768,181276,223.3099);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.264114,42.796524,-74.25489,
42.795242,-74.253685,42.790104,
-74.248367,42.786282,-74.255005,
42.7752,-74.251915,42.766022,
-74.254326,42.762115,-74.263931,
42.755539,-74.270149,42.757294,
-74.290253,42.756271,-74.307098,
42.75,-74.27813,42.719395,-74.271202,
42.719467,-74.27272,42.714195,
-74.24144,42.716785,-74.240273,
42.718849,-74.20314,42.710751,
-74.184662,42.712429,-74.180702,
42.729904,-73.809998,42.775101,
-73.809799,42.778801,-73.822601,
42.780201,-73.828102,42.783699,
-73.829506,42.7901,-73.842003,
42.797798,-73.858902,42.819901,
-73.876305,42.834202,-73.882202,
42.8508,-73.896301,42.851002,
-73.905106,42.911201,-73.918701,
42.9105,-73.955902,42.897301,
-73.9645,42.9034,-73.969902,
42.911201,-74.006905,42.933701,
-74.055832,42.953251,-74.093521,
42.95562,-74.084335,42.897415,
-74.257622,42.811947,-74.256279,
42.805553,-74.264938,42.799858,
-74.264114,42.796524)),'Schenectady',
'36093','NewYork','NY','36',206.0897,149285,724.3686);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.648712,42.829483,-74.665802,
42.791801,-74.667931,42.750637,
-74.636177,42.651909,-74.631042,
42.626598,-74.672211,42.565071,
-74.711983,42.517723,-74.619301,
42.424313,-74.443909,42.354935,
-74.379463,42.373791,-74.376595,
42.370575,-74.357582,42.364574,
-74.346497,42.35561,-74.341377,
42.358395,-74.331017,42.35704,
-74.321373,42.36058,-74.312988,
42.35701,-74.299881,42.362492,
-74.290939,42.361202,-74.277054,
42.36327,-74.259598,42.379036,
-74.247437,42.37907,-74.245102,
42.377079,-74.254723,42.408127,
-74.263878,42.407047,-74.265282,
42.419785,-74.252846,42.445267,
-74.244873,42.470188,-74.22892,
42.494305,-74.225983,42.507984,
-74.231071,42.519054,-74.229416,
42.528824,-74.238571,42.543781,
-74.243256,42.558083,-74.218575,
42.593567,-74.210014,42.597351,
-74.207123,42.605915,-74.193916,
42.618923,-74.192993,42.626991,
-74.182266,42.641682,-74.170273,
42.66732,-74.169952,42.691292,
-74.165108,42.717133,-74.180702,
42.729904,-74.184662,42.712429,
-74.20314,42.710751,-74.240273,
42.718849,-74.24144,42.716785,
-74.27272,42.714195,-74.271202,
42.719467,-74.27813,42.719395,
-74.307098,42.75,-74.290253,
42.756271,-74.270149,42.757294,
-74.263931,42.755539,-74.254326,
42.762115,-74.251915,42.766022,
-74.255005,42.7752,-74.248367,
42.786282,-74.253685,42.790104,
-74.25489,42.795242,-74.264114,
42.796524,-74.289871,42.783733,
-74.32515,42.783268,-74.45533,
42.772903,-74.562309,42.812656,
-74.648712,42.829483)),'Schoharie',
'36095','NewYork','NY','36',621.7304,31859,51.2424);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-76.895912,42.54147,-76.910469,
42.541409,-76.915642,42.509575,
-76.911919,42.479458,-76.903656,
42.462212,-76.964294,42.459118,
-76.964767,42.46418,-76.98822,
42.463169,-76.989746,42.484821,
-77.107513,42.4837,-77.099968,
42.272285,-77.089127,42.271935,
-77.06881,42.275745,-76.965347,
42.278419,-76.96508,42.287369,
-76.843231,42.293682,-76.734238,
42.293648,-76.733009,42.247978,
-76.686111,42.24826,-76.685989,
42.237549,-76.648445,42.238022,
-76.642586,42.233646,-76.619873,
42.2486,-76.61969,42.28278,
-76.691811,42.284302,-76.69088,
42.373283,-76.686249,42.373306,
-76.686066,42.375,-76.696976,
42.546635,-76.895912,42.54147)),
'Schuyler','36097','NewYork','NY','36',328.6662,18662,56.7809);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-76.964134,43.013096,-76.963676,
42.872566,-76.978844,42.869007,
-76.981667,42.862164,-76.972885,
42.83707,-76.978355,42.828884,
-76.97477,42.812717,-76.977913,
42.773132,-76.972755,42.764149,
-76.947899,42.764275,-76.945305,
42.737225,-76.939018,42.721455,
-76.89743,42.663582,-76.894859,
42.629086,-76.895912,42.54147,
-76.696976,42.546635,-76.586319,
42.549839,-76.612503,42.562798,
-76.627098,42.573795,-76.656563,
42.604729,-76.66687,42.623386,
-76.688232,42.674717,-76.720024,
42.700344,-76.729279,42.71283,
-76.739799,42.770035,-76.740395,
42.789352,-76.719841,42.825378,
-76.717514,42.838764,-76.721573,
42.869511,-76.737785,42.902039,
-76.739502,42.916767,-76.734619,
42.944744,-76.739685,42.954407,
-76.737061,42.970219,-76.727951,
42.978081,-76.729141,42.987701,
-76.720985,42.995365,-76.721985,
43.007797,-76.711525,43.017975,
-76.714157,43.024014,-76.964134,
43.013096)),'Seneca','36099',
'NewYork','NY','36',324.8676,33683,103.6821);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-77.490295,42.577202,-77.66021,
42.580257,-77.661598,42.535,
-77.720901,42.535,-77.723251,
42.471149,-77.726395,42.403976,
-77.731346,42.404057,-77.750214,
41.998714,-77.610107,41.999298,
-77.125,41.999325,-76.966003,
42.001202,-76.965347,42.278419,
-77.06881,42.275745,-77.089127,
42.271935,-77.099968,42.272285,
-77.107513,42.4837,-77.107903,
42.505699,-77.115105,42.508202,
-77.122101,42.500801,-77.135078,
42.494736,-77.144257,42.494637,
-77.149811,42.5,-77.147202,42.532001,
-77.149902,42.553799,-77.144104,
42.576801,-77.366798,42.576302,
-77.490295,42.577202)),'Steuben',
'36101','NewYork','NY','36',1392.4833,99088,71.1591);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.496902,40.92308,-73.490799,
40.919399,-73.477745,40.899208,
-73.476509,40.87701,-73.467796,
40.868,-73.462708,40.8666,-73.4645,
40.859402,-73.455803,40.842499,
-73.428505,40.697899,-73.423599,
40.6689,-73.423798,40.655499,
-73.426102,40.6558,-73.425964,
40.608772,-73.424202,40.6091,
-73.342201,40.632217,-73.326569,
40.632717,-73.314659,40.628246,
-73.310928,40.61956,-73.260551,
40.621052,-73.176819,40.636761,
-73.084839,40.658249,-73.033272,
40.672001,-72.884567,40.726151,
-72.816666,40.746784,-72.756485,
40.763111,-72.753059,40.762257,
-72.619827,40.799217,-72.506363,
40.83102,-72.421387,40.857574,
-72.353333,40.88121,-72.217957,
40.934219,-72.142029,40.961437,
-71.918549,41.038795,-71.903511,
41.039513,-71.874855,41.051689,
-71.856232,41.070313,-71.866974,
41.077477,-71.89563,41.076759,
-71.905655,41.086071,-71.91497,
41.081776,-71.959373,41.071743,
-71.96225,41.062431,-71.95723,
41.045959,-71.965111,41.04166,
-71.973701,41.040234,-71.980148,
41.043095,-71.983017,41.047394,
-71.99305,41.047394,-72.022415,
41.020889,-72.039604,41.019455,
-72.052498,41.022324,-72.061806,
41.01659,-72.066826,41.010143,
-72.076851,41.009426,-72.084015,
40.996536,-72.09333,40.992237,
-72.107651,40.99295,-72.118393,
41.000835,-72.128426,41.015877,
-72.136307,41.020172,-72.138451,
41.040943,-72.16066,41.053123,
-72.175697,41.047394,-72.18071,
41.038795,-72.190742,41.03307,
-72.200058,41.030914,-72.231567,
41.044525,-72.263084,41.04166,
-72.273834,41.050255,-72.282425,
41.068878,-72.276695,41.076759,
-72.280991,41.081055,-72.292458,
41.081055,-72.308929,41.084641,
-72.320389,41.090366,-72.323257,
41.100395,-72.253777,41.134064,
-72.253059,41.141228,-72.238014,
41.154835,-72.237297,41.159847,
-72.24733,41.160564,-72.258781,
41.158417,-72.266663,41.154121,
-72.277962,41.158173,-72.286186,
41.157299,-72.313309,41.147617,
-72.320091,41.140835,-72.331711,
41.136959,-72.340431,41.140835,
-72.354958,41.138897,-72.358833,
41.13018,-72.365616,41.123402,
-72.383049,41.114681,-72.391769,
41.10112,-72.406296,41.091434,
-72.426643,41.086594,-72.446976,
41.084656,-72.455696,41.072063,
-72.477974,41.051723,-72.517685,
41.0401,-72.562241,41.013943,
-72.57193,41.003292,-72.631981,
40.98101,-72.678482,40.978104,
-72.692039,40.980045,-72.771461,
40.966484,-72.835396,40.968418,
-72.866394,40.963577,-72.899323,
40.962608,-73.006844,40.965511,
-73.053337,40.964546,-73.08239,
40.972298,-73.104675,40.968418,
-73.119324,40.977081,-73.132698,
40.96751,-73.151054,40.966045,
-73.158035,40.96788,-73.159874,
40.966412,-73.145554,40.955395,
-73.147751,40.930798,-73.165741,
40.92382,-73.227432,40.906559,
-73.267815,40.914272,-73.294624,
40.924183,-73.323257,40.928955,
-73.331703,40.930061,-73.352631,
40.926758,-73.375031,40.937035,
-73.393394,40.954659,-73.399635,
40.955029,-73.402199,40.952087,
-73.404037,40.92345,-73.406975,
40.920143,-73.417625,40.918312,
-73.429008,40.920143,-73.430161,
40.928635,-73.430305,40.929699,
-73.437103,40.934799,-73.4617,
40.936901,-73.485802,40.946301,
-73.493904,40.9398,-73.496902,
40.92308)),'Suffolk','36103',
'NewYork','NY','36',911.0761,1321864,1450.8808);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-75.146835,41.850811,-75.140633,
41.851994,-75.131371,41.845058,
-75.115982,41.844551,-75.113724,
41.822697,-75.100418,41.81826,
-75.089874,41.811489,-75.076614,
41.815201,-75.072266,41.812813,
-75.077278,41.79842,-75.081802,
41.796394,-75.093262,41.796299,
-75.10041,41.789562,-75.105026,
41.774117,-75.100357,41.76881,
-75.093201,41.768272,-75.077385,
41.771561,-75.065285,41.766602,
-75.06076,41.764111,-75.053619,
41.751575,-75.055206,41.735081,
-75.050247,41.713219,-75.052612,
41.711308,-75.067017,41.712502,
-75.069214,41.708073,-75.053131,
41.688305,-75.051674,41.679871,
-75.059723,41.672234,-75.050308,
41.662468,-75.049049,41.633694,
-75.044037,41.622528,-75.045898,
41.616116,-75.058304,41.618069,
-75.061943,41.616341,-75.06076,
41.610317,-75.074188,41.608498,
-75.074997,41.605625,-75.070084,
41.601917,-75.060402,41.590725,
-75.047142,41.583172,-75.040878,
41.569599,-75.027725,41.563454,
-75.018913,41.551716,-75.016533,
41.544155,-75.025185,41.539711,
-75.025146,41.535011,-75.009941,
41.528374,-75.003372,41.522884,
-75.001297,41.519203,-75.003532,
41.508011,-74.988029,41.508648,
-74.984756,41.506523,-74.982559,
41.498398,-74.985985,41.485775,
-74.983727,41.480804,-74.958649,
41.476307,-74.945145,41.483398,
-74.933846,41.482513,-74.925377,
41.47736,-74.910995,41.474083,
-74.90728,41.46104,-74.904594,
41.459717,-74.890755,41.455235,
-74.889679,41.450687,-74.89679,
41.442089,-74.893013,41.438526,
-74.858971,41.444336,-74.837303,
41.431538,-74.831062,41.430412,
-74.826424,41.431644,-74.818382,
41.440414,-74.809418,41.442905,
-74.801949,41.438515,-74.79689,
41.425301,-74.792503,41.421986,
-74.784729,41.422302,-74.773628,
41.426262,-74.761215,41.423122,
-74.755081,41.424881,-74.756111,
41.428123,-74.75161,41.432148,
-74.755951,41.433796,-74.762207,
41.448513,-74.759125,41.454319,
-74.760246,41.460819,-74.750969,
41.464954,-74.754944,41.478615,
-74.760361,41.482342,-74.761047,
41.4907,-74.752792,41.493652,
-74.475861,41.504246,-74.476097,
41.510098,-74.466415,41.5163,
-74.466118,41.522842,-74.457687,
41.52747,-74.455246,41.532936,
-74.451508,41.532661,-74.444717,
41.537395,-74.445297,41.543941,
-74.438873,41.543022,-74.438843,
41.54705,-74.435555,41.545975,
-74.434486,41.553547,-74.426476,
41.556179,-74.430038,41.558239,
-74.423149,41.560135,-74.423065,
41.562767,-74.4198,41.562382,
-74.418404,41.569515,-74.409081,
41.568027,-74.408043,41.569813,
-74.411118,41.570843,-74.408592,
41.574707,-74.406822,41.572285,
-74.396736,41.576145,-74.390785,
41.58614,-74.388382,41.583439,
-74.384697,41.583553,-74.367844,
41.590897,-74.364822,41.594719,
-74.374062,41.595695,-74.375969,
41.597893,-74.375961,41.604393,
-74.386246,41.618443,-74.387131,
41.627567,-74.395485,41.644791,
-74.575478,41.745167,-74.487328,
41.835171,-74.454086,41.875504,
-74.625,41.951023,-74.78109,
42.016289,-75.146835,41.850811)),
'Sullivan','36105','NewYork','NY','36',969.6352,69277,71.4464);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-76.2537,42.407497,-76.293457,
42.406502,-76.298485,42.395866,
-76.296577,42.38953,-76.29985,
42.384499,-76.29541,42.380039,
-76.280815,42.380241,-76.275543,
42.376968,-76.265953,42.375362,
-76.242737,42.363766,-76.240295,
42.360012,-76.238159,42.351208,
-76.245682,42.342033,-76.247307,
42.329082,-76.251472,42.324833,
-76.250427,42.296608,-76.288635,
42.296692,-76.288567,42.308155,
-76.35096,42.308365,-76.351234,
42.318214,-76.415649,42.318295,
-76.416534,42.262905,-76.474831,
42.263687,-76.474304,42.281059,
-76.538689,42.281681,-76.536118,
42.25,-76.536842,42.155327,
-76.562874,42.155834,-76.563881,
42.152477,-76.557854,42.143078,
-76.558868,42.135231,-76.554634,
42.13139,-76.559746,42.131176,
-76.556557,42.12661,-76.550903,
42.079552,-76.541824,42.051655,
-76.561821,42.009033,-76.558449,
42.00008,-76.147202,41.998688,
-76.106194,41.998783,-76.105217,
42.031841,-76.11171,42.101105,
-76.10891,42.101185,-76.116577,
42.185535,-76.087425,42.186752,
-76.087677,42.193535,-76.085236,
42.193569,-76.087044,42.212849,
-76.082909,42.213009,-76.081474,
42.230412,-76.084801,42.230431,
-76.091255,42.249561,-76.096703,
42.249454,-76.096985,42.257378,
-76.081032,42.258007,-76.083801,
42.271744,-76.087608,42.271637,
-76.088081,42.27869,-76.10096,
42.278347,-76.101578,42.287216,
-76.106934,42.287285,-76.106918,
42.293457,-76.099113,42.293579,
-76.099464,42.303326,-76.101944,
42.303257,-76.101974,42.310326,
-76.106606,42.310272,-76.106743,
42.318661,-76.112755,42.318531,
-76.112778,42.32645,-76.116714,
42.326496,-76.117058,42.337154,
-76.109642,42.337257,-76.110268,
42.347271,-76.112297,42.357193,
-76.114967,42.357212,-76.114983,
42.367035,-76.122795,42.367115,
-76.123207,42.380714,-76.12056,
42.380669,-76.124817,42.39193,
-76.12487,42.401943,-76.130028,
42.401966,-76.130531,42.410263,
-76.2537,42.407497)),'Tioga','36107',
'NewYork','NY','36',518.6357,52337,100.9127);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-76.66687,42.623386,-76.656563,
42.604729,-76.627098,42.573795,
-76.612503,42.562798,-76.586319,
42.549839,-76.696976,42.546635,
-76.686066,42.375,-76.686249,
42.373306,-76.69088,42.373283,
-76.691811,42.284302,-76.61969,
42.28278,-76.538689,42.281681,
-76.474304,42.281059,-76.474831,
42.263687,-76.416534,42.262905,
-76.415649,42.318295,-76.351234,
42.318214,-76.35096,42.308365,
-76.288567,42.308155,-76.288635,
42.296692,-76.250427,42.296608,
-76.251472,42.324833,-76.247307,
42.329082,-76.245682,42.342033,
-76.238159,42.351208,-76.240295,
42.360012,-76.242737,42.363766,
-76.265953,42.375362,-76.275543,
42.376968,-76.280815,42.380241,
-76.29541,42.380039,-76.29985,
42.384499,-76.296577,42.38953,
-76.298485,42.395866,-76.293457,
42.406502,-76.2537,42.407497,
-76.26593,42.62352,-76.458817,
42.618538,-76.45919,42.627106,
-76.614365,42.622196,-76.614647,
42.625298,-76.66687,42.623386)),
'Tompkins','36109','NewYork','NY','36',475.9956,94097,197.6845);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.452118,42.169136,-74.504387,
42.144833,-74.531395,42.146389,
-74.554001,42.121395,-74.78109,
42.016289,-74.625,41.951023,
-74.454086,41.875504,-74.487328,
41.835171,-74.575478,41.745167,
-74.395485,41.644791,-74.387131,
41.627567,-74.386246,41.618443,
-74.375961,41.604393,-74.375969,
41.597893,-74.374062,41.595695,
-74.364822,41.594719,-74.367844,
41.590897,-74.354195,41.591885,
-74.350571,41.598431,-74.340874,
41.59436,-74.335327,41.597382,
-74.332161,41.596764,-74.330116,
41.601181,-74.319664,41.603333,
-74.313049,41.610744,-74.306282,
41.608986,-74.304482,41.615505,
-74.296127,41.619183,-74.291527,
41.61861,-74.280067,41.625538,
-74.267982,41.628963,-74.264679,
41.632668,-74.250595,41.62923,
-74.252007,41.605282,-74.187912,
41.590698,-74.185768,41.594036,
-74.126808,41.582451,-74.134918,
41.615604,-74.095428,41.606354,
-74.090439,41.598461,-74.068375,
41.60574,-74.054214,41.585972,
-74.054092,41.580517,-73.953728,
41.589886,-73.953003,41.625099,
-73.947304,41.6563,-73.9478,41.6674,
-73.942902,41.683998,-73.947105,
41.699299,-73.941505,41.732601,
-73.941246,41.754223,-73.952034,
41.770527,-73.952866,41.787872,
-73.948753,41.815647,-73.949364,
41.848545,-73.939713,41.866768,
-73.945518,41.881359,-73.962639,
41.900928,-73.964828,41.913055,
-73.958466,41.921055,-73.953247,
41.956978,-73.933853,42.015568,
-73.937714,42.029697,-73.933151,
42.060719,-73.92672,42.070526,
-73.930046,42.07869,-73.92189,
42.109936,-73.911095,42.127205,
-73.918785,42.128826,-74.002869,
42.176903,-74.00399,42.163277,
-74.025299,42.162045,-74.042816,
42.1703,-74.075218,42.0965,-74.2314,
42.108353,-74.307983,42.114258,
-74.452118,42.169136)),'Ulster',
'36111','NewYork','NY','36',1126.3818,165304,146.7564);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-74.057426,43.74445,-74.215042,
43.728642,-74.160522,43.371464,
-73.883728,43.397919,-73.875,
43.384426,-73.871407,43.372456,
-73.875572,43.361851,-73.865181,
43.354107,-73.864471,43.345428,
-73.853722,43.337681,-73.859077,
43.328045,-73.843391,43.318638,
-73.837349,43.306541,-73.82505,
43.304199,-73.827934,43.2845,
-73.825584,43.277477,-73.835999,
43.265762,-73.83535,43.250931,
-73.826294,43.24551,-73.819969,
43.250572,-73.815804,43.250916,
-73.803734,43.250248,-73.793327,
43.246174,-73.77993,43.234833,
-73.773125,43.224659,-73.767937,
43.222054,-73.760658,43.231789,
-73.744392,43.242645,-73.738007,
43.255157,-73.74041,43.264637,
-73.73513,43.268826,-73.711418,
43.273766,-73.705025,43.279285,
-73.696686,43.278408,-73.690598,
43.284,-73.685402,43.2808,-73.681198,
43.2673,-73.676903,43.263401,
-73.669998,43.263802,-73.661507,
43.2728,-73.675598,43.285,-73.671715,
43.293083,-73.651108,43.289501,
-73.642303,43.293201,-73.643204,
43.3041,-73.637238,43.306866,
-73.628593,43.303791,-73.610275,
43.306473,-73.595398,43.306049,
-73.629166,43.486351,-73.632462,
43.493832,-73.637131,43.496853,
-73.63192,43.497166,-73.636726,
43.499634,-73.635231,43.501904,
-73.633003,43.500919,-73.63353,
43.505108,-73.631393,43.504211,
-73.632767,43.512035,-73.628929,
43.518917,-73.625603,43.51889,
-73.626884,43.521523,-73.62381,
43.518986,-73.619568,43.520245,
-73.616196,43.539982,-73.607552,
43.551533,-73.614258,43.556061,
-73.611275,43.560631,-73.612907,
43.563259,-73.60762,43.563881,
-73.604576,43.567841,-73.589203,
43.56926,-73.584351,43.572826,
-73.577599,43.57914,-73.58197,
43.578659,-73.58213,43.580307,
-73.575371,43.582115,-73.566658,
43.591099,-73.565208,43.598053,
-73.555801,43.604389,-73.539581,
43.62534,-73.525787,43.636009,
-73.514389,43.637611,-73.516312,
43.639809,-73.512787,43.643211,
-73.50444,43.6441,-73.503586,
43.646843,-73.502136,43.645245,
-73.50238,43.651783,-73.498787,
43.650826,-73.493713,43.655216,
-73.496468,43.661343,-73.493782,
43.66267,-73.492943,43.669327,
-73.496849,43.672844,-73.49263,
43.672894,-73.487122,43.679459,
-73.484299,43.692356,-73.472771,
43.707199,-73.474945,43.710903,
-73.470665,43.716122,-73.471169,
43.720577,-73.467766,43.721153,
-73.467575,43.724831,-73.464264,
43.725883,-73.465218,43.730824,
-73.462029,43.728745,-73.459793,
43.729958,-73.464684,43.733383,
-73.463364,43.738918,-73.460777,
43.737499,-73.460869,43.747379,
-73.463654,43.758003,-73.466843,
43.757797,-73.458138,43.761845,
-73.457764,43.76516,-73.460976,
43.768684,-73.471863,43.771675,
-73.471359,43.775745,-73.457672,
43.783684,-73.446625,43.79491,
-73.437309,43.800491,-73.438637,
43.803623,-74.057426,43.74445)),
'Warren','36113','NewYork','NY','36',869.5693,59209,68.0899);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.438637,43.803623,-73.437309,
43.800491,-73.446625,43.79491,
-73.457672,43.783684,-73.471359,
43.775745,-73.471863,43.771675,
-73.460976,43.768684,-73.457764,
43.76516,-73.458138,43.761845,
-73.466843,43.757797,-73.463654,
43.758003,-73.460869,43.747379,
-73.460777,43.737499,-73.463364,
43.738918,-73.464684,43.733383,
-73.459793,43.729958,-73.462029,
43.728745,-73.465218,43.730824,
-73.464264,43.725883,-73.467575,
43.724831,-73.467766,43.721153,
-73.471169,43.720577,-73.470665,
43.716122,-73.474945,43.710903,
-73.472771,43.707199,-73.484299,
43.692356,-73.487122,43.679459,
-73.49263,43.672894,-73.496849,
43.672844,-73.492943,43.669327,
-73.493782,43.66267,-73.496468,
43.661343,-73.493713,43.655216,
-73.498787,43.650826,-73.50238,
43.651783,-73.502136,43.645245,
-73.503586,43.646843,-73.50444,
43.6441,-73.512787,43.643211,
-73.516312,43.639809,-73.514389,
43.637611,-73.525787,43.636009,
-73.539581,43.62534,-73.555801,
43.604389,-73.565208,43.598053,
-73.566658,43.591099,-73.575371,
43.582115,-73.58213,43.580307,
-73.58197,43.578659,-73.577599,
43.57914,-73.584351,43.572826,
-73.589203,43.56926,-73.604576,
43.567841,-73.60762,43.563881,
-73.612907,43.563259,-73.611275,
43.560631,-73.614258,43.556061,
-73.607552,43.551533,-73.616196,
43.539982,-73.619568,43.520245,
-73.62381,43.518986,-73.626884,
43.521523,-73.625603,43.51889,
-73.628929,43.518917,-73.632767,
43.512035,-73.631393,43.504211,
-73.63353,43.505108,-73.633003,
43.500919,-73.635231,43.501904,
-73.636726,43.499634,-73.63192,
43.497166,-73.637131,43.496853,
-73.632462,43.493832,-73.629166,
43.486351,-73.595398,43.306049,
-73.588989,43.299343,-73.600098,
43.279728,-73.601173,43.268764,
-73.592796,43.267075,-73.587296,
43.25745,-73.597923,43.240875,
-73.593994,43.232559,-73.586403,
43.22736,-73.579666,43.209595,
-73.58625,43.192299,-73.582787,
43.189568,-73.581451,43.182415,
-73.590279,43.170399,-73.588181,
43.166721,-73.58374,43.165501,
-73.580658,43.152809,-73.591499,
43.137444,-73.586037,43.123592,
-73.57608,43.115765,-73.573784,
43.100002,-73.578758,43.089649,
-73.575737,43.082428,-73.582199,
43.070114,-73.578239,43.057262,
-73.586823,43.048473,-73.593544,
43.01535,-73.597549,43.007549,
-73.60714,42.999165,-73.609299,
42.982761,-73.631561,42.970543,
-73.629761,42.951427,-73.635902,
42.941216,-73.451042,42.944504,
-73.449715,42.951141,-73.431061,
42.958572,-73.421669,42.954857,
-73.408653,42.956856,-73.404953,
42.955414,-73.403458,42.951267,
-73.393921,42.953011,-73.389214,
42.948322,-73.380692,42.947746,
-73.380043,42.943676,-73.274742,
42.943577,-73.270485,43.03064,
-73.264511,43.123322,-73.259605,
43.21677,-73.255081,43.314602,
-73.251297,43.40863,-73.249207,
43.461742,-73.248146,43.523106,
-73.241837,43.532276,-73.246078,
43.539478,-73.250572,43.543362,
-73.24826,43.544987,-73.250854,
43.550362,-73.249084,43.553791,
-73.254936,43.555527,-73.253052,
43.556786,-73.256378,43.561817,
-73.26461,43.569069,-73.269447,
43.569847,-73.268028,43.571907,
-73.278259,43.574566,-73.281303,
43.573513,-73.281746,43.577511,
-73.285362,43.579205,-73.295738,
43.576717,-73.297783,43.579323,
-73.292557,43.584442,-73.297371,
43.587257,-73.291573,43.599148,
-73.298462,43.609962,-73.303215,
43.609711,-73.300758,43.617256,
-73.302521,43.623772,-73.306679,
43.627953,-73.311615,43.624027,
-73.318298,43.628433,-73.32814,
43.625847,-73.334633,43.62793,
-73.340515,43.62458,-73.344955,
43.626213,-73.349197,43.621391,
-73.355087,43.626163,-73.366005,
43.623375,-73.372337,43.624424,
-73.370277,43.619328,-73.376831,
43.608761,-73.37291,43.604782,
-73.377785,43.598289,-73.383949,
43.597218,-73.382385,43.591637,
-73.387321,43.590744,-73.382797,
43.586102,-73.385696,43.583199,
-73.38382,43.576702,-73.391045,
43.574192,-73.391991,43.570145,
-73.396645,43.567883,-73.40435,
43.570263,-73.420822,43.581425,
-73.429077,43.583927,-73.431671,
43.588219,-73.422058,43.602955,
-73.424149,43.612293,-73.418114,
43.621624,-73.429024,43.636478,
-73.425659,43.64423,-73.415955,
43.65239,-73.407883,43.673367,
-73.40435,43.691345,-73.395958,
43.69677,-73.386322,43.711277,
-73.371056,43.725269,-73.370331,
43.743839,-73.363106,43.753082,
-73.350868,43.771378,-73.357986,
43.785873,-73.376801,43.79871,
-73.379723,43.808331,-73.438637,
43.803623)),'Washington','36115',
'NewYork','NY','36',835.3925,59330,71.0204);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-77.375,43.276779,-77.375,43.276699,
-77.371552,43.034599,-77.247101,
43.034599,-77.246902,43.0397,
-77.134514,43.039825,-77.133705,
43.012402,-76.964134,43.013096,
-76.714157,43.024014,-76.719437,
43.037086,-76.718094,43.062672,
-76.712074,43.068623,-76.706215,
43.070717,-76.702637,43.080143,
-76.713493,43.249367,-76.722183,
43.343403,-76.731979,43.343063,
-76.767731,43.318958,-76.784264,
43.311516,-76.843819,43.304901,
-76.866142,43.29332,-76.881035,
43.292492,-76.898399,43.296627,
-76.94471,43.272644,-76.956299,
43.270988,-76.975311,43.2743,
-77.010048,43.270164,-77.043961,
43.270164,-77.049751,43.277607,
-77.070427,43.281738,-77.1035,
43.287533,-77.122528,43.286705,
-77.144859,43.290012,-77.171326,
43.280914,-77.192001,43.284225,
-77.218468,43.284225,-77.270569,
43.277607,-77.313576,43.280087,
-77.368996,43.277607,-77.375,
43.276779)),'Wayne','36117',
'NewYork','NY','36',604.1245,89123,147.5241);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-73.983002,41.321602,-73.9814,
41.314098,-73.9674,41.301601,
-73.946304,41.289398,-73.947906,
41.2845,-73.9701,41.2631,-73.972702,
41.2561,-73.971199,41.247799,
-73.9617,41.241901,-73.9618,41.2341,
-73.953705,41.228901,-73.931908,
41.204899,-73.912102,41.167702,
-73.892906,41.150501,-73.887901,
41.138199,-73.895302,41.082298,
-73.894302,41.0578,-73.889801,
41.037498,-73.894402,40.997101,
-73.896904,40.981602,-73.918503,
40.9174,-73.859901,40.900299,
-73.854797,40.908798,-73.851303,
40.909801,-73.853798,40.907101,
-73.842003,40.903801,-73.838905,
40.893902,-73.784096,40.880333,
-73.782066,40.883743,-73.775291,
40.882423,-73.770927,40.879185,
-73.767265,40.880775,-73.767487,
40.886189,-73.770348,40.888039,
-73.770432,40.893879,-73.766266,
40.901756,-73.761955,40.906811,
-73.743484,40.917889,-73.742065,
40.927429,-73.735222,40.925835,
-73.734261,40.921223,-73.731407,
40.927589,-73.725197,40.928223,
-73.722656,40.941586,-73.716454,
40.944763,-73.708504,40.944443,
-73.698326,40.939514,-73.69149,
40.944286,-73.686081,40.943649,
-73.677177,40.963688,-73.662506,
40.966099,-73.660393,40.968224,
-73.659958,40.974625,-73.656815,
40.977722,-73.658051,40.985401,
-73.657646,40.985874,-73.660095,
40.987812,-73.657486,40.98875,
-73.659798,40.999401,-73.655106,
41.0116,-73.728203,41.100601,
-73.634201,41.1441,-73.555695,
41.179588,-73.485771,41.211452,
-73.483147,41.212666,-73.503075,
41.237259,-73.551392,41.295326,
-73.545158,41.36628,-73.983002,
41.321602)),'Westchester','36119',
'NewYork','NY','36',432.8098,874866,2021.3623);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-78.464653,42.867401,-78.486511,
42.867672,-78.488403,42.780602,
-78.463486,42.780399,-78.464203,
42.536133,-78.464912,42.5191,
-78.309097,42.520939,-78.038994,
42.520901,-78.041855,42.529148,
-78.048309,42.52684,-78.041756,
42.532948,-78.042831,42.535088,
-78.0494,42.538692,-78.059906,
42.532253,-78.061172,42.535797,
-78.049423,42.543865,-78.052208,
42.548252,-78.048279,42.557919,
-78.036064,42.566879,-78.02858,
42.567909,-78.034447,42.573463,
-78.04686,42.570194,-78.050903,
42.576416,-78.036858,42.587475,
-78.022507,42.584866,-78.009018,
42.589249,-78.00428,42.595325,
-78.006561,42.598778,-78.015373,
42.599422,-78.022156,42.596096,
-78.027138,42.598167,-78.029228,
42.603745,-78.017967,42.607094,
-78.012726,42.61105,-78.005554,
42.610264,-77.996765,42.616032,
-77.990051,42.615192,-77.987579,
42.619308,-77.988297,42.6278,
-77.983681,42.630043,-77.983299,
42.633949,-77.977379,42.638802,
-77.97673,42.645039,-77.972145,
42.647213,-77.974411,42.654503,
-77.969307,42.66198,-77.962952,
42.661732,-77.956596,42.66782,
-77.955246,42.862484,-77.995529,
42.863121,-77.995628,42.864933,
-78.074425,42.863682,-78.074402,
42.870213,-78.464653,42.867401)),
'Wyoming','36121','NewYork','NY','36',592.8774,42507,71.696);
commit;
END;
/

BEGIN 
INSERT_DEMO_COUNTIES(MDSYS.SDO_GEOMETRY(2003,8265,null,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),
MDSYS.SDO_ORDINATE_ARRAY(-77.366798,42.576302,-77.144104,
42.576801,-77.149902,42.553799,
-77.147202,42.532001,-77.149811,42.5,
-77.144257,42.494637,-77.135078,
42.494736,-77.122101,42.500801,
-77.115105,42.508202,-77.107903,
42.505699,-77.107513,42.4837,
-76.989746,42.484821,-76.98822,
42.463169,-76.964767,42.46418,
-76.964294,42.459118,-76.903656,
42.462212,-76.911919,42.479458,
-76.915642,42.509575,-76.910469,
42.541409,-76.895912,42.54147,
-76.894859,42.629086,-76.89743,
42.663582,-76.939018,42.721455,
-76.945305,42.737225,-76.947899,
42.764275,-76.972755,42.764149,
-77.313301,42.7612,-77.336998,
42.733898,-77.346901,42.716301,
-77.354706,42.697102,-77.357704,
42.6679,-77.367401,42.667801,
-77.366798,42.576302)),'Yates',
'36123','NewYork','NY','36',338.1916,22810,67.4468);
commit;
END;
/



CREATE  TABLE DEMO_CITIES
  (
    "LOCATION" "MDSYS"."SDO_GEOMETRY" ,
    "CITY"       VARCHAR2(42 BYTE),
    "STATE_ABRV" VARCHAR2(2 BYTE),
    "POP90"      NUMBER,
    "RANK90"     NUMBER
  );
  
  COMMIT;
  
  
  CREATE OR REPLACE PROCEDURE INSERT_DEMO_CITIES(
    LOCATION MDSYS.SDO_GEOMETRY,
    CITY       VARCHAR2,
    STATE_ABRV VARCHAR2,
    POP90      NUMBER,
    RANK90     NUMBER)
  IS
  BEGIN
    Insert into DEMO_CITIES (LOCATION,CITY,STATE_ABRV,POP90,RANK90)
    VALUES (LOCATION,CITY,STATE_ABRV,POP90,RANK90);
  END;
  /
COMMIT;
  
  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-73.943849,40.6698,null),null,null),'New York','NY',7322564,1);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-118.411201,34.112101,null),null,null),'Los Angeles','CA',3485398,2);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.13577,32.81495,null),null,null),'San Diego','CA',1110549,6);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-112.071399,33.54255,null),null,null),'Phoenix','AZ',983403,9);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-121.849783,37.304,null),null,null),'San Jose','CA',782248,11);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-122.495856,37.77904,null),null,null),'San Francisco','CA',723959,14);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-81.648509,30.33415,null),null,null),'Jacksonville','FL',672971,15);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-118.159824,33.7889,null),null,null),'Long Beach','CA',429433,32);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-110.891717,32.195816,null),null,null),'Tucson','AZ',405390,33);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-122.22455,37.771544,null),null,null),'Oakland','CA',372242,39);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-121.46736,38.56685,null),null,null),'Sacramento','CA',369365,41);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-80.210845,25.775667,null),null,null),'Miami','FL',358548,46);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-119.792874,36.7806,null),null,null),'Fresno','CA',354202,47);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-78.859684,42.8898,null),null,null),'Buffalo','NY',328123,50);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.882114,33.7364,null),null,null),'Santa Ana','CA',293742,52);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-111.740337,33.417736,null),null,null),'Mesa','AZ',288091,53);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-82.48212,27.959,null),null,null),'Tampa','FL',280015,55);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.872331,33.8389,null),null,null),'Anaheim','CA',266406,59);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-82.642121,27.758,null),null,null),'St Petersburg','FL',238629,65);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-77.615838,43.168651,null),null,null),'Rochester','NY',231636,66);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.397363,33.940437,null),null,null),'Riverside','CA',226505,68);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-121.306741,37.96985,null),null,null),'Stockton','CA',210943,74);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-73.867514,40.947033,null),null,null),'Yonkers','NY',188082,84);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-80.296772,25.86175,null),null,null),'Hialeah','FL',188004,85);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-118.008115,33.691755,null),null,null),'Huntington Beach','CA',181519,90);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-118.253257,34.17672,null),null,null),'Glendale','CA',180038,92);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-119.004553,35.3577,null),null,null),'Bakersfield','CA',174820,97);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-121.997122,37.528506,null),null,null),'Fremont','CA',173339,98);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-120.993923,37.659799,null),null,null),'Modesto','CA',164730,103);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-81.374248,28.504748,null),null,null),'Orlando','FL',164693,104);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.292299,34.13975,null),null,null),'San Bernardino','CA',164164,105);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-76.144067,43.041059,null),null,null),'Syracuse','NY',163860,106);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-80.139499,26.14255,null),null,null),'Fort Lauderdale','FL',149377,116);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-112.20159,33.584128,null),null,null),'Glendale','AZ',148134,117);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.959375,33.77875,null),null,null),'Garden Grove','CA',143050,120);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-119.213695,34.197426,null),null,null),'Oxnard','CA',142216,121);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-111.930639,33.38835,null),null,null),'Tempe','AZ',141865,122);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.044733,32.62845,null),null,null),'Chula Vista','CA',135163,131);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.60581,34.054412,null),null,null),'Ontario','CA',133179,134);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-118.340424,33.8348,null),null,null),'Torrance','CA',133107,135);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.761399,34.05895,null),null,null),'Pomona','CA',131723,136);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-118.138724,34.1607,null),null,null),'Pasadena','CA',131591,137);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-111.870478,33.685992,null),null,null),'Scottsdale','AZ',130069,139);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.310286,33.225074,null),null,null),'Oceanside','CA',128398,141);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-84.281399,30.457,null),null,null),'Tallahassee','FL',124773,146);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-80.164762,26.029817,null),null,null),'Hollywood','FL',121697,148);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.210311,33.92623,null),null,null),'Moreno Valley','CA',118779,151);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-122.025531,37.38575,null),null,null),'Sunnyvale','CA',117229,153);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.928054,33.8848,null),null,null),'Fullerton','CA',114144,156);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-122.700799,38.4486,null),null,null),'Santa Rosa','CA',113313,158);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-122.104602,37.627667,null),null,null),'Hayward','CA',111498,162);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-121.99987,37.97325,null),null,null),'Concord','CA',111348,163);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.823999,33.80525,null),null,null),'Orange','CA',110658,165);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-118.510175,34.413408,null),null,null),'Santa Clarita','CA',110642,166);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.795807,33.662114,null),null,null),'Irvine','CA',110330,167);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-118.343649,33.95585,null),null,null),'Inglewood','CA',109602,169);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-122.264186,38.107467,null),null,null),'Vallejo','CA',109199,171);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-121.635081,36.684833,null),null,null),'Salinas','CA',108777,173);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.07127,33.136445,null),null,null),'Escondido','CA',108635,176);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-118.027797,34.0748,null),null,null),'El Monte','CA',106209,181);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-118.867557,34.1927,null),null,null),'Thousand Oaks','CA',104352,185);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-122.29729,37.86725,null),null,null),'Berkeley','CA',102724,189);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-117.570239,34.123831,null),null,null),'Rancho Cucamonga','CA',101409,191);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-73.799017,42.66575,null),null,null),'Albany','NY',101082,192);
 COMMIT;
 END;
/

  BEGIN 
 INSERT_DEMO_CITIES(MDSYS.SDO_GEOMETRY(2001,8265,MDSYS.SDO_POINT_TYPE(-118.751299,34.26305,null),null,null),'Simi Valley','CA',100217,195);
 COMMIT;
 END;
/





 
---
--- insert geom metadata for the base tables
---


insert into USER_SDO_GEOM_METADATA values (
	'DEMO_STATES', 
	'GEOM', 
        MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', -180, 180, .00000005), 
                            MDSYS.SDO_DIM_ELEMENT('Y', -90, 90, .00000005)),
        8265);

insert into USER_SDO_GEOM_METADATA values (
        'DEMO_COUNTIES',
        'GEOM',
        MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', -180, 180, .00000005),
                            MDSYS.SDO_DIM_ELEMENT('Y', -90, 90, .00000005)),
        8265);


insert into USER_SDO_GEOM_METADATA values (
        'DEMO_CITIES',
        'LOCATION',
        MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', -180, 180, .00000005),
                            MDSYS.SDO_DIM_ELEMENT('Y', -90, 90, .00000005)),
        8265);

commit;


create index DEMO_STATES_SDX on DEMO_STATES(GEOM) 
indextype is mdsys.spatial_index;

create index DEMO_COUNTIES_SDX on DEMO_COUNTIES(GEOM)
indextype is mdsys.spatial_index;

create index DEMO_CITIES_SDX on DEMO_CITIES(LOCATION)
indextype is mdsys.spatial_index;

commit;