set lZogOLAPISQL=true;
set logPreSQL=true;
set sZkipExecuteSQL=true;

_create aw defaultaw;

CREATE CUBE DIMENSION chan22 (
  channel VARCHAR2(20) LEVEL, 
  total_channel VARCHAR2(20) LEVEL, 
  channel_short_desc VARCHAR2(20) NOT INDEXED UNIQUE AT LEVEL channel,
  total_channel_short_desc VARCHAR2(20) NOT INDEXED UNIQUE AT LEVEL total_channel,
  channel_long_desc VARCHAR2(20) NOT INDEXED UNIQUE AT LEVEL channel,
  total_channel_long_desc VARCHAR2(20) NOT INDEXED UNIQUE AT LEVEL total_channel,
  long_description GROUP (
     channel_long_desc ,
     total_channel_long_desc 
  ),
  short_description GROUP (
     channel_short_desc ,
     total_channel_short_desc 
  ),
  HIERARCHY standard CONSTRAINT NOT RAGGED NOT SKIP LEVEL (channel CHILD OF total_channel)
) UNIQUE 
  ENFORCE STAR CONSISTENCY 
  MATERIALIZED VIEW READY
  ANALYTIC WORKSPACE defaultaw TABLESPACE global_tablespace
  MAP (channel, channel_short_desc, channel_long_desc, total_channel, total_channel_short_desc, total_channel_long_desc) USING 
  SELECT channel_id, channel_dsc, channel_dsc, total_channel_id, total_channel_dsc, total_channel_dsc FROM channel_dim;
  
COMMENT ON CUBE DIMENSION chan22 TYPE 'LONG_DESCRIPTION' IS 'Channel';

CREATE CUBE DIMENSION geog22 (
  city VARCHAR2(20) LEVEL, 
  state VARCHAR2(20) LEVEL, 
  country VARCHAR2(20) LEVEL,
  city_desc VARCHAR2(20) AT LEVEL city,
  state_desc VARCHAR2(20) AT LEVEL state,
  country_desc VARCHAR2(20) AT LEVEL country,
  description GROUP (
     city_desc ,
     state_desc ,
     country_desc 
  ),
  state_governer VARCHAR2(20),
  HIERARCHY standard (city CHILD OF state CHILD OF country)
);

COMMENT ON CUBE DIMENSION geog22 TYPE 'LONG_DESCRIPTION' IS 'Geography';

CREATE CUBE DIMENSION time23 (
  month VARCHAR2(8) LEVEL, 
  cal_quarter VARCHAR2(9)  LEVEL, 
  cal_year VARCHAR2(10)  LEVEL,
  fiscal_quarter VARCHAR2(9) LEVEL,
  fiscal_year VARCHAR2(10) LEVEL,
  HIERARCHY calendar (month CHILD OF cal_quarter CHILD OF cal_year),
  HIERARCHY fiscal (month CHILD OF fiscal_quarter CHILD OF fiscal_year)
);

COMMENT ON CUBE DIMENSION geog22 TYPE 'LONG_DESCRIPTION' IS 'Time without end date';

CREATE CUBE DIMENSION time22 TIME (
  month VARCHAR2(10)  LEVEL, 
  calendar_quarter VARCHAR2(10)  LEVEL,  
  calendar_year VARCHAR2(10)  LEVEL,
   
  month_end_date DATE AT LEVEL month,  
  calendar_quarter_end_date DATE AT LEVEL calendar_quarter,  
  calendar_year_end_date DATE AT LEVEL calendar_year, 
  
  month_time_span NUMBER at LEVEL month,
  calendar_quarter_time_span NUMBER AT LEVEL calendar_quarter,
  calendar_year_time_span NUMBER AT LEVEL calendar_year,   
  
  
  HIERARCHY calendar (month CHILD OF calendar_quarter CHILD OF calendar_year),
    end_date END DATE GROUP ( 
    calendar_year_end_date, calendar_quarter_end_date, month_end_date ),
  time_span TIME SPAN GROUP ( 
    calendar_year_time_span, calendar_quarter_time_span, month_time_span)
);

COMMENT ON CUBE DIMENSION time22 TYPE 'LONG_DESCRIPTION' IS 'Time without end date';

CREATE CUBE DIMENSION org22 (
  emp VARCHAR2(40) DIMENSION KEY,
  mgr VARCHAR2(40) PARENT,
  HIERARCHY standard 
);

CREATE CUBE DIMENSION dept22 (
   dept VARCHAR2(20) DIMENSION KEY
);

CREATE CUBE salescube22 (
   city DIMENSION KEY FOR geog22 SPARSE,
   time22 DIMENSION KEY,
   sales NUMBER(10,2)
) DEFAULT MEASURE sales  
  SOLVE BY (
    SUM MAINTAIN COUNT OVER ALL)
  SPARSE TYPE COMPRESSED  
  STORAGE GROUP MEASURE_GROUP1 SHARED USING NUMBER INCLUDES ALL
  ANALYTIC WORKSPACE defaultaw;
  
  
  CREATE CUBE MYCUBE97 (
  CHANNEL DIMENSION KEY SPARSE,
  "TIME" DIMENSION KEY SPARSE,
  SALES NUMBER,
  COST NUMBER,
  ADD1 AS (MYCUBE97.SALES + MYCUBE97.COST),
  SALES_RANK AS (RANK() OVER (HIERARCHY CHANNEL.CHANNEL_ROLLUP ORDER BY MYCUBE97.SALES DESC NULLS LAST WITHIN LEVEL)),
  SALES_SHARE AS (SHARE(MYCUBE97.SALES OF HIERARCHY CHANNEL.CHANNEL_ROLLUP TOP))
) DEFAULT MEASURE SALES  
  SOLVE BY (
    SUM MAINTAIN COUNT OVER ALL)
  SPARSE TYPE COMPRESSED  
  STORAGE GROUP MEASURE_GROUP1 SHARED USING NUMBER INCLUDES ALL  
  PARTITION ON CHANNEL BY TOTAL_CHANNEL FOR STANDARD
  ANALYTIC WORKSPACE GLOBAL
  MAP (CHANNEL, "TIME", COST, SALES) 
  USING SELECT CHANNEL_ID, TIME_ID, COST, SALES FROM UNITS_FACT;

COMMENT ON CUBE DIMENSION salescube22 TYPE 'LONG_DESCRIPTION' IS 'Sales Cube';

CREATE MEASURE FOLDER sales_measure_folder ( "UNITS_CUBE94.SALES", "UNITS_CUBE94.COST");