<?xml version='1.0' encoding='UTF-8'?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:c="http://xmlns.oracle.com/jdeveloper/updatecenter"
                xmlns:u="http://xmlns.oracle.com/jdeveloper/update">

  <!-- Key for Muenchian grouping -->
  <xsl:key name="updates-by-id" match="/c:updates/u:update" use="@id" />

  <xsl:template match="/">
    <html>

      <head>
        <title>Oracle Fusion Desktop Platform Update Center</title>
        <link rel="stylesheet" type="text/css" href="style.css" />
      </head>


      <body>
        <h1>Oracle Fusion Desktop Platform Update Center</h1>


        <p>Click on the id of an update to see available versions.</p>
 
        <table class="bordered" border="0" cellpadding="3" cellspacing="1">
          <tr>
            <th class="bordered">ID</th>
            <th class="bordered">Name</th>
            <th class="bordered">Author</th>
          </tr>

          <xsl:for-each select="/c:updates/u:update[count(. | key('updates-by-id', @id)[1]) = 1]">         
          <xsl:sort select="@id" />
            <tr>
              <td class="bordered0"><a href="#{@id}"><xsl:value-of select="@id" /></a></td>
              <td class="bordered0"><xsl:value-of select="u:name" /></td>
              <td class="bordered0">
              <xsl:element name="a">
                <xsl:attribute name="href"><xsl:value-of select="u:author-url" /></xsl:attribute>
                <xsl:value-of select="u:author" />
              </xsl:element>
              </td>
            </tr>
          </xsl:for-each>
        </table>

        <p /><p />

          <xsl:for-each select="/c:updates/u:update[count(. | key('updates-by-id', @id)[1]) = 1]">
            <xsl:sort select="@id" />
            <a name="{@id}"></a><h2>Details for <xsl:value-of select="u:name" /></h2>

            <p>
              <xsl:value-of select="u:description" />
            </p>

            <table class="bordered" border="0" cellpadding="3" cellspacing="1">
              <tr>
                <th class="bordered">Version</th>
                <th class="bordered">Requirements</th>
                <th class="bordered">Links</th>
              </tr>

              <xsl:for-each select="key('updates-by-id', @id)">
                <xsl:sort select="u:version" />

                <tr>
                  <td class="bordered0" valign="top"><xsl:value-of select="u:version" /></td>
                  <td class="bordered0" valign="top">
                    <xsl:for-each select="u:requirements/u:requires-extension">
                      <xsl:value-of select="@id" /> (min=<b><xsl:value-of select="@minVersion" /></b>, max=<b><xsl:value-of select="@maxVersion" /></b>)<br />
                    </xsl:for-each>
                  </td>
                  <td class="bordered0" valign="top">
                    <xsl:element name="a">
                      <xsl:attribute name="href"><xsl:value-of select="u:bundle-url" /></xsl:attribute>
                      Download</xsl:element>

                    <xsl:if test="boolean(u:requirements/u:requires-agreement)">
                      &#160;
                      <xsl:element name="a">
                        <xsl:attribute name="href"><xsl:value-of select="u:requirements/u:requires-agreement/@url" /></xsl:attribute>
                        License
                      </xsl:element>
                    </xsl:if>
                  </td>
                </tr>

              </xsl:for-each>

            </table>
          </xsl:for-each>

      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>
