<?xml version="1.0"?>
<!-- 
NAME
    kutsquo.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_tsquota_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    sdavid 11/02/05 - fix inconsistent stylesheet format 
    htseng 04/03/03 - fix bug 2884168 
    htseng 08/02/02 - add grantee parse param
    htseng 07/29/02 - add more parse params
    htseng 09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	05/29/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="TSQUOTA_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ALTER</xsl:with-param>
   <xsl:with-param name="ObjectType">TABLESPACE_QUOTA</xsl:with-param>
   <xsl:with-param name="Grantee" select="USER_NAME"/>
   <xsl:with-param name="Grantor" select="GRANTOR"/>
  </xsl:call-template>
  <xsl:text>DECLARE </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  TEMP_COUNT NUMBER; </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  SQLSTR VARCHAR2(200); </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>BEGIN </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  SQLSTR := 'ALTER USER </xsl:text>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Object" select="USER_NAME"/>
  </xsl:call-template>
  <xsl:choose>
   <xsl:when test="MAXBLOCKS= -1">
    <xsl:text> QUOTA UNLIMITED ON </xsl:text>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Object" select="TS_NAME"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> QUOTA </xsl:text>
    <xsl:value-of select="MAXBLOCKS * BLOCKSIZE"/>
    <xsl:text> ON </xsl:text>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Object" select="TS_NAME"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>';</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  EXECUTE IMMEDIATE SQLSTR;</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>EXCEPTION </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>  WHEN OTHERS THEN</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>    IF SQLCODE = -30041 THEN </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>      SQLSTR := 'SELECT COUNT(*) FROM USER_TABLESPACES </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>              WHERE TABLESPACE_NAME = ''</xsl:text>
  <xsl:value-of select="TS_NAME"/>
  <xsl:text>'' AND CONTENTS = ''TEMPORARY''';</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>      EXECUTE IMMEDIATE SQLSTR INTO TEMP_COUNT;</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>      IF TEMP_COUNT = 1 THEN RETURN; </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>      ELSE RAISE; </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>      END IF;</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>    ELSE</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>      RAISE;</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>    END IF;</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>END;</xsl:text>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
