<?xml version="1.0"?>
<!--
NAME
    kusrls.xsl
DESCRIPTION
    Convert mdapi RLS_POLICY_T document to RLS POLICY document (SXML)
    Convert mdapi RLS_GROUP_T document to RLS GROUP document (SXML)
    Convert mdapi RLS_CONTEXT_T document to RLS CONTEXT document (SXML)

MODIFIED        MM/DD/YY
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng     12/08/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <!-- *******************************************************************
Template: RLS_POLICY_T - top-level template for RLS_POLICY.
  This template puts out
   - the opening RLS_POLICY element (with xmlns and version attributes)
   - NAME elements

******************************************************************** -->
 <xsl:template match="RLS_POLICY_T">
  <xsl:element name="RLS_POLICY" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="SCHEMA">
    <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:value-of select="BASE_OBJ/NAME"/>
   </xsl:element>
   <xsl:element name="POLICY_GROUP">
    <xsl:value-of select="GNAME"/>
   </xsl:element>
   <xsl:element name="POLICY_NAME">
    <xsl:value-of select="NAME"/>
   </xsl:element>
   <xsl:element name="FUNCTION_SCHEMA">
    <xsl:value-of select="PFSCHMA"/>
   </xsl:element>
   <xsl:element name="POLICY_FUNCTION">
    <xsl:if test="PPNAME">
     <xsl:value-of select="PPNAME"/>
     <xsl:text>.</xsl:text>
    </xsl:if>
    <xsl:value-of select="PFNAME"/>
   </xsl:element>
   <xsl:element name="STATEMENT_TYPE_LIST">
    <!--
      The stmt_type uses 5 bits, values 2048, 8, 4, 2, and 1. These represent
      INDEX,DELETE,UPDATE,INSERT AND SELECT.
   -->
    <!-- If bit 2048 is set, is  'INDEX' -->
    <xsl:if test="STMT_TYPE >= 2048">
     <xsl:element name="STATEMENT_TYPE_LIST_ENTRY">
      <xsl:element name="NAME">
       <xsl:text>INDEX</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:if>
    <!-- If bit 8 is set, is 'DELETE'
  -->
    <xsl:if test="(STMT_TYPE mod 2048)>=8">
     <xsl:element name="STATEMENT_TYPE_LIST_ENTRY">
      <xsl:element name="NAME">
       <xsl:text>DELETE</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:if>
    <!-- If bit 4 is set, is 'UPDATE'
  -->
    <xsl:if test="(STMT_TYPE mod 8)>=4">
     <xsl:element name="STATEMENT_TYPE_LIST_ENTRY">
      <xsl:element name="NAME">
       <xsl:text>UPDATE</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:if>
    <!-- If bit 2 is set, is 'INSERT'
  -->
    <xsl:if test="(STMT_TYPE mod 4)>=2">
     <xsl:element name="STATEMENT_TYPE_LIST_ENTRY">
      <xsl:element name="NAME">
       <xsl:text>INSERT</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:if>
    <!-- If bit 1 is set, is 'SELECT'
  -->
    <xsl:if test="(STMT_TYPE mod 2)=1">
     <xsl:element name="STATEMENT_TYPE_LIST_ENTRY">
      <xsl:element name="NAME">
       <xsl:text>SELECT</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:if>
   </xsl:element>
   <xsl:element name="UPDATE_CHECK">
    <xsl:choose>
     <xsl:when test="CHECK_OPT = 1">
      <xsl:text>Y</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>N</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <xsl:element name="ENABLE">
    <xsl:choose>
     <xsl:when test="ENABLE_FLAG = 1">
      <xsl:text>Y</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>N</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <!-- static_policy will be ignored and overwritten by policy_type -->
   <xsl:element name="STATIC_POLICY">
    <xsl:text>N</xsl:text>
   </xsl:element>
   <xsl:element name="POLICY_TYPE">
    <xsl:value-of select="POLICY_TYPE"/>
   </xsl:element>
   <xsl:element name="LONG_PREDICATE">
    <xsl:choose>
     <xsl:when test="LONG_PRED = 512">
      <xsl:text>N</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>Y</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>
   <xsl:if test="REL_COLS/REL_COLS_ITEM">
    <xsl:element name="RELEVANT_COLUMN_LIST">
     <xsl:for-each select="REL_COLS/REL_COLS_ITEM">
      <xsl:element name="RELEVANT_COLUMN_LIST_ENTRY">
       <xsl:element name="NAME">
        <xsl:value-of select="SEC_REL_COL"/>
       </xsl:element>
      </xsl:element>
     </xsl:for-each>
    </xsl:element>
   </xsl:if>
   <!-- security relevant cols option -->
   <xsl:if test="REL_COLS_OPT = 4096">
    <xsl:element name="ALL_ROWS"/>
   </xsl:if>
  </xsl:element>
 </xsl:template>
 <!-- Template to recreate RLS_CONTEXT -->
 <xsl:template match="RLS_CONTEXT_T">
  <xsl:element name="RLS_CONTEXT" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="SCHEMA">
    <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:value-of select="BASE_OBJ/NAME"/>
   </xsl:element>
   <xsl:element name="NAMESPACE">
    <xsl:value-of select="NAME"/>
   </xsl:element>
   <xsl:element name="ATTRIBUTE">
    <xsl:value-of select="ATTR"/>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <!-- Template to recreate RLS_GROUP -->
 <xsl:template match="RLS_GROUP_T">
  <xsl:element name="RLS_GROUP" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="SCHEMA">
    <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:value-of select="BASE_OBJ/NAME"/>
   </xsl:element>
   <xsl:element name="POLICY_GROUP">
    <xsl:value-of select="NAME"/>
   </xsl:element>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
