<?xml version="1.0"?>
<!--
NAME
    kusctx.xsl
DESCRIPTION
    Convert mdapi CONTEXT_T document to CONTEXT document (SXML)

MODIFIED        MM/DD/YY
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    rapayne     11/03/05 - Bug 4715313: Reformat with XMLSpy
    htseng      12/06/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <!-- *******************************************************************
Template: CONTEXT_T - top-level template for CONTEXT.
  This template puts out
   - the opening CONTEXT element (with xmlns and version attributes)
   - NAME elements

******************************************************************** -->
 <xsl:template match="CONTEXT_T">
  <xsl:element name="CONTEXT" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="NAME">
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
   </xsl:element>
   <xsl:element name="PACKAGE">
    <xsl:element name="SCHEMA">
     <xsl:value-of select="SCHEMA_NAME"/>
    </xsl:element>
    <xsl:element name="NAME">
     <xsl:value-of select="PACKAGE_NAME"/>
    </xsl:element>
   </xsl:element>
   <xsl:choose>
    <xsl:when test="FLAGS=1">
     <xsl:element name="INITIALIZED">
      <xsl:text>EXTERNALLY</xsl:text>
     </xsl:element>
    </xsl:when>
    <xsl:when test="FLAGS=2">
     <xsl:element name="ACCESSED">
      <xsl:text>GLOBALLY</xsl:text>
     </xsl:element>
    </xsl:when>
    <xsl:when test="FLAGS=4">
     <xsl:element name="INITIALIZED">
      <xsl:text>GLOBALLY</xsl:text>
     </xsl:element>
    </xsl:when>
    <xsl:otherwise>
  </xsl:otherwise>
   </xsl:choose>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
