<?xml version="1.0"?>
<!-- 
NAME
    kuoutln.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_outline_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng      12/18/02 - add EXPORT parameter
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    lbarton     06/01/01 - remove oradb-style imports
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	06/23/00 - Support INSERT
    lbarton	07/24/00 - use uriref in import
    lbarton	06/02/00 - support parsing
    gclaborn	03/31/00 - created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="INSERT">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="OUTLINE_T">
  <xsl:choose>
   <xsl:when test="$INSERT=1">
    <xsl:call-template name="DoOutlineIns"/>
    <xsl:for-each select="HINTS/HINTS_ITEM">
     <xsl:call-template name="DoOutlineHint"/>
    </xsl:for-each>
    <xsl:for-each select="NODES/NODES_ITEM">
     <xsl:call-template name="DoOutlineNode"/>
    </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoOutlineCre"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <!-- generate INSERTs into OL$ -->
 <xsl:template name="DoOutlineIns">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">INSERT INTO OL$</xsl:with-param>
  </xsl:call-template>
  <xsl:text>INSERT INTO "OUTLN"."OL$" (</xsl:text>
  <xsl:text>"OL_NAME", "SQL_TEXT", "TEXTLEN", "SIGNATURE", </xsl:text>
  <xsl:text>"HASH_VALUE", "CATEGORY", "VERSION", "CREATOR",  </xsl:text>
  <xsl:text>"TIMESTAMP", "FLAGS", "HINTCOUNT") VALUES ('</xsl:text>
  <xsl:value-of select="NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="SQL_TEXT"/>
  <xsl:text>',</xsl:text>
  <xsl:value-of select="TEXTLEN"/>
  <xsl:text>,HEXTORAW('</xsl:text>
  <xsl:value-of select="SIGNATURE"/>
  <xsl:text>'),</xsl:text>
  <xsl:value-of select="HASH_VALUE"/>
  <xsl:text>,'</xsl:text>
  <xsl:value-of select="CATEGORY"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="VERSION"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="CREATOR"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="TIMESTAMP"/>
  <xsl:text>',</xsl:text>
  <xsl:value-of select="FLAGS"/>
  <xsl:text>,</xsl:text>
  <xsl:value-of select="HINTCOUNT"/>
  <xsl:text>)</xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
 </xsl:template>
 <!-- generate INSERTs into OL$HINTS -->
 <xsl:template name="DoOutlineHint">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">INSERT INTO OL$HINTS</xsl:with-param>
  </xsl:call-template>
  <xsl:text>INSERT INTO "OUTLN"."OL$HINTS" (</xsl:text>
  <xsl:text>"OL_NAME", "HINT#", "CATEGORY", "HINT_TYPE", </xsl:text>
  <xsl:text>"HINT_TEXT", "STAGE#", "NODE#", "TABLE_NAME", </xsl:text>
  <xsl:text>"TABLE_TIN", "TABLE_POS", "REF_ID", "USER_TABLE_NAME", </xsl:text>
  <xsl:text>"COST", "CARDINALITY", "BYTES", "HINT_TEXTOFF", </xsl:text>
  <xsl:text>"HINT_TEXTLEN", "JOIN_PRED") VALUES ('</xsl:text>
  <xsl:value-of select="NAME"/>
  <xsl:text>',</xsl:text>
  <xsl:value-of select="HINT"/>
  <xsl:text>,'</xsl:text>
  <xsl:value-of select="CATEGORY"/>
  <xsl:text>',</xsl:text>
  <xsl:value-of select="HINT_TYPE"/>
  <xsl:text>,'</xsl:text>
  <xsl:value-of select="HINT_TEXT"/>
  <xsl:text>',</xsl:text>
  <xsl:value-of select="STAGE"/>
  <xsl:text>,</xsl:text>
  <xsl:value-of select="NODE"/>
  <xsl:choose>
   <xsl:when test="TABLE_NAME">
    <xsl:text>,'</xsl:text>
    <xsl:value-of select="TABLE_NAME"/>
    <xsl:text>'</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="TABLE_TIN">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="TABLE_TIN"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="TABLE_POS">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="TABLE_POS"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="REF_ID">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="REF_ID"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="USER_TABLE_NAME">
    <xsl:text>,'</xsl:text>
    <xsl:value-of select="USER_TABLE_NAME"/>
    <xsl:text>'</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="COST">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="COST"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="CARDINALITY">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="CARDINALITY"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="BYTES">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="BYTES"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="HINT_TEXTOFF">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="HINT_TEXTOFF"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="HINT_TEXTLEN">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="HINT_TEXTLEN"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="JOIN_PRED">
    <xsl:text>,</xsl:text>
    <xsl:value-of select="JOIN_PRED"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>)</xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
 </xsl:template>
 <!-- generate INSERTs into OL$NODES -->
 <xsl:template name="DoOutlineNode">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">INSERT INTO OL$NODES</xsl:with-param>
  </xsl:call-template>
  <xsl:text>INSERT INTO "OUTLN"."OL$NODES" (</xsl:text>
  <xsl:text>"OL_NAME", "CATEGORY", "NODE_ID", "PARENT_ID", </xsl:text>
  <xsl:text>"NODE_TYPE", "NODE_TEXTLEN", "NODE_TEXTOFF") VALUES ('</xsl:text>
  <xsl:value-of select="NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="CATEGORY"/>
  <xsl:text>',</xsl:text>
  <xsl:value-of select="NODE"/>
  <xsl:text>,</xsl:text>
  <xsl:value-of select="PARENT"/>
  <xsl:text>,</xsl:text>
  <xsl:value-of select="NODE_TYPE"/>
  <xsl:text>,</xsl:text>
  <xsl:value-of select="NODE_TEXTLEN"/>
  <xsl:text>,</xsl:text>
  <xsl:value-of select="NODE_TEXTOFF"/>
  <xsl:text>)</xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
 </xsl:template>
 <!-- generate CREATE OUTLINE statement -->
 <xsl:template name="DoOutlineCre">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">OUTLINE</xsl:with-param>
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
  <xsl:text>CREATE </xsl:text>
  <xsl:if test="$EXPORT=0">
   <xsl:text>OR REPLACE </xsl:text>
  </xsl:if>
  <xsl:text>OUTLINE </xsl:text>
  <xsl:if test="substring(NAME,1,11)!='SYS_OUTLINE'">
   <xsl:value-of select="NAME"/>
   <xsl:text> </xsl:text>
  </xsl:if>
  <xsl:if test="substring(CATEGORY,1,7)!='DEFAULT'">
   <xsl:text>FOR CATEGORY </xsl:text>
   <xsl:value-of select="CATEGORY"/>
   <xsl:text> </xsl:text>
  </xsl:if>
  <xsl:text>ON </xsl:text>
  <!-- NOTE: For some reason, SQLPlus appends a line feed to the SQL text...
     We have to leave it.
 -->
  <xsl:value-of select="SQL_TEXT"/>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
