<?xml version="1.0"?>
<!-- 

 Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuiot.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of IOT ADTs
NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED	MM/DD/YY
    rapayne     12/06/08 - merge BLOCKSIZE logic for CM
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng      08/08/05 - bug 3560220: get correct behavior from processor 
    lbarton     05/09/05 - bug 4331909: use dataobj_num for OBJNO_REUSE in 
                           overflow seg 
    lbarton     05/21/04 - Bug 3617842: SAMPLE and PCTSPACE 
    lbarton     07/15/03 - Bug 3045654: nested table tablespace if vsn >= 10
    lbarton     06/04/03 - bug 2990330: for IOV supply obj# for transportable
    htseng      11/01/02 - temp disable nestead tablespace
    gclaborn    11/03/00 - change name
    lbarton	06/23/00 - Multinested collections
    lbarton	05/15/00 - Params for new API
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- primary key constraint for IOT -->
 <xsl:template match="PK_CON">
  <xsl:param name="InColList">0</xsl:param>
  <xsl:if test="$InColList=1">
   <xsl:text>, </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;	</xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- if not system-generated name, emit constraint name -->
  <xsl:if test="8>(FLAGS mod 16)">
   <xsl:text>CONSTRAINT "</xsl:text>
   <xsl:value-of select="NAME"/>
   <xsl:text>" </xsl:text>
  </xsl:if>
  <xsl:text>PRIMARY KEY (</xsl:text>
  <xsl:apply-templates select="COL_LIST">
   <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   <xsl:with-param name="DoLF">0</xsl:with-param>
   <xsl:with-param name="DoHidden">1</xsl:with-param>
  </xsl:apply-templates>
  <xsl:text>)</xsl:text>
  <!-- primary key & unique constraints
                            can't use NOVALIDATE. bug 573946 -->
  <xsl:apply-templates select="ENABLED">
   <xsl:with-param name="NOVALIDATE_OK">0</xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <!-- IOT overflow table -->
 <xsl:template name="DoIOV">
  <xsl:param name="Node" select="''"/>
  <xsl:param name="Nested">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <xsl:if test="($Node/INCLCOL_NAME)">
   <xsl:text> INCLUDING "</xsl:text>
   <xsl:value-of select="$Node/INCLCOL_NAME"/>
   <xsl:text>"</xsl:text>
  </xsl:if>
  <xsl:text> OVERFLOW</xsl:text>
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text> </xsl:text>
   <xsl:choose>
    <xsl:when test="($Node/PROPERTY mod 64)>=32">
     <!-- PIOT -->
     <xsl:call-template name="DoPIOTSegAttrs">
      <xsl:with-param name="Node" select="$Node/PART_OBJ/OVPARTOBJ"/>
     </xsl:call-template>
     <xsl:call-template name="DoPIOTLogging">
      <xsl:with-param name="Node" select="$Node/PART_OBJ/OVPARTOBJ"/>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:apply-templates select="$Node/IOV">
      <xsl:with-param name="Nested" select="$Nested"/>
      <xsl:with-param name="Pctspace" select="$Pctspace"/>
     </xsl:apply-templates>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template match="IOV">
  <xsl:param name="Nested">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <xsl:apply-templates select="PCT_FREE"/>
  <xsl:call-template name="DoLogging"/>
  <xsl:choose>
   <xsl:when test="DATAOBJ_NUM">
    <xsl:apply-templates select="STORAGE">
     <xsl:with-param name="Nested" select="$Nested"/>
     <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="DATAOBJ_NUM"/>
     <xsl:with-param name="Pctspace" select="$Pctspace"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:otherwise>
    <!-- An old Data Pump dump file may not have DATAOBJ_NUM.
         But sometimes OBJ_NUM will contain the same value.
         So use it as the value of Dataobjnum and hope we're lucky -->
    <xsl:apply-templates select="STORAGE">
     <xsl:with-param name="Nested" select="$Nested"/>
     <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="OBJ_NUM"/>
     <xsl:with-param name="Pctspace" select="$Pctspace"/>
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$VERSION>=1000000000 and $Nested='1'
                and string-length(TS_NAME)!=0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text> TABLESPACE "</xsl:text>
   <xsl:value-of select="TS_NAME"/>
   <xsl:text>" </xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
