<?xml version="1.0"?>
<!--
NAME
    kufull.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL full conversion of type_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    lbarton     07/07/03 - Bug 3016951: add TRANSPORTABLE param
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    lbarton     06/01/01 - remove oradb-style imports
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	07/24/00 - use uriref in import
    lbarton	06/02/00 - support parsing
    lbarton	05/15/00 - Params for new API
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kuproc.xsl"/>
 <xsl:import href="kutypspc.xsl"/>
 <xsl:import href="kubody.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="SPECIFICATION">1</xsl:param>
 <xsl:param name="BODY">1</xsl:param>
 <!-- OID, TIMESTAMP, TRANSPORTABLE are only for export -->
 <xsl:param name="OID">0</xsl:param>
 <xsl:param name="TIMESTAMP">0</xsl:param>
 <xsl:param name="TRANSPORTABLE">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="FULL_TYPE_T">
  <xsl:if test="$SPECIFICATION=1">
   <xsl:apply-templates select="TYPE_T"/>
  </xsl:if>
  <xsl:if test="$SPECIFICATION=1 and $BODY=1">
   <!-- insert LF between SQL statements -->
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:if test="$BODY=1">
   <xsl:apply-templates select="TYPE_BODY_T"/>
  </xsl:if>
 </xsl:template>
 <xsl:template match="FULL_PACKAGE_T">
  <xsl:if test="$SPECIFICATION=1">
   <xsl:apply-templates select="PACKAGE_T"/>
  </xsl:if>
  <!-- insert LF between SQL statements -->
  <xsl:if test="$SPECIFICATION=1 and $BODY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:if test="$BODY=1">
   <xsl:apply-templates select="PACKAGE_BODY_T"/>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
