<?xml version="1.0"?>
<!-- 
NAME
    kudvstam.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL 
    conversion of ku$_dv_isrm_t UDTs
    for the Import Staging Realm.

    Used when a schema is protected by the Database Vault Import Staging Realm 
    (such schema protection is referred to as "Staging Realm Membership").
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    pknaggs     05/15/08 - bug 6938028: Database Vault Protected Schema.
    pknaggs     04/15/08 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import the kucommon.xsl script, otherwise this template will never get invoked. See line 43 in kucommon.xsl, where the comment is "Top level template for all objects", this is the xsl equivalent of 'main'.  -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- Parameters required for DoParse to function correctly. -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param> 
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <!-- Template to create a new Database Vault Import Staging Realm Membership -->
 <xsl:template match="DVPS_STAGING_REALM_MEMBERSHP_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_MACADM</xsl:with-param>
   <xsl:with-param name="ObjectType">DVPS_STAGING_REALM_MEMBERSHIP</xsl:with-param>
  </xsl:call-template>      
  <xsl:text>BEGIN DVSYS.DBMS_MACADM.ADD_OBJECT_TO_REALM(realm_name => 'Datapump Import Staging Realm for Database Vault', object_owner => </xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="SCHEMA_NAME"/>
   <xsl:with-param name="Leading">'</xsl:with-param>
   <xsl:with-param name="Trailing">'</xsl:with-param>
   <xsl:with-param name="NullVal">NULL</xsl:with-param>
  </xsl:call-template>
  <xsl:text>, object_name => '%', object_type => '%'); END;</xsl:text>
  <!-- Terminate inner SQL statement -->
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
