<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuacomm.xsl
DESCRIPTION 
    XSLT stylesheet: common templates for SXML => ALTER_XML conversions
    This stylesheet imports kuscommc.xsl, common templates for both
    this and SXML => DDL conversions
MODIFIED        MM/DD/YY
    abodge      09/06/11 - Bug 12953548: obj type missing for COMMENT ON
    abodge      08/19/11 - Fix bug 12875146 - column comments
    abodge      06/16/11 - Implement EMIT_SCHEMA transform param
    abodge      05/17/11 - Alter Comments
    lbarton     07/08/08 - bug 5709159: UnquotedSourceName
    lbarton     01/24/08 - Bug 6724820: move VERSION param to kuscommc.xsl
    rapayne     12/21/06 - add AlterCOL_LIST template
    lbarton     09/22/06 - parse item support
    rapayne     06/09/06 - Add CmpObjects template.
    rapayne     05/24/06 - creation.
-->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommc.xsl"/>
 <!-- Parameters referenced by imported templates. They are never set
      by the ALTERXML transform, but they must be defined and have
      the specified values. -->
 <xsl:param name="PRETTY">0</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="EMIT_SCHEMA">1</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="PARTITIONING">1</xsl:param>
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="REF_CONSTRAINTS">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_XPATH">0</xsl:param>
 <xsl:param name="PRS_XPATH_NS">sxml:</xsl:param>
 <!-- templates -->
 <xsl:template match="/">
 <!-- *******************************************************************
Top level template for all objects
******************************************************************** -->
  <xsl:apply-templates/>
 </xsl:template>
 <xsl:template name="Object1">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: Object1
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:element name="OBJECT1">
   <xsl:call-template name="ObjectSchemaName">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="ObjectNumber">1</xsl:with-param>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="Object2">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: Object2
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <xsl:element name="OBJECT2">
   <xsl:call-template name="ObjectSchemaName">
    <xsl:with-param name="ParentNode" select="$ParentNode"/>
    <xsl:with-param name="ObjectNumber">2</xsl:with-param>
   </xsl:call-template>
  </xsl:element>
 </xsl:template>
 <xsl:template name="CmpObjects">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template:  CmpObjects
Parameters:
 ParentNode - Parent node of SCHEMA, NAME for both object 1
                       and object2.
******************************************************************** -->
  <!-- Object 1 -->
  <xsl:call-template name="Object1">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <!-- Object 2 -->
  <xsl:call-template name="Object2">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="ObjectSchemaName">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjectNumber">1</xsl:param>
  <!-- *******************************************************************
Template: ObjectSchemaName
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
 ObjectNumber - 1 (default) or 2
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:SCHEMA">
   <xsl:element name="SCHEMA">
    <xsl:apply-templates select="$ParentNode/sxml:SCHEMA">
     <xsl:with-param name="ObjectNumber" select="$ObjectNumber"/>
    </xsl:apply-templates>
   </xsl:element>
  </xsl:if>
  <xsl:element name="NAME">
   <xsl:apply-templates select="$ParentNode/sxml:NAME">
    <xsl:with-param name="ObjectNumber" select="$ObjectNumber"/>
   </xsl:apply-templates>
  </xsl:element>
 </xsl:template>
 <xsl:template match="sxml:SCHEMA | sxml:NAME">
  <xsl:param name="ObjectNumber">1</xsl:param>
  <!-- *******************************************************************
Template: SCHEMA | NAME
Parameters:
 ObjectNumber - 1 (default) or 2
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$ObjectNumber=1 and @value1">
    <xsl:value-of select="@value1"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="."/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="SchemaName">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: SchemaName
 This template puts out "<schema>"."<name>"
Parameters:
 ParentNode - parent of SCHEMA and NAME
******************************************************************** -->
  <xsl:if test="$EMIT_SCHEMA=1 and $ParentNode/sxml:SCHEMA">
   <xsl:call-template name="SourceName">
    <xsl:with-param name="NameNode" select="$ParentNode/sxml:SCHEMA"/>
   </xsl:call-template>
   <xsl:text>.</xsl:text>
  </xsl:if>
  <xsl:call-template name="SourceName">
   <xsl:with-param name="NameNode" select="$ParentNode/sxml:NAME"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="SourceName">
  <xsl:param name="NameNode" select="''"/>
  <!-- *******************************************************************
Template: SourceName: emit the source name or schema.
 The schema/name values are from the value1 attribute, if present,
 otherwise the element content.  This lets the template handle the
 case of comparing object1 and object2 where the objects have different
 names or schemas.  The alter templates should always generate ALTERs
 to object1.  But if the objects have different names or schemas,
 object1's name and schema are in the value1 attribute rather than the
 element content, e.g.,
      <NAME value1="EMP1">EMP2</NAME>
Parameters:
 NameNode - NAME or SCHEMA node
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$NameNode/@value1">
    <xsl:call-template name="QuotedName">
     <xsl:with-param name="NameNode" select="$NameNode/@value1"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="QuotedName">
     <xsl:with-param name="NameNode" select="$NameNode"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="UnquotedSourceName">
  <xsl:param name="NameNode" select="''"/>
  <!-- *******************************************************************
Template: UnquotedSourceName: Like "SourceName" except the quotes are
 omitted.
Parameters:
 NameNode - NAME or SCHEMA node
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$NameNode/@value1">
    <xsl:value-of select="$NameNode/@value1"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$NameNode"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="QuotedName">
  <xsl:param name="NameNode" select="''"/>
  <!-- *******************************************************************
Template: QuotedName
Parameters:
 NameNode - NAME node
******************************************************************** -->
  <xsl:if test="(not(contains($NameNode,'&quot;')))">"</xsl:if>
  <xsl:value-of select="$NameNode"/>
  <xsl:if test="(not(contains($NameNode,'&quot;')))">"</xsl:if>
 </xsl:template>
 <xsl:template name="AddParseItem">
  <xsl:param name="ParseIt">0</xsl:param>
  <xsl:param name="Item" select="''"/>
  <xsl:param name="Value1" select="''"/>
  <xsl:param name="Value2" select="''"/>
  <xsl:param name="Value3" select="''"/>
  <xsl:param name="Value4" select="''"/>
  <xsl:param name="Value5" select="''"/>
  <xsl:param name="Value6" select="''"/>
  <xsl:param name="Value7" select="''"/>
  <!-- *******************************************************************
Template: AddParseItem
Parameters:
 ParseIt : 1 = generate the parse item
 Item    : Item name
 Value1  : value
 Value2-7: if defined, these values are appended (space-separated) to Value1
******************************************************************** -->
  <xsl:if test="$ParseIt=1 and (string-length($Value1)!=0 or
                                string-length($Value2)!=0 or
                                string-length($Value3)!=0 or
                                string-length($Value4)!=0 or
                                string-length($Value5)!=0 or
                                string-length($Value6)!=0 or
                                string-length($Value7)!=0)">
   <xsl:element name="PARSE_LIST_ITEM">
    <xsl:element name="ITEM">
     <xsl:value-of select="$Item"/>
    </xsl:element>
    <xsl:element name="VALUE">
     <xsl:if test="string-length($Value1)!=0">
      <xsl:value-of select="$Value1"/>
     </xsl:if>
     <xsl:if test="string-length($Value2)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value2"/>
     </xsl:if>
     <xsl:if test="string-length($Value3)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value3"/>
     </xsl:if>
     <xsl:if test="string-length($Value4)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value4"/>
     </xsl:if>
     <xsl:if test="string-length($Value5)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value5"/>
     </xsl:if>
     <xsl:if test="string-length($Value6)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value6"/>
     </xsl:if>
     <xsl:if test="string-length($Value7)!=0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$Value7"/>
     </xsl:if>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AddXPathParseItem">
  <xsl:param name="Node" select="''"/>
  <!-- *******************************************************************
Template: AddXPathParseItem
Parameters:
 Node - Node whose XPath we generate
******************************************************************** -->
  <xsl:if test="$PRS_XPATH=1">
   <xsl:element name="PARSE_LIST_ITEM">
    <xsl:element name="ITEM">XPATH</xsl:element>
    <xsl:element name="VALUE">
     <xsl:call-template name="GenXPath">
      <xsl:with-param name="Node" select="$Node"/>
     </xsl:call-template>
    </xsl:element>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template name="GenXPath">
  <xsl:param name="Node" select="''"/>
  <!-- *******************************************************************
Template: GenXPath - recursive template to generate XPath
Parameters:
 Node - current node
******************************************************************** -->
  <!-- In Oracle C-based XSL parser, the local name of the document root node
     is '#document' -->
  <xsl:if test="string-length(local-name($Node))!=0 and local-name($Node)!='#document'">
   <xsl:call-template name="GenXPath">
    <xsl:with-param name="Node" select="$Node/parent::node()"/>
   </xsl:call-template>
   <xsl:text>/</xsl:text>
   <xsl:value-of select="$PRS_XPATH_NS"/>
   <xsl:value-of select="local-name($Node)"/>
   <xsl:variable name="thisPosition" select="count($Node/preceding-sibling::*[name($Node)=name()])"/>
   <xsl:variable name="numFollowing" select="count($Node/following-sibling::*[name($Node)=name()])"/>
   <xsl:if test="$thisPosition+$numFollowing &gt; 0">
    <xsl:value-of select="concat('[',$thisPosition+1,']')"/>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="AlterCOL_LIST">
  <xsl:param name="ColListItems" select="''"/>
  <!-- ***********************
Template: AlterCOL_LIST 
Parameters:
ColListItems - COL_LIST_ITEM nodes
******************************************************************** -->
  <xsl:for-each select="$ColListItems">
   <xsl:choose>
    <xsl:when test="@src='1'"/>
    <xsl:otherwise>
     <xsl:if test="position()!=1">
      <!-- to avoid the last item is @src='1' -->
      <xsl:text>,</xsl:text>
     </xsl:if>
     <xsl:call-template name="QuotedName">
      <xsl:with-param name="NameNode" select="sxml:NAME"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="CommonNotAlterable">
  <xsl:param name="NameParent" select="''"/>
  <xsl:param name="Reason" select="''"/>
  <!-- *******************************************************************
Template: CommonNotAlterable
Parameters:
 NameParent
 Reason:   
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:element name="PARSE_LIST">
    <xsl:call-template name="AddXPathParseItem">
     <xsl:with-param name="Node" select="$NameParent"/>
    </xsl:call-template>
    <xsl:if test="$NameParent/sxml:NAME">
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$NameParent/sxml:NAME"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="AddParseItem">
     <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
     <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
     <xsl:with-param name="Value1" select="$Reason"/>
    </xsl:call-template>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterComments">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="ObjectType" select="'TABLE'"/>
  <!-- *******************************************************************
Template: AlterComments
 This template puts out COMMENT ON Alter XML
Parameters:
 ParentNode - parent of COMMENTS
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:COMMENTS/sxml:OBJECT_COMMENT[@src='1']">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Comment" select="''"/>
     <xsl:with-param name="ObjectType" select="$ObjectType"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Comment" select="''"/>
     <xsl:with-param name="ObjectType" select="$ObjectType"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:COMMENTS/sxml:OBJECT_COMMENT[@src='2']">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Comment" select="$ParentNode/sxml:COMMENTS/sxml:OBJECT_COMMENT[@src='2']"/>
     <xsl:with-param name="ObjectType" select="$ObjectType"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Comment" select="$ParentNode/sxml:COMMENTS/sxml:OBJECT_COMMENT[@src='2']"/>
     <xsl:with-param name="ObjectType" select="$ObjectType"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <xsl:if test="$ParentNode/sxml:COMMENTS/sxml:OBJECT_COMMENT[@value1]">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Comment" select="$ParentNode/sxml:COMMENTS/sxml:OBJECT_COMMENT[@value1]"/>
     <xsl:with-param name="ObjectType" select="$ObjectType"/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="Comment" select="$ParentNode/sxml:COMMENTS/sxml:OBJECT_COMMENT[@value1]"/>
     <xsl:with-param name="ObjectType" select="$ObjectType"/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <xsl:for-each select="$ParentNode/sxml:COMMENTS/sxml:COLUMN_COMMENT[@src='1']">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ColCommentNode" select="."/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
     <xsl:with-param name="Comment" select="''"/>
    </xsl:call-template>
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ColCommentNode" select="."/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
     <xsl:with-param name="Comment" select="''"/>
    </xsl:call-template>
   </xsl:element>
  </xsl:for-each>
  <xsl:for-each select="$ParentNode/sxml:COMMENTS/sxml:COLUMN_COMMENT[@src='2']">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ColCommentNode" select="."/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
     <xsl:with-param name="Comment" select="sxml:COMMENT"/>
    </xsl:call-template>
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ColCommentNode" select="."/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
     <xsl:with-param name="Comment" select="sxml:COMMENT"/>
    </xsl:call-template>
   </xsl:element>
  </xsl:for-each>
  <xsl:for-each select="$ParentNode/sxml:COMMENTS/sxml:COLUMN_COMMENT/sxml:COMMENT[@value1]">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ColCommentNode" select=".."/>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
     <xsl:with-param name="Comment" select="."/>
    </xsl:call-template>
    <xsl:call-template name="AddComment">
     <xsl:with-param name="ParentNode" select="$ParentNode"/>
     <xsl:with-param name="ColCommentNode" select=".."/>
     <xsl:with-param name="Action">SQL</xsl:with-param>
     <xsl:with-param name="Comment" select="."/>
    </xsl:call-template>
   </xsl:element>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="AddComment">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Comment" select="''"/>
  <xsl:param name="ColCommentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <xsl:param name="ObjectType" select="''"/>
  <!-- *******************************************************************
Template: AddComment
Parameters:
 ParentNode - Parent node of SCHEMA, NAME, COMMENTS
 Comment - Text of comment
 ColCommentNode - COLUMN_COMMENT node (for column comments)
 ObjectType - Type of object (TABLE or MATERIALIZED VIEW)
 Action = "PARSE" or "SQL"
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:choose>
      <xsl:when test="$ColCommentNode">
       <xsl:call-template name="AddXPathParseItem">
        <xsl:with-param name="Node" select="$ColCommentNode"/>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="AddXPathParseItem">
        <xsl:with-param name="Node" select="$ParentNode/sxml:COMMENTS/sxml:OBJECT_COMMENT"/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ADD_COMMENT</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>COMMENT ON </xsl:text>
       <xsl:choose>
        <xsl:when test="$ColCommentNode">
         <xsl:text>COLUMN </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$ParentNode"/>
         </xsl:call-template>
         <xsl:text>.</xsl:text>
         <xsl:call-template name="QuotedName">
          <xsl:with-param name="NameNode" select="$ColCommentNode/sxml:COL_LIST_ITEM"/>
         </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="$ObjectType"/>
         <xsl:text> </xsl:text>
         <xsl:call-template name="SchemaName">
          <xsl:with-param name="ParentNode" select="$ParentNode"/>
         </xsl:call-template>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:text> IS '</xsl:text>
       <xsl:value-of select="$Comment"/>
       <xsl:text>'</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>

 </xsl:template>

</xsl:stylesheet>
