<?xml version="1.0"?>
<!--
NAME
    kuaclus.xsl
DESCRIPTION
    Convert sxml CLUSTER diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    abodge       06/29/12 - Fix xmlns attribute problem
    lbarton      07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    rapayne      07/05/07 - bug 6031401: make column diffs  not_alterable.
    rapayne      06/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kuatprop.xsl"/>
 <!-- params for parse -->
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_CLAUSE_TYPE">0</xsl:param>
 <xsl:param name="PRS_COLUMN_ATTRIBUTE">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:CLUSTER">
  <xsl:element name="ALTER_XML" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">CLUSTER</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2 -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Start alter list -->
   <xsl:element name="ALTER_LIST">
    <!-- Check NAME - rename is not allowed so mark as not_alterable -->
    <xsl:if test="./sxml:NAME[@value1]">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="NameParent" select="./sxml:NAME"/>
      <xsl:with-param name="Reason">RENAME_CLUSTER</xsl:with-param>
     </xsl:call-template>
    </xsl:if>
    <!-- Check COL_LIST - any diffs are marked as not_alterable -->
    <xsl:for-each select="sxml:COL_LIST/sxml:COL_LIST_ITEM">
     <xsl:if test="./@src or sxml:NAME/@value1">
      <xsl:choose>
       <xsl:when test="./@src=2">
        <xsl:call-template name="CommonNotAlterable">
         <xsl:with-param name="NameParent" select="."/>
         <xsl:with-param name="Reason">ADD_COLUMN</xsl:with-param>
        </xsl:call-template>
       </xsl:when>
       <xsl:when test="./@src=1">
        <xsl:call-template name="CommonNotAlterable">
         <xsl:with-param name="NameParent" select="."/>
         <xsl:with-param name="Reason">DELETE_COLUMN</xsl:with-param>
        </xsl:call-template>
       </xsl:when>
       <xsl:otherwise>
        <xsl:call-template name="CommonNotAlterable">
         <xsl:with-param name="NameParent" select="."/>
         <xsl:with-param name="Reason">MODIFY_COLUMN</xsl:with-param>
        </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:if>
    </xsl:for-each>
    <!-- Check PhysicalAttributes-->
    <xsl:if test="./sxml:PCTUSED/@value1 or
     ./sxml:PCTFREE/@value1 or
  ./sxml:INITRANS/@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterClusterAttr">
       <xsl:with-param name="ClusterNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterClusterAttr">
       <xsl:with-param name="ClusterNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <!-- Check CACHE -->
    <xsl:if test="./sxml:CACHE/@src">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterCache">
       <xsl:with-param name="ClusterNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterCache">
       <xsl:with-param name="ClusterNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
    <!-- Check SIZE: can not alter size for HASH CLUSTERS -->
    <xsl:if test="./sxml:SIZE/@src or
        ./sxml:SIZE/@value1">
     <xsl:choose>
      <xsl:when test="./sxml:HASHKEYS">
       <xsl:call-template name="CommonNotAlterable">
        <xsl:with-param name="NameParent" select="./sxml:SIZE"/>
        <xsl:with-param name="Reason">SIZE_ON_HASH_CLUSTER</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
       <xsl:element name="ALTER_LIST_ITEM">
        <xsl:call-template name="AlterSize">
         <xsl:with-param name="ClusterNode" select="."/>
         <xsl:with-param name="SizeNode" select="./sxml:SIZE"/>
         <xsl:with-param name="Action">PARSE</xsl:with-param>
        </xsl:call-template>
        <xsl:call-template name="AlterSize">
         <xsl:with-param name="ClusterNode" select="."/>
         <xsl:with-param name="SizeNode" select="./sxml:SIZE"/>
         <xsl:with-param name="Action">SQL</xsl:with-param>
        </xsl:call-template>
       </xsl:element>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>
    <!-- Check PARALLEL -->
    <xsl:if test="./sxml:PARALLEL/@src or
        ./sxml:PARALLEL_DEGREE/@src or
        ./sxml:PARALLEL_DEGREE/sxml:DEGREE/@value1 or
        .//sxml:PARALLEL_DEGREE/sxml:INSTANCES/@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterParallel">
       <xsl:with-param name="ParallelNode" select="./sxml:PARALLEL_DEGREE"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterParallel">
       <xsl:with-param name="ParallelNode" select="./sxml:PARALLEL_DEGREE"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:if>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="CommonNotAlterable">
  <xsl:param name="NameParent" select="''"/>
  <xsl:param name="Reason" select="''"/>
  <!-- *******************************************************************
Template: CommonNotAlterable
Parameters:
 NameParent
 Reason:   
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:element name="PARSE_LIST">
    <xsl:call-template name="AddXPathParseItem">
     <xsl:with-param name="Node" select="$NameParent"/>
    </xsl:call-template>
    <xsl:if test="$NameParent/sxml:NAME">
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="$NameParent/sxml:NAME"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="AddParseItem">
     <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
     <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
     <xsl:with-param name="Value1" select="$Reason"/>
    </xsl:call-template>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterClusterAttr">
  <xsl:param name="ClusterNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterClusterAttr - modify the cluster attributes:
    PCTFREE
    PCTUSED 
    INITRANS
    storage_clause
Parameters:
 ClusterNode
Action - PARSE or SQL 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ClusterNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
      <xsl:with-param name="Item">NAME</xsl:with-param>
      <xsl:with-param name="Value1" select="sxml:NAME"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">CLUSTER_PHYSATTR</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER CLUSTER </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ClusterNode"/>
       </xsl:call-template>
       <xsl:call-template name="AlterPhysicalAttributes">
        <xsl:with-param name="ParentNode" select="$ClusterNode"/>
        <xsl:with-param name="TypeNode">MODIFY</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterCache">
  <xsl:param name="ClusterNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterCache - modify the CACHE attribute
Parameters:
 ClusterNode
 Action - PARSE or SQL 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ClusterNode/sxml:CACHE"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">CLUSTER_CACHE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER CLUSTER </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ClusterNode"/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$ClusterNode/sxml:CACHE/@src='1'">
         <xsl:text> NOCACHE </xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text> CACHE </xsl:text>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterSize">
  <xsl:param name="ClusterNode" select="''"/>
  <xsl:param name="SizeNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterSize- modify the SIZE attribute. 
     This is not allowed for HASH CLUSTERs
Parameters:
 ClusterNode
 SizeNode
 Action - PARSE or SQL 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$SizeNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">CLUSTER_SIZE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER CLUSTER </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$ClusterNode"/>
       </xsl:call-template>
       <xsl:text> SIZE  </xsl:text>
       <xsl:value-of select="$SizeNode"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterParallel">
  <xsl:param name="ParallelNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterParallel - modify the PARALLEL attribute
Parameters:
 ParallelNode
 Action - PARSE or SQL 
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_COLUMN_ATTRIBUTE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParallelNode"/>
     </xsl:call-template>
     <xsl:choose>
      <xsl:when test="$ParallelNode/@src='2'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">ADD_PARALLEL</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$ParallelNode/@src='1'">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">REMOVE_PARALLEL</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$ParallelNode/sxml:DEGREE/@value1">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
        <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
        <xsl:with-param name="Value1">MODIFY_PARALLEL</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
      <xsl:when test="$ParallelNode/sxml:INSTANCES/@value1">
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
        <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
        <xsl:with-param name="Value1">PARALLEL_INSTANCES</xsl:with-param>
       </xsl:call-template>
      </xsl:when>
     </xsl:choose>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER CLUSTER </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="."/>
       </xsl:call-template>
       <xsl:choose>
        <xsl:when test="$ParallelNode/@src='2' or $ParallelNode/sxml:DEGREE/@value1">
         <xsl:text> PARALLEL </xsl:text>
         <xsl:value-of select="$ParallelNode/sxml:DEGREE"/>
        </xsl:when>
        <xsl:when test="$ParallelNode/@src='1'">
         <xsl:text> NOPARALLEL</xsl:text>
        </xsl:when>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
