<?xml version="1.0" ?>
<!-- 
NAME
    knfcf1.xsl - replication Flavor Column Filtering script #1

DESCRIPTION
    XSLT stylesheet for filtering out columns that aren't in
    a given list from a table or index.
    FILTER_COLUMNS contains the list of columns to include.
    Any columns not in FILTER_COLUMNS will be removed.
    Any constraints containing one or more columns not in FILTER_COLUMNS
      will be removed. This xsl script tags constraints with columns
      not in FILTER_COLUMNS with DELETE_FLAVOR_COLUMNS. replfcf2.xsl
      must then be called to remove the constraints.

NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED	MM/DD/YY
    elu         05/01/01 - add support for partitions
    gclaborn    11/06/00 - Add no modify comment; change name
    elu 	08/14/00 - Created.
 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:param name="FILTER_COLUMNS"/>
<xsl:param name="FILTER_NT_STORE"/>

<!-- copy everything from the input file -->
<xsl:template match="@*|node()">
 <xsl:copy>
  <xsl:apply-templates select="@*|node()"/>
 </xsl:copy>
</xsl:template>

<!-- filter out columns in index not in list -->
<xsl:template match="INDEX_T/COL_LIST/COL_LIST_ITEM
                [not(contains($FILTER_COLUMNS,concat(',',COL/COL_NUM,',')))]"/>

<!-- filter out columns in table not in list -->
<xsl:template match="TABLE_T/COL_LIST/COL_LIST_ITEM
                    [not(contains($FILTER_COLUMNS,concat(',',COL_NUM,',')))]"/>


<!-- filter out scope for pkref columns not in list -->
<xsl:template match="TABLE_T/PKREF_LIST/PKREF_LIST_ITEM
                    [not(contains($FILTER_COLUMNS,concat(',',COL_NUM,',')))]"/>

<!-- filter out storage tables not in list -->
<xsl:template match="NTS_ITEM
                  [not(contains($FILTER_NT_STORE,concat(',',NTAB_NUM,',')))]"/>

<!-- mark partitions containing columns not in list (these will be 
     deleteed by replfcf2.xsl-->
<xsl:template 
       match="TABLE_T/PART_OBJ/PARTCOLS/PARTCOLS_ITEM/COL">
  <xsl:copy>
  <xsl:if test = "not(contains($FILTER_COLUMNS, concat(',', COL_NUM, ',')))">
   <DELETE_FLAVOR_COLUMN/>
  </xsl:if>
  <xsl:apply-templates select="@*|node()"/>
 </xsl:copy>
</xsl:template>

<xsl:template 
       match="TABLE_T/PART_OBJ/SUBPARTCOLS/SUBPARTCOLS_ITEM/COL">
  <xsl:copy>
  <xsl:if test = "not(contains($FILTER_COLUMNS, concat(',', COL_NUM, ',')))">
   <DELETE_FLAVOR_COLUMN/>
  </xsl:if>
  <xsl:apply-templates select="@*|node()"/>
 </xsl:copy>
</xsl:template>

<!-- mark constraints containing columns not in list (these will be 
     deleted by replfcf2.xsl)
 -->
<xsl:template 
       match="TABLE_T/CON1_LIST/CON1_LIST_ITEM/IND/COL_LIST/COL_LIST_ITEM/COL">
  <xsl:copy>
  <xsl:if test = "not(contains($FILTER_COLUMNS, concat(',', COL_NUM, ',')))">
   <DELETE_FLAVOR_COLUMN/>
  </xsl:if>
  <xsl:apply-templates select="@*|node()"/>
 </xsl:copy>
</xsl:template>

<xsl:template 
           match="TABLE_T/CON1_LIST/CON1_LIST_ITEM/COL_LIST/COL_LIST_ITEM/COL">
  <xsl:copy>
  <xsl:if test = "not(contains($FILTER_COLUMNS, concat(',', COL_NUM, ',')))">
   <DELETE_FLAVOR_COLUMN/>
  </xsl:if>
  <xsl:apply-templates select="@*|node()"/>
 </xsl:copy>
</xsl:template>

<xsl:template 
   match="TABLE_T/CON2_LIST/CON2_LIST_ITEM/SRC_COL_LIST/SRC_COL_LIST_ITEM/COL">
  <xsl:copy>
  <xsl:if test = "not(contains($FILTER_COLUMNS, concat(',', COL_NUM, ',')))">
   <DELETE_FLAVOR_COLUMN/>
  </xsl:if>
  <xsl:apply-templates select="@*|node()"/>
 </xsl:copy>
</xsl:template>

</xsl:stylesheet>

