<?xml version="1.0" ?>
<!--
NAME
    cmkuview.xsl
DESCRIPTION
    Convert mdapi VIEW_T document to VIEW document (editable XML)

MODIFIED    MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    xshen       03/08/05 - fix schema mapping
    lhan        10/07/04 - incorporate TEXTVCNT
    ngade       08/11/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>
<xsl:import href="cmkuobjtbl.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="VIEW_T">
  <VIEW>
    <!-- schemaName -->
    <xsl:call-template name="DoSchemaWithMapping">
      <xsl:with-param name="CurrentSchema" select="SCHEMA_OBJ/OWNER_NAME"/>
    </xsl:call-template>

    <!-- name -->
    <NAME>
      <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    </NAME> 
    <!-- status -->
    <xsl:choose>
      <xsl:when test="SCHEMA_OBJ/STATUS = 1">
        <STATUS>
          <xsl:text>VALID</xsl:text>
        </STATUS>
      </xsl:when>
      <xsl:otherwise>
        <STATUS>
          <xsl:text>INVALID</xsl:text>
        </STATUS>
      </xsl:otherwise>
    </xsl:choose>
    <!-- query text -->
    <xsl:element name="TEXT">
     <xsl:choose>
      <xsl:when test="TEXTVCNT">
       <xsl:for-each select="TEXTVCNT/TEXTVCNT_ITEM">
        <xsl:value-of select="."/>
       </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="TEXT"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:element>
    <!-- constraint name -->
    <xsl:choose>	
      <xsl:when test="(WITH_OPTION/FLAGS mod 16)>=8"/>
       <xsl:otherwise>
        <xsl:if test="string-length(WITH_OPTION/NAME)!=0">
          <CONSTRAINT>    
            <xsl:value-of select="WITH_OPTION/NAME"/>
          </CONSTRAINT>      
        </xsl:if>
      </xsl:otherwise>      
    </xsl:choose>  
    <!-- XMLschema object tables -->
    <xsl:if test="NAME='XMLTYPE' and OWNER_NAME='SYS' and
        COL_LIST2/COL_LIST2_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT">
     <xsl:apply-templates select="COL_LIST2/COL_LIST2_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT"/>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="(PROPERTY mod 2)>=1">  <!-- object view -->
        <xsl:if test='string-length(OWNER_NAME)!=0'>
          <OBJECT_TYPE_SCHEMA>
             <xsl:choose>
               <xsl:when test="$SCHEMA_MAP=1 and (OWNER_NAME=$R_SCHEMA)">
                 <xsl:value-of select="$L_SCHEMA"/>
               </xsl:when>
               <xsl:otherwise>
                 <xsl:value-of select="OWNER_NAME"/>
               </xsl:otherwise>
             </xsl:choose>
          </OBJECT_TYPE_SCHEMA>
        </xsl:if>
        <xsl:if test='string-length(NAME)!=0'>
        <OBJECT_TYPE_NAME>
          <xsl:value-of select="NAME"/>
          </OBJECT_TYPE_NAME>
        </xsl:if>
        <xsl:if test="OIDTEXTLENGTH > 0">
          <OBJECT_IDENTIFIER>
            <xsl:value-of select="OIDTEXT"/>
          </OBJECT_IDENTIFIER>
      </xsl:if>
      </xsl:when>
      <xsl:otherwise test="COL_LIST/COL_LIST_ITEM[COL_NUM=1]"> <!-- relational view -->
        <ALIAS>
          <xsl:for-each select="COL_LIST/COL_LIST_ITEM">
          <xsl:sort select="NAME"/>
            <xsl:if test="position()!=1">
              <xsl:text>,</xsl:text>
            </xsl:if>
            <xsl:text>"</xsl:text>                        
            <xsl:value-of select="current()/NAME"/>
            <xsl:text>"</xsl:text>                        
            <xsl:if test="position()=last()">
              <xsl:text></xsl:text>
            </xsl:if>
          </xsl:for-each>
        </ALIAS>
      </xsl:otherwise>
    </xsl:choose>    
  </VIEW>
</xsl:template>
</xsl:stylesheet>
