<?xml version="1.0" ?>
<!--
NAME
    cmkustorage.xsl
DESCRIPTION
    XSLT stylesheet for XML => CMXML conversion of storage attributes

MODIFIED        MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    xshen       07/08/05 - partition fix 
    xshen       02/23/05 - add deprecated to monitoring 
    ngade       10/28/04 - fix optimal for rollback segment.
    lhan        10/08/04 - treat pct as part of physical attr
    lhan        10/04/04 - handle partitioned iots
    xshen       09/22/04 - add compare options
    lhan        08/20/04 - modify doparallel
    lhan        08/11/04 - 
    ngade       08/09/04 - 
    lhan        08/03/04 - index support
    ngade       08/02/04 - change DoStorage
    lhan        07/30/04 - 
    lhan        07/21/04 - more segment attr
    lhan        07/12/04 - lhan_xsl_0712
    lhan        07/12/04 - initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="DoSegmentAttributes">
 <xsl:param name="ParentNode" select="''"/>
 <xsl:param name="PartObj" select="0"/>

 <SEGMENT_ATTRIBUTES>
 <xsl:call-template name="DoPCT">
  <xsl:with-param name="ParentNode" select="$ParentNode"/>
 </xsl:call-template>

 <xsl:if test="not ($PartObj='1')">
  <xsl:element name="COMPRESS">
   <xsl:choose>
    <xsl:when test="($ParentNode/STORAGE/FLAGS mod 4096)>=2048">Y</xsl:when>
    <xsl:otherwise>N</xsl:otherwise>
   </xsl:choose>
  </xsl:element>
 </xsl:if>

 <xsl:element name="LOGGING">
   <xsl:choose>
     <xsl:when test="$PartObj='1'">
       <!-- No Logging is bit 0x04 in FLAGS=1 (in tabpart$) -->
       <xsl:choose>
         <xsl:when test="($ParentNode/FLAGS mod 8)>=4">N</xsl:when>
         <xsl:otherwise>Y</xsl:otherwise>
       </xsl:choose>
     </xsl:when>
     <xsl:otherwise>
      <xsl:choose>
       <xsl:when test="($ParentNode/FLAGS mod 64)>=32">N</xsl:when>
       <xsl:otherwise>Y</xsl:otherwise>
      </xsl:choose>
     </xsl:otherwise>
   </xsl:choose>
 </xsl:element>

 <xsl:call-template name="DoTablespace">
  <xsl:with-param name="ParentNode" select="$ParentNode"/>
 </xsl:call-template>
 <xsl:call-template name="DoStorage">
  <xsl:with-param name="ParentNode" select="$ParentNode/STORAGE"/>
  <xsl:with-param name="BlkSize" select="$ParentNode/BLOCKSIZE"/>
 </xsl:call-template>
 </SEGMENT_ATTRIBUTES>
</xsl:template>

<xsl:template name="DoPCT">
 <xsl:param name="ParentNode" select="''"/>
 <xsl:param name="ADT_type">TABLE</xsl:param>
<xsl:if test="$IGNORE_PHYSICAL_ATTS=0">
 <PCTFREE>
  <xsl:value-of select="$ParentNode/PCT_FREE"/>
 </PCTFREE>
 <xsl:if test="not($ADT_type='INDEX')">
  <PCTUSED>
   <xsl:value-of select="$ParentNode/PCT_USED"/>
  </PCTUSED>
 </xsl:if>
 <INITRANS>
  <xsl:value-of select="$ParentNode/INITRANS"/>
 </INITRANS>
 <MAXTRANS>
  <xsl:value-of select="$ParentNode/MAXTRANS"/>
 </MAXTRANS>
</xsl:if>
</xsl:template>

<xsl:template name="DoTablespace">
 <xsl:param name="ParentNode" select="''"/>
<xsl:if test="$IGNORE_TABLESPACE=0">
 <TABLESPACE>
  <xsl:if test="string-length($ParentNode/TS_NAME)!=0">
   <xsl:value-of select="$ParentNode/TS_NAME"/>
  </xsl:if>
  <xsl:if test="string-length($ParentNode/DEFTS_NAME)!=0">
   <xsl:value-of select="$ParentNode/DEFTS_NAME"/>
  </xsl:if>
 </TABLESPACE>
</xsl:if>
</xsl:template>

<xsl:template name="DoStorage">
 <xsl:param name="BlkSize"/> 
 <xsl:param name="ParentNode" select="''"/>
<xsl:if test="$IGNORE_PHYSICAL_ATTS=0">
 <STORAGE>
  <xsl:if test="$ParentNode/DEFINIEXTS or $ParentNode/INIEXTS or $ParentNode/DFLINIT">
   <INITIAL>
    <xsl:choose>
     <xsl:when test="$ParentNode/INIEXTS">
      <xsl:value-of select="($ParentNode/INIEXTS)*$BlkSize"/>
     </xsl:when>
     <xsl:when test="$ParentNode/DFLINIT">     
      <xsl:value-of select="($ParentNode/DFLINIT)*$BlkSize"/>
     </xsl:when>
     <xsl:when test="$ParentNode/DEFINIEXTS">     
      <xsl:value-of select="($ParentNode/DEFINIEXTS)*$BlkSize"/>
     </xsl:when>
    </xsl:choose>
   </INITIAL>
  </xsl:if>
  <xsl:if test="$ParentNode/DEFEXTSIZE or $ParentNode/EXTSIZE or $ParentNode/DFLINCR">
   <NEXT>
    <xsl:choose>
      <xsl:when test="$ParentNode/EXTSIZE">
      <xsl:value-of select="($ParentNode/EXTSIZE)*$BlkSize"/>
     </xsl:when>
     <xsl:when test="$ParentNode/DEFEXTSIZE">
      <xsl:value-of select="($ParentNode/DEFEXTSIZE)*$BlkSize"/>
     </xsl:when>
     <xsl:when test="$ParentNode/DFLINCR">     
      <xsl:value-of select="($ParentNode/DFLINCR)*$BlkSize"/>
     </xsl:when>
    </xsl:choose>
   </NEXT>
  </xsl:if>
  <xsl:if test="$ParentNode/DEFMINEXTS or $ParentNode/MINEXTS or $ParentNode/DFLMINEXT">
   <MINEXTENTS>
    <xsl:value-of select="$ParentNode/MINEXTS"/>
    <xsl:value-of select="$ParentNode/DFLMINEXT"/>
    <xsl:value-of select="$ParentNode/DEFMINEXTS"/>
   </MINEXTENTS>
  </xsl:if>
  <xsl:if test="$ParentNode/DEFMAXEXTS or $ParentNode/MAXEXTS or $ParentNode/DFLMAXEXT">
   <MAXEXTENTS>
    <xsl:value-of select="$ParentNode/MAXEXTS"/>
    <xsl:value-of select="$ParentNode/DFLMAXEXT"/>
    <xsl:value-of select="$ParentNode/DEFMAXEXTS"/>
   </MAXEXTENTS>
  </xsl:if>
  <xsl:if test="$ParentNode/DEFEXTPCT or $ParentNode/EXTPCT or $ParentNode/DFLEXTPCT">
   <PCTINCREASE>
    <xsl:value-of select="$ParentNode/EXTPCT"/>
    <xsl:value-of select="$ParentNode/DFLEXTPCT"/>
    <xsl:value-of select="$ParentNode/DEFEXTPCT"/>
   </PCTINCREASE>
  </xsl:if>
  <xsl:if test="$ParentNode/DEFLISTS > 0 or $ParentNode/LISTS">
   <FREELISTS>
    <xsl:value-of select="$ParentNode/LISTS"/>
    <xsl:value-of select="$ParentNode/DEFLISTS"/>
   </FREELISTS>
  </xsl:if>
  <xsl:if test="$ParentNode/DEFGROUPS > 0 or $ParentNode/GROUPS">
   <FREELIST_GROUPS>
    <xsl:value-of select="$ParentNode/GROUPS"/>
   </FREELIST_GROUPS>
  </xsl:if>
 <xsl:if test="$ParentNode/CACHEHINT or $ParentNode/DEFBUFPOOL">
  <BUFFER_POOL>
  <xsl:if test="$ParentNode/CACHEHINT">
   <xsl:choose>
    <xsl:when test='$ParentNode/CACHEHINT=0'>DEFAULT</xsl:when>
    <xsl:when test='$ParentNode/CACHEHINT=1'>KEEP</xsl:when>
    <xsl:when test='$ParentNode/CACHEHINT=2'>RECYCLE</xsl:when>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="$ParentNode/DEFBUFPOOL">
   <xsl:choose>
    <xsl:when test='$ParentNode/DEFBUFPOOL=0'>DEFAULT</xsl:when>
    <xsl:when test='$ParentNode/DEFBUFPOOL=1'>KEEP</xsl:when>
    <xsl:when test='$ParentNode/DEFBUFPOOL=2'>RECYCLE</xsl:when>
   </xsl:choose>
  </xsl:if>
  </BUFFER_POOL>
  <xsl:if test="$ParentNode/OPTIMAL">
    <OPTIMAL>
      <xsl:value-of select="$ParentNode/OPTIMAL"/>
    </OPTIMAL>
 </xsl:if>
 </xsl:if>
 </STORAGE>
</xsl:if>
</xsl:template>

<!-- CACHE, MONITORING, PARALLEL -->

<!-- MONITORING for table is deprecated from 10g -->

<xsl:template name="DoParallel">
 <xsl:param name="ADT_type">TABLE</xsl:param>
 <xsl:param name="FlagsParent" select="''"/>
 <xsl:param name="SetParallel">-1</xsl:param>

 <xsl:if test="not($ADT_type='INDEX')">
  <xsl:if test="($FlagsParent/FLAGS mod 16)>=8">
   <xsl:element name="CACHE">
    <xsl:text>Y</xsl:text>
   </xsl:element>
  </xsl:if>
  <xsl:if test="($FlagsParent/FLAGS mod 4194304)>=2097152">
    <!-- See bug: 4196008.  Do not compare deprecated attr unless both on 9.x -->
    <xsl:if test="(not($ADT_type='TABLE') or $USAGE!=1 or ($L_VERSION=9 and $R_VERSION=9))">
       <MONITORING>
         <xsl:text>Y</xsl:text>
       </MONITORING>
    </xsl:if>
   </xsl:if>
 </xsl:if>

 <xsl:choose>
  <xsl:when test="0>$SetParallel">
   <xsl:if test="$FlagsParent/DEGREE">
    <xsl:element name="PARALLEL">
    <xsl:choose>

     <!-- old syntax: PARALLEL (DEGREE n INSTANCES m) -->
     <xsl:when test="32767>$FlagsParent/INSTANCES">
      <xsl:choose>
       <xsl:when test="$FlagsParent/DEGREE=32767">
        <xsl:text>DEFAULT</xsl:text>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="$FlagsParent/DEGREE"/>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>

     <!-- new syntax PARALLEL [n] -->
     <xsl:otherwise>
      <xsl:if test="32767>$FlagsParent/DEGREE">
       <xsl:value-of select="$FlagsParent/DEGREE"/>
      </xsl:if>
     </xsl:otherwise>

    </xsl:choose>
    </xsl:element>

    <!-- old syntax: PARALLEL (DEGREE n INSTANCES m) -->
    <xsl:if test="32767>$FlagsParent/INSTANCES">
     <xsl:element name="INSTANCE">
     <xsl:choose>
       <xsl:when
	      test="$FlagsParent/INSTANCES=32767">
        <xsl:text>DEFAULT</xsl:text>
       </xsl:when>
       <xsl:when test="32767>$FlagsParent/INSTANCES">
        <xsl:value-of select="$FlagsParent/INSTANCES"/>
       </xsl:when>
      </xsl:choose>
     </xsl:element>
    </xsl:if>

   </xsl:if>
  </xsl:when>

  <!-- user-specified value -->
  <xsl:otherwise>
   <xsl:element name="PARALLEL">
   <xsl:choose>
    <xsl:when test="$SetParallel=0">
     <xsl:text>N</xsl:text>
    </xsl:when>
    <xsl:when test="$SetParallel>32767">
     <xsl:text>Y</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="$SetParallel"/>
    </xsl:otherwise>
   </xsl:choose>
   </xsl:element>
  </xsl:otherwise>
 </xsl:choose>

</xsl:template>

</xsl:stylesheet>
