<?xml version="1.0" ?>
<!--
NAME
    cmkuprtobj.xsl
DESCRIPTION
    XSLT stylesheet for XML => CMXML conversion of Partition ADTs

MODIFIED        MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    xshen       07/14/05 - ignore high value changes 
    xshen       07/08/05 - partition logging attribute 
    xshen       06/13/05 - fixing partcols & add hashpart ts list
    xshen       09/22/04 - add compare options
    xshen       08/06/04 - support part status for index in accessor mode 
    xshen       08/04/04 - local composite partitioning 
    xshen       08/04/04 - support local partition 
    xshen       08/03/04 - support index partition, parameterize part templates 
    xshen       07/29/04 - support partition iot overflow 
    xshen       07/26/04 - add hiboundval to compartition 
    lhan        07/15/04 - lhan_xsl_0715
    lhan        07/15/04 - lhan_xsl_0715
    lhan        07/15/04 - initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:param name="IGNORE_HIGH_VALUES">0</xsl:param>

<!-- Parameterized Templates                         -->

<!-- ADT_type INDEX is always passed explicitly      -->
<!-- TABLE type is assumed if not INDEX              -->
<!--
    Parttype -	1 = range
                2 = hash                
                4 = list
    Local    -  1 = local partitioned index                 
  -->
<xsl:template name="DoPartLists">
 <xsl:param name="ADT_type">TABLE</xsl:param>
 <xsl:param name="ParentNode" select="''"/>
 <xsl:param name="Parttype">0</xsl:param>
 <xsl:param name="Local">0</xsl:param>
   <xsl:if test="$ADT_type='INDEX' and $Parttype=2"> <!-- local hash -->
     <xsl:call-template name="GetHashPartTSList">
       <xsl:with-param name="PartList" select="$ParentNode/PART_LIST"/>
     </xsl:call-template>   
   </xsl:if>
   <xsl:apply-templates select="$ParentNode/PART_LIST">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="Parttype" select="$Parttype"/>
    <xsl:with-param name="Local" select="$Local"/>
   </xsl:apply-templates>   
</xsl:template>

<xsl:template match="PARTCOLS | SUBPARTCOLS">
 <PARTCOLS>
   <xsl:for-each select="PARTCOLS_ITEM | SUBPARTCOLS_ITEM">
     <PARTCOLS_ITEM>
       <NAME>
        <xsl:value-of select="COL/NAME"/>
       </NAME>
     </PARTCOLS_ITEM>
   </xsl:for-each>
 </PARTCOLS>
</xsl:template>

<xsl:template match="PARTOBJ | TABPARTOBJ">
  <xsl:if test="$IGNORE_PHYSICAL_ATTS=0">
     <DEFAULT_PHYSICAL_PROPERTIES>
      <PCTFREE>
       <xsl:value-of select="DEFPCTFREE"/>
      </PCTFREE>
      <PCTUSED>
       <xsl:value-of select="DEFPCTUSED"/>
      </PCTUSED>
      <INITRANS>
       <xsl:value-of select="DEFINITRANS"/>
      </INITRANS>
    <xsl:if test="$IGNORE_TABLESPACE=0">
      <TABLESPACE>
       <xsl:value-of select="DEFTS_NAME"/>
      </TABLESPACE>
    </xsl:if>
     </DEFAULT_PHYSICAL_PROPERTIES>
   </xsl:if>
</xsl:template>

<xsl:template match="PART_LIST">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="Parttype">1</xsl:param>
  <xsl:param name="Local">0</xsl:param>
     <PART_LIST>
      <xsl:for-each select="PART_LIST_ITEM">
       <PART_LIST_ITEM>
        <NAME>
         <xsl:value-of select="SCHEMA_OBJ/SUBNAME"/>
        </NAME>
        <xsl:choose>
        <!-- global hash partitioned index -->
         <xsl:when test="($ADT_type='INDEX' and $Parttype=2 and $Local!=1)"> 
           <xsl:call-template name="DoTablespace">
             <xsl:with-param name="ParentNode" select="."/>
           </xsl:call-template>          
         </xsl:when>
         <xsl:otherwise> 
          <xsl:if test="(HIBOUNDVAL and $IGNORE_HIGH_VALUES=0)">
            <HIBOUNDVAL>
              <xsl:value-of select="HIBOUNDVAL"/>
            </HIBOUNDVAL>          
          </xsl:if>
          <xsl:call-template name="DoSegmentAttributes">
            <xsl:with-param name="ParentNode" select="."/>
            <xsl:with-param name="PartObj" select="1"/>
          </xsl:call-template> 
         </xsl:otherwise>
        </xsl:choose>
        <!-- Index Partition Status: accessors only -->
        <xsl:if test="$ADT_type='INDEX' and SCHEMA_OBJ/FLAGS">
          <xsl:call-template name="DoPartStatus">
            <xsl:with-param name="ParentNode" select="."/>
          </xsl:call-template>
        </xsl:if>
        <!-- PIOT OVERFLOW -->
        <xsl:if test="not($ADT_type='INDEX')">
         <xsl:call-template name="DoIOVList">
          <xsl:with-param name="List" select="../../IOV_LIST"/>
          <xsl:with-param name="PNUM" select="PART_NUM"/>
         </xsl:call-template>
        </xsl:if> 
       </PART_LIST_ITEM>
      </xsl:for-each>
     </PART_LIST>
</xsl:template>

<xsl:template match="SUBPARTS">
     <SUBPARTITION_LIST>
      <xsl:for-each select="SUBPARTS_ITEM">
       <SUBPARTITION_LIST_ITEM>
        <NAME>
         <xsl:value-of select="SCHEMA_OBJ/SUBNAME"/>
        </NAME>
        <xsl:if test="(HIBOUNDVAL and $IGNORE_HIGH_VALUES=0)">
         <HIBOUNDVAL>
          <xsl:value-of select="HIBOUNDVAL"/>
         </HIBOUNDVAL>          
        </xsl:if>
        <xsl:call-template name="DoSegmentAttributes">
         <xsl:with-param name="ParentNode" select="."/>
         <xsl:with-param name="PartObj" select="1"/>
        </xsl:call-template>       
       </SUBPARTITION_LIST_ITEM>
      </xsl:for-each>
     </SUBPARTITION_LIST>
</xsl:template>

<xsl:template match="COMPART_LIST">
 <xsl:param name="ADT_type">TABLE</xsl:param>
 <xsl:param name="Sub_type"></xsl:param>
 <COMPARTITION_LIST>
  <xsl:for-each select="COMPART_LIST_ITEM">
   <COMPARTITION_LIST_ITEM>
    <NAME>
     <xsl:value-of select="SCHEMA_OBJ/SUBNAME"/>
    </NAME>
    <xsl:if test="(HIBOUNDVAL and $IGNORE_HIGH_VALUES=0)">
      <HIBOUNDVAL>
        <xsl:value-of select="HIBOUNDVAL"/>
      </HIBOUNDVAL>          
    </xsl:if>
    <!-- Index Partition Status: accessors only -->
    <xsl:if test="$ADT_type='INDEX' and SCHEMA_OBJ/FLAGS">
      <xsl:call-template name="DoPartStatus">
        <xsl:with-param name="ParentNode" select="."/>
      </xsl:call-template>
    </xsl:if>    
    <SUBPARTITION_TEMPLATE>
     <SUBPARTITION_COUNT>
      <xsl:value-of select="SUBPARTCNT"/>
     </SUBPARTITION_COUNT>
     <!-- Hash Subpartitioning: HASHSUBPARTTS_LIST -->
     <xsl:if test="$Sub_type='HASH'">
       <xsl:call-template name="GetHashSubPartTSList">
         <xsl:with-param name="SubParts" select="SUBPARTS"/>
       </xsl:call-template>
     </xsl:if>
     <xsl:apply-templates select = "SUBPARTS"/>       
    </SUBPARTITION_TEMPLATE>
   </COMPARTITION_LIST_ITEM>
  </xsl:for-each>
</COMPARTITION_LIST>
</xsl:template>

<!-- PIOTs -->

<xsl:template name="DoPIOTSegAttrs">
 <xsl:param name="ParentNode" select="''"/>
  <SEGMENT_ATTRIBUTES>
    <PCTFREE>
      <xsl:value-of select="$ParentNode/DEFPCTFREE"/>
    </PCTFREE>
    <xsl:element name="LOGGING">
      <xsl:choose>
       <xsl:when test="($ParentNode/DEFLOGGING)=0">N</xsl:when>
       <xsl:otherwise>Y</xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  <xsl:if test="$IGNORE_TABLESPACE=0">
    <TABLESPACE>
      <xsl:value-of select="$ParentNode/DEFTS_NAME"/>
    </TABLESPACE>
  </xsl:if>
  </SEGMENT_ATTRIBUTES>
</xsl:template>

<!-- PIOT OVERFLOW -->

<xsl:template name="DoIOVList">
 <xsl:param name="List" select="''"/>
 <xsl:param name="PNUM">0</xsl:param>
  <xsl:if test="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]">
   <OVERFLOW>
     <xsl:call-template name="DoSegmentAttributes">
       <xsl:with-param name="ParentNode" select="$List/IOV_LIST_ITEM[PART_NUM=$PNUM]"/>
     </xsl:call-template>
   </OVERFLOW>
  </xsl:if>
</xsl:template>

<!-- Part Status: Index accessors -->
<xsl:template name="DoPartStatus">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:if test="$USAGE=2">
    <xsl:element name="STATUS">
      <xsl:choose>
        <xsl:when test="($ParentNode/SCHEMA_OBJ/FLAGS mod 2)=1">
          <xsl:text>UNUSABLE</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>USABLE</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:if>
</xsl:template>

<xsl:template name="GetHashPartTSList">
  <xsl:param name="PartList" select="''"/>
  <HASHPARTTS_LIST>
   <xsl:for-each select="$PartList/PART_LIST_ITEM">
    <!-- xsl:sort select="TS_NAME"/ -->
    <xsl:if test="position()!=1">
      <xsl:text>,</xsl:text>
    </xsl:if>
    <xsl:value-of select="current()/TS_NAME"/>
    <xsl:if test="position()=last()">
      <xsl:text></xsl:text>
    </xsl:if>
   </xsl:for-each>
  </HASHPARTTS_LIST>
</xsl:template>

<!-- ts_name only exist in hash part list item -->
<xsl:template name="GetHashSubPartTSList">
  <xsl:param name="SubParts" select="''"/>
  <HASHSUBPARTTS_LIST>
   <xsl:for-each select="$SubParts/SUBPARTS_ITEM">
    <!-- xsl:sort select="TS_NAME"/ -->
    <xsl:if test="position()!=1">
      <xsl:text>,</xsl:text>
    </xsl:if>
    <xsl:value-of select="current()/TS_NAME"/>
    <xsl:if test="position()=last()">
      <xsl:text></xsl:text>
    </xsl:if>
   </xsl:for-each>
 </HASHSUBPARTTS_LIST>
</xsl:template>

</xsl:stylesheet>
