<?xml version="1.0" encoding="utf-8"?>
<!-- 
NAME
    cmkucommon.xsl
DESCRIPTION
    Templates for common and utility functions of CM xslt
NOTES

MODIFIED	MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    xshen       05/16/05 - adding ignore partition param 
    xshen       03/08/05 - changing MAPPED_SCHEMA 
    xshen       03/08/05 - add schema mapping to base obj template 
    xshen       02/23/05 - adding versions 
    xshen       09/22/04 - add compare option parameters
    xshen       09/20/04 - add encrypted password template
    xshen       08/04/04 - support diff/accessor mode 
    lhan        08/02/04 - more support for index
    lhan        07/30/04 - Trim string
    xshen       07/20/04 - add parameter 
    lhan        07/13/04 - add more common templates
    xshen       07/10/04 - xshen_changemgr_differ
    xshen	07/09/04 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Begin: Top-level parameters -->

<xsl:param name="SCHEMA_MAP">0</xsl:param>
<xsl:param name="UNAVAILABLE">UNAVAILABLE</xsl:param>

<!-- Adding versions: See bug 4196008 -->
<xsl:param name="L_VERSION">0</xsl:param>
<xsl:param name="R_VERSION">0</xsl:param>

<!-- Adding left and right schemas for schema mapping -->
<xsl:param name="L_SCHEMA" select="''"/>
<xsl:param name="R_SCHEMA" select="''"/>

<!-- Compare Options -->
<!-- 
     Ignore Physical Attributes: 
     Differ   - 0 or 1
     Accessor - 0
     Default  - 0 
-->
<xsl:param name="IGNORE_PARTITION">0</xsl:param>

<!-- 
     Ignore Physical Attributes: 
     Differ   - 0 or 1
     Accessor - 0
     Default  - 0 
-->
<xsl:param name="IGNORE_PHYSICAL_ATTS">0</xsl:param>

<!-- 
     Ignore Tablespace: 
     Differ   - 0 or 1
     Accessor - 0
     Default  - 0
-->
<xsl:param name="IGNORE_TABLESPACE">0</xsl:param>

<!--
     Usage is a mode parameter indicating where the transformation
     occurrs.  In Change Manager there are currently 2 modes.
     This parameter should be used in the following scenario: 
     An attribute is required by EITHER mode but NOT BOTH.
     
     If an attribute is required by a mode only in SOME circumstances, 
     then define a distinct parameter rather than using the usage
     parameter.
     
     E.g., INCLUDE_STATISTICS (table) can be turned on/off for differ 
     based on comparison option, but is always turned on for accessor.  
     local index partition columns should always be turned off for 
     differ but on for accessor - the 2nd example uses the USAGE param.
     
     1 - Differ   (CMXML comparison)
     2 - Accessor (XML - EMO conversion)
     Default - 1          
 -->
<xsl:param name="USAGE">1</xsl:param>
<!-- End: Top-level parameters -->

<!-- schema object name -->
<xsl:template match="SCHEMA_OBJ | BASE_OBJ | IMPL_OBJ | OPER_OBJ | STATS_OBJ
  | BASETYPE_OBJ | ARRAYTYPE_OBJ">
  <xsl:call-template name="DoSchemaWithMapping">
    <xsl:with-param name="CurrentSchema" select="OWNER_NAME"/>
  </xsl:call-template>
  <NAME>
   <xsl:value-of select="NAME"/>
  </NAME>
</xsl:template>

<xsl:template name="Trim_string">
 <xsl:param name="String"/>
  <xsl:choose>
   <xsl:when test="substring($String,string-length($String),1)=' '">
    <xsl:value-of select="substring($String,1,string-length($String)-1)"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$String"/>
   </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="ColNameOrAttr">
 <xsl:param name="ColItem">0</xsl:param>
  <!-- use ATTRNAME if it exists, otherwise NAME
       (The old test was "1>($ColItem/PROPERTY mod 2)" -->
  <xsl:choose>
   <xsl:when test="$ColItem/ATTRNAME">
    <xsl:value-of select="$ColItem/ATTRNAME"/>  <!-- already in quotes -->
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$ColItem/NAME"/>
   </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="PASSWORD">
  <xsl:choose>
    <xsl:when test=".='EXTERNAL' or .='GLOBAL'">
      <PASSWORD> 
        <xsl:value-of select="."/>
      </PASSWORD>
    </xsl:when>
    <xsl:otherwise>
      <PASSWORD ENCRYPTED="TRUE"> 
        <!-- Adding encrypted so we can hide encrypted value if they diff-ed -->
        <xsl:value-of select="."/>
      </PASSWORD>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Do Schema with mapping -->
<xsl:template name="DoSchemaWithMapping">
  <xsl:param name="CurrentSchema" select="''"/>
   <SCHEMA>
     <xsl:choose>
       <xsl:when test="$SCHEMA_MAP=1 and not($CurrentSchema='') and ($CurrentSchema=$R_SCHEMA)">
         <xsl:value-of select="$L_SCHEMA"/>
       </xsl:when>
       <xsl:otherwise>
         <xsl:value-of select="$CurrentSchema"/>
       </xsl:otherwise>
     </xsl:choose>
   </SCHEMA>
</xsl:template>

</xsl:stylesheet>



